/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.NullAppender;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;

public class LoggerOutput
implements TestRule {
    private NullAppender logAppender;
    private ArgumentCaptor<LogEvent> logEventCaptor;
    private final List<Consumer<List<LoggingEvent>>> logEventExpectations = new ArrayList<Consumer<List<LoggingEvent>>>();

    public void expect(Consumer<List<LoggingEvent>> expectation) {
        if (this.logEventCaptor == null) {
            this.logEventCaptor = ArgumentCaptor.forClass(LogEvent.class);
        }
        this.logEventExpectations.add(expectation);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
                LoggerOutput.this.logAppender = (NullAppender)Mockito.spy((Object)NullAppender.createAppender((String)UUID.randomUUID().toString()));
                LoggerOutput.this.logAppender.start();
                lc.getConfiguration().addAppender((Appender)LoggerOutput.this.logAppender);
                lc.getRootLogger().addAppender(lc.getConfiguration().getAppender(LoggerOutput.this.logAppender.getName()));
                lc.updateLoggers();
                try {
                    base.evaluate();
                    if (!LoggerOutput.this.logEventExpectations.isEmpty()) {
                        ((NullAppender)Mockito.verify((Object)LoggerOutput.this.logAppender, (VerificationMode)Mockito.atLeastOnce())).append((LogEvent)LoggerOutput.this.logEventCaptor.capture());
                        List logEvents = LoggerOutput.this.logEventCaptor.getAllValues().stream().map(x$0 -> LoggerOutput.toSlf4j(x$0)).collect(Collectors.toList());
                        for (Consumer expectation : LoggerOutput.this.logEventExpectations) {
                            expectation.accept(logEvents);
                        }
                    }
                }
                finally {
                    lc.getRootLogger().removeAppender(lc.getConfiguration().getAppender(LoggerOutput.this.logAppender.getName()));
                    lc.updateLoggers();
                    LoggerOutput.this.logEventExpectations.clear();
                    LoggerOutput.this.logEventCaptor = null;
                }
            }
        };
    }

    private static LoggingEvent toSlf4j(final LogEvent log4jEvent) {
        return new LoggingEvent(){

            public Level getLevel() {
                switch (log4jEvent.getLevel().toString()) {
                    case "FATAL": 
                    case "ERROR": {
                        return Level.ERROR;
                    }
                    case "WARN": {
                        return Level.WARN;
                    }
                    case "INFO": {
                        return Level.INFO;
                    }
                    case "DEBUG": {
                        return Level.DEBUG;
                    }
                }
                return Level.TRACE;
            }

            public Marker getMarker() {
                return null;
            }

            public String getLoggerName() {
                return log4jEvent.getLoggerName();
            }

            public String getMessage() {
                return log4jEvent.getMessage().getFormattedMessage();
            }

            public String getThreadName() {
                return log4jEvent.getThreadName();
            }

            public Object[] getArgumentArray() {
                return new Object[0];
            }

            public long getTimeStamp() {
                return log4jEvent.getTimeMillis();
            }

            public Throwable getThrowable() {
                return null;
            }
        };
    }
}

