/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.IOException;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperTestClient;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.zookeeper.KeeperException;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalSetTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalSetTest.class);
    byte[] entry;
    private final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    BookKeeper bkcReader;

    public ConditionalSetTest() {
        super(3);
    }

    @Override
    @Before
    public void setUp() throws IOException, Exception {
        super.setUp();
        this.entry = new byte[10];
        this.bkcReader = new BookKeeperTestClient(this.baseClientConf);
    }

    @Test
    public void testConditionalSet() throws IOException, InterruptedException, BKException, KeeperException {
        LedgerHandle lhWrite = this.bkc.createLedger(this.digestType, new byte[]{97, 98});
        long ledgerId = lhWrite.getId();
        LOG.debug("Ledger ID: " + lhWrite.getId());
        for (int i = 0; i < 10; ++i) {
            LOG.debug("Adding entry: " + i);
            lhWrite.addEntry(this.entry);
        }
        LOG.debug("Instantiating new bookkeeper client.");
        LedgerHandle lhRead = this.bkcReader.openLedger(lhWrite.getId(), this.digestType, new byte[]{97, 98});
        LOG.debug("Opened the ledger already");
        lhWrite.close();
    }
}

