/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bookkeeper.bookie.BookieResources;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.server.http.service.ListLedgerService;
import org.apache.bookkeeper.shaded.com.google.common.collect.ImmutableMap;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.commons.lang3.RandomUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ListLedgerServiceTest
extends BookKeeperClusterTestCase {
    private final ObjectMapper mapper = new ObjectMapper();
    private ListLedgerService listLedgerService;

    public ListLedgerServiceTest() {
        super(1);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        TestStatsProvider provider = new TestStatsProvider();
        this.listLedgerService = new ListLedgerService(this.confByIndex(0), BookieResources.createMetadataDriver((ServerConfiguration)this.confByIndex(0), (StatsLogger)provider.getStatsLogger("")).getLedgerManagerFactory());
    }

    @Test
    public void testEmptyList() throws Exception {
        HttpServiceResponse response = this.listLedgerService.handle(new HttpServiceRequest());
        Assert.assertEquals((long)response.getStatusCode(), (long)HttpServer.StatusCode.OK.getValue());
        JsonNode json = this.mapper.readTree(response.getBody());
        Assert.assertEquals((long)0L, (long)json.size());
    }

    @Test
    public void testListLedgers() throws Exception {
        int ledgerNum = RandomUtils.nextInt((int)1, (int)10);
        HashMap<Long, LedgerMetadata> ledgers = new HashMap<Long, LedgerMetadata>();
        for (int i = 0; i < ledgerNum; ++i) {
            LedgerHandle ledger = this.bkc.createLedger(1, 1, 1, BookKeeper.DigestType.CRC32, new byte[0]);
            ledgers.put(ledger.getId(), ledger.getLedgerMetadata());
            ledger.close();
        }
        HttpServiceResponse response = this.listLedgerService.handle(new HttpServiceRequest());
        Assert.assertEquals((long)response.getStatusCode(), (long)HttpServer.StatusCode.OK.getValue());
        JsonNode json = this.mapper.readTree(response.getBody());
        Assert.assertEquals((long)ledgerNum, (long)json.size());
        json.fieldNames().forEachRemaining(field -> {
            Assert.assertTrue((boolean)ledgers.containsKey(Long.parseLong(field)));
            Assert.assertTrue((boolean)json.get(field).isNull());
        });
    }

    @Test
    public void testListLedgersWithMetadata() throws Exception {
        int ledgerNum = RandomUtils.nextInt((int)1, (int)10);
        HashMap<Long, LedgerMetadata> ledgers = new HashMap<Long, LedgerMetadata>();
        for (int i = 0; i < ledgerNum; ++i) {
            LedgerHandle ledger = this.bkc.createLedger(1, 1, 1, BookKeeper.DigestType.CRC32, new byte[0]);
            ledger.close();
            ledgers.put(ledger.getId(), ledger.getLedgerMetadata());
        }
        HttpServiceResponse response = this.listLedgerService.handle(new HttpServiceRequest(null, HttpServer.Method.GET, (Map)ImmutableMap.of((Object)"print_metadata", (Object)"true")));
        Assert.assertEquals((long)response.getStatusCode(), (long)HttpServer.StatusCode.OK.getValue());
        JsonNode json = this.mapper.readTree(response.getBody());
        Assert.assertEquals((long)ledgerNum, (long)json.size());
        json.fieldNames().forEachRemaining(field -> {
            LedgerMetadata meta = (LedgerMetadata)ledgers.get(Long.parseLong(field));
            Assert.assertNotNull((Object)meta);
            Assert.assertFalse((boolean)json.get(field).isNull());
        });
    }

    @Test
    public void testListLedgersWithMetadataDecoded() throws Exception {
        int ledgerNum = RandomUtils.nextInt((int)1, (int)10);
        HashMap<Long, LedgerMetadata> ledgers = new HashMap<Long, LedgerMetadata>();
        for (int i = 0; i < ledgerNum; ++i) {
            LedgerHandle ledger = this.bkc.createLedger(1, 1, 1, BookKeeper.DigestType.CRC32, new byte[0], (Map)ImmutableMap.of((Object)"test_key", (Object)"test_value".getBytes()));
            ledger.close();
            ledgers.put(ledger.getId(), ledger.getLedgerMetadata());
        }
        HttpServiceResponse response = this.listLedgerService.handle(new HttpServiceRequest(null, HttpServer.Method.GET, (Map)ImmutableMap.of((Object)"print_metadata", (Object)"true", (Object)"decode_meta", (Object)"true")));
        Assert.assertEquals((long)response.getStatusCode(), (long)HttpServer.StatusCode.OK.getValue());
        JsonNode json = this.mapper.readTree(response.getBody());
        Assert.assertEquals((long)ledgerNum, (long)json.size());
        json.fieldNames().forEachRemaining(field -> {
            LedgerMetadata meta = (LedgerMetadata)ledgers.get(Long.parseLong(field));
            Assert.assertNotNull((Object)meta);
            JsonNode node = json.get(field);
            Assert.assertEquals((long)meta.getMetadataFormatVersion(), (long)node.get("metadataFormatVersion").asInt());
            Assert.assertEquals((long)meta.getEnsembleSize(), (long)node.get("ensembleSize").asInt());
            Assert.assertEquals((long)meta.getWriteQuorumSize(), (long)node.get("writeQuorumSize").asInt());
            Assert.assertEquals((long)meta.getAckQuorumSize(), (long)node.get("ackQuorumSize").asInt());
            Assert.assertEquals((long)meta.getCToken(), (long)node.get("ctoken").asLong());
            Assert.assertEquals((Object)meta.getState().name(), (Object)node.get("state").asText());
            Assert.assertEquals((Object)meta.isClosed(), (Object)node.get("closed").asBoolean());
            Assert.assertEquals((long)meta.getLength(), (long)node.get("length").asLong());
            Assert.assertEquals((long)meta.getLastEntryId(), (long)node.get("lastEntryId").asLong());
            Assert.assertEquals((Object)meta.getDigestType().name(), (Object)node.get("digestType").asText());
            Assert.assertEquals((Object)new String(meta.getPassword()), (Object)node.get("password").asText());
            for (Map.Entry entry : meta.getCustomMetadata().entrySet()) {
                JsonNode data = node.get("customMetadata").get((String)entry.getKey());
                Assert.assertArrayEquals((byte[])((byte[])entry.getValue()), (byte[])Base64.getDecoder().decode(data.asText()));
            }
            for (Map.Entry entry : meta.getAllEnsembles().entrySet()) {
                JsonNode members = node.get("allEnsembles").get(String.valueOf(entry.getKey()));
                Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
                Assert.assertEquals((long)((List)entry.getValue()).size(), (long)members.size());
                JsonNode member = members.get(0);
                Assert.assertEquals((Object)((BookieId)((List)entry.getValue()).get(0)).getId(), (Object)member.get("id").asText());
            }
        });
    }
}

