/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.server.http.service.AutoRecoveryStatusService;
import org.apache.bookkeeper.shaded.com.google.common.collect.ImmutableMap;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AutoRecoveryStatusServiceTest
extends BookKeeperClusterTestCase {
    private final ObjectMapper mapper = new ObjectMapper();
    private AutoRecoveryStatusService autoRecoveryStatusService;

    public AutoRecoveryStatusServiceTest() {
        super(1);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.autoRecoveryStatusService = new AutoRecoveryStatusService(this.baseConf);
    }

    @Test
    public void testGetStatus() throws Exception {
        HttpServiceRequest request = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response = this.autoRecoveryStatusService.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response.getStatusCode());
        JsonNode json = this.mapper.readTree(response.getBody());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)json.get("enabled").asBoolean());
    }

    @Test
    public void testEnableStatus() throws Exception {
        ImmutableMap params = ImmutableMap.of((Object)"enabled", (Object)"true");
        HttpServiceRequest request = new HttpServiceRequest(null, HttpServer.Method.PUT, (Map)params);
        HttpServiceResponse response = this.autoRecoveryStatusService.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response.getStatusCode());
        JsonNode json = this.mapper.readTree(response.getBody());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)json.get("enabled").asBoolean());
        request = new HttpServiceRequest(null, HttpServer.Method.GET, (Map)params);
        response = this.autoRecoveryStatusService.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response.getStatusCode());
        json = this.mapper.readTree(response.getBody());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)json.get("enabled").asBoolean());
    }

    @Test
    public void testDisableStatus() throws Exception {
        ImmutableMap params = ImmutableMap.of((Object)"enabled", (Object)"false");
        HttpServiceRequest request = new HttpServiceRequest(null, HttpServer.Method.PUT, (Map)params);
        HttpServiceResponse response = this.autoRecoveryStatusService.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response.getStatusCode());
        JsonNode json = this.mapper.readTree(response.getBody());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)json.get("enabled").asBoolean());
        request = new HttpServiceRequest(null, HttpServer.Method.GET, (Map)params);
        response = this.autoRecoveryStatusService.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response.getStatusCode());
        json = this.mapper.readTree(response.getBody());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)json.get("enabled").asBoolean());
    }

    @Test
    public void testInvalidParams() throws Exception {
        ImmutableMap params = ImmutableMap.of((Object)"enable", (Object)"false");
        HttpServiceRequest request = new HttpServiceRequest(null, HttpServer.Method.PUT, (Map)params);
        HttpServiceResponse response = this.autoRecoveryStatusService.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.BAD_REQUEST.getValue(), (long)response.getStatusCode());
    }

    @Test
    public void testInvalidMethod() throws Exception {
        HttpServiceRequest request = new HttpServiceRequest(null, HttpServer.Method.POST, null);
        HttpServiceResponse response = this.autoRecoveryStatusService.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response.getStatusCode());
    }
}

