/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.util.HashedWheelTimer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.LongPollReadEntryProcessorV3;
import org.apache.bookkeeper.proto.RequestStats;
import org.apache.bookkeeper.shaded.com.google.protobuf.ByteString;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LongPollReadEntryProcessorV3Test {
    ExecutorService executor;
    HashedWheelTimer timer;

    @Before
    public void setup() {
        this.executor = Executors.newSingleThreadExecutor();
        this.timer = new HashedWheelTimer();
    }

    @After
    public void teardown() {
        this.timer.stop();
        this.executor.shutdownNow();
    }

    @Test
    public void testWatchIsCancelledOnTimeout() throws Exception {
        BookkeeperProtocol.Request request = BookkeeperProtocol.Request.newBuilder().setHeader(BookkeeperProtocol.BKPacketHeader.newBuilder().setTxnId(System.currentTimeMillis()).setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.READ_ENTRY).build()).setReadRequest(BookkeeperProtocol.ReadRequest.newBuilder().setLedgerId(10L).setEntryId(1L).setMasterKey(ByteString.copyFrom((byte[])new byte[0])).setPreviousLAC(0L).setTimeOut(1L).build()).build();
        Channel channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)channel.isOpen()).thenReturn((Object)true);
        Bookie bookie = (Bookie)Mockito.mock(Bookie.class);
        BookieRequestProcessor requestProcessor = (BookieRequestProcessor)Mockito.mock(BookieRequestProcessor.class);
        Mockito.when((Object)requestProcessor.getBookie()).thenReturn((Object)bookie);
        Mockito.when((Object)requestProcessor.getRequestStats()).thenReturn((Object)new RequestStats((StatsLogger)NullStatsLogger.INSTANCE));
        Mockito.when((Object)bookie.waitForLastAddConfirmedUpdate(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (Watcher)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)bookie.readEntry(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)Unpooled.buffer());
        Mockito.when((Object)bookie.readLastAddConfirmed(ArgumentMatchers.anyLong())).thenReturn((Object)1L);
        CompletableFuture cancelFuture = new CompletableFuture();
        ((Bookie)Mockito.doAnswer(invocationOnMock -> {
            cancelFuture.complete(null);
            return null;
        }).when((Object)bookie)).cancelWaitForLastAddConfirmedUpdate(ArgumentMatchers.anyLong(), (Watcher)ArgumentMatchers.any());
        LongPollReadEntryProcessorV3 processor = new LongPollReadEntryProcessorV3(request, channel, requestProcessor, this.executor, this.executor, this.timer);
        processor.run();
        cancelFuture.get(10L, TimeUnit.SECONDS);
    }
}

