/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.net;

import java.util.Set;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieNode;
import org.apache.bookkeeper.net.NetworkTopologyImpl;
import org.apache.bookkeeper.net.Node;
import org.junit.Assert;
import org.junit.Test;

public class NetworkTopologyImplTest {
    @Test
    public void getLeavesShouldReturnEmptySetForNonExistingScope() {
        NetworkTopologyImpl networkTopology = new NetworkTopologyImpl();
        Set leaves = networkTopology.getLeaves("/non-existing-scope");
        Assert.assertTrue((boolean)leaves.isEmpty());
    }

    @Test
    public void getLeavesShouldReturnNodesInScope() {
        NetworkTopologyImpl networkTopology = new NetworkTopologyImpl();
        String rack0Scope = "/rack-0";
        BookieId bookieIdScopeRack0 = BookieId.parse((String)"bookieIdScopeRack0");
        BookieNode bookieRack0ScopeNode = new BookieNode(bookieIdScopeRack0, rack0Scope);
        String rack1Scope = "/rack-1";
        BookieId bookieIdScopeRack1 = BookieId.parse((String)"bookieIdScopeRack1");
        BookieNode bookieRack1ScopeNode = new BookieNode(bookieIdScopeRack1, rack1Scope);
        networkTopology.add((Node)bookieRack0ScopeNode);
        networkTopology.add((Node)bookieRack1ScopeNode);
        Set leavesScopeRack0 = networkTopology.getLeaves(rack0Scope);
        Set leavesScopeRack1 = networkTopology.getLeaves(rack1Scope);
        Assert.assertTrue((leavesScopeRack0.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)leavesScopeRack0.contains(bookieRack0ScopeNode));
        Assert.assertTrue((leavesScopeRack1.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)leavesScopeRack1.contains(bookieRack1ScopeNode));
    }

    @Test
    public void testRestartBKWithNewRackDepth() {
        NetworkTopologyImpl networkTopology = new NetworkTopologyImpl();
        String dp1Rack = "/rack-1";
        String dp2Rack = "/dp/rack-1";
        BookieId bkId1 = BookieId.parse((String)"bookieIdScopeRack0");
        BookieId bkId2 = BookieId.parse((String)"bookieIdScopeRack1");
        BookieNode dp1BkNode1 = new BookieNode(bkId1, dp1Rack);
        BookieNode dp1BkNode2 = new BookieNode(bkId2, dp1Rack);
        networkTopology.add((Node)dp1BkNode1);
        networkTopology.add((Node)dp1BkNode2);
        networkTopology.remove((Node)dp1BkNode1);
        BookieNode dp2BkNode1 = new BookieNode(bkId1, dp2Rack);
        try {
            networkTopology.add((Node)dp2BkNode1);
            Assert.fail((String)"Expected add node failed caused by different depth of rack");
        }
        catch (NetworkTopologyImpl.InvalidTopologyException invalidTopologyException) {
            // empty catch block
        }
        Set leaves = networkTopology.getLeaves(dp1Rack);
        Assert.assertEquals((long)leaves.size(), (long)1L);
        Assert.assertTrue((boolean)leaves.contains(dp1BkNode2));
        networkTopology.remove((Node)dp1BkNode2);
        BookieNode dp2BkNode2 = new BookieNode(bkId2, dp2Rack);
        networkTopology.add((Node)dp2BkNode1);
        networkTopology.add((Node)dp2BkNode2);
        leaves = networkTopology.getLeaves(dp2Rack);
        Assert.assertEquals((long)leaves.size(), (long)2L);
        Assert.assertTrue((boolean)leaves.contains(dp2BkNode1));
        Assert.assertTrue((boolean)leaves.contains(dp2BkNode2));
    }

    @Test
    public void getLeavesShouldReturnLeavesThatAreNotInExcludedScope() {
        NetworkTopologyImpl networkTopology = new NetworkTopologyImpl();
        String rack0Scope = "/rack-0";
        BookieId bookieIdScopeRack0 = BookieId.parse((String)"bookieIdScopeRack0");
        BookieNode bookieRack0ScopeNode = new BookieNode(bookieIdScopeRack0, rack0Scope);
        String rack1Scope = "/rack-1";
        BookieId bookieIdScopeRack1 = BookieId.parse((String)"bookieIdScopeRack1");
        BookieNode bookieRack1ScopeNode = new BookieNode(bookieIdScopeRack1, rack1Scope);
        String rack2Scope = "/rack-2";
        BookieId bookieIdScopeRack2 = BookieId.parse((String)"bookieIdScopeRack2");
        BookieNode bookieRack2ScopeNode = new BookieNode(bookieIdScopeRack2, rack2Scope);
        networkTopology.add((Node)bookieRack0ScopeNode);
        networkTopology.add((Node)bookieRack1ScopeNode);
        networkTopology.add((Node)bookieRack2ScopeNode);
        String scopeExcludingRack1 = "~/rack-1";
        Set leavesExcludingRack2Scope = networkTopology.getLeaves(scopeExcludingRack1);
        Assert.assertTrue((leavesExcludingRack2Scope.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)leavesExcludingRack2Scope.contains(bookieRack0ScopeNode));
        Assert.assertTrue((boolean)leavesExcludingRack2Scope.contains(bookieRack2ScopeNode));
    }

    @Test
    public void testInvalidRackName() {
        NetworkTopologyImpl networkTopology = new NetworkTopologyImpl();
        String rack0Scope = "";
        BookieId bookieIdScopeRack0 = BookieId.parse((String)"bookieIdScopeRack0");
        BookieNode bookieRack0ScopeNode = new BookieNode(bookieIdScopeRack0, rack0Scope);
        String rack1Scope = "/";
        BookieId bookieIdScopeRack1 = BookieId.parse((String)"bookieIdScopeRack1");
        BookieNode bookieRack1ScopeNode = new BookieNode(bookieIdScopeRack1, rack1Scope);
        try {
            networkTopology.add((Node)bookieRack0ScopeNode);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"bookieIdScopeRack0, which is located at , is not a decendent of /", (Object)e.getMessage());
        }
        try {
            networkTopology.add((Node)bookieRack1ScopeNode);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"bookieIdScopeRack1, which is located at , is not a decendent of /", (Object)e.getMessage());
        }
    }
}

