/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerLayout;
import org.apache.bookkeeper.meta.ZkLayoutManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.junit.Assert;
import org.junit.Test;

public class ZkLedgerLayoutTest
extends BookKeeperClusterTestCase {
    public ZkLedgerLayoutTest() {
        super(0);
    }

    @Override
    protected ClientConfiguration newClientConfiguration() {
        return (ClientConfiguration)new ClientConfiguration().setMetadataServiceUri(this.metadataServiceUri);
    }

    @Test
    public void testLedgerLayout() throws Exception {
        ClientConfiguration conf = this.newClientConfiguration();
        conf.setLedgerManagerFactoryClass(HierarchicalLedgerManagerFactory.class);
        String ledgerRootPath = "/testLedgerLayout";
        ZkLayoutManager zkLayoutManager = new ZkLayoutManager(this.zkc, ledgerRootPath, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        this.zkc.create(ledgerRootPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals(null, (Object)zkLayoutManager.readLedgerLayout());
        String testName = "foobar";
        int testVersion = -559038737;
        LedgerLayout layout2 = new LedgerLayout(testName, testVersion);
        zkLayoutManager.storeLedgerLayout(layout2);
        LedgerLayout layout = zkLayoutManager.readLedgerLayout();
        Assert.assertEquals((Object)testName, (Object)layout.getManagerFactoryClass());
        Assert.assertEquals((long)testVersion, (long)layout.getManagerVersion());
    }

    private void writeLedgerLayout(String ledgersRootPath, String managerType, int managerVersion, int layoutVersion) throws Exception {
        LedgerLayout layout = new LedgerLayout(managerType, managerVersion);
        Field f = LedgerLayout.class.getDeclaredField("layoutFormatVersion");
        f.setAccessible(true);
        f.set(layout, layoutVersion);
        ZkLayoutManager zkLayoutManager = new ZkLayoutManager(this.zkc, ledgersRootPath, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        zkLayoutManager.storeLedgerLayout(layout);
    }

    @Test
    public void testBadVersionLedgerLayout() throws Exception {
        ClientConfiguration conf = this.newClientConfiguration();
        String zkLedgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)conf);
        this.writeLedgerLayout(zkLedgersRootPath, HierarchicalLedgerManagerFactory.class.getName(), 1, 3);
        ZkLayoutManager zkLayoutManager = new ZkLayoutManager(this.zkc, zkLedgersRootPath, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        try {
            zkLayoutManager.readLedgerLayout();
            Assert.fail((String)"Shouldn't reach here!");
        }
        catch (IOException ie) {
            Assert.assertTrue((String)"Invalid exception", (boolean)ie.getMessage().contains("version not compatible"));
        }
    }

    @Test
    public void testAbsentLedgerManagerLayout() throws Exception {
        ClientConfiguration conf = this.newClientConfiguration();
        String ledgersLayout = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)conf) + "/" + "LAYOUT";
        StringBuilder sb = new StringBuilder();
        sb.append(2).append("\n");
        this.zkc.create(ledgersLayout, sb.toString().getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        ZkLayoutManager zkLayoutManager = new ZkLayoutManager(this.zkc, ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)conf), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        try {
            zkLayoutManager.readLedgerLayout();
            Assert.fail((String)"Shouldn't reach here!");
        }
        catch (IOException ie) {
            Assert.assertTrue((String)"Invalid exception", (boolean)ie.getMessage().contains("version absent from"));
        }
    }

    @Test
    public void testBaseLedgerManagerLayout() throws Exception {
        ClientConfiguration conf = this.newClientConfiguration();
        String rootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)conf);
        String ledgersLayout = rootPath + "/" + "LAYOUT";
        StringBuilder sb = new StringBuilder();
        sb.append(2).append("\n").append(HierarchicalLedgerManagerFactory.class.getName());
        this.zkc.create(ledgersLayout, sb.toString().getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        ZkLayoutManager zkLayoutManager = new ZkLayoutManager(this.zkc, rootPath, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        try {
            zkLayoutManager.readLedgerLayout();
            Assert.fail((String)"Shouldn't reach here!");
        }
        catch (IOException ie) {
            Assert.assertTrue((String)"Invalid exception", (boolean)ie.getMessage().contains("Invalid Ledger Manager"));
        }
    }

    @Test
    public void testReadV1LedgerManagerLayout() throws Exception {
        ClientConfiguration conf = this.newClientConfiguration();
        String zkLedgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)conf);
        this.writeLedgerLayout(zkLedgersRootPath, "hierarchical", 1, 1);
        ZkLayoutManager zkLayoutManager = new ZkLayoutManager(this.zkc, zkLedgersRootPath, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        LedgerLayout layout = zkLayoutManager.readLedgerLayout();
        Assert.assertNotNull((String)"Should not be null", (Object)layout);
        Assert.assertEquals((Object)"hierarchical", (Object)layout.getManagerFactoryClass());
        Assert.assertEquals((long)1L, (long)layout.getManagerVersion());
        Assert.assertEquals((long)1L, (long)layout.getLayoutFormatVersion());
    }
}

