/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.testing.executors.MockExecutorController;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.AbstractZkLedgerManager;
import org.apache.bookkeeper.meta.HierarchicalLedgerManager;
import org.apache.bookkeeper.meta.LedgerMetadataSerDe;
import org.apache.bookkeeper.meta.LongHierarchicalLedgerManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.bookkeeper.zookeeper.MockZooKeeperTestCase;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"javax.management.*"})
@PrepareForTest(value={AbstractZkLedgerManager.class, ZkUtils.class})
public class AbstractZkLedgerManagerTest
extends MockZooKeeperTestCase {
    private ClientConfiguration conf;
    private AbstractZkLedgerManager ledgerManager;
    private ScheduledExecutorService scheduler;
    private MockExecutorController schedulerController;
    private LedgerMetadata metadata;
    private LedgerMetadataSerDe serDe;

    @Override
    @Before
    public void setup() throws Exception {
        PowerMockito.mockStatic(Executors.class, (Class[])new Class[0]);
        super.setup();
        this.scheduler = (ScheduledExecutorService)PowerMockito.mock(ScheduledExecutorService.class);
        this.schedulerController = new MockExecutorController().controlSubmit(this.scheduler).controlSchedule(this.scheduler).controlExecute(this.scheduler).controlScheduleAtFixedRate(this.scheduler, 10);
        PowerMockito.when((Object)Executors.newSingleThreadScheduledExecutor((ThreadFactory)ArgumentMatchers.any())).thenReturn((Object)this.scheduler);
        this.conf = new ClientConfiguration();
        this.ledgerManager = (AbstractZkLedgerManager)Mockito.mock(AbstractZkLedgerManager.class, (MockSettings)Mockito.withSettings().useConstructor(new Object[]{this.conf, this.mockZk}).defaultAnswer(Mockito.CALLS_REAL_METHODS));
        ArrayList ensemble = Lists.newArrayList((Object[])new BookieId[]{new BookieSocketAddress("192.0.2.1", 3181).toBookieId(), new BookieSocketAddress("192.0.2.2", 3181).toBookieId(), new BookieSocketAddress("192.0.2.3", 3181).toBookieId(), new BookieSocketAddress("192.0.2.4", 3181).toBookieId(), new BookieSocketAddress("192.0.2.5", 3181).toBookieId()});
        this.metadata = LedgerMetadataBuilder.create().withId(123L).withDigestType(DigestType.CRC32C).withPassword(new byte[0]).withEnsembleSize(5).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)ensemble).withCreationTime(12345L).build();
        ((AbstractZkLedgerManager)Mockito.doAnswer(invocationOnMock -> {
            long ledgerId = (Long)invocationOnMock.getArgument(0);
            return String.valueOf(ledgerId);
        }).when((Object)this.ledgerManager)).getLedgerPath(ArgumentMatchers.anyLong());
        ((AbstractZkLedgerManager)Mockito.doAnswer(invocationOnMock -> {
            String ledgerStr = (String)invocationOnMock.getArgument(0);
            return Long.parseLong(ledgerStr);
        }).when((Object)this.ledgerManager)).getLedgerId(ArgumentMatchers.anyString());
        Assert.assertEquals((Object)ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.conf), (Object)this.ledgerManager.ledgerRootPath);
        Assert.assertSame((Object)this.mockZk, (Object)this.ledgerManager.zk);
        Assert.assertSame((Object)this.conf, (Object)this.ledgerManager.conf);
        Assert.assertSame((Object)this.scheduler, (Object)this.ledgerManager.scheduler);
        this.serDe = new LedgerMetadataSerDe();
    }

    @After
    public void teardown() throws Exception {
        if (null != this.ledgerManager) {
            this.ledgerManager.close();
            ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)0))).close();
            ((ScheduledExecutorService)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).shutdown();
        }
    }

    @Test
    public void testCreateLedgerMetadataSuccess() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        this.mockZkUtilsAsyncCreateFullPathOptimistic(ledgerStr, CreateMode.PERSISTENT, KeeperException.Code.OK.intValue(), ledgerStr);
        Versioned result = (Versioned)this.ledgerManager.createLedgerMetadata(ledgerId, this.metadata).get();
        Assert.assertEquals((Object)new LongVersion(0L), (Object)result.getVersion());
    }

    @Test
    public void testCreateLedgerMetadataNodeExists() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        this.mockZkUtilsAsyncCreateFullPathOptimistic(ledgerStr, CreateMode.PERSISTENT, KeeperException.Code.NODEEXISTS.intValue(), null);
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getVersion()).thenReturn((Object)1234);
        Mockito.when((Object)stat.getCtime()).thenReturn((Object)this.metadata.getCtime());
        this.mockZkGetData(ledgerStr, false, KeeperException.Code.OK.intValue(), this.serDe.serialize(this.metadata), stat);
        try {
            FutureUtils.result((CompletableFuture)this.ledgerManager.createLedgerMetadata(ledgerId, this.metadata));
            Assert.fail((String)"Should fail to create ledger metadata if the ledger already exists");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BKException));
            BKException bke = (BKException)((Object)e);
            Assert.assertEquals((long)-20L, (long)bke.getCode());
        }
    }

    @Test
    public void testCreateLedgerMetadataException() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        this.mockZkUtilsAsyncCreateFullPathOptimistic(ledgerStr, CreateMode.PERSISTENT, KeeperException.Code.CONNECTIONLOSS.intValue(), null);
        try {
            FutureUtils.result((CompletableFuture)this.ledgerManager.createLedgerMetadata(ledgerId, this.metadata));
            Assert.fail((String)"Should fail to create ledger metadata when encountering zookeeper exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BKException));
            BKException bke = (BKException)((Object)e);
            Assert.assertEquals((long)-9L, (long)bke.getCode());
            Assert.assertTrue((boolean)(bke.getCause() instanceof KeeperException));
        }
    }

    @Test
    public void testRemoveLedgerMetadataSuccess() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        LongVersion version = new LongVersion(1234L);
        this.mockZkDelete(ledgerStr, (int)version.getLongVersion(), KeeperException.Code.OK.intValue());
        this.ledgerManager.removeLedgerMetadata(ledgerId, (Version)version).get();
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).delete((String)ArgumentMatchers.eq((Object)ledgerStr), ArgumentMatchers.eq((int)1234), (AsyncCallback.VoidCallback)ArgumentMatchers.any(AsyncCallback.VoidCallback.class), ArgumentMatchers.eq(null));
    }

    @Test
    public void testRemoveLedgerMetadataVersionAny() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        this.mockZkDelete(ledgerStr, -1, KeeperException.Code.OK.intValue());
        this.ledgerManager.removeLedgerMetadata(ledgerId, Version.ANY).get();
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).delete((String)ArgumentMatchers.eq((Object)ledgerStr), ArgumentMatchers.eq((int)-1), (AsyncCallback.VoidCallback)ArgumentMatchers.any(AsyncCallback.VoidCallback.class), ArgumentMatchers.eq(null));
    }

    @Test
    public void testRemoveLedgerMetadataVersionNew() throws Exception {
        this.testRemoveLedgerMetadataInvalidVersion(Version.NEW);
    }

    @Test
    public void testRemoveLedgerMetadataUnknownVersionType() throws Exception {
        Version version = (Version)Mockito.mock(Version.class);
        this.testRemoveLedgerMetadataInvalidVersion(version);
    }

    private void testRemoveLedgerMetadataInvalidVersion(Version version) throws Exception {
        long ledgerId = System.currentTimeMillis();
        try {
            FutureUtils.result((CompletableFuture)this.ledgerManager.removeLedgerMetadata(ledgerId, version));
            Assert.fail((String)("Should fail to remove metadata if version is " + Version.NEW));
        }
        catch (BKException bke) {
            Assert.assertEquals((long)-17L, (long)bke.getCode());
        }
    }

    @Test
    public void testRemoveLedgerMetadataNoNode() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        LongVersion version = new LongVersion(1234L);
        this.mockZkDelete(ledgerStr, (int)version.getLongVersion(), KeeperException.Code.NONODE.intValue());
        try {
            FutureUtils.result((CompletableFuture)this.ledgerManager.removeLedgerMetadata(ledgerId, (Version)version));
        }
        catch (BKException bke) {
            Assert.fail((String)"Should succeed");
        }
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).delete((String)ArgumentMatchers.eq((Object)ledgerStr), ArgumentMatchers.eq((int)1234), (AsyncCallback.VoidCallback)ArgumentMatchers.any(AsyncCallback.VoidCallback.class), ArgumentMatchers.eq(null));
    }

    @Test
    public void testRemoveLedgerMetadataException() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        LongVersion version = new LongVersion(1234L);
        this.mockZkDelete(ledgerStr, (int)version.getLongVersion(), KeeperException.Code.CONNECTIONLOSS.intValue());
        try {
            FutureUtils.result((CompletableFuture)this.ledgerManager.removeLedgerMetadata(ledgerId, (Version)version));
            Assert.fail((String)"Should fail to remove metadata upon ZKException");
        }
        catch (BKException bke) {
            Assert.assertEquals((long)-9L, (long)bke.getCode());
        }
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).delete((String)ArgumentMatchers.eq((Object)ledgerStr), ArgumentMatchers.eq((int)1234), (AsyncCallback.VoidCallback)ArgumentMatchers.any(AsyncCallback.VoidCallback.class), ArgumentMatchers.eq(null));
    }

    @Test
    public void testRemoveLedgerMetadataHierarchical() throws Exception {
        HierarchicalLedgerManager hlm = new HierarchicalLedgerManager((AbstractConfiguration)this.conf, this.mockZk);
        this.testRemoveLedgerMetadataHierarchicalLedgerManager((AbstractZkLedgerManager)hlm);
    }

    @Test
    public void testRemoveLedgerMetadataLongHierarchical() throws Exception {
        LongHierarchicalLedgerManager hlm = new LongHierarchicalLedgerManager((AbstractConfiguration)this.conf, this.mockZk);
        this.testRemoveLedgerMetadataHierarchicalLedgerManager((AbstractZkLedgerManager)hlm);
    }

    private void testRemoveLedgerMetadataHierarchicalLedgerManager(AbstractZkLedgerManager lm) throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = lm.getLedgerPath(ledgerId);
        LongVersion version = new LongVersion(1234L);
        this.mockZkUtilsAsyncDeleteFullPathOptimistic(ledgerStr, (int)version.getLongVersion(), KeeperException.Code.OK.intValue());
        lm.removeLedgerMetadata(ledgerId, (Version)version).get();
        PowerMockito.verifyStatic(ZkUtils.class, (VerificationMode)Mockito.times((int)1));
        ZkUtils.asyncDeleteFullPathOptimistic((ZooKeeper)((ZooKeeper)ArgumentMatchers.eq((Object)this.mockZk)), (String)((String)ArgumentMatchers.eq((Object)ledgerStr)), (int)ArgumentMatchers.eq((int)1234), (AsyncCallback.VoidCallback)((AsyncCallback.VoidCallback)ArgumentMatchers.any(AsyncCallback.VoidCallback.class)), (String)((String)ArgumentMatchers.eq((Object)ledgerStr)));
    }

    @Test
    public void testReadLedgerMetadataSuccess() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getVersion()).thenReturn((Object)1234);
        Mockito.when((Object)stat.getCtime()).thenReturn((Object)this.metadata.getCtime());
        this.mockZkGetData(ledgerStr, false, KeeperException.Code.OK.intValue(), this.serDe.serialize(this.metadata), stat);
        Versioned readMetadata = (Versioned)FutureUtils.result((CompletableFuture)this.ledgerManager.readLedgerMetadata(ledgerId));
        Assert.assertEquals((Object)this.metadata, (Object)readMetadata.getValue());
        Assert.assertEquals((Object)new LongVersion(1234L), (Object)readMetadata.getVersion());
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getData((String)ArgumentMatchers.eq((Object)ledgerStr), (Watcher)ArgumentMatchers.eq(null), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
    }

    @Test
    public void testReadLedgerMetadataNoNode() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        this.mockZkGetData(ledgerStr, false, KeeperException.Code.NONODE.intValue(), null, null);
        try {
            FutureUtils.result((CompletableFuture)this.ledgerManager.readLedgerMetadata(ledgerId));
            Assert.fail((String)"Should fail on reading ledger metadata if a ledger doesn't exist");
        }
        catch (BKException bke) {
            Assert.assertEquals((long)-25L, (long)bke.getCode());
        }
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getData((String)ArgumentMatchers.eq((Object)ledgerStr), (Watcher)ArgumentMatchers.eq(null), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
    }

    @Test
    public void testReadLedgerMetadataException() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        this.mockZkGetData(ledgerStr, false, KeeperException.Code.CONNECTIONLOSS.intValue(), null, null);
        try {
            FutureUtils.result((CompletableFuture)this.ledgerManager.readLedgerMetadata(ledgerId));
            Assert.fail((String)"Should fail on reading ledger metadata if a ledger doesn't exist");
        }
        catch (BKException bke) {
            Assert.assertEquals((long)-9L, (long)bke.getCode());
        }
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getData((String)ArgumentMatchers.eq((Object)ledgerStr), (Watcher)ArgumentMatchers.eq(null), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
    }

    @Test
    public void testReadLedgerMetadataStatMissing() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        this.mockZkGetData(ledgerStr, false, KeeperException.Code.OK.intValue(), this.serDe.serialize(this.metadata), null);
        try {
            FutureUtils.result((CompletableFuture)this.ledgerManager.readLedgerMetadata(ledgerId));
            Assert.fail((String)"Should fail on reading ledger metadata if a ledger doesn't exist");
        }
        catch (BKException bke) {
            Assert.assertEquals((long)-9L, (long)bke.getCode());
        }
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getData((String)ArgumentMatchers.eq((Object)ledgerStr), (Watcher)ArgumentMatchers.eq(null), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
    }

    @Test
    public void testReadLedgerMetadataDataCorrupted() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getVersion()).thenReturn((Object)1234);
        Mockito.when((Object)stat.getCtime()).thenReturn((Object)this.metadata.getCtime());
        this.mockZkGetData(ledgerStr, false, KeeperException.Code.OK.intValue(), new byte[0], stat);
        try {
            FutureUtils.result((CompletableFuture)this.ledgerManager.readLedgerMetadata(ledgerId));
            Assert.fail((String)"Should fail on reading ledger metadata if a ledger doesn't exist");
        }
        catch (BKException bke) {
            Assert.assertEquals((long)-9L, (long)bke.getCode());
        }
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getData((String)ArgumentMatchers.eq((Object)ledgerStr), (Watcher)ArgumentMatchers.eq(null), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
    }

    @Test
    public void testWriteLedgerMetadataSuccess() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getVersion()).thenReturn((Object)1235);
        Mockito.when((Object)stat.getCtime()).thenReturn((Object)this.metadata.getCtime());
        this.mockZkSetData(ledgerStr, this.serDe.serialize(this.metadata), 1234, KeeperException.Code.OK.intValue(), stat);
        Version v = ((Versioned)this.ledgerManager.writeLedgerMetadata(ledgerId, this.metadata, (Version)new LongVersion(1234L)).get()).getVersion();
        Assert.assertEquals((Object)new LongVersion(1235L), (Object)v);
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).setData((String)ArgumentMatchers.eq((Object)ledgerStr), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.eq((int)1234), (AsyncCallback.StatCallback)ArgumentMatchers.any(AsyncCallback.StatCallback.class), ArgumentMatchers.any());
    }

    @Test
    public void testWriteLedgerMetadataBadVersion() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        this.mockZkSetData(ledgerStr, this.serDe.serialize(this.metadata), 1234, KeeperException.Code.BADVERSION.intValue(), null);
        try {
            FutureUtils.result((CompletableFuture)this.ledgerManager.writeLedgerMetadata(ledgerId, this.metadata, (Version)new LongVersion(1234L)));
            Assert.fail((String)"Should fail on writing ledger metadata if encountering bad version");
        }
        catch (BKException bke) {
            Assert.assertEquals((long)-17L, (long)bke.getCode());
        }
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).setData((String)ArgumentMatchers.eq((Object)ledgerStr), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.eq((int)1234), (AsyncCallback.StatCallback)ArgumentMatchers.any(AsyncCallback.StatCallback.class), ArgumentMatchers.any());
    }

    @Test
    public void testWriteLedgerMetadataException() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        this.mockZkSetData(ledgerStr, this.serDe.serialize(this.metadata), 1234, KeeperException.Code.CONNECTIONLOSS.intValue(), null);
        try {
            FutureUtils.result((CompletableFuture)this.ledgerManager.writeLedgerMetadata(ledgerId, this.metadata, (Version)new LongVersion(1234L)));
            Assert.fail((String)"Should fail on writing ledger metadata if encountering zookeeper exceptions");
        }
        catch (BKException bke) {
            Assert.assertEquals((long)-9L, (long)bke.getCode());
        }
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).setData((String)ArgumentMatchers.eq((Object)ledgerStr), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.eq((int)1234), (AsyncCallback.StatCallback)ArgumentMatchers.any(AsyncCallback.StatCallback.class), ArgumentMatchers.any());
    }

    @Test
    public void testWriteLedgerMetadataInvalidVersion() throws Exception {
        Version[] versions;
        for (Version version : versions = new Version[]{Version.NEW, Version.ANY, (Version)Mockito.mock(Version.class)}) {
            this.testWriteLedgerMetadataInvalidVersion(version);
        }
    }

    private void testWriteLedgerMetadataInvalidVersion(Version invalidVersion) throws Exception {
        long ledgerId = System.currentTimeMillis();
        try {
            FutureUtils.result((CompletableFuture)this.ledgerManager.writeLedgerMetadata(ledgerId, this.metadata, invalidVersion));
            Assert.fail((String)"Should fail on writing ledger metadata if an invalid version is provided.");
        }
        catch (BKException bke) {
            Assert.assertEquals((long)-17L, (long)bke.getCode());
        }
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)0))).setData(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), (AsyncCallback.StatCallback)ArgumentMatchers.any(AsyncCallback.StatCallback.class), ArgumentMatchers.any());
    }

    @Test
    public void testLedgerMetadataListener() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        LinkedBlockingQueue changes = new LinkedBlockingQueue();
        BookkeeperInternalCallbacks.LedgerMetadataListener listener = (ledgerId1, metadata) -> changes.add(metadata.getValue());
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getVersion()).thenReturn((Object)1234);
        Mockito.when((Object)stat.getCtime()).thenReturn((Object)this.metadata.getCtime());
        this.mockZkGetData(ledgerStr, true, KeeperException.Code.OK.intValue(), this.serDe.serialize(this.metadata), stat);
        this.ledgerManager.registerLedgerMetadataListener(ledgerId, listener);
        LedgerMetadata change1 = (LedgerMetadata)changes.take();
        Assert.assertEquals((Object)this.metadata, (Object)change1);
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getData(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
        Assert.assertTrue((boolean)this.watchers.containsKey(ledgerStr));
        Set watcherSet1 = (Set)this.watchers.get(ledgerStr);
        Assert.assertEquals((long)1L, (long)watcherSet1.size());
        Watcher registeredWatcher1 = (Watcher)watcherSet1.stream().findFirst().get();
        Mockito.when((Object)stat.getVersion()).thenReturn((Object)1235);
        this.mockZkGetData(ledgerStr, true, KeeperException.Code.OK.intValue(), this.serDe.serialize(this.metadata), stat);
        this.notifyWatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, ledgerStr);
        LedgerMetadata change2 = (LedgerMetadata)changes.take();
        Assert.assertEquals((Object)this.metadata, (Object)change2);
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)2))).getData(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
        Assert.assertTrue((boolean)this.watchers.containsKey(ledgerStr));
        Set watcherSet2 = (Set)this.watchers.get(ledgerStr);
        Assert.assertEquals((long)1L, (long)watcherSet2.size());
        Watcher registeredWatcher2 = (Watcher)watcherSet2.stream().findFirst().get();
        Assert.assertSame((Object)registeredWatcher1, (Object)registeredWatcher2);
        ((ScheduledExecutorService)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)2))).submit((Runnable)ArgumentMatchers.any(Runnable.class));
        ((ScheduledExecutorService)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)0))).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
    }

    @Test
    public void testLedgerMetadataListenerOnLedgerDeleted() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        LinkedBlockingQueue changes = new LinkedBlockingQueue();
        BookkeeperInternalCallbacks.LedgerMetadataListener listener = (ledgerId1, metadata) -> changes.add(Optional.ofNullable(metadata != null ? (LedgerMetadata)metadata.getValue() : null));
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getVersion()).thenReturn((Object)1234);
        Mockito.when((Object)stat.getCtime()).thenReturn((Object)this.metadata.getCtime());
        this.mockZkGetData(ledgerStr, true, KeeperException.Code.OK.intValue(), this.serDe.serialize(this.metadata), stat);
        this.ledgerManager.registerLedgerMetadataListener(ledgerId, listener);
        Assert.assertTrue((boolean)this.ledgerManager.listeners.containsKey(ledgerId));
        LedgerMetadata change1 = (LedgerMetadata)((Optional)changes.take()).get();
        Assert.assertEquals((Object)this.metadata, (Object)change1);
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getData(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
        Assert.assertTrue((boolean)this.watchers.containsKey(ledgerStr));
        this.mockZkGetData(ledgerStr, true, KeeperException.Code.NONODE.intValue(), null, null);
        this.notifyWatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, ledgerStr);
        Optional change2 = (Optional)changes.take();
        Assert.assertFalse((boolean)change2.isPresent());
        Assert.assertFalse((boolean)this.ledgerManager.listeners.containsKey(ledgerId));
        ((ScheduledExecutorService)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).submit((Runnable)ArgumentMatchers.any(Runnable.class));
        ((ScheduledExecutorService)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)0))).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        Assert.assertFalse((boolean)this.watchers.containsKey(ledgerStr));
    }

    @Test
    public void testLedgerMetadataListenerOnLedgerDeletedEvent() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        LinkedBlockingQueue changes = new LinkedBlockingQueue();
        BookkeeperInternalCallbacks.LedgerMetadataListener listener = (ledgerId1, metadata) -> changes.add(Optional.ofNullable(metadata != null ? (LedgerMetadata)metadata.getValue() : null));
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getVersion()).thenReturn((Object)1234);
        Mockito.when((Object)stat.getCtime()).thenReturn((Object)this.metadata.getCtime());
        this.mockZkGetData(ledgerStr, true, KeeperException.Code.OK.intValue(), this.serDe.serialize(this.metadata), stat);
        this.ledgerManager.registerLedgerMetadataListener(ledgerId, listener);
        Assert.assertTrue((boolean)this.ledgerManager.listeners.containsKey(ledgerId));
        LedgerMetadata change1 = (LedgerMetadata)((Optional)changes.take()).get();
        Assert.assertEquals((Object)this.metadata, (Object)change1);
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getData(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
        Assert.assertTrue((boolean)this.watchers.containsKey(ledgerStr));
        this.notifyWatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, ledgerStr);
        Optional change2 = (Optional)changes.take();
        Assert.assertFalse((boolean)change2.isPresent());
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getData(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
        Assert.assertFalse((boolean)this.ledgerManager.listeners.containsKey(ledgerId));
    }

    @Test
    public void testLedgerMetadataListenerOnRetries() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        LinkedBlockingQueue changes = new LinkedBlockingQueue();
        BookkeeperInternalCallbacks.LedgerMetadataListener listener = (ledgerId1, metadata) -> changes.add(metadata.getValue());
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getVersion()).thenReturn((Object)1234);
        Mockito.when((Object)stat.getCtime()).thenReturn((Object)this.metadata.getCtime());
        this.mockZkGetData(ledgerStr, true, KeeperException.Code.SESSIONEXPIRED.intValue(), null, null);
        this.ledgerManager.registerLedgerMetadataListener(ledgerId, listener);
        Assert.assertTrue((boolean)this.ledgerManager.listeners.containsKey(ledgerId));
        Assert.assertNull(changes.poll());
        ((ScheduledExecutorService)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getData(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
        Assert.assertFalse((boolean)this.watchers.containsKey(ledgerStr));
        this.mockZkGetData(ledgerStr, true, KeeperException.Code.OK.intValue(), this.serDe.serialize(this.metadata), stat);
        this.schedulerController.advance(Duration.ofMillis(200L));
        LedgerMetadata change = (LedgerMetadata)changes.take();
        Assert.assertEquals((Object)this.metadata, (Object)change);
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)2))).getData(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
        Assert.assertTrue((boolean)this.watchers.containsKey(ledgerStr));
    }

    @Test
    public void testLedgerMetadataListenerOnSessionExpired() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        LinkedBlockingQueue changes = new LinkedBlockingQueue();
        BookkeeperInternalCallbacks.LedgerMetadataListener listener = (ledgerId1, metadata) -> changes.add(metadata.getValue());
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getVersion()).thenReturn((Object)1234);
        Mockito.when((Object)stat.getCtime()).thenReturn((Object)this.metadata.getCtime());
        this.mockZkGetData(ledgerStr, true, KeeperException.Code.OK.intValue(), this.serDe.serialize(this.metadata), stat);
        this.ledgerManager.registerLedgerMetadataListener(ledgerId, listener);
        LedgerMetadata change1 = (LedgerMetadata)changes.take();
        Assert.assertEquals((Object)this.metadata, (Object)change1);
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getData(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
        Assert.assertTrue((boolean)this.watchers.containsKey(ledgerStr));
        Set watcherSet1 = (Set)this.watchers.get(ledgerStr);
        Assert.assertEquals((long)1L, (long)watcherSet1.size());
        Watcher registeredWatcher1 = (Watcher)watcherSet1.stream().findFirst().get();
        this.notifyWatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, ledgerStr);
        LedgerMetadata change2 = (LedgerMetadata)changes.take();
        Assert.assertEquals((Object)this.metadata, (Object)change2);
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)2))).getData(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
        Assert.assertTrue((boolean)this.watchers.containsKey(ledgerStr));
        Set watcherSet2 = (Set)this.watchers.get(ledgerStr);
        Assert.assertEquals((long)1L, (long)watcherSet2.size());
        Watcher registeredWatcher2 = (Watcher)watcherSet2.stream().findFirst().get();
        Assert.assertSame((Object)registeredWatcher1, (Object)registeredWatcher2);
    }

    @Test
    public void testUnregisterLedgerMetadataListener() throws Exception {
        long ledgerId = System.currentTimeMillis();
        String ledgerStr = String.valueOf(ledgerId);
        LinkedBlockingQueue changes = new LinkedBlockingQueue();
        BookkeeperInternalCallbacks.LedgerMetadataListener listener = (ledgerId1, metadata) -> changes.add(metadata.getValue());
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getVersion()).thenReturn((Object)1234);
        Mockito.when((Object)stat.getCtime()).thenReturn((Object)this.metadata.getCtime());
        this.mockZkGetData(ledgerStr, true, KeeperException.Code.OK.intValue(), this.serDe.serialize(this.metadata), stat);
        this.ledgerManager.registerLedgerMetadataListener(ledgerId, listener);
        Assert.assertTrue((boolean)this.ledgerManager.listeners.containsKey(ledgerId));
        LedgerMetadata change1 = (LedgerMetadata)changes.take();
        Assert.assertEquals((Object)this.metadata, (Object)change1);
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getData(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
        Assert.assertTrue((boolean)this.watchers.containsKey(ledgerStr));
        Set watcherSet1 = (Set)this.watchers.get(ledgerStr);
        Assert.assertEquals((long)1L, (long)watcherSet1.size());
        Watcher registeredWatcher1 = (Watcher)watcherSet1.stream().findFirst().get();
        Mockito.when((Object)stat.getVersion()).thenReturn((Object)1235);
        this.mockZkGetData(ledgerStr, true, KeeperException.Code.OK.intValue(), this.serDe.serialize(this.metadata), stat);
        this.mockZkRemoveWatcher();
        this.ledgerManager.unregisterLedgerMetadataListener(ledgerId, listener);
        Assert.assertFalse((boolean)this.ledgerManager.listeners.containsKey(ledgerId));
        Assert.assertFalse((boolean)this.watchers.containsKey(ledgerStr));
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).removeWatches((String)ArgumentMatchers.eq((Object)this.ledgerManager.getLedgerPath(ledgerId)), (Watcher)ArgumentMatchers.any(Watcher.class), (Watcher.WatcherType)ArgumentMatchers.any(Watcher.WatcherType.class), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue(), (AsyncCallback.VoidCallback)ArgumentMatchers.any(AsyncCallback.VoidCallback.class), ArgumentMatchers.any());
        this.notifyWatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, ledgerStr);
        Assert.assertNull(changes.poll());
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getData(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
    }
}

