/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.discover;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.discover.BookieServiceInfoUtils;
import org.apache.bookkeeper.discover.ZKRegistrationClient;
import org.apache.bookkeeper.discover.ZKRegistrationManager;
import org.apache.bookkeeper.net.BookieId;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class BookieServiceInfoTest {
    @Test
    public void testSerializeDeserializeBookieServiceInfo() throws Exception {
        String bookieId = "127.0.0.1:3181";
        BookieServiceInfo expected = new BookieServiceInfo();
        BookieServiceInfo.Endpoint endpointRPC = new BookieServiceInfo.Endpoint("1", 1281, "localhost", "bookie-rpc", Collections.emptyList(), Collections.emptyList());
        BookieServiceInfo.Endpoint endpointHTTP = new BookieServiceInfo.Endpoint("2", 1281, "localhost", "bookie-http", Collections.emptyList(), Collections.emptyList());
        expected.setEndpoints(Arrays.asList(endpointRPC, endpointHTTP));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("test", "value");
        expected.setProperties(properties);
        byte[] serialized = ZKRegistrationManager.serializeBookieServiceInfo((BookieServiceInfo)expected);
        BookieServiceInfo deserialized = ZKRegistrationClient.deserializeBookieServiceInfo((BookieId)BookieId.parse((String)bookieId), (byte[])serialized);
        this.assertBookieServiceInfoEquals(expected, deserialized);
    }

    @Test
    public void testDeserializeBookieServiceInfo() throws Exception {
        BookieId bookieId = BookieId.parse((String)"127.0.0.1:3181");
        BookieServiceInfo expected = BookieServiceInfoUtils.buildLegacyBookieServiceInfo((String)bookieId.toString());
        BookieServiceInfo deserialized = ZKRegistrationClient.deserializeBookieServiceInfo((BookieId)bookieId, null);
        this.assertBookieServiceInfoEquals(expected, deserialized);
        expected = BookieServiceInfoUtils.buildLegacyBookieServiceInfo((String)bookieId.toString());
        deserialized = ZKRegistrationClient.deserializeBookieServiceInfo((BookieId)bookieId, (byte[])new byte[0]);
        this.assertBookieServiceInfoEquals(expected, deserialized);
    }

    private void assertBookieServiceInfoEquals(BookieServiceInfo expected, BookieServiceInfo provided) {
        for (BookieServiceInfo.Endpoint ep : expected.getEndpoints()) {
            BookieServiceInfo.Endpoint e = provided.getEndpoints().stream().filter(ee -> Objects.equals(ee.getId(), ep.getId())).findFirst().get();
            Assert.assertThat((Object)e.getHost(), (Matcher)Matchers.is((Object)ep.getHost()));
            Assert.assertThat((Object)e.getPort(), (Matcher)Matchers.is((Object)ep.getPort()));
            Assert.assertThat((Object)e.getProtocol(), (Matcher)Matchers.is((Object)ep.getProtocol()));
            Assert.assertArrayEquals((Object[])e.getAuth().toArray(), (Object[])ep.getAuth().toArray());
            Assert.assertArrayEquals((Object[])e.getExtensions().toArray(), (Object[])ep.getExtensions().toArray());
        }
        Assert.assertEquals((Object)expected.getProperties(), (Object)provided.getProperties());
    }
}

