/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.api;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteHandleTest {
    private static final Logger log = LoggerFactory.getLogger(WriteHandleTest.class);
    @Rule
    public final TestName runtime = new TestName();
    private final WriteHandle handle = (WriteHandle)Mockito.mock(WriteHandle.class);
    private final LinkedBlockingQueue<ByteBuf> entryQueue = new LinkedBlockingQueue();

    public WriteHandleTest() throws Exception {
        ((WriteHandle)Mockito.doAnswer(invocationOnMock -> {
            ByteBuf buf = (ByteBuf)invocationOnMock.getArgument(0);
            this.entryQueue.add(buf);
            return -1L;
        }).when((Object)this.handle)).append((ByteBuf)ArgumentMatchers.any(ByteBuf.class));
        Mockito.when((Object)this.handle.append((byte[])ArgumentMatchers.any(byte[].class))).thenCallRealMethod();
        Mockito.when((Object)this.handle.append((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenCallRealMethod();
        Mockito.when((Object)this.handle.append((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).thenCallRealMethod();
    }

    @Test
    public void testAppendBytes() throws Exception {
        byte[] testData = this.runtime.getMethodName().getBytes(StandardCharsets.UTF_8);
        this.handle.append(testData);
        ByteBuf buffer = this.entryQueue.take();
        byte[] bufferData = ByteBufUtil.getBytes((ByteBuf)buffer);
        Assert.assertArrayEquals((byte[])testData, (byte[])bufferData);
        ((WriteHandle)Mockito.verify((Object)this.handle, (VerificationMode)Mockito.times((int)1))).append((ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }

    @Test
    public void testAppendBytes2() throws Exception {
        byte[] testData = this.runtime.getMethodName().getBytes(StandardCharsets.UTF_8);
        this.handle.append(testData, 1, testData.length / 2);
        byte[] expectedData = new byte[testData.length / 2];
        System.arraycopy(testData, 1, expectedData, 0, testData.length / 2);
        ByteBuf buffer = this.entryQueue.take();
        byte[] bufferData = ByteBufUtil.getBytes((ByteBuf)buffer);
        Assert.assertArrayEquals((byte[])expectedData, (byte[])bufferData);
        ((WriteHandle)Mockito.verify((Object)this.handle, (VerificationMode)Mockito.times((int)1))).append((ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }

    @Test
    public void testAppendByteBuffer() throws Exception {
        byte[] testData = this.runtime.getMethodName().getBytes(StandardCharsets.UTF_8);
        this.handle.append(ByteBuffer.wrap(testData, 1, testData.length / 2));
        byte[] expectedData = new byte[testData.length / 2];
        System.arraycopy(testData, 1, expectedData, 0, testData.length / 2);
        ByteBuf buffer = this.entryQueue.take();
        byte[] bufferData = ByteBufUtil.getBytes((ByteBuf)buffer);
        Assert.assertArrayEquals((byte[])expectedData, (byte[])bufferData);
        ((WriteHandle)Mockito.verify((Object)this.handle, (VerificationMode)Mockito.times((int)1))).append((ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }
}

