/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.api;

import java.util.EnumSet;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.junit.Assert;
import org.junit.Test;

public class WriteFlagTest {
    private static final int NONE = 0;

    @Test
    public void testGetWriteFlagsDeferredSync() {
        Assert.assertEquals(EnumSet.of(WriteFlag.DEFERRED_SYNC), (Object)WriteFlag.getWriteFlags((int)WriteFlag.DEFERRED_SYNC.getValue()));
    }

    @Test
    public void testGetWriteFlagsNone() {
        Assert.assertEquals((Object)WriteFlag.NONE, (Object)WriteFlag.getWriteFlags((int)0));
    }

    @Test(expected=NullPointerException.class)
    public void testGetWriteFlagsValueNull() {
        WriteFlag.getWriteFlagsValue(null);
    }

    @Test
    public void testGetWriteFlagsValueEmpty() {
        Assert.assertEquals((long)0L, (long)WriteFlag.getWriteFlagsValue((EnumSet)WriteFlag.NONE));
    }

    @Test
    public void testGetWriteFlagsValueDeferredSync() {
        Assert.assertEquals((long)1L, (long)WriteFlag.getWriteFlagsValue(EnumSet.of(WriteFlag.DEFERRED_SYNC)));
    }
}

