/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.api;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.bookkeeper.client.api.WriteAdvHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;

public class WriteAdvHandleTest {
    @Rule
    public final TestName runtime = new TestName();
    private final long entryId;
    private final WriteAdvHandle handle = (WriteAdvHandle)Mockito.mock(WriteAdvHandle.class);
    private final LinkedBlockingQueue<ByteBuf> entryQueue;

    public WriteAdvHandleTest() {
        this.entryId = System.currentTimeMillis();
        this.entryQueue = new LinkedBlockingQueue();
        ((WriteAdvHandle)Mockito.doAnswer(invocationOnMock -> {
            ByteBuf buf = (ByteBuf)invocationOnMock.getArgument(1);
            this.entryQueue.add(buf);
            return FutureUtils.value((Object)-1L);
        }).when((Object)this.handle)).writeAsync(ArgumentMatchers.anyLong(), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
        PowerMockito.when((Object)this.handle.writeAsync(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(byte[].class))).thenCallRealMethod();
        PowerMockito.when((Object)this.handle.writeAsync(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenCallRealMethod();
        PowerMockito.when((Object)this.handle.writeAsync(ArgumentMatchers.anyLong(), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).thenCallRealMethod();
    }

    @Test
    public void testAppendBytes() throws Exception {
        byte[] testData = this.runtime.getMethodName().getBytes(StandardCharsets.UTF_8);
        this.handle.writeAsync(this.entryId, testData);
        ByteBuf buffer = this.entryQueue.take();
        byte[] bufferData = ByteBufUtil.getBytes((ByteBuf)buffer);
        Assert.assertArrayEquals((byte[])testData, (byte[])bufferData);
        ((WriteAdvHandle)Mockito.verify((Object)this.handle, (VerificationMode)Mockito.times((int)1))).writeAsync(ArgumentMatchers.eq((long)this.entryId), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }

    @Test
    public void testAppendBytes2() throws Exception {
        byte[] testData = this.runtime.getMethodName().getBytes(StandardCharsets.UTF_8);
        this.handle.writeAsync(this.entryId, testData, 1, testData.length / 2);
        byte[] expectedData = new byte[testData.length / 2];
        System.arraycopy(testData, 1, expectedData, 0, testData.length / 2);
        ByteBuf buffer = this.entryQueue.take();
        byte[] bufferData = ByteBufUtil.getBytes((ByteBuf)buffer);
        Assert.assertArrayEquals((byte[])expectedData, (byte[])bufferData);
        ((WriteAdvHandle)Mockito.verify((Object)this.handle, (VerificationMode)Mockito.times((int)1))).writeAsync(ArgumentMatchers.eq((long)this.entryId), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }

    @Test
    public void testAppendByteBuffer() throws Exception {
        byte[] testData = this.runtime.getMethodName().getBytes(StandardCharsets.UTF_8);
        this.handle.writeAsync(this.entryId, ByteBuffer.wrap(testData, 1, testData.length / 2));
        byte[] expectedData = new byte[testData.length / 2];
        System.arraycopy(testData, 1, expectedData, 0, testData.length / 2);
        ByteBuf buffer = this.entryQueue.take();
        byte[] bufferData = ByteBufUtil.getBytes((ByteBuf)buffer);
        Assert.assertArrayEquals((byte[])expectedData, (byte[])bufferData);
        ((WriteAdvHandle)Mockito.verify((Object)this.handle, (VerificationMode)Mockito.times((int)1))).writeAsync(ArgumentMatchers.eq((long)this.entryId), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }
}

