/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.SortedLedgerStorage;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestPiggybackLAC
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestPiggybackLAC.class);
    final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    public TestPiggybackLAC(Class<? extends LedgerStorage> storageClass) {
        super(1);
        this.baseConf.setLedgerStorageClass(storageClass.getName());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        return Arrays.asList({InterleavedLedgerStorage.class}, {SortedLedgerStorage.class}, {DbLedgerStorage.class});
    }

    @Test
    public void testPiggybackLAC() throws Exception {
        int numEntries = 10;
        LedgerHandle lh = this.bkc.createLedger(1, 1, 1, this.digestType, "".getBytes());
        for (int i = 0; i < numEntries; ++i) {
            lh.addEntry(("data" + i).getBytes());
            LOG.info("Added entry {}.", (Object)i);
        }
        LedgerHandle readLh = this.bkc.openLedgerNoRecovery(lh.getId(), this.digestType, "".getBytes());
        long lastLAC = readLh.getLastAddConfirmed();
        Assert.assertEquals((long)(numEntries - 2), (long)lastLAC);
        for (int i = 0; i < numEntries; ++i) {
            lh.addEntry(("data" + (i + numEntries)).getBytes());
            LOG.info("Added entry {}.", (Object)(i + numEntries));
        }
        int numReads = 0;
        int i = 0;
        while ((long)i <= readLh.getLastAddConfirmed()) {
            Enumeration data = readLh.readEntries((long)i, (long)i);
            while (data.hasMoreElements()) {
                LedgerEntry entry = (LedgerEntry)data.nextElement();
                Assert.assertEquals((Object)("data" + i), (Object)new String(entry.getEntry()));
                ++numReads;
            }
            ++i;
        }
        Assert.assertEquals((long)(2 * numEntries - 1), (long)numReads);
        Assert.assertEquals((long)(2 * numEntries - 2), (long)readLh.getLastAddConfirmed());
        readLh.close();
        lh.close();
    }
}

