/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperTestClient;
import org.apache.bookkeeper.client.BookieWatcher;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.junit.Test;

public class TestBookieWatcher
extends BookKeeperClusterTestCase {
    public TestBookieWatcher() {
        super(2);
    }

    private void expireZooKeeperSession(ZooKeeper zk, int timeout) throws IOException, InterruptedException, KeeperException {
        final CountDownLatch latch = new CountDownLatch(1);
        ZooKeeper newZk = new ZooKeeper(this.zkUtil.getZooKeeperConnectString(), timeout, new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    latch.countDown();
                }
            }
        }, zk.getSessionId(), zk.getSessionPasswd());
        if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.CONNECTIONLOSS);
        }
        newZk.close();
    }

    @Test
    public void testBookieWatcherIsBookieUnavailable() throws Exception {
        BookieWatcher bookieWatcher = this.bkc.getBookieWatcher();
        Set writableBookies1 = bookieWatcher.getBookies();
        Set readonlyBookies1 = bookieWatcher.getReadOnlyBookies();
        Assert.assertEquals((String)"There should be writable bookies initially.", (long)2L, (long)writableBookies1.size());
        Assert.assertEquals((String)"There should be no read only bookies initially.", Collections.emptySet(), (Object)readonlyBookies1);
        BookieId bookieId0 = this.getBookie(0);
        BookieId bookieId1 = this.getBookie(1);
        boolean isUnavailable1 = bookieWatcher.isBookieUnavailable(bookieId0);
        Assert.assertFalse((String)"The bookie should not be unavailable.", (boolean)isUnavailable1);
        this.setBookieToReadOnly(bookieId0);
        Set writableBookies2 = bookieWatcher.getBookies();
        Set readonlyBookies2 = bookieWatcher.getReadOnlyBookies();
        Assert.assertEquals((String)"There should be one writable bookie.", Collections.singleton(bookieId1), (Object)writableBookies2);
        Assert.assertEquals((String)"There should be one read only bookie.", Collections.singleton(bookieId0), (Object)readonlyBookies2);
        boolean isUnavailable2 = bookieWatcher.isBookieUnavailable(bookieId0);
        Assert.assertFalse((String)"The bookie should not be unavailable.", (boolean)isUnavailable2);
        this.killBookieAndWaitForZK(0);
        Set writableBookies3 = bookieWatcher.getBookies();
        Set readonlyBookies3 = bookieWatcher.getReadOnlyBookies();
        Assert.assertEquals((String)"There should be one writable bookie.", Collections.singleton(bookieId1), (Object)writableBookies3);
        Assert.assertEquals((String)"There should be no read only bookies.", Collections.emptySet(), (Object)readonlyBookies3);
        boolean isUnavailable3 = bookieWatcher.isBookieUnavailable(bookieId0);
        Assert.assertTrue((String)"The bookie should be unavailable.", (boolean)isUnavailable3);
    }

    @Test
    public void testBookieWatcherSurviveWhenSessionExpired() throws Exception {
        int timeout = 2000;
        try (ZooKeeperClient zk = ZooKeeperClient.newBuilder().connectString(this.zkUtil.getZooKeeperConnectString()).sessionTimeoutMs(2000).build();){
            this.runBookieWatcherWhenSessionExpired((ZooKeeper)zk, 2000, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBookieWatcherDieWhenSessionExpired() throws Exception {
        int timeout = 2000;
        final CountDownLatch connectLatch = new CountDownLatch(1);
        ZooKeeper zk = new ZooKeeper(this.zkUtil.getZooKeeperConnectString(), 2000, new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                if (Watcher.Event.EventType.None == watchedEvent.getType() && Watcher.Event.KeeperState.SyncConnected == watchedEvent.getState()) {
                    connectLatch.countDown();
                }
            }
        });
        try {
            connectLatch.await();
            this.runBookieWatcherWhenSessionExpired(zk, 2000, false);
        }
        finally {
            if (Collections.singletonList(zk).get(0) != null) {
                zk.close();
            }
        }
    }

    private void runBookieWatcherWhenSessionExpired(ZooKeeper zk, int timeout, boolean reconnectable) throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.metadataServiceUri);
        try (BookKeeperTestClient bkc = new BookKeeperTestClient(conf, zk);){
            LedgerHandle lh;
            try {
                lh = bkc.createLedger(3, 2, 2, BookKeeper.DigestType.CRC32, new byte[0]);
                Assert.fail((String)"Should fail to create ledger due to not enough bookies.");
            }
            catch (BKException bKException) {
                // empty catch block
            }
            this.expireZooKeeperSession(bkc.getZkHandle(), timeout);
            TimeUnit.MILLISECONDS.sleep(3 * timeout);
            for (int i = 0; i < 2; ++i) {
                this.startNewBookie();
            }
            TimeUnit.SECONDS.sleep(1L);
            try {
                lh = bkc.createLedger(3, 2, 2, BookKeeper.DigestType.CRC32, new byte[0]);
                lh.close();
                if (!reconnectable) {
                    Assert.fail((String)"Should fail to create ledger due to bookie watcher could not survive after session expire.");
                }
            }
            catch (BKException bke) {
                if (reconnectable) {
                    Assert.fail((String)"Should not fail to create ledger due to bookie watcher could survive after session expire.");
                }
            }
        }
    }
}

