/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.File;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.NullAppender;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdcContextTest
extends BookKeeperClusterTestCase {
    private static final Logger log = LoggerFactory.getLogger(MdcContextTest.class);
    public static final String MDC_REQUEST_ID = "request_id";
    final byte[] entry = "Test Entry".getBytes();
    BookKeeper bkc;
    LedgerHandle lh;
    private NullAppender mockAppender;
    private Queue<String> capturedEvents;

    public MdcContextTest() {
        super(3);
        this.baseConf.setNumAddWorkerThreads(0);
        this.baseConf.setNumReadWorkerThreads(0);
        this.baseConf.setPreserveMdcForTaskExecution(true);
        this.baseConf.setReadOnlyModeEnabled(true);
        this.baseConf.setLedgerStorageClass(InterleavedLedgerStorage.class.getName());
        this.baseConf.setEntryLogFilePreAllocationEnabled(false);
        this.baseConf.setMinUsableSizeForEntryLogCreation(Long.MAX_VALUE);
    }

    public static String mdcFormat(Object mdc, String message) {
        return mdc == null ? "[request_id:] - " + message : "[request_id:" + mdc + "] - " + message;
    }

    public void assertLogWithMdc(String mdc, String msgSubstring) {
        Assert.assertThat(this.capturedEvents, (Matcher)Matchers.hasItem((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("[request_id:" + mdc + "] - ")), Matchers.containsString((String)msgSubstring)})));
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ClientConfiguration conf = new ClientConfiguration();
        ((ClientConfiguration)conf.setReadTimeout(360).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri())).setPreserveMdcForTaskExecution(true);
        ThreadContext.clearMap();
        this.bkc = new BookKeeper(conf);
        ThreadContext.put((String)MDC_REQUEST_ID, (String)"ledger_create");
        log.info("creating ledger");
        this.lh = this.bkc.createLedgerAdv(3, 3, 3, BookKeeper.DigestType.CRC32, new byte[0]);
        ThreadContext.clearMap();
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        this.mockAppender = (NullAppender)Mockito.spy((Object)NullAppender.createAppender((String)UUID.randomUUID().toString()));
        this.mockAppender.start();
        lc.getConfiguration().addAppender((Appender)this.mockAppender);
        lc.getRootLogger().addAppender(lc.getConfiguration().getAppender(this.mockAppender.getName()));
        lc.getConfiguration().getRootLogger().setLevel(Level.INFO);
        lc.updateLoggers();
        this.capturedEvents = new ConcurrentLinkedQueue<String>();
        ((NullAppender)Mockito.doAnswer((Answer)AdditionalAnswers.answerVoid(event -> this.capturedEvents.add(MdcContextTest.mdcFormat(event.getContextData().getValue(MDC_REQUEST_ID), event.getMessage().getFormattedMessage())))).when((Object)this.mockAppender)).append((LogEvent)ArgumentMatchers.any());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.lh.close();
        this.bkc.close();
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        lc.getRootLogger().removeAppender(lc.getConfiguration().getAppender(this.mockAppender.getName()));
        lc.updateLoggers();
        this.capturedEvents = null;
        ThreadContext.clearMap();
        super.tearDown();
    }

    @Test
    public void testLedgerCreateFails() throws Exception {
        ThreadContext.put((String)MDC_REQUEST_ID, (String)"ledger_create_fail");
        try {
            this.bkc.createLedgerAdv(99, 3, 2, BookKeeper.DigestType.CRC32, new byte[0]);
            Assert.fail((String)"should not get here");
        }
        catch (BKException bKException) {
            // empty catch block
        }
        this.assertLogWithMdc("ledger_create_fail", "Not enough bookies to create ledger");
    }

    @Test
    public void testSimpleAdd() throws Exception {
        ThreadContext.put((String)MDC_REQUEST_ID, (String)"ledger_add_entry");
        this.lh.addEntry(0L, this.entry);
        this.assertLogWithMdc("ledger_add_entry", "Successfully connected to bookie");
        this.assertLogWithMdc("ledger_add_entry", "Created new entry log file");
    }

    @Test
    public void testAddWithEnsembleChange() throws Exception {
        this.lh.addEntry(0L, this.entry);
        this.startNewBookie();
        this.killBookie(0);
        ThreadContext.put((String)MDC_REQUEST_ID, (String)"ledger_add_entry");
        this.lh.addEntry(1L, this.entry);
        this.assertLogWithMdc("ledger_add_entry", "Could not connect to bookie");
        this.assertLogWithMdc("ledger_add_entry", "Failed to write entry");
    }

    @Test
    public void testAddFailsWithReadOnlyBookie() throws Exception {
        for (int i = 0; i < 3; ++i) {
            Bookie bookie = this.serverByIndex(i).getBookie();
            File[] ledgerDirs = this.confByIndex(i).getLedgerDirs();
            LedgerDirsManager ledgerDirsManager = ((BookieImpl)bookie).getLedgerDirsManager();
            ledgerDirsManager.addToFilledDirs(new File(ledgerDirs[0], "current"));
        }
        ThreadContext.put((String)MDC_REQUEST_ID, (String)"ledger_add_entry");
        try {
            this.lh.addEntry(0L, this.entry);
            Assert.fail((String)"should not get here");
        }
        catch (BKException bKException) {
            // empty catch block
        }
        this.assertLogWithMdc("ledger_add_entry", "No writable ledger dirs below diskUsageThreshold");
        this.assertLogWithMdc("ledger_add_entry", "All ledger directories are non writable and no reserved space");
        this.assertLogWithMdc("ledger_add_entry", "Error writing entry:0 to ledger:0");
        this.assertLogWithMdc("ledger_add_entry", "Add for failed on bookie");
        this.assertLogWithMdc("ledger_add_entry", "Failed to find 1 bookies");
        this.assertLogWithMdc("ledger_add_entry", "Closing ledger 0 due to NotEnoughBookiesException");
    }

    @Test
    public void testAddFailsDuplicateEntry() throws Exception {
        this.lh.addEntry(0L, this.entry);
        ThreadContext.put((String)MDC_REQUEST_ID, (String)"ledger_add_duplicate_entry");
        try {
            this.lh.addEntry(0L, this.entry);
            Assert.fail((String)"should not get here");
        }
        catch (BKException bKException) {
            // empty catch block
        }
        this.assertLogWithMdc("ledger_add_duplicate_entry", "Trying to re-add duplicate entryid:0");
        this.assertLogWithMdc("ledger_add_duplicate_entry", "Write of ledger entry to quorum failed");
    }

    @Test
    public void testReadEntryBeyondLac() throws Exception {
        ThreadContext.put((String)MDC_REQUEST_ID, (String)"ledger_read_entry");
        try {
            this.lh.readEntries(100L, 100L);
            Assert.fail((String)"should not get here");
        }
        catch (BKException.BKReadException bKReadException) {
            // empty catch block
        }
        this.assertLogWithMdc("ledger_read_entry", "ReadEntries exception on ledgerId:0 firstEntry:100 lastEntry:100");
    }

    @Test
    public void testReadFromDeletedLedger() throws Exception {
        this.lh.addEntry(0L, this.entry);
        this.lh.close();
        this.bkc.deleteLedger(this.lh.ledgerId);
        ThreadContext.put((String)MDC_REQUEST_ID, (String)"ledger_read_entry");
        try {
            this.lh.readEntries(100L, 100L);
            Assert.fail((String)"should not get here");
        }
        catch (BKException.BKReadException bKReadException) {
            // empty catch block
        }
        this.assertLogWithMdc("ledger_read_entry", "ReadEntries exception on ledgerId:0 firstEntry:100 lastEntry:100");
    }
}

