/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.Iterator;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;

public class ListLedgersTest
extends BookKeeperClusterTestCase {
    private final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    public ListLedgersTest() {
        super(4);
    }

    @Test
    public void testListLedgers() throws Exception {
        int numOfLedgers = 10;
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkc = new BookKeeper(conf);
        for (int i = 0; i < numOfLedgers; ++i) {
            bkc.createLedger(this.digestType, "testPasswd".getBytes()).close();
        }
        BookKeeperAdmin admin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());
        Iterable iterable = admin.listLedgers();
        int counter = 0;
        for (Long lId : iterable) {
            ++counter;
        }
        Assert.assertTrue((String)("Wrong number of ledgers: " + numOfLedgers), (counter == numOfLedgers ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyList() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeperAdmin admin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());
        Iterable iterable = admin.listLedgers();
        Assert.assertFalse((String)"There should be no ledger", (boolean)iterable.iterator().hasNext());
    }

    @Test
    public void testRemoveNotSupported() throws Exception {
        int numOfLedgers = 1;
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkc = new BookKeeper(conf);
        for (int i = 0; i < numOfLedgers; ++i) {
            bkc.createLedger(this.digestType, "testPasswd".getBytes()).close();
        }
        BookKeeperAdmin admin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());
        Iterator iterator = admin.listLedgers().iterator();
        iterator.next();
        try {
            iterator.remove();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assert.fail((String)"Remove is not supported, we shouln't have reached this point");
    }
}

