/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.bookkeeper.bookie.BookieAccessor;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.EntryFormatter;
import org.apache.bookkeeper.util.LedgerIdFormatter;
import org.apache.commons.configuration.CompositeConfiguration;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerCmdTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerCmdTest.class);
    private BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    private static final String PASSWORD = "testPasswd";

    public LedgerCmdTest() {
        super(1);
        this.baseConf.setLedgerStorageClass(DbLedgerStorage.class.getName());
        this.baseConf.setGcWaitTime(60000L);
        this.baseConf.setFlushInterval(1);
    }

    @Test
    public void testLedgerDbStorageCmd() throws Exception {
        BookKeeper bk = new BookKeeper(this.baseClientConf, this.zkc);
        LOG.info("Create ledger and add entries to it");
        LedgerHandle lh1 = this.createLedgerWithEntries(bk, 10);
        for (int i = 0; i < this.bookieCount(); ++i) {
            BookieAccessor.forceFlush((BookieImpl)this.serverByIndex(i).getBookie());
        }
        String[] argv = new String[]{"ledger", Long.toString(lh1.getId())};
        ServerConfiguration conf = this.confByIndex(0);
        conf.setUseHostNameAsBookieID(true);
        BookieShell bkShell = new BookieShell(LedgerIdFormatter.LONG_LEDGERID_FORMATTER, EntryFormatter.STRING_FORMATTER);
        bkShell.setConf((CompositeConfiguration)conf);
        TestCase.assertEquals((String)"Failed to return exit code!", (int)0, (int)bkShell.run(argv));
    }

    private LedgerHandle createLedgerWithEntries(BookKeeper bk, int numOfEntries) throws Exception {
        LedgerHandle lh = bk.createLedger(1, 1, this.digestType, PASSWORD.getBytes());
        final AtomicInteger rc = new AtomicInteger(0);
        final CountDownLatch latch = new CountDownLatch(numOfEntries);
        AsyncCallback.AddCallback cb = new AsyncCallback.AddCallback(){

            public void addComplete(int rccb, LedgerHandle lh, long entryId, Object ctx) {
                rc.compareAndSet(0, rccb);
                latch.countDown();
            }
        };
        for (int i = 0; i < numOfEntries; ++i) {
            lh.asyncAddEntry(("foobar" + i).getBytes(), cb, null);
        }
        if (!latch.await(30L, TimeUnit.SECONDS)) {
            throw new Exception("Entries took too long to add");
        }
        if (rc.get() != 0) {
            throw BKException.create((int)rc.get());
        }
        return lh;
    }
}

