/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.meta.zk.ZKMetadataClientDriver;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperTestClient
extends BookKeeper {
    private static final Logger log = LoggerFactory.getLogger(BookKeeperTestClient.class);
    TestStatsProvider statsProvider;

    public BookKeeperTestClient(ClientConfiguration conf, TestStatsProvider statsProvider) throws IOException, InterruptedException, BKException {
        super(conf, null, null, (ByteBufAllocator)new UnpooledByteBufAllocator(false), (StatsLogger)(statsProvider == null ? NullStatsLogger.INSTANCE : statsProvider.getStatsLogger("")), null, null, null);
        this.statsProvider = statsProvider;
    }

    public BookKeeperTestClient(ClientConfiguration conf, ZooKeeper zkc) throws IOException, InterruptedException, BKException {
        super(conf, zkc, null, (ByteBufAllocator)new UnpooledByteBufAllocator(false), (StatsLogger)NullStatsLogger.INSTANCE, null, null, null);
        this.statsProvider = this.statsProvider;
    }

    public BookKeeperTestClient(ClientConfiguration conf) throws InterruptedException, BKException, IOException {
        this(conf, (TestStatsProvider)null);
    }

    public ZooKeeper getZkHandle() {
        return ((ZKMetadataClientDriver)this.metadataDriver).getZk();
    }

    public ClientConfiguration getConf() {
        return super.getConf();
    }

    public BookieClient getBookieClient() {
        return this.bookieClient;
    }

    public Future<?> waitForReadOnlyBookie(BookieId b) throws Exception {
        return this.waitForBookieInSet(b, false);
    }

    public Future<?> waitForWritableBookie(BookieId b) throws Exception {
        return this.waitForBookieInSet(b, true);
    }

    private Future<?> waitForBookieInSet(BookieId b, boolean writable) throws Exception {
        log.info("Wait for {} to become {}", (Object)b, (Object)(writable ? "writable" : "readonly"));
        CompletableFuture readOnlyFuture = new CompletableFuture();
        CompletableFuture writableFuture = new CompletableFuture();
        RegistrationClient.RegistrationListener readOnlyListener = bookies -> {
            boolean contains = ((Set)bookies.getValue()).contains(b);
            if (!writable && contains || writable && !contains) {
                readOnlyFuture.complete(null);
            }
        };
        RegistrationClient.RegistrationListener writableListener = bookies -> {
            boolean contains = ((Set)bookies.getValue()).contains(b);
            if (writable && contains || !writable && !contains) {
                writableFuture.complete(null);
            }
        };
        this.getMetadataClientDriver().getRegistrationClient().watchWritableBookies(writableListener);
        this.getMetadataClientDriver().getRegistrationClient().watchReadOnlyBookies(readOnlyListener);
        if (writable) {
            return ((CompletableFuture)writableFuture.thenCompose(ignored -> this.getMetadataClientDriver().getRegistrationClient().getReadOnlyBookies())).thenCompose(readonlyBookies -> {
                if (((Set)readonlyBookies.getValue()).contains(b)) {
                    return readOnlyFuture;
                }
                return FutureUtils.Void();
            });
        }
        return ((CompletableFuture)readOnlyFuture.thenCompose(ignored -> this.getMetadataClientDriver().getRegistrationClient().getWritableBookies())).thenCompose(writableBookies -> {
            if (((Set)writableBookies.getValue()).contains(b)) {
                return writableFuture;
            }
            return FutureUtils.Void();
        });
    }

    public TestStatsProvider getTestStatsProvider() {
        return this.statsProvider;
    }
}

