/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={LedgersIndexRebuildTest.class, MetadataDrivers.class})
public class LedgersIndexRebuildTest {
    private final BookieId bookieAddress = BookieId.parse((String)UUID.randomUUID().toString());
    private ServerConfiguration conf;
    private File tmpDir;

    @Before
    public void setUp() throws IOException {
        this.tmpDir = File.createTempFile("bkTest", ".dir");
        this.tmpDir.delete();
        this.tmpDir.mkdir();
        File curDir = BookieImpl.getCurrentDirectory((File)this.tmpDir);
        BookieImpl.checkDirectoryStructure((File)curDir);
        System.out.println(this.tmpDir);
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.forceDelete((File)this.tmpDir);
    }

    @Test
    public void testRebuildIncludesAllLedgersAndSetToFenced() throws Exception {
        byte[] masterKey = "12345".getBytes();
        long ledgerCount = 100L;
        DbLedgerStorage ledgerStorage = this.setupLedgerStorage();
        for (long ledgerId = 0L; ledgerId < ledgerCount; ++ledgerId) {
            ledgerStorage.setMasterKey(ledgerId, masterKey);
            for (long entryId = 0L; entryId < 2L; ++entryId) {
                ByteBuf entry = Unpooled.buffer((int)128);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId);
                entry.writeBytes(("entry-" + entryId).getBytes());
                ledgerStorage.addEntry(entry);
            }
        }
        ledgerStorage.flush();
        ledgerStorage.shutdown();
        BookieShell shell = new BookieShell();
        shell.setConf((CompositeConfiguration)this.conf);
        int res = shell.run(new String[]{"rebuild-db-ledgers-index", "-v"});
        Assert.assertEquals((long)0L, (long)res);
        ledgerStorage = new DbLedgerStorage();
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(this.conf, this.conf.getLedgerDirs(), new DiskChecker(this.conf.getDiskUsageThreshold(), this.conf.getDiskUsageWarnThreshold()));
        ledgerStorage.initialize(this.conf, null, ledgerDirsManager, ledgerDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        for (long ledgerId = 0L; ledgerId < ledgerCount; ++ledgerId) {
            Assert.assertTrue((boolean)ledgerStorage.ledgerExists(ledgerId));
            Assert.assertTrue((boolean)ledgerStorage.isFenced(ledgerId));
        }
        ledgerStorage.shutdown();
    }

    private DbLedgerStorage setupLedgerStorage() throws Exception {
        this.conf = TestBKConfiguration.newServerConfiguration();
        this.conf.setBookieId(this.bookieAddress.getId());
        this.conf.setLedgerDirNames(new String[]{this.tmpDir.toString()});
        this.conf.setLedgerStorageClass(DbLedgerStorage.class.getName());
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(this.conf, this.conf.getLedgerDirs(), new DiskChecker(this.conf.getDiskUsageThreshold(), this.conf.getDiskUsageWarnThreshold()));
        PowerMockito.whenNew(ServerConfiguration.class).withNoArguments().thenReturn((Object)this.conf);
        PowerMockito.whenNew(BookieId.class).withParameterTypes(String.class, new Class[0]).withArguments((Object)ArgumentMatchers.anyString(), new Object[0]).thenReturn((Object)this.bookieAddress);
        DbLedgerStorage ledgerStorage = new DbLedgerStorage();
        ledgerStorage.initialize(this.conf, null, ledgerDirsManager, ledgerDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        return ledgerStorage;
    }
}

