/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.shaded.com.google.common.collect.Sets;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionRollbackTest {
    private static final Logger log = LoggerFactory.getLogger(ConversionRollbackTest.class);
    CheckpointSource checkpointSource = new CheckpointSource(){

        public CheckpointSource.Checkpoint newCheckpoint() {
            return CheckpointSource.Checkpoint.MAX;
        }

        public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
        }
    };
    Checkpointer checkpointer = new Checkpointer(){

        public void startCheckpoint(CheckpointSource.Checkpoint checkpoint) {
        }

        public void start() {
        }
    };

    @Test
    public void convertFromDbStorageToInterleaved() throws Exception {
        File tmpDir = File.createTempFile("bkTest", ".dir");
        tmpDir.delete();
        tmpDir.mkdir();
        File curDir = BookieImpl.getCurrentDirectory((File)tmpDir);
        BookieImpl.checkDirectoryStructure((File)curDir);
        log.info("Using temp directory: {}", (Object)tmpDir);
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setLedgerDirNames(new String[]{tmpDir.toString()});
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
        DbLedgerStorage dbStorage = new DbLedgerStorage();
        dbStorage.initialize(conf, null, ledgerDirsManager, ledgerDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        dbStorage.setCheckpointer(this.checkpointer);
        dbStorage.setCheckpointSource(this.checkpointSource);
        for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
            dbStorage.setMasterKey(ledgerId, ("ledger-" + ledgerId).getBytes());
            dbStorage.setFenced(ledgerId);
            for (long entryId = 0L; entryId < 10000L; ++entryId) {
                ByteBuf entry = Unpooled.buffer((int)128);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId);
                entry.writeBytes(("entry-" + entryId).getBytes());
                dbStorage.addEntry(entry);
            }
        }
        dbStorage.flush();
        dbStorage.shutdown();
        BookieShell shell = new BookieShell();
        shell.setConf((CompositeConfiguration)conf);
        int res = shell.run(new String[]{"convert-to-interleaved-storage"});
        Assert.assertEquals((long)0L, (long)res);
        InterleavedLedgerStorage interleavedStorage = new InterleavedLedgerStorage();
        interleavedStorage.initialize(conf, null, ledgerDirsManager, ledgerDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        interleavedStorage.setCheckpointSource(this.checkpointSource);
        interleavedStorage.setCheckpointer(this.checkpointer);
        TreeSet ledgers = Sets.newTreeSet((Iterable)interleavedStorage.getActiveLedgersInRange(0L, Long.MAX_VALUE));
        Assert.assertEquals((Object)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new Long[]{0L, 1L, 2L, 3L, 4L})), (Object)ledgers);
        for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
            Assert.assertEquals((Object)true, (Object)interleavedStorage.isFenced(ledgerId));
            Assert.assertEquals((Object)("ledger-" + ledgerId), (Object)new String(interleavedStorage.readMasterKey(ledgerId)));
            for (long entryId = 0L; entryId < 10000L; ++entryId) {
                ByteBuf entry = Unpooled.buffer((int)1024);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId);
                entry.writeBytes(("entry-" + entryId).getBytes());
                ByteBuf result = interleavedStorage.getEntry(ledgerId, entryId);
                Assert.assertEquals((Object)entry, (Object)result);
            }
        }
        interleavedStorage.shutdown();
        FileUtils.forceDelete((File)tmpDir);
    }
}

