/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.datainteg;

import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.datainteg.MetadataAsyncIterator;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.MockLedgerManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.versioning.Versioned;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataAsyncIteratorTest {
    private static Logger log = LoggerFactory.getLogger(MetadataAsyncIteratorTest.class);

    private LedgerMetadata newRandomMetadata(long randBit) throws Exception {
        return LedgerMetadataBuilder.create().withId(1L).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(1).withWriteQuorumSize(1).withAckQuorumSize(1).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{BookieId.parse((String)("foobar-" + randBit + ":3181"))})).build();
    }

    private ConcurrentHashMap<Long, LedgerMetadata> addLedgers(LedgerManager lm, int count) throws Exception {
        ConcurrentHashMap<Long, LedgerMetadata> added = new ConcurrentHashMap<Long, LedgerMetadata>();
        for (long i = 0L; i < (long)count; ++i) {
            LedgerMetadata metadata = this.newRandomMetadata(i);
            lm.createLedgerMetadata(i, metadata).get();
            added.put(i, metadata);
        }
        return added;
    }

    private static CompletableFuture<Void> removeFromMap(ConcurrentHashMap<Long, LedgerMetadata> map, long ledgerId, LedgerMetadata metadata) {
        log.debug("removing ledger {}", (Object)ledgerId);
        if (map.remove(ledgerId, metadata)) {
            return CompletableFuture.completedFuture(null);
        }
        log.debug("ledger {} already removed", (Object)ledgerId);
        return FutureUtils.exception((Throwable)new Exception("ledger already removed"));
    }

    @Test
    public void testIteratorOverAll() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ConcurrentHashMap<Long, LedgerMetadata> added = this.addLedgers(lm, 10000);
        MetadataAsyncIterator iterator = new MetadataAsyncIterator(Schedulers.io(), (LedgerManager)lm, 100, 3, TimeUnit.SECONDS);
        iterator.forEach((ledgerId, metadata) -> MetadataAsyncIteratorTest.removeFromMap(added, ledgerId, metadata)).get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)added.isEmpty(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testSingleLedger() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        LedgerMetadata single = this.newRandomMetadata(-559038737L);
        MetadataAsyncIterator iterator = new MetadataAsyncIterator(Schedulers.io(), (LedgerManager)lm, 100, 3, TimeUnit.SECONDS);
        iterator.forEach((ledgerId, metadata) -> {
            if (ledgerId == -559038737L && metadata.equals(single)) {
                return CompletableFuture.completedFuture(null);
            }
            return FutureUtils.exception((Throwable)new Exception("Unexpected metadata"));
        }).get(10L, TimeUnit.SECONDS);
    }

    @Test
    public void testEmptyRange() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        MetadataAsyncIterator iterator = new MetadataAsyncIterator(Schedulers.io(), (LedgerManager)lm, 100, 3, TimeUnit.SECONDS);
        iterator.forEach((ledgerId, metadata) -> FutureUtils.exception((Throwable)new Exception("Should be empty"))).get(10L, TimeUnit.SECONDS);
    }

    @Test
    public void testOneLedgerErrorsOnRead() throws Exception {
        MockLedgerManager lm = new MockLedgerManager(){

            @Override
            public CompletableFuture<Versioned<LedgerMetadata>> readLedgerMetadata(long ledgerId) {
                if (ledgerId == 403L) {
                    return FutureUtils.exception((Throwable)new BKException.ZKException());
                }
                return super.readLedgerMetadata(ledgerId);
            }
        };
        ConcurrentHashMap<Long, LedgerMetadata> added = this.addLedgers(lm, 10000);
        MetadataAsyncIterator iterator = new MetadataAsyncIterator(Schedulers.io(), (LedgerManager)lm, 100, 3, TimeUnit.SECONDS);
        try {
            iterator.forEach((ledgerId, metadata) -> MetadataAsyncIteratorTest.removeFromMap(added, ledgerId, metadata)).get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException ee) {
            MatcherAssert.assertThat((Object)ee.getCause(), (Matcher)Matchers.instanceOf(BKException.ZKException.class));
        }
    }

    @Test
    public void testOneLedgerErrorsOnProcessing() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ConcurrentHashMap<Long, LedgerMetadata> added = this.addLedgers(lm, 10000);
        MetadataAsyncIterator iterator = new MetadataAsyncIterator(Schedulers.io(), (LedgerManager)lm, 100, 3, TimeUnit.SECONDS);
        try {
            iterator.forEach((ledgerId, metadata) -> {
                if (ledgerId == 403L) {
                    log.info("IKDEBUG erroring");
                    return FutureUtils.exception((Throwable)new Exception("foobar"));
                }
                return CompletableFuture.completedFuture(null);
            }).get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"shouldn't succeed");
        }
        catch (ExecutionException ee) {
            MatcherAssert.assertThat((Object)ee.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"foobar"));
        }
    }

    @Test
    public void testAllLedgersErrorOnRead() throws Exception {
        MockLedgerManager lm = new MockLedgerManager(){

            @Override
            public CompletableFuture<Versioned<LedgerMetadata>> readLedgerMetadata(long ledgerId) {
                CompletableFuture<Versioned<LedgerMetadata>> promise = new CompletableFuture<Versioned<LedgerMetadata>>();
                promise.completeExceptionally((Throwable)new BKException.ZKException());
                return promise;
            }
        };
        ConcurrentHashMap<Long, LedgerMetadata> added = this.addLedgers(lm, 10000);
        MetadataAsyncIterator iterator = new MetadataAsyncIterator(Schedulers.io(), (LedgerManager)lm, 100, 3, TimeUnit.SECONDS);
        try {
            iterator.forEach((ledgerId, metadata) -> CompletableFuture.completedFuture(null)).get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException ee) {
            MatcherAssert.assertThat((Object)ee.getCause(), (Matcher)Matchers.instanceOf(BKException.ZKException.class));
        }
    }

    @Test
    public void testAllLedgersErrorOnProcessing() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ConcurrentHashMap<Long, LedgerMetadata> added = this.addLedgers(lm, 10000);
        MetadataAsyncIterator iterator = new MetadataAsyncIterator(Schedulers.io(), (LedgerManager)lm, 100, 3, TimeUnit.SECONDS);
        try {
            iterator.forEach((ledgerId, metadata) -> FutureUtils.exception((Throwable)new Exception("foobar"))).get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"shouldn't succeed");
        }
        catch (ExecutionException ee) {
            MatcherAssert.assertThat((Object)ee.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"foobar"));
        }
    }

    @Test
    public void testOneLedgerDisappearsBetweenListAndRead() throws Exception {
        MockLedgerManager lm = new MockLedgerManager(){

            @Override
            public CompletableFuture<Versioned<LedgerMetadata>> readLedgerMetadata(long ledgerId) {
                if (ledgerId == 501L) {
                    CompletableFuture<Versioned<LedgerMetadata>> promise = new CompletableFuture<Versioned<LedgerMetadata>>();
                    promise.completeExceptionally((Throwable)new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
                    return promise;
                }
                return super.readLedgerMetadata(ledgerId);
            }
        };
        ConcurrentHashMap<Long, LedgerMetadata> added = this.addLedgers(lm, 10000);
        MetadataAsyncIterator iterator = new MetadataAsyncIterator(Schedulers.io(), (LedgerManager)lm, 100, 3, TimeUnit.SECONDS);
        iterator.forEach((ledgerId, metadata) -> MetadataAsyncIteratorTest.removeFromMap(added, ledgerId, metadata)).get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)added.size(), (Matcher)Matchers.equalTo((Object)1));
        log.info("IKDEBUG {} {}", added, (Object)added.containsKey(5L));
        MatcherAssert.assertThat((Object)added.containsKey(501L), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testEverySecondLedgerDisappearsBetweenListAndRead() throws Exception {
        MockLedgerManager lm = new MockLedgerManager(){

            @Override
            public CompletableFuture<Versioned<LedgerMetadata>> readLedgerMetadata(long ledgerId) {
                if (ledgerId % 2L == 0L) {
                    return FutureUtils.exception((Throwable)new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
                }
                return super.readLedgerMetadata(ledgerId);
            }
        };
        int numLedgers = 10000;
        ConcurrentHashMap<Long, LedgerMetadata> added = this.addLedgers(lm, numLedgers);
        MetadataAsyncIterator iterator = new MetadataAsyncIterator(Schedulers.io(), (LedgerManager)lm, 100, 3, TimeUnit.SECONDS);
        iterator.forEach((ledgerId, metadata) -> MetadataAsyncIteratorTest.removeFromMap(added, ledgerId, metadata)).get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)added.size(), (Matcher)Matchers.equalTo((Object)(numLedgers / 2)));
        MatcherAssert.assertThat((Object)added.keySet().stream().allMatch(k -> k % 2L == 0L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)added.keySet().stream().noneMatch(k -> k % 2L == 1L), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testEveryLedgerDisappearsBetweenListAndRead() throws Exception {
        MockLedgerManager lm = new MockLedgerManager(){

            @Override
            public CompletableFuture<Versioned<LedgerMetadata>> readLedgerMetadata(long ledgerId) {
                return FutureUtils.exception((Throwable)new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
            }
        };
        int numLedgers = 10000;
        ConcurrentHashMap<Long, LedgerMetadata> added = this.addLedgers(lm, numLedgers);
        MetadataAsyncIterator iterator = new MetadataAsyncIterator(Schedulers.io(), (LedgerManager)lm, 100, 3, TimeUnit.SECONDS);
        iterator.forEach((ledgerId, metadata) -> MetadataAsyncIteratorTest.removeFromMap(added, ledgerId, metadata)).get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)added.size(), (Matcher)Matchers.equalTo((Object)numLedgers));
    }

    @Test
    public void testMaxOutInFlight() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        int numLedgers = 1000;
        ConcurrentHashMap<Long, LedgerMetadata> added = this.addLedgers(lm, numLedgers);
        MetadataAsyncIterator iterator = new MetadataAsyncIterator(Schedulers.io(), (LedgerManager)lm, 10, 3, TimeUnit.SECONDS);
        CompletableFuture<Object> blocker = new CompletableFuture<Object>();
        CompletableFuture iterFuture = iterator.forEach((ledgerId, metadata) -> blocker.thenCompose(ignore -> MetadataAsyncIteratorTest.removeFromMap(added, ledgerId, metadata)));
        MatcherAssert.assertThat((Object)iterFuture.isDone(), (Matcher)Matchers.equalTo((Object)false));
        blocker.complete(null);
        iterFuture.get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)added.isEmpty(), (Matcher)Matchers.equalTo((Object)true));
    }
}

