/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.datainteg;

import io.netty.buffer.ByteBuf;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.observers.TestObserver;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.MockLedgerStorage;
import org.apache.bookkeeper.bookie.datainteg.DataIntegrityCheckImpl;
import org.apache.bookkeeper.bookie.datainteg.EntryCopier;
import org.apache.bookkeeper.bookie.datainteg.EntryCopierImpl;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.MockTicker;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.MockLedgerManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.MockBookieClient;
import org.apache.bookkeeper.shaded.com.google.common.base.Ticker;
import org.apache.bookkeeper.shaded.com.google.common.collect.ImmutableMap;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.shaded.com.google.common.collect.Sets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DataIntegrityCheckTest {
    private static final byte[] PASSWD = new byte[0];
    private final BookieId bookie1 = BookieId.parse((String)"bookie1:3181");
    private final BookieId bookie2 = BookieId.parse((String)"bookie2:3181");
    private final BookieId bookie3 = BookieId.parse((String)"bookie3:3181");
    private final BookieId bookie4 = BookieId.parse((String)"bookie4:3181");
    private final BookieId bookie5 = BookieId.parse((String)"bookie5:3181");
    private OrderedExecutor executor = null;

    @Before
    public void setup() throws Exception {
        this.executor = OrderedExecutor.newBuilder().numThreads(1).name("test").build();
    }

    @After
    public void teardown() throws Exception {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    private static ServerConfiguration serverConf() {
        ServerConfiguration conf = new ServerConfiguration();
        conf.setAdvertisedAddress("foobar");
        return conf;
    }

    private LedgerMetadataBuilder newMetadataWithEnsemble(long ledgerId, BookieId ... bookies) {
        return LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(bookies.length).withWriteQuorumSize(bookies.length).withAckQuorumSize(bookies.length).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])bookies));
    }

    private LedgerMetadataBuilder newClosedMetadataWithEnsemble(long ledgerId, long numEntries, BookieId ... bookies) {
        return LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(bookies.length).withWriteQuorumSize(bookies.length).withAckQuorumSize(bookies.length).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])bookies)).withLastEntryId(numEntries - 1L).withLength(128L * numEntries).withClosedState();
    }

    @Test
    public void testPrebootBookieIdInOpenSegmentMarkedInLimbo() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        lm.createLedgerMetadata(48879L, this.newMetadataWithEnsemble(48879L, bookieId).build()).get();
        MockLedgerStorage storage = new MockLedgerStorage();
        MatcherAssert.assertThat((Object)storage.ledgerExists(48879L), (Matcher)Matchers.is((Object)false));
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(BookieImpl.getBookieId((ServerConfiguration)conf), (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)Mockito.mock(EntryCopier.class), (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        impl.runPreBootCheck("test").get();
        MatcherAssert.assertThat((Object)storage.hasLimboState(48879L), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)storage.isFenced(48879L), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testPrebootFencedMarkedInLimbo() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        lm.createLedgerMetadata(48879L, this.newMetadataWithEnsemble(48879L, BookieImpl.getBookieId((ServerConfiguration)conf)).withInRecoveryState().build()).get();
        MockLedgerStorage storage = new MockLedgerStorage();
        MatcherAssert.assertThat((Object)storage.ledgerExists(48879L), (Matcher)Matchers.is((Object)false));
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(bookieId, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)Mockito.mock(EntryCopier.class), (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        impl.runPreBootCheck("test").get();
        MatcherAssert.assertThat((Object)storage.hasLimboState(48879L), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)storage.isFenced(48879L), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testPrebootClosedNotMarkedInLimbo() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        lm.createLedgerMetadata(48879L, this.newMetadataWithEnsemble(48879L, BookieImpl.getBookieId((ServerConfiguration)conf)).withClosedState().withLength(100L).withLastEntryId(1L).build()).get();
        MockLedgerStorage storage = new MockLedgerStorage();
        MatcherAssert.assertThat((Object)storage.ledgerExists(48879L), (Matcher)Matchers.is((Object)false));
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(bookieId, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)Mockito.mock(EntryCopier.class), (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        impl.runPreBootCheck("test").get();
        MatcherAssert.assertThat((Object)storage.hasLimboState(48879L), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)storage.isFenced(48879L), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testPrebootFlushCalled() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        lm.createLedgerMetadata(48879L, this.newMetadataWithEnsemble(48879L, BookieImpl.getBookieId((ServerConfiguration)conf)).build()).get();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        MatcherAssert.assertThat((Object)storage.ledgerExists(48879L), (Matcher)Matchers.is((Object)false));
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(bookieId, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)Mockito.mock(EntryCopier.class), (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)0))).flush();
        impl.runPreBootCheck("test").get();
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)1))).flush();
        MatcherAssert.assertThat((Object)storage.hasLimboState(48879L), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)storage.isFenced(48879L), (Matcher)Matchers.is((Object)true));
    }

    @Test(expected=ExecutionException.class)
    public void testFailureInPrebootMarkFailsAll() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        lm.createLedgerMetadata(48877L, this.newMetadataWithEnsemble(48877L, bookieId).build()).get();
        lm.createLedgerMetadata(48879L, this.newMetadataWithEnsemble(48879L, bookieId).build()).get();
        lm.createLedgerMetadata(48864L, this.newMetadataWithEnsemble(48864L, bookieId).build()).get();
        MockLedgerStorage storage = new MockLedgerStorage(){

            @Override
            public void setLimboState(long ledgerId) throws IOException {
                if (ledgerId == 48879L) {
                    throw new IOException("boom!");
                }
                super.setLimboState(ledgerId);
            }
        };
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(bookieId, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)Mockito.mock(EntryCopier.class), (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        impl.runPreBootCheck("test").get();
    }

    @Test
    public void testRecoverLimboOpensAndClears() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        final BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(bookieId, lm, storage, (EntryCopier)Mockito.mock(EntryCopier.class), (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io()){

            Single<LedgerMetadata> recoverLedger(long ledgerId, String runId) {
                return Single.just((Object)DataIntegrityCheckTest.this.newClosedMetadataWithEnsemble(ledgerId, -1L, new BookieId[]{bookieId, DataIntegrityCheckTest.this.bookie1}).build());
            }
        };
        HashMap<Long, LedgerMetadata> ledgers = new HashMap<Long, LedgerMetadata>();
        ledgers.put(3840L, this.newMetadataWithEnsemble(3840L, bookieId, this.bookie1).build());
        storage.setMasterKey(3840L, PASSWD);
        storage.setLimboState(3840L);
        ledgers.put(57005L, this.newMetadataWithEnsemble(57005L, bookieId, this.bookie1).build());
        storage.setMasterKey(57005L, PASSWD);
        storage.setLimboState(57005L);
        Set results = (Set)impl.checkAndRecoverLedgers(ledgers, "test").get();
        MatcherAssert.assertThat((Object)results.stream().filter(r -> r.isOK()).count(), (Matcher)Matchers.equalTo((Object)2L));
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)1))).clearLimboState(3840L);
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)1))).clearLimboState(57005L);
    }

    @Test
    public void testRecoverLimboErrorOnOpenOnlyAffectsThatOne() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        final BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(bookieId, lm, storage, (EntryCopier)Mockito.mock(EntryCopier.class), (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io()){

            Single<LedgerMetadata> recoverLedger(long ledgerId, String runId) {
                if (ledgerId == 3840L) {
                    return Single.error((Throwable)new BKException.BKReadException());
                }
                return Single.just((Object)DataIntegrityCheckTest.this.newClosedMetadataWithEnsemble(ledgerId, 0L, new BookieId[]{bookieId, DataIntegrityCheckTest.this.bookie1}).build());
            }
        };
        HashMap<Long, LedgerMetadata> ledgers = new HashMap<Long, LedgerMetadata>();
        ledgers.put(3840L, this.newMetadataWithEnsemble(3840L, bookieId, this.bookie1).build());
        storage.setMasterKey(3840L, PASSWD);
        storage.setLimboState(3840L);
        ledgers.put(57005L, this.newMetadataWithEnsemble(57005L, bookieId, this.bookie1).build());
        storage.setMasterKey(57005L, PASSWD);
        storage.setLimboState(57005L);
        Set results = (Set)impl.checkAndRecoverLedgers(ledgers, "test").get();
        MatcherAssert.assertThat((Object)results.stream().filter(r -> r.isOK()).count(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)results.stream().filter(r -> r.isOK()).map(r -> r.getLedgerId()).findFirst().get(), (Matcher)Matchers.equalTo((Object)57005L));
        MatcherAssert.assertThat((Object)results.stream().filter(r -> r.isError()).count(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)results.stream().filter(r -> r.isError()).map(r -> r.getLedgerId()).findFirst().get(), (Matcher)Matchers.equalTo((Object)3840L));
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)0))).clearLimboState(3840L);
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)1))).clearLimboState(57005L);
    }

    @Test
    public void testRecoverLimboNoSuchLedger() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        final BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(bookieId, lm, storage, (EntryCopier)Mockito.mock(EntryCopier.class), (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io()){

            Single<LedgerMetadata> recoverLedger(long ledgerId, String runId) {
                if (ledgerId == 57005L) {
                    return Single.error((Throwable)new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
                }
                return Single.just((Object)DataIntegrityCheckTest.this.newClosedMetadataWithEnsemble(ledgerId, -1L, new BookieId[]{bookieId, DataIntegrityCheckTest.this.bookie1}).build());
            }
        };
        HashMap<Long, LedgerMetadata> ledgers = new HashMap<Long, LedgerMetadata>();
        ledgers.put(3840L, this.newMetadataWithEnsemble(3840L, bookieId, this.bookie1).build());
        storage.setMasterKey(3840L, PASSWD);
        storage.setLimboState(3840L);
        ledgers.put(57005L, this.newMetadataWithEnsemble(57005L, bookieId, this.bookie1).build());
        storage.setMasterKey(57005L, PASSWD);
        storage.setLimboState(57005L);
        Set results = (Set)impl.checkAndRecoverLedgers(ledgers, "test").get();
        MatcherAssert.assertThat((Object)results.stream().filter(r -> r.isOK()).count(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)results.stream().filter(r -> r.isOK()).map(r -> r.getLedgerId()).findFirst().get(), (Matcher)Matchers.equalTo((Object)3840L));
        MatcherAssert.assertThat((Object)results.stream().filter(r -> r.isMissing()).count(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)results.stream().filter(r -> r.isMissing()).map(r -> r.getLedgerId()).findFirst().get(), (Matcher)Matchers.equalTo((Object)57005L));
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)1))).clearLimboState(3840L);
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)0))).clearLimboState(57005L);
    }

    @Test
    public void testRecoverLimboClearStateFailure() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        final BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage(){

            @Override
            public void clearLimboState(long ledgerId) throws IOException {
                if (ledgerId == 3840L) {
                    throw new IOException("foobar");
                }
            }
        });
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(bookieId, lm, storage, (EntryCopier)Mockito.mock(EntryCopier.class), (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io()){

            Single<LedgerMetadata> recoverLedger(long ledgerId, String runId) {
                return Single.just((Object)DataIntegrityCheckTest.this.newClosedMetadataWithEnsemble(ledgerId, -1L, new BookieId[]{bookieId, DataIntegrityCheckTest.this.bookie1}).build());
            }
        };
        HashMap<Long, LedgerMetadata> ledgers = new HashMap<Long, LedgerMetadata>();
        ledgers.put(3840L, this.newMetadataWithEnsemble(3840L, bookieId, this.bookie1).build());
        storage.setMasterKey(3840L, PASSWD);
        storage.setLimboState(3840L);
        ledgers.put(57005L, this.newMetadataWithEnsemble(57005L, bookieId, this.bookie1).build());
        storage.setMasterKey(57005L, PASSWD);
        storage.setLimboState(57005L);
        Set results = (Set)impl.checkAndRecoverLedgers(ledgers, "test").get();
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)0))).flush();
    }

    @Test
    public void testRecoverLimboManyLedgers() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        final BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        final ArrayList cleared = new ArrayList();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage(){

            @Override
            public void clearLimboState(long ledgerId) {
                cleared.add(ledgerId);
            }
        });
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(bookieId, lm, storage, (EntryCopier)Mockito.mock(EntryCopier.class), (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io()){

            Single<LedgerMetadata> recoverLedger(long ledgerId, String runId) {
                return Single.just((Object)DataIntegrityCheckTest.this.newClosedMetadataWithEnsemble(ledgerId, -1L, new BookieId[]{bookieId, DataIntegrityCheckTest.this.bookie1}).build());
            }
        };
        long numLedgers = 10000L;
        long first = 1L;
        long last = first + 10000L;
        HashMap<Long, LedgerMetadata> ledgers = new HashMap<Long, LedgerMetadata>();
        for (long i = first; i < last; ++i) {
            LedgerMetadata metadata = this.newMetadataWithEnsemble(i, bookieId, this.bookie1).build();
            ledgers.put(i, metadata);
            storage.setMasterKey(i, metadata.getPassword());
            storage.setLimboState(i);
        }
        MatcherAssert.assertThat((Object)ledgers.size(), (Matcher)Matchers.equalTo((Object)10000));
        Set results = (Set)impl.checkAndRecoverLedgers(ledgers, "test").get();
        MatcherAssert.assertThat((Object)results.size(), (Matcher)Matchers.equalTo((Object)10000));
        MatcherAssert.assertThat((Object)results.stream().filter(r -> r.isOK()).count(), (Matcher)Matchers.equalTo((Object)10000L));
        for (DataIntegrityCheckImpl.LedgerResult r2 : results) {
            MatcherAssert.assertThat((Object)r2.isOK(), (Matcher)Matchers.equalTo((Object)true));
            ledgers.remove(r2.getLedgerId());
        }
        MatcherAssert.assertThat((Object)ledgers.isEmpty(), (Matcher)Matchers.equalTo((Object)true));
        HashSet clearedSet = Sets.newHashSet(cleared);
        MatcherAssert.assertThat((Object)clearedSet.size(), (Matcher)Matchers.equalTo((Object)cleared.size()));
        for (long l : LongStream.range(first, last).toArray()) {
            MatcherAssert.assertThat((Object)l, (Matcher)Matchers.isIn((Collection)clearedSet));
        }
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)10000))).clearLimboState(Mockito.anyLong());
    }

    @Test
    public void testRecoverLimboManyLedgersErrorOnFirst() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        final BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        final ArrayList cleared = new ArrayList();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage(){

            @Override
            public void clearLimboState(long ledgerId) {
                cleared.add(ledgerId);
            }
        });
        long numLedgers = 100L;
        final long first = 1L;
        long last = first + 100L;
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(bookieId, lm, storage, (EntryCopier)Mockito.mock(EntryCopier.class), (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io()){

            Single<LedgerMetadata> recoverLedger(long ledgerId, String runId) {
                if (ledgerId == first) {
                    return Single.error((Throwable)new BKException.BKBookieHandleNotAvailableException());
                }
                return Single.just((Object)DataIntegrityCheckTest.this.newClosedMetadataWithEnsemble(ledgerId, -1L, new BookieId[]{bookieId, DataIntegrityCheckTest.this.bookie1}).build());
            }
        };
        HashMap<Long, LedgerMetadata> ledgers = new HashMap<Long, LedgerMetadata>();
        for (long i = first; i < last; ++i) {
            LedgerMetadata metadata = this.newMetadataWithEnsemble(i, bookieId, this.bookie1).build();
            ledgers.put(i, metadata);
            storage.setMasterKey(i, metadata.getPassword());
            storage.setLimboState(i);
        }
        MatcherAssert.assertThat((Object)ledgers.size(), (Matcher)Matchers.equalTo((Object)100));
        Set results = (Set)impl.checkAndRecoverLedgers(ledgers, "test").get();
        MatcherAssert.assertThat((Object)results.size(), (Matcher)Matchers.equalTo((Object)100));
        MatcherAssert.assertThat((Object)results.stream().filter(r -> r.isOK()).count(), (Matcher)Matchers.equalTo((Object)99L));
        MatcherAssert.assertThat((Object)results.stream().filter(r -> r.isError()).count(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)results.stream().filter(r -> r.isError()).map(r -> r.getLedgerId()).findFirst().get(), (Matcher)Matchers.equalTo((Object)first));
        HashSet clearedSet = Sets.newHashSet(cleared);
        MatcherAssert.assertThat((Object)clearedSet.size(), (Matcher)Matchers.equalTo((Object)cleared.size()));
        for (long l : LongStream.range(first, last).toArray()) {
            if (l == first) {
                MatcherAssert.assertThat((Object)l, (Matcher)Matchers.not((Matcher)Matchers.isIn((Collection)clearedSet)));
                continue;
            }
            MatcherAssert.assertThat((Object)l, (Matcher)Matchers.isIn((Collection)clearedSet));
        }
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)99))).clearLimboState(Mockito.anyLong());
    }

    @Test
    public void testRecoverLimboNoLedgers() throws Exception {
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        final BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        ArrayList cleared = new ArrayList();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(bookieId, lm, storage, (EntryCopier)Mockito.mock(EntryCopier.class), (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io()){

            Single<LedgerMetadata> recoverLedger(long ledgerId, String runId) {
                return Single.just((Object)DataIntegrityCheckTest.this.newClosedMetadataWithEnsemble(ledgerId, -1L, new BookieId[]{bookieId, DataIntegrityCheckTest.this.bookie1}).build());
            }
        };
        ImmutableMap ledgers = ImmutableMap.of();
        Set resolved = (Set)impl.checkAndRecoverLedgers((Map)ledgers, "test").get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)resolved.isEmpty(), (Matcher)Matchers.equalTo((Object)true));
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)0))).clearLimboState(Mockito.anyLong());
    }

    @Test
    public void testRecoverSingleLedgerEntriesOnLedgerIDontHave() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie3, this.bookie2).build();
        bookieClient.getMockBookies().seedLedger(id1, metadata1);
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        TestObserver observer = TestObserver.create();
        impl.checkAndRecoverLedgerEntries(id1, metadata1, "test").subscribe((SingleObserver)observer);
        ((TestObserver)observer.await()).assertNoErrors();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)true));
        for (long i = 0L; i <= metadata1.getLastEntryId(); ++i) {
            MatcherAssert.assertThat((Object)storage.entryExists(id1, i), (Matcher)Matchers.equalTo((Object)false));
        }
    }

    @Test
    public void testRecoverSingleLedgerNotClosedOneEnsemble() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        LedgerMetadata metadata1 = this.newMetadataWithEnsemble(id1, this.bookie1, this.bookie2).build();
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        TestObserver observer = TestObserver.create();
        impl.checkAndRecoverLedgerEntries(id1, metadata1, "test").subscribe((SingleObserver)observer);
        ((TestObserver)observer.await()).assertNoErrors();
        LedgerMetadata md1 = this.newMetadataWithEnsemble(id1, this.bookie1).build();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testRecoverSingleLedgerNoClosedMultiEnsembleBookieInClosed() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        LedgerMetadata metadata1 = this.newMetadataWithEnsemble(id1, this.bookie1, this.bookie2).newEnsembleEntry(10L, (List)Lists.newArrayList((Object[])new BookieId[]{this.bookie3, this.bookie2})).build();
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id1, metadata1);
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        TestObserver observer = TestObserver.create();
        impl.checkAndRecoverLedgerEntries(id1, metadata1, "test").subscribe((SingleObserver)observer);
        ((TestObserver)observer.await()).assertNoErrors();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)true));
        for (long e = 0L; e < 10L; ++e) {
            MatcherAssert.assertThat((Object)storage.entryExists(id1, e), (Matcher)Matchers.equalTo((Object)true));
        }
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 10L), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testRecoverSingleLedgerNotClosedMultiEnsembleBookieInFinal() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        LedgerMetadata metadata1 = this.newMetadataWithEnsemble(id1, this.bookie3, this.bookie2).newEnsembleEntry(10L, (List)Lists.newArrayList((Object[])new BookieId[]{this.bookie1, this.bookie2})).build();
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id1, metadata1);
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        TestObserver observer = TestObserver.create();
        impl.checkAndRecoverLedgerEntries(id1, metadata1, "test").subscribe((SingleObserver)observer);
        ((TestObserver)observer.await()).assertNoErrors();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testRecoverSingleLedgerLargeEnsembleStriped() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie4, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie4, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        LedgerMetadata metadata1 = LedgerMetadataBuilder.create().withId(id1).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(5).withWriteQuorumSize(2).withAckQuorumSize(2).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{this.bookie1, this.bookie2, this.bookie3, this.bookie4, this.bookie5})).withClosedState().withLastEntryId(10L).withLength(1000L).build();
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie1, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie5, id1, metadata1);
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        TestObserver observer = TestObserver.create();
        impl.checkAndRecoverLedgerEntries(id1, metadata1, "test").subscribe((SingleObserver)observer);
        ((TestObserver)observer.await()).assertNoErrors();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 0L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 1L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 2L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 3L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 4L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 5L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 6L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 7L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 8L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 9L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 10L), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testRecoverSingleLedgerEntriesOnlyEntriesNeeded() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie3, this.bookie2).newEnsembleEntry(10L, (List)Lists.newArrayList((Object[])new BookieId[]{this.bookie1, this.bookie2})).newEnsembleEntry(100L, (List)Lists.newArrayList((Object[])new BookieId[]{this.bookie3, this.bookie2})).build();
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id1, metadata1);
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        TestObserver observer = TestObserver.create();
        impl.checkAndRecoverLedgerEntries(id1, metadata1, "test").subscribe((SingleObserver)observer);
        ((TestObserver)observer.await()).assertNoErrors();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 9L), (Matcher)Matchers.equalTo((Object)false));
        for (long e = 10L; e < 100L; ++e) {
            MatcherAssert.assertThat((Object)storage.entryExists(id1, e), (Matcher)Matchers.equalTo((Object)true));
        }
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 100L), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testRecoverSingleLedgerEntriesOnlyEntriesNeededEverySecond() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie1, this.bookie2).build();
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        long added = 0L;
        storage.setMasterKey(id1, PASSWD);
        for (long e = 0L; e <= metadata1.getLastEntryId(); ++e) {
            if (e % 2L != 0L) continue;
            storage.addEntry(bookieClient.getMockBookies().generateEntry(id1, e, e - 1L));
            ++added;
        }
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)true));
        TestObserver observer = TestObserver.create();
        impl.checkAndRecoverLedgerEntries(id1, metadata1, "test").subscribe((SingleObserver)observer);
        ((TestObserver)observer.await()).assertNoErrors();
        for (long e = 0L; e <= metadata1.getLastEntryId(); ++e) {
            if (e % 2L == 0L) {
                ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)0))).readEntry((BookieId)Mockito.any(), Mockito.eq((long)id1), Mockito.eq((long)e), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
            }
            if (e % 2L == 1L) {
                ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)1))).readEntry((BookieId)Mockito.any(), Mockito.eq((long)id1), Mockito.eq((long)e), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
            }
            MatcherAssert.assertThat((Object)storage.entryExists(id1, e), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    @Test
    public void testRecoverSingleLedgerErrorAtStart() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie1, this.bookie2).build();
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.setPreReadHook((bookie, ledger, entry) -> {
            if (entry == 0L) {
                return FutureUtils.exception((Throwable)new BKException.BKReadException());
            }
            return CompletableFuture.completedFuture(null);
        });
        TestObserver observer = TestObserver.create();
        impl.checkAndRecoverLedgerEntries(id1, metadata1, "test").subscribe((SingleObserver)observer);
        ((TestObserver)observer.await()).assertError(t -> t instanceof BKException.BKReadException);
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 0L), (Matcher)Matchers.equalTo((Object)false));
        for (long e = 1L; e <= metadata1.getLastEntryId(); ++e) {
            MatcherAssert.assertThat((Object)storage.entryExists(id1, e), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    @Test
    public void testRecoverSingleLedgerErrorEverySecond() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie1, this.bookie2).build();
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.setPreReadHook((bookie, ledger, entry) -> {
            if (entry % 2L == 0L) {
                return FutureUtils.exception((Throwable)new BKException.BKReadException());
            }
            return CompletableFuture.completedFuture(null);
        });
        TestObserver observer = TestObserver.create();
        impl.checkAndRecoverLedgerEntries(id1, metadata1, "test").subscribe((SingleObserver)observer);
        ((TestObserver)observer.await()).assertError(t -> {
            if (t instanceof CompositeException) {
                CompositeException e = (CompositeException)t;
                for (Throwable t2 : e.getExceptions()) {
                    if (t2 instanceof BKException.BKReadException) continue;
                    return false;
                }
                return e.getExceptions().size() == 500;
            }
            return false;
        });
        for (long e = 0L; e <= metadata1.getLastEntryId(); ++e) {
            if (e % 2L == 0L) {
                MatcherAssert.assertThat((Object)storage.entryExists(id1, e), (Matcher)Matchers.equalTo((Object)false));
                continue;
            }
            MatcherAssert.assertThat((Object)storage.entryExists(id1, e), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    @Test
    public void testRecoverSingleLedgerErrorOneOnStore() throws Exception {
        long e;
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage(){

            @Override
            public long addEntry(ByteBuf entry) throws IOException, BookieException {
                long entryId = this.extractEntryId(entry);
                if (entryId > 10L && entryId <= 100L) {
                    throw new IOException("Don't feel like storing these");
                }
                return super.addEntry(entry);
            }
        });
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie1, this.bookie2).build();
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        TestObserver observer = TestObserver.create();
        impl.checkAndRecoverLedgerEntries(id1, metadata1, "test").subscribe((SingleObserver)observer);
        ((TestObserver)observer.await()).assertError(t -> {
            if (t instanceof CompositeException) {
                CompositeException e = (CompositeException)t;
                for (Throwable t2 : e.getExceptions()) {
                    boolean failStore = t2 instanceof IOException;
                    if (failStore) continue;
                    return false;
                }
                return e.getExceptions().size() == 90;
            }
            return false;
        });
        for (e = 0L; e <= 10L; ++e) {
            MatcherAssert.assertThat((Object)storage.entryExists(id1, e), (Matcher)Matchers.equalTo((Object)true));
        }
        for (e = 11L; e <= 100L; ++e) {
            MatcherAssert.assertThat((Object)storage.entryExists(id1, e), (Matcher)Matchers.equalTo((Object)false));
        }
        for (e = 101L; e <= metadata1.getLastEntryId(); ++e) {
            MatcherAssert.assertThat((Object)storage.entryExists(id1, e), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    @Test
    public void testRecoverMultiLedgers() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        long id2 = 48862L;
        long id3 = 48830L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie1, this.bookie2).build();
        LedgerMetadata metadata2 = this.newClosedMetadataWithEnsemble(id2, 1000L, this.bookie1, this.bookie3).build();
        LedgerMetadata metadata3 = this.newClosedMetadataWithEnsemble(id3, 1000L, this.bookie1, this.bookie3).build();
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id2, metadata2);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id3, metadata3);
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)false));
        ImmutableMap ledgers = ImmutableMap.of((Object)id1, (Object)metadata1, (Object)id2, (Object)metadata2, (Object)id3, (Object)metadata3);
        Set resolved = (Set)impl.checkAndRecoverLedgers((Map)ledgers, "test").get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)resolved.stream().filter(r -> r.isOK()).count(), (Matcher)Matchers.equalTo((Object)3L));
        MatcherAssert.assertThat(resolved.stream().filter(r -> r.isOK()).map(r -> r.getLedgerId()).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{id1, id2, id3}));
        for (long e = 0L; e <= metadata1.getLastEntryId(); ++e) {
            MatcherAssert.assertThat((Object)storage.entryExists(id1, e), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)storage.entryExists(id2, e), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)storage.entryExists(id3, e), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    @Test
    public void testRecoverMultiLedgersOneUnavailable() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        long id2 = 48862L;
        long id3 = 48830L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie1, this.bookie2).build();
        LedgerMetadata metadata2 = this.newClosedMetadataWithEnsemble(id2, 1000L, this.bookie1, this.bookie3).build();
        LedgerMetadata metadata3 = this.newClosedMetadataWithEnsemble(id3, 1000L, this.bookie1, this.bookie3).build();
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id3, metadata3);
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)false));
        ImmutableMap ledgers = ImmutableMap.of((Object)id1, (Object)metadata1, (Object)id2, (Object)metadata2, (Object)id3, (Object)metadata3);
        Set resolved = (Set)impl.checkAndRecoverLedgers((Map)ledgers, "test").get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)resolved.stream().filter(r -> r.isOK()).count(), (Matcher)Matchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)resolved.stream().filter(r -> r.isError()).count(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat(resolved.stream().filter(r -> r.isOK()).map(r -> r.getLedgerId()).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{id1, id3}));
        for (long e = 0L; e <= metadata1.getLastEntryId(); ++e) {
            MatcherAssert.assertThat((Object)storage.entryExists(id1, e), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)storage.entryExists(id3, e), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    @Test
    public void testRecoverMultiLedgersOneFailsToWriteLocally() throws Exception {
        final long id1 = 57005L;
        long id2 = 48862L;
        long id3 = 48830L;
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage(){

            @Override
            public long addEntry(ByteBuf entry) throws IOException, BookieException {
                if (this.extractLedgerId(entry) == id1 && this.extractEntryId(entry) == 3L) {
                    throw new IOException("Don't feel like storing this");
                }
                return super.addEntry(entry);
            }
        });
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie1, this.bookie2).build();
        LedgerMetadata metadata2 = this.newClosedMetadataWithEnsemble(id2, 1000L, this.bookie1, this.bookie3).build();
        LedgerMetadata metadata3 = this.newClosedMetadataWithEnsemble(id3, 1000L, this.bookie1, this.bookie3).build();
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id2, metadata2);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id3, metadata3);
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)false));
        ImmutableMap ledgers = ImmutableMap.of((Object)id1, (Object)metadata1, (Object)id2, (Object)metadata2, (Object)id3, (Object)metadata3);
        Set resolved = (Set)impl.checkAndRecoverLedgers((Map)ledgers, "test").get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)resolved.stream().filter(r -> r.isOK()).count(), (Matcher)Matchers.equalTo((Object)2L));
        MatcherAssert.assertThat(resolved.stream().filter(r -> r.isOK()).map(r -> r.getLedgerId()).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{id2, id3}));
        MatcherAssert.assertThat(resolved.stream().filter(r -> r.isError()).map(r -> r.getLedgerId()).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{id1}));
        for (long e = 0L; e <= metadata1.getLastEntryId(); ++e) {
            MatcherAssert.assertThat((Object)storage.entryExists(id1, e), (Matcher)Matchers.equalTo((Object)(e != 3L ? 1 : 0)));
            MatcherAssert.assertThat((Object)storage.entryExists(id2, e), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)storage.entryExists(id3, e), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    @Test
    public void testRecoverMultiLedgersAllUnavailable() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        long id2 = 48862L;
        long id3 = 48830L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie1, this.bookie2).build();
        LedgerMetadata metadata2 = this.newClosedMetadataWithEnsemble(id2, 1000L, this.bookie1, this.bookie3).build();
        LedgerMetadata metadata3 = this.newClosedMetadataWithEnsemble(id3, 1000L, this.bookie1, this.bookie3).build();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)false));
        ImmutableMap ledgers = ImmutableMap.of((Object)id1, (Object)metadata1, (Object)id2, (Object)metadata2, (Object)id3, (Object)metadata3);
        Set resolved = (Set)impl.checkAndRecoverLedgers((Map)ledgers, "test").get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)resolved.stream().filter(r -> r.isOK()).count(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)resolved.stream().filter(r -> r.isError()).count(), (Matcher)Matchers.equalTo((Object)3L));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(id1, 0L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(id2, 0L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(id3, 0L), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testEnsemblesContainBookie() throws Exception {
        LedgerMetadata md1 = this.newMetadataWithEnsemble(1L, this.bookie1).build();
        MatcherAssert.assertThat((Object)DataIntegrityCheckImpl.ensemblesContainBookie((LedgerMetadata)md1, (BookieId)this.bookie1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)DataIntegrityCheckImpl.ensemblesContainBookie((LedgerMetadata)md1, (BookieId)this.bookie2), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)DataIntegrityCheckImpl.ensemblesContainBookie((LedgerMetadata)md1, (BookieId)this.bookie3), (Matcher)Matchers.equalTo((Object)false));
        LedgerMetadata md2 = this.newMetadataWithEnsemble(2L, this.bookie1, this.bookie2).newEnsembleEntry(1L, (List)Lists.newArrayList((Object[])new BookieId[]{this.bookie2, this.bookie3})).build();
        MatcherAssert.assertThat((Object)DataIntegrityCheckImpl.ensemblesContainBookie((LedgerMetadata)md2, (BookieId)this.bookie1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)DataIntegrityCheckImpl.ensemblesContainBookie((LedgerMetadata)md2, (BookieId)this.bookie2), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)DataIntegrityCheckImpl.ensemblesContainBookie((LedgerMetadata)md2, (BookieId)this.bookie3), (Matcher)Matchers.equalTo((Object)true));
        LedgerMetadata md3 = this.newMetadataWithEnsemble(3L, this.bookie1, this.bookie2).newEnsembleEntry(1L, (List)Lists.newArrayList((Object[])new BookieId[]{this.bookie2, this.bookie1})).build();
        MatcherAssert.assertThat((Object)DataIntegrityCheckImpl.ensemblesContainBookie((LedgerMetadata)md3, (BookieId)this.bookie1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)DataIntegrityCheckImpl.ensemblesContainBookie((LedgerMetadata)md3, (BookieId)this.bookie2), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)DataIntegrityCheckImpl.ensemblesContainBookie((LedgerMetadata)md3, (BookieId)this.bookie3), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testMetadataCacheLoad() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        long id2 = 48862L;
        long id3 = 48830L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie1, this.bookie2).build();
        LedgerMetadata metadata2 = this.newClosedMetadataWithEnsemble(id2, 1000L, this.bookie1, this.bookie3).build();
        LedgerMetadata metadata3 = this.newClosedMetadataWithEnsemble(id3, 1000L, this.bookie1, this.bookie3).build();
        lm.createLedgerMetadata(id1, metadata1).get();
        lm.createLedgerMetadata(id2, metadata2).get();
        lm.createLedgerMetadata(id3, metadata3).get();
        Map ledgers = (Map)impl.getCachedOrReadMetadata("test").get();
        MatcherAssert.assertThat(ledgers.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{id1, id2, id3}));
    }

    @Test
    public void testFullCheckCacheLoadAndProcessIfEmpty() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        long id1 = 57005L;
        long id2 = 48862L;
        long id3 = 48830L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie1, this.bookie2).build();
        LedgerMetadata metadata2 = this.newClosedMetadataWithEnsemble(id2, 1000L, this.bookie1, this.bookie3).build();
        LedgerMetadata metadata3 = this.newClosedMetadataWithEnsemble(id3, 1000L, this.bookie1, this.bookie3).build();
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id2, metadata2);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id3, metadata3);
        lm.createLedgerMetadata(id1, metadata1).get();
        lm.createLedgerMetadata(id2, metadata2).get();
        lm.createLedgerMetadata(id3, metadata3).get();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)false));
        impl.runFullCheck().get();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testFullCheckCacheLoadAndProcessSomeInLimbo() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        long id1 = 57005L;
        long id2 = 48862L;
        long id3 = 48830L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie1, this.bookie2).build();
        LedgerMetadata metadata2 = this.newClosedMetadataWithEnsemble(id2, 1000L, this.bookie1, this.bookie3).build();
        LedgerMetadata metadata3 = this.newMetadataWithEnsemble(id3, this.bookie1, this.bookie3).build();
        final LedgerMetadata metadata3closed = this.newClosedMetadataWithEnsemble(id3, 1000L, this.bookie1, this.bookie3).build();
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, lm, storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io()){

            Single<LedgerMetadata> recoverLedger(long ledgerId, String runId) {
                return Single.just((Object)metadata3closed);
            }
        };
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id2, metadata2);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id3, metadata3closed);
        lm.createLedgerMetadata(id1, metadata1).get();
        lm.createLedgerMetadata(id2, metadata2).get();
        lm.createLedgerMetadata(id3, metadata3).get();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)false));
        storage.setMasterKey(id3, PASSWD);
        storage.setLimboState(id3);
        MatcherAssert.assertThat((Object)storage.hasLimboState(id3), (Matcher)Matchers.equalTo((Object)true));
        storage.setStorageStateFlag(LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK);
        MatcherAssert.assertThat((Object)LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK, (Matcher)Matchers.isIn(storage.getStorageStateFlags()));
        impl.runFullCheck().get();
        MatcherAssert.assertThat((Object)LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK, (Matcher)Matchers.not((Matcher)Matchers.isIn(storage.getStorageStateFlags())));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.hasLimboState(id3), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testFullCheckInLimboRecoveryFailsFirstTime() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        long id1 = 57005L;
        long id2 = 48862L;
        long id3 = 48830L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 1000L, this.bookie1, this.bookie2).build();
        LedgerMetadata metadata2 = this.newClosedMetadataWithEnsemble(id2, 1000L, this.bookie1, this.bookie3).build();
        LedgerMetadata metadata3 = this.newMetadataWithEnsemble(id3, this.bookie1, this.bookie3).build();
        final LedgerMetadata metadata3closed = this.newClosedMetadataWithEnsemble(id3, 1000L, this.bookie1, this.bookie3).build();
        final AtomicInteger callCount = new AtomicInteger(0);
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, lm, storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io()){

            Single<LedgerMetadata> recoverLedger(long ledgerId, String runId) {
                if (callCount.getAndIncrement() == 0) {
                    return Single.error((Throwable)new BKException.BKReadException());
                }
                return Single.just((Object)metadata3closed);
            }
        };
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id2, metadata2);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id3, metadata3closed);
        lm.createLedgerMetadata(id1, metadata1).get();
        lm.createLedgerMetadata(id2, metadata2).get();
        lm.createLedgerMetadata(id3, metadata3).get();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)false));
        storage.setMasterKey(id3, PASSWD);
        storage.setLimboState(id3);
        MatcherAssert.assertThat((Object)storage.hasLimboState(id3), (Matcher)Matchers.equalTo((Object)true));
        storage.setStorageStateFlag(LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK);
        MatcherAssert.assertThat((Object)LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK, (Matcher)Matchers.isIn(storage.getStorageStateFlags()));
        impl.runFullCheck().get();
        MatcherAssert.assertThat((Object)LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK, (Matcher)Matchers.isIn(storage.getStorageStateFlags()));
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)1))).flush();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(id3, 0L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.hasLimboState(id3), (Matcher)Matchers.equalTo((Object)true));
        impl.runFullCheck().get();
        MatcherAssert.assertThat((Object)LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK, (Matcher)Matchers.not((Matcher)Matchers.isIn(storage.getStorageStateFlags())));
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)2))).flush();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(id3, 0L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.hasLimboState(id3), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testFullCheckInEntryCopyFailsFirstTime() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        long id1 = 57005L;
        long id2 = 48862L;
        long id3 = 48830L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 100L, this.bookie1, this.bookie2).build();
        LedgerMetadata metadata2 = this.newClosedMetadataWithEnsemble(id2, 100L, this.bookie1, this.bookie3).build();
        LedgerMetadata metadata3 = this.newMetadataWithEnsemble(id3, this.bookie1, this.bookie3).build();
        final LedgerMetadata metadata3closed = this.newClosedMetadataWithEnsemble(id3, 100L, this.bookie1, this.bookie3).build();
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, lm, storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io()){

            Single<LedgerMetadata> recoverLedger(long ledgerId, String runId) {
                return Single.just((Object)metadata3closed);
            }
        };
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id2, metadata2);
        lm.createLedgerMetadata(id1, metadata1).get();
        lm.createLedgerMetadata(id2, metadata2).get();
        lm.createLedgerMetadata(id3, metadata3).get();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)false));
        storage.setMasterKey(id3, PASSWD);
        storage.setLimboState(id3);
        MatcherAssert.assertThat((Object)storage.hasLimboState(id3), (Matcher)Matchers.equalTo((Object)true));
        storage.setStorageStateFlag(LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK);
        MatcherAssert.assertThat((Object)LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK, (Matcher)Matchers.isIn(storage.getStorageStateFlags()));
        impl.runFullCheck().get();
        MatcherAssert.assertThat((Object)LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK, (Matcher)Matchers.isIn(storage.getStorageStateFlags()));
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)1))).flush();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(id3, 0L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.hasLimboState(id3), (Matcher)Matchers.equalTo((Object)false));
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id3, metadata3closed);
        impl.runFullCheck().get();
        MatcherAssert.assertThat((Object)LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK, (Matcher)Matchers.not((Matcher)Matchers.isIn(storage.getStorageStateFlags())));
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)2))).flush();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(id3, 0L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.hasLimboState(id3), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testFullCheckAllInLimboAndMissing() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        long id1 = 57005L;
        long id2 = 48862L;
        long id3 = 48830L;
        LedgerMetadata metadata1 = this.newMetadataWithEnsemble(id1, this.bookie1, this.bookie2).build();
        LedgerMetadata metadata2 = this.newMetadataWithEnsemble(id2, this.bookie1, this.bookie3).build();
        LedgerMetadata metadata3 = this.newMetadataWithEnsemble(id3, this.bookie1, this.bookie3).build();
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, lm, storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io()){

            Single<LedgerMetadata> recoverLedger(long ledgerId, String runId) {
                return Single.error((Throwable)new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
            }
        };
        lm.createLedgerMetadata(id1, metadata1).get();
        lm.createLedgerMetadata(id2, metadata2).get();
        lm.createLedgerMetadata(id3, metadata3).get();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)false));
        storage.setMasterKey(id1, PASSWD);
        storage.setLimboState(id1);
        storage.setMasterKey(id2, PASSWD);
        storage.setLimboState(id2);
        storage.setMasterKey(id3, PASSWD);
        storage.setLimboState(id3);
        MatcherAssert.assertThat((Object)storage.hasLimboState(id1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.hasLimboState(id2), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.hasLimboState(id3), (Matcher)Matchers.equalTo((Object)true));
        storage.setStorageStateFlag(LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK);
        MatcherAssert.assertThat((Object)LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK, (Matcher)Matchers.isIn(storage.getStorageStateFlags()));
        impl.runFullCheck().get();
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)1))).flush();
        MatcherAssert.assertThat((Object)LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK, (Matcher)Matchers.not((Matcher)Matchers.isIn(storage.getStorageStateFlags())));
    }

    @Test
    public void testFullCheckFailFlushRetainsFlag() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerManager lm = new MockLedgerManager();
        ServerConfiguration conf = DataIntegrityCheckTest.serverConf();
        final AtomicInteger count = new AtomicInteger(0);
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage(){

            @Override
            public void flush() throws IOException {
                if (count.getAndIncrement() == 0) {
                    throw new IOException("broken flush");
                }
            }
        });
        EntryCopierImpl copier = new EntryCopierImpl(this.bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        long id1 = 57005L;
        long id2 = 48862L;
        long id3 = 48830L;
        LedgerMetadata metadata1 = this.newClosedMetadataWithEnsemble(id1, 100L, this.bookie1, this.bookie2).build();
        LedgerMetadata metadata2 = this.newClosedMetadataWithEnsemble(id2, 100L, this.bookie1, this.bookie3).build();
        LedgerMetadata metadata3 = this.newClosedMetadataWithEnsemble(id3, 100L, this.bookie1, this.bookie3).build();
        DataIntegrityCheckImpl impl = new DataIntegrityCheckImpl(this.bookie1, (LedgerManager)lm, (LedgerStorage)storage, (EntryCopier)copier, (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class), Schedulers.io());
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie2, id1, metadata1);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id2, metadata2);
        bookieClient.getMockBookies().seedLedgerForBookie(this.bookie3, id3, metadata3);
        lm.createLedgerMetadata(id1, metadata1).get();
        lm.createLedgerMetadata(id2, metadata2).get();
        lm.createLedgerMetadata(id3, metadata3).get();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)false));
        storage.setStorageStateFlag(LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK);
        try {
            impl.runFullCheck().get();
            Assert.fail((String)"Should have failed on flush");
        }
        catch (ExecutionException ee) {
            MatcherAssert.assertThat((Object)ee.getCause(), (Matcher)Matchers.instanceOf(IOException.class));
        }
        MatcherAssert.assertThat((Object)LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK, (Matcher)Matchers.isIn(storage.getStorageStateFlags()));
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)1))).flush();
        MatcherAssert.assertThat((Object)storage.ledgerExists(id1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id2), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.ledgerExists(id3), (Matcher)Matchers.equalTo((Object)true));
        impl.runFullCheck().get();
        MatcherAssert.assertThat((Object)LedgerStorage.StorageState.NEEDS_INTEGRITY_CHECK, (Matcher)Matchers.not((Matcher)Matchers.isIn(storage.getStorageStateFlags())));
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)2))).flush();
    }
}

