/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.function.Supplier;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieResources;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.ReadOnlyBookie;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.NullMetadataBookieDriver;
import org.apache.bookkeeper.proto.SimpleBookieServiceInfoProvider;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBookieImpl
extends BookieImpl {
    private static final Logger log = LoggerFactory.getLogger(TestBookieImpl.class);
    private final Resources resources;

    public TestBookieImpl(ServerConfiguration conf) throws Exception {
        this(new ResourceBuilder(conf).build());
    }

    public TestBookieImpl(Resources resources) throws Exception {
        super(resources.conf, resources.registrationManager, resources.storage, resources.diskChecker, resources.ledgerDirsManager, resources.indexDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (Supplier)new SimpleBookieServiceInfoProvider(resources.conf));
        this.resources = resources;
    }

    public static ReadOnlyBookie buildReadOnly(Resources resources) throws Exception {
        return new ReadOnlyBookie(resources.conf, resources.registrationManager, resources.storage, resources.diskChecker, resources.ledgerDirsManager, resources.indexDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (Supplier)new SimpleBookieServiceInfoProvider(resources.conf));
    }

    public static ReadOnlyBookie buildReadOnly(ServerConfiguration conf) throws Exception {
        return TestBookieImpl.buildReadOnly(new ResourceBuilder(conf).build());
    }

    int shutdown(int exitCode) {
        int ret = super.shutdown(exitCode);
        this.resources.cleanup();
        return ret;
    }

    public static class ResourceBuilder {
        private final ServerConfiguration conf;
        private MetadataBookieDriver metadataBookieDriver;
        private RegistrationManager registrationManager;

        public ResourceBuilder(ServerConfiguration conf) {
            this.conf = conf;
        }

        public ResourceBuilder withMetadataDriver(MetadataBookieDriver driver) {
            this.metadataBookieDriver = driver;
            return this;
        }

        public ResourceBuilder withRegistrationManager(RegistrationManager registrationManager) {
            this.registrationManager = registrationManager;
            return this;
        }

        Resources build() throws Exception {
            if (this.metadataBookieDriver == null) {
                this.metadataBookieDriver = this.conf.getMetadataServiceUri() == null ? new NullMetadataBookieDriver() : BookieResources.createMetadataDriver((ServerConfiguration)this.conf, (StatsLogger)NullStatsLogger.INSTANCE);
            }
            if (this.registrationManager == null) {
                this.registrationManager = this.metadataBookieDriver.createRegistrationManager();
            }
            LedgerManagerFactory ledgerManagerFactory = this.metadataBookieDriver.getLedgerManagerFactory();
            LedgerManager ledgerManager = ledgerManagerFactory.newLedgerManager();
            DiskChecker diskChecker = BookieResources.createDiskChecker((ServerConfiguration)this.conf);
            LedgerDirsManager ledgerDirsManager = BookieResources.createLedgerDirsManager((ServerConfiguration)this.conf, (DiskChecker)diskChecker, (StatsLogger)NullStatsLogger.INSTANCE);
            LedgerDirsManager indexDirsManager = BookieResources.createIndexDirsManager((ServerConfiguration)this.conf, (DiskChecker)diskChecker, (StatsLogger)NullStatsLogger.INSTANCE, (LedgerDirsManager)ledgerDirsManager);
            LedgerStorage storage = BookieResources.createLedgerStorage((ServerConfiguration)this.conf, (LedgerManager)ledgerManager, (LedgerDirsManager)ledgerDirsManager, (LedgerDirsManager)indexDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
            return new Resources(this.conf, this.metadataBookieDriver, this.registrationManager, ledgerManagerFactory, ledgerManager, storage, diskChecker, ledgerDirsManager, indexDirsManager);
        }
    }

    public static class Resources {
        private final ServerConfiguration conf;
        private final MetadataBookieDriver metadataDriver;
        private final RegistrationManager registrationManager;
        private final LedgerManagerFactory ledgerManagerFactory;
        private final LedgerManager ledgerManager;
        private final LedgerStorage storage;
        private final DiskChecker diskChecker;
        private final LedgerDirsManager ledgerDirsManager;
        private final LedgerDirsManager indexDirsManager;

        Resources(ServerConfiguration conf, MetadataBookieDriver metadataDriver, RegistrationManager registrationManager, LedgerManagerFactory ledgerManagerFactory, LedgerManager ledgerManager, LedgerStorage storage, DiskChecker diskChecker, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager) {
            this.conf = conf;
            this.metadataDriver = metadataDriver;
            this.registrationManager = registrationManager;
            this.ledgerManagerFactory = ledgerManagerFactory;
            this.ledgerManager = ledgerManager;
            this.storage = storage;
            this.diskChecker = diskChecker;
            this.ledgerDirsManager = ledgerDirsManager;
            this.indexDirsManager = indexDirsManager;
        }

        void cleanup() {
            try {
                this.ledgerManager.close();
            }
            catch (Exception e) {
                log.warn("Error shutting down ledger manager", (Throwable)e);
            }
            try {
                this.ledgerManagerFactory.close();
            }
            catch (Exception e) {
                log.warn("Error shutting down ledger manager factory", (Throwable)e);
            }
            this.registrationManager.close();
            try {
                this.metadataDriver.close();
            }
            catch (Exception e) {
                log.warn("Error shutting down metadata driver", (Throwable)e);
            }
        }
    }
}

