/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SingleBookieInitializationTest {
    @Rule
    public final TemporaryFolder testDir = new TemporaryFolder();
    private File journalDir;
    private File ledgerDir;
    private ServerConfiguration conf;
    private Bookie bookie;

    @Before
    public void setUp() throws Exception {
        this.journalDir = this.testDir.newFolder("journal");
        this.ledgerDir = this.testDir.newFolder("ledgers");
        this.conf = TestBKConfiguration.newServerConfiguration();
        this.conf.setJournalDirsName(new String[]{this.journalDir.getAbsolutePath()});
        this.conf.setLedgerDirNames(new String[]{this.ledgerDir.getAbsolutePath()});
        this.conf.setMetadataServiceUri(null);
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.bookie) {
            this.bookie.shutdown();
        }
    }

    private static String generateDataString(long ledger, long entry) {
        return "ledger-" + ledger + "-" + entry;
    }

    private static ByteBuf generateEntry(long ledger, long entry) {
        byte[] data = SingleBookieInitializationTest.generateDataString(ledger, entry).getBytes();
        ByteBuf bb = Unpooled.buffer((int)(16 + data.length));
        bb.writeLong(ledger);
        bb.writeLong(entry);
        bb.writeBytes(data);
        return bb;
    }

    @Test
    public void testInitBookieNoWritableDirsButHasEnoughSpaces() throws Exception {
        float usage = 1.0f - (float)this.ledgerDir.getUsableSpace() / (float)this.ledgerDir.getTotalSpace();
        this.conf.setDiskUsageThreshold(usage / 2.0f);
        this.conf.setDiskUsageWarnThreshold(usage / 3.0f);
        this.conf.setMinUsableSizeForEntryLogCreation(Long.MIN_VALUE);
        this.conf.setLedgerStorageClass(InterleavedLedgerStorage.class.getName());
        this.bookie = new TestBookieImpl(this.conf);
        this.bookie.start();
        CompletableFuture writeFuture = new CompletableFuture();
        this.bookie.addEntry(SingleBookieInitializationTest.generateEntry(1L, 2L), false, (rc, ledgerId, entryId, addr, ctx) -> writeFuture.complete(rc), null, new byte[0]);
        Assert.assertEquals((long)0L, (long)((Integer)writeFuture.get()).intValue());
    }

    @Test
    public void testInitBookieNoWritableDirsAndNoEnoughSpaces() throws Exception {
        float usage = 1.0f - (float)this.ledgerDir.getUsableSpace() / (float)this.ledgerDir.getTotalSpace();
        this.conf.setDiskUsageThreshold(usage / 2.0f);
        this.conf.setDiskUsageWarnThreshold(usage / 3.0f);
        this.conf.setMinUsableSizeForEntryLogCreation(Long.MAX_VALUE);
        this.conf.setLedgerStorageClass(InterleavedLedgerStorage.class.getName());
        this.bookie = new TestBookieImpl(this.conf);
        this.bookie.start();
        try {
            this.bookie.addEntry(SingleBookieInitializationTest.generateEntry(1L, 2L), false, (rc, ledgerId, entryId, addr, ctx) -> {}, null, new byte[0]);
            Assert.fail((String)"Should fail on creating new entry log file since there is no enough disk space to accommodate writes");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe.getCause() instanceof LedgerDirsManager.NoWritableLedgerDirException));
        }
    }
}

