/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LedgerStorageTestBase {
    private static final Logger log = LoggerFactory.getLogger(LedgerStorageTestBase.class);
    @Rule
    public TestName testName = new TestName();
    protected ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
    protected File journalDir;
    protected File ledgerDir;
    protected LedgerDirsManager ledgerDirsManager;

    private File createTempDir(String suffix) throws Exception {
        File dir = File.createTempFile(this.testName.getMethodName(), suffix);
        dir.delete();
        dir.mkdirs();
        return dir;
    }

    protected LedgerStorageTestBase() {
    }

    @Before
    public void setUp() throws Exception {
        this.journalDir = this.createTempDir("journal");
        this.ledgerDir = this.createTempDir("ledger");
        BookieImpl.getCurrentDirectory((File)this.journalDir).mkdir();
        BookieImpl.getCurrentDirectory((File)this.ledgerDir).mkdir();
        this.conf.setMetadataServiceUri(null);
        this.conf.setJournalDirName(this.journalDir.getPath());
        this.conf.setLedgerDirNames(new String[]{this.ledgerDir.getPath()});
        DiskChecker checker = new DiskChecker(this.conf.getDiskUsageThreshold(), this.conf.getDiskUsageWarnThreshold());
        this.ledgerDirsManager = new LedgerDirsManager(this.conf, this.conf.getLedgerDirs(), checker);
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.journalDir);
        FileUtils.deleteDirectory((File)this.ledgerDir);
    }
}

