/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.commons.configuration.CompositeConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class ForceAuditorChecksCmdTest
extends BookKeeperClusterTestCase {
    public ForceAuditorChecksCmdTest() {
        super(1);
        this.baseConf.setAuditorPeriodicPlacementPolicyCheckInterval(10000L);
        this.baseConf.setAuditorPeriodicReplicasCheckInterval(10000L);
    }

    @Test
    public void verifyAuditCTimeReset() throws Exception {
        String[] argv = new String[]{"forceauditchecks", "-calc", "-ppc", "-rc"};
        long curTime = System.currentTimeMillis();
        ServerConfiguration conf = this.confByIndex(0);
        BookieShell bkShell = new BookieShell();
        bkShell.setConf((CompositeConfiguration)conf);
        MetadataDrivers.runFunctionWithLedgerManagerFactory((ServerConfiguration)conf, mFactory -> {
            try (LedgerUnderreplicationManager urM = mFactory.newLedgerUnderreplicationManager();){
                urM.setCheckAllLedgersCTime(curTime);
                urM.setPlacementPolicyCheckCTime(curTime);
                urM.setReplicasCheckCTime(curTime);
            }
            catch (InterruptedException | ReplicationException e) {
                throw new UncheckedExecutionException(e);
            }
            return null;
        });
        Assert.assertEquals((String)"Failed to return exit code!", (long)0L, (long)bkShell.run(argv));
        MetadataDrivers.runFunctionWithLedgerManagerFactory((ServerConfiguration)conf, mFactory -> {
            try (LedgerUnderreplicationManager urm = mFactory.newLedgerUnderreplicationManager();){
                long replicasCheckCTime;
                long placementPolicyCheckCTime;
                long checkAllLedgersCTime = urm.getCheckAllLedgersCTime();
                if (checkAllLedgersCTime > curTime - 1728000000L) {
                    Assert.fail((String)"The checkAllLedgersCTime should have been reset to atleast 20 days old");
                }
                if ((placementPolicyCheckCTime = urm.getPlacementPolicyCheckCTime()) > curTime - 1728000000L) {
                    Assert.fail((String)"The placementPolicyCheckCTime should have been reset to atleast 20 days old");
                }
                if ((replicasCheckCTime = urm.getReplicasCheckCTime()) > curTime - 1728000000L) {
                    Assert.fail((String)"The replicasCheckCTime should have been reset to atleast 20 days old");
                }
            }
            catch (InterruptedException | ReplicationException e) {
                throw new UncheckedExecutionException(e);
            }
            return null;
        });
    }
}

