/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server;

import java.io.IOException;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieResources;
import org.apache.bookkeeper.bookie.LegacyCookieValidation;
import org.apache.bookkeeper.common.allocator.ByteBufAllocatorWithOomHandler;
import org.apache.bookkeeper.common.component.LifecycleComponentStack;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.NullMetadataBookieDriver;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.server.Main;
import org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.server.service.BookieService;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={BookieService.class, BookieResources.class, Main.class})
public class TestMain {
    @Test
    public void testBuildBookieServer() throws Exception {
        PowerMockito.mockStatic(BookieResources.class, (Class[])new Class[0]);
        PowerMockito.when((Object)BookieResources.createMetadataDriver((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()))).thenReturn((Object)new NullMetadataBookieDriver());
        PowerMockito.when((Object)BookieResources.createAllocator((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()))).thenReturn(PowerMockito.mock(ByteBufAllocatorWithOomHandler.class));
        ServerConfiguration serverConf = new ServerConfiguration().setAutoRecoveryDaemonEnabled(false).setHttpServerEnabled(false).setExtraServerComponents(new String[]{TestComponent.class.getName()});
        BookieConfiguration conf = new BookieConfiguration(serverConf);
        PowerMockito.whenNew(BookieImpl.class).withAnyArguments().thenReturn(PowerMockito.mock(BookieImpl.class));
        PowerMockito.whenNew(LegacyCookieValidation.class).withAnyArguments().thenReturn(PowerMockito.mock(LegacyCookieValidation.class));
        BookieServer mockServer = (BookieServer)PowerMockito.mock(BookieServer.class);
        PowerMockito.whenNew(BookieServer.class).withAnyArguments().thenReturn((Object)mockServer);
        BookieSocketAddress bookieAddress = new BookieSocketAddress("127.0.0.1", 1281);
        PowerMockito.when((Object)mockServer.getLocalAddress()).thenReturn((Object)bookieAddress);
        PowerMockito.when((Object)mockServer.getBookieId()).thenReturn((Object)bookieAddress.toBookieId());
        LifecycleComponentStack stack = Main.buildBookieServer((BookieConfiguration)conf);
        Assert.assertEquals((long)7L, (long)stack.getNumComponents());
        Assert.assertTrue((boolean)(stack.getComponent(6) instanceof TestComponent));
        stack.start();
        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).start();
        stack.stop();
        stack.close();
        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).shutdown();
    }

    @Test
    public void testIgnoreExtraServerComponentsStartupFailures() throws Exception {
        PowerMockito.mockStatic(BookieResources.class, (Class[])new Class[0]);
        PowerMockito.when((Object)BookieResources.createMetadataDriver((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()))).thenReturn((Object)new NullMetadataBookieDriver());
        ServerConfiguration serverConf = new ServerConfiguration().setAutoRecoveryDaemonEnabled(false).setHttpServerEnabled(false).setExtraServerComponents(new String[]{"bad-server-component"}).setIgnoreExtraServerComponentsStartupFailures(true);
        BookieConfiguration conf = new BookieConfiguration(serverConf);
        PowerMockito.whenNew(BookieImpl.class).withAnyArguments().thenReturn(PowerMockito.mock(BookieImpl.class));
        PowerMockito.whenNew(LegacyCookieValidation.class).withAnyArguments().thenReturn(PowerMockito.mock(LegacyCookieValidation.class));
        BookieServer mockServer = (BookieServer)PowerMockito.mock(BookieServer.class);
        PowerMockito.whenNew(BookieServer.class).withAnyArguments().thenReturn((Object)mockServer);
        BookieSocketAddress bookieAddress = new BookieSocketAddress("127.0.0.1", 1281);
        PowerMockito.when((Object)mockServer.getLocalAddress()).thenReturn((Object)bookieAddress);
        PowerMockito.when((Object)mockServer.getBookieId()).thenReturn((Object)bookieAddress.toBookieId());
        LifecycleComponentStack stack = Main.buildBookieServer((BookieConfiguration)conf);
        Assert.assertEquals((long)6L, (long)stack.getNumComponents());
        stack.start();
        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).start();
        stack.stop();
        stack.close();
        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).shutdown();
    }

    @Test
    public void testExtraServerComponentsStartupFailures() throws Exception {
        PowerMockito.mockStatic(BookieResources.class, (Class[])new Class[0]);
        PowerMockito.when((Object)BookieResources.createMetadataDriver((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()))).thenReturn((Object)new NullMetadataBookieDriver());
        ServerConfiguration serverConf = new ServerConfiguration().setAutoRecoveryDaemonEnabled(false).setHttpServerEnabled(false).setExtraServerComponents(new String[]{"bad-server-component"}).setIgnoreExtraServerComponentsStartupFailures(false);
        BookieConfiguration conf = new BookieConfiguration(serverConf);
        PowerMockito.whenNew(BookieImpl.class).withAnyArguments().thenReturn(PowerMockito.mock(BookieImpl.class));
        PowerMockito.whenNew(LegacyCookieValidation.class).withAnyArguments().thenReturn(PowerMockito.mock(LegacyCookieValidation.class));
        BookieServer mockServer = (BookieServer)PowerMockito.mock(BookieServer.class);
        PowerMockito.whenNew(BookieServer.class).withAnyArguments().thenReturn((Object)mockServer);
        BookieSocketAddress bookieAddress = new BookieSocketAddress("127.0.0.1", 1281);
        PowerMockito.when((Object)mockServer.getLocalAddress()).thenReturn((Object)bookieAddress);
        PowerMockito.when((Object)mockServer.getBookieId()).thenReturn((Object)bookieAddress.toBookieId());
        try {
            Main.buildBookieServer((BookieConfiguration)conf);
            Assert.fail((String)"Should fail to start bookie server if `ignoreExtraServerComponentsStartupFailures` is set to false");
        }
        catch (RuntimeException re) {
            Assert.assertTrue((boolean)(re.getCause() instanceof ClassNotFoundException));
        }
    }

    static class TestComponent
    extends ServerLifecycleComponent {
        public TestComponent(BookieConfiguration conf, StatsLogger statsLogger) {
            super("test-component", conf, statsLogger);
        }

        protected void doStart() {
        }

        protected void doStop() {
        }

        protected void doClose() throws IOException {
        }
    }
}

