/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.util.List;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerLayout;
import org.apache.bookkeeper.meta.ZkLayoutManager;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestZkLayoutManager {
    private static final String ledgersRootPath = "/path/to/ledgers/root";
    private static final String layoutPath = "/path/to/ledgers/root/LAYOUT";
    private static final int managerVersion = 78;
    private final ZooKeeper zk = (ZooKeeper)Mockito.mock(ZooKeeper.class);
    private final LedgerLayout layout = new LedgerLayout(HierarchicalLedgerManagerFactory.class.getName(), 78);
    private final ZkLayoutManager zkLayoutManager = new ZkLayoutManager(this.zk, "/path/to/ledgers/root", (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);

    @Test
    public void testReadLayout() throws Exception {
        Mockito.when((Object)this.zk.getData((String)ArgumentMatchers.eq((Object)layoutPath), ArgumentMatchers.eq((boolean)false), (Stat)ArgumentMatchers.eq(null))).thenReturn((Object)this.layout.serialize());
        Assert.assertEquals((Object)this.layout, (Object)this.zkLayoutManager.readLedgerLayout());
    }

    @Test
    public void testStoreLayout() throws Exception {
        this.zkLayoutManager.storeLedgerLayout(this.layout);
        ((ZooKeeper)Mockito.verify((Object)this.zk, (VerificationMode)Mockito.times((int)1))).create((String)ArgumentMatchers.eq((Object)layoutPath), (byte[])ArgumentMatchers.eq((Object)this.layout.serialize()), (List)ArgumentMatchers.eq((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE), (CreateMode)ArgumentMatchers.eq((Object)CreateMode.PERSISTENT));
    }

    @Test
    public void testDeleteLayout() throws Exception {
        this.zkLayoutManager.deleteLedgerLayout();
        ((ZooKeeper)Mockito.verify((Object)this.zk, (VerificationMode)Mockito.times((int)1))).delete((String)ArgumentMatchers.eq((Object)layoutPath), ArgumentMatchers.eq((int)-1));
    }
}

