/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.Unpooled;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.PendingReadLacOp;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.ByteBufList;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPendingReadLacOp
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestPendingReadLacOp.class);
    byte[] pwd = "asdf".getBytes();
    byte[] data = "foo".getBytes();

    public TestPendingReadLacOp() {
        super(3);
    }

    @Test
    public void testPendingReadLacOpMissingExplicitLAC() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 3, 2, BookKeeper.DigestType.CRC32, this.pwd);
        lh.append(this.data);
        lh.append(this.data);
        lh.append(this.data);
        CompletableFuture result = new CompletableFuture();
        PendingReadLacOp pro = new PendingReadLacOp(lh, this.bkc.getBookieClient(), lh.getCurrentEnsemble(), (rc, lac) -> result.complete(lac)){

            public void initiate() {
                for (int i = 0; i < this.lh.getCurrentEnsemble().size(); ++i) {
                    int index = i;
                    ByteBufList buffer = this.lh.getDigestManager().computeDigestAndPackageForSending(2L, 1L, (long)TestPendingReadLacOp.this.data.length, Unpooled.wrappedBuffer((byte[])TestPendingReadLacOp.this.data));
                    ((TestPendingReadLacOp)TestPendingReadLacOp.this).bkc.scheduler.schedule(() -> this.readLacComplete(0, this.lh.getId(), null, Unpooled.copiedBuffer((byte[])buffer.toArray()), index), 0L, TimeUnit.SECONDS);
                    this.bookieClient.readLac((BookieId)this.lh.getCurrentEnsemble().get(i), this.lh.ledgerId, (BookkeeperInternalCallbacks.ReadLacCallback)this, (Object)i);
                }
            }
        };
        pro.initiate();
        Assert.assertEquals((long)1L, (long)((Long)result.get()));
    }

    @Test
    public void testPendingReadLacOpMissingLAC() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 3, 2, BookKeeper.DigestType.MAC, this.pwd);
        lh.append(this.data);
        lh.append(this.data);
        lh.append(this.data);
        CompletableFuture result = new CompletableFuture();
        PendingReadLacOp pro = new PendingReadLacOp(lh, this.bkc.getBookieClient(), lh.getCurrentEnsemble(), (rc, lac) -> result.complete(lac)){

            public void initiate() {
                for (int i = 0; i < this.lh.getCurrentEnsemble().size(); ++i) {
                    int index = i;
                    ByteBufList buffer = this.lh.getDigestManager().computeDigestAndPackageForSendingLac(1L);
                    ((TestPendingReadLacOp)TestPendingReadLacOp.this).bkc.scheduler.schedule(() -> this.readLacComplete(0, this.lh.getId(), buffer.getBuffer(0), null, index), 0L, TimeUnit.SECONDS);
                    this.bookieClient.readLac((BookieId)this.lh.getCurrentEnsemble().get(i), this.lh.ledgerId, (BookkeeperInternalCallbacks.ReadLacCallback)this, (Object)i);
                }
            }
        };
        pro.initiate();
        Assert.assertEquals((long)((Long)result.get()), (long)1L);
    }
}

