/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperClientStats;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.ClientInternalConf;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.ReadLastConfirmedAndEntryOp;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.client.api.LastConfirmedAndEntry;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.impl.LastConfirmedAndEntryImpl;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.ReadLastConfirmedAndEntryContext;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.proto.checksum.DummyDigestManager;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.util.ByteBufList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadLastConfirmedAndEntryOpTest {
    private static final Logger log = LoggerFactory.getLogger(ReadLastConfirmedAndEntryOpTest.class);
    private static final long LEDGERID = System.currentTimeMillis();
    private final TestStatsProvider testStatsProvider = new TestStatsProvider();
    private BookKeeperClientStats clientStats;
    private ClientContext mockClientCtx;
    private BookieClient mockBookieClient;
    private LedgerHandle mockLh;
    private ScheduledExecutorService scheduler;
    private OrderedScheduler orderedScheduler;
    private ClientInternalConf internalConf;
    private EnsemblePlacementPolicy mockPlacementPolicy;
    private LedgerMetadata ledgerMetadata;
    private DistributionSchedule distributionSchedule;
    private DigestManager digestManager;

    @Before
    public void setup() throws Exception {
        this.clientStats = BookKeeperClientStats.newInstance((StatsLogger)this.testStatsProvider.getStatsLogger(""));
        ClientConfiguration conf = new ClientConfiguration();
        conf.setFirstSpeculativeReadLACTimeout(100);
        conf.setMaxSpeculativeReadLACTimeout(200);
        conf.setSpeculativeReadLACTimeoutBackoffMultiplier(2.0f);
        this.internalConf = ClientInternalConf.fromConfig((ClientConfiguration)conf);
        ArrayList<BookieId> ensemble = new ArrayList<BookieId>(3);
        for (int i = 0; i < 3; ++i) {
            ensemble.add(new BookieSocketAddress("127.0.0.1", 3181 + i).toBookieId());
        }
        this.ledgerMetadata = LedgerMetadataBuilder.create().withId(124L).withEnsembleSize(3).withWriteQuorumSize(2).withAckQuorumSize(2).withPassword(new byte[0]).withDigestType(BookKeeper.DigestType.CRC32.toApiDigestType()).newEnsembleEntry(0L, ensemble).build();
        this.distributionSchedule = new RoundRobinDistributionSchedule(3, 2, 3);
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.orderedScheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-ordered-scheduler").numThreads(1).build();
        this.mockBookieClient = (BookieClient)Mockito.mock(BookieClient.class);
        this.mockPlacementPolicy = (EnsemblePlacementPolicy)Mockito.mock(EnsemblePlacementPolicy.class);
        this.mockClientCtx = (ClientContext)Mockito.mock(ClientContext.class);
        Mockito.when((Object)this.mockClientCtx.getBookieClient()).thenReturn((Object)this.mockBookieClient);
        Mockito.when((Object)this.mockClientCtx.getPlacementPolicy()).thenReturn((Object)this.mockPlacementPolicy);
        Mockito.when((Object)this.mockClientCtx.getConf()).thenReturn((Object)this.internalConf);
        Mockito.when((Object)this.mockClientCtx.getScheduler()).thenReturn((Object)this.orderedScheduler);
        Mockito.when((Object)this.mockClientCtx.getMainWorkerPool()).thenReturn((Object)this.orderedScheduler);
        Mockito.when((Object)this.mockClientCtx.getClientStats()).thenReturn((Object)this.clientStats);
        this.mockLh = (LedgerHandle)Mockito.mock(LedgerHandle.class);
        Mockito.when((Object)this.mockLh.getId()).thenReturn((Object)LEDGERID);
        Mockito.when((Object)this.mockLh.getCurrentEnsemble()).thenReturn(ensemble);
        Mockito.when((Object)this.mockLh.getLedgerMetadata()).thenReturn((Object)this.ledgerMetadata);
        Mockito.when((Object)this.mockLh.getDistributionSchedule()).thenReturn((Object)this.distributionSchedule);
        this.digestManager = new DummyDigestManager(LEDGERID, false, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Mockito.when((Object)this.mockLh.getDigestManager()).thenReturn((Object)this.digestManager);
    }

    @After
    public void teardown() {
        this.scheduler.shutdown();
        this.orderedScheduler.shutdown();
    }

    @Test
    public void testSpeculativeResponses() throws Exception {
        long entryId = 2L;
        long lac = 1L;
        ByteBuf data = Unpooled.copiedBuffer((CharSequence)"test-speculative-responses", (Charset)StandardCharsets.UTF_8);
        ByteBufList dataWithDigest = this.digestManager.computeDigestAndPackageForSending(2L, 1L, (long)data.readableBytes(), data);
        byte[] bytesWithDigest = new byte[dataWithDigest.readableBytes()];
        Assert.assertEquals((long)bytesWithDigest.length, (long)dataWithDigest.getBytes(bytesWithDigest));
        Map callbacks = Collections.synchronizedMap(new HashMap());
        ((BookieClient)Mockito.doAnswer(invocationOnMock -> {
            BookieId address = (BookieId)invocationOnMock.getArgument(0);
            BookkeeperInternalCallbacks.ReadEntryCallback callback = (BookkeeperInternalCallbacks.ReadEntryCallback)invocationOnMock.getArgument(6);
            ReadLastConfirmedAndEntryContext context = (ReadLastConfirmedAndEntryContext)invocationOnMock.getArgument(7);
            ReadLastConfirmedAndEntryHolder holder = new ReadLastConfirmedAndEntryHolder(address, callback, context);
            log.info("Received read request to bookie {}", (Object)address);
            callbacks.put(address, holder);
            return null;
        }).when((Object)this.mockBookieClient)).readEntryWaitForLACUpdate((BookieId)ArgumentMatchers.any(BookieId.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean(), (BookkeeperInternalCallbacks.ReadEntryCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.ReadEntryCallback.class), ArgumentMatchers.any());
        CompletableFuture resultFuture = new CompletableFuture();
        ReadLastConfirmedAndEntryOp.LastConfirmedAndEntryCallback resultCallback = (rc, lastAddConfirmed, entry) -> {
            if (0 != rc) {
                FutureUtils.completeExceptionally((CompletableFuture)resultFuture, (Throwable)BKException.create((int)rc));
            } else {
                FutureUtils.complete((CompletableFuture)resultFuture, (Object)LastConfirmedAndEntryImpl.create((long)lastAddConfirmed, (LedgerEntry)entry));
            }
        };
        ReadLastConfirmedAndEntryOp op = new ReadLastConfirmedAndEntryOp(this.mockLh, this.mockClientCtx, this.mockLh.getCurrentEnsemble(), resultCallback, 1L, 10000L);
        op.initiate();
        while (callbacks.size() < 3) {
            log.info("Received {} read requests", (Object)callbacks.size());
            Thread.sleep(100L);
        }
        log.info("All speculative reads are outstanding now.");
        Iterator iter = callbacks.entrySet().iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Map.Entry firstBookieEntry = iter.next();
        ReadLastConfirmedAndEntryHolder firstBookieHolder = (ReadLastConfirmedAndEntryHolder)firstBookieEntry.getValue();
        ReadLastConfirmedAndEntryContext firstContext = firstBookieHolder.context;
        firstContext.setLastAddConfirmed(2L);
        firstBookieHolder.getCallback().readEntryComplete(0, LEDGERID, -1L, null, (Object)firstContext);
        LedgerEntryImpl entry2 = LedgerEntryImpl.create((long)LEDGERID, (long)Long.MAX_VALUE);
        Assert.assertTrue((boolean)iter.hasNext());
        Map.Entry secondBookieEntry = iter.next();
        ReadLastConfirmedAndEntryHolder secondBookieHolder = (ReadLastConfirmedAndEntryHolder)secondBookieEntry.getValue();
        ReadLastConfirmedAndEntryContext secondContext = secondBookieHolder.context;
        secondContext.setLastAddConfirmed(2L);
        secondBookieHolder.getCallback().readEntryComplete(0, LEDGERID, 2L, Unpooled.wrappedBuffer((byte[])bytesWithDigest), (Object)secondContext);
        Assert.assertNull((Object)entry2.getEntryBuffer());
        entry2.close();
        try (LastConfirmedAndEntry lacAndEntry = (LastConfirmedAndEntry)FutureUtils.result(resultFuture);){
            Assert.assertEquals((long)2L, (long)lacAndEntry.getLastAddConfirmed());
            Assert.assertNull((Object)lacAndEntry.getEntry());
        }
    }

    static class ReadLastConfirmedAndEntryHolder {
        private final BookieId address;
        private final BookkeeperInternalCallbacks.ReadEntryCallback callback;
        private final ReadLastConfirmedAndEntryContext context;

        public ReadLastConfirmedAndEntryHolder(BookieId address, BookkeeperInternalCallbacks.ReadEntryCallback callback, ReadLastConfirmedAndEntryContext context) {
            this.address = address;
            this.callback = callback;
            this.context = context;
        }

        public BookieId getAddress() {
            return this.address;
        }

        public BookkeeperInternalCallbacks.ReadEntryCallback getCallback() {
            return this.callback;
        }

        public ReadLastConfirmedAndEntryContext getContext() {
            return this.context;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadLastConfirmedAndEntryHolder)) {
                return false;
            }
            ReadLastConfirmedAndEntryHolder other = (ReadLastConfirmedAndEntryHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BookieId this$address = this.getAddress();
            BookieId other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            BookkeeperInternalCallbacks.ReadEntryCallback this$callback = this.getCallback();
            BookkeeperInternalCallbacks.ReadEntryCallback other$callback = other.getCallback();
            if (this$callback == null ? other$callback != null : !this$callback.equals(other$callback)) {
                return false;
            }
            ReadLastConfirmedAndEntryContext this$context = this.getContext();
            ReadLastConfirmedAndEntryContext other$context = other.getContext();
            return !(this$context == null ? other$context != null : !this$context.equals(other$context));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReadLastConfirmedAndEntryHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BookieId $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            BookkeeperInternalCallbacks.ReadEntryCallback $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            ReadLastConfirmedAndEntryContext $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : $context.hashCode());
            return result;
        }

        public String toString() {
            return "ReadLastConfirmedAndEntryOpTest.ReadLastConfirmedAndEntryHolder(address=" + this.getAddress() + ", callback=" + this.getCallback() + ", context=" + this.getContext() + ")";
        }
    }
}

