/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.ClientUtil;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.MockClientContext;
import org.apache.bookkeeper.client.ReadOnlyLedgerHandle;
import org.apache.bookkeeper.client.SyncCallbackUtils;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.MockBookies;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.versioning.Versioned;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerRecovery2Test {
    private static final Logger log = LoggerFactory.getLogger(LedgerRecovery2Test.class);
    private static final byte[] PASSWD = "foobar".getBytes();
    private static final BookieId b1 = new BookieSocketAddress("b1", 3181).toBookieId();
    private static final BookieId b2 = new BookieSocketAddress("b2", 3181).toBookieId();
    private static final BookieId b3 = new BookieSocketAddress("b3", 3181).toBookieId();
    private static final BookieId b4 = new BookieSocketAddress("b4", 3181).toBookieId();
    private static final BookieId b5 = new BookieSocketAddress("b5", 3181).toBookieId();

    private static Versioned<LedgerMetadata> setupLedger(ClientContext clientCtx, long ledgerId, List<BookieId> bookies) throws Exception {
        LedgerMetadata md = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(PASSWD).withDigestType(DigestType.CRC32C).withWriteQuorumSize(bookies.size()).newEnsembleEntry(0L, bookies).build();
        return (Versioned)clientCtx.getLedgerManager().createLedgerMetadata(ledgerId, md).get();
    }

    private static Versioned<LedgerMetadata> setupLedger(ClientContext clientCtx, long ledgerId, List<BookieId> bookies, int ensembleSize, int writeQuorumSize, int ackQuorumSize) throws Exception {
        LedgerMetadata md = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(PASSWD).withDigestType(DigestType.CRC32C).withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).newEnsembleEntry(0L, bookies).build();
        return (Versioned)clientCtx.getLedgerManager().createLedgerMetadata(ledgerId, md).get();
    }

    @Test
    public void testCantRecoverAllDown() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        clientCtx.getMockBookieClient().errorBookies(b1, b2, b3);
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        try {
            BookkeeperInternalCallbacks.GenericCallbackFuture promise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
            lh.recover((BookkeeperInternalCallbacks.GenericCallback)promise, null, false);
            promise.get();
            Assert.fail((String)"Recovery shouldn't have been able to complete");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(BKException.BKReadException.class, ee.getCause().getClass());
        }
    }

    @Test
    public void testCanReadLacButCantWrite() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        clientCtx.getMockBookieClient().getMockBookies().seedEntries(b1, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> FutureUtils.exception((Throwable)new BKException.BKWriteException()));
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        try {
            BookkeeperInternalCallbacks.GenericCallbackFuture promise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
            lh.recover((BookkeeperInternalCallbacks.GenericCallback)promise, null, false);
            promise.get();
            Assert.fail((String)"Recovery shouldn't have been able to complete");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(BKException.BKNotEnoughBookiesException.class, ee.getCause().getClass());
        }
    }

    @Test
    public void testMetadataClosedDuringRecovery() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        CompletableFuture writingBack = new CompletableFuture();
        CompletableFuture<Object> blocker = new CompletableFuture<Object>();
        clientCtx.getMockBookieClient().getMockBookies().seedEntries(b1, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> {
            writingBack.complete(null);
            return blocker;
        });
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        BookkeeperInternalCallbacks.GenericCallbackFuture recoveryPromise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
        lh.recover((BookkeeperInternalCallbacks.GenericCallback)recoveryPromise, null, false);
        writingBack.get(10L, TimeUnit.SECONDS);
        ClientUtil.transformMetadata(clientCtx, 1L, metadata -> LedgerMetadataBuilder.from((LedgerMetadata)metadata).withClosedState().withLastEntryId(-1L).withLength(0L).build());
        blocker.complete(null);
        recoveryPromise.get();
        Assert.assertEquals((long)lh.getLastAddConfirmed(), (long)-1L);
        Assert.assertEquals((long)lh.getLength(), (long)0L);
    }

    @Test
    public void testNewEnsembleAddedDuringRecovery() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        CompletableFuture writingBack = new CompletableFuture();
        CompletableFuture<Object> blocker = new CompletableFuture<Object>();
        CompletableFuture failing = new CompletableFuture();
        clientCtx.getMockBookieClient().getMockBookies().seedEntries(b1, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> {
            writingBack.complete(null);
            if (bookie.equals((Object)b3)) {
                return failing;
            }
            return blocker;
        });
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        BookkeeperInternalCallbacks.GenericCallbackFuture recoveryPromise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
        lh.recover((BookkeeperInternalCallbacks.GenericCallback)recoveryPromise, null, false);
        writingBack.get(10L, TimeUnit.SECONDS);
        ClientUtil.transformMetadata(clientCtx, 1L, metadata -> LedgerMetadataBuilder.from((LedgerMetadata)metadata).newEnsembleEntry(1L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b4})).build());
        failing.completeExceptionally(new BKException.BKWriteException());
        blocker.complete(null);
        try {
            recoveryPromise.get();
            Assert.fail((String)"Should fail on the update");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(BKException.BKUnexpectedConditionException.class, ee.getCause().getClass());
        }
    }

    @Test
    public void testRecoveryBookieFailedAtStart() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        CompletableFuture writingBack = new CompletableFuture();
        CompletableFuture blocker = new CompletableFuture();
        CompletableFuture failing = new CompletableFuture();
        clientCtx.getMockBookieClient().getMockBookies().seedEntries(b1, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().errorBookies(b2);
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        BookkeeperInternalCallbacks.GenericCallbackFuture recoveryPromise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
        lh.recover((BookkeeperInternalCallbacks.GenericCallback)recoveryPromise, null, false);
        recoveryPromise.get();
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b4, b3}));
    }

    @Test
    public void testRecoveryOneBookieFailsDuring() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        clientCtx.getMockBookieClient().getMockBookies().seedEntries(b1, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().getMockBookies().seedEntries(b3, 1L, 1L, -1L);
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> {
            if (bookie.equals((Object)b2) && entryId == 1L) {
                return FutureUtils.exception((Throwable)new BKException.BKWriteException());
            }
            return FutureUtils.value(null);
        });
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        BookkeeperInternalCallbacks.GenericCallbackFuture recoveryPromise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
        lh.recover((BookkeeperInternalCallbacks.GenericCallback)recoveryPromise, null, false);
        recoveryPromise.get();
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)2L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(1L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b4, b3}));
        Assert.assertEquals((long)lh.getLastAddConfirmed(), (long)1L);
    }

    @Test
    public void testRecoveryTwoBookiesFailOnSameEntry() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        clientCtx.getMockRegistrationClient().addBookies(b4, b5).get();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        clientCtx.getMockBookieClient().getMockBookies().seedEntries(b1, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> {
            if (bookie.equals((Object)b1) || bookie.equals((Object)b2)) {
                return FutureUtils.exception((Throwable)new BKException.BKWriteException());
            }
            return FutureUtils.value(null);
        });
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        BookkeeperInternalCallbacks.GenericCallbackFuture recoveryPromise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
        lh.recover((BookkeeperInternalCallbacks.GenericCallback)recoveryPromise, null, false);
        recoveryPromise.get();
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
        Assert.assertTrue((boolean)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).contains(b3));
        Assert.assertTrue((boolean)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).contains(b4));
        Assert.assertTrue((boolean)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).contains(b5));
        Assert.assertEquals((long)lh.getLastAddConfirmed(), (long)0L);
    }

    @Test
    public void testFirstWriterCannotCommitWriteAfter2ndWriterCloses() throws Exception {
        CompletableFuture<Void> reachedStep1 = new CompletableFuture<Void>();
        CompletableFuture<Void> reachedStep2 = new CompletableFuture<Void>();
        CompletableFuture<Void> reachedStep3 = new CompletableFuture<Void>();
        CompletableFuture<Void> reachedStep4 = new CompletableFuture<Void>();
        CompletableFuture<Void> reachedStep5 = new CompletableFuture<Void>();
        CompletableFuture<Void> reachedStep6 = new CompletableFuture<Void>();
        CompletableFuture<Void> reachedStep7 = new CompletableFuture<Void>();
        CompletableFuture<Void> reachedStep8 = new CompletableFuture<Void>();
        CompletableFuture<Void> reachedStep9 = new CompletableFuture<Void>();
        MockBookies mockBookies = new MockBookies();
        MockClientContext clientCtx1 = MockClientContext.create(mockBookies);
        Versioned<LedgerMetadata> md1 = LedgerRecovery2Test.setupLedger(clientCtx1, 1L, Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        CompletableFuture blockB1Write = new CompletableFuture();
        CompletableFuture<Object> blockB2Write = new CompletableFuture<Object>();
        CompletableFuture<Object> blockB3Write = new CompletableFuture<Object>();
        clientCtx1.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> {
            if (entryId < 2L) {
                return FutureUtils.value(null);
            }
            if (!reachedStep1.isDone()) {
                reachedStep1.complete(null);
            }
            if (bookie.equals((Object)b1)) {
                return blockB1Write;
            }
            if (bookie.equals((Object)b2)) {
                reachedStep9.complete(null);
                return blockB2Write;
            }
            if (bookie.equals((Object)b3)) {
                reachedStep3.complete(null);
                return blockB3Write;
            }
            return FutureUtils.value(null);
        });
        LedgerHandle w1 = new LedgerHandle((ClientContext)clientCtx1, 1L, md1, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        w1.addEntry("e0".getBytes(StandardCharsets.UTF_8));
        w1.addEntry("e1".getBytes(StandardCharsets.UTF_8));
        MockClientContext clientCtx2 = MockClientContext.create(mockBookies);
        Versioned<LedgerMetadata> md2 = LedgerRecovery2Test.setupLedger(clientCtx2, 1L, Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        CompletableFuture<Object> blockB1ReadLac = new CompletableFuture<Object>();
        CompletableFuture<Object> blockB2ReadLac = new CompletableFuture<Object>();
        CompletableFuture<Object> blockB3ReadLac = new CompletableFuture<Object>();
        CompletableFuture<Object> blockB1ReadEntry0 = new CompletableFuture<Object>();
        CompletableFuture<Object> blockB2ReadEntry0 = new CompletableFuture<Object>();
        CompletableFuture blockB3ReadEntry0 = new CompletableFuture();
        AtomicBoolean isB1LacRead = new AtomicBoolean(true);
        AtomicBoolean isB2LacRead = new AtomicBoolean(true);
        AtomicBoolean isB3LacRead = new AtomicBoolean(true);
        clientCtx2.getMockBookieClient().setPreReadHook((bookie, ledgerId, entryId) -> {
            if (bookie.equals((Object)b1)) {
                if (isB1LacRead.get()) {
                    isB1LacRead.set(false);
                    reachedStep2.complete(null);
                    return blockB1ReadLac;
                }
                reachedStep6.complete(null);
                return blockB1ReadEntry0;
            }
            if (bookie.equals((Object)b2)) {
                if (isB2LacRead.get()) {
                    try {
                        isB2LacRead.set(false);
                        reachedStep4.complete(null);
                        blockB2ReadLac.get();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return FutureUtils.exception((Throwable)new BKException.BKWriteException());
                }
                reachedStep7.complete(null);
                return blockB2ReadEntry0;
            }
            if (bookie.equals((Object)b3)) {
                if (isB3LacRead.get()) {
                    isB3LacRead.set(false);
                    reachedStep5.complete(null);
                    return blockB3ReadLac;
                }
                return blockB3ReadEntry0;
            }
            return FutureUtils.value(null);
        });
        AtomicInteger w2MetaUpdates = new AtomicInteger(0);
        CompletableFuture<Object> blockW2StartingRecovery = new CompletableFuture<Object>();
        CompletableFuture<Object> blockW2ClosingLedger = new CompletableFuture<Object>();
        clientCtx2.getMockLedgerManager().setPreWriteHook((ledgerId, metadata) -> {
            if (w2MetaUpdates.get() == 0) {
                w2MetaUpdates.incrementAndGet();
                return blockW2StartingRecovery;
            }
            reachedStep8.complete(null);
            return blockW2ClosingLedger;
        });
        ReadOnlyLedgerHandle w2 = new ReadOnlyLedgerHandle((ClientContext)clientCtx2, 1L, md2, BookKeeper.DigestType.CRC32C, PASSWD, false);
        CompletableFuture w1WriteFuture = new CompletableFuture();
        AtomicInteger writeResult = new AtomicInteger(0);
        w1.asyncAddEntry("e2".getBytes(), (rc, lh1, entryId, ctx) -> {
            if (rc == 0) {
                writeResult.set(1);
            } else {
                writeResult.set(2);
            }
            SyncCallbackUtils.finish((int)rc, null, (CompletableFuture)w1WriteFuture);
        }, null);
        this.stepBlock(reachedStep1);
        BookkeeperInternalCallbacks.GenericCallbackFuture recoveryPromise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
        w2.recover((BookkeeperInternalCallbacks.GenericCallback)recoveryPromise, null, false);
        blockW2StartingRecovery.complete(null);
        this.stepBlock(reachedStep2);
        blockB1ReadLac.complete(null);
        this.stepBlock(reachedStep3);
        blockB3Write.complete(null);
        this.stepBlock(reachedStep4);
        blockB2ReadLac.complete(null);
        this.stepBlock(reachedStep5);
        blockB3ReadLac.complete(null);
        this.stepBlock(reachedStep6);
        blockB1ReadEntry0.complete(null);
        this.stepBlock(reachedStep7);
        blockB2ReadEntry0.complete(null);
        this.stepBlock(reachedStep8);
        blockW2ClosingLedger.complete(null);
        this.stepBlock(reachedStep9);
        blockB2Write.complete(null);
        try {
            w1WriteFuture.get(200L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"The write to b2 should have failed as it was fenced by the recovery read of step 7");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof BKException.BKLedgerFencedException));
        }
        Assert.assertEquals((long)1L, (long)w1.getLedgerMetadata().getAllEnsembles().size());
        Assert.assertEquals((long)2L, (long)writeResult.get());
        Assert.assertEquals((long)1L, (long)w1.getLastAddConfirmed());
        Assert.assertEquals((long)1L, (long)w2.getLedgerMetadata().getAllEnsembles().size());
        Assert.assertEquals((long)1L, (long)w2.getLastAddConfirmed());
    }

    private void stepBlock(CompletableFuture<Void> reachedStepFuture) {
        try {
            reachedStepFuture.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRecoveryWhenSecondEnsembleReturnsLacMinusOne() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieId[]{b1, b2}), 2, 2, 2);
        clientCtx.getMockBookieClient().getMockBookies().seedEntries(b1, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().getMockBookies().seedEntries(b2, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().getMockBookies().seedEntries(b1, 1L, 1L, -1L);
        ClientUtil.transformMetadata(clientCtx, 1L, metadata -> LedgerMetadataBuilder.from((LedgerMetadata)metadata).newEnsembleEntry(1L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b3})).build());
        clientCtx.getMockBookieClient().getMockBookies().seedEntries(b3, 1L, 1L, 0L);
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> {
            if (bookie.equals((Object)b3)) {
                return FutureUtils.exception((Throwable)new BKException.BKWriteException());
            }
            return FutureUtils.value(null);
        });
        clientCtx.getMockBookieClient().setPreReadHook((bookie, ledgerId, entryId) -> {
            if (bookie.equals((Object)b3)) {
                return FutureUtils.exception((Throwable)new BKException.BKTimeoutException());
            }
            return FutureUtils.value(null);
        });
        BookkeeperInternalCallbacks.GenericCallbackFuture recoveryPromise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
        lh.recover((BookkeeperInternalCallbacks.GenericCallback)recoveryPromise, null, false);
        recoveryPromise.get();
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)2L);
        Assert.assertTrue((boolean)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).contains(b1));
        Assert.assertTrue((boolean)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).contains(b2));
        Assert.assertTrue((boolean)((List)lh.getLedgerMetadata().getAllEnsembles().get(1L)).contains(b1));
        Assert.assertTrue((boolean)((List)lh.getLedgerMetadata().getAllEnsembles().get(1L)).contains(b4));
        Assert.assertEquals((long)lh.getLastAddConfirmed(), (long)1L);
        Assert.assertEquals((long)lh.getLedgerMetadata().getLastEntryId(), (long)1L);
    }
}

