/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import org.apache.bookkeeper.client.BookieAddressResolverDisabled;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieAddressResolver;
import org.junit.Assert;
import org.junit.Test;

public class BookieAddressResolverDisabledTest {
    @Test
    public void testResolve() {
        BookieAddressResolverDisabled resolver = new BookieAddressResolverDisabled();
        BookieSocketAddress addr1 = resolver.resolve(BookieId.parse((String)"127.0.0.1:3181"));
        Assert.assertEquals((Object)"127.0.0.1", (Object)addr1.getHostName());
        Assert.assertEquals((long)3181L, (long)addr1.getPort());
        BookieSocketAddress addr2 = resolver.resolve(BookieId.parse((String)"localhost:3182"));
        Assert.assertEquals((Object)"localhost", (Object)addr2.getHostName());
        Assert.assertEquals((long)3182L, (long)addr2.getPort());
        try {
            resolver.resolve(BookieId.parse((String)"foobar"));
            Assert.fail((String)"Non-legacy style bookie id should fail to resolve address");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BookieAddressResolver.BookieIdNotResolvedException));
        }
    }
}

