/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.shaded.com.google.common.collect.Sets;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class ConversionTest {
    CheckpointSource checkpointSource = new CheckpointSource(){

        public CheckpointSource.Checkpoint newCheckpoint() {
            return CheckpointSource.Checkpoint.MAX;
        }

        public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
        }
    };
    Checkpointer checkpointer = new Checkpointer(){

        public void startCheckpoint(CheckpointSource.Checkpoint checkpoint) {
        }

        public void start() {
        }
    };

    @Test
    public void test() throws Exception {
        File tmpDir = File.createTempFile("bkTest", ".dir");
        tmpDir.delete();
        tmpDir.mkdir();
        File curDir = BookieImpl.getCurrentDirectory((File)tmpDir);
        BookieImpl.checkDirectoryStructure((File)curDir);
        System.out.println(tmpDir);
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setLedgerDirNames(new String[]{tmpDir.toString()});
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
        InterleavedLedgerStorage interleavedStorage = new InterleavedLedgerStorage();
        interleavedStorage.initialize(conf, null, ledgerDirsManager, ledgerDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        interleavedStorage.setCheckpointSource(this.checkpointSource);
        interleavedStorage.setCheckpointer(this.checkpointer);
        for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
            interleavedStorage.setMasterKey(ledgerId, ("ledger-" + ledgerId).getBytes());
            interleavedStorage.setFenced(ledgerId);
            for (long entryId = 0L; entryId < 10000L; ++entryId) {
                ByteBuf entry = Unpooled.buffer((int)128);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId);
                entry.writeBytes(("entry-" + entryId).getBytes());
                interleavedStorage.addEntry(entry);
            }
        }
        interleavedStorage.flush();
        interleavedStorage.shutdown();
        BookieShell shell = new BookieShell();
        shell.setConf((CompositeConfiguration)conf);
        int res = shell.run(new String[]{"convert-to-db-storage"});
        Assert.assertEquals((long)0L, (long)res);
        DbLedgerStorage dbStorage = new DbLedgerStorage();
        dbStorage.initialize(conf, null, ledgerDirsManager, ledgerDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        dbStorage.setCheckpointer(this.checkpointer);
        dbStorage.setCheckpointSource(this.checkpointSource);
        interleavedStorage = new InterleavedLedgerStorage();
        interleavedStorage.initialize(conf, null, ledgerDirsManager, ledgerDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        interleavedStorage.setCheckpointSource(this.checkpointSource);
        interleavedStorage.setCheckpointer(this.checkpointer);
        TreeSet ledgers = Sets.newTreeSet((Iterable)dbStorage.getActiveLedgersInRange(0L, Long.MAX_VALUE));
        Assert.assertEquals((Object)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new Long[]{0L, 1L, 2L, 3L, 4L})), (Object)ledgers);
        ledgers = Sets.newTreeSet((Iterable)interleavedStorage.getActiveLedgersInRange(0L, Long.MAX_VALUE));
        Assert.assertEquals((Object)Sets.newTreeSet(), (Object)ledgers);
        for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
            Assert.assertEquals((Object)true, (Object)dbStorage.isFenced(ledgerId));
            Assert.assertEquals((Object)("ledger-" + ledgerId), (Object)new String(dbStorage.readMasterKey(ledgerId)));
            for (long entryId = 0L; entryId < 10000L; ++entryId) {
                ByteBuf entry = Unpooled.buffer((int)1024);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId);
                entry.writeBytes(("entry-" + entryId).getBytes());
                ByteBuf result = dbStorage.getEntry(ledgerId, entryId);
                Assert.assertEquals((Object)entry, (Object)result);
                result.release();
                try {
                    interleavedStorage.getEntry(ledgerId, entryId);
                    Assert.fail((String)"entry should not exist");
                    continue;
                }
                catch (Bookie.NoLedgerException noLedgerException) {
                    // empty catch block
                }
            }
        }
        interleavedStorage.shutdown();
        dbStorage.shutdown();
        FileUtils.forceDelete((File)tmpDir);
    }
}

