/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.bookie.SkipListArena;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.shaded.com.google.common.primitives.Ints;
import org.junit.Assert;
import org.junit.Test;

public class SkipListArenaTest {
    final CustomConfiguration cfg = new CustomConfiguration();

    @Test
    public void testRandomAllocation() {
        Random rand = new Random();
        SkipListArena arena = new SkipListArena((ServerConfiguration)this.cfg);
        int expectedOff = 0;
        byte[] lastBuffer = null;
        for (int i = 0; i < 10000; ++i) {
            int size = rand.nextInt(512);
            SkipListArena.MemorySlice alloc = arena.allocateBytes(size);
            if (alloc.getData() != lastBuffer) {
                expectedOff = 0;
                lastBuffer = alloc.getData();
            }
            Assert.assertTrue((expectedOff == alloc.getOffset() ? 1 : 0) != 0);
            Assert.assertTrue((String)("Allocation " + alloc + " overruns buffer"), (alloc.getOffset() + size <= alloc.getData().length ? 1 : 0) != 0);
            expectedOff += size;
        }
    }

    @Test
    public void testLargeAllocation() {
        SkipListArena arena = new SkipListArena((ServerConfiguration)this.cfg);
        SkipListArena.MemorySlice alloc = arena.allocateBytes(2048);
        Assert.assertNull((String)"2KB allocation shouldn't be satisfied by LAB.", (Object)alloc);
    }

    private Thread getAllocThread(final ConcurrentLinkedQueue<AllocBuffer> queue, final CountDownLatch latch, final SkipListArena arena) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                Random rand = new Random();
                for (int j = 0; j < 1000; ++j) {
                    int size = rand.nextInt(512);
                    SkipListArena.MemorySlice alloc = arena.allocateBytes(size);
                    queue.add(new AllocBuffer(alloc, size));
                }
                latch.countDown();
            }
        });
    }

    @Test
    public void testConcurrency() throws Exception {
        SkipListArena arena = new SkipListArena((ServerConfiguration)this.cfg);
        CountDownLatch latch = new CountDownLatch(10);
        ConcurrentLinkedQueue<AllocBuffer> queue = new ConcurrentLinkedQueue<AllocBuffer>();
        HashSet<Thread> testThreads = new HashSet<Thread>();
        for (int i = 0; i < 10; ++i) {
            testThreads.add(this.getAllocThread(queue, latch, arena));
        }
        for (Thread thread : testThreads) {
            thread.start();
        }
        latch.await();
        HashMap<ByteArray, TreeMap<Integer, AllocBuffer>> mapsByArray = new HashMap<ByteArray, TreeMap<Integer, AllocBuffer>>();
        boolean overlapped = false;
        AllocBuffer[] buffers = queue.toArray(new AllocBuffer[0]);
        for (AllocBuffer buf : buffers) {
            AllocBuffer other;
            if (buf.size == 0) continue;
            ByteArray ptr = new ByteArray(buf.alloc.getData());
            TreeMap<Integer, AllocBuffer> treeMap = (TreeMap<Integer, AllocBuffer>)mapsByArray.get(ptr);
            if (treeMap == null) {
                treeMap = new TreeMap<Integer, AllocBuffer>();
                mapsByArray.put(ptr, treeMap);
            }
            if ((other = treeMap.put(buf.alloc.getOffset(), buf)) == null) continue;
            Assert.fail((String)("Buffer " + other.toString() + " overlapped with " + buf.toString()));
        }
        for (Map treeMap : mapsByArray.values()) {
            int expectedOff = 0;
            for (AllocBuffer buf : treeMap.values()) {
                Assert.assertEquals((long)expectedOff, (long)buf.alloc.getOffset());
                expectedOff += buf.size;
            }
        }
    }

    private static class AllocBuffer
    implements Comparable<AllocBuffer> {
        private final SkipListArena.MemorySlice alloc;
        private final int size;

        public AllocBuffer(SkipListArena.MemorySlice alloc, int size) {
            this.alloc = alloc;
            this.size = size;
        }

        @Override
        public int compareTo(AllocBuffer e) {
            Assert.assertTrue((this.alloc.getData() == e.alloc.getData() ? 1 : 0) != 0);
            return Ints.compare((int)this.alloc.getOffset(), (int)e.alloc.getOffset());
        }

        public String toString() {
            return this.alloc + ":" + this.size;
        }
    }

    private class ByteArray {
        final byte[] bytes;

        ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public int hashCode() {
            return this.bytes.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ByteArray) {
                ByteArray other = (ByteArray)object;
                return this.bytes.equals(other.bytes);
            }
            return false;
        }
    }

    class CustomConfiguration
    extends ServerConfiguration {
        CustomConfiguration() {
        }

        public int getSkipListArenaChunkSize() {
            return 4096;
        }

        public int getSkipListArenaMaxAllocSize() {
            return 1024;
        }

        public boolean getJournalFlushWhenQueueEmpty() {
            return true;
        }
    }
}

