/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.NullAppender;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOrderedExecutorDecorators {
    private static final Logger log = LoggerFactory.getLogger(TestOrderedExecutorDecorators.class);
    private static final String MDC_KEY = "mdc-key";
    private NullAppender mockAppender;
    private final Queue<String> capturedEvents = new ConcurrentLinkedQueue<String>();

    public static String mdcFormat(Object mdc, String message) {
        return String.format("[%s:%s] %s", MDC_KEY, mdc, message);
    }

    @Before
    public void setUp() throws Exception {
        ThreadContext.clearMap();
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        this.mockAppender = (NullAppender)Mockito.spy((Object)NullAppender.createAppender((String)UUID.randomUUID().toString()));
        this.mockAppender.start();
        lc.getConfiguration().addAppender((Appender)this.mockAppender);
        lc.getRootLogger().addAppender(lc.getConfiguration().getAppender(this.mockAppender.getName()));
        lc.getConfiguration().getRootLogger().setLevel(Level.INFO);
        lc.updateLoggers();
        ((NullAppender)Mockito.doAnswer((Answer)AdditionalAnswers.answerVoid(event -> this.capturedEvents.add(TestOrderedExecutorDecorators.mdcFormat(event.getContextData().getValue(MDC_KEY), event.getMessage().getFormattedMessage())))).when((Object)this.mockAppender)).append((LogEvent)ArgumentMatchers.any());
    }

    @After
    public void tearDown() throws Exception {
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        lc.getRootLogger().removeAppender(lc.getConfiguration().getAppender(this.mockAppender.getName()));
        lc.updateLoggers();
        this.capturedEvents.clear();
        ThreadContext.clearMap();
    }

    @Test
    public void testMDCInvokeOrdered() throws Exception {
        OrderedExecutor executor = OrderedExecutor.newBuilder().name("test").numThreads(20).preserveMdcForTaskExecution(true).build();
        try {
            ThreadContext.put((String)MDC_KEY, (String)"testMDCInvokeOrdered");
            executor.submitOrdered(10L, () -> {
                log.info("foobar");
                return 10;
            }).get();
            Assert.assertThat(this.capturedEvents, (Matcher)Matchers.hasItem((Object)TestOrderedExecutorDecorators.mdcFormat("testMDCInvokeOrdered", "foobar")));
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    public void testMDCInvokeDirectOnChosen() throws Exception {
        OrderedExecutor executor = OrderedExecutor.newBuilder().name("test").numThreads(20).preserveMdcForTaskExecution(true).build();
        try {
            ThreadContext.put((String)MDC_KEY, (String)"testMDCInvokeOrdered");
            executor.chooseThread(10L).submit(() -> {
                log.info("foobar");
                return 10;
            }).get();
            Assert.assertThat(this.capturedEvents, (Matcher)Matchers.hasItem((Object)TestOrderedExecutorDecorators.mdcFormat("testMDCInvokeOrdered", "foobar")));
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    public void testMDCScheduleOrdered() throws Exception {
        OrderedScheduler scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test").numThreads(20).preserveMdcForTaskExecution(true).build();
        try {
            ThreadContext.put((String)MDC_KEY, (String)"testMDCInvokeOrdered");
            scheduler.scheduleOrdered((Object)10, SafeRunnable.safeRun(() -> log.info("foobar")), 0L, TimeUnit.DAYS).get();
            Assert.assertThat(this.capturedEvents, (Matcher)Matchers.hasItem((Object)TestOrderedExecutorDecorators.mdcFormat("testMDCInvokeOrdered", "foobar")));
        }
        finally {
            scheduler.shutdown();
        }
    }

    @Test
    public void testMDCScheduleDirectOnChosen() throws Exception {
        OrderedScheduler scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test").numThreads(20).preserveMdcForTaskExecution(true).build();
        try {
            ThreadContext.put((String)MDC_KEY, (String)"testMDCInvokeOrdered");
            scheduler.chooseThread(10L).schedule((Runnable)SafeRunnable.safeRun(() -> log.info("foobar")), 0L, TimeUnit.DAYS).get();
            Assert.assertThat(this.capturedEvents, (Matcher)Matchers.hasItem((Object)TestOrderedExecutorDecorators.mdcFormat("testMDCInvokeOrdered", "foobar")));
        }
        finally {
            scheduler.shutdown();
        }
    }
}

