/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.testing.executors;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.testing.executors.MockExecutorController;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MockExecutorControllerTest {
    private static final int MAX_SCHEDULES = 5;
    private ScheduledExecutorService executor;
    private MockExecutorController mockExecutorControl;

    @Before
    public void setup() {
        this.executor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        this.mockExecutorControl = new MockExecutorController().controlExecute(this.executor).controlSubmit(this.executor).controlSchedule(this.executor).controlScheduleAtFixedRate(this.executor, 5);
    }

    @Test
    public void testSubmit() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        ((Runnable)Mockito.doNothing().when((Object)task)).run();
        this.executor.submit(task);
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void testExecute() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        ((Runnable)Mockito.doNothing().when((Object)task)).run();
        this.executor.execute(task);
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void testDelay() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        ((Runnable)Mockito.doNothing().when((Object)task)).run();
        this.executor.schedule(task, 10L, TimeUnit.MILLISECONDS);
        this.mockExecutorControl.advance(Duration.ofMillis(5L));
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)0))).run();
        this.mockExecutorControl.advance(Duration.ofMillis(10L));
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void testScheduleAtFixedRate() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        ((Runnable)Mockito.doNothing().when((Object)task)).run();
        this.executor.scheduleAtFixedRate(task, 5L, 10L, TimeUnit.MILLISECONDS);
        this.mockExecutorControl.advance(Duration.ofMillis(2L));
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)0))).run();
        this.mockExecutorControl.advance(Duration.ofMillis(3L));
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)1))).run();
        for (int i = 1; i < 5; ++i) {
            this.mockExecutorControl.advance(Duration.ofMillis(2L));
            ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)i))).run();
            this.mockExecutorControl.advance(Duration.ofMillis(8L));
            ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)(i + 1)))).run();
        }
        this.mockExecutorControl.advance(Duration.ofMillis(500L));
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)5))).run();
    }
}

