/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.conf.validators;

import java.util.function.Function;
import org.apache.bookkeeper.common.conf.validators.ClassValidator;
import org.junit.Assert;
import org.junit.Test;

public class ClassValidatorTest {
    @Test
    public void testValidateStrings() {
        ClassValidator validator = ClassValidator.of(Function.class);
        Assert.assertTrue((boolean)validator.validate("test-valid-classname", (Object)TestFunction.class.getName()));
        Assert.assertFalse((boolean)validator.validate("test-invalid-classname", (Object)"unknown"));
    }

    @Test
    public void testValidateClass() {
        ClassValidator validator = ClassValidator.of(Function.class);
        Assert.assertTrue((boolean)validator.validate("test-valid-class", TestFunction.class));
        Assert.assertFalse((boolean)validator.validate("test-invalid-class", Integer.class));
    }

    @Test
    public void testValidateWrongType() {
        ClassValidator validator = ClassValidator.of(Function.class);
        Assert.assertFalse((boolean)validator.validate("test-invalid-type", (Object)12345));
    }

    private static class TestFunction
    implements Function<String, String> {
        private TestFunction() {
        }

        @Override
        public String apply(String s) {
            return s + "!";
        }
    }
}

