/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.conf;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.bookkeeper.common.conf.ConfigDef;
import org.apache.bookkeeper.common.conf.ConfigKey;
import org.apache.bookkeeper.common.conf.ConfigKeyGroup;
import org.apache.bookkeeper.common.conf.Type;
import org.apache.bookkeeper.common.conf.Validator;
import org.apache.bookkeeper.common.conf.validators.ClassValidator;
import org.apache.bookkeeper.common.conf.validators.RangeValidator;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDefTest {
    private static final Logger log = LoggerFactory.getLogger(ConfigDefTest.class);

    @Test
    public void testBuildConfigDef() {
        ConfigDef configDef = ConfigDef.of(TestConfig.class);
        Assert.assertEquals((long)2L, (long)configDef.getGroups().size());
        Iterator grpIter = configDef.getGroups().iterator();
        Assert.assertTrue((boolean)grpIter.hasNext());
        ConfigKeyGroup group1 = (ConfigKeyGroup)grpIter.next();
        Assert.assertSame((Object)TestConfig.group1, (Object)group1);
        Set keys = (Set)configDef.getSettings().get(group1.name());
        Assert.assertNotNull((Object)keys);
        Assert.assertEquals((long)1L, (long)keys.size());
        Assert.assertEquals((Object)TestConfig.key11, keys.iterator().next());
        Assert.assertTrue((boolean)grpIter.hasNext());
        ConfigKeyGroup group2 = (ConfigKeyGroup)grpIter.next();
        Assert.assertSame((Object)TestConfig.group2, (Object)group2);
        keys = (Set)configDef.getSettings().get(group2.name());
        Assert.assertNotNull((Object)keys);
        Assert.assertEquals((long)2L, (long)keys.size());
        Iterator keyIter = keys.iterator();
        Assert.assertEquals((Object)TestConfig.key22, keyIter.next());
        Assert.assertEquals((Object)TestConfig.key21, keyIter.next());
        Assert.assertFalse((boolean)keyIter.hasNext());
        Assert.assertFalse((boolean)grpIter.hasNext());
    }

    @Test
    public void testSaveConfigDef() throws IOException {
        String readConf;
        byte[] confData;
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("test_conf_2.conf");){
            confData = new byte[is.available()];
            ByteStreams.readFully((InputStream)is, (byte[])confData);
        }
        ConfigDef configDef = ConfigDef.of(TestConfig2.class);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            configDef.save((OutputStream)baos);
            readConf = baos.toString();
            log.info("\n{}", (Object)readConf);
        }
        Assert.assertEquals((Object)new String(confData, StandardCharsets.UTF_8), (Object)readConf);
    }

    private static class TestConfig2 {
        private static final ConfigKeyGroup emptyGroup = ConfigKeyGroup.builder((String)"empty_group").description("Empty Group Settings").order(1).build();
        private static final ConfigKeyGroup group1 = ConfigKeyGroup.builder((String)"group1").description("This is a very long description : Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas bibendum ac felis id commodo. Etiam mauris purus, fringilla id tempus in, mollis vel orci. Duis ultricies at erat eget iaculis.").order(2).build();
        private static final ConfigKey intKey = ConfigKey.builder((String)"int_key").type(Type.INT).description("it is an int key").group(group1).validator((Validator)RangeValidator.atLeast((Number)1000)).build();
        private static final ConfigKey longKey = ConfigKey.builder((String)"long_key").type(Type.LONG).description("it is a long key").group(group1).validator((Validator)RangeValidator.atMost((Number)1000)).build();
        private static final ConfigKey shortKey = ConfigKey.builder((String)"short_key").type(Type.SHORT).description("it is a short key").group(group1).validator((Validator)RangeValidator.between((Number)500, (Number)1000)).build();
        private static final ConfigKey doubleKey = ConfigKey.builder((String)"double_key").type(Type.DOUBLE).description("it is a double key").group(group1).validator((Validator)RangeValidator.between((Number)Float.valueOf(1234.0f), (Number)Float.valueOf(5678.0f))).build();
        private static final ConfigKey boolKey = ConfigKey.builder((String)"bool_key").type(Type.BOOLEAN).description("it is a bool key").group(group1).build();
        private static final ConfigKey classKey = ConfigKey.builder((String)"class_key").type(Type.CLASS).description("it is a class key").validator((Validator)ClassValidator.of(Runnable.class)).group(group1).build();
        private static final ConfigKey listKey = ConfigKey.builder((String)"list_key").type(Type.LIST).description("it is a list key").group(group1).build();
        private static final ConfigKey stringKey = ConfigKey.builder((String)"string_key").type(Type.STRING).description("it is a string key").group(group1).build();
        private static final ConfigKeyGroup group2 = ConfigKeyGroup.builder((String)"group2").description("This group has short description").order(3).build();
        private static final ConfigKey keyWithSince = ConfigKey.builder((String)"key_with_since").type(Type.STRING).description("it is a string key with since").since("4.7.0").group(group2).orderInGroup(10).build();
        private static final ConfigKey keyWithDocumentation = ConfigKey.builder((String)"key_with_short_documentation").type(Type.STRING).description("it is a string key with documentation").documentation("it has a short documentation").group(group2).orderInGroup(9).build();
        private static final ConfigKey keyWithLongDocumentation = ConfigKey.builder((String)"key_long_short_documentation").type(Type.STRING).description("it is a string key with documentation").documentation("it has a long documentation : Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas bibendum ac felis id commodo. Etiam mauris purus, fringilla id tempus in, mollis vel orci. Duis ultricies at erat eget iaculis.").group(group2).orderInGroup(8).build();
        private static final ConfigKey keyWithDefaultValue = ConfigKey.builder((String)"key_with_default_value").type(Type.STRING).description("it is a string key with default value").defaultValue((Object)"this-is-a-test-value").group(group2).orderInGroup(7).build();
        private static final ConfigKey keyWithOptionalValues = ConfigKey.builder((String)"key_with_optional_values").type(Type.STRING).description("it is a string key with optional values").defaultValue((Object)"this-is-a-default-value").optionValues((List)Lists.newArrayList((Object[])new String[]{"item1", "item2", "item3", "item3"})).group(group2).orderInGroup(6).build();
        private static final ConfigKey deprecatedKey = ConfigKey.builder((String)"deprecated_key").type(Type.STRING).deprecated(true).description("it is a deprecated key").group(group2).orderInGroup(5).build();
        private static final ConfigKey deprecatedKeyWithSince = ConfigKey.builder((String)"deprecated_key_with_since").type(Type.STRING).deprecated(true).deprecatedSince("4.3.0").description("it is a deprecated key with since").group(group2).orderInGroup(4).build();
        private static final ConfigKey deprecatedKeyWithReplacedKey = ConfigKey.builder((String)"deprecated_key_with_replaced_key").type(Type.STRING).deprecated(true).deprecatedByConfigKey("key_with_optional_values").description("it is a deprecated key with replaced key").group(group2).orderInGroup(3).build();
        private static final ConfigKey deprecatedKeyWithSinceAndReplacedKey = ConfigKey.builder((String)"deprecated_key_with_since_and_replaced_key").type(Type.STRING).deprecated(true).deprecatedSince("4.3.0").deprecatedByConfigKey("key_with_optional_values").description("it is a deprecated key with since and replaced key").group(group2).orderInGroup(2).build();
        private static final ConfigKey requiredKey = ConfigKey.builder((String)"required_key").type(Type.STRING).required(true).description("it is a required key").group(group2).orderInGroup(1).build();

        private TestConfig2() {
        }
    }

    private static class TestConfig {
        private static final ConfigKeyGroup group1 = ConfigKeyGroup.builder((String)"group1").description("Group 1 Settings").order(1).build();
        private static final ConfigKey key11 = ConfigKey.builder((String)"key11").type(Type.LONG).group(group1).validator((Validator)RangeValidator.atLeast((Number)1000)).build();
        private static final ConfigKeyGroup group2 = ConfigKeyGroup.builder((String)"group2").description("Group 2 Settings").order(2).build();
        private static final ConfigKey key21 = ConfigKey.builder((String)"key21").type(Type.LONG).group(group2).validator((Validator)RangeValidator.atMost((Number)1000)).orderInGroup(2).build();
        private static final ConfigKey key22 = ConfigKey.builder((String)"key22").type(Type.STRING).group(group2).validator((Validator)ClassValidator.of(Runnable.class)).orderInGroup(1).build();

        private TestConfig() {
        }
    }
}

