/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.extensions.hub.proxy.session;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.TestSession;

public class SeleniumSessions {
    private static final Pattern SESSION_ID_PATTERN = Pattern.compile("/session/([^/]+).*");
    private final GridRegistry registry;

    public SeleniumSessions(GridRegistry registry) {
        this.registry = registry;
    }

    public URL getRemoteHostForSession(String sessionId) {
        for (TestSession activeSession : this.registry.getActiveSessions()) {
            if (!sessionId.equals(activeSession.getExternalKey().getKey())) continue;
            return activeSession.getSlot().getProxy().getRemoteHost();
        }
        throw new IllegalArgumentException("Invalid sessionId. No active session is present for id:" + sessionId);
    }

    public void refreshTimeout(String sessionId) {
        for (TestSession activeSession : this.registry.getActiveSessions()) {
            if (!sessionId.equals(activeSession.getExternalKey().getKey())) continue;
            this.refreshTimeout(activeSession);
        }
    }

    private void refreshTimeout(TestSession activeSession) {
        if (activeSession.getInactivityTime() != 0L) {
            activeSession.setIgnoreTimeout(false);
        }
    }

    public static String getSessionIdFromPath(String pathInfo) {
        Matcher matcher = SESSION_ID_PATTERN.matcher(pathInfo);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Invalid request. Session Id is not present");
    }

    public static String trimSessionPath(String pathInfo) {
        return pathInfo.replaceFirst("/session/" + SeleniumSessions.getSessionIdFromPath(pathInfo), "");
    }
}

