/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.extensions.hub.proxy.client;

import io.sterodium.extensions.hub.proxy.client.HttpClientProvider;
import io.sterodium.extensions.hub.proxy.client.HttpResponseConverter;
import io.sterodium.extensions.hub.proxy.client.UnsupportedHttpMethodException;
import io.sterodium.extensions.hub.proxy.session.SeleniumSessions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class RequestForwardingClient {
    private static final Logger LOGGER = Logger.getLogger(RequestForwardingClient.class.getName());
    private static final String NODE_HOST = "http://%s:%d/extra";
    private final HttpClientProvider httpClientProvider;
    private final String endpoint;

    public RequestForwardingClient(String host, int port) {
        this(String.format(NODE_HOST, host, port), new HttpClientProvider());
    }

    public RequestForwardingClient(String endpoint, HttpClientProvider httpClientProvider) {
        this.httpClientProvider = httpClientProvider;
        this.endpoint = endpoint;
    }

    public void forwardRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        try (CloseableHttpClient httpClient = this.httpClientProvider.provide();){
            HttpRequestBase httpRequest = this.createHttpRequest(servletRequest);
            CloseableHttpResponse extensionResponse = httpClient.execute((HttpUriRequest)httpRequest);
            HttpResponseConverter.copy((HttpResponse)extensionResponse, servletResponse);
        }
    }

    private HttpRequestBase createHttpRequest(HttpServletRequest request) throws IOException {
        HttpRequestBase httpRequestBase;
        String method = request.getMethod();
        LOGGER.info("Creating " + method + " request to forward");
        Object object = "POST".equals(method) ? this.createPostRequest(request) : ("GET".equals(method) ? new HttpGet() : ("PUT".equals(method) ? new HttpPut() : (httpRequestBase = "DELETE".equals(method) ? new HttpDelete() : null)));
        if (httpRequestBase == null) {
            throw new UnsupportedHttpMethodException(method);
        }
        URI uri = URI.create(this.endpoint + SeleniumSessions.trimSessionPath(request.getPathInfo()));
        LOGGER.info("Trimming session id from path, new path: " + uri.toString());
        httpRequestBase.setURI(uri);
        return httpRequestBase;
    }

    private HttpRequestBase createPostRequest(HttpServletRequest request) throws IOException {
        HttpPost httpPost = new HttpPost();
        InputStreamEntity entity = new InputStreamEntity((InputStream)request.getInputStream(), (long)request.getContentLength(), ContentType.create((String)request.getContentType().split(";")[0]));
        httpPost.setEntity((HttpEntity)entity);
        return httpPost;
    }
}

