/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.extensions.hub.proxy;

import com.google.common.annotations.VisibleForTesting;
import io.sterodium.extensions.hub.proxy.client.RequestForwardingClient;
import io.sterodium.extensions.hub.proxy.client.RequestForwardingClientProvider;
import io.sterodium.extensions.hub.proxy.session.SeleniumSessions;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.web.servlet.RegistryBasedServlet;

public class HubRequestsProxyingServlet
extends RegistryBasedServlet {
    private static final Logger LOGGER = Logger.getLogger(HubRequestsProxyingServlet.class.getName());
    @VisibleForTesting
    RequestForwardingClientProvider requestForwardingClientProvider = new RequestForwardingClientProvider();

    public HubRequestsProxyingServlet() {
        this(null);
    }

    public HubRequestsProxyingServlet(GridRegistry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.forwardRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.forwardRequest(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.forwardRequest(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.forwardRequest(req, resp);
    }

    private void forwardRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        RequestForwardingClient requestForwardingClient;
        try {
            requestForwardingClient = this.createExtensionClient(req.getPathInfo());
        }
        catch (IllegalArgumentException e) {
            resp.sendError(400, e.getMessage());
            return;
        }
        try {
            requestForwardingClient.forwardRequest(req, resp);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Exception during request forwarding", e);
            resp.sendError(400, e.getMessage());
        }
    }

    private RequestForwardingClient createExtensionClient(String path) {
        LOGGER.info("Forwarding request with path: " + path);
        String sessionId = SeleniumSessions.getSessionIdFromPath(path);
        LOGGER.info("Retrieving remote host for session: " + sessionId);
        SeleniumSessions sessions = new SeleniumSessions(this.getRegistry());
        sessions.refreshTimeout(sessionId);
        URL remoteHost = sessions.getRemoteHostForSession(sessionId);
        String host = remoteHost.getHost();
        int port = remoteHost.getPort();
        LOGGER.info("Remote host retrieved: " + host + ":" + port);
        return this.requestForwardingClientProvider.provide(host, port);
    }
}

