/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.extension.pojo.strategy;

import cn.smallbun.screw.extension.pojo.strategy.NameStrategy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HumpNameStrategy
implements NameStrategy {
    private final Pattern linePattern = Pattern.compile("_(\\w)");

    @Override
    public String transClassName(String name) {
        return this.upperCase(this.lineToHump(name));
    }

    @Override
    public String transFieldName(String name, Class<?> type) {
        return this.lineToHump(name);
    }

    @Override
    public String transSetName(String name, Class<?> type) {
        return "set" + this.upperCase(this.lineToHump(name));
    }

    @Override
    public String transGetName(String name, Class<?> type) {
        if (Boolean.class.isAssignableFrom(type)) {
            return "is" + this.upperCase(this.lineToHump(name));
        }
        return "get" + this.upperCase(this.lineToHump(name));
    }

    private String lineToHump(String str) {
        Matcher matcher = this.linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String upperCase(String str) {
        char[] ch = str.toCharArray();
        if (ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char)(ch[0] - 32);
        }
        return new String(ch);
    }
}

