/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.extension.pojo.execute;

import cn.smallbun.screw.core.exception.ScrewException;
import cn.smallbun.screw.core.execute.Execute;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.StringUtils;
import cn.smallbun.screw.extension.pojo.PojoConfiguration;
import cn.smallbun.screw.extension.pojo.engine.freemark.FreeMarkerPojoEngine;
import cn.smallbun.screw.extension.pojo.metadata.model.PojoModel;
import cn.smallbun.screw.extension.pojo.process.PojoModelProcess;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoExecute
implements Execute {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PojoConfiguration configuration;

    public PojoExecute(PojoConfiguration config) {
        String validate = this.validate(config);
        if (StringUtils.isNotBlank((CharSequence)validate)) {
            throw new ScrewException(validate);
        }
        this.configuration = config;
    }

    public ByteArrayOutputStream execute() {
        try {
            boolean mkdir;
            File pathFile;
            long start = System.currentTimeMillis();
            List<PojoModel> process = new PojoModelProcess(this.configuration).getPojoModel();
            FreeMarkerPojoEngine pojoEngine = new FreeMarkerPojoEngine();
            String path = this.configuration.getPath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (!(pathFile = new File(path)).exists() && !(mkdir = pathFile.mkdirs())) {
                throw new ScrewException("create directory failed");
            }
            if (!pathFile.isDirectory()) {
                throw new ScrewException("path is not a directory");
            }
            for (PojoModel pojoModel : process) {
                pojoEngine.produce(pojoModel, path + pojoModel.getClassName() + ".java");
            }
            this.logger.debug("pojo generation complete time consuming:{}ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe((Throwable)e);
        }
        return null;
    }

    private String validate(PojoConfiguration config) {
        StringBuilder error = new StringBuilder();
        String separator = System.lineSeparator();
        if (config == null) {
            error.append(separator);
            error.append("config can't be null!");
            return error.toString();
        }
        if (StringUtils.isBlank((CharSequence)config.getPackageName())) {
            error.append(separator);
            error.append("package can't be null!");
        }
        if (StringUtils.isBlank((CharSequence)config.getPath())) {
            error.append(separator);
            error.append("path can't be null!");
        }
        if (config.getDataSource() == null) {
            error.append(separator);
            error.append("datasource can't be null!");
        }
        if (config.getNameStrategy() == null) {
            error.append(separator);
            error.append("name strategy can't be null!");
        }
        return error.toString();
    }
}

