/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.extension.pojo.engine.freemark;

import cn.smallbun.screw.core.exception.ProduceException;
import cn.smallbun.screw.core.exception.ScrewException;
import cn.smallbun.screw.extension.pojo.engine.PojoEngine;
import cn.smallbun.screw.extension.pojo.metadata.model.PojoModel;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class FreeMarkerPojoEngine
implements PojoEngine {
    private final Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);

    public FreeMarkerPojoEngine() {
        this.configuration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), "/template/freemarker/"));
    }

    @Override
    public void produce(PojoModel info, String docName) throws ProduceException {
        try {
            Template template = this.configuration.getTemplate("pojo_java.ftl");
            File file = new File(docName);
            if (file.exists()) {
                throw new ScrewException("file need to generate has been exist! path:" + docName);
            }
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
                template.process((Object)info, (Writer)out);
            }
            catch (TemplateException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

