/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.extension.pojo.process;

import cn.smallbun.screw.core.Configuration;
import cn.smallbun.screw.core.engine.EngineConfig;
import cn.smallbun.screw.core.engine.EngineFileType;
import cn.smallbun.screw.core.metadata.model.ColumnModel;
import cn.smallbun.screw.core.metadata.model.DataModel;
import cn.smallbun.screw.core.metadata.model.TableModel;
import cn.smallbun.screw.core.process.DataModelProcess;
import cn.smallbun.screw.extension.pojo.PojoConfiguration;
import cn.smallbun.screw.extension.pojo.dialect.TypeDialect;
import cn.smallbun.screw.extension.pojo.dialect.TypeDialectFactory;
import cn.smallbun.screw.extension.pojo.metadata.model.PojoModel;
import cn.smallbun.screw.extension.pojo.metadata.model.TypeModel;
import cn.smallbun.screw.extension.pojo.process.PojoProcess;
import cn.smallbun.screw.extension.pojo.strategy.NameStrategy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PojoModelProcess
implements PojoProcess {
    private final PojoConfiguration pojoConfiguration;

    public PojoModelProcess(PojoConfiguration configuration) {
        this.pojoConfiguration = configuration;
    }

    @Override
    public List<PojoModel> getPojoModel() {
        List<TableModel> tableModels = this.getTableModel(this.pojoConfiguration);
        ArrayList<PojoModel> pojoModels = new ArrayList<PojoModel>(tableModels.size());
        TypeDialect dialect = new TypeDialectFactory(this.pojoConfiguration.getDataSource()).newInstance();
        NameStrategy nameStrategy = this.pojoConfiguration.getNameStrategy();
        Map<String, Class<?>> customType = this.pojoConfiguration.getCustomType();
        for (TableModel model : tableModels) {
            PojoModel pojoModel = new PojoModel();
            pojoModel.setUseLombok(this.pojoConfiguration.isUseLombok());
            pojoModel.setPackageName(this.pojoConfiguration.getPackageName());
            pojoModel.setTableName(model.getTableName());
            pojoModel.setRemarks(model.getRemarks());
            pojoModel.setClassName(nameStrategy.transClassName(model.getTableName()));
            HashSet<String> importList = new HashSet<String>();
            ArrayList<TypeModel> fieldList = new ArrayList<TypeModel>();
            for (ColumnModel column : model.getColumns()) {
                TypeModel typeModel = new TypeModel();
                typeModel.setFieldName(column.getColumnName());
                typeModel.setFieldType(column.getTypeName());
                typeModel.setRemarks(column.getRemarks());
                Class<?> classType = dialect.getTypeByMap(customType, column.getTypeName());
                if (classType == null) {
                    classType = dialect.getClassTypeByFieldType(column.getTypeName());
                }
                if (!classType.getTypeName().startsWith("java.lang")) {
                    importList.add(classType.getTypeName());
                }
                typeModel.setClassName(nameStrategy.transFieldName(column.getColumnName(), classType));
                typeModel.setClassType(classType.getSimpleName());
                if (!this.pojoConfiguration.isUseLombok()) {
                    typeModel.setGetName(nameStrategy.transGetName(column.getColumnName(), classType));
                    typeModel.setSetName(nameStrategy.transSetName(column.getColumnName(), classType));
                }
                fieldList.add(typeModel);
            }
            pojoModel.setImportList(importList);
            pojoModel.setFieldList(fieldList);
            pojoModels.add(pojoModel);
        }
        return pojoModels;
    }

    private List<TableModel> getTableModel(PojoConfiguration pojoConfiguration) {
        Configuration config = Configuration.builder().dataSource(pojoConfiguration.getDataSource()).produceConfig(pojoConfiguration.getProcessConfig()).engineConfig(EngineConfig.builder().fileType(EngineFileType.HTML).build()).build();
        DataModel process = new DataModelProcess(config).process();
        return process.getTables();
    }
}

