/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.extension.pojo.dialect;

import cn.smallbun.screw.core.exception.ScrewException;
import cn.smallbun.screw.core.query.DatabaseType;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.JdbcUtils;
import cn.smallbun.screw.extension.pojo.dialect.TypeDialect;
import cn.smallbun.screw.extension.pojo.dialect.mysql.MysqlTypeDialect;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class TypeDialectFactory {
    private final DataSource dataSource;
    private final Map<DatabaseType, Class<? extends TypeDialect>> dialectMap = new HashMap<DatabaseType, Class<? extends TypeDialect>>();

    public TypeDialectFactory(DataSource dataSource) {
        this.dialectMap.put(DatabaseType.MYSQL, MysqlTypeDialect.class);
        this.dataSource = dataSource;
    }

    public TypeDialect newInstance() {
        try {
            String url = this.getDataSource().getConnection().getMetaData().getURL();
            Class<? extends TypeDialect> query = this.dialectMap.get(JdbcUtils.getDbType((String)url));
            if (query == null) {
                throw new ScrewException("this database has not support url:" + url);
            }
            Constructor<? extends TypeDialect> constructor = query.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | SQLException e) {
            throw ExceptionUtils.mpe((Throwable)e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

