/*
 * Decompiled with CFR 0.152.
 */
package io.springboot.plugin.goview.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.springboot.plugin.goview.common.base.BaseController;
import io.springboot.plugin.goview.common.domain.AjaxResult;
import io.springboot.plugin.goview.common.domain.GoviewProject;
import io.springboot.plugin.goview.common.domain.GoviewProjectData;
import io.springboot.plugin.goview.common.domain.MagicHttp;
import io.springboot.plugin.goview.common.domain.ResultTable;
import io.springboot.plugin.goview.common.domain.Tablepar;
import io.springboot.plugin.goview.config.GoviewProperties;
import io.springboot.plugin.goview.mapper.GoviewProjectDataMapper;
import io.springboot.plugin.goview.mapper.GoviewProjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.ModelMap;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/project"})
public class GoViewProjectAPIController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(GoViewProjectAPIController.class);
    private final GoviewProjectDataMapper projectDataMapper;
    private final GoviewProjectMapper projectMapper;
    private final GoviewProperties goviewProperties;

    @GetMapping(value={"/list"})
    public ResultTable list(Tablepar tablepar, GoviewProject goviewProject) {
        Page page = new Page((long)tablepar.getPage(), (long)tablepar.getLimit());
        Page result = (Page)this.projectMapper.selectPage((IPage)page, (Wrapper)Wrappers.query((Object)goviewProject));
        ResultTable resultTable = GoViewProjectAPIController.pageTable(result.getRecords(), result.getTotal());
        resultTable.setCode(200);
        return resultTable;
    }

    @PostMapping(value={"/create"})
    public AjaxResult add(@RequestBody GoviewProject goviewProject) {
        this.projectMapper.insert(goviewProject);
        return AjaxResult.successData(200, goviewProject).put("msg", (Object)"\u521b\u5efa\u6210\u529f");
    }

    @DeleteMapping(value={"/delete"})
    public AjaxResult delete(String ids) {
        this.projectMapper.deleteById((Serializable)((Object)ids));
        return this.success();
    }

    @PostMapping(value={"/edit"})
    public AjaxResult editSave(@RequestBody GoviewProject goviewProject) {
        this.projectMapper.updateById(goviewProject);
        return this.success();
    }

    @PostMapping(value={"/rename"})
    public AjaxResult rename(@RequestBody GoviewProject goviewProject) {
        this.projectMapper.updateById(goviewProject);
        return this.success();
    }

    @PutMapping(value={"/publish"})
    @ResponseBody
    public AjaxResult updateVisible(@RequestBody GoviewProject goviewProject) {
        this.projectMapper.updateById(goviewProject);
        return this.success();
    }

    @GetMapping(value={"/getData"})
    public AjaxResult getData(String projectId, ModelMap map) {
        GoviewProject goviewProject = (GoviewProject)this.projectMapper.selectById((Serializable)((Object)projectId));
        List goviewProjectDataList = this.projectDataMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(GoviewProjectData::getProjectId, (Object)projectId));
        if (CollUtil.isNotEmpty((Collection)goviewProjectDataList)) {
            goviewProject.setContent(((GoviewProjectData)goviewProjectDataList.get(0)).getContent());
            return AjaxResult.successData(200, goviewProject).put("msg", (Object)"\u83b7\u53d6\u6210\u529f");
        }
        return AjaxResult.successData(200, null).put("msg", (Object)"\u65e0\u6570\u636e");
    }

    @PostMapping(value={"/save/data"})
    public AjaxResult saveData(GoviewProjectData data) {
        boolean exists = this.projectDataMapper.exists((Wrapper)Wrappers.lambdaQuery().eq(GoviewProjectData::getProjectId, (Object)data.getProjectId()));
        if (exists) {
            this.projectDataMapper.update(data, (Wrapper)Wrappers.lambdaQuery().eq(GoviewProjectData::getProjectId, (Object)data.getProjectId()));
        } else {
            this.projectDataMapper.insert(data);
        }
        return AjaxResult.success("\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/magicHttp"})
    public AjaxResult magicHttp(@RequestBody MagicHttp magicHttp) {
        return AjaxResult.successNullData("\u53c2\u6570\u5f02\u5e38\u4e3anull");
    }

    @PostMapping(value={"/upload"})
    @ResponseBody
    public AjaxResult upload(@RequestBody MultipartFile object) throws IOException {
        File dest = new File(this.goviewProperties.getImgPath() + object.getOriginalFilename());
        object.transferTo(dest);
        HashMap<String, String> map = new HashMap<String, String>(4);
        String url = StrUtil.isNotBlank((CharSequence)this.goviewProperties.getHost()) ? this.goviewProperties.getHost() + this.goviewProperties.getGatewayPrefix() + "/api/project/get-file/" + object.getOriginalFilename() : this.goviewProperties.getGatewayPrefix() + "/api/project/get-file/" + object.getOriginalFilename();
        map.put("link", url);
        return AjaxResult.successData(200, map);
    }

    @GetMapping(value={"/get-file/{fileName}"})
    public ResponseEntity<byte[]> getFile(@PathVariable String fileName) {
        HttpHeaders headers = new HttpHeaders();
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(fileName).build();
        headers.setContentDisposition(contentDisposition);
        try {
            return new ResponseEntity((Object)FileCopyUtils.copyToByteArray((File)new File(this.goviewProperties.getImgPath() + fileName)), (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (IOException e) {
            log.warn(e.getLocalizedMessage());
            return null;
        }
    }

    public GoViewProjectAPIController(GoviewProjectDataMapper projectDataMapper, GoviewProjectMapper projectMapper, GoviewProperties goviewProperties) {
        this.projectDataMapper = projectDataMapper;
        this.projectMapper = projectMapper;
        this.goviewProperties = goviewProperties;
    }
}

