(() => {
  // node_modules/monaco-editor/esm/vs/base/common/errors.js
  var ErrorHandler = class {
    constructor() {
      this.listeners = [];
      this.unexpectedErrorHandler = function(e) {
        setTimeout(() => {
          if (e.stack) {
            throw new Error(e.message + "\n\n" + e.stack);
          }
          throw e;
        }, 0);
      };
    }
    emit(e) {
      this.listeners.forEach((listener) => {
        listener(e);
      });
    }
    onUnexpectedError(e) {
      this.unexpectedErrorHandler(e);
      this.emit(e);
    }
    onUnexpectedExternalError(e) {
      this.unexpectedErrorHandler(e);
    }
  };
  var errorHandler = new ErrorHandler();
  function onUnexpectedError(e) {
    if (!isCancellationError(e)) {
      errorHandler.onUnexpectedError(e);
    }
    return void 0;
  }
  function transformErrorForSerialization(error) {
    if (error instanceof Error) {
      let {name, message} = error;
      const stack = error.stacktrace || error.stack;
      return {
        $isError: true,
        name,
        message,
        stack
      };
    }
    return error;
  }
  var canceledName = "Canceled";
  function isCancellationError(error) {
    if (error instanceof CancellationError) {
      return true;
    }
    return error instanceof Error && error.name === canceledName && error.message === canceledName;
  }
  var CancellationError = class extends Error {
    constructor() {
      super(canceledName);
      this.name = this.message;
    }
  };

  // node_modules/monaco-editor/esm/vs/base/common/functional.js
  function once(fn) {
    const _this = this;
    let didCall = false;
    let result;
    return function() {
      if (didCall) {
        return result;
      }
      didCall = true;
      result = fn.apply(_this, arguments);
      return result;
    };
  }

  // node_modules/monaco-editor/esm/vs/base/common/iterator.js
  var Iterable;
  (function(Iterable2) {
    function is(thing) {
      return thing && typeof thing === "object" && typeof thing[Symbol.iterator] === "function";
    }
    Iterable2.is = is;
    const _empty2 = Object.freeze([]);
    function empty() {
      return _empty2;
    }
    Iterable2.empty = empty;
    function* single(element) {
      yield element;
    }
    Iterable2.single = single;
    function from(iterable) {
      return iterable || _empty2;
    }
    Iterable2.from = from;
    function isEmpty(iterable) {
      return !iterable || iterable[Symbol.iterator]().next().done === true;
    }
    Iterable2.isEmpty = isEmpty;
    function first(iterable) {
      return iterable[Symbol.iterator]().next().value;
    }
    Iterable2.first = first;
    function some(iterable, predicate) {
      for (const element of iterable) {
        if (predicate(element)) {
          return true;
        }
      }
      return false;
    }
    Iterable2.some = some;
    function find(iterable, predicate) {
      for (const element of iterable) {
        if (predicate(element)) {
          return element;
        }
      }
      return void 0;
    }
    Iterable2.find = find;
    function* filter(iterable, predicate) {
      for (const element of iterable) {
        if (predicate(element)) {
          yield element;
        }
      }
    }
    Iterable2.filter = filter;
    function* map(iterable, fn) {
      let index = 0;
      for (const element of iterable) {
        yield fn(element, index++);
      }
    }
    Iterable2.map = map;
    function* concat(...iterables) {
      for (const iterable of iterables) {
        for (const element of iterable) {
          yield element;
        }
      }
    }
    Iterable2.concat = concat;
    function* concatNested(iterables) {
      for (const iterable of iterables) {
        for (const element of iterable) {
          yield element;
        }
      }
    }
    Iterable2.concatNested = concatNested;
    function reduce(iterable, reducer, initialValue) {
      let value = initialValue;
      for (const element of iterable) {
        value = reducer(value, element);
      }
      return value;
    }
    Iterable2.reduce = reduce;
    function* slice(arr, from2, to = arr.length) {
      if (from2 < 0) {
        from2 += arr.length;
      }
      if (to < 0) {
        to += arr.length;
      } else if (to > arr.length) {
        to = arr.length;
      }
      for (; from2 < to; from2++) {
        yield arr[from2];
      }
    }
    Iterable2.slice = slice;
    function consume(iterable, atMost = Number.POSITIVE_INFINITY) {
      const consumed = [];
      if (atMost === 0) {
        return [consumed, iterable];
      }
      const iterator = iterable[Symbol.iterator]();
      for (let i = 0; i < atMost; i++) {
        const next = iterator.next();
        if (next.done) {
          return [consumed, Iterable2.empty()];
        }
        consumed.push(next.value);
      }
      return [consumed, {[Symbol.iterator]() {
        return iterator;
      }}];
    }
    Iterable2.consume = consume;
    function equals2(a, b, comparator = (at, bt) => at === bt) {
      const ai = a[Symbol.iterator]();
      const bi = b[Symbol.iterator]();
      while (true) {
        const an = ai.next();
        const bn = bi.next();
        if (an.done !== bn.done) {
          return false;
        } else if (an.done) {
          return true;
        } else if (!comparator(an.value, bn.value)) {
          return false;
        }
      }
    }
    Iterable2.equals = equals2;
  })(Iterable || (Iterable = {}));

  // node_modules/monaco-editor/esm/vs/base/common/lifecycle.js
  var TRACK_DISPOSABLES = false;
  var disposableTracker = null;
  function setDisposableTracker(tracker) {
    disposableTracker = tracker;
  }
  if (TRACK_DISPOSABLES) {
    const __is_disposable_tracked__ = "__is_disposable_tracked__";
    setDisposableTracker(new class {
      trackDisposable(x) {
        const stack = new Error("Potentially leaked disposable").stack;
        setTimeout(() => {
          if (!x[__is_disposable_tracked__]) {
            console.log(stack);
          }
        }, 3e3);
      }
      setParent(child, parent) {
        if (child && child !== Disposable.None) {
          try {
            child[__is_disposable_tracked__] = true;
          } catch (_a3) {
          }
        }
      }
      markAsDisposed(disposable) {
        if (disposable && disposable !== Disposable.None) {
          try {
            disposable[__is_disposable_tracked__] = true;
          } catch (_a3) {
          }
        }
      }
      markAsSingleton(disposable) {
      }
    }());
  }
  function trackDisposable(x) {
    disposableTracker === null || disposableTracker === void 0 ? void 0 : disposableTracker.trackDisposable(x);
    return x;
  }
  function markAsDisposed(disposable) {
    disposableTracker === null || disposableTracker === void 0 ? void 0 : disposableTracker.markAsDisposed(disposable);
  }
  function setParentOfDisposable(child, parent) {
    disposableTracker === null || disposableTracker === void 0 ? void 0 : disposableTracker.setParent(child, parent);
  }
  function setParentOfDisposables(children, parent) {
    if (!disposableTracker) {
      return;
    }
    for (const child of children) {
      disposableTracker.setParent(child, parent);
    }
  }
  var MultiDisposeError = class extends Error {
    constructor(errors) {
      super(`Encountered errors while disposing of store. Errors: [${errors.join(", ")}]`);
      this.errors = errors;
    }
  };
  function dispose(arg) {
    if (Iterable.is(arg)) {
      let errors = [];
      for (const d of arg) {
        if (d) {
          try {
            d.dispose();
          } catch (e) {
            errors.push(e);
          }
        }
      }
      if (errors.length === 1) {
        throw errors[0];
      } else if (errors.length > 1) {
        throw new MultiDisposeError(errors);
      }
      return Array.isArray(arg) ? [] : arg;
    } else if (arg) {
      arg.dispose();
      return arg;
    }
  }
  function combinedDisposable(...disposables) {
    const parent = toDisposable(() => dispose(disposables));
    setParentOfDisposables(disposables, parent);
    return parent;
  }
  function toDisposable(fn) {
    const self2 = trackDisposable({
      dispose: once(() => {
        markAsDisposed(self2);
        fn();
      })
    });
    return self2;
  }
  var DisposableStore = class {
    constructor() {
      this._toDispose = new Set();
      this._isDisposed = false;
      trackDisposable(this);
    }
    dispose() {
      if (this._isDisposed) {
        return;
      }
      markAsDisposed(this);
      this._isDisposed = true;
      this.clear();
    }
    get isDisposed() {
      return this._isDisposed;
    }
    clear() {
      try {
        dispose(this._toDispose.values());
      } finally {
        this._toDispose.clear();
      }
    }
    add(o) {
      if (!o) {
        return o;
      }
      if (o === this) {
        throw new Error("Cannot register a disposable on itself!");
      }
      setParentOfDisposable(o, this);
      if (this._isDisposed) {
        if (!DisposableStore.DISABLE_DISPOSED_WARNING) {
          console.warn(new Error("Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!").stack);
        }
      } else {
        this._toDispose.add(o);
      }
      return o;
    }
  };
  DisposableStore.DISABLE_DISPOSED_WARNING = false;
  var Disposable = class {
    constructor() {
      this._store = new DisposableStore();
      trackDisposable(this);
      setParentOfDisposable(this._store, this);
    }
    dispose() {
      markAsDisposed(this);
      this._store.dispose();
    }
    _register(o) {
      if (o === this) {
        throw new Error("Cannot register a disposable on itself!");
      }
      return this._store.add(o);
    }
  };
  Disposable.None = Object.freeze({dispose() {
  }});
  var SafeDisposable = class {
    constructor() {
      this.dispose = () => {
      };
      this.unset = () => {
      };
      this.isset = () => false;
      trackDisposable(this);
    }
    set(fn) {
      let callback = fn;
      this.unset = () => callback = void 0;
      this.isset = () => callback !== void 0;
      this.dispose = () => {
        if (callback) {
          callback();
          callback = void 0;
          markAsDisposed(this);
        }
      };
      return this;
    }
  };

  // node_modules/monaco-editor/esm/vs/base/common/linkedList.js
  var Node = class {
    constructor(element) {
      this.element = element;
      this.next = Node.Undefined;
      this.prev = Node.Undefined;
    }
  };
  Node.Undefined = new Node(void 0);
  var LinkedList = class {
    constructor() {
      this._first = Node.Undefined;
      this._last = Node.Undefined;
      this._size = 0;
    }
    get size() {
      return this._size;
    }
    isEmpty() {
      return this._first === Node.Undefined;
    }
    clear() {
      let node = this._first;
      while (node !== Node.Undefined) {
        const next = node.next;
        node.prev = Node.Undefined;
        node.next = Node.Undefined;
        node = next;
      }
      this._first = Node.Undefined;
      this._last = Node.Undefined;
      this._size = 0;
    }
    unshift(element) {
      return this._insert(element, false);
    }
    push(element) {
      return this._insert(element, true);
    }
    _insert(element, atTheEnd) {
      const newNode = new Node(element);
      if (this._first === Node.Undefined) {
        this._first = newNode;
        this._last = newNode;
      } else if (atTheEnd) {
        const oldLast = this._last;
        this._last = newNode;
        newNode.prev = oldLast;
        oldLast.next = newNode;
      } else {
        const oldFirst = this._first;
        this._first = newNode;
        newNode.next = oldFirst;
        oldFirst.prev = newNode;
      }
      this._size += 1;
      let didRemove = false;
      return () => {
        if (!didRemove) {
          didRemove = true;
          this._remove(newNode);
        }
      };
    }
    shift() {
      if (this._first === Node.Undefined) {
        return void 0;
      } else {
        const res = this._first.element;
        this._remove(this._first);
        return res;
      }
    }
    pop() {
      if (this._last === Node.Undefined) {
        return void 0;
      } else {
        const res = this._last.element;
        this._remove(this._last);
        return res;
      }
    }
    _remove(node) {
      if (node.prev !== Node.Undefined && node.next !== Node.Undefined) {
        const anchor = node.prev;
        anchor.next = node.next;
        node.next.prev = anchor;
      } else if (node.prev === Node.Undefined && node.next === Node.Undefined) {
        this._first = Node.Undefined;
        this._last = Node.Undefined;
      } else if (node.next === Node.Undefined) {
        this._last = this._last.prev;
        this._last.next = Node.Undefined;
      } else if (node.prev === Node.Undefined) {
        this._first = this._first.next;
        this._first.prev = Node.Undefined;
      }
      this._size -= 1;
    }
    *[Symbol.iterator]() {
      let node = this._first;
      while (node !== Node.Undefined) {
        yield node.element;
        node = node.next;
      }
    }
  };

  // node_modules/monaco-editor/esm/vs/base/common/platform.js
  var _a;
  var LANGUAGE_DEFAULT = "en";
  var _isWindows = false;
  var _isMacintosh = false;
  var _isLinux = false;
  var _isLinuxSnap = false;
  var _isNative = false;
  var _isWeb = false;
  var _isElectron = false;
  var _isIOS = false;
  var _isCI = false;
  var _locale = void 0;
  var _language = LANGUAGE_DEFAULT;
  var _translationsConfigFile = void 0;
  var _userAgent = void 0;
  var globals = typeof self === "object" ? self : typeof global === "object" ? global : {};
  var nodeProcess = void 0;
  if (typeof globals.vscode !== "undefined" && typeof globals.vscode.process !== "undefined") {
    nodeProcess = globals.vscode.process;
  } else if (typeof process !== "undefined") {
    nodeProcess = process;
  }
  var isElectronProcess = typeof ((_a = nodeProcess === null || nodeProcess === void 0 ? void 0 : nodeProcess.versions) === null || _a === void 0 ? void 0 : _a.electron) === "string";
  var isElectronRenderer = isElectronProcess && (nodeProcess === null || nodeProcess === void 0 ? void 0 : nodeProcess.type) === "renderer";
  if (typeof navigator === "object" && !isElectronRenderer) {
    _userAgent = navigator.userAgent;
    _isWindows = _userAgent.indexOf("Windows") >= 0;
    _isMacintosh = _userAgent.indexOf("Macintosh") >= 0;
    _isIOS = (_userAgent.indexOf("Macintosh") >= 0 || _userAgent.indexOf("iPad") >= 0 || _userAgent.indexOf("iPhone") >= 0) && !!navigator.maxTouchPoints && navigator.maxTouchPoints > 0;
    _isLinux = _userAgent.indexOf("Linux") >= 0;
    _isWeb = true;
    _locale = navigator.language;
    _language = _locale;
  } else if (typeof nodeProcess === "object") {
    _isWindows = nodeProcess.platform === "win32";
    _isMacintosh = nodeProcess.platform === "darwin";
    _isLinux = nodeProcess.platform === "linux";
    _isLinuxSnap = _isLinux && !!nodeProcess.env["SNAP"] && !!nodeProcess.env["SNAP_REVISION"];
    _isElectron = isElectronProcess;
    _isCI = !!nodeProcess.env["CI"] || !!nodeProcess.env["BUILD_ARTIFACTSTAGINGDIRECTORY"];
    _locale = LANGUAGE_DEFAULT;
    _language = LANGUAGE_DEFAULT;
    const rawNlsConfig = nodeProcess.env["VSCODE_NLS_CONFIG"];
    if (rawNlsConfig) {
      try {
        const nlsConfig = JSON.parse(rawNlsConfig);
        const resolved = nlsConfig.availableLanguages["*"];
        _locale = nlsConfig.locale;
        _language = resolved ? resolved : LANGUAGE_DEFAULT;
        _translationsConfigFile = nlsConfig._translationsConfigFile;
      } catch (e) {
      }
    }
    _isNative = true;
  } else {
    console.error("Unable to resolve platform.");
  }
  var _platform = 0;
  if (_isMacintosh) {
    _platform = 1;
  } else if (_isWindows) {
    _platform = 3;
  } else if (_isLinux) {
    _platform = 2;
  }
  var isWindows = _isWindows;
  var isMacintosh = _isMacintosh;
  var isWebWorker = _isWeb && typeof globals.importScripts === "function";
  var userAgent = _userAgent;
  var setTimeout0 = (() => {
    if (typeof globals.postMessage === "function" && !globals.importScripts) {
      let pending = [];
      globals.addEventListener("message", (e) => {
        if (e.data && e.data.vscodeScheduleAsyncWork) {
          for (let i = 0, len = pending.length; i < len; i++) {
            const candidate = pending[i];
            if (candidate.id === e.data.vscodeScheduleAsyncWork) {
              pending.splice(i, 1);
              candidate.callback();
              return;
            }
          }
        }
      });
      let lastId = 0;
      return (callback) => {
        const myId = ++lastId;
        pending.push({
          id: myId,
          callback
        });
        globals.postMessage({vscodeScheduleAsyncWork: myId}, "*");
      };
    }
    return (callback) => setTimeout(callback);
  })();
  var isChrome = !!(userAgent && userAgent.indexOf("Chrome") >= 0);
  var isFirefox = !!(userAgent && userAgent.indexOf("Firefox") >= 0);
  var isSafari = !!(!isChrome && (userAgent && userAgent.indexOf("Safari") >= 0));
  var isEdge = !!(userAgent && userAgent.indexOf("Edg/") >= 0);
  var isAndroid = !!(userAgent && userAgent.indexOf("Android") >= 0);

  // node_modules/monaco-editor/esm/vs/base/common/stopwatch.js
  var hasPerformanceNow = globals.performance && typeof globals.performance.now === "function";
  var StopWatch = class {
    constructor(highResolution) {
      this._highResolution = hasPerformanceNow && highResolution;
      this._startTime = this._now();
      this._stopTime = -1;
    }
    static create(highResolution = true) {
      return new StopWatch(highResolution);
    }
    stop() {
      this._stopTime = this._now();
    }
    elapsed() {
      if (this._stopTime !== -1) {
        return this._stopTime - this._startTime;
      }
      return this._now() - this._startTime;
    }
    _now() {
      return this._highResolution ? globals.performance.now() : Date.now();
    }
  };

  // node_modules/monaco-editor/esm/vs/base/common/event.js
  var _enableDisposeWithListenerWarning = false;
  var _enableSnapshotPotentialLeakWarning = false;
  var Event;
  (function(Event2) {
    Event2.None = () => Disposable.None;
    function _addLeakageTraceLogic(options) {
      if (_enableSnapshotPotentialLeakWarning) {
        const {onListenerDidAdd: origListenerDidAdd} = options;
        const stack = Stacktrace.create();
        let count = 0;
        options.onListenerDidAdd = () => {
          if (++count === 2) {
            console.warn("snapshotted emitter LIKELY used public and SHOULD HAVE BEEN created with DisposableStore. snapshotted here");
            stack.print();
          }
          origListenerDidAdd === null || origListenerDidAdd === void 0 ? void 0 : origListenerDidAdd();
        };
      }
    }
    function once3(event) {
      return (listener, thisArgs = null, disposables) => {
        let didFire = false;
        let result;
        result = event((e) => {
          if (didFire) {
            return;
          } else if (result) {
            result.dispose();
          } else {
            didFire = true;
          }
          return listener.call(thisArgs, e);
        }, null, disposables);
        if (didFire) {
          result.dispose();
        }
        return result;
      };
    }
    Event2.once = once3;
    function map(event, map2, disposable) {
      return snapshot((listener, thisArgs = null, disposables) => event((i) => listener.call(thisArgs, map2(i)), null, disposables), disposable);
    }
    Event2.map = map;
    function forEach(event, each, disposable) {
      return snapshot((listener, thisArgs = null, disposables) => event((i) => {
        each(i);
        listener.call(thisArgs, i);
      }, null, disposables), disposable);
    }
    Event2.forEach = forEach;
    function filter(event, filter2, disposable) {
      return snapshot((listener, thisArgs = null, disposables) => event((e) => filter2(e) && listener.call(thisArgs, e), null, disposables), disposable);
    }
    Event2.filter = filter;
    function signal(event) {
      return event;
    }
    Event2.signal = signal;
    function any(...events) {
      return (listener, thisArgs = null, disposables) => combinedDisposable(...events.map((event) => event((e) => listener.call(thisArgs, e), null, disposables)));
    }
    Event2.any = any;
    function reduce(event, merge, initial, disposable) {
      let output = initial;
      return map(event, (e) => {
        output = merge(output, e);
        return output;
      }, disposable);
    }
    Event2.reduce = reduce;
    function snapshot(event, disposable) {
      let listener;
      const options = {
        onFirstListenerAdd() {
          listener = event(emitter.fire, emitter);
        },
        onLastListenerRemove() {
          listener.dispose();
        }
      };
      if (!disposable) {
        _addLeakageTraceLogic(options);
      }
      const emitter = new Emitter(options);
      if (disposable) {
        disposable.add(emitter);
      }
      return emitter.event;
    }
    function debounce(event, merge, delay = 100, leading = false, leakWarningThreshold, disposable) {
      let subscription;
      let output = void 0;
      let handle = void 0;
      let numDebouncedCalls = 0;
      const options = {
        leakWarningThreshold,
        onFirstListenerAdd() {
          subscription = event((cur) => {
            numDebouncedCalls++;
            output = merge(output, cur);
            if (leading && !handle) {
              emitter.fire(output);
              output = void 0;
            }
            clearTimeout(handle);
            handle = setTimeout(() => {
              const _output = output;
              output = void 0;
              handle = void 0;
              if (!leading || numDebouncedCalls > 1) {
                emitter.fire(_output);
              }
              numDebouncedCalls = 0;
            }, delay);
          });
        },
        onLastListenerRemove() {
          subscription.dispose();
        }
      };
      if (!disposable) {
        _addLeakageTraceLogic(options);
      }
      const emitter = new Emitter(options);
      if (disposable) {
        disposable.add(emitter);
      }
      return emitter.event;
    }
    Event2.debounce = debounce;
    function latch(event, equals2 = (a, b) => a === b, disposable) {
      let firstCall = true;
      let cache;
      return filter(event, (value) => {
        const shouldEmit = firstCall || !equals2(value, cache);
        firstCall = false;
        cache = value;
        return shouldEmit;
      }, disposable);
    }
    Event2.latch = latch;
    function split(event, isT, disposable) {
      return [
        Event2.filter(event, isT, disposable),
        Event2.filter(event, (e) => !isT(e), disposable)
      ];
    }
    Event2.split = split;
    function buffer(event, flushAfterTimeout = false, _buffer = []) {
      let buffer2 = _buffer.slice();
      let listener = event((e) => {
        if (buffer2) {
          buffer2.push(e);
        } else {
          emitter.fire(e);
        }
      });
      const flush = () => {
        if (buffer2) {
          buffer2.forEach((e) => emitter.fire(e));
        }
        buffer2 = null;
      };
      const emitter = new Emitter({
        onFirstListenerAdd() {
          if (!listener) {
            listener = event((e) => emitter.fire(e));
          }
        },
        onFirstListenerDidAdd() {
          if (buffer2) {
            if (flushAfterTimeout) {
              setTimeout(flush);
            } else {
              flush();
            }
          }
        },
        onLastListenerRemove() {
          if (listener) {
            listener.dispose();
          }
          listener = null;
        }
      });
      return emitter.event;
    }
    Event2.buffer = buffer;
    class ChainableEvent {
      constructor(event) {
        this.event = event;
      }
      map(fn) {
        return new ChainableEvent(map(this.event, fn));
      }
      forEach(fn) {
        return new ChainableEvent(forEach(this.event, fn));
      }
      filter(fn) {
        return new ChainableEvent(filter(this.event, fn));
      }
      reduce(merge, initial) {
        return new ChainableEvent(reduce(this.event, merge, initial));
      }
      latch() {
        return new ChainableEvent(latch(this.event));
      }
      debounce(merge, delay = 100, leading = false, leakWarningThreshold) {
        return new ChainableEvent(debounce(this.event, merge, delay, leading, leakWarningThreshold));
      }
      on(listener, thisArgs, disposables) {
        return this.event(listener, thisArgs, disposables);
      }
      once(listener, thisArgs, disposables) {
        return once3(this.event)(listener, thisArgs, disposables);
      }
    }
    function chain(event) {
      return new ChainableEvent(event);
    }
    Event2.chain = chain;
    function fromNodeEventEmitter(emitter, eventName, map2 = (id) => id) {
      const fn = (...args) => result.fire(map2(...args));
      const onFirstListenerAdd = () => emitter.on(eventName, fn);
      const onLastListenerRemove = () => emitter.removeListener(eventName, fn);
      const result = new Emitter({onFirstListenerAdd, onLastListenerRemove});
      return result.event;
    }
    Event2.fromNodeEventEmitter = fromNodeEventEmitter;
    function fromDOMEventEmitter(emitter, eventName, map2 = (id) => id) {
      const fn = (...args) => result.fire(map2(...args));
      const onFirstListenerAdd = () => emitter.addEventListener(eventName, fn);
      const onLastListenerRemove = () => emitter.removeEventListener(eventName, fn);
      const result = new Emitter({onFirstListenerAdd, onLastListenerRemove});
      return result.event;
    }
    Event2.fromDOMEventEmitter = fromDOMEventEmitter;
    function toPromise(event) {
      return new Promise((resolve2) => once3(event)(resolve2));
    }
    Event2.toPromise = toPromise;
    function runAndSubscribe(event, handler) {
      handler(void 0);
      return event((e) => handler(e));
    }
    Event2.runAndSubscribe = runAndSubscribe;
    function runAndSubscribeWithStore(event, handler) {
      let store = null;
      function run(e) {
        store === null || store === void 0 ? void 0 : store.dispose();
        store = new DisposableStore();
        handler(e, store);
      }
      run(void 0);
      const disposable = event((e) => run(e));
      return toDisposable(() => {
        disposable.dispose();
        store === null || store === void 0 ? void 0 : store.dispose();
      });
    }
    Event2.runAndSubscribeWithStore = runAndSubscribeWithStore;
  })(Event || (Event = {}));
  var EventProfiling = class {
    constructor(name) {
      this._listenerCount = 0;
      this._invocationCount = 0;
      this._elapsedOverall = 0;
      this._name = `${name}_${EventProfiling._idPool++}`;
    }
    start(listenerCount) {
      this._stopWatch = new StopWatch(true);
      this._listenerCount = listenerCount;
    }
    stop() {
      if (this._stopWatch) {
        const elapsed = this._stopWatch.elapsed();
        this._elapsedOverall += elapsed;
        this._invocationCount += 1;
        console.info(`did FIRE ${this._name}: elapsed_ms: ${elapsed.toFixed(5)}, listener: ${this._listenerCount} (elapsed_overall: ${this._elapsedOverall.toFixed(2)}, invocations: ${this._invocationCount})`);
        this._stopWatch = void 0;
      }
    }
  };
  EventProfiling._idPool = 0;
  var _globalLeakWarningThreshold = -1;
  var LeakageMonitor = class {
    constructor(customThreshold, name = Math.random().toString(18).slice(2, 5)) {
      this.customThreshold = customThreshold;
      this.name = name;
      this._warnCountdown = 0;
    }
    dispose() {
      if (this._stacks) {
        this._stacks.clear();
      }
    }
    check(stack, listenerCount) {
      let threshold = _globalLeakWarningThreshold;
      if (typeof this.customThreshold === "number") {
        threshold = this.customThreshold;
      }
      if (threshold <= 0 || listenerCount < threshold) {
        return void 0;
      }
      if (!this._stacks) {
        this._stacks = new Map();
      }
      const count = this._stacks.get(stack.value) || 0;
      this._stacks.set(stack.value, count + 1);
      this._warnCountdown -= 1;
      if (this._warnCountdown <= 0) {
        this._warnCountdown = threshold * 0.5;
        let topStack;
        let topCount = 0;
        for (const [stack2, count2] of this._stacks) {
          if (!topStack || topCount < count2) {
            topStack = stack2;
            topCount = count2;
          }
        }
        console.warn(`[${this.name}] potential listener LEAK detected, having ${listenerCount} listeners already. MOST frequent listener (${topCount}):`);
        console.warn(topStack);
      }
      return () => {
        const count2 = this._stacks.get(stack.value) || 0;
        this._stacks.set(stack.value, count2 - 1);
      };
    }
  };
  var Stacktrace = class {
    constructor(value) {
      this.value = value;
    }
    static create() {
      var _a3;
      return new Stacktrace((_a3 = new Error().stack) !== null && _a3 !== void 0 ? _a3 : "");
    }
    print() {
      console.warn(this.value.split("\n").slice(2).join("\n"));
    }
  };
  var Listener = class {
    constructor(callback, callbackThis, stack) {
      this.callback = callback;
      this.callbackThis = callbackThis;
      this.stack = stack;
      this.subscription = new SafeDisposable();
    }
    invoke(e) {
      this.callback.call(this.callbackThis, e);
    }
  };
  var Emitter = class {
    constructor(options) {
      var _a3;
      this._disposed = false;
      this._options = options;
      this._leakageMon = _globalLeakWarningThreshold > 0 ? new LeakageMonitor(this._options && this._options.leakWarningThreshold) : void 0;
      this._perfMon = ((_a3 = this._options) === null || _a3 === void 0 ? void 0 : _a3._profName) ? new EventProfiling(this._options._profName) : void 0;
    }
    dispose() {
      var _a3, _b, _c, _d;
      if (!this._disposed) {
        this._disposed = true;
        if (this._listeners) {
          if (_enableDisposeWithListenerWarning) {
            const listeners = Array.from(this._listeners);
            queueMicrotask(() => {
              var _a4;
              for (const listener of listeners) {
                if (listener.subscription.isset()) {
                  listener.subscription.unset();
                  (_a4 = listener.stack) === null || _a4 === void 0 ? void 0 : _a4.print();
                }
              }
            });
          }
          this._listeners.clear();
        }
        (_a3 = this._deliveryQueue) === null || _a3 === void 0 ? void 0 : _a3.clear();
        (_c = (_b = this._options) === null || _b === void 0 ? void 0 : _b.onLastListenerRemove) === null || _c === void 0 ? void 0 : _c.call(_b);
        (_d = this._leakageMon) === null || _d === void 0 ? void 0 : _d.dispose();
      }
    }
    get event() {
      if (!this._event) {
        this._event = (callback, thisArgs, disposables) => {
          var _a3, _b, _c;
          if (!this._listeners) {
            this._listeners = new LinkedList();
          }
          const firstListener = this._listeners.isEmpty();
          if (firstListener && ((_a3 = this._options) === null || _a3 === void 0 ? void 0 : _a3.onFirstListenerAdd)) {
            this._options.onFirstListenerAdd(this);
          }
          let removeMonitor;
          let stack;
          if (this._leakageMon && this._listeners.size >= 30) {
            stack = Stacktrace.create();
            removeMonitor = this._leakageMon.check(stack, this._listeners.size + 1);
          }
          if (_enableDisposeWithListenerWarning) {
            stack = stack !== null && stack !== void 0 ? stack : Stacktrace.create();
          }
          const listener = new Listener(callback, thisArgs, stack);
          const removeListener = this._listeners.push(listener);
          if (firstListener && ((_b = this._options) === null || _b === void 0 ? void 0 : _b.onFirstListenerDidAdd)) {
            this._options.onFirstListenerDidAdd(this);
          }
          if ((_c = this._options) === null || _c === void 0 ? void 0 : _c.onListenerDidAdd) {
            this._options.onListenerDidAdd(this, callback, thisArgs);
          }
          const result = listener.subscription.set(() => {
            if (removeMonitor) {
              removeMonitor();
            }
            if (!this._disposed) {
              removeListener();
              if (this._options && this._options.onLastListenerRemove) {
                const hasListeners = this._listeners && !this._listeners.isEmpty();
                if (!hasListeners) {
                  this._options.onLastListenerRemove(this);
                }
              }
            }
          });
          if (disposables instanceof DisposableStore) {
            disposables.add(result);
          } else if (Array.isArray(disposables)) {
            disposables.push(result);
          }
          return result;
        };
      }
      return this._event;
    }
    fire(event) {
      var _a3, _b;
      if (this._listeners) {
        if (!this._deliveryQueue) {
          this._deliveryQueue = new LinkedList();
        }
        for (let listener of this._listeners) {
          this._deliveryQueue.push([listener, event]);
        }
        (_a3 = this._perfMon) === null || _a3 === void 0 ? void 0 : _a3.start(this._deliveryQueue.size);
        while (this._deliveryQueue.size > 0) {
          const [listener, event2] = this._deliveryQueue.shift();
          try {
            listener.invoke(event2);
          } catch (e) {
            onUnexpectedError(e);
          }
        }
        (_b = this._perfMon) === null || _b === void 0 ? void 0 : _b.stop();
      }
    }
  };

  // node_modules/monaco-editor/esm/vs/base/common/types.js
  function getAllPropertyNames(obj) {
    let res = [];
    let proto = Object.getPrototypeOf(obj);
    while (Object.prototype !== proto) {
      res = res.concat(Object.getOwnPropertyNames(proto));
      proto = Object.getPrototypeOf(proto);
    }
    return res;
  }
  function getAllMethodNames(obj) {
    const methods = [];
    for (const prop of getAllPropertyNames(obj)) {
      if (typeof obj[prop] === "function") {
        methods.push(prop);
      }
    }
    return methods;
  }
  function createProxyObject(methodNames, invoke) {
    const createProxyMethod = (method) => {
      return function() {
        const args = Array.prototype.slice.call(arguments, 0);
        return invoke(method, args);
      };
    };
    let result = {};
    for (const methodName of methodNames) {
      result[methodName] = createProxyMethod(methodName);
    }
    return result;
  }
  function assertNever(value, message = "Unreachable") {
    throw new Error(message);
  }

  // node_modules/monaco-editor/esm/vs/base/common/cache.js
  var LRUCachedComputed = class {
    constructor(computeFn) {
      this.computeFn = computeFn;
      this.lastCache = void 0;
      this.lastArgKey = void 0;
    }
    get(arg) {
      const key = JSON.stringify(arg);
      if (this.lastArgKey !== key) {
        this.lastArgKey = key;
        this.lastCache = this.computeFn(arg);
      }
      return this.lastCache;
    }
  };

  // node_modules/monaco-editor/esm/vs/base/common/lazy.js
  var Lazy = class {
    constructor(executor) {
      this.executor = executor;
      this._didRun = false;
    }
    getValue() {
      if (!this._didRun) {
        try {
          this._value = this.executor();
        } catch (err) {
          this._error = err;
        } finally {
          this._didRun = true;
        }
      }
      if (this._error) {
        throw this._error;
      }
      return this._value;
    }
    get rawValue() {
      return this._value;
    }
  };

  // node_modules/monaco-editor/esm/vs/base/common/strings.js
  var _a2;
  function escapeRegExpCharacters(value) {
    return value.replace(/[\\\{\}\*\+\?\|\^\$\.\[\]\(\)]/g, "\\$&");
  }
  function splitLines(str) {
    return str.split(/\r\n|\r|\n/);
  }
  function firstNonWhitespaceIndex(str) {
    for (let i = 0, len = str.length; i < len; i++) {
      const chCode = str.charCodeAt(i);
      if (chCode !== 32 && chCode !== 9) {
        return i;
      }
    }
    return -1;
  }
  function lastNonWhitespaceIndex(str, startIndex = str.length - 1) {
    for (let i = startIndex; i >= 0; i--) {
      const chCode = str.charCodeAt(i);
      if (chCode !== 32 && chCode !== 9) {
        return i;
      }
    }
    return -1;
  }
  function isUpperAsciiLetter(code) {
    return code >= 65 && code <= 90;
  }
  function isHighSurrogate(charCode) {
    return 55296 <= charCode && charCode <= 56319;
  }
  function isLowSurrogate(charCode) {
    return 56320 <= charCode && charCode <= 57343;
  }
  function computeCodePoint(highSurrogate, lowSurrogate) {
    return (highSurrogate - 55296 << 10) + (lowSurrogate - 56320) + 65536;
  }
  function getNextCodePoint(str, len, offset) {
    const charCode = str.charCodeAt(offset);
    if (isHighSurrogate(charCode) && offset + 1 < len) {
      const nextCharCode = str.charCodeAt(offset + 1);
      if (isLowSurrogate(nextCharCode)) {
        return computeCodePoint(charCode, nextCharCode);
      }
    }
    return charCode;
  }
  var IS_BASIC_ASCII = /^[\t\n\r\x20-\x7E]*$/;
  function isBasicASCII(str) {
    return IS_BASIC_ASCII.test(str);
  }
  var UTF8_BOM_CHARACTER = String.fromCharCode(65279);
  var GraphemeBreakTree = class {
    constructor() {
      this._data = getGraphemeBreakRawData();
    }
    static getInstance() {
      if (!GraphemeBreakTree._INSTANCE) {
        GraphemeBreakTree._INSTANCE = new GraphemeBreakTree();
      }
      return GraphemeBreakTree._INSTANCE;
    }
    getGraphemeBreakType(codePoint) {
      if (codePoint < 32) {
        if (codePoint === 10) {
          return 3;
        }
        if (codePoint === 13) {
          return 2;
        }
        return 4;
      }
      if (codePoint < 127) {
        return 0;
      }
      const data = this._data;
      const nodeCount = data.length / 3;
      let nodeIndex = 1;
      while (nodeIndex <= nodeCount) {
        if (codePoint < data[3 * nodeIndex]) {
          nodeIndex = 2 * nodeIndex;
        } else if (codePoint > data[3 * nodeIndex + 1]) {
          nodeIndex = 2 * nodeIndex + 1;
        } else {
          return data[3 * nodeIndex + 2];
        }
      }
      return 0;
    }
  };
  GraphemeBreakTree._INSTANCE = null;
  function getGraphemeBreakRawData() {
    return JSON.parse("[0,0,0,51229,51255,12,44061,44087,12,127462,127487,6,7083,7085,5,47645,47671,12,54813,54839,12,128678,128678,14,3270,3270,5,9919,9923,14,45853,45879,12,49437,49463,12,53021,53047,12,71216,71218,7,128398,128399,14,129360,129374,14,2519,2519,5,4448,4519,9,9742,9742,14,12336,12336,14,44957,44983,12,46749,46775,12,48541,48567,12,50333,50359,12,52125,52151,12,53917,53943,12,69888,69890,5,73018,73018,5,127990,127990,14,128558,128559,14,128759,128760,14,129653,129655,14,2027,2035,5,2891,2892,7,3761,3761,5,6683,6683,5,8293,8293,4,9825,9826,14,9999,9999,14,43452,43453,5,44509,44535,12,45405,45431,12,46301,46327,12,47197,47223,12,48093,48119,12,48989,49015,12,49885,49911,12,50781,50807,12,51677,51703,12,52573,52599,12,53469,53495,12,54365,54391,12,65279,65279,4,70471,70472,7,72145,72147,7,119173,119179,5,127799,127818,14,128240,128244,14,128512,128512,14,128652,128652,14,128721,128722,14,129292,129292,14,129445,129450,14,129734,129743,14,1476,1477,5,2366,2368,7,2750,2752,7,3076,3076,5,3415,3415,5,4141,4144,5,6109,6109,5,6964,6964,5,7394,7400,5,9197,9198,14,9770,9770,14,9877,9877,14,9968,9969,14,10084,10084,14,43052,43052,5,43713,43713,5,44285,44311,12,44733,44759,12,45181,45207,12,45629,45655,12,46077,46103,12,46525,46551,12,46973,46999,12,47421,47447,12,47869,47895,12,48317,48343,12,48765,48791,12,49213,49239,12,49661,49687,12,50109,50135,12,50557,50583,12,51005,51031,12,51453,51479,12,51901,51927,12,52349,52375,12,52797,52823,12,53245,53271,12,53693,53719,12,54141,54167,12,54589,54615,12,55037,55063,12,69506,69509,5,70191,70193,5,70841,70841,7,71463,71467,5,72330,72342,5,94031,94031,5,123628,123631,5,127763,127765,14,127941,127941,14,128043,128062,14,128302,128317,14,128465,128467,14,128539,128539,14,128640,128640,14,128662,128662,14,128703,128703,14,128745,128745,14,129004,129007,14,129329,129330,14,129402,129402,14,129483,129483,14,129686,129704,14,130048,131069,14,173,173,4,1757,1757,1,2200,2207,5,2434,2435,7,2631,2632,5,2817,2817,5,3008,3008,5,3201,3201,5,3387,3388,5,3542,3542,5,3902,3903,7,4190,4192,5,6002,6003,5,6439,6440,5,6765,6770,7,7019,7027,5,7154,7155,7,8205,8205,13,8505,8505,14,9654,9654,14,9757,9757,14,9792,9792,14,9852,9853,14,9890,9894,14,9937,9937,14,9981,9981,14,10035,10036,14,11035,11036,14,42654,42655,5,43346,43347,7,43587,43587,5,44006,44007,7,44173,44199,12,44397,44423,12,44621,44647,12,44845,44871,12,45069,45095,12,45293,45319,12,45517,45543,12,45741,45767,12,45965,45991,12,46189,46215,12,46413,46439,12,46637,46663,12,46861,46887,12,47085,47111,12,47309,47335,12,47533,47559,12,47757,47783,12,47981,48007,12,48205,48231,12,48429,48455,12,48653,48679,12,48877,48903,12,49101,49127,12,49325,49351,12,49549,49575,12,49773,49799,12,49997,50023,12,50221,50247,12,50445,50471,12,50669,50695,12,50893,50919,12,51117,51143,12,51341,51367,12,51565,51591,12,51789,51815,12,52013,52039,12,52237,52263,12,52461,52487,12,52685,52711,12,52909,52935,12,53133,53159,12,53357,53383,12,53581,53607,12,53805,53831,12,54029,54055,12,54253,54279,12,54477,54503,12,54701,54727,12,54925,54951,12,55149,55175,12,68101,68102,5,69762,69762,7,70067,70069,7,70371,70378,5,70720,70721,7,71087,71087,5,71341,71341,5,71995,71996,5,72249,72249,7,72850,72871,5,73109,73109,5,118576,118598,5,121505,121519,5,127245,127247,14,127568,127569,14,127777,127777,14,127872,127891,14,127956,127967,14,128015,128016,14,128110,128172,14,128259,128259,14,128367,128368,14,128424,128424,14,128488,128488,14,128530,128532,14,128550,128551,14,128566,128566,14,128647,128647,14,128656,128656,14,128667,128673,14,128691,128693,14,128715,128715,14,128728,128732,14,128752,128752,14,128765,128767,14,129096,129103,14,129311,129311,14,129344,129349,14,129394,129394,14,129413,129425,14,129466,129471,14,129511,129535,14,129664,129666,14,129719,129722,14,129760,129767,14,917536,917631,5,13,13,2,1160,1161,5,1564,1564,4,1807,1807,1,2085,2087,5,2307,2307,7,2382,2383,7,2497,2500,5,2563,2563,7,2677,2677,5,2763,2764,7,2879,2879,5,2914,2915,5,3021,3021,5,3142,3144,5,3263,3263,5,3285,3286,5,3398,3400,7,3530,3530,5,3633,3633,5,3864,3865,5,3974,3975,5,4155,4156,7,4229,4230,5,5909,5909,7,6078,6085,7,6277,6278,5,6451,6456,7,6744,6750,5,6846,6846,5,6972,6972,5,7074,7077,5,7146,7148,7,7222,7223,5,7416,7417,5,8234,8238,4,8417,8417,5,9000,9000,14,9203,9203,14,9730,9731,14,9748,9749,14,9762,9763,14,9776,9783,14,9800,9811,14,9831,9831,14,9872,9873,14,9882,9882,14,9900,9903,14,9929,9933,14,9941,9960,14,9974,9974,14,9989,9989,14,10006,10006,14,10062,10062,14,10160,10160,14,11647,11647,5,12953,12953,14,43019,43019,5,43232,43249,5,43443,43443,5,43567,43568,7,43696,43696,5,43765,43765,7,44013,44013,5,44117,44143,12,44229,44255,12,44341,44367,12,44453,44479,12,44565,44591,12,44677,44703,12,44789,44815,12,44901,44927,12,45013,45039,12,45125,45151,12,45237,45263,12,45349,45375,12,45461,45487,12,45573,45599,12,45685,45711,12,45797,45823,12,45909,45935,12,46021,46047,12,46133,46159,12,46245,46271,12,46357,46383,12,46469,46495,12,46581,46607,12,46693,46719,12,46805,46831,12,46917,46943,12,47029,47055,12,47141,47167,12,47253,47279,12,47365,47391,12,47477,47503,12,47589,47615,12,47701,47727,12,47813,47839,12,47925,47951,12,48037,48063,12,48149,48175,12,48261,48287,12,48373,48399,12,48485,48511,12,48597,48623,12,48709,48735,12,48821,48847,12,48933,48959,12,49045,49071,12,49157,49183,12,49269,49295,12,49381,49407,12,49493,49519,12,49605,49631,12,49717,49743,12,49829,49855,12,49941,49967,12,50053,50079,12,50165,50191,12,50277,50303,12,50389,50415,12,50501,50527,12,50613,50639,12,50725,50751,12,50837,50863,12,50949,50975,12,51061,51087,12,51173,51199,12,51285,51311,12,51397,51423,12,51509,51535,12,51621,51647,12,51733,51759,12,51845,51871,12,51957,51983,12,52069,52095,12,52181,52207,12,52293,52319,12,52405,52431,12,52517,52543,12,52629,52655,12,52741,52767,12,52853,52879,12,52965,52991,12,53077,53103,12,53189,53215,12,53301,53327,12,53413,53439,12,53525,53551,12,53637,53663,12,53749,53775,12,53861,53887,12,53973,53999,12,54085,54111,12,54197,54223,12,54309,54335,12,54421,54447,12,54533,54559,12,54645,54671,12,54757,54783,12,54869,54895,12,54981,55007,12,55093,55119,12,55243,55291,10,66045,66045,5,68325,68326,5,69688,69702,5,69817,69818,5,69957,69958,7,70089,70092,5,70198,70199,5,70462,70462,5,70502,70508,5,70750,70750,5,70846,70846,7,71100,71101,5,71230,71230,7,71351,71351,5,71737,71738,5,72000,72000,7,72160,72160,5,72273,72278,5,72752,72758,5,72882,72883,5,73031,73031,5,73461,73462,7,94192,94193,7,119149,119149,7,121403,121452,5,122915,122916,5,126980,126980,14,127358,127359,14,127535,127535,14,127759,127759,14,127771,127771,14,127792,127793,14,127825,127867,14,127897,127899,14,127945,127945,14,127985,127986,14,128000,128007,14,128021,128021,14,128066,128100,14,128184,128235,14,128249,128252,14,128266,128276,14,128335,128335,14,128379,128390,14,128407,128419,14,128444,128444,14,128481,128481,14,128499,128499,14,128526,128526,14,128536,128536,14,128543,128543,14,128556,128556,14,128564,128564,14,128577,128580,14,128643,128645,14,128649,128649,14,128654,128654,14,128660,128660,14,128664,128664,14,128675,128675,14,128686,128689,14,128695,128696,14,128705,128709,14,128717,128719,14,128725,128725,14,128736,128741,14,128747,128748,14,128755,128755,14,128762,128762,14,128981,128991,14,129009,129023,14,129160,129167,14,129296,129304,14,129320,129327,14,129340,129342,14,129356,129356,14,129388,129392,14,129399,129400,14,129404,129407,14,129432,129442,14,129454,129455,14,129473,129474,14,129485,129487,14,129648,129651,14,129659,129660,14,129671,129679,14,129709,129711,14,129728,129730,14,129751,129753,14,129776,129782,14,917505,917505,4,917760,917999,5,10,10,3,127,159,4,768,879,5,1471,1471,5,1536,1541,1,1648,1648,5,1767,1768,5,1840,1866,5,2070,2073,5,2137,2139,5,2274,2274,1,2363,2363,7,2377,2380,7,2402,2403,5,2494,2494,5,2507,2508,7,2558,2558,5,2622,2624,7,2641,2641,5,2691,2691,7,2759,2760,5,2786,2787,5,2876,2876,5,2881,2884,5,2901,2902,5,3006,3006,5,3014,3016,7,3072,3072,5,3134,3136,5,3157,3158,5,3260,3260,5,3266,3266,5,3274,3275,7,3328,3329,5,3391,3392,7,3405,3405,5,3457,3457,5,3536,3537,7,3551,3551,5,3636,3642,5,3764,3772,5,3895,3895,5,3967,3967,7,3993,4028,5,4146,4151,5,4182,4183,7,4226,4226,5,4253,4253,5,4957,4959,5,5940,5940,7,6070,6070,7,6087,6088,7,6158,6158,4,6432,6434,5,6448,6449,7,6679,6680,5,6742,6742,5,6754,6754,5,6783,6783,5,6912,6915,5,6966,6970,5,6978,6978,5,7042,7042,7,7080,7081,5,7143,7143,7,7150,7150,7,7212,7219,5,7380,7392,5,7412,7412,5,8203,8203,4,8232,8232,4,8265,8265,14,8400,8412,5,8421,8432,5,8617,8618,14,9167,9167,14,9200,9200,14,9410,9410,14,9723,9726,14,9733,9733,14,9745,9745,14,9752,9752,14,9760,9760,14,9766,9766,14,9774,9774,14,9786,9786,14,9794,9794,14,9823,9823,14,9828,9828,14,9833,9850,14,9855,9855,14,9875,9875,14,9880,9880,14,9885,9887,14,9896,9897,14,9906,9916,14,9926,9927,14,9935,9935,14,9939,9939,14,9962,9962,14,9972,9972,14,9978,9978,14,9986,9986,14,9997,9997,14,10002,10002,14,10017,10017,14,10055,10055,14,10071,10071,14,10133,10135,14,10548,10549,14,11093,11093,14,12330,12333,5,12441,12442,5,42608,42610,5,43010,43010,5,43045,43046,5,43188,43203,7,43302,43309,5,43392,43394,5,43446,43449,5,43493,43493,5,43571,43572,7,43597,43597,7,43703,43704,5,43756,43757,5,44003,44004,7,44009,44010,7,44033,44059,12,44089,44115,12,44145,44171,12,44201,44227,12,44257,44283,12,44313,44339,12,44369,44395,12,44425,44451,12,44481,44507,12,44537,44563,12,44593,44619,12,44649,44675,12,44705,44731,12,44761,44787,12,44817,44843,12,44873,44899,12,44929,44955,12,44985,45011,12,45041,45067,12,45097,45123,12,45153,45179,12,45209,45235,12,45265,45291,12,45321,45347,12,45377,45403,12,45433,45459,12,45489,45515,12,45545,45571,12,45601,45627,12,45657,45683,12,45713,45739,12,45769,45795,12,45825,45851,12,45881,45907,12,45937,45963,12,45993,46019,12,46049,46075,12,46105,46131,12,46161,46187,12,46217,46243,12,46273,46299,12,46329,46355,12,46385,46411,12,46441,46467,12,46497,46523,12,46553,46579,12,46609,46635,12,46665,46691,12,46721,46747,12,46777,46803,12,46833,46859,12,46889,46915,12,46945,46971,12,47001,47027,12,47057,47083,12,47113,47139,12,47169,47195,12,47225,47251,12,47281,47307,12,47337,47363,12,47393,47419,12,47449,47475,12,47505,47531,12,47561,47587,12,47617,47643,12,47673,47699,12,47729,47755,12,47785,47811,12,47841,47867,12,47897,47923,12,47953,47979,12,48009,48035,12,48065,48091,12,48121,48147,12,48177,48203,12,48233,48259,12,48289,48315,12,48345,48371,12,48401,48427,12,48457,48483,12,48513,48539,12,48569,48595,12,48625,48651,12,48681,48707,12,48737,48763,12,48793,48819,12,48849,48875,12,48905,48931,12,48961,48987,12,49017,49043,12,49073,49099,12,49129,49155,12,49185,49211,12,49241,49267,12,49297,49323,12,49353,49379,12,49409,49435,12,49465,49491,12,49521,49547,12,49577,49603,12,49633,49659,12,49689,49715,12,49745,49771,12,49801,49827,12,49857,49883,12,49913,49939,12,49969,49995,12,50025,50051,12,50081,50107,12,50137,50163,12,50193,50219,12,50249,50275,12,50305,50331,12,50361,50387,12,50417,50443,12,50473,50499,12,50529,50555,12,50585,50611,12,50641,50667,12,50697,50723,12,50753,50779,12,50809,50835,12,50865,50891,12,50921,50947,12,50977,51003,12,51033,51059,12,51089,51115,12,51145,51171,12,51201,51227,12,51257,51283,12,51313,51339,12,51369,51395,12,51425,51451,12,51481,51507,12,51537,51563,12,51593,51619,12,51649,51675,12,51705,51731,12,51761,51787,12,51817,51843,12,51873,51899,12,51929,51955,12,51985,52011,12,52041,52067,12,52097,52123,12,52153,52179,12,52209,52235,12,52265,52291,12,52321,52347,12,52377,52403,12,52433,52459,12,52489,52515,12,52545,52571,12,52601,52627,12,52657,52683,12,52713,52739,12,52769,52795,12,52825,52851,12,52881,52907,12,52937,52963,12,52993,53019,12,53049,53075,12,53105,53131,12,53161,53187,12,53217,53243,12,53273,53299,12,53329,53355,12,53385,53411,12,53441,53467,12,53497,53523,12,53553,53579,12,53609,53635,12,53665,53691,12,53721,53747,12,53777,53803,12,53833,53859,12,53889,53915,12,53945,53971,12,54001,54027,12,54057,54083,12,54113,54139,12,54169,54195,12,54225,54251,12,54281,54307,12,54337,54363,12,54393,54419,12,54449,54475,12,54505,54531,12,54561,54587,12,54617,54643,12,54673,54699,12,54729,54755,12,54785,54811,12,54841,54867,12,54897,54923,12,54953,54979,12,55009,55035,12,55065,55091,12,55121,55147,12,55177,55203,12,65024,65039,5,65520,65528,4,66422,66426,5,68152,68154,5,69291,69292,5,69633,69633,5,69747,69748,5,69811,69814,5,69826,69826,5,69932,69932,7,70016,70017,5,70079,70080,7,70095,70095,5,70196,70196,5,70367,70367,5,70402,70403,7,70464,70464,5,70487,70487,5,70709,70711,7,70725,70725,7,70833,70834,7,70843,70844,7,70849,70849,7,71090,71093,5,71103,71104,5,71227,71228,7,71339,71339,5,71344,71349,5,71458,71461,5,71727,71735,5,71985,71989,7,71998,71998,5,72002,72002,7,72154,72155,5,72193,72202,5,72251,72254,5,72281,72283,5,72344,72345,5,72766,72766,7,72874,72880,5,72885,72886,5,73023,73029,5,73104,73105,5,73111,73111,5,92912,92916,5,94095,94098,5,113824,113827,4,119142,119142,7,119155,119162,4,119362,119364,5,121476,121476,5,122888,122904,5,123184,123190,5,125252,125258,5,127183,127183,14,127340,127343,14,127377,127386,14,127491,127503,14,127548,127551,14,127744,127756,14,127761,127761,14,127769,127769,14,127773,127774,14,127780,127788,14,127796,127797,14,127820,127823,14,127869,127869,14,127894,127895,14,127902,127903,14,127943,127943,14,127947,127950,14,127972,127972,14,127988,127988,14,127992,127994,14,128009,128011,14,128019,128019,14,128023,128041,14,128064,128064,14,128102,128107,14,128174,128181,14,128238,128238,14,128246,128247,14,128254,128254,14,128264,128264,14,128278,128299,14,128329,128330,14,128348,128359,14,128371,128377,14,128392,128393,14,128401,128404,14,128421,128421,14,128433,128434,14,128450,128452,14,128476,128478,14,128483,128483,14,128495,128495,14,128506,128506,14,128519,128520,14,128528,128528,14,128534,128534,14,128538,128538,14,128540,128542,14,128544,128549,14,128552,128555,14,128557,128557,14,128560,128563,14,128565,128565,14,128567,128576,14,128581,128591,14,128641,128642,14,128646,128646,14,128648,128648,14,128650,128651,14,128653,128653,14,128655,128655,14,128657,128659,14,128661,128661,14,128663,128663,14,128665,128666,14,128674,128674,14,128676,128677,14,128679,128685,14,128690,128690,14,128694,128694,14,128697,128702,14,128704,128704,14,128710,128714,14,128716,128716,14,128720,128720,14,128723,128724,14,128726,128727,14,128733,128735,14,128742,128744,14,128746,128746,14,128749,128751,14,128753,128754,14,128756,128758,14,128761,128761,14,128763,128764,14,128884,128895,14,128992,129003,14,129008,129008,14,129036,129039,14,129114,129119,14,129198,129279,14,129293,129295,14,129305,129310,14,129312,129319,14,129328,129328,14,129331,129338,14,129343,129343,14,129351,129355,14,129357,129359,14,129375,129387,14,129393,129393,14,129395,129398,14,129401,129401,14,129403,129403,14,129408,129412,14,129426,129431,14,129443,129444,14,129451,129453,14,129456,129465,14,129472,129472,14,129475,129482,14,129484,129484,14,129488,129510,14,129536,129647,14,129652,129652,14,129656,129658,14,129661,129663,14,129667,129670,14,129680,129685,14,129705,129708,14,129712,129718,14,129723,129727,14,129731,129733,14,129744,129750,14,129754,129759,14,129768,129775,14,129783,129791,14,917504,917504,4,917506,917535,4,917632,917759,4,918000,921599,4,0,9,4,11,12,4,14,31,4,169,169,14,174,174,14,1155,1159,5,1425,1469,5,1473,1474,5,1479,1479,5,1552,1562,5,1611,1631,5,1750,1756,5,1759,1764,5,1770,1773,5,1809,1809,5,1958,1968,5,2045,2045,5,2075,2083,5,2089,2093,5,2192,2193,1,2250,2273,5,2275,2306,5,2362,2362,5,2364,2364,5,2369,2376,5,2381,2381,5,2385,2391,5,2433,2433,5,2492,2492,5,2495,2496,7,2503,2504,7,2509,2509,5,2530,2531,5,2561,2562,5,2620,2620,5,2625,2626,5,2635,2637,5,2672,2673,5,2689,2690,5,2748,2748,5,2753,2757,5,2761,2761,7,2765,2765,5,2810,2815,5,2818,2819,7,2878,2878,5,2880,2880,7,2887,2888,7,2893,2893,5,2903,2903,5,2946,2946,5,3007,3007,7,3009,3010,7,3018,3020,7,3031,3031,5,3073,3075,7,3132,3132,5,3137,3140,7,3146,3149,5,3170,3171,5,3202,3203,7,3262,3262,7,3264,3265,7,3267,3268,7,3271,3272,7,3276,3277,5,3298,3299,5,3330,3331,7,3390,3390,5,3393,3396,5,3402,3404,7,3406,3406,1,3426,3427,5,3458,3459,7,3535,3535,5,3538,3540,5,3544,3550,7,3570,3571,7,3635,3635,7,3655,3662,5,3763,3763,7,3784,3789,5,3893,3893,5,3897,3897,5,3953,3966,5,3968,3972,5,3981,3991,5,4038,4038,5,4145,4145,7,4153,4154,5,4157,4158,5,4184,4185,5,4209,4212,5,4228,4228,7,4237,4237,5,4352,4447,8,4520,4607,10,5906,5908,5,5938,5939,5,5970,5971,5,6068,6069,5,6071,6077,5,6086,6086,5,6089,6099,5,6155,6157,5,6159,6159,5,6313,6313,5,6435,6438,7,6441,6443,7,6450,6450,5,6457,6459,5,6681,6682,7,6741,6741,7,6743,6743,7,6752,6752,5,6757,6764,5,6771,6780,5,6832,6845,5,6847,6862,5,6916,6916,7,6965,6965,5,6971,6971,7,6973,6977,7,6979,6980,7,7040,7041,5,7073,7073,7,7078,7079,7,7082,7082,7,7142,7142,5,7144,7145,5,7149,7149,5,7151,7153,5,7204,7211,7,7220,7221,7,7376,7378,5,7393,7393,7,7405,7405,5,7415,7415,7,7616,7679,5,8204,8204,5,8206,8207,4,8233,8233,4,8252,8252,14,8288,8292,4,8294,8303,4,8413,8416,5,8418,8420,5,8482,8482,14,8596,8601,14,8986,8987,14,9096,9096,14,9193,9196,14,9199,9199,14,9201,9202,14,9208,9210,14,9642,9643,14,9664,9664,14,9728,9729,14,9732,9732,14,9735,9741,14,9743,9744,14,9746,9746,14,9750,9751,14,9753,9756,14,9758,9759,14,9761,9761,14,9764,9765,14,9767,9769,14,9771,9773,14,9775,9775,14,9784,9785,14,9787,9791,14,9793,9793,14,9795,9799,14,9812,9822,14,9824,9824,14,9827,9827,14,9829,9830,14,9832,9832,14,9851,9851,14,9854,9854,14,9856,9861,14,9874,9874,14,9876,9876,14,9878,9879,14,9881,9881,14,9883,9884,14,9888,9889,14,9895,9895,14,9898,9899,14,9904,9905,14,9917,9918,14,9924,9925,14,9928,9928,14,9934,9934,14,9936,9936,14,9938,9938,14,9940,9940,14,9961,9961,14,9963,9967,14,9970,9971,14,9973,9973,14,9975,9977,14,9979,9980,14,9982,9985,14,9987,9988,14,9992,9996,14,9998,9998,14,10000,10001,14,10004,10004,14,10013,10013,14,10024,10024,14,10052,10052,14,10060,10060,14,10067,10069,14,10083,10083,14,10085,10087,14,10145,10145,14,10175,10175,14,11013,11015,14,11088,11088,14,11503,11505,5,11744,11775,5,12334,12335,5,12349,12349,14,12951,12951,14,42607,42607,5,42612,42621,5,42736,42737,5,43014,43014,5,43043,43044,7,43047,43047,7,43136,43137,7,43204,43205,5,43263,43263,5,43335,43345,5,43360,43388,8,43395,43395,7,43444,43445,7,43450,43451,7,43454,43456,7,43561,43566,5,43569,43570,5,43573,43574,5,43596,43596,5,43644,43644,5,43698,43700,5,43710,43711,5,43755,43755,7,43758,43759,7,43766,43766,5,44005,44005,5,44008,44008,5,44012,44012,7,44032,44032,11,44060,44060,11,44088,44088,11,44116,44116,11,44144,44144,11,44172,44172,11,44200,44200,11,44228,44228,11,44256,44256,11,44284,44284,11,44312,44312,11,44340,44340,11,44368,44368,11,44396,44396,11,44424,44424,11,44452,44452,11,44480,44480,11,44508,44508,11,44536,44536,11,44564,44564,11,44592,44592,11,44620,44620,11,44648,44648,11,44676,44676,11,44704,44704,11,44732,44732,11,44760,44760,11,44788,44788,11,44816,44816,11,44844,44844,11,44872,44872,11,44900,44900,11,44928,44928,11,44956,44956,11,44984,44984,11,45012,45012,11,45040,45040,11,45068,45068,11,45096,45096,11,45124,45124,11,45152,45152,11,45180,45180,11,45208,45208,11,45236,45236,11,45264,45264,11,45292,45292,11,45320,45320,11,45348,45348,11,45376,45376,11,45404,45404,11,45432,45432,11,45460,45460,11,45488,45488,11,45516,45516,11,45544,45544,11,45572,45572,11,45600,45600,11,45628,45628,11,45656,45656,11,45684,45684,11,45712,45712,11,45740,45740,11,45768,45768,11,45796,45796,11,45824,45824,11,45852,45852,11,45880,45880,11,45908,45908,11,45936,45936,11,45964,45964,11,45992,45992,11,46020,46020,11,46048,46048,11,46076,46076,11,46104,46104,11,46132,46132,11,46160,46160,11,46188,46188,11,46216,46216,11,46244,46244,11,46272,46272,11,46300,46300,11,46328,46328,11,46356,46356,11,46384,46384,11,46412,46412,11,46440,46440,11,46468,46468,11,46496,46496,11,46524,46524,11,46552,46552,11,46580,46580,11,46608,46608,11,46636,46636,11,46664,46664,11,46692,46692,11,46720,46720,11,46748,46748,11,46776,46776,11,46804,46804,11,46832,46832,11,46860,46860,11,46888,46888,11,46916,46916,11,46944,46944,11,46972,46972,11,47000,47000,11,47028,47028,11,47056,47056,11,47084,47084,11,47112,47112,11,47140,47140,11,47168,47168,11,47196,47196,11,47224,47224,11,47252,47252,11,47280,47280,11,47308,47308,11,47336,47336,11,47364,47364,11,47392,47392,11,47420,47420,11,47448,47448,11,47476,47476,11,47504,47504,11,47532,47532,11,47560,47560,11,47588,47588,11,47616,47616,11,47644,47644,11,47672,47672,11,47700,47700,11,47728,47728,11,47756,47756,11,47784,47784,11,47812,47812,11,47840,47840,11,47868,47868,11,47896,47896,11,47924,47924,11,47952,47952,11,47980,47980,11,48008,48008,11,48036,48036,11,48064,48064,11,48092,48092,11,48120,48120,11,48148,48148,11,48176,48176,11,48204,48204,11,48232,48232,11,48260,48260,11,48288,48288,11,48316,48316,11,48344,48344,11,48372,48372,11,48400,48400,11,48428,48428,11,48456,48456,11,48484,48484,11,48512,48512,11,48540,48540,11,48568,48568,11,48596,48596,11,48624,48624,11,48652,48652,11,48680,48680,11,48708,48708,11,48736,48736,11,48764,48764,11,48792,48792,11,48820,48820,11,48848,48848,11,48876,48876,11,48904,48904,11,48932,48932,11,48960,48960,11,48988,48988,11,49016,49016,11,49044,49044,11,49072,49072,11,49100,49100,11,49128,49128,11,49156,49156,11,49184,49184,11,49212,49212,11,49240,49240,11,49268,49268,11,49296,49296,11,49324,49324,11,49352,49352,11,49380,49380,11,49408,49408,11,49436,49436,11,49464,49464,11,49492,49492,11,49520,49520,11,49548,49548,11,49576,49576,11,49604,49604,11,49632,49632,11,49660,49660,11,49688,49688,11,49716,49716,11,49744,49744,11,49772,49772,11,49800,49800,11,49828,49828,11,49856,49856,11,49884,49884,11,49912,49912,11,49940,49940,11,49968,49968,11,49996,49996,11,50024,50024,11,50052,50052,11,50080,50080,11,50108,50108,11,50136,50136,11,50164,50164,11,50192,50192,11,50220,50220,11,50248,50248,11,50276,50276,11,50304,50304,11,50332,50332,11,50360,50360,11,50388,50388,11,50416,50416,11,50444,50444,11,50472,50472,11,50500,50500,11,50528,50528,11,50556,50556,11,50584,50584,11,50612,50612,11,50640,50640,11,50668,50668,11,50696,50696,11,50724,50724,11,50752,50752,11,50780,50780,11,50808,50808,11,50836,50836,11,50864,50864,11,50892,50892,11,50920,50920,11,50948,50948,11,50976,50976,11,51004,51004,11,51032,51032,11,51060,51060,11,51088,51088,11,51116,51116,11,51144,51144,11,51172,51172,11,51200,51200,11,51228,51228,11,51256,51256,11,51284,51284,11,51312,51312,11,51340,51340,11,51368,51368,11,51396,51396,11,51424,51424,11,51452,51452,11,51480,51480,11,51508,51508,11,51536,51536,11,51564,51564,11,51592,51592,11,51620,51620,11,51648,51648,11,51676,51676,11,51704,51704,11,51732,51732,11,51760,51760,11,51788,51788,11,51816,51816,11,51844,51844,11,51872,51872,11,51900,51900,11,51928,51928,11,51956,51956,11,51984,51984,11,52012,52012,11,52040,52040,11,52068,52068,11,52096,52096,11,52124,52124,11,52152,52152,11,52180,52180,11,52208,52208,11,52236,52236,11,52264,52264,11,52292,52292,11,52320,52320,11,52348,52348,11,52376,52376,11,52404,52404,11,52432,52432,11,52460,52460,11,52488,52488,11,52516,52516,11,52544,52544,11,52572,52572,11,52600,52600,11,52628,52628,11,52656,52656,11,52684,52684,11,52712,52712,11,52740,52740,11,52768,52768,11,52796,52796,11,52824,52824,11,52852,52852,11,52880,52880,11,52908,52908,11,52936,52936,11,52964,52964,11,52992,52992,11,53020,53020,11,53048,53048,11,53076,53076,11,53104,53104,11,53132,53132,11,53160,53160,11,53188,53188,11,53216,53216,11,53244,53244,11,53272,53272,11,53300,53300,11,53328,53328,11,53356,53356,11,53384,53384,11,53412,53412,11,53440,53440,11,53468,53468,11,53496,53496,11,53524,53524,11,53552,53552,11,53580,53580,11,53608,53608,11,53636,53636,11,53664,53664,11,53692,53692,11,53720,53720,11,53748,53748,11,53776,53776,11,53804,53804,11,53832,53832,11,53860,53860,11,53888,53888,11,53916,53916,11,53944,53944,11,53972,53972,11,54000,54000,11,54028,54028,11,54056,54056,11,54084,54084,11,54112,54112,11,54140,54140,11,54168,54168,11,54196,54196,11,54224,54224,11,54252,54252,11,54280,54280,11,54308,54308,11,54336,54336,11,54364,54364,11,54392,54392,11,54420,54420,11,54448,54448,11,54476,54476,11,54504,54504,11,54532,54532,11,54560,54560,11,54588,54588,11,54616,54616,11,54644,54644,11,54672,54672,11,54700,54700,11,54728,54728,11,54756,54756,11,54784,54784,11,54812,54812,11,54840,54840,11,54868,54868,11,54896,54896,11,54924,54924,11,54952,54952,11,54980,54980,11,55008,55008,11,55036,55036,11,55064,55064,11,55092,55092,11,55120,55120,11,55148,55148,11,55176,55176,11,55216,55238,9,64286,64286,5,65056,65071,5,65438,65439,5,65529,65531,4,66272,66272,5,68097,68099,5,68108,68111,5,68159,68159,5,68900,68903,5,69446,69456,5,69632,69632,7,69634,69634,7,69744,69744,5,69759,69761,5,69808,69810,7,69815,69816,7,69821,69821,1,69837,69837,1,69927,69931,5,69933,69940,5,70003,70003,5,70018,70018,7,70070,70078,5,70082,70083,1,70094,70094,7,70188,70190,7,70194,70195,7,70197,70197,7,70206,70206,5,70368,70370,7,70400,70401,5,70459,70460,5,70463,70463,7,70465,70468,7,70475,70477,7,70498,70499,7,70512,70516,5,70712,70719,5,70722,70724,5,70726,70726,5,70832,70832,5,70835,70840,5,70842,70842,5,70845,70845,5,70847,70848,5,70850,70851,5,71088,71089,7,71096,71099,7,71102,71102,7,71132,71133,5,71219,71226,5,71229,71229,5,71231,71232,5,71340,71340,7,71342,71343,7,71350,71350,7,71453,71455,5,71462,71462,7,71724,71726,7,71736,71736,7,71984,71984,5,71991,71992,7,71997,71997,7,71999,71999,1,72001,72001,1,72003,72003,5,72148,72151,5,72156,72159,7,72164,72164,7,72243,72248,5,72250,72250,1,72263,72263,5,72279,72280,7,72324,72329,1,72343,72343,7,72751,72751,7,72760,72765,5,72767,72767,5,72873,72873,7,72881,72881,7,72884,72884,7,73009,73014,5,73020,73021,5,73030,73030,1,73098,73102,7,73107,73108,7,73110,73110,7,73459,73460,5,78896,78904,4,92976,92982,5,94033,94087,7,94180,94180,5,113821,113822,5,118528,118573,5,119141,119141,5,119143,119145,5,119150,119154,5,119163,119170,5,119210,119213,5,121344,121398,5,121461,121461,5,121499,121503,5,122880,122886,5,122907,122913,5,122918,122922,5,123566,123566,5,125136,125142,5,126976,126979,14,126981,127182,14,127184,127231,14,127279,127279,14,127344,127345,14,127374,127374,14,127405,127461,14,127489,127490,14,127514,127514,14,127538,127546,14,127561,127567,14,127570,127743,14,127757,127758,14,127760,127760,14,127762,127762,14,127766,127768,14,127770,127770,14,127772,127772,14,127775,127776,14,127778,127779,14,127789,127791,14,127794,127795,14,127798,127798,14,127819,127819,14,127824,127824,14,127868,127868,14,127870,127871,14,127892,127893,14,127896,127896,14,127900,127901,14,127904,127940,14,127942,127942,14,127944,127944,14,127946,127946,14,127951,127955,14,127968,127971,14,127973,127984,14,127987,127987,14,127989,127989,14,127991,127991,14,127995,127999,5,128008,128008,14,128012,128014,14,128017,128018,14,128020,128020,14,128022,128022,14,128042,128042,14,128063,128063,14,128065,128065,14,128101,128101,14,128108,128109,14,128173,128173,14,128182,128183,14,128236,128237,14,128239,128239,14,128245,128245,14,128248,128248,14,128253,128253,14,128255,128258,14,128260,128263,14,128265,128265,14,128277,128277,14,128300,128301,14,128326,128328,14,128331,128334,14,128336,128347,14,128360,128366,14,128369,128370,14,128378,128378,14,128391,128391,14,128394,128397,14,128400,128400,14,128405,128406,14,128420,128420,14,128422,128423,14,128425,128432,14,128435,128443,14,128445,128449,14,128453,128464,14,128468,128475,14,128479,128480,14,128482,128482,14,128484,128487,14,128489,128494,14,128496,128498,14,128500,128505,14,128507,128511,14,128513,128518,14,128521,128525,14,128527,128527,14,128529,128529,14,128533,128533,14,128535,128535,14,128537,128537,14]");
  }
  var AmbiguousCharacters = class {
    constructor(confusableDictionary) {
      this.confusableDictionary = confusableDictionary;
    }
    static getInstance(locales) {
      return AmbiguousCharacters.cache.get(Array.from(locales));
    }
    static getLocales() {
      return AmbiguousCharacters._locales.getValue();
    }
    isAmbiguous(codePoint) {
      return this.confusableDictionary.has(codePoint);
    }
    getPrimaryConfusable(codePoint) {
      return this.confusableDictionary.get(codePoint);
    }
    getConfusableCodePoints() {
      return new Set(this.confusableDictionary.keys());
    }
  };
  _a2 = AmbiguousCharacters;
  AmbiguousCharacters.ambiguousCharacterData = new Lazy(() => {
    return JSON.parse('{"_common":[8232,32,8233,32,5760,32,8192,32,8193,32,8194,32,8195,32,8196,32,8197,32,8198,32,8200,32,8201,32,8202,32,8287,32,8199,32,8239,32,2042,95,65101,95,65102,95,65103,95,8208,45,8209,45,8210,45,65112,45,1748,45,8259,45,727,45,8722,45,10134,45,11450,45,1549,44,1643,44,8218,44,184,44,42233,44,894,59,2307,58,2691,58,1417,58,1795,58,1796,58,5868,58,65072,58,6147,58,6153,58,8282,58,1475,58,760,58,42889,58,8758,58,720,58,42237,58,451,33,11601,33,660,63,577,63,2429,63,5038,63,42731,63,119149,46,8228,46,1793,46,1794,46,42510,46,68176,46,1632,46,1776,46,42232,46,1373,96,65287,96,8219,96,8242,96,1370,96,1523,96,8175,96,65344,96,900,96,8189,96,8125,96,8127,96,8190,96,697,96,884,96,712,96,714,96,715,96,756,96,699,96,701,96,700,96,702,96,42892,96,1497,96,2036,96,2037,96,5194,96,5836,96,94033,96,94034,96,65339,91,10088,40,10098,40,12308,40,64830,40,65341,93,10089,41,10099,41,12309,41,64831,41,10100,123,119060,123,10101,125,65342,94,8270,42,1645,42,8727,42,66335,42,5941,47,8257,47,8725,47,8260,47,9585,47,10187,47,10744,47,119354,47,12755,47,12339,47,11462,47,20031,47,12035,47,65340,92,65128,92,8726,92,10189,92,10741,92,10745,92,119311,92,119355,92,12756,92,20022,92,12034,92,42872,38,708,94,710,94,5869,43,10133,43,66203,43,8249,60,10094,60,706,60,119350,60,5176,60,5810,60,5120,61,11840,61,12448,61,42239,61,8250,62,10095,62,707,62,119351,62,5171,62,94015,62,8275,126,732,126,8128,126,8764,126,65372,124,65293,45,120784,50,120794,50,120804,50,120814,50,120824,50,130034,50,42842,50,423,50,1000,50,42564,50,5311,50,42735,50,119302,51,120785,51,120795,51,120805,51,120815,51,120825,51,130035,51,42923,51,540,51,439,51,42858,51,11468,51,1248,51,94011,51,71882,51,120786,52,120796,52,120806,52,120816,52,120826,52,130036,52,5070,52,71855,52,120787,53,120797,53,120807,53,120817,53,120827,53,130037,53,444,53,71867,53,120788,54,120798,54,120808,54,120818,54,120828,54,130038,54,11474,54,5102,54,71893,54,119314,55,120789,55,120799,55,120809,55,120819,55,120829,55,130039,55,66770,55,71878,55,2819,56,2538,56,2666,56,125131,56,120790,56,120800,56,120810,56,120820,56,120830,56,130040,56,547,56,546,56,66330,56,2663,57,2920,57,2541,57,3437,57,120791,57,120801,57,120811,57,120821,57,120831,57,130041,57,42862,57,11466,57,71884,57,71852,57,71894,57,9082,97,65345,97,119834,97,119886,97,119938,97,119990,97,120042,97,120094,97,120146,97,120198,97,120250,97,120302,97,120354,97,120406,97,120458,97,593,97,945,97,120514,97,120572,97,120630,97,120688,97,120746,97,65313,65,119808,65,119860,65,119912,65,119964,65,120016,65,120068,65,120120,65,120172,65,120224,65,120276,65,120328,65,120380,65,120432,65,913,65,120488,65,120546,65,120604,65,120662,65,120720,65,5034,65,5573,65,42222,65,94016,65,66208,65,119835,98,119887,98,119939,98,119991,98,120043,98,120095,98,120147,98,120199,98,120251,98,120303,98,120355,98,120407,98,120459,98,388,98,5071,98,5234,98,5551,98,65314,66,8492,66,119809,66,119861,66,119913,66,120017,66,120069,66,120121,66,120173,66,120225,66,120277,66,120329,66,120381,66,120433,66,42932,66,914,66,120489,66,120547,66,120605,66,120663,66,120721,66,5108,66,5623,66,42192,66,66178,66,66209,66,66305,66,65347,99,8573,99,119836,99,119888,99,119940,99,119992,99,120044,99,120096,99,120148,99,120200,99,120252,99,120304,99,120356,99,120408,99,120460,99,7428,99,1010,99,11429,99,43951,99,66621,99,128844,67,71922,67,71913,67,65315,67,8557,67,8450,67,8493,67,119810,67,119862,67,119914,67,119966,67,120018,67,120174,67,120226,67,120278,67,120330,67,120382,67,120434,67,1017,67,11428,67,5087,67,42202,67,66210,67,66306,67,66581,67,66844,67,8574,100,8518,100,119837,100,119889,100,119941,100,119993,100,120045,100,120097,100,120149,100,120201,100,120253,100,120305,100,120357,100,120409,100,120461,100,1281,100,5095,100,5231,100,42194,100,8558,68,8517,68,119811,68,119863,68,119915,68,119967,68,120019,68,120071,68,120123,68,120175,68,120227,68,120279,68,120331,68,120383,68,120435,68,5024,68,5598,68,5610,68,42195,68,8494,101,65349,101,8495,101,8519,101,119838,101,119890,101,119942,101,120046,101,120098,101,120150,101,120202,101,120254,101,120306,101,120358,101,120410,101,120462,101,43826,101,1213,101,8959,69,65317,69,8496,69,119812,69,119864,69,119916,69,120020,69,120072,69,120124,69,120176,69,120228,69,120280,69,120332,69,120384,69,120436,69,917,69,120492,69,120550,69,120608,69,120666,69,120724,69,11577,69,5036,69,42224,69,71846,69,71854,69,66182,69,119839,102,119891,102,119943,102,119995,102,120047,102,120099,102,120151,102,120203,102,120255,102,120307,102,120359,102,120411,102,120463,102,43829,102,42905,102,383,102,7837,102,1412,102,119315,70,8497,70,119813,70,119865,70,119917,70,120021,70,120073,70,120125,70,120177,70,120229,70,120281,70,120333,70,120385,70,120437,70,42904,70,988,70,120778,70,5556,70,42205,70,71874,70,71842,70,66183,70,66213,70,66853,70,65351,103,8458,103,119840,103,119892,103,119944,103,120048,103,120100,103,120152,103,120204,103,120256,103,120308,103,120360,103,120412,103,120464,103,609,103,7555,103,397,103,1409,103,119814,71,119866,71,119918,71,119970,71,120022,71,120074,71,120126,71,120178,71,120230,71,120282,71,120334,71,120386,71,120438,71,1292,71,5056,71,5107,71,42198,71,65352,104,8462,104,119841,104,119945,104,119997,104,120049,104,120101,104,120153,104,120205,104,120257,104,120309,104,120361,104,120413,104,120465,104,1211,104,1392,104,5058,104,65320,72,8459,72,8460,72,8461,72,119815,72,119867,72,119919,72,120023,72,120179,72,120231,72,120283,72,120335,72,120387,72,120439,72,919,72,120494,72,120552,72,120610,72,120668,72,120726,72,11406,72,5051,72,5500,72,42215,72,66255,72,731,105,9075,105,65353,105,8560,105,8505,105,8520,105,119842,105,119894,105,119946,105,119998,105,120050,105,120102,105,120154,105,120206,105,120258,105,120310,105,120362,105,120414,105,120466,105,120484,105,618,105,617,105,953,105,8126,105,890,105,120522,105,120580,105,120638,105,120696,105,120754,105,1110,105,42567,105,1231,105,43893,105,5029,105,71875,105,65354,106,8521,106,119843,106,119895,106,119947,106,119999,106,120051,106,120103,106,120155,106,120207,106,120259,106,120311,106,120363,106,120415,106,120467,106,1011,106,1112,106,65322,74,119817,74,119869,74,119921,74,119973,74,120025,74,120077,74,120129,74,120181,74,120233,74,120285,74,120337,74,120389,74,120441,74,42930,74,895,74,1032,74,5035,74,5261,74,42201,74,119844,107,119896,107,119948,107,120000,107,120052,107,120104,107,120156,107,120208,107,120260,107,120312,107,120364,107,120416,107,120468,107,8490,75,65323,75,119818,75,119870,75,119922,75,119974,75,120026,75,120078,75,120130,75,120182,75,120234,75,120286,75,120338,75,120390,75,120442,75,922,75,120497,75,120555,75,120613,75,120671,75,120729,75,11412,75,5094,75,5845,75,42199,75,66840,75,1472,108,8739,73,9213,73,65512,73,1633,108,1777,73,66336,108,125127,108,120783,73,120793,73,120803,73,120813,73,120823,73,130033,73,65321,73,8544,73,8464,73,8465,73,119816,73,119868,73,119920,73,120024,73,120128,73,120180,73,120232,73,120284,73,120336,73,120388,73,120440,73,65356,108,8572,73,8467,108,119845,108,119897,108,119949,108,120001,108,120053,108,120105,73,120157,73,120209,73,120261,73,120313,73,120365,73,120417,73,120469,73,448,73,120496,73,120554,73,120612,73,120670,73,120728,73,11410,73,1030,73,1216,73,1493,108,1503,108,1575,108,126464,108,126592,108,65166,108,65165,108,1994,108,11599,73,5825,73,42226,73,93992,73,66186,124,66313,124,119338,76,8556,76,8466,76,119819,76,119871,76,119923,76,120027,76,120079,76,120131,76,120183,76,120235,76,120287,76,120339,76,120391,76,120443,76,11472,76,5086,76,5290,76,42209,76,93974,76,71843,76,71858,76,66587,76,66854,76,65325,77,8559,77,8499,77,119820,77,119872,77,119924,77,120028,77,120080,77,120132,77,120184,77,120236,77,120288,77,120340,77,120392,77,120444,77,924,77,120499,77,120557,77,120615,77,120673,77,120731,77,1018,77,11416,77,5047,77,5616,77,5846,77,42207,77,66224,77,66321,77,119847,110,119899,110,119951,110,120003,110,120055,110,120107,110,120159,110,120211,110,120263,110,120315,110,120367,110,120419,110,120471,110,1400,110,1404,110,65326,78,8469,78,119821,78,119873,78,119925,78,119977,78,120029,78,120081,78,120185,78,120237,78,120289,78,120341,78,120393,78,120445,78,925,78,120500,78,120558,78,120616,78,120674,78,120732,78,11418,78,42208,78,66835,78,3074,111,3202,111,3330,111,3458,111,2406,111,2662,111,2790,111,3046,111,3174,111,3302,111,3430,111,3664,111,3792,111,4160,111,1637,111,1781,111,65359,111,8500,111,119848,111,119900,111,119952,111,120056,111,120108,111,120160,111,120212,111,120264,111,120316,111,120368,111,120420,111,120472,111,7439,111,7441,111,43837,111,959,111,120528,111,120586,111,120644,111,120702,111,120760,111,963,111,120532,111,120590,111,120648,111,120706,111,120764,111,11423,111,4351,111,1413,111,1505,111,1607,111,126500,111,126564,111,126596,111,65259,111,65260,111,65258,111,65257,111,1726,111,64428,111,64429,111,64427,111,64426,111,1729,111,64424,111,64425,111,64423,111,64422,111,1749,111,3360,111,4125,111,66794,111,71880,111,71895,111,66604,111,1984,79,2534,79,2918,79,12295,79,70864,79,71904,79,120782,79,120792,79,120802,79,120812,79,120822,79,130032,79,65327,79,119822,79,119874,79,119926,79,119978,79,120030,79,120082,79,120134,79,120186,79,120238,79,120290,79,120342,79,120394,79,120446,79,927,79,120502,79,120560,79,120618,79,120676,79,120734,79,11422,79,1365,79,11604,79,4816,79,2848,79,66754,79,42227,79,71861,79,66194,79,66219,79,66564,79,66838,79,9076,112,65360,112,119849,112,119901,112,119953,112,120005,112,120057,112,120109,112,120161,112,120213,112,120265,112,120317,112,120369,112,120421,112,120473,112,961,112,120530,112,120544,112,120588,112,120602,112,120646,112,120660,112,120704,112,120718,112,120762,112,120776,112,11427,112,65328,80,8473,80,119823,80,119875,80,119927,80,119979,80,120031,80,120083,80,120187,80,120239,80,120291,80,120343,80,120395,80,120447,80,929,80,120504,80,120562,80,120620,80,120678,80,120736,80,11426,80,5090,80,5229,80,42193,80,66197,80,119850,113,119902,113,119954,113,120006,113,120058,113,120110,113,120162,113,120214,113,120266,113,120318,113,120370,113,120422,113,120474,113,1307,113,1379,113,1382,113,8474,81,119824,81,119876,81,119928,81,119980,81,120032,81,120084,81,120188,81,120240,81,120292,81,120344,81,120396,81,120448,81,11605,81,119851,114,119903,114,119955,114,120007,114,120059,114,120111,114,120163,114,120215,114,120267,114,120319,114,120371,114,120423,114,120475,114,43847,114,43848,114,7462,114,11397,114,43905,114,119318,82,8475,82,8476,82,8477,82,119825,82,119877,82,119929,82,120033,82,120189,82,120241,82,120293,82,120345,82,120397,82,120449,82,422,82,5025,82,5074,82,66740,82,5511,82,42211,82,94005,82,65363,115,119852,115,119904,115,119956,115,120008,115,120060,115,120112,115,120164,115,120216,115,120268,115,120320,115,120372,115,120424,115,120476,115,42801,115,445,115,1109,115,43946,115,71873,115,66632,115,65331,83,119826,83,119878,83,119930,83,119982,83,120034,83,120086,83,120138,83,120190,83,120242,83,120294,83,120346,83,120398,83,120450,83,1029,83,1359,83,5077,83,5082,83,42210,83,94010,83,66198,83,66592,83,119853,116,119905,116,119957,116,120009,116,120061,116,120113,116,120165,116,120217,116,120269,116,120321,116,120373,116,120425,116,120477,116,8868,84,10201,84,128872,84,65332,84,119827,84,119879,84,119931,84,119983,84,120035,84,120087,84,120139,84,120191,84,120243,84,120295,84,120347,84,120399,84,120451,84,932,84,120507,84,120565,84,120623,84,120681,84,120739,84,11430,84,5026,84,42196,84,93962,84,71868,84,66199,84,66225,84,66325,84,119854,117,119906,117,119958,117,120010,117,120062,117,120114,117,120166,117,120218,117,120270,117,120322,117,120374,117,120426,117,120478,117,42911,117,7452,117,43854,117,43858,117,651,117,965,117,120534,117,120592,117,120650,117,120708,117,120766,117,1405,117,66806,117,71896,117,8746,85,8899,85,119828,85,119880,85,119932,85,119984,85,120036,85,120088,85,120140,85,120192,85,120244,85,120296,85,120348,85,120400,85,120452,85,1357,85,4608,85,66766,85,5196,85,42228,85,94018,85,71864,85,8744,118,8897,118,65366,118,8564,118,119855,118,119907,118,119959,118,120011,118,120063,118,120115,118,120167,118,120219,118,120271,118,120323,118,120375,118,120427,118,120479,118,7456,118,957,118,120526,118,120584,118,120642,118,120700,118,120758,118,1141,118,1496,118,71430,118,43945,118,71872,118,119309,86,1639,86,1783,86,8548,86,119829,86,119881,86,119933,86,119985,86,120037,86,120089,86,120141,86,120193,86,120245,86,120297,86,120349,86,120401,86,120453,86,1140,86,11576,86,5081,86,5167,86,42719,86,42214,86,93960,86,71840,86,66845,86,623,119,119856,119,119908,119,119960,119,120012,119,120064,119,120116,119,120168,119,120220,119,120272,119,120324,119,120376,119,120428,119,120480,119,7457,119,1121,119,1309,119,1377,119,71434,119,71438,119,71439,119,43907,119,71919,87,71910,87,119830,87,119882,87,119934,87,119986,87,120038,87,120090,87,120142,87,120194,87,120246,87,120298,87,120350,87,120402,87,120454,87,1308,87,5043,87,5076,87,42218,87,5742,120,10539,120,10540,120,10799,120,65368,120,8569,120,119857,120,119909,120,119961,120,120013,120,120065,120,120117,120,120169,120,120221,120,120273,120,120325,120,120377,120,120429,120,120481,120,5441,120,5501,120,5741,88,9587,88,66338,88,71916,88,65336,88,8553,88,119831,88,119883,88,119935,88,119987,88,120039,88,120091,88,120143,88,120195,88,120247,88,120299,88,120351,88,120403,88,120455,88,42931,88,935,88,120510,88,120568,88,120626,88,120684,88,120742,88,11436,88,11613,88,5815,88,42219,88,66192,88,66228,88,66327,88,66855,88,611,121,7564,121,65369,121,119858,121,119910,121,119962,121,120014,121,120066,121,120118,121,120170,121,120222,121,120274,121,120326,121,120378,121,120430,121,120482,121,655,121,7935,121,43866,121,947,121,8509,121,120516,121,120574,121,120632,121,120690,121,120748,121,1199,121,4327,121,71900,121,65337,89,119832,89,119884,89,119936,89,119988,89,120040,89,120092,89,120144,89,120196,89,120248,89,120300,89,120352,89,120404,89,120456,89,933,89,978,89,120508,89,120566,89,120624,89,120682,89,120740,89,11432,89,1198,89,5033,89,5053,89,42220,89,94019,89,71844,89,66226,89,119859,122,119911,122,119963,122,120015,122,120067,122,120119,122,120171,122,120223,122,120275,122,120327,122,120379,122,120431,122,120483,122,7458,122,43923,122,71876,122,66293,90,71909,90,65338,90,8484,90,8488,90,119833,90,119885,90,119937,90,119989,90,120041,90,120197,90,120249,90,120301,90,120353,90,120405,90,120457,90,918,90,120493,90,120551,90,120609,90,120667,90,120725,90,5059,90,42204,90,71849,90,65282,34,65284,36,65285,37,65286,38,65290,42,65291,43,65294,46,65295,47,65296,48,65297,49,65298,50,65299,51,65300,52,65301,53,65302,54,65303,55,65304,56,65305,57,65308,60,65309,61,65310,62,65312,64,65316,68,65318,70,65319,71,65324,76,65329,81,65330,82,65333,85,65334,86,65335,87,65343,95,65346,98,65348,100,65350,102,65355,107,65357,109,65358,110,65361,113,65362,114,65364,116,65365,117,65367,119,65370,122,65371,123,65373,125],"_default":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"cs":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"de":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"es":[8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"fr":[65374,126,65306,58,65281,33,8216,96,8245,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"it":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"ja":[8211,45,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65292,44,65307,59],"ko":[8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"pl":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"pt-BR":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"qps-ploc":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"ru":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,305,105,921,73,1009,112,215,120,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"tr":[160,32,8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"zh-hans":[65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41],"zh-hant":[8211,45,65374,126,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65307,59]}');
  });
  AmbiguousCharacters.cache = new LRUCachedComputed((locales) => {
    function arrayToMap(arr) {
      const result = new Map();
      for (let i = 0; i < arr.length; i += 2) {
        result.set(arr[i], arr[i + 1]);
      }
      return result;
    }
    function mergeMaps(map1, map2) {
      const result = new Map(map1);
      for (const [key, value] of map2) {
        result.set(key, value);
      }
      return result;
    }
    function intersectMaps(map1, map2) {
      if (!map1) {
        return map2;
      }
      const result = new Map();
      for (const [key, value] of map1) {
        if (map2.has(key)) {
          result.set(key, value);
        }
      }
      return result;
    }
    const data = _a2.ambiguousCharacterData.getValue();
    let filteredLocales = locales.filter((l) => !l.startsWith("_") && l in data);
    if (filteredLocales.length === 0) {
      filteredLocales = ["_default"];
    }
    let languageSpecificMap = void 0;
    for (const locale of filteredLocales) {
      const map2 = arrayToMap(data[locale]);
      languageSpecificMap = intersectMaps(languageSpecificMap, map2);
    }
    const commonMap = arrayToMap(data["_common"]);
    const map = mergeMaps(commonMap, languageSpecificMap);
    return new AmbiguousCharacters(map);
  });
  AmbiguousCharacters._locales = new Lazy(() => Object.keys(AmbiguousCharacters.ambiguousCharacterData.getValue()).filter((k) => !k.startsWith("_")));
  var InvisibleCharacters = class {
    static getRawData() {
      return JSON.parse("[9,10,11,12,13,32,127,160,173,847,1564,4447,4448,6068,6069,6155,6156,6157,6158,7355,7356,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8203,8204,8205,8206,8207,8234,8235,8236,8237,8238,8239,8287,8288,8289,8290,8291,8292,8293,8294,8295,8296,8297,8298,8299,8300,8301,8302,8303,10240,12288,12644,65024,65025,65026,65027,65028,65029,65030,65031,65032,65033,65034,65035,65036,65037,65038,65039,65279,65440,65520,65521,65522,65523,65524,65525,65526,65527,65528,65532,78844,119155,119156,119157,119158,119159,119160,119161,119162,917504,917505,917506,917507,917508,917509,917510,917511,917512,917513,917514,917515,917516,917517,917518,917519,917520,917521,917522,917523,917524,917525,917526,917527,917528,917529,917530,917531,917532,917533,917534,917535,917536,917537,917538,917539,917540,917541,917542,917543,917544,917545,917546,917547,917548,917549,917550,917551,917552,917553,917554,917555,917556,917557,917558,917559,917560,917561,917562,917563,917564,917565,917566,917567,917568,917569,917570,917571,917572,917573,917574,917575,917576,917577,917578,917579,917580,917581,917582,917583,917584,917585,917586,917587,917588,917589,917590,917591,917592,917593,917594,917595,917596,917597,917598,917599,917600,917601,917602,917603,917604,917605,917606,917607,917608,917609,917610,917611,917612,917613,917614,917615,917616,917617,917618,917619,917620,917621,917622,917623,917624,917625,917626,917627,917628,917629,917630,917631,917760,917761,917762,917763,917764,917765,917766,917767,917768,917769,917770,917771,917772,917773,917774,917775,917776,917777,917778,917779,917780,917781,917782,917783,917784,917785,917786,917787,917788,917789,917790,917791,917792,917793,917794,917795,917796,917797,917798,917799,917800,917801,917802,917803,917804,917805,917806,917807,917808,917809,917810,917811,917812,917813,917814,917815,917816,917817,917818,917819,917820,917821,917822,917823,917824,917825,917826,917827,917828,917829,917830,917831,917832,917833,917834,917835,917836,917837,917838,917839,917840,917841,917842,917843,917844,917845,917846,917847,917848,917849,917850,917851,917852,917853,917854,917855,917856,917857,917858,917859,917860,917861,917862,917863,917864,917865,917866,917867,917868,917869,917870,917871,917872,917873,917874,917875,917876,917877,917878,917879,917880,917881,917882,917883,917884,917885,917886,917887,917888,917889,917890,917891,917892,917893,917894,917895,917896,917897,917898,917899,917900,917901,917902,917903,917904,917905,917906,917907,917908,917909,917910,917911,917912,917913,917914,917915,917916,917917,917918,917919,917920,917921,917922,917923,917924,917925,917926,917927,917928,917929,917930,917931,917932,917933,917934,917935,917936,917937,917938,917939,917940,917941,917942,917943,917944,917945,917946,917947,917948,917949,917950,917951,917952,917953,917954,917955,917956,917957,917958,917959,917960,917961,917962,917963,917964,917965,917966,917967,917968,917969,917970,917971,917972,917973,917974,917975,917976,917977,917978,917979,917980,917981,917982,917983,917984,917985,917986,917987,917988,917989,917990,917991,917992,917993,917994,917995,917996,917997,917998,917999]");
    }
    static getData() {
      if (!this._data) {
        this._data = new Set(InvisibleCharacters.getRawData());
      }
      return this._data;
    }
    static isInvisibleCharacter(codePoint) {
      return InvisibleCharacters.getData().has(codePoint);
    }
    static get codePoints() {
      return InvisibleCharacters.getData();
    }
  };
  InvisibleCharacters._data = void 0;

  // node_modules/monaco-editor/esm/vs/base/common/worker/simpleWorker.js
  var INITIALIZE = "$initialize";
  var RequestMessage = class {
    constructor(vsWorker, req, method, args) {
      this.vsWorker = vsWorker;
      this.req = req;
      this.method = method;
      this.args = args;
      this.type = 0;
    }
  };
  var ReplyMessage = class {
    constructor(vsWorker, seq, res, err) {
      this.vsWorker = vsWorker;
      this.seq = seq;
      this.res = res;
      this.err = err;
      this.type = 1;
    }
  };
  var SubscribeEventMessage = class {
    constructor(vsWorker, req, eventName, arg) {
      this.vsWorker = vsWorker;
      this.req = req;
      this.eventName = eventName;
      this.arg = arg;
      this.type = 2;
    }
  };
  var EventMessage = class {
    constructor(vsWorker, req, event) {
      this.vsWorker = vsWorker;
      this.req = req;
      this.event = event;
      this.type = 3;
    }
  };
  var UnsubscribeEventMessage = class {
    constructor(vsWorker, req) {
      this.vsWorker = vsWorker;
      this.req = req;
      this.type = 4;
    }
  };
  var SimpleWorkerProtocol = class {
    constructor(handler) {
      this._workerId = -1;
      this._handler = handler;
      this._lastSentReq = 0;
      this._pendingReplies = Object.create(null);
      this._pendingEmitters = new Map();
      this._pendingEvents = new Map();
    }
    setWorkerId(workerId) {
      this._workerId = workerId;
    }
    sendMessage(method, args) {
      const req = String(++this._lastSentReq);
      return new Promise((resolve2, reject) => {
        this._pendingReplies[req] = {
          resolve: resolve2,
          reject
        };
        this._send(new RequestMessage(this._workerId, req, method, args));
      });
    }
    listen(eventName, arg) {
      let req = null;
      const emitter = new Emitter({
        onFirstListenerAdd: () => {
          req = String(++this._lastSentReq);
          this._pendingEmitters.set(req, emitter);
          this._send(new SubscribeEventMessage(this._workerId, req, eventName, arg));
        },
        onLastListenerRemove: () => {
          this._pendingEmitters.delete(req);
          this._send(new UnsubscribeEventMessage(this._workerId, req));
          req = null;
        }
      });
      return emitter.event;
    }
    handleMessage(message) {
      if (!message || !message.vsWorker) {
        return;
      }
      if (this._workerId !== -1 && message.vsWorker !== this._workerId) {
        return;
      }
      this._handleMessage(message);
    }
    _handleMessage(msg) {
      switch (msg.type) {
        case 1:
          return this._handleReplyMessage(msg);
        case 0:
          return this._handleRequestMessage(msg);
        case 2:
          return this._handleSubscribeEventMessage(msg);
        case 3:
          return this._handleEventMessage(msg);
        case 4:
          return this._handleUnsubscribeEventMessage(msg);
      }
    }
    _handleReplyMessage(replyMessage) {
      if (!this._pendingReplies[replyMessage.seq]) {
        console.warn("Got reply to unknown seq");
        return;
      }
      let reply = this._pendingReplies[replyMessage.seq];
      delete this._pendingReplies[replyMessage.seq];
      if (replyMessage.err) {
        let err = replyMessage.err;
        if (replyMessage.err.$isError) {
          err = new Error();
          err.name = replyMessage.err.name;
          err.message = replyMessage.err.message;
          err.stack = replyMessage.err.stack;
        }
        reply.reject(err);
        return;
      }
      reply.resolve(replyMessage.res);
    }
    _handleRequestMessage(requestMessage) {
      let req = requestMessage.req;
      let result = this._handler.handleMessage(requestMessage.method, requestMessage.args);
      result.then((r) => {
        this._send(new ReplyMessage(this._workerId, req, r, void 0));
      }, (e) => {
        if (e.detail instanceof Error) {
          e.detail = transformErrorForSerialization(e.detail);
        }
        this._send(new ReplyMessage(this._workerId, req, void 0, transformErrorForSerialization(e)));
      });
    }
    _handleSubscribeEventMessage(msg) {
      const req = msg.req;
      const disposable = this._handler.handleEvent(msg.eventName, msg.arg)((event) => {
        this._send(new EventMessage(this._workerId, req, event));
      });
      this._pendingEvents.set(req, disposable);
    }
    _handleEventMessage(msg) {
      if (!this._pendingEmitters.has(msg.req)) {
        console.warn("Got event for unknown req");
        return;
      }
      this._pendingEmitters.get(msg.req).fire(msg.event);
    }
    _handleUnsubscribeEventMessage(msg) {
      if (!this._pendingEvents.has(msg.req)) {
        console.warn("Got unsubscribe for unknown req");
        return;
      }
      this._pendingEvents.get(msg.req).dispose();
      this._pendingEvents.delete(msg.req);
    }
    _send(msg) {
      let transfer = [];
      if (msg.type === 0) {
        for (let i = 0; i < msg.args.length; i++) {
          if (msg.args[i] instanceof ArrayBuffer) {
            transfer.push(msg.args[i]);
          }
        }
      } else if (msg.type === 1) {
        if (msg.res instanceof ArrayBuffer) {
          transfer.push(msg.res);
        }
      }
      this._handler.sendMessage(msg, transfer);
    }
  };
  function propertyIsEvent(name) {
    return name[0] === "o" && name[1] === "n" && isUpperAsciiLetter(name.charCodeAt(2));
  }
  function propertyIsDynamicEvent(name) {
    return /^onDynamic/.test(name) && isUpperAsciiLetter(name.charCodeAt(9));
  }
  function createProxyObject2(methodNames, invoke, proxyListen) {
    const createProxyMethod = (method) => {
      return function() {
        const args = Array.prototype.slice.call(arguments, 0);
        return invoke(method, args);
      };
    };
    const createProxyDynamicEvent = (eventName) => {
      return function(arg) {
        return proxyListen(eventName, arg);
      };
    };
    let result = {};
    for (const methodName of methodNames) {
      if (propertyIsDynamicEvent(methodName)) {
        result[methodName] = createProxyDynamicEvent(methodName);
        continue;
      }
      if (propertyIsEvent(methodName)) {
        result[methodName] = proxyListen(methodName, void 0);
        continue;
      }
      result[methodName] = createProxyMethod(methodName);
    }
    return result;
  }
  var SimpleWorkerServer = class {
    constructor(postMessage, requestHandlerFactory) {
      this._requestHandlerFactory = requestHandlerFactory;
      this._requestHandler = null;
      this._protocol = new SimpleWorkerProtocol({
        sendMessage: (msg, transfer) => {
          postMessage(msg, transfer);
        },
        handleMessage: (method, args) => this._handleMessage(method, args),
        handleEvent: (eventName, arg) => this._handleEvent(eventName, arg)
      });
    }
    onmessage(msg) {
      this._protocol.handleMessage(msg);
    }
    _handleMessage(method, args) {
      if (method === INITIALIZE) {
        return this.initialize(args[0], args[1], args[2], args[3]);
      }
      if (!this._requestHandler || typeof this._requestHandler[method] !== "function") {
        return Promise.reject(new Error("Missing requestHandler or method: " + method));
      }
      try {
        return Promise.resolve(this._requestHandler[method].apply(this._requestHandler, args));
      } catch (e) {
        return Promise.reject(e);
      }
    }
    _handleEvent(eventName, arg) {
      if (!this._requestHandler) {
        throw new Error(`Missing requestHandler`);
      }
      if (propertyIsDynamicEvent(eventName)) {
        const event = this._requestHandler[eventName].call(this._requestHandler, arg);
        if (typeof event !== "function") {
          throw new Error(`Missing dynamic event ${eventName} on request handler.`);
        }
        return event;
      }
      if (propertyIsEvent(eventName)) {
        const event = this._requestHandler[eventName];
        if (typeof event !== "function") {
          throw new Error(`Missing event ${eventName} on request handler.`);
        }
        return event;
      }
      throw new Error(`Malformed event name ${eventName}`);
    }
    initialize(workerId, loaderConfig, moduleId, hostMethods) {
      this._protocol.setWorkerId(workerId);
      const proxyMethodRequest = (method, args) => {
        return this._protocol.sendMessage(method, args);
      };
      const proxyListen = (eventName, arg) => {
        return this._protocol.listen(eventName, arg);
      };
      const hostProxy = createProxyObject2(hostMethods, proxyMethodRequest, proxyListen);
      if (this._requestHandlerFactory) {
        this._requestHandler = this._requestHandlerFactory(hostProxy);
        return Promise.resolve(getAllMethodNames(this._requestHandler));
      }
      if (loaderConfig) {
        if (typeof loaderConfig.baseUrl !== "undefined") {
          delete loaderConfig["baseUrl"];
        }
        if (typeof loaderConfig.paths !== "undefined") {
          if (typeof loaderConfig.paths.vs !== "undefined") {
            delete loaderConfig.paths["vs"];
          }
        }
        if (typeof loaderConfig.trustedTypesPolicy !== void 0) {
          delete loaderConfig["trustedTypesPolicy"];
        }
        loaderConfig.catchError = true;
        globals.require.config(loaderConfig);
      }
      return new Promise((resolve2, reject) => {
        const req = globals.require;
        req([moduleId], (module2) => {
          this._requestHandler = module2.create(hostProxy);
          if (!this._requestHandler) {
            reject(new Error(`No RequestHandler!`));
            return;
          }
          resolve2(getAllMethodNames(this._requestHandler));
        }, reject);
      });
    }
  };

  // node_modules/monaco-editor/esm/vs/base/common/diff/diffChange.js
  var DiffChange = class {
    constructor(originalStart, originalLength, modifiedStart, modifiedLength) {
      this.originalStart = originalStart;
      this.originalLength = originalLength;
      this.modifiedStart = modifiedStart;
      this.modifiedLength = modifiedLength;
    }
    getOriginalEnd() {
      return this.originalStart + this.originalLength;
    }
    getModifiedEnd() {
      return this.modifiedStart + this.modifiedLength;
    }
  };

  // node_modules/monaco-editor/esm/vs/base/common/hash.js
  function numberHash(val, initialHashVal) {
    return (initialHashVal << 5) - initialHashVal + val | 0;
  }
  function stringHash(s, hashVal) {
    hashVal = numberHash(149417, hashVal);
    for (let i = 0, length = s.length; i < length; i++) {
      hashVal = numberHash(s.charCodeAt(i), hashVal);
    }
    return hashVal;
  }
  function leftRotate(value, bits, totalBits = 32) {
    const delta = totalBits - bits;
    const mask = ~((1 << delta) - 1);
    return (value << bits | (mask & value) >>> delta) >>> 0;
  }
  function fill(dest, index = 0, count = dest.byteLength, value = 0) {
    for (let i = 0; i < count; i++) {
      dest[index + i] = value;
    }
  }
  function leftPad(value, length, char = "0") {
    while (value.length < length) {
      value = char + value;
    }
    return value;
  }
  function toHexString(bufferOrValue, bitsize = 32) {
    if (bufferOrValue instanceof ArrayBuffer) {
      return Array.from(new Uint8Array(bufferOrValue)).map((b) => b.toString(16).padStart(2, "0")).join("");
    }
    return leftPad((bufferOrValue >>> 0).toString(16), bitsize / 4);
  }
  var StringSHA1 = class {
    constructor() {
      this._h0 = 1732584193;
      this._h1 = 4023233417;
      this._h2 = 2562383102;
      this._h3 = 271733878;
      this._h4 = 3285377520;
      this._buff = new Uint8Array(64 + 3);
      this._buffDV = new DataView(this._buff.buffer);
      this._buffLen = 0;
      this._totalLen = 0;
      this._leftoverHighSurrogate = 0;
      this._finished = false;
    }
    update(str) {
      const strLen = str.length;
      if (strLen === 0) {
        return;
      }
      const buff = this._buff;
      let buffLen = this._buffLen;
      let leftoverHighSurrogate = this._leftoverHighSurrogate;
      let charCode;
      let offset;
      if (leftoverHighSurrogate !== 0) {
        charCode = leftoverHighSurrogate;
        offset = -1;
        leftoverHighSurrogate = 0;
      } else {
        charCode = str.charCodeAt(0);
        offset = 0;
      }
      while (true) {
        let codePoint = charCode;
        if (isHighSurrogate(charCode)) {
          if (offset + 1 < strLen) {
            const nextCharCode = str.charCodeAt(offset + 1);
            if (isLowSurrogate(nextCharCode)) {
              offset++;
              codePoint = computeCodePoint(charCode, nextCharCode);
            } else {
              codePoint = 65533;
            }
          } else {
            leftoverHighSurrogate = charCode;
            break;
          }
        } else if (isLowSurrogate(charCode)) {
          codePoint = 65533;
        }
        buffLen = this._push(buff, buffLen, codePoint);
        offset++;
        if (offset < strLen) {
          charCode = str.charCodeAt(offset);
        } else {
          break;
        }
      }
      this._buffLen = buffLen;
      this._leftoverHighSurrogate = leftoverHighSurrogate;
    }
    _push(buff, buffLen, codePoint) {
      if (codePoint < 128) {
        buff[buffLen++] = codePoint;
      } else if (codePoint < 2048) {
        buff[buffLen++] = 192 | (codePoint & 1984) >>> 6;
        buff[buffLen++] = 128 | (codePoint & 63) >>> 0;
      } else if (codePoint < 65536) {
        buff[buffLen++] = 224 | (codePoint & 61440) >>> 12;
        buff[buffLen++] = 128 | (codePoint & 4032) >>> 6;
        buff[buffLen++] = 128 | (codePoint & 63) >>> 0;
      } else {
        buff[buffLen++] = 240 | (codePoint & 1835008) >>> 18;
        buff[buffLen++] = 128 | (codePoint & 258048) >>> 12;
        buff[buffLen++] = 128 | (codePoint & 4032) >>> 6;
        buff[buffLen++] = 128 | (codePoint & 63) >>> 0;
      }
      if (buffLen >= 64) {
        this._step();
        buffLen -= 64;
        this._totalLen += 64;
        buff[0] = buff[64 + 0];
        buff[1] = buff[64 + 1];
        buff[2] = buff[64 + 2];
      }
      return buffLen;
    }
    digest() {
      if (!this._finished) {
        this._finished = true;
        if (this._leftoverHighSurrogate) {
          this._leftoverHighSurrogate = 0;
          this._buffLen = this._push(this._buff, this._buffLen, 65533);
        }
        this._totalLen += this._buffLen;
        this._wrapUp();
      }
      return toHexString(this._h0) + toHexString(this._h1) + toHexString(this._h2) + toHexString(this._h3) + toHexString(this._h4);
    }
    _wrapUp() {
      this._buff[this._buffLen++] = 128;
      fill(this._buff, this._buffLen);
      if (this._buffLen > 56) {
        this._step();
        fill(this._buff);
      }
      const ml = 8 * this._totalLen;
      this._buffDV.setUint32(56, Math.floor(ml / 4294967296), false);
      this._buffDV.setUint32(60, ml % 4294967296, false);
      this._step();
    }
    _step() {
      const bigBlock32 = StringSHA1._bigBlock32;
      const data = this._buffDV;
      for (let j = 0; j < 64; j += 4) {
        bigBlock32.setUint32(j, data.getUint32(j, false), false);
      }
      for (let j = 64; j < 320; j += 4) {
        bigBlock32.setUint32(j, leftRotate(bigBlock32.getUint32(j - 12, false) ^ bigBlock32.getUint32(j - 32, false) ^ bigBlock32.getUint32(j - 56, false) ^ bigBlock32.getUint32(j - 64, false), 1), false);
      }
      let a = this._h0;
      let b = this._h1;
      let c = this._h2;
      let d = this._h3;
      let e = this._h4;
      let f, k;
      let temp;
      for (let j = 0; j < 80; j++) {
        if (j < 20) {
          f = b & c | ~b & d;
          k = 1518500249;
        } else if (j < 40) {
          f = b ^ c ^ d;
          k = 1859775393;
        } else if (j < 60) {
          f = b & c | b & d | c & d;
          k = 2400959708;
        } else {
          f = b ^ c ^ d;
          k = 3395469782;
        }
        temp = leftRotate(a, 5) + f + e + k + bigBlock32.getUint32(j * 4, false) & 4294967295;
        e = d;
        d = c;
        c = leftRotate(b, 30);
        b = a;
        a = temp;
      }
      this._h0 = this._h0 + a & 4294967295;
      this._h1 = this._h1 + b & 4294967295;
      this._h2 = this._h2 + c & 4294967295;
      this._h3 = this._h3 + d & 4294967295;
      this._h4 = this._h4 + e & 4294967295;
    }
  };
  StringSHA1._bigBlock32 = new DataView(new ArrayBuffer(320));

  // node_modules/monaco-editor/esm/vs/base/common/diff/diff.js
  var StringDiffSequence = class {
    constructor(source) {
      this.source = source;
    }
    getElements() {
      const source = this.source;
      const characters = new Int32Array(source.length);
      for (let i = 0, len = source.length; i < len; i++) {
        characters[i] = source.charCodeAt(i);
      }
      return characters;
    }
  };
  function stringDiff(original, modified, pretty) {
    return new LcsDiff(new StringDiffSequence(original), new StringDiffSequence(modified)).ComputeDiff(pretty).changes;
  }
  var Debug = class {
    static Assert(condition, message) {
      if (!condition) {
        throw new Error(message);
      }
    }
  };
  var MyArray = class {
    static Copy(sourceArray, sourceIndex, destinationArray, destinationIndex, length) {
      for (let i = 0; i < length; i++) {
        destinationArray[destinationIndex + i] = sourceArray[sourceIndex + i];
      }
    }
    static Copy2(sourceArray, sourceIndex, destinationArray, destinationIndex, length) {
      for (let i = 0; i < length; i++) {
        destinationArray[destinationIndex + i] = sourceArray[sourceIndex + i];
      }
    }
  };
  var DiffChangeHelper = class {
    constructor() {
      this.m_changes = [];
      this.m_originalStart = 1073741824;
      this.m_modifiedStart = 1073741824;
      this.m_originalCount = 0;
      this.m_modifiedCount = 0;
    }
    MarkNextChange() {
      if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
        this.m_changes.push(new DiffChange(this.m_originalStart, this.m_originalCount, this.m_modifiedStart, this.m_modifiedCount));
      }
      this.m_originalCount = 0;
      this.m_modifiedCount = 0;
      this.m_originalStart = 1073741824;
      this.m_modifiedStart = 1073741824;
    }
    AddOriginalElement(originalIndex, modifiedIndex) {
      this.m_originalStart = Math.min(this.m_originalStart, originalIndex);
      this.m_modifiedStart = Math.min(this.m_modifiedStart, modifiedIndex);
      this.m_originalCount++;
    }
    AddModifiedElement(originalIndex, modifiedIndex) {
      this.m_originalStart = Math.min(this.m_originalStart, originalIndex);
      this.m_modifiedStart = Math.min(this.m_modifiedStart, modifiedIndex);
      this.m_modifiedCount++;
    }
    getChanges() {
      if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
        this.MarkNextChange();
      }
      return this.m_changes;
    }
    getReverseChanges() {
      if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
        this.MarkNextChange();
      }
      this.m_changes.reverse();
      return this.m_changes;
    }
  };
  var LcsDiff = class {
    constructor(originalSequence, modifiedSequence, continueProcessingPredicate = null) {
      this.ContinueProcessingPredicate = continueProcessingPredicate;
      this._originalSequence = originalSequence;
      this._modifiedSequence = modifiedSequence;
      const [originalStringElements, originalElementsOrHash, originalHasStrings] = LcsDiff._getElements(originalSequence);
      const [modifiedStringElements, modifiedElementsOrHash, modifiedHasStrings] = LcsDiff._getElements(modifiedSequence);
      this._hasStrings = originalHasStrings && modifiedHasStrings;
      this._originalStringElements = originalStringElements;
      this._originalElementsOrHash = originalElementsOrHash;
      this._modifiedStringElements = modifiedStringElements;
      this._modifiedElementsOrHash = modifiedElementsOrHash;
      this.m_forwardHistory = [];
      this.m_reverseHistory = [];
    }
    static _isStringArray(arr) {
      return arr.length > 0 && typeof arr[0] === "string";
    }
    static _getElements(sequence) {
      const elements = sequence.getElements();
      if (LcsDiff._isStringArray(elements)) {
        const hashes = new Int32Array(elements.length);
        for (let i = 0, len = elements.length; i < len; i++) {
          hashes[i] = stringHash(elements[i], 0);
        }
        return [elements, hashes, true];
      }
      if (elements instanceof Int32Array) {
        return [[], elements, false];
      }
      return [[], new Int32Array(elements), false];
    }
    ElementsAreEqual(originalIndex, newIndex) {
      if (this._originalElementsOrHash[originalIndex] !== this._modifiedElementsOrHash[newIndex]) {
        return false;
      }
      return this._hasStrings ? this._originalStringElements[originalIndex] === this._modifiedStringElements[newIndex] : true;
    }
    ElementsAreStrictEqual(originalIndex, newIndex) {
      if (!this.ElementsAreEqual(originalIndex, newIndex)) {
        return false;
      }
      const originalElement = LcsDiff._getStrictElement(this._originalSequence, originalIndex);
      const modifiedElement = LcsDiff._getStrictElement(this._modifiedSequence, newIndex);
      return originalElement === modifiedElement;
    }
    static _getStrictElement(sequence, index) {
      if (typeof sequence.getStrictElement === "function") {
        return sequence.getStrictElement(index);
      }
      return null;
    }
    OriginalElementsAreEqual(index1, index2) {
      if (this._originalElementsOrHash[index1] !== this._originalElementsOrHash[index2]) {
        return false;
      }
      return this._hasStrings ? this._originalStringElements[index1] === this._originalStringElements[index2] : true;
    }
    ModifiedElementsAreEqual(index1, index2) {
      if (this._modifiedElementsOrHash[index1] !== this._modifiedElementsOrHash[index2]) {
        return false;
      }
      return this._hasStrings ? this._modifiedStringElements[index1] === this._modifiedStringElements[index2] : true;
    }
    ComputeDiff(pretty) {
      return this._ComputeDiff(0, this._originalElementsOrHash.length - 1, 0, this._modifiedElementsOrHash.length - 1, pretty);
    }
    _ComputeDiff(originalStart, originalEnd, modifiedStart, modifiedEnd, pretty) {
      const quitEarlyArr = [false];
      let changes = this.ComputeDiffRecursive(originalStart, originalEnd, modifiedStart, modifiedEnd, quitEarlyArr);
      if (pretty) {
        changes = this.PrettifyChanges(changes);
      }
      return {
        quitEarly: quitEarlyArr[0],
        changes
      };
    }
    ComputeDiffRecursive(originalStart, originalEnd, modifiedStart, modifiedEnd, quitEarlyArr) {
      quitEarlyArr[0] = false;
      while (originalStart <= originalEnd && modifiedStart <= modifiedEnd && this.ElementsAreEqual(originalStart, modifiedStart)) {
        originalStart++;
        modifiedStart++;
      }
      while (originalEnd >= originalStart && modifiedEnd >= modifiedStart && this.ElementsAreEqual(originalEnd, modifiedEnd)) {
        originalEnd--;
        modifiedEnd--;
      }
      if (originalStart > originalEnd || modifiedStart > modifiedEnd) {
        let changes;
        if (modifiedStart <= modifiedEnd) {
          Debug.Assert(originalStart === originalEnd + 1, "originalStart should only be one more than originalEnd");
          changes = [
            new DiffChange(originalStart, 0, modifiedStart, modifiedEnd - modifiedStart + 1)
          ];
        } else if (originalStart <= originalEnd) {
          Debug.Assert(modifiedStart === modifiedEnd + 1, "modifiedStart should only be one more than modifiedEnd");
          changes = [
            new DiffChange(originalStart, originalEnd - originalStart + 1, modifiedStart, 0)
          ];
        } else {
          Debug.Assert(originalStart === originalEnd + 1, "originalStart should only be one more than originalEnd");
          Debug.Assert(modifiedStart === modifiedEnd + 1, "modifiedStart should only be one more than modifiedEnd");
          changes = [];
        }
        return changes;
      }
      const midOriginalArr = [0];
      const midModifiedArr = [0];
      const result = this.ComputeRecursionPoint(originalStart, originalEnd, modifiedStart, modifiedEnd, midOriginalArr, midModifiedArr, quitEarlyArr);
      const midOriginal = midOriginalArr[0];
      const midModified = midModifiedArr[0];
      if (result !== null) {
        return result;
      } else if (!quitEarlyArr[0]) {
        const leftChanges = this.ComputeDiffRecursive(originalStart, midOriginal, modifiedStart, midModified, quitEarlyArr);
        let rightChanges = [];
        if (!quitEarlyArr[0]) {
          rightChanges = this.ComputeDiffRecursive(midOriginal + 1, originalEnd, midModified + 1, modifiedEnd, quitEarlyArr);
        } else {
          rightChanges = [
            new DiffChange(midOriginal + 1, originalEnd - (midOriginal + 1) + 1, midModified + 1, modifiedEnd - (midModified + 1) + 1)
          ];
        }
        return this.ConcatenateChanges(leftChanges, rightChanges);
      }
      return [
        new DiffChange(originalStart, originalEnd - originalStart + 1, modifiedStart, modifiedEnd - modifiedStart + 1)
      ];
    }
    WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr) {
      let forwardChanges = null;
      let reverseChanges = null;
      let changeHelper = new DiffChangeHelper();
      let diagonalMin = diagonalForwardStart;
      let diagonalMax = diagonalForwardEnd;
      let diagonalRelative = midOriginalArr[0] - midModifiedArr[0] - diagonalForwardOffset;
      let lastOriginalIndex = -1073741824;
      let historyIndex = this.m_forwardHistory.length - 1;
      do {
        const diagonal = diagonalRelative + diagonalForwardBase;
        if (diagonal === diagonalMin || diagonal < diagonalMax && forwardPoints[diagonal - 1] < forwardPoints[diagonal + 1]) {
          originalIndex = forwardPoints[diagonal + 1];
          modifiedIndex = originalIndex - diagonalRelative - diagonalForwardOffset;
          if (originalIndex < lastOriginalIndex) {
            changeHelper.MarkNextChange();
          }
          lastOriginalIndex = originalIndex;
          changeHelper.AddModifiedElement(originalIndex + 1, modifiedIndex);
          diagonalRelative = diagonal + 1 - diagonalForwardBase;
        } else {
          originalIndex = forwardPoints[diagonal - 1] + 1;
          modifiedIndex = originalIndex - diagonalRelative - diagonalForwardOffset;
          if (originalIndex < lastOriginalIndex) {
            changeHelper.MarkNextChange();
          }
          lastOriginalIndex = originalIndex - 1;
          changeHelper.AddOriginalElement(originalIndex, modifiedIndex + 1);
          diagonalRelative = diagonal - 1 - diagonalForwardBase;
        }
        if (historyIndex >= 0) {
          forwardPoints = this.m_forwardHistory[historyIndex];
          diagonalForwardBase = forwardPoints[0];
          diagonalMin = 1;
          diagonalMax = forwardPoints.length - 1;
        }
      } while (--historyIndex >= -1);
      forwardChanges = changeHelper.getReverseChanges();
      if (quitEarlyArr[0]) {
        let originalStartPoint = midOriginalArr[0] + 1;
        let modifiedStartPoint = midModifiedArr[0] + 1;
        if (forwardChanges !== null && forwardChanges.length > 0) {
          const lastForwardChange = forwardChanges[forwardChanges.length - 1];
          originalStartPoint = Math.max(originalStartPoint, lastForwardChange.getOriginalEnd());
          modifiedStartPoint = Math.max(modifiedStartPoint, lastForwardChange.getModifiedEnd());
        }
        reverseChanges = [
          new DiffChange(originalStartPoint, originalEnd - originalStartPoint + 1, modifiedStartPoint, modifiedEnd - modifiedStartPoint + 1)
        ];
      } else {
        changeHelper = new DiffChangeHelper();
        diagonalMin = diagonalReverseStart;
        diagonalMax = diagonalReverseEnd;
        diagonalRelative = midOriginalArr[0] - midModifiedArr[0] - diagonalReverseOffset;
        lastOriginalIndex = 1073741824;
        historyIndex = deltaIsEven ? this.m_reverseHistory.length - 1 : this.m_reverseHistory.length - 2;
        do {
          const diagonal = diagonalRelative + diagonalReverseBase;
          if (diagonal === diagonalMin || diagonal < diagonalMax && reversePoints[diagonal - 1] >= reversePoints[diagonal + 1]) {
            originalIndex = reversePoints[diagonal + 1] - 1;
            modifiedIndex = originalIndex - diagonalRelative - diagonalReverseOffset;
            if (originalIndex > lastOriginalIndex) {
              changeHelper.MarkNextChange();
            }
            lastOriginalIndex = originalIndex + 1;
            changeHelper.AddOriginalElement(originalIndex + 1, modifiedIndex + 1);
            diagonalRelative = diagonal + 1 - diagonalReverseBase;
          } else {
            originalIndex = reversePoints[diagonal - 1];
            modifiedIndex = originalIndex - diagonalRelative - diagonalReverseOffset;
            if (originalIndex > lastOriginalIndex) {
              changeHelper.MarkNextChange();
            }
            lastOriginalIndex = originalIndex;
            changeHelper.AddModifiedElement(originalIndex + 1, modifiedIndex + 1);
            diagonalRelative = diagonal - 1 - diagonalReverseBase;
          }
          if (historyIndex >= 0) {
            reversePoints = this.m_reverseHistory[historyIndex];
            diagonalReverseBase = reversePoints[0];
            diagonalMin = 1;
            diagonalMax = reversePoints.length - 1;
          }
        } while (--historyIndex >= -1);
        reverseChanges = changeHelper.getChanges();
      }
      return this.ConcatenateChanges(forwardChanges, reverseChanges);
    }
    ComputeRecursionPoint(originalStart, originalEnd, modifiedStart, modifiedEnd, midOriginalArr, midModifiedArr, quitEarlyArr) {
      let originalIndex = 0, modifiedIndex = 0;
      let diagonalForwardStart = 0, diagonalForwardEnd = 0;
      let diagonalReverseStart = 0, diagonalReverseEnd = 0;
      originalStart--;
      modifiedStart--;
      midOriginalArr[0] = 0;
      midModifiedArr[0] = 0;
      this.m_forwardHistory = [];
      this.m_reverseHistory = [];
      const maxDifferences = originalEnd - originalStart + (modifiedEnd - modifiedStart);
      const numDiagonals = maxDifferences + 1;
      const forwardPoints = new Int32Array(numDiagonals);
      const reversePoints = new Int32Array(numDiagonals);
      const diagonalForwardBase = modifiedEnd - modifiedStart;
      const diagonalReverseBase = originalEnd - originalStart;
      const diagonalForwardOffset = originalStart - modifiedStart;
      const diagonalReverseOffset = originalEnd - modifiedEnd;
      const delta = diagonalReverseBase - diagonalForwardBase;
      const deltaIsEven = delta % 2 === 0;
      forwardPoints[diagonalForwardBase] = originalStart;
      reversePoints[diagonalReverseBase] = originalEnd;
      quitEarlyArr[0] = false;
      for (let numDifferences = 1; numDifferences <= maxDifferences / 2 + 1; numDifferences++) {
        let furthestOriginalIndex = 0;
        let furthestModifiedIndex = 0;
        diagonalForwardStart = this.ClipDiagonalBound(diagonalForwardBase - numDifferences, numDifferences, diagonalForwardBase, numDiagonals);
        diagonalForwardEnd = this.ClipDiagonalBound(diagonalForwardBase + numDifferences, numDifferences, diagonalForwardBase, numDiagonals);
        for (let diagonal = diagonalForwardStart; diagonal <= diagonalForwardEnd; diagonal += 2) {
          if (diagonal === diagonalForwardStart || diagonal < diagonalForwardEnd && forwardPoints[diagonal - 1] < forwardPoints[diagonal + 1]) {
            originalIndex = forwardPoints[diagonal + 1];
          } else {
            originalIndex = forwardPoints[diagonal - 1] + 1;
          }
          modifiedIndex = originalIndex - (diagonal - diagonalForwardBase) - diagonalForwardOffset;
          const tempOriginalIndex = originalIndex;
          while (originalIndex < originalEnd && modifiedIndex < modifiedEnd && this.ElementsAreEqual(originalIndex + 1, modifiedIndex + 1)) {
            originalIndex++;
            modifiedIndex++;
          }
          forwardPoints[diagonal] = originalIndex;
          if (originalIndex + modifiedIndex > furthestOriginalIndex + furthestModifiedIndex) {
            furthestOriginalIndex = originalIndex;
            furthestModifiedIndex = modifiedIndex;
          }
          if (!deltaIsEven && Math.abs(diagonal - diagonalReverseBase) <= numDifferences - 1) {
            if (originalIndex >= reversePoints[diagonal]) {
              midOriginalArr[0] = originalIndex;
              midModifiedArr[0] = modifiedIndex;
              if (tempOriginalIndex <= reversePoints[diagonal] && 1447 > 0 && numDifferences <= 1447 + 1) {
                return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
              } else {
                return null;
              }
            }
          }
        }
        const matchLengthOfLongest = (furthestOriginalIndex - originalStart + (furthestModifiedIndex - modifiedStart) - numDifferences) / 2;
        if (this.ContinueProcessingPredicate !== null && !this.ContinueProcessingPredicate(furthestOriginalIndex, matchLengthOfLongest)) {
          quitEarlyArr[0] = true;
          midOriginalArr[0] = furthestOriginalIndex;
          midModifiedArr[0] = furthestModifiedIndex;
          if (matchLengthOfLongest > 0 && 1447 > 0 && numDifferences <= 1447 + 1) {
            return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
          } else {
            originalStart++;
            modifiedStart++;
            return [
              new DiffChange(originalStart, originalEnd - originalStart + 1, modifiedStart, modifiedEnd - modifiedStart + 1)
            ];
          }
        }
        diagonalReverseStart = this.ClipDiagonalBound(diagonalReverseBase - numDifferences, numDifferences, diagonalReverseBase, numDiagonals);
        diagonalReverseEnd = this.ClipDiagonalBound(diagonalReverseBase + numDifferences, numDifferences, diagonalReverseBase, numDiagonals);
        for (let diagonal = diagonalReverseStart; diagonal <= diagonalReverseEnd; diagonal += 2) {
          if (diagonal === diagonalReverseStart || diagonal < diagonalReverseEnd && reversePoints[diagonal - 1] >= reversePoints[diagonal + 1]) {
            originalIndex = reversePoints[diagonal + 1] - 1;
          } else {
            originalIndex = reversePoints[diagonal - 1];
          }
          modifiedIndex = originalIndex - (diagonal - diagonalReverseBase) - diagonalReverseOffset;
          const tempOriginalIndex = originalIndex;
          while (originalIndex > originalStart && modifiedIndex > modifiedStart && this.ElementsAreEqual(originalIndex, modifiedIndex)) {
            originalIndex--;
            modifiedIndex--;
          }
          reversePoints[diagonal] = originalIndex;
          if (deltaIsEven && Math.abs(diagonal - diagonalForwardBase) <= numDifferences) {
            if (originalIndex <= forwardPoints[diagonal]) {
              midOriginalArr[0] = originalIndex;
              midModifiedArr[0] = modifiedIndex;
              if (tempOriginalIndex >= forwardPoints[diagonal] && 1447 > 0 && numDifferences <= 1447 + 1) {
                return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
              } else {
                return null;
              }
            }
          }
        }
        if (numDifferences <= 1447) {
          let temp = new Int32Array(diagonalForwardEnd - diagonalForwardStart + 2);
          temp[0] = diagonalForwardBase - diagonalForwardStart + 1;
          MyArray.Copy2(forwardPoints, diagonalForwardStart, temp, 1, diagonalForwardEnd - diagonalForwardStart + 1);
          this.m_forwardHistory.push(temp);
          temp = new Int32Array(diagonalReverseEnd - diagonalReverseStart + 2);
          temp[0] = diagonalReverseBase - diagonalReverseStart + 1;
          MyArray.Copy2(reversePoints, diagonalReverseStart, temp, 1, diagonalReverseEnd - diagonalReverseStart + 1);
          this.m_reverseHistory.push(temp);
        }
      }
      return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
    }
    PrettifyChanges(changes) {
      for (let i = 0; i < changes.length; i++) {
        const change = changes[i];
        const originalStop = i < changes.length - 1 ? changes[i + 1].originalStart : this._originalElementsOrHash.length;
        const modifiedStop = i < changes.length - 1 ? changes[i + 1].modifiedStart : this._modifiedElementsOrHash.length;
        const checkOriginal = change.originalLength > 0;
        const checkModified = change.modifiedLength > 0;
        while (change.originalStart + change.originalLength < originalStop && change.modifiedStart + change.modifiedLength < modifiedStop && (!checkOriginal || this.OriginalElementsAreEqual(change.originalStart, change.originalStart + change.originalLength)) && (!checkModified || this.ModifiedElementsAreEqual(change.modifiedStart, change.modifiedStart + change.modifiedLength))) {
          const startStrictEqual = this.ElementsAreStrictEqual(change.originalStart, change.modifiedStart);
          const endStrictEqual = this.ElementsAreStrictEqual(change.originalStart + change.originalLength, change.modifiedStart + change.modifiedLength);
          if (endStrictEqual && !startStrictEqual) {
            break;
          }
          change.originalStart++;
          change.modifiedStart++;
        }
        let mergedChangeArr = [null];
        if (i < changes.length - 1 && this.ChangesOverlap(changes[i], changes[i + 1], mergedChangeArr)) {
          changes[i] = mergedChangeArr[0];
          changes.splice(i + 1, 1);
          i--;
          continue;
        }
      }
      for (let i = changes.length - 1; i >= 0; i--) {
        const change = changes[i];
        let originalStop = 0;
        let modifiedStop = 0;
        if (i > 0) {
          const prevChange = changes[i - 1];
          originalStop = prevChange.originalStart + prevChange.originalLength;
          modifiedStop = prevChange.modifiedStart + prevChange.modifiedLength;
        }
        const checkOriginal = change.originalLength > 0;
        const checkModified = change.modifiedLength > 0;
        let bestDelta = 0;
        let bestScore = this._boundaryScore(change.originalStart, change.originalLength, change.modifiedStart, change.modifiedLength);
        for (let delta = 1; ; delta++) {
          const originalStart = change.originalStart - delta;
          const modifiedStart = change.modifiedStart - delta;
          if (originalStart < originalStop || modifiedStart < modifiedStop) {
            break;
          }
          if (checkOriginal && !this.OriginalElementsAreEqual(originalStart, originalStart + change.originalLength)) {
            break;
          }
          if (checkModified && !this.ModifiedElementsAreEqual(modifiedStart, modifiedStart + change.modifiedLength)) {
            break;
          }
          const touchingPreviousChange = originalStart === originalStop && modifiedStart === modifiedStop;
          const score = (touchingPreviousChange ? 5 : 0) + this._boundaryScore(originalStart, change.originalLength, modifiedStart, change.modifiedLength);
          if (score > bestScore) {
            bestScore = score;
            bestDelta = delta;
          }
        }
        change.originalStart -= bestDelta;
        change.modifiedStart -= bestDelta;
        const mergedChangeArr = [null];
        if (i > 0 && this.ChangesOverlap(changes[i - 1], changes[i], mergedChangeArr)) {
          changes[i - 1] = mergedChangeArr[0];
          changes.splice(i, 1);
          i++;
          continue;
        }
      }
      if (this._hasStrings) {
        for (let i = 1, len = changes.length; i < len; i++) {
          const aChange = changes[i - 1];
          const bChange = changes[i];
          const matchedLength = bChange.originalStart - aChange.originalStart - aChange.originalLength;
          const aOriginalStart = aChange.originalStart;
          const bOriginalEnd = bChange.originalStart + bChange.originalLength;
          const abOriginalLength = bOriginalEnd - aOriginalStart;
          const aModifiedStart = aChange.modifiedStart;
          const bModifiedEnd = bChange.modifiedStart + bChange.modifiedLength;
          const abModifiedLength = bModifiedEnd - aModifiedStart;
          if (matchedLength < 5 && abOriginalLength < 20 && abModifiedLength < 20) {
            const t = this._findBetterContiguousSequence(aOriginalStart, abOriginalLength, aModifiedStart, abModifiedLength, matchedLength);
            if (t) {
              const [originalMatchStart, modifiedMatchStart] = t;
              if (originalMatchStart !== aChange.originalStart + aChange.originalLength || modifiedMatchStart !== aChange.modifiedStart + aChange.modifiedLength) {
                aChange.originalLength = originalMatchStart - aChange.originalStart;
                aChange.modifiedLength = modifiedMatchStart - aChange.modifiedStart;
                bChange.originalStart = originalMatchStart + matchedLength;
                bChange.modifiedStart = modifiedMatchStart + matchedLength;
                bChange.originalLength = bOriginalEnd - bChange.originalStart;
                bChange.modifiedLength = bModifiedEnd - bChange.modifiedStart;
              }
            }
          }
        }
      }
      return changes;
    }
    _findBetterContiguousSequence(originalStart, originalLength, modifiedStart, modifiedLength, desiredLength) {
      if (originalLength < desiredLength || modifiedLength < desiredLength) {
        return null;
      }
      const originalMax = originalStart + originalLength - desiredLength + 1;
      const modifiedMax = modifiedStart + modifiedLength - desiredLength + 1;
      let bestScore = 0;
      let bestOriginalStart = 0;
      let bestModifiedStart = 0;
      for (let i = originalStart; i < originalMax; i++) {
        for (let j = modifiedStart; j < modifiedMax; j++) {
          const score = this._contiguousSequenceScore(i, j, desiredLength);
          if (score > 0 && score > bestScore) {
            bestScore = score;
            bestOriginalStart = i;
            bestModifiedStart = j;
          }
        }
      }
      if (bestScore > 0) {
        return [bestOriginalStart, bestModifiedStart];
      }
      return null;
    }
    _contiguousSequenceScore(originalStart, modifiedStart, length) {
      let score = 0;
      for (let l = 0; l < length; l++) {
        if (!this.ElementsAreEqual(originalStart + l, modifiedStart + l)) {
          return 0;
        }
        score += this._originalStringElements[originalStart + l].length;
      }
      return score;
    }
    _OriginalIsBoundary(index) {
      if (index <= 0 || index >= this._originalElementsOrHash.length - 1) {
        return true;
      }
      return this._hasStrings && /^\s*$/.test(this._originalStringElements[index]);
    }
    _OriginalRegionIsBoundary(originalStart, originalLength) {
      if (this._OriginalIsBoundary(originalStart) || this._OriginalIsBoundary(originalStart - 1)) {
        return true;
      }
      if (originalLength > 0) {
        const originalEnd = originalStart + originalLength;
        if (this._OriginalIsBoundary(originalEnd - 1) || this._OriginalIsBoundary(originalEnd)) {
          return true;
        }
      }
      return false;
    }
    _ModifiedIsBoundary(index) {
      if (index <= 0 || index >= this._modifiedElementsOrHash.length - 1) {
        return true;
      }
      return this._hasStrings && /^\s*$/.test(this._modifiedStringElements[index]);
    }
    _ModifiedRegionIsBoundary(modifiedStart, modifiedLength) {
      if (this._ModifiedIsBoundary(modifiedStart) || this._ModifiedIsBoundary(modifiedStart - 1)) {
        return true;
      }
      if (modifiedLength > 0) {
        const modifiedEnd = modifiedStart + modifiedLength;
        if (this._ModifiedIsBoundary(modifiedEnd - 1) || this._ModifiedIsBoundary(modifiedEnd)) {
          return true;
        }
      }
      return false;
    }
    _boundaryScore(originalStart, originalLength, modifiedStart, modifiedLength) {
      const originalScore = this._OriginalRegionIsBoundary(originalStart, originalLength) ? 1 : 0;
      const modifiedScore = this._ModifiedRegionIsBoundary(modifiedStart, modifiedLength) ? 1 : 0;
      return originalScore + modifiedScore;
    }
    ConcatenateChanges(left, right) {
      let mergedChangeArr = [];
      if (left.length === 0 || right.length === 0) {
        return right.length > 0 ? right : left;
      } else if (this.ChangesOverlap(left[left.length - 1], right[0], mergedChangeArr)) {
        const result = new Array(left.length + right.length - 1);
        MyArray.Copy(left, 0, result, 0, left.length - 1);
        result[left.length - 1] = mergedChangeArr[0];
        MyArray.Copy(right, 1, result, left.length, right.length - 1);
        return result;
      } else {
        const result = new Array(left.length + right.length);
        MyArray.Copy(left, 0, result, 0, left.length);
        MyArray.Copy(right, 0, result, left.length, right.length);
        return result;
      }
    }
    ChangesOverlap(left, right, mergedChangeArr) {
      Debug.Assert(left.originalStart <= right.originalStart, "Left change is not less than or equal to right change");
      Debug.Assert(left.modifiedStart <= right.modifiedStart, "Left change is not less than or equal to right change");
      if (left.originalStart + left.originalLength >= right.originalStart || left.modifiedStart + left.modifiedLength >= right.modifiedStart) {
        const originalStart = left.originalStart;
        let originalLength = left.originalLength;
        const modifiedStart = left.modifiedStart;
        let modifiedLength = left.modifiedLength;
        if (left.originalStart + left.originalLength >= right.originalStart) {
          originalLength = right.originalStart + right.originalLength - left.originalStart;
        }
        if (left.modifiedStart + left.modifiedLength >= right.modifiedStart) {
          modifiedLength = right.modifiedStart + right.modifiedLength - left.modifiedStart;
        }
        mergedChangeArr[0] = new DiffChange(originalStart, originalLength, modifiedStart, modifiedLength);
        return true;
      } else {
        mergedChangeArr[0] = null;
        return false;
      }
    }
    ClipDiagonalBound(diagonal, numDifferences, diagonalBaseIndex, numDiagonals) {
      if (diagonal >= 0 && diagonal < numDiagonals) {
        return diagonal;
      }
      const diagonalsBelow = diagonalBaseIndex;
      const diagonalsAbove = numDiagonals - diagonalBaseIndex - 1;
      const diffEven = numDifferences % 2 === 0;
      if (diagonal < 0) {
        const lowerBoundEven = diagonalsBelow % 2 === 0;
        return diffEven === lowerBoundEven ? 0 : 1;
      } else {
        const upperBoundEven = diagonalsAbove % 2 === 0;
        return diffEven === upperBoundEven ? numDiagonals - 1 : numDiagonals - 2;
      }
    }
  };

  // node_modules/monaco-editor/esm/vs/base/common/process.js
  var safeProcess;
  if (typeof globals.vscode !== "undefined" && typeof globals.vscode.process !== "undefined") {
    const sandboxProcess = globals.vscode.process;
    safeProcess = {
      get platform() {
        return sandboxProcess.platform;
      },
      get arch() {
        return sandboxProcess.arch;
      },
      get env() {
        return sandboxProcess.env;
      },
      cwd() {
        return sandboxProcess.cwd();
      }
    };
  } else if (typeof process !== "undefined") {
    safeProcess = {
      get platform() {
        return process.platform;
      },
      get arch() {
        return process.arch;
      },
      get env() {
        return process.env;
      },
      cwd() {
        return process.env["VSCODE_CWD"] || process.cwd();
      }
    };
  } else {
    safeProcess = {
      get platform() {
        return isWindows ? "win32" : isMacintosh ? "darwin" : "linux";
      },
      get arch() {
        return void 0;
      },
      get env() {
        return {};
      },
      cwd() {
        return "/";
      }
    };
  }
  var cwd = safeProcess.cwd;
  var env = safeProcess.env;
  var platform = safeProcess.platform;

  // node_modules/monaco-editor/esm/vs/base/common/path.js
  var CHAR_UPPERCASE_A = 65;
  var CHAR_LOWERCASE_A = 97;
  var CHAR_UPPERCASE_Z = 90;
  var CHAR_LOWERCASE_Z = 122;
  var CHAR_DOT = 46;
  var CHAR_FORWARD_SLASH = 47;
  var CHAR_BACKWARD_SLASH = 92;
  var CHAR_COLON = 58;
  var CHAR_QUESTION_MARK = 63;
  var ErrorInvalidArgType = class extends Error {
    constructor(name, expected, actual) {
      let determiner;
      if (typeof expected === "string" && expected.indexOf("not ") === 0) {
        determiner = "must not be";
        expected = expected.replace(/^not /, "");
      } else {
        determiner = "must be";
      }
      const type = name.indexOf(".") !== -1 ? "property" : "argument";
      let msg = `The "${name}" ${type} ${determiner} of type ${expected}`;
      msg += `. Received type ${typeof actual}`;
      super(msg);
      this.code = "ERR_INVALID_ARG_TYPE";
    }
  };
  function validateString(value, name) {
    if (typeof value !== "string") {
      throw new ErrorInvalidArgType(name, "string", value);
    }
  }
  function isPathSeparator(code) {
    return code === CHAR_FORWARD_SLASH || code === CHAR_BACKWARD_SLASH;
  }
  function isPosixPathSeparator(code) {
    return code === CHAR_FORWARD_SLASH;
  }
  function isWindowsDeviceRoot(code) {
    return code >= CHAR_UPPERCASE_A && code <= CHAR_UPPERCASE_Z || code >= CHAR_LOWERCASE_A && code <= CHAR_LOWERCASE_Z;
  }
  function normalizeString(path, allowAboveRoot, separator, isPathSeparator2) {
    let res = "";
    let lastSegmentLength = 0;
    let lastSlash = -1;
    let dots = 0;
    let code = 0;
    for (let i = 0; i <= path.length; ++i) {
      if (i < path.length) {
        code = path.charCodeAt(i);
      } else if (isPathSeparator2(code)) {
        break;
      } else {
        code = CHAR_FORWARD_SLASH;
      }
      if (isPathSeparator2(code)) {
        if (lastSlash === i - 1 || dots === 1) {
        } else if (dots === 2) {
          if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== CHAR_DOT || res.charCodeAt(res.length - 2) !== CHAR_DOT) {
            if (res.length > 2) {
              const lastSlashIndex = res.lastIndexOf(separator);
              if (lastSlashIndex === -1) {
                res = "";
                lastSegmentLength = 0;
              } else {
                res = res.slice(0, lastSlashIndex);
                lastSegmentLength = res.length - 1 - res.lastIndexOf(separator);
              }
              lastSlash = i;
              dots = 0;
              continue;
            } else if (res.length !== 0) {
              res = "";
              lastSegmentLength = 0;
              lastSlash = i;
              dots = 0;
              continue;
            }
          }
          if (allowAboveRoot) {
            res += res.length > 0 ? `${separator}..` : "..";
            lastSegmentLength = 2;
          }
        } else {
          if (res.length > 0) {
            res += `${separator}${path.slice(lastSlash + 1, i)}`;
          } else {
            res = path.slice(lastSlash + 1, i);
          }
          lastSegmentLength = i - lastSlash - 1;
        }
        lastSlash = i;
        dots = 0;
      } else if (code === CHAR_DOT && dots !== -1) {
        ++dots;
      } else {
        dots = -1;
      }
    }
    return res;
  }
  function _format(sep2, pathObject) {
    if (pathObject === null || typeof pathObject !== "object") {
      throw new ErrorInvalidArgType("pathObject", "Object", pathObject);
    }
    const dir = pathObject.dir || pathObject.root;
    const base = pathObject.base || `${pathObject.name || ""}${pathObject.ext || ""}`;
    if (!dir) {
      return base;
    }
    return dir === pathObject.root ? `${dir}${base}` : `${dir}${sep2}${base}`;
  }
  var win32 = {
    resolve(...pathSegments) {
      let resolvedDevice = "";
      let resolvedTail = "";
      let resolvedAbsolute = false;
      for (let i = pathSegments.length - 1; i >= -1; i--) {
        let path;
        if (i >= 0) {
          path = pathSegments[i];
          validateString(path, "path");
          if (path.length === 0) {
            continue;
          }
        } else if (resolvedDevice.length === 0) {
          path = cwd();
        } else {
          path = env[`=${resolvedDevice}`] || cwd();
          if (path === void 0 || path.slice(0, 2).toLowerCase() !== resolvedDevice.toLowerCase() && path.charCodeAt(2) === CHAR_BACKWARD_SLASH) {
            path = `${resolvedDevice}\\`;
          }
        }
        const len = path.length;
        let rootEnd = 0;
        let device = "";
        let isAbsolute = false;
        const code = path.charCodeAt(0);
        if (len === 1) {
          if (isPathSeparator(code)) {
            rootEnd = 1;
            isAbsolute = true;
          }
        } else if (isPathSeparator(code)) {
          isAbsolute = true;
          if (isPathSeparator(path.charCodeAt(1))) {
            let j = 2;
            let last = j;
            while (j < len && !isPathSeparator(path.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              const firstPart = path.slice(last, j);
              last = j;
              while (j < len && isPathSeparator(path.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                last = j;
                while (j < len && !isPathSeparator(path.charCodeAt(j))) {
                  j++;
                }
                if (j === len || j !== last) {
                  device = `\\\\${firstPart}\\${path.slice(last, j)}`;
                  rootEnd = j;
                }
              }
            }
          } else {
            rootEnd = 1;
          }
        } else if (isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON) {
          device = path.slice(0, 2);
          rootEnd = 2;
          if (len > 2 && isPathSeparator(path.charCodeAt(2))) {
            isAbsolute = true;
            rootEnd = 3;
          }
        }
        if (device.length > 0) {
          if (resolvedDevice.length > 0) {
            if (device.toLowerCase() !== resolvedDevice.toLowerCase()) {
              continue;
            }
          } else {
            resolvedDevice = device;
          }
        }
        if (resolvedAbsolute) {
          if (resolvedDevice.length > 0) {
            break;
          }
        } else {
          resolvedTail = `${path.slice(rootEnd)}\\${resolvedTail}`;
          resolvedAbsolute = isAbsolute;
          if (isAbsolute && resolvedDevice.length > 0) {
            break;
          }
        }
      }
      resolvedTail = normalizeString(resolvedTail, !resolvedAbsolute, "\\", isPathSeparator);
      return resolvedAbsolute ? `${resolvedDevice}\\${resolvedTail}` : `${resolvedDevice}${resolvedTail}` || ".";
    },
    normalize(path) {
      validateString(path, "path");
      const len = path.length;
      if (len === 0) {
        return ".";
      }
      let rootEnd = 0;
      let device;
      let isAbsolute = false;
      const code = path.charCodeAt(0);
      if (len === 1) {
        return isPosixPathSeparator(code) ? "\\" : path;
      }
      if (isPathSeparator(code)) {
        isAbsolute = true;
        if (isPathSeparator(path.charCodeAt(1))) {
          let j = 2;
          let last = j;
          while (j < len && !isPathSeparator(path.charCodeAt(j))) {
            j++;
          }
          if (j < len && j !== last) {
            const firstPart = path.slice(last, j);
            last = j;
            while (j < len && isPathSeparator(path.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              last = j;
              while (j < len && !isPathSeparator(path.charCodeAt(j))) {
                j++;
              }
              if (j === len) {
                return `\\\\${firstPart}\\${path.slice(last)}\\`;
              }
              if (j !== last) {
                device = `\\\\${firstPart}\\${path.slice(last, j)}`;
                rootEnd = j;
              }
            }
          }
        } else {
          rootEnd = 1;
        }
      } else if (isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON) {
        device = path.slice(0, 2);
        rootEnd = 2;
        if (len > 2 && isPathSeparator(path.charCodeAt(2))) {
          isAbsolute = true;
          rootEnd = 3;
        }
      }
      let tail = rootEnd < len ? normalizeString(path.slice(rootEnd), !isAbsolute, "\\", isPathSeparator) : "";
      if (tail.length === 0 && !isAbsolute) {
        tail = ".";
      }
      if (tail.length > 0 && isPathSeparator(path.charCodeAt(len - 1))) {
        tail += "\\";
      }
      if (device === void 0) {
        return isAbsolute ? `\\${tail}` : tail;
      }
      return isAbsolute ? `${device}\\${tail}` : `${device}${tail}`;
    },
    isAbsolute(path) {
      validateString(path, "path");
      const len = path.length;
      if (len === 0) {
        return false;
      }
      const code = path.charCodeAt(0);
      return isPathSeparator(code) || len > 2 && isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON && isPathSeparator(path.charCodeAt(2));
    },
    join(...paths2) {
      if (paths2.length === 0) {
        return ".";
      }
      let joined;
      let firstPart;
      for (let i = 0; i < paths2.length; ++i) {
        const arg = paths2[i];
        validateString(arg, "path");
        if (arg.length > 0) {
          if (joined === void 0) {
            joined = firstPart = arg;
          } else {
            joined += `\\${arg}`;
          }
        }
      }
      if (joined === void 0) {
        return ".";
      }
      let needsReplace = true;
      let slashCount = 0;
      if (typeof firstPart === "string" && isPathSeparator(firstPart.charCodeAt(0))) {
        ++slashCount;
        const firstLen = firstPart.length;
        if (firstLen > 1 && isPathSeparator(firstPart.charCodeAt(1))) {
          ++slashCount;
          if (firstLen > 2) {
            if (isPathSeparator(firstPart.charCodeAt(2))) {
              ++slashCount;
            } else {
              needsReplace = false;
            }
          }
        }
      }
      if (needsReplace) {
        while (slashCount < joined.length && isPathSeparator(joined.charCodeAt(slashCount))) {
          slashCount++;
        }
        if (slashCount >= 2) {
          joined = `\\${joined.slice(slashCount)}`;
        }
      }
      return win32.normalize(joined);
    },
    relative(from, to) {
      validateString(from, "from");
      validateString(to, "to");
      if (from === to) {
        return "";
      }
      const fromOrig = win32.resolve(from);
      const toOrig = win32.resolve(to);
      if (fromOrig === toOrig) {
        return "";
      }
      from = fromOrig.toLowerCase();
      to = toOrig.toLowerCase();
      if (from === to) {
        return "";
      }
      let fromStart = 0;
      while (fromStart < from.length && from.charCodeAt(fromStart) === CHAR_BACKWARD_SLASH) {
        fromStart++;
      }
      let fromEnd = from.length;
      while (fromEnd - 1 > fromStart && from.charCodeAt(fromEnd - 1) === CHAR_BACKWARD_SLASH) {
        fromEnd--;
      }
      const fromLen = fromEnd - fromStart;
      let toStart = 0;
      while (toStart < to.length && to.charCodeAt(toStart) === CHAR_BACKWARD_SLASH) {
        toStart++;
      }
      let toEnd = to.length;
      while (toEnd - 1 > toStart && to.charCodeAt(toEnd - 1) === CHAR_BACKWARD_SLASH) {
        toEnd--;
      }
      const toLen = toEnd - toStart;
      const length = fromLen < toLen ? fromLen : toLen;
      let lastCommonSep = -1;
      let i = 0;
      for (; i < length; i++) {
        const fromCode = from.charCodeAt(fromStart + i);
        if (fromCode !== to.charCodeAt(toStart + i)) {
          break;
        } else if (fromCode === CHAR_BACKWARD_SLASH) {
          lastCommonSep = i;
        }
      }
      if (i !== length) {
        if (lastCommonSep === -1) {
          return toOrig;
        }
      } else {
        if (toLen > length) {
          if (to.charCodeAt(toStart + i) === CHAR_BACKWARD_SLASH) {
            return toOrig.slice(toStart + i + 1);
          }
          if (i === 2) {
            return toOrig.slice(toStart + i);
          }
        }
        if (fromLen > length) {
          if (from.charCodeAt(fromStart + i) === CHAR_BACKWARD_SLASH) {
            lastCommonSep = i;
          } else if (i === 2) {
            lastCommonSep = 3;
          }
        }
        if (lastCommonSep === -1) {
          lastCommonSep = 0;
        }
      }
      let out = "";
      for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
        if (i === fromEnd || from.charCodeAt(i) === CHAR_BACKWARD_SLASH) {
          out += out.length === 0 ? ".." : "\\..";
        }
      }
      toStart += lastCommonSep;
      if (out.length > 0) {
        return `${out}${toOrig.slice(toStart, toEnd)}`;
      }
      if (toOrig.charCodeAt(toStart) === CHAR_BACKWARD_SLASH) {
        ++toStart;
      }
      return toOrig.slice(toStart, toEnd);
    },
    toNamespacedPath(path) {
      if (typeof path !== "string") {
        return path;
      }
      if (path.length === 0) {
        return "";
      }
      const resolvedPath = win32.resolve(path);
      if (resolvedPath.length <= 2) {
        return path;
      }
      if (resolvedPath.charCodeAt(0) === CHAR_BACKWARD_SLASH) {
        if (resolvedPath.charCodeAt(1) === CHAR_BACKWARD_SLASH) {
          const code = resolvedPath.charCodeAt(2);
          if (code !== CHAR_QUESTION_MARK && code !== CHAR_DOT) {
            return `\\\\?\\UNC\\${resolvedPath.slice(2)}`;
          }
        }
      } else if (isWindowsDeviceRoot(resolvedPath.charCodeAt(0)) && resolvedPath.charCodeAt(1) === CHAR_COLON && resolvedPath.charCodeAt(2) === CHAR_BACKWARD_SLASH) {
        return `\\\\?\\${resolvedPath}`;
      }
      return path;
    },
    dirname(path) {
      validateString(path, "path");
      const len = path.length;
      if (len === 0) {
        return ".";
      }
      let rootEnd = -1;
      let offset = 0;
      const code = path.charCodeAt(0);
      if (len === 1) {
        return isPathSeparator(code) ? path : ".";
      }
      if (isPathSeparator(code)) {
        rootEnd = offset = 1;
        if (isPathSeparator(path.charCodeAt(1))) {
          let j = 2;
          let last = j;
          while (j < len && !isPathSeparator(path.charCodeAt(j))) {
            j++;
          }
          if (j < len && j !== last) {
            last = j;
            while (j < len && isPathSeparator(path.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              last = j;
              while (j < len && !isPathSeparator(path.charCodeAt(j))) {
                j++;
              }
              if (j === len) {
                return path;
              }
              if (j !== last) {
                rootEnd = offset = j + 1;
              }
            }
          }
        }
      } else if (isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON) {
        rootEnd = len > 2 && isPathSeparator(path.charCodeAt(2)) ? 3 : 2;
        offset = rootEnd;
      }
      let end = -1;
      let matchedSlash = true;
      for (let i = len - 1; i >= offset; --i) {
        if (isPathSeparator(path.charCodeAt(i))) {
          if (!matchedSlash) {
            end = i;
            break;
          }
        } else {
          matchedSlash = false;
        }
      }
      if (end === -1) {
        if (rootEnd === -1) {
          return ".";
        }
        end = rootEnd;
      }
      return path.slice(0, end);
    },
    basename(path, ext) {
      if (ext !== void 0) {
        validateString(ext, "ext");
      }
      validateString(path, "path");
      let start = 0;
      let end = -1;
      let matchedSlash = true;
      let i;
      if (path.length >= 2 && isWindowsDeviceRoot(path.charCodeAt(0)) && path.charCodeAt(1) === CHAR_COLON) {
        start = 2;
      }
      if (ext !== void 0 && ext.length > 0 && ext.length <= path.length) {
        if (ext === path) {
          return "";
        }
        let extIdx = ext.length - 1;
        let firstNonSlashEnd = -1;
        for (i = path.length - 1; i >= start; --i) {
          const code = path.charCodeAt(i);
          if (isPathSeparator(code)) {
            if (!matchedSlash) {
              start = i + 1;
              break;
            }
          } else {
            if (firstNonSlashEnd === -1) {
              matchedSlash = false;
              firstNonSlashEnd = i + 1;
            }
            if (extIdx >= 0) {
              if (code === ext.charCodeAt(extIdx)) {
                if (--extIdx === -1) {
                  end = i;
                }
              } else {
                extIdx = -1;
                end = firstNonSlashEnd;
              }
            }
          }
        }
        if (start === end) {
          end = firstNonSlashEnd;
        } else if (end === -1) {
          end = path.length;
        }
        return path.slice(start, end);
      }
      for (i = path.length - 1; i >= start; --i) {
        if (isPathSeparator(path.charCodeAt(i))) {
          if (!matchedSlash) {
            start = i + 1;
            break;
          }
        } else if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
      }
      if (end === -1) {
        return "";
      }
      return path.slice(start, end);
    },
    extname(path) {
      validateString(path, "path");
      let start = 0;
      let startDot = -1;
      let startPart = 0;
      let end = -1;
      let matchedSlash = true;
      let preDotState = 0;
      if (path.length >= 2 && path.charCodeAt(1) === CHAR_COLON && isWindowsDeviceRoot(path.charCodeAt(0))) {
        start = startPart = 2;
      }
      for (let i = path.length - 1; i >= start; --i) {
        const code = path.charCodeAt(i);
        if (isPathSeparator(code)) {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (code === CHAR_DOT) {
          if (startDot === -1) {
            startDot = i;
          } else if (preDotState !== 1) {
            preDotState = 1;
          }
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (startDot === -1 || end === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        return "";
      }
      return path.slice(startDot, end);
    },
    format: _format.bind(null, "\\"),
    parse(path) {
      validateString(path, "path");
      const ret = {root: "", dir: "", base: "", ext: "", name: ""};
      if (path.length === 0) {
        return ret;
      }
      const len = path.length;
      let rootEnd = 0;
      let code = path.charCodeAt(0);
      if (len === 1) {
        if (isPathSeparator(code)) {
          ret.root = ret.dir = path;
          return ret;
        }
        ret.base = ret.name = path;
        return ret;
      }
      if (isPathSeparator(code)) {
        rootEnd = 1;
        if (isPathSeparator(path.charCodeAt(1))) {
          let j = 2;
          let last = j;
          while (j < len && !isPathSeparator(path.charCodeAt(j))) {
            j++;
          }
          if (j < len && j !== last) {
            last = j;
            while (j < len && isPathSeparator(path.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              last = j;
              while (j < len && !isPathSeparator(path.charCodeAt(j))) {
                j++;
              }
              if (j === len) {
                rootEnd = j;
              } else if (j !== last) {
                rootEnd = j + 1;
              }
            }
          }
        }
      } else if (isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON) {
        if (len <= 2) {
          ret.root = ret.dir = path;
          return ret;
        }
        rootEnd = 2;
        if (isPathSeparator(path.charCodeAt(2))) {
          if (len === 3) {
            ret.root = ret.dir = path;
            return ret;
          }
          rootEnd = 3;
        }
      }
      if (rootEnd > 0) {
        ret.root = path.slice(0, rootEnd);
      }
      let startDot = -1;
      let startPart = rootEnd;
      let end = -1;
      let matchedSlash = true;
      let i = path.length - 1;
      let preDotState = 0;
      for (; i >= rootEnd; --i) {
        code = path.charCodeAt(i);
        if (isPathSeparator(code)) {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (code === CHAR_DOT) {
          if (startDot === -1) {
            startDot = i;
          } else if (preDotState !== 1) {
            preDotState = 1;
          }
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (end !== -1) {
        if (startDot === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          ret.base = ret.name = path.slice(startPart, end);
        } else {
          ret.name = path.slice(startPart, startDot);
          ret.base = path.slice(startPart, end);
          ret.ext = path.slice(startDot, end);
        }
      }
      if (startPart > 0 && startPart !== rootEnd) {
        ret.dir = path.slice(0, startPart - 1);
      } else {
        ret.dir = ret.root;
      }
      return ret;
    },
    sep: "\\",
    delimiter: ";",
    win32: null,
    posix: null
  };
  var posix = {
    resolve(...pathSegments) {
      let resolvedPath = "";
      let resolvedAbsolute = false;
      for (let i = pathSegments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
        const path = i >= 0 ? pathSegments[i] : cwd();
        validateString(path, "path");
        if (path.length === 0) {
          continue;
        }
        resolvedPath = `${path}/${resolvedPath}`;
        resolvedAbsolute = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
      }
      resolvedPath = normalizeString(resolvedPath, !resolvedAbsolute, "/", isPosixPathSeparator);
      if (resolvedAbsolute) {
        return `/${resolvedPath}`;
      }
      return resolvedPath.length > 0 ? resolvedPath : ".";
    },
    normalize(path) {
      validateString(path, "path");
      if (path.length === 0) {
        return ".";
      }
      const isAbsolute = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
      const trailingSeparator = path.charCodeAt(path.length - 1) === CHAR_FORWARD_SLASH;
      path = normalizeString(path, !isAbsolute, "/", isPosixPathSeparator);
      if (path.length === 0) {
        if (isAbsolute) {
          return "/";
        }
        return trailingSeparator ? "./" : ".";
      }
      if (trailingSeparator) {
        path += "/";
      }
      return isAbsolute ? `/${path}` : path;
    },
    isAbsolute(path) {
      validateString(path, "path");
      return path.length > 0 && path.charCodeAt(0) === CHAR_FORWARD_SLASH;
    },
    join(...paths2) {
      if (paths2.length === 0) {
        return ".";
      }
      let joined;
      for (let i = 0; i < paths2.length; ++i) {
        const arg = paths2[i];
        validateString(arg, "path");
        if (arg.length > 0) {
          if (joined === void 0) {
            joined = arg;
          } else {
            joined += `/${arg}`;
          }
        }
      }
      if (joined === void 0) {
        return ".";
      }
      return posix.normalize(joined);
    },
    relative(from, to) {
      validateString(from, "from");
      validateString(to, "to");
      if (from === to) {
        return "";
      }
      from = posix.resolve(from);
      to = posix.resolve(to);
      if (from === to) {
        return "";
      }
      const fromStart = 1;
      const fromEnd = from.length;
      const fromLen = fromEnd - fromStart;
      const toStart = 1;
      const toLen = to.length - toStart;
      const length = fromLen < toLen ? fromLen : toLen;
      let lastCommonSep = -1;
      let i = 0;
      for (; i < length; i++) {
        const fromCode = from.charCodeAt(fromStart + i);
        if (fromCode !== to.charCodeAt(toStart + i)) {
          break;
        } else if (fromCode === CHAR_FORWARD_SLASH) {
          lastCommonSep = i;
        }
      }
      if (i === length) {
        if (toLen > length) {
          if (to.charCodeAt(toStart + i) === CHAR_FORWARD_SLASH) {
            return to.slice(toStart + i + 1);
          }
          if (i === 0) {
            return to.slice(toStart + i);
          }
        } else if (fromLen > length) {
          if (from.charCodeAt(fromStart + i) === CHAR_FORWARD_SLASH) {
            lastCommonSep = i;
          } else if (i === 0) {
            lastCommonSep = 0;
          }
        }
      }
      let out = "";
      for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
        if (i === fromEnd || from.charCodeAt(i) === CHAR_FORWARD_SLASH) {
          out += out.length === 0 ? ".." : "/..";
        }
      }
      return `${out}${to.slice(toStart + lastCommonSep)}`;
    },
    toNamespacedPath(path) {
      return path;
    },
    dirname(path) {
      validateString(path, "path");
      if (path.length === 0) {
        return ".";
      }
      const hasRoot = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
      let end = -1;
      let matchedSlash = true;
      for (let i = path.length - 1; i >= 1; --i) {
        if (path.charCodeAt(i) === CHAR_FORWARD_SLASH) {
          if (!matchedSlash) {
            end = i;
            break;
          }
        } else {
          matchedSlash = false;
        }
      }
      if (end === -1) {
        return hasRoot ? "/" : ".";
      }
      if (hasRoot && end === 1) {
        return "//";
      }
      return path.slice(0, end);
    },
    basename(path, ext) {
      if (ext !== void 0) {
        validateString(ext, "ext");
      }
      validateString(path, "path");
      let start = 0;
      let end = -1;
      let matchedSlash = true;
      let i;
      if (ext !== void 0 && ext.length > 0 && ext.length <= path.length) {
        if (ext === path) {
          return "";
        }
        let extIdx = ext.length - 1;
        let firstNonSlashEnd = -1;
        for (i = path.length - 1; i >= 0; --i) {
          const code = path.charCodeAt(i);
          if (code === CHAR_FORWARD_SLASH) {
            if (!matchedSlash) {
              start = i + 1;
              break;
            }
          } else {
            if (firstNonSlashEnd === -1) {
              matchedSlash = false;
              firstNonSlashEnd = i + 1;
            }
            if (extIdx >= 0) {
              if (code === ext.charCodeAt(extIdx)) {
                if (--extIdx === -1) {
                  end = i;
                }
              } else {
                extIdx = -1;
                end = firstNonSlashEnd;
              }
            }
          }
        }
        if (start === end) {
          end = firstNonSlashEnd;
        } else if (end === -1) {
          end = path.length;
        }
        return path.slice(start, end);
      }
      for (i = path.length - 1; i >= 0; --i) {
        if (path.charCodeAt(i) === CHAR_FORWARD_SLASH) {
          if (!matchedSlash) {
            start = i + 1;
            break;
          }
        } else if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
      }
      if (end === -1) {
        return "";
      }
      return path.slice(start, end);
    },
    extname(path) {
      validateString(path, "path");
      let startDot = -1;
      let startPart = 0;
      let end = -1;
      let matchedSlash = true;
      let preDotState = 0;
      for (let i = path.length - 1; i >= 0; --i) {
        const code = path.charCodeAt(i);
        if (code === CHAR_FORWARD_SLASH) {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (code === CHAR_DOT) {
          if (startDot === -1) {
            startDot = i;
          } else if (preDotState !== 1) {
            preDotState = 1;
          }
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (startDot === -1 || end === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        return "";
      }
      return path.slice(startDot, end);
    },
    format: _format.bind(null, "/"),
    parse(path) {
      validateString(path, "path");
      const ret = {root: "", dir: "", base: "", ext: "", name: ""};
      if (path.length === 0) {
        return ret;
      }
      const isAbsolute = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
      let start;
      if (isAbsolute) {
        ret.root = "/";
        start = 1;
      } else {
        start = 0;
      }
      let startDot = -1;
      let startPart = 0;
      let end = -1;
      let matchedSlash = true;
      let i = path.length - 1;
      let preDotState = 0;
      for (; i >= start; --i) {
        const code = path.charCodeAt(i);
        if (code === CHAR_FORWARD_SLASH) {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (code === CHAR_DOT) {
          if (startDot === -1) {
            startDot = i;
          } else if (preDotState !== 1) {
            preDotState = 1;
          }
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (end !== -1) {
        const start2 = startPart === 0 && isAbsolute ? 1 : startPart;
        if (startDot === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          ret.base = ret.name = path.slice(start2, end);
        } else {
          ret.name = path.slice(start2, startDot);
          ret.base = path.slice(start2, end);
          ret.ext = path.slice(startDot, end);
        }
      }
      if (startPart > 0) {
        ret.dir = path.slice(0, startPart - 1);
      } else if (isAbsolute) {
        ret.dir = "/";
      }
      return ret;
    },
    sep: "/",
    delimiter: ":",
    win32: null,
    posix: null
  };
  posix.win32 = win32.win32 = win32;
  posix.posix = win32.posix = posix;
  var normalize = platform === "win32" ? win32.normalize : posix.normalize;
  var resolve = platform === "win32" ? win32.resolve : posix.resolve;
  var relative = platform === "win32" ? win32.relative : posix.relative;
  var dirname = platform === "win32" ? win32.dirname : posix.dirname;
  var basename = platform === "win32" ? win32.basename : posix.basename;
  var extname = platform === "win32" ? win32.extname : posix.extname;
  var sep = platform === "win32" ? win32.sep : posix.sep;

  // node_modules/monaco-editor/esm/vs/base/common/uri.js
  var _schemePattern = /^\w[\w\d+.-]*$/;
  var _singleSlashStart = /^\//;
  var _doubleSlashStart = /^\/\//;
  function _validateUri(ret, _strict) {
    if (!ret.scheme && _strict) {
      throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${ret.authority}", path: "${ret.path}", query: "${ret.query}", fragment: "${ret.fragment}"}`);
    }
    if (ret.scheme && !_schemePattern.test(ret.scheme)) {
      throw new Error("[UriError]: Scheme contains illegal characters.");
    }
    if (ret.path) {
      if (ret.authority) {
        if (!_singleSlashStart.test(ret.path)) {
          throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
        }
      } else {
        if (_doubleSlashStart.test(ret.path)) {
          throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
        }
      }
    }
  }
  function _schemeFix(scheme, _strict) {
    if (!scheme && !_strict) {
      return "file";
    }
    return scheme;
  }
  function _referenceResolution(scheme, path) {
    switch (scheme) {
      case "https":
      case "http":
      case "file":
        if (!path) {
          path = _slash;
        } else if (path[0] !== _slash) {
          path = _slash + path;
        }
        break;
    }
    return path;
  }
  var _empty = "";
  var _slash = "/";
  var _regexp = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
  var URI = class {
    constructor(schemeOrData, authority, path, query, fragment, _strict = false) {
      if (typeof schemeOrData === "object") {
        this.scheme = schemeOrData.scheme || _empty;
        this.authority = schemeOrData.authority || _empty;
        this.path = schemeOrData.path || _empty;
        this.query = schemeOrData.query || _empty;
        this.fragment = schemeOrData.fragment || _empty;
      } else {
        this.scheme = _schemeFix(schemeOrData, _strict);
        this.authority = authority || _empty;
        this.path = _referenceResolution(this.scheme, path || _empty);
        this.query = query || _empty;
        this.fragment = fragment || _empty;
        _validateUri(this, _strict);
      }
    }
    static isUri(thing) {
      if (thing instanceof URI) {
        return true;
      }
      if (!thing) {
        return false;
      }
      return typeof thing.authority === "string" && typeof thing.fragment === "string" && typeof thing.path === "string" && typeof thing.query === "string" && typeof thing.scheme === "string" && typeof thing.fsPath === "string" && typeof thing.with === "function" && typeof thing.toString === "function";
    }
    get fsPath() {
      return uriToFsPath(this, false);
    }
    with(change) {
      if (!change) {
        return this;
      }
      let {scheme, authority, path, query, fragment} = change;
      if (scheme === void 0) {
        scheme = this.scheme;
      } else if (scheme === null) {
        scheme = _empty;
      }
      if (authority === void 0) {
        authority = this.authority;
      } else if (authority === null) {
        authority = _empty;
      }
      if (path === void 0) {
        path = this.path;
      } else if (path === null) {
        path = _empty;
      }
      if (query === void 0) {
        query = this.query;
      } else if (query === null) {
        query = _empty;
      }
      if (fragment === void 0) {
        fragment = this.fragment;
      } else if (fragment === null) {
        fragment = _empty;
      }
      if (scheme === this.scheme && authority === this.authority && path === this.path && query === this.query && fragment === this.fragment) {
        return this;
      }
      return new Uri(scheme, authority, path, query, fragment);
    }
    static parse(value, _strict = false) {
      const match = _regexp.exec(value);
      if (!match) {
        return new Uri(_empty, _empty, _empty, _empty, _empty);
      }
      return new Uri(match[2] || _empty, percentDecode(match[4] || _empty), percentDecode(match[5] || _empty), percentDecode(match[7] || _empty), percentDecode(match[9] || _empty), _strict);
    }
    static file(path) {
      let authority = _empty;
      if (isWindows) {
        path = path.replace(/\\/g, _slash);
      }
      if (path[0] === _slash && path[1] === _slash) {
        const idx = path.indexOf(_slash, 2);
        if (idx === -1) {
          authority = path.substring(2);
          path = _slash;
        } else {
          authority = path.substring(2, idx);
          path = path.substring(idx) || _slash;
        }
      }
      return new Uri("file", authority, path, _empty, _empty);
    }
    static from(components) {
      const result = new Uri(components.scheme, components.authority, components.path, components.query, components.fragment);
      _validateUri(result, true);
      return result;
    }
    static joinPath(uri, ...pathFragment) {
      if (!uri.path) {
        throw new Error(`[UriError]: cannot call joinPath on URI without path`);
      }
      let newPath;
      if (isWindows && uri.scheme === "file") {
        newPath = URI.file(win32.join(uriToFsPath(uri, true), ...pathFragment)).path;
      } else {
        newPath = posix.join(uri.path, ...pathFragment);
      }
      return uri.with({path: newPath});
    }
    toString(skipEncoding = false) {
      return _asFormatted(this, skipEncoding);
    }
    toJSON() {
      return this;
    }
    static revive(data) {
      if (!data) {
        return data;
      } else if (data instanceof URI) {
        return data;
      } else {
        const result = new Uri(data);
        result._formatted = data.external;
        result._fsPath = data._sep === _pathSepMarker ? data.fsPath : null;
        return result;
      }
    }
  };
  var _pathSepMarker = isWindows ? 1 : void 0;
  var Uri = class extends URI {
    constructor() {
      super(...arguments);
      this._formatted = null;
      this._fsPath = null;
    }
    get fsPath() {
      if (!this._fsPath) {
        this._fsPath = uriToFsPath(this, false);
      }
      return this._fsPath;
    }
    toString(skipEncoding = false) {
      if (!skipEncoding) {
        if (!this._formatted) {
          this._formatted = _asFormatted(this, false);
        }
        return this._formatted;
      } else {
        return _asFormatted(this, true);
      }
    }
    toJSON() {
      const res = {
        $mid: 1
      };
      if (this._fsPath) {
        res.fsPath = this._fsPath;
        res._sep = _pathSepMarker;
      }
      if (this._formatted) {
        res.external = this._formatted;
      }
      if (this.path) {
        res.path = this.path;
      }
      if (this.scheme) {
        res.scheme = this.scheme;
      }
      if (this.authority) {
        res.authority = this.authority;
      }
      if (this.query) {
        res.query = this.query;
      }
      if (this.fragment) {
        res.fragment = this.fragment;
      }
      return res;
    }
  };
  var encodeTable = {
    [58]: "%3A",
    [47]: "%2F",
    [63]: "%3F",
    [35]: "%23",
    [91]: "%5B",
    [93]: "%5D",
    [64]: "%40",
    [33]: "%21",
    [36]: "%24",
    [38]: "%26",
    [39]: "%27",
    [40]: "%28",
    [41]: "%29",
    [42]: "%2A",
    [43]: "%2B",
    [44]: "%2C",
    [59]: "%3B",
    [61]: "%3D",
    [32]: "%20"
  };
  function encodeURIComponentFast(uriComponent, allowSlash) {
    let res = void 0;
    let nativeEncodePos = -1;
    for (let pos = 0; pos < uriComponent.length; pos++) {
      const code = uriComponent.charCodeAt(pos);
      if (code >= 97 && code <= 122 || code >= 65 && code <= 90 || code >= 48 && code <= 57 || code === 45 || code === 46 || code === 95 || code === 126 || allowSlash && code === 47) {
        if (nativeEncodePos !== -1) {
          res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
          nativeEncodePos = -1;
        }
        if (res !== void 0) {
          res += uriComponent.charAt(pos);
        }
      } else {
        if (res === void 0) {
          res = uriComponent.substr(0, pos);
        }
        const escaped = encodeTable[code];
        if (escaped !== void 0) {
          if (nativeEncodePos !== -1) {
            res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
            nativeEncodePos = -1;
          }
          res += escaped;
        } else if (nativeEncodePos === -1) {
          nativeEncodePos = pos;
        }
      }
    }
    if (nativeEncodePos !== -1) {
      res += encodeURIComponent(uriComponent.substring(nativeEncodePos));
    }
    return res !== void 0 ? res : uriComponent;
  }
  function encodeURIComponentMinimal(path) {
    let res = void 0;
    for (let pos = 0; pos < path.length; pos++) {
      const code = path.charCodeAt(pos);
      if (code === 35 || code === 63) {
        if (res === void 0) {
          res = path.substr(0, pos);
        }
        res += encodeTable[code];
      } else {
        if (res !== void 0) {
          res += path[pos];
        }
      }
    }
    return res !== void 0 ? res : path;
  }
  function uriToFsPath(uri, keepDriveLetterCasing) {
    let value;
    if (uri.authority && uri.path.length > 1 && uri.scheme === "file") {
      value = `//${uri.authority}${uri.path}`;
    } else if (uri.path.charCodeAt(0) === 47 && (uri.path.charCodeAt(1) >= 65 && uri.path.charCodeAt(1) <= 90 || uri.path.charCodeAt(1) >= 97 && uri.path.charCodeAt(1) <= 122) && uri.path.charCodeAt(2) === 58) {
      if (!keepDriveLetterCasing) {
        value = uri.path[1].toLowerCase() + uri.path.substr(2);
      } else {
        value = uri.path.substr(1);
      }
    } else {
      value = uri.path;
    }
    if (isWindows) {
      value = value.replace(/\//g, "\\");
    }
    return value;
  }
  function _asFormatted(uri, skipEncoding) {
    const encoder = !skipEncoding ? encodeURIComponentFast : encodeURIComponentMinimal;
    let res = "";
    let {scheme, authority, path, query, fragment} = uri;
    if (scheme) {
      res += scheme;
      res += ":";
    }
    if (authority || scheme === "file") {
      res += _slash;
      res += _slash;
    }
    if (authority) {
      let idx = authority.indexOf("@");
      if (idx !== -1) {
        const userinfo = authority.substr(0, idx);
        authority = authority.substr(idx + 1);
        idx = userinfo.indexOf(":");
        if (idx === -1) {
          res += encoder(userinfo, false);
        } else {
          res += encoder(userinfo.substr(0, idx), false);
          res += ":";
          res += encoder(userinfo.substr(idx + 1), false);
        }
        res += "@";
      }
      authority = authority.toLowerCase();
      idx = authority.indexOf(":");
      if (idx === -1) {
        res += encoder(authority, false);
      } else {
        res += encoder(authority.substr(0, idx), false);
        res += authority.substr(idx);
      }
    }
    if (path) {
      if (path.length >= 3 && path.charCodeAt(0) === 47 && path.charCodeAt(2) === 58) {
        const code = path.charCodeAt(1);
        if (code >= 65 && code <= 90) {
          path = `/${String.fromCharCode(code + 32)}:${path.substr(3)}`;
        }
      } else if (path.length >= 2 && path.charCodeAt(1) === 58) {
        const code = path.charCodeAt(0);
        if (code >= 65 && code <= 90) {
          path = `${String.fromCharCode(code + 32)}:${path.substr(2)}`;
        }
      }
      res += encoder(path, true);
    }
    if (query) {
      res += "?";
      res += encoder(query, false);
    }
    if (fragment) {
      res += "#";
      res += !skipEncoding ? encodeURIComponentFast(fragment, false) : fragment;
    }
    return res;
  }
  function decodeURIComponentGraceful(str) {
    try {
      return decodeURIComponent(str);
    } catch (_a3) {
      if (str.length > 3) {
        return str.substr(0, 3) + decodeURIComponentGraceful(str.substr(3));
      } else {
        return str;
      }
    }
  }
  var _rEncodedAsHex = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
  function percentDecode(str) {
    if (!str.match(_rEncodedAsHex)) {
      return str;
    }
    return str.replace(_rEncodedAsHex, (match) => decodeURIComponentGraceful(match));
  }

  // node_modules/monaco-editor/esm/vs/editor/common/core/position.js
  var Position = class {
    constructor(lineNumber, column) {
      this.lineNumber = lineNumber;
      this.column = column;
    }
    with(newLineNumber = this.lineNumber, newColumn = this.column) {
      if (newLineNumber === this.lineNumber && newColumn === this.column) {
        return this;
      } else {
        return new Position(newLineNumber, newColumn);
      }
    }
    delta(deltaLineNumber = 0, deltaColumn = 0) {
      return this.with(this.lineNumber + deltaLineNumber, this.column + deltaColumn);
    }
    equals(other) {
      return Position.equals(this, other);
    }
    static equals(a, b) {
      if (!a && !b) {
        return true;
      }
      return !!a && !!b && a.lineNumber === b.lineNumber && a.column === b.column;
    }
    isBefore(other) {
      return Position.isBefore(this, other);
    }
    static isBefore(a, b) {
      if (a.lineNumber < b.lineNumber) {
        return true;
      }
      if (b.lineNumber < a.lineNumber) {
        return false;
      }
      return a.column < b.column;
    }
    isBeforeOrEqual(other) {
      return Position.isBeforeOrEqual(this, other);
    }
    static isBeforeOrEqual(a, b) {
      if (a.lineNumber < b.lineNumber) {
        return true;
      }
      if (b.lineNumber < a.lineNumber) {
        return false;
      }
      return a.column <= b.column;
    }
    static compare(a, b) {
      const aLineNumber = a.lineNumber | 0;
      const bLineNumber = b.lineNumber | 0;
      if (aLineNumber === bLineNumber) {
        const aColumn = a.column | 0;
        const bColumn = b.column | 0;
        return aColumn - bColumn;
      }
      return aLineNumber - bLineNumber;
    }
    clone() {
      return new Position(this.lineNumber, this.column);
    }
    toString() {
      return "(" + this.lineNumber + "," + this.column + ")";
    }
    static lift(pos) {
      return new Position(pos.lineNumber, pos.column);
    }
    static isIPosition(obj) {
      return obj && typeof obj.lineNumber === "number" && typeof obj.column === "number";
    }
  };

  // node_modules/monaco-editor/esm/vs/editor/common/core/range.js
  var Range = class {
    constructor(startLineNumber, startColumn, endLineNumber, endColumn) {
      if (startLineNumber > endLineNumber || startLineNumber === endLineNumber && startColumn > endColumn) {
        this.startLineNumber = endLineNumber;
        this.startColumn = endColumn;
        this.endLineNumber = startLineNumber;
        this.endColumn = startColumn;
      } else {
        this.startLineNumber = startLineNumber;
        this.startColumn = startColumn;
        this.endLineNumber = endLineNumber;
        this.endColumn = endColumn;
      }
    }
    isEmpty() {
      return Range.isEmpty(this);
    }
    static isEmpty(range) {
      return range.startLineNumber === range.endLineNumber && range.startColumn === range.endColumn;
    }
    containsPosition(position) {
      return Range.containsPosition(this, position);
    }
    static containsPosition(range, position) {
      if (position.lineNumber < range.startLineNumber || position.lineNumber > range.endLineNumber) {
        return false;
      }
      if (position.lineNumber === range.startLineNumber && position.column < range.startColumn) {
        return false;
      }
      if (position.lineNumber === range.endLineNumber && position.column > range.endColumn) {
        return false;
      }
      return true;
    }
    static strictContainsPosition(range, position) {
      if (position.lineNumber < range.startLineNumber || position.lineNumber > range.endLineNumber) {
        return false;
      }
      if (position.lineNumber === range.startLineNumber && position.column <= range.startColumn) {
        return false;
      }
      if (position.lineNumber === range.endLineNumber && position.column >= range.endColumn) {
        return false;
      }
      return true;
    }
    containsRange(range) {
      return Range.containsRange(this, range);
    }
    static containsRange(range, otherRange) {
      if (otherRange.startLineNumber < range.startLineNumber || otherRange.endLineNumber < range.startLineNumber) {
        return false;
      }
      if (otherRange.startLineNumber > range.endLineNumber || otherRange.endLineNumber > range.endLineNumber) {
        return false;
      }
      if (otherRange.startLineNumber === range.startLineNumber && otherRange.startColumn < range.startColumn) {
        return false;
      }
      if (otherRange.endLineNumber === range.endLineNumber && otherRange.endColumn > range.endColumn) {
        return false;
      }
      return true;
    }
    strictContainsRange(range) {
      return Range.strictContainsRange(this, range);
    }
    static strictContainsRange(range, otherRange) {
      if (otherRange.startLineNumber < range.startLineNumber || otherRange.endLineNumber < range.startLineNumber) {
        return false;
      }
      if (otherRange.startLineNumber > range.endLineNumber || otherRange.endLineNumber > range.endLineNumber) {
        return false;
      }
      if (otherRange.startLineNumber === range.startLineNumber && otherRange.startColumn <= range.startColumn) {
        return false;
      }
      if (otherRange.endLineNumber === range.endLineNumber && otherRange.endColumn >= range.endColumn) {
        return false;
      }
      return true;
    }
    plusRange(range) {
      return Range.plusRange(this, range);
    }
    static plusRange(a, b) {
      let startLineNumber;
      let startColumn;
      let endLineNumber;
      let endColumn;
      if (b.startLineNumber < a.startLineNumber) {
        startLineNumber = b.startLineNumber;
        startColumn = b.startColumn;
      } else if (b.startLineNumber === a.startLineNumber) {
        startLineNumber = b.startLineNumber;
        startColumn = Math.min(b.startColumn, a.startColumn);
      } else {
        startLineNumber = a.startLineNumber;
        startColumn = a.startColumn;
      }
      if (b.endLineNumber > a.endLineNumber) {
        endLineNumber = b.endLineNumber;
        endColumn = b.endColumn;
      } else if (b.endLineNumber === a.endLineNumber) {
        endLineNumber = b.endLineNumber;
        endColumn = Math.max(b.endColumn, a.endColumn);
      } else {
        endLineNumber = a.endLineNumber;
        endColumn = a.endColumn;
      }
      return new Range(startLineNumber, startColumn, endLineNumber, endColumn);
    }
    intersectRanges(range) {
      return Range.intersectRanges(this, range);
    }
    static intersectRanges(a, b) {
      let resultStartLineNumber = a.startLineNumber;
      let resultStartColumn = a.startColumn;
      let resultEndLineNumber = a.endLineNumber;
      let resultEndColumn = a.endColumn;
      let otherStartLineNumber = b.startLineNumber;
      let otherStartColumn = b.startColumn;
      let otherEndLineNumber = b.endLineNumber;
      let otherEndColumn = b.endColumn;
      if (resultStartLineNumber < otherStartLineNumber) {
        resultStartLineNumber = otherStartLineNumber;
        resultStartColumn = otherStartColumn;
      } else if (resultStartLineNumber === otherStartLineNumber) {
        resultStartColumn = Math.max(resultStartColumn, otherStartColumn);
      }
      if (resultEndLineNumber > otherEndLineNumber) {
        resultEndLineNumber = otherEndLineNumber;
        resultEndColumn = otherEndColumn;
      } else if (resultEndLineNumber === otherEndLineNumber) {
        resultEndColumn = Math.min(resultEndColumn, otherEndColumn);
      }
      if (resultStartLineNumber > resultEndLineNumber) {
        return null;
      }
      if (resultStartLineNumber === resultEndLineNumber && resultStartColumn > resultEndColumn) {
        return null;
      }
      return new Range(resultStartLineNumber, resultStartColumn, resultEndLineNumber, resultEndColumn);
    }
    equalsRange(other) {
      return Range.equalsRange(this, other);
    }
    static equalsRange(a, b) {
      return !!a && !!b && a.startLineNumber === b.startLineNumber && a.startColumn === b.startColumn && a.endLineNumber === b.endLineNumber && a.endColumn === b.endColumn;
    }
    getEndPosition() {
      return Range.getEndPosition(this);
    }
    static getEndPosition(range) {
      return new Position(range.endLineNumber, range.endColumn);
    }
    getStartPosition() {
      return Range.getStartPosition(this);
    }
    static getStartPosition(range) {
      return new Position(range.startLineNumber, range.startColumn);
    }
    toString() {
      return "[" + this.startLineNumber + "," + this.startColumn + " -> " + this.endLineNumber + "," + this.endColumn + "]";
    }
    setEndPosition(endLineNumber, endColumn) {
      return new Range(this.startLineNumber, this.startColumn, endLineNumber, endColumn);
    }
    setStartPosition(startLineNumber, startColumn) {
      return new Range(startLineNumber, startColumn, this.endLineNumber, this.endColumn);
    }
    collapseToStart() {
      return Range.collapseToStart(this);
    }
    static collapseToStart(range) {
      return new Range(range.startLineNumber, range.startColumn, range.startLineNumber, range.startColumn);
    }
    static fromPositions(start, end = start) {
      return new Range(start.lineNumber, start.column, end.lineNumber, end.column);
    }
    static lift(range) {
      if (!range) {
        return null;
      }
      return new Range(range.startLineNumber, range.startColumn, range.endLineNumber, range.endColumn);
    }
    static isIRange(obj) {
      return obj && typeof obj.startLineNumber === "number" && typeof obj.startColumn === "number" && typeof obj.endLineNumber === "number" && typeof obj.endColumn === "number";
    }
    static areIntersectingOrTouching(a, b) {
      if (a.endLineNumber < b.startLineNumber || a.endLineNumber === b.startLineNumber && a.endColumn < b.startColumn) {
        return false;
      }
      if (b.endLineNumber < a.startLineNumber || b.endLineNumber === a.startLineNumber && b.endColumn < a.startColumn) {
        return false;
      }
      return true;
    }
    static areIntersecting(a, b) {
      if (a.endLineNumber < b.startLineNumber || a.endLineNumber === b.startLineNumber && a.endColumn <= b.startColumn) {
        return false;
      }
      if (b.endLineNumber < a.startLineNumber || b.endLineNumber === a.startLineNumber && b.endColumn <= a.startColumn) {
        return false;
      }
      return true;
    }
    static compareRangesUsingStarts(a, b) {
      if (a && b) {
        const aStartLineNumber = a.startLineNumber | 0;
        const bStartLineNumber = b.startLineNumber | 0;
        if (aStartLineNumber === bStartLineNumber) {
          const aStartColumn = a.startColumn | 0;
          const bStartColumn = b.startColumn | 0;
          if (aStartColumn === bStartColumn) {
            const aEndLineNumber = a.endLineNumber | 0;
            const bEndLineNumber = b.endLineNumber | 0;
            if (aEndLineNumber === bEndLineNumber) {
              const aEndColumn = a.endColumn | 0;
              const bEndColumn = b.endColumn | 0;
              return aEndColumn - bEndColumn;
            }
            return aEndLineNumber - bEndLineNumber;
          }
          return aStartColumn - bStartColumn;
        }
        return aStartLineNumber - bStartLineNumber;
      }
      const aExists = a ? 1 : 0;
      const bExists = b ? 1 : 0;
      return aExists - bExists;
    }
    static compareRangesUsingEnds(a, b) {
      if (a.endLineNumber === b.endLineNumber) {
        if (a.endColumn === b.endColumn) {
          if (a.startLineNumber === b.startLineNumber) {
            return a.startColumn - b.startColumn;
          }
          return a.startLineNumber - b.startLineNumber;
        }
        return a.endColumn - b.endColumn;
      }
      return a.endLineNumber - b.endLineNumber;
    }
    static spansMultipleLines(range) {
      return range.endLineNumber > range.startLineNumber;
    }
    toJSON() {
      return this;
    }
  };

  // node_modules/monaco-editor/esm/vs/editor/common/diff/diffComputer.js
  var MINIMUM_MATCHING_CHARACTER_LENGTH = 3;
  function computeDiff(originalSequence, modifiedSequence, continueProcessingPredicate, pretty) {
    const diffAlgo = new LcsDiff(originalSequence, modifiedSequence, continueProcessingPredicate);
    return diffAlgo.ComputeDiff(pretty);
  }
  var LineSequence = class {
    constructor(lines) {
      const startColumns = [];
      const endColumns = [];
      for (let i = 0, length = lines.length; i < length; i++) {
        startColumns[i] = getFirstNonBlankColumn(lines[i], 1);
        endColumns[i] = getLastNonBlankColumn(lines[i], 1);
      }
      this.lines = lines;
      this._startColumns = startColumns;
      this._endColumns = endColumns;
    }
    getElements() {
      const elements = [];
      for (let i = 0, len = this.lines.length; i < len; i++) {
        elements[i] = this.lines[i].substring(this._startColumns[i] - 1, this._endColumns[i] - 1);
      }
      return elements;
    }
    getStrictElement(index) {
      return this.lines[index];
    }
    getStartLineNumber(i) {
      return i + 1;
    }
    getEndLineNumber(i) {
      return i + 1;
    }
    createCharSequence(shouldIgnoreTrimWhitespace, startIndex, endIndex) {
      const charCodes = [];
      const lineNumbers = [];
      const columns = [];
      let len = 0;
      for (let index = startIndex; index <= endIndex; index++) {
        const lineContent = this.lines[index];
        const startColumn = shouldIgnoreTrimWhitespace ? this._startColumns[index] : 1;
        const endColumn = shouldIgnoreTrimWhitespace ? this._endColumns[index] : lineContent.length + 1;
        for (let col = startColumn; col < endColumn; col++) {
          charCodes[len] = lineContent.charCodeAt(col - 1);
          lineNumbers[len] = index + 1;
          columns[len] = col;
          len++;
        }
      }
      return new CharSequence(charCodes, lineNumbers, columns);
    }
  };
  var CharSequence = class {
    constructor(charCodes, lineNumbers, columns) {
      this._charCodes = charCodes;
      this._lineNumbers = lineNumbers;
      this._columns = columns;
    }
    getElements() {
      return this._charCodes;
    }
    getStartLineNumber(i) {
      return this._lineNumbers[i];
    }
    getStartColumn(i) {
      return this._columns[i];
    }
    getEndLineNumber(i) {
      return this._lineNumbers[i];
    }
    getEndColumn(i) {
      return this._columns[i] + 1;
    }
  };
  var CharChange = class {
    constructor(originalStartLineNumber, originalStartColumn, originalEndLineNumber, originalEndColumn, modifiedStartLineNumber, modifiedStartColumn, modifiedEndLineNumber, modifiedEndColumn) {
      this.originalStartLineNumber = originalStartLineNumber;
      this.originalStartColumn = originalStartColumn;
      this.originalEndLineNumber = originalEndLineNumber;
      this.originalEndColumn = originalEndColumn;
      this.modifiedStartLineNumber = modifiedStartLineNumber;
      this.modifiedStartColumn = modifiedStartColumn;
      this.modifiedEndLineNumber = modifiedEndLineNumber;
      this.modifiedEndColumn = modifiedEndColumn;
    }
    static createFromDiffChange(diffChange, originalCharSequence, modifiedCharSequence) {
      let originalStartLineNumber;
      let originalStartColumn;
      let originalEndLineNumber;
      let originalEndColumn;
      let modifiedStartLineNumber;
      let modifiedStartColumn;
      let modifiedEndLineNumber;
      let modifiedEndColumn;
      if (diffChange.originalLength === 0) {
        originalStartLineNumber = 0;
        originalStartColumn = 0;
        originalEndLineNumber = 0;
        originalEndColumn = 0;
      } else {
        originalStartLineNumber = originalCharSequence.getStartLineNumber(diffChange.originalStart);
        originalStartColumn = originalCharSequence.getStartColumn(diffChange.originalStart);
        originalEndLineNumber = originalCharSequence.getEndLineNumber(diffChange.originalStart + diffChange.originalLength - 1);
        originalEndColumn = originalCharSequence.getEndColumn(diffChange.originalStart + diffChange.originalLength - 1);
      }
      if (diffChange.modifiedLength === 0) {
        modifiedStartLineNumber = 0;
        modifiedStartColumn = 0;
        modifiedEndLineNumber = 0;
        modifiedEndColumn = 0;
      } else {
        modifiedStartLineNumber = modifiedCharSequence.getStartLineNumber(diffChange.modifiedStart);
        modifiedStartColumn = modifiedCharSequence.getStartColumn(diffChange.modifiedStart);
        modifiedEndLineNumber = modifiedCharSequence.getEndLineNumber(diffChange.modifiedStart + diffChange.modifiedLength - 1);
        modifiedEndColumn = modifiedCharSequence.getEndColumn(diffChange.modifiedStart + diffChange.modifiedLength - 1);
      }
      return new CharChange(originalStartLineNumber, originalStartColumn, originalEndLineNumber, originalEndColumn, modifiedStartLineNumber, modifiedStartColumn, modifiedEndLineNumber, modifiedEndColumn);
    }
  };
  function postProcessCharChanges(rawChanges) {
    if (rawChanges.length <= 1) {
      return rawChanges;
    }
    const result = [rawChanges[0]];
    let prevChange = result[0];
    for (let i = 1, len = rawChanges.length; i < len; i++) {
      const currChange = rawChanges[i];
      const originalMatchingLength = currChange.originalStart - (prevChange.originalStart + prevChange.originalLength);
      const modifiedMatchingLength = currChange.modifiedStart - (prevChange.modifiedStart + prevChange.modifiedLength);
      const matchingLength = Math.min(originalMatchingLength, modifiedMatchingLength);
      if (matchingLength < MINIMUM_MATCHING_CHARACTER_LENGTH) {
        prevChange.originalLength = currChange.originalStart + currChange.originalLength - prevChange.originalStart;
        prevChange.modifiedLength = currChange.modifiedStart + currChange.modifiedLength - prevChange.modifiedStart;
      } else {
        result.push(currChange);
        prevChange = currChange;
      }
    }
    return result;
  }
  var LineChange = class {
    constructor(originalStartLineNumber, originalEndLineNumber, modifiedStartLineNumber, modifiedEndLineNumber, charChanges) {
      this.originalStartLineNumber = originalStartLineNumber;
      this.originalEndLineNumber = originalEndLineNumber;
      this.modifiedStartLineNumber = modifiedStartLineNumber;
      this.modifiedEndLineNumber = modifiedEndLineNumber;
      this.charChanges = charChanges;
    }
    static createFromDiffResult(shouldIgnoreTrimWhitespace, diffChange, originalLineSequence, modifiedLineSequence, continueCharDiff, shouldComputeCharChanges, shouldPostProcessCharChanges) {
      let originalStartLineNumber;
      let originalEndLineNumber;
      let modifiedStartLineNumber;
      let modifiedEndLineNumber;
      let charChanges = void 0;
      if (diffChange.originalLength === 0) {
        originalStartLineNumber = originalLineSequence.getStartLineNumber(diffChange.originalStart) - 1;
        originalEndLineNumber = 0;
      } else {
        originalStartLineNumber = originalLineSequence.getStartLineNumber(diffChange.originalStart);
        originalEndLineNumber = originalLineSequence.getEndLineNumber(diffChange.originalStart + diffChange.originalLength - 1);
      }
      if (diffChange.modifiedLength === 0) {
        modifiedStartLineNumber = modifiedLineSequence.getStartLineNumber(diffChange.modifiedStart) - 1;
        modifiedEndLineNumber = 0;
      } else {
        modifiedStartLineNumber = modifiedLineSequence.getStartLineNumber(diffChange.modifiedStart);
        modifiedEndLineNumber = modifiedLineSequence.getEndLineNumber(diffChange.modifiedStart + diffChange.modifiedLength - 1);
      }
      if (shouldComputeCharChanges && diffChange.originalLength > 0 && diffChange.originalLength < 20 && diffChange.modifiedLength > 0 && diffChange.modifiedLength < 20 && continueCharDiff()) {
        const originalCharSequence = originalLineSequence.createCharSequence(shouldIgnoreTrimWhitespace, diffChange.originalStart, diffChange.originalStart + diffChange.originalLength - 1);
        const modifiedCharSequence = modifiedLineSequence.createCharSequence(shouldIgnoreTrimWhitespace, diffChange.modifiedStart, diffChange.modifiedStart + diffChange.modifiedLength - 1);
        let rawChanges = computeDiff(originalCharSequence, modifiedCharSequence, continueCharDiff, true).changes;
        if (shouldPostProcessCharChanges) {
          rawChanges = postProcessCharChanges(rawChanges);
        }
        charChanges = [];
        for (let i = 0, length = rawChanges.length; i < length; i++) {
          charChanges.push(CharChange.createFromDiffChange(rawChanges[i], originalCharSequence, modifiedCharSequence));
        }
      }
      return new LineChange(originalStartLineNumber, originalEndLineNumber, modifiedStartLineNumber, modifiedEndLineNumber, charChanges);
    }
  };
  var DiffComputer = class {
    constructor(originalLines, modifiedLines, opts) {
      this.shouldComputeCharChanges = opts.shouldComputeCharChanges;
      this.shouldPostProcessCharChanges = opts.shouldPostProcessCharChanges;
      this.shouldIgnoreTrimWhitespace = opts.shouldIgnoreTrimWhitespace;
      this.shouldMakePrettyDiff = opts.shouldMakePrettyDiff;
      this.originalLines = originalLines;
      this.modifiedLines = modifiedLines;
      this.original = new LineSequence(originalLines);
      this.modified = new LineSequence(modifiedLines);
      this.continueLineDiff = createContinueProcessingPredicate(opts.maxComputationTime);
      this.continueCharDiff = createContinueProcessingPredicate(opts.maxComputationTime === 0 ? 0 : Math.min(opts.maxComputationTime, 5e3));
    }
    computeDiff() {
      if (this.original.lines.length === 1 && this.original.lines[0].length === 0) {
        if (this.modified.lines.length === 1 && this.modified.lines[0].length === 0) {
          return {
            quitEarly: false,
            changes: []
          };
        }
        return {
          quitEarly: false,
          changes: [{
            originalStartLineNumber: 1,
            originalEndLineNumber: 1,
            modifiedStartLineNumber: 1,
            modifiedEndLineNumber: this.modified.lines.length,
            charChanges: [{
              modifiedEndColumn: 0,
              modifiedEndLineNumber: 0,
              modifiedStartColumn: 0,
              modifiedStartLineNumber: 0,
              originalEndColumn: 0,
              originalEndLineNumber: 0,
              originalStartColumn: 0,
              originalStartLineNumber: 0
            }]
          }]
        };
      }
      if (this.modified.lines.length === 1 && this.modified.lines[0].length === 0) {
        return {
          quitEarly: false,
          changes: [{
            originalStartLineNumber: 1,
            originalEndLineNumber: this.original.lines.length,
            modifiedStartLineNumber: 1,
            modifiedEndLineNumber: 1,
            charChanges: [{
              modifiedEndColumn: 0,
              modifiedEndLineNumber: 0,
              modifiedStartColumn: 0,
              modifiedStartLineNumber: 0,
              originalEndColumn: 0,
              originalEndLineNumber: 0,
              originalStartColumn: 0,
              originalStartLineNumber: 0
            }]
          }]
        };
      }
      const diffResult = computeDiff(this.original, this.modified, this.continueLineDiff, this.shouldMakePrettyDiff);
      const rawChanges = diffResult.changes;
      const quitEarly = diffResult.quitEarly;
      if (this.shouldIgnoreTrimWhitespace) {
        const lineChanges = [];
        for (let i = 0, length = rawChanges.length; i < length; i++) {
          lineChanges.push(LineChange.createFromDiffResult(this.shouldIgnoreTrimWhitespace, rawChanges[i], this.original, this.modified, this.continueCharDiff, this.shouldComputeCharChanges, this.shouldPostProcessCharChanges));
        }
        return {
          quitEarly,
          changes: lineChanges
        };
      }
      const result = [];
      let originalLineIndex = 0;
      let modifiedLineIndex = 0;
      for (let i = -1, len = rawChanges.length; i < len; i++) {
        const nextChange = i + 1 < len ? rawChanges[i + 1] : null;
        const originalStop = nextChange ? nextChange.originalStart : this.originalLines.length;
        const modifiedStop = nextChange ? nextChange.modifiedStart : this.modifiedLines.length;
        while (originalLineIndex < originalStop && modifiedLineIndex < modifiedStop) {
          const originalLine = this.originalLines[originalLineIndex];
          const modifiedLine = this.modifiedLines[modifiedLineIndex];
          if (originalLine !== modifiedLine) {
            {
              let originalStartColumn = getFirstNonBlankColumn(originalLine, 1);
              let modifiedStartColumn = getFirstNonBlankColumn(modifiedLine, 1);
              while (originalStartColumn > 1 && modifiedStartColumn > 1) {
                const originalChar = originalLine.charCodeAt(originalStartColumn - 2);
                const modifiedChar = modifiedLine.charCodeAt(modifiedStartColumn - 2);
                if (originalChar !== modifiedChar) {
                  break;
                }
                originalStartColumn--;
                modifiedStartColumn--;
              }
              if (originalStartColumn > 1 || modifiedStartColumn > 1) {
                this._pushTrimWhitespaceCharChange(result, originalLineIndex + 1, 1, originalStartColumn, modifiedLineIndex + 1, 1, modifiedStartColumn);
              }
            }
            {
              let originalEndColumn = getLastNonBlankColumn(originalLine, 1);
              let modifiedEndColumn = getLastNonBlankColumn(modifiedLine, 1);
              const originalMaxColumn = originalLine.length + 1;
              const modifiedMaxColumn = modifiedLine.length + 1;
              while (originalEndColumn < originalMaxColumn && modifiedEndColumn < modifiedMaxColumn) {
                const originalChar = originalLine.charCodeAt(originalEndColumn - 1);
                const modifiedChar = originalLine.charCodeAt(modifiedEndColumn - 1);
                if (originalChar !== modifiedChar) {
                  break;
                }
                originalEndColumn++;
                modifiedEndColumn++;
              }
              if (originalEndColumn < originalMaxColumn || modifiedEndColumn < modifiedMaxColumn) {
                this._pushTrimWhitespaceCharChange(result, originalLineIndex + 1, originalEndColumn, originalMaxColumn, modifiedLineIndex + 1, modifiedEndColumn, modifiedMaxColumn);
              }
            }
          }
          originalLineIndex++;
          modifiedLineIndex++;
        }
        if (nextChange) {
          result.push(LineChange.createFromDiffResult(this.shouldIgnoreTrimWhitespace, nextChange, this.original, this.modified, this.continueCharDiff, this.shouldComputeCharChanges, this.shouldPostProcessCharChanges));
          originalLineIndex += nextChange.originalLength;
          modifiedLineIndex += nextChange.modifiedLength;
        }
      }
      return {
        quitEarly,
        changes: result
      };
    }
    _pushTrimWhitespaceCharChange(result, originalLineNumber, originalStartColumn, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedEndColumn) {
      if (this._mergeTrimWhitespaceCharChange(result, originalLineNumber, originalStartColumn, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedEndColumn)) {
        return;
      }
      let charChanges = void 0;
      if (this.shouldComputeCharChanges) {
        charChanges = [new CharChange(originalLineNumber, originalStartColumn, originalLineNumber, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedLineNumber, modifiedEndColumn)];
      }
      result.push(new LineChange(originalLineNumber, originalLineNumber, modifiedLineNumber, modifiedLineNumber, charChanges));
    }
    _mergeTrimWhitespaceCharChange(result, originalLineNumber, originalStartColumn, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedEndColumn) {
      const len = result.length;
      if (len === 0) {
        return false;
      }
      const prevChange = result[len - 1];
      if (prevChange.originalEndLineNumber === 0 || prevChange.modifiedEndLineNumber === 0) {
        return false;
      }
      if (prevChange.originalEndLineNumber + 1 === originalLineNumber && prevChange.modifiedEndLineNumber + 1 === modifiedLineNumber) {
        prevChange.originalEndLineNumber = originalLineNumber;
        prevChange.modifiedEndLineNumber = modifiedLineNumber;
        if (this.shouldComputeCharChanges && prevChange.charChanges) {
          prevChange.charChanges.push(new CharChange(originalLineNumber, originalStartColumn, originalLineNumber, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedLineNumber, modifiedEndColumn));
        }
        return true;
      }
      return false;
    }
  };
  function getFirstNonBlankColumn(txt, defaultValue) {
    const r = firstNonWhitespaceIndex(txt);
    if (r === -1) {
      return defaultValue;
    }
    return r + 1;
  }
  function getLastNonBlankColumn(txt, defaultValue) {
    const r = lastNonWhitespaceIndex(txt);
    if (r === -1) {
      return defaultValue;
    }
    return r + 2;
  }
  function createContinueProcessingPredicate(maximumRuntime) {
    if (maximumRuntime === 0) {
      return () => true;
    }
    const startTime = Date.now();
    return () => {
      return Date.now() - startTime < maximumRuntime;
    };
  }

  // node_modules/monaco-editor/esm/vs/base/common/uint.js
  function toUint8(v) {
    if (v < 0) {
      return 0;
    }
    if (v > 255) {
      return 255;
    }
    return v | 0;
  }
  function toUint32(v) {
    if (v < 0) {
      return 0;
    }
    if (v > 4294967295) {
      return 4294967295;
    }
    return v | 0;
  }

  // node_modules/monaco-editor/esm/vs/editor/common/model/prefixSumComputer.js
  var PrefixSumComputer = class {
    constructor(values) {
      this.values = values;
      this.prefixSum = new Uint32Array(values.length);
      this.prefixSumValidIndex = new Int32Array(1);
      this.prefixSumValidIndex[0] = -1;
    }
    insertValues(insertIndex, insertValues) {
      insertIndex = toUint32(insertIndex);
      const oldValues = this.values;
      const oldPrefixSum = this.prefixSum;
      const insertValuesLen = insertValues.length;
      if (insertValuesLen === 0) {
        return false;
      }
      this.values = new Uint32Array(oldValues.length + insertValuesLen);
      this.values.set(oldValues.subarray(0, insertIndex), 0);
      this.values.set(oldValues.subarray(insertIndex), insertIndex + insertValuesLen);
      this.values.set(insertValues, insertIndex);
      if (insertIndex - 1 < this.prefixSumValidIndex[0]) {
        this.prefixSumValidIndex[0] = insertIndex - 1;
      }
      this.prefixSum = new Uint32Array(this.values.length);
      if (this.prefixSumValidIndex[0] >= 0) {
        this.prefixSum.set(oldPrefixSum.subarray(0, this.prefixSumValidIndex[0] + 1));
      }
      return true;
    }
    setValue(index, value) {
      index = toUint32(index);
      value = toUint32(value);
      if (this.values[index] === value) {
        return false;
      }
      this.values[index] = value;
      if (index - 1 < this.prefixSumValidIndex[0]) {
        this.prefixSumValidIndex[0] = index - 1;
      }
      return true;
    }
    removeValues(startIndex, count) {
      startIndex = toUint32(startIndex);
      count = toUint32(count);
      const oldValues = this.values;
      const oldPrefixSum = this.prefixSum;
      if (startIndex >= oldValues.length) {
        return false;
      }
      const maxCount = oldValues.length - startIndex;
      if (count >= maxCount) {
        count = maxCount;
      }
      if (count === 0) {
        return false;
      }
      this.values = new Uint32Array(oldValues.length - count);
      this.values.set(oldValues.subarray(0, startIndex), 0);
      this.values.set(oldValues.subarray(startIndex + count), startIndex);
      this.prefixSum = new Uint32Array(this.values.length);
      if (startIndex - 1 < this.prefixSumValidIndex[0]) {
        this.prefixSumValidIndex[0] = startIndex - 1;
      }
      if (this.prefixSumValidIndex[0] >= 0) {
        this.prefixSum.set(oldPrefixSum.subarray(0, this.prefixSumValidIndex[0] + 1));
      }
      return true;
    }
    getTotalSum() {
      if (this.values.length === 0) {
        return 0;
      }
      return this._getPrefixSum(this.values.length - 1);
    }
    getPrefixSum(index) {
      if (index < 0) {
        return 0;
      }
      index = toUint32(index);
      return this._getPrefixSum(index);
    }
    _getPrefixSum(index) {
      if (index <= this.prefixSumValidIndex[0]) {
        return this.prefixSum[index];
      }
      let startIndex = this.prefixSumValidIndex[0] + 1;
      if (startIndex === 0) {
        this.prefixSum[0] = this.values[0];
        startIndex++;
      }
      if (index >= this.values.length) {
        index = this.values.length - 1;
      }
      for (let i = startIndex; i <= index; i++) {
        this.prefixSum[i] = this.prefixSum[i - 1] + this.values[i];
      }
      this.prefixSumValidIndex[0] = Math.max(this.prefixSumValidIndex[0], index);
      return this.prefixSum[index];
    }
    getIndexOf(sum) {
      sum = Math.floor(sum);
      this.getTotalSum();
      let low = 0;
      let high = this.values.length - 1;
      let mid = 0;
      let midStop = 0;
      let midStart = 0;
      while (low <= high) {
        mid = low + (high - low) / 2 | 0;
        midStop = this.prefixSum[mid];
        midStart = midStop - this.values[mid];
        if (sum < midStart) {
          high = mid - 1;
        } else if (sum >= midStop) {
          low = mid + 1;
        } else {
          break;
        }
      }
      return new PrefixSumIndexOfResult(mid, sum - midStart);
    }
  };
  var PrefixSumIndexOfResult = class {
    constructor(index, remainder) {
      this.index = index;
      this.remainder = remainder;
      this._prefixSumIndexOfResultBrand = void 0;
      this.index = index;
      this.remainder = remainder;
    }
  };

  // node_modules/monaco-editor/esm/vs/editor/common/model/mirrorTextModel.js
  var MirrorTextModel = class {
    constructor(uri, lines, eol, versionId) {
      this._uri = uri;
      this._lines = lines;
      this._eol = eol;
      this._versionId = versionId;
      this._lineStarts = null;
      this._cachedTextValue = null;
    }
    dispose() {
      this._lines.length = 0;
    }
    get version() {
      return this._versionId;
    }
    getText() {
      if (this._cachedTextValue === null) {
        this._cachedTextValue = this._lines.join(this._eol);
      }
      return this._cachedTextValue;
    }
    onEvents(e) {
      if (e.eol && e.eol !== this._eol) {
        this._eol = e.eol;
        this._lineStarts = null;
      }
      const changes = e.changes;
      for (const change of changes) {
        this._acceptDeleteRange(change.range);
        this._acceptInsertText(new Position(change.range.startLineNumber, change.range.startColumn), change.text);
      }
      this._versionId = e.versionId;
      this._cachedTextValue = null;
    }
    _ensureLineStarts() {
      if (!this._lineStarts) {
        const eolLength = this._eol.length;
        const linesLength = this._lines.length;
        const lineStartValues = new Uint32Array(linesLength);
        for (let i = 0; i < linesLength; i++) {
          lineStartValues[i] = this._lines[i].length + eolLength;
        }
        this._lineStarts = new PrefixSumComputer(lineStartValues);
      }
    }
    _setLineText(lineIndex, newValue) {
      this._lines[lineIndex] = newValue;
      if (this._lineStarts) {
        this._lineStarts.setValue(lineIndex, this._lines[lineIndex].length + this._eol.length);
      }
    }
    _acceptDeleteRange(range) {
      if (range.startLineNumber === range.endLineNumber) {
        if (range.startColumn === range.endColumn) {
          return;
        }
        this._setLineText(range.startLineNumber - 1, this._lines[range.startLineNumber - 1].substring(0, range.startColumn - 1) + this._lines[range.startLineNumber - 1].substring(range.endColumn - 1));
        return;
      }
      this._setLineText(range.startLineNumber - 1, this._lines[range.startLineNumber - 1].substring(0, range.startColumn - 1) + this._lines[range.endLineNumber - 1].substring(range.endColumn - 1));
      this._lines.splice(range.startLineNumber, range.endLineNumber - range.startLineNumber);
      if (this._lineStarts) {
        this._lineStarts.removeValues(range.startLineNumber, range.endLineNumber - range.startLineNumber);
      }
    }
    _acceptInsertText(position, insertText) {
      if (insertText.length === 0) {
        return;
      }
      const insertLines = splitLines(insertText);
      if (insertLines.length === 1) {
        this._setLineText(position.lineNumber - 1, this._lines[position.lineNumber - 1].substring(0, position.column - 1) + insertLines[0] + this._lines[position.lineNumber - 1].substring(position.column - 1));
        return;
      }
      insertLines[insertLines.length - 1] += this._lines[position.lineNumber - 1].substring(position.column - 1);
      this._setLineText(position.lineNumber - 1, this._lines[position.lineNumber - 1].substring(0, position.column - 1) + insertLines[0]);
      const newLengths = new Uint32Array(insertLines.length - 1);
      for (let i = 1; i < insertLines.length; i++) {
        this._lines.splice(position.lineNumber + i - 1, 0, insertLines[i]);
        newLengths[i - 1] = insertLines[i].length + this._eol.length;
      }
      if (this._lineStarts) {
        this._lineStarts.insertValues(position.lineNumber, newLengths);
      }
    }
  };

  // node_modules/monaco-editor/esm/vs/editor/common/core/wordHelper.js
  var USUAL_WORD_SEPARATORS = "`~!@#$%^&*()-=+[{]}\\|;:'\",.<>/?";
  function createWordRegExp(allowInWords = "") {
    let source = "(-?\\d*\\.\\d\\w*)|([^";
    for (const sep2 of USUAL_WORD_SEPARATORS) {
      if (allowInWords.indexOf(sep2) >= 0) {
        continue;
      }
      source += "\\" + sep2;
    }
    source += "\\s]+)";
    return new RegExp(source, "g");
  }
  var DEFAULT_WORD_REGEXP = createWordRegExp();
  function ensureValidWordDefinition(wordDefinition) {
    let result = DEFAULT_WORD_REGEXP;
    if (wordDefinition && wordDefinition instanceof RegExp) {
      if (!wordDefinition.global) {
        let flags = "g";
        if (wordDefinition.ignoreCase) {
          flags += "i";
        }
        if (wordDefinition.multiline) {
          flags += "m";
        }
        if (wordDefinition.unicode) {
          flags += "u";
        }
        result = new RegExp(wordDefinition.source, flags);
      } else {
        result = wordDefinition;
      }
    }
    result.lastIndex = 0;
    return result;
  }
  var _defaultConfig = {
    maxLen: 1e3,
    windowSize: 15,
    timeBudget: 150
  };
  function getWordAtText(column, wordDefinition, text, textOffset, config = _defaultConfig) {
    if (text.length > config.maxLen) {
      let start = column - config.maxLen / 2;
      if (start < 0) {
        start = 0;
      } else {
        textOffset += start;
      }
      text = text.substring(start, column + config.maxLen / 2);
      return getWordAtText(column, wordDefinition, text, textOffset, config);
    }
    const t1 = Date.now();
    const pos = column - 1 - textOffset;
    let prevRegexIndex = -1;
    let match = null;
    for (let i = 1; ; i++) {
      if (Date.now() - t1 >= config.timeBudget) {
        break;
      }
      const regexIndex = pos - config.windowSize * i;
      wordDefinition.lastIndex = Math.max(0, regexIndex);
      const thisMatch = _findRegexMatchEnclosingPosition(wordDefinition, text, pos, prevRegexIndex);
      if (!thisMatch && match) {
        break;
      }
      match = thisMatch;
      if (regexIndex <= 0) {
        break;
      }
      prevRegexIndex = regexIndex;
    }
    if (match) {
      const result = {
        word: match[0],
        startColumn: textOffset + 1 + match.index,
        endColumn: textOffset + 1 + match.index + match[0].length
      };
      wordDefinition.lastIndex = 0;
      return result;
    }
    return null;
  }
  function _findRegexMatchEnclosingPosition(wordDefinition, text, pos, stopPos) {
    let match;
    while (match = wordDefinition.exec(text)) {
      const matchIndex = match.index || 0;
      if (matchIndex <= pos && wordDefinition.lastIndex >= pos) {
        return match;
      } else if (stopPos > 0 && matchIndex > stopPos) {
        return null;
      }
    }
    return null;
  }

  // node_modules/monaco-editor/esm/vs/editor/common/core/characterClassifier.js
  var CharacterClassifier = class {
    constructor(_defaultValue) {
      const defaultValue = toUint8(_defaultValue);
      this._defaultValue = defaultValue;
      this._asciiMap = CharacterClassifier._createAsciiMap(defaultValue);
      this._map = new Map();
    }
    static _createAsciiMap(defaultValue) {
      const asciiMap = new Uint8Array(256);
      for (let i = 0; i < 256; i++) {
        asciiMap[i] = defaultValue;
      }
      return asciiMap;
    }
    set(charCode, _value) {
      const value = toUint8(_value);
      if (charCode >= 0 && charCode < 256) {
        this._asciiMap[charCode] = value;
      } else {
        this._map.set(charCode, value);
      }
    }
    get(charCode) {
      if (charCode >= 0 && charCode < 256) {
        return this._asciiMap[charCode];
      } else {
        return this._map.get(charCode) || this._defaultValue;
      }
    }
  };

  // node_modules/monaco-editor/esm/vs/editor/common/languages/linkComputer.js
  var Uint8Matrix = class {
    constructor(rows, cols, defaultValue) {
      const data = new Uint8Array(rows * cols);
      for (let i = 0, len = rows * cols; i < len; i++) {
        data[i] = defaultValue;
      }
      this._data = data;
      this.rows = rows;
      this.cols = cols;
    }
    get(row, col) {
      return this._data[row * this.cols + col];
    }
    set(row, col, value) {
      this._data[row * this.cols + col] = value;
    }
  };
  var StateMachine = class {
    constructor(edges) {
      let maxCharCode = 0;
      let maxState = 0;
      for (let i = 0, len = edges.length; i < len; i++) {
        const [from, chCode, to] = edges[i];
        if (chCode > maxCharCode) {
          maxCharCode = chCode;
        }
        if (from > maxState) {
          maxState = from;
        }
        if (to > maxState) {
          maxState = to;
        }
      }
      maxCharCode++;
      maxState++;
      const states = new Uint8Matrix(maxState, maxCharCode, 0);
      for (let i = 0, len = edges.length; i < len; i++) {
        const [from, chCode, to] = edges[i];
        states.set(from, chCode, to);
      }
      this._states = states;
      this._maxCharCode = maxCharCode;
    }
    nextState(currentState, chCode) {
      if (chCode < 0 || chCode >= this._maxCharCode) {
        return 0;
      }
      return this._states.get(currentState, chCode);
    }
  };
  var _stateMachine = null;
  function getStateMachine() {
    if (_stateMachine === null) {
      _stateMachine = new StateMachine([
        [1, 104, 2],
        [1, 72, 2],
        [1, 102, 6],
        [1, 70, 6],
        [2, 116, 3],
        [2, 84, 3],
        [3, 116, 4],
        [3, 84, 4],
        [4, 112, 5],
        [4, 80, 5],
        [5, 115, 9],
        [5, 83, 9],
        [5, 58, 10],
        [6, 105, 7],
        [6, 73, 7],
        [7, 108, 8],
        [7, 76, 8],
        [8, 101, 9],
        [8, 69, 9],
        [9, 58, 10],
        [10, 47, 11],
        [11, 47, 12]
      ]);
    }
    return _stateMachine;
  }
  var _classifier = null;
  function getClassifier() {
    if (_classifier === null) {
      _classifier = new CharacterClassifier(0);
      const FORCE_TERMINATION_CHARACTERS = ` 	<>'"\u3001\u3002\uFF61\uFF64\uFF0C\uFF0E\uFF1A\uFF1B\u2018\u3008\u300C\u300E\u3014\uFF08\uFF3B\uFF5B\uFF62\uFF63\uFF5D\uFF3D\uFF09\u3015\u300F\u300D\u3009\u2019\uFF40\uFF5E\u2026`;
      for (let i = 0; i < FORCE_TERMINATION_CHARACTERS.length; i++) {
        _classifier.set(FORCE_TERMINATION_CHARACTERS.charCodeAt(i), 1);
      }
      const CANNOT_END_WITH_CHARACTERS = ".,;";
      for (let i = 0; i < CANNOT_END_WITH_CHARACTERS.length; i++) {
        _classifier.set(CANNOT_END_WITH_CHARACTERS.charCodeAt(i), 2);
      }
    }
    return _classifier;
  }
  var LinkComputer = class {
    static _createLink(classifier, line, lineNumber, linkBeginIndex, linkEndIndex) {
      let lastIncludedCharIndex = linkEndIndex - 1;
      do {
        const chCode = line.charCodeAt(lastIncludedCharIndex);
        const chClass = classifier.get(chCode);
        if (chClass !== 2) {
          break;
        }
        lastIncludedCharIndex--;
      } while (lastIncludedCharIndex > linkBeginIndex);
      if (linkBeginIndex > 0) {
        const charCodeBeforeLink = line.charCodeAt(linkBeginIndex - 1);
        const lastCharCodeInLink = line.charCodeAt(lastIncludedCharIndex);
        if (charCodeBeforeLink === 40 && lastCharCodeInLink === 41 || charCodeBeforeLink === 91 && lastCharCodeInLink === 93 || charCodeBeforeLink === 123 && lastCharCodeInLink === 125) {
          lastIncludedCharIndex--;
        }
      }
      return {
        range: {
          startLineNumber: lineNumber,
          startColumn: linkBeginIndex + 1,
          endLineNumber: lineNumber,
          endColumn: lastIncludedCharIndex + 2
        },
        url: line.substring(linkBeginIndex, lastIncludedCharIndex + 1)
      };
    }
    static computeLinks(model, stateMachine = getStateMachine()) {
      const classifier = getClassifier();
      const result = [];
      for (let i = 1, lineCount = model.getLineCount(); i <= lineCount; i++) {
        const line = model.getLineContent(i);
        const len = line.length;
        let j = 0;
        let linkBeginIndex = 0;
        let linkBeginChCode = 0;
        let state = 1;
        let hasOpenParens = false;
        let hasOpenSquareBracket = false;
        let inSquareBrackets = false;
        let hasOpenCurlyBracket = false;
        while (j < len) {
          let resetStateMachine = false;
          const chCode = line.charCodeAt(j);
          if (state === 13) {
            let chClass;
            switch (chCode) {
              case 40:
                hasOpenParens = true;
                chClass = 0;
                break;
              case 41:
                chClass = hasOpenParens ? 0 : 1;
                break;
              case 91:
                inSquareBrackets = true;
                hasOpenSquareBracket = true;
                chClass = 0;
                break;
              case 93:
                inSquareBrackets = false;
                chClass = hasOpenSquareBracket ? 0 : 1;
                break;
              case 123:
                hasOpenCurlyBracket = true;
                chClass = 0;
                break;
              case 125:
                chClass = hasOpenCurlyBracket ? 0 : 1;
                break;
              case 39:
                chClass = linkBeginChCode === 34 || linkBeginChCode === 96 ? 0 : 1;
                break;
              case 34:
                chClass = linkBeginChCode === 39 || linkBeginChCode === 96 ? 0 : 1;
                break;
              case 96:
                chClass = linkBeginChCode === 39 || linkBeginChCode === 34 ? 0 : 1;
                break;
              case 42:
                chClass = linkBeginChCode === 42 ? 1 : 0;
                break;
              case 124:
                chClass = linkBeginChCode === 124 ? 1 : 0;
                break;
              case 32:
                chClass = inSquareBrackets ? 0 : 1;
                break;
              default:
                chClass = classifier.get(chCode);
            }
            if (chClass === 1) {
              result.push(LinkComputer._createLink(classifier, line, i, linkBeginIndex, j));
              resetStateMachine = true;
            }
          } else if (state === 12) {
            let chClass;
            if (chCode === 91) {
              hasOpenSquareBracket = true;
              chClass = 0;
            } else {
              chClass = classifier.get(chCode);
            }
            if (chClass === 1) {
              resetStateMachine = true;
            } else {
              state = 13;
            }
          } else {
            state = stateMachine.nextState(state, chCode);
            if (state === 0) {
              resetStateMachine = true;
            }
          }
          if (resetStateMachine) {
            state = 1;
            hasOpenParens = false;
            hasOpenSquareBracket = false;
            hasOpenCurlyBracket = false;
            linkBeginIndex = j + 1;
            linkBeginChCode = chCode;
          }
          j++;
        }
        if (state === 13) {
          result.push(LinkComputer._createLink(classifier, line, i, linkBeginIndex, len));
        }
      }
      return result;
    }
  };
  function computeLinks(model) {
    if (!model || typeof model.getLineCount !== "function" || typeof model.getLineContent !== "function") {
      return [];
    }
    return LinkComputer.computeLinks(model);
  }

  // node_modules/monaco-editor/esm/vs/editor/common/languages/supports/inplaceReplaceSupport.js
  var BasicInplaceReplace = class {
    constructor() {
      this._defaultValueSet = [
        ["true", "false"],
        ["True", "False"],
        ["Private", "Public", "Friend", "ReadOnly", "Partial", "Protected", "WriteOnly"],
        ["public", "protected", "private"]
      ];
    }
    navigateValueSet(range1, text1, range2, text2, up) {
      if (range1 && text1) {
        const result = this.doNavigateValueSet(text1, up);
        if (result) {
          return {
            range: range1,
            value: result
          };
        }
      }
      if (range2 && text2) {
        const result = this.doNavigateValueSet(text2, up);
        if (result) {
          return {
            range: range2,
            value: result
          };
        }
      }
      return null;
    }
    doNavigateValueSet(text, up) {
      const numberResult = this.numberReplace(text, up);
      if (numberResult !== null) {
        return numberResult;
      }
      return this.textReplace(text, up);
    }
    numberReplace(value, up) {
      const precision = Math.pow(10, value.length - (value.lastIndexOf(".") + 1));
      let n1 = Number(value);
      let n2 = parseFloat(value);
      if (!isNaN(n1) && !isNaN(n2) && n1 === n2) {
        if (n1 === 0 && !up) {
          return null;
        } else {
          n1 = Math.floor(n1 * precision);
          n1 += up ? precision : -precision;
          return String(n1 / precision);
        }
      }
      return null;
    }
    textReplace(value, up) {
      return this.valueSetsReplace(this._defaultValueSet, value, up);
    }
    valueSetsReplace(valueSets, value, up) {
      let result = null;
      for (let i = 0, len = valueSets.length; result === null && i < len; i++) {
        result = this.valueSetReplace(valueSets[i], value, up);
      }
      return result;
    }
    valueSetReplace(valueSet, value, up) {
      let idx = valueSet.indexOf(value);
      if (idx >= 0) {
        idx += up ? 1 : -1;
        if (idx < 0) {
          idx = valueSet.length - 1;
        } else {
          idx %= valueSet.length;
        }
        return valueSet[idx];
      }
      return null;
    }
  };
  BasicInplaceReplace.INSTANCE = new BasicInplaceReplace();

  // node_modules/monaco-editor/esm/vs/base/common/cancellation.js
  var shortcutEvent = Object.freeze(function(callback, context) {
    const handle = setTimeout(callback.bind(context), 0);
    return {dispose() {
      clearTimeout(handle);
    }};
  });
  var CancellationToken;
  (function(CancellationToken2) {
    function isCancellationToken(thing) {
      if (thing === CancellationToken2.None || thing === CancellationToken2.Cancelled) {
        return true;
      }
      if (thing instanceof MutableToken) {
        return true;
      }
      if (!thing || typeof thing !== "object") {
        return false;
      }
      return typeof thing.isCancellationRequested === "boolean" && typeof thing.onCancellationRequested === "function";
    }
    CancellationToken2.isCancellationToken = isCancellationToken;
    CancellationToken2.None = Object.freeze({
      isCancellationRequested: false,
      onCancellationRequested: Event.None
    });
    CancellationToken2.Cancelled = Object.freeze({
      isCancellationRequested: true,
      onCancellationRequested: shortcutEvent
    });
  })(CancellationToken || (CancellationToken = {}));
  var MutableToken = class {
    constructor() {
      this._isCancelled = false;
      this._emitter = null;
    }
    cancel() {
      if (!this._isCancelled) {
        this._isCancelled = true;
        if (this._emitter) {
          this._emitter.fire(void 0);
          this.dispose();
        }
      }
    }
    get isCancellationRequested() {
      return this._isCancelled;
    }
    get onCancellationRequested() {
      if (this._isCancelled) {
        return shortcutEvent;
      }
      if (!this._emitter) {
        this._emitter = new Emitter();
      }
      return this._emitter.event;
    }
    dispose() {
      if (this._emitter) {
        this._emitter.dispose();
        this._emitter = null;
      }
    }
  };
  var CancellationTokenSource = class {
    constructor(parent) {
      this._token = void 0;
      this._parentListener = void 0;
      this._parentListener = parent && parent.onCancellationRequested(this.cancel, this);
    }
    get token() {
      if (!this._token) {
        this._token = new MutableToken();
      }
      return this._token;
    }
    cancel() {
      if (!this._token) {
        this._token = CancellationToken.Cancelled;
      } else if (this._token instanceof MutableToken) {
        this._token.cancel();
      }
    }
    dispose(cancel = false) {
      if (cancel) {
        this.cancel();
      }
      if (this._parentListener) {
        this._parentListener.dispose();
      }
      if (!this._token) {
        this._token = CancellationToken.None;
      } else if (this._token instanceof MutableToken) {
        this._token.dispose();
      }
    }
  };

  // node_modules/monaco-editor/esm/vs/base/common/keyCodes.js
  var KeyCodeStrMap = class {
    constructor() {
      this._keyCodeToStr = [];
      this._strToKeyCode = Object.create(null);
    }
    define(keyCode, str) {
      this._keyCodeToStr[keyCode] = str;
      this._strToKeyCode[str.toLowerCase()] = keyCode;
    }
    keyCodeToStr(keyCode) {
      return this._keyCodeToStr[keyCode];
    }
    strToKeyCode(str) {
      return this._strToKeyCode[str.toLowerCase()] || 0;
    }
  };
  var uiMap = new KeyCodeStrMap();
  var userSettingsUSMap = new KeyCodeStrMap();
  var userSettingsGeneralMap = new KeyCodeStrMap();
  var EVENT_KEY_CODE_MAP = new Array(230);
  var NATIVE_WINDOWS_KEY_CODE_TO_KEY_CODE = {};
  var scanCodeIntToStr = [];
  var scanCodeStrToInt = Object.create(null);
  var scanCodeLowerCaseStrToInt = Object.create(null);
  var IMMUTABLE_CODE_TO_KEY_CODE = [];
  var IMMUTABLE_KEY_CODE_TO_CODE = [];
  for (let i = 0; i <= 193; i++) {
    IMMUTABLE_CODE_TO_KEY_CODE[i] = -1;
  }
  for (let i = 0; i <= 127; i++) {
    IMMUTABLE_KEY_CODE_TO_CODE[i] = -1;
  }
  (function() {
    const empty = "";
    const mappings = [
      [0, 1, 0, "None", 0, "unknown", 0, "VK_UNKNOWN", empty, empty],
      [0, 1, 1, "Hyper", 0, empty, 0, empty, empty, empty],
      [0, 1, 2, "Super", 0, empty, 0, empty, empty, empty],
      [0, 1, 3, "Fn", 0, empty, 0, empty, empty, empty],
      [0, 1, 4, "FnLock", 0, empty, 0, empty, empty, empty],
      [0, 1, 5, "Suspend", 0, empty, 0, empty, empty, empty],
      [0, 1, 6, "Resume", 0, empty, 0, empty, empty, empty],
      [0, 1, 7, "Turbo", 0, empty, 0, empty, empty, empty],
      [0, 1, 8, "Sleep", 0, empty, 0, "VK_SLEEP", empty, empty],
      [0, 1, 9, "WakeUp", 0, empty, 0, empty, empty, empty],
      [31, 0, 10, "KeyA", 31, "A", 65, "VK_A", empty, empty],
      [32, 0, 11, "KeyB", 32, "B", 66, "VK_B", empty, empty],
      [33, 0, 12, "KeyC", 33, "C", 67, "VK_C", empty, empty],
      [34, 0, 13, "KeyD", 34, "D", 68, "VK_D", empty, empty],
      [35, 0, 14, "KeyE", 35, "E", 69, "VK_E", empty, empty],
      [36, 0, 15, "KeyF", 36, "F", 70, "VK_F", empty, empty],
      [37, 0, 16, "KeyG", 37, "G", 71, "VK_G", empty, empty],
      [38, 0, 17, "KeyH", 38, "H", 72, "VK_H", empty, empty],
      [39, 0, 18, "KeyI", 39, "I", 73, "VK_I", empty, empty],
      [40, 0, 19, "KeyJ", 40, "J", 74, "VK_J", empty, empty],
      [41, 0, 20, "KeyK", 41, "K", 75, "VK_K", empty, empty],
      [42, 0, 21, "KeyL", 42, "L", 76, "VK_L", empty, empty],
      [43, 0, 22, "KeyM", 43, "M", 77, "VK_M", empty, empty],
      [44, 0, 23, "KeyN", 44, "N", 78, "VK_N", empty, empty],
      [45, 0, 24, "KeyO", 45, "O", 79, "VK_O", empty, empty],
      [46, 0, 25, "KeyP", 46, "P", 80, "VK_P", empty, empty],
      [47, 0, 26, "KeyQ", 47, "Q", 81, "VK_Q", empty, empty],
      [48, 0, 27, "KeyR", 48, "R", 82, "VK_R", empty, empty],
      [49, 0, 28, "KeyS", 49, "S", 83, "VK_S", empty, empty],
      [50, 0, 29, "KeyT", 50, "T", 84, "VK_T", empty, empty],
      [51, 0, 30, "KeyU", 51, "U", 85, "VK_U", empty, empty],
      [52, 0, 31, "KeyV", 52, "V", 86, "VK_V", empty, empty],
      [53, 0, 32, "KeyW", 53, "W", 87, "VK_W", empty, empty],
      [54, 0, 33, "KeyX", 54, "X", 88, "VK_X", empty, empty],
      [55, 0, 34, "KeyY", 55, "Y", 89, "VK_Y", empty, empty],
      [56, 0, 35, "KeyZ", 56, "Z", 90, "VK_Z", empty, empty],
      [22, 0, 36, "Digit1", 22, "1", 49, "VK_1", empty, empty],
      [23, 0, 37, "Digit2", 23, "2", 50, "VK_2", empty, empty],
      [24, 0, 38, "Digit3", 24, "3", 51, "VK_3", empty, empty],
      [25, 0, 39, "Digit4", 25, "4", 52, "VK_4", empty, empty],
      [26, 0, 40, "Digit5", 26, "5", 53, "VK_5", empty, empty],
      [27, 0, 41, "Digit6", 27, "6", 54, "VK_6", empty, empty],
      [28, 0, 42, "Digit7", 28, "7", 55, "VK_7", empty, empty],
      [29, 0, 43, "Digit8", 29, "8", 56, "VK_8", empty, empty],
      [30, 0, 44, "Digit9", 30, "9", 57, "VK_9", empty, empty],
      [21, 0, 45, "Digit0", 21, "0", 48, "VK_0", empty, empty],
      [3, 1, 46, "Enter", 3, "Enter", 13, "VK_RETURN", empty, empty],
      [9, 1, 47, "Escape", 9, "Escape", 27, "VK_ESCAPE", empty, empty],
      [1, 1, 48, "Backspace", 1, "Backspace", 8, "VK_BACK", empty, empty],
      [2, 1, 49, "Tab", 2, "Tab", 9, "VK_TAB", empty, empty],
      [10, 1, 50, "Space", 10, "Space", 32, "VK_SPACE", empty, empty],
      [83, 0, 51, "Minus", 83, "-", 189, "VK_OEM_MINUS", "-", "OEM_MINUS"],
      [81, 0, 52, "Equal", 81, "=", 187, "VK_OEM_PLUS", "=", "OEM_PLUS"],
      [87, 0, 53, "BracketLeft", 87, "[", 219, "VK_OEM_4", "[", "OEM_4"],
      [89, 0, 54, "BracketRight", 89, "]", 221, "VK_OEM_6", "]", "OEM_6"],
      [88, 0, 55, "Backslash", 88, "\\", 220, "VK_OEM_5", "\\", "OEM_5"],
      [0, 0, 56, "IntlHash", 0, empty, 0, empty, empty, empty],
      [80, 0, 57, "Semicolon", 80, ";", 186, "VK_OEM_1", ";", "OEM_1"],
      [90, 0, 58, "Quote", 90, "'", 222, "VK_OEM_7", "'", "OEM_7"],
      [86, 0, 59, "Backquote", 86, "`", 192, "VK_OEM_3", "`", "OEM_3"],
      [82, 0, 60, "Comma", 82, ",", 188, "VK_OEM_COMMA", ",", "OEM_COMMA"],
      [84, 0, 61, "Period", 84, ".", 190, "VK_OEM_PERIOD", ".", "OEM_PERIOD"],
      [85, 0, 62, "Slash", 85, "/", 191, "VK_OEM_2", "/", "OEM_2"],
      [8, 1, 63, "CapsLock", 8, "CapsLock", 20, "VK_CAPITAL", empty, empty],
      [59, 1, 64, "F1", 59, "F1", 112, "VK_F1", empty, empty],
      [60, 1, 65, "F2", 60, "F2", 113, "VK_F2", empty, empty],
      [61, 1, 66, "F3", 61, "F3", 114, "VK_F3", empty, empty],
      [62, 1, 67, "F4", 62, "F4", 115, "VK_F4", empty, empty],
      [63, 1, 68, "F5", 63, "F5", 116, "VK_F5", empty, empty],
      [64, 1, 69, "F6", 64, "F6", 117, "VK_F6", empty, empty],
      [65, 1, 70, "F7", 65, "F7", 118, "VK_F7", empty, empty],
      [66, 1, 71, "F8", 66, "F8", 119, "VK_F8", empty, empty],
      [67, 1, 72, "F9", 67, "F9", 120, "VK_F9", empty, empty],
      [68, 1, 73, "F10", 68, "F10", 121, "VK_F10", empty, empty],
      [69, 1, 74, "F11", 69, "F11", 122, "VK_F11", empty, empty],
      [70, 1, 75, "F12", 70, "F12", 123, "VK_F12", empty, empty],
      [0, 1, 76, "PrintScreen", 0, empty, 0, empty, empty, empty],
      [79, 1, 77, "ScrollLock", 79, "ScrollLock", 145, "VK_SCROLL", empty, empty],
      [7, 1, 78, "Pause", 7, "PauseBreak", 19, "VK_PAUSE", empty, empty],
      [19, 1, 79, "Insert", 19, "Insert", 45, "VK_INSERT", empty, empty],
      [14, 1, 80, "Home", 14, "Home", 36, "VK_HOME", empty, empty],
      [11, 1, 81, "PageUp", 11, "PageUp", 33, "VK_PRIOR", empty, empty],
      [20, 1, 82, "Delete", 20, "Delete", 46, "VK_DELETE", empty, empty],
      [13, 1, 83, "End", 13, "End", 35, "VK_END", empty, empty],
      [12, 1, 84, "PageDown", 12, "PageDown", 34, "VK_NEXT", empty, empty],
      [17, 1, 85, "ArrowRight", 17, "RightArrow", 39, "VK_RIGHT", "Right", empty],
      [15, 1, 86, "ArrowLeft", 15, "LeftArrow", 37, "VK_LEFT", "Left", empty],
      [18, 1, 87, "ArrowDown", 18, "DownArrow", 40, "VK_DOWN", "Down", empty],
      [16, 1, 88, "ArrowUp", 16, "UpArrow", 38, "VK_UP", "Up", empty],
      [78, 1, 89, "NumLock", 78, "NumLock", 144, "VK_NUMLOCK", empty, empty],
      [108, 1, 90, "NumpadDivide", 108, "NumPad_Divide", 111, "VK_DIVIDE", empty, empty],
      [103, 1, 91, "NumpadMultiply", 103, "NumPad_Multiply", 106, "VK_MULTIPLY", empty, empty],
      [106, 1, 92, "NumpadSubtract", 106, "NumPad_Subtract", 109, "VK_SUBTRACT", empty, empty],
      [104, 1, 93, "NumpadAdd", 104, "NumPad_Add", 107, "VK_ADD", empty, empty],
      [3, 1, 94, "NumpadEnter", 3, empty, 0, empty, empty, empty],
      [94, 1, 95, "Numpad1", 94, "NumPad1", 97, "VK_NUMPAD1", empty, empty],
      [95, 1, 96, "Numpad2", 95, "NumPad2", 98, "VK_NUMPAD2", empty, empty],
      [96, 1, 97, "Numpad3", 96, "NumPad3", 99, "VK_NUMPAD3", empty, empty],
      [97, 1, 98, "Numpad4", 97, "NumPad4", 100, "VK_NUMPAD4", empty, empty],
      [98, 1, 99, "Numpad5", 98, "NumPad5", 101, "VK_NUMPAD5", empty, empty],
      [99, 1, 100, "Numpad6", 99, "NumPad6", 102, "VK_NUMPAD6", empty, empty],
      [100, 1, 101, "Numpad7", 100, "NumPad7", 103, "VK_NUMPAD7", empty, empty],
      [101, 1, 102, "Numpad8", 101, "NumPad8", 104, "VK_NUMPAD8", empty, empty],
      [102, 1, 103, "Numpad9", 102, "NumPad9", 105, "VK_NUMPAD9", empty, empty],
      [93, 1, 104, "Numpad0", 93, "NumPad0", 96, "VK_NUMPAD0", empty, empty],
      [107, 1, 105, "NumpadDecimal", 107, "NumPad_Decimal", 110, "VK_DECIMAL", empty, empty],
      [92, 0, 106, "IntlBackslash", 92, "OEM_102", 226, "VK_OEM_102", empty, empty],
      [58, 1, 107, "ContextMenu", 58, "ContextMenu", 93, empty, empty, empty],
      [0, 1, 108, "Power", 0, empty, 0, empty, empty, empty],
      [0, 1, 109, "NumpadEqual", 0, empty, 0, empty, empty, empty],
      [71, 1, 110, "F13", 71, "F13", 124, "VK_F13", empty, empty],
      [72, 1, 111, "F14", 72, "F14", 125, "VK_F14", empty, empty],
      [73, 1, 112, "F15", 73, "F15", 126, "VK_F15", empty, empty],
      [74, 1, 113, "F16", 74, "F16", 127, "VK_F16", empty, empty],
      [75, 1, 114, "F17", 75, "F17", 128, "VK_F17", empty, empty],
      [76, 1, 115, "F18", 76, "F18", 129, "VK_F18", empty, empty],
      [77, 1, 116, "F19", 77, "F19", 130, "VK_F19", empty, empty],
      [0, 1, 117, "F20", 0, empty, 0, "VK_F20", empty, empty],
      [0, 1, 118, "F21", 0, empty, 0, "VK_F21", empty, empty],
      [0, 1, 119, "F22", 0, empty, 0, "VK_F22", empty, empty],
      [0, 1, 120, "F23", 0, empty, 0, "VK_F23", empty, empty],
      [0, 1, 121, "F24", 0, empty, 0, "VK_F24", empty, empty],
      [0, 1, 122, "Open", 0, empty, 0, empty, empty, empty],
      [0, 1, 123, "Help", 0, empty, 0, empty, empty, empty],
      [0, 1, 124, "Select", 0, empty, 0, empty, empty, empty],
      [0, 1, 125, "Again", 0, empty, 0, empty, empty, empty],
      [0, 1, 126, "Undo", 0, empty, 0, empty, empty, empty],
      [0, 1, 127, "Cut", 0, empty, 0, empty, empty, empty],
      [0, 1, 128, "Copy", 0, empty, 0, empty, empty, empty],
      [0, 1, 129, "Paste", 0, empty, 0, empty, empty, empty],
      [0, 1, 130, "Find", 0, empty, 0, empty, empty, empty],
      [0, 1, 131, "AudioVolumeMute", 112, "AudioVolumeMute", 173, "VK_VOLUME_MUTE", empty, empty],
      [0, 1, 132, "AudioVolumeUp", 113, "AudioVolumeUp", 175, "VK_VOLUME_UP", empty, empty],
      [0, 1, 133, "AudioVolumeDown", 114, "AudioVolumeDown", 174, "VK_VOLUME_DOWN", empty, empty],
      [105, 1, 134, "NumpadComma", 105, "NumPad_Separator", 108, "VK_SEPARATOR", empty, empty],
      [110, 0, 135, "IntlRo", 110, "ABNT_C1", 193, "VK_ABNT_C1", empty, empty],
      [0, 1, 136, "KanaMode", 0, empty, 0, empty, empty, empty],
      [0, 0, 137, "IntlYen", 0, empty, 0, empty, empty, empty],
      [0, 1, 138, "Convert", 0, empty, 0, empty, empty, empty],
      [0, 1, 139, "NonConvert", 0, empty, 0, empty, empty, empty],
      [0, 1, 140, "Lang1", 0, empty, 0, empty, empty, empty],
      [0, 1, 141, "Lang2", 0, empty, 0, empty, empty, empty],
      [0, 1, 142, "Lang3", 0, empty, 0, empty, empty, empty],
      [0, 1, 143, "Lang4", 0, empty, 0, empty, empty, empty],
      [0, 1, 144, "Lang5", 0, empty, 0, empty, empty, empty],
      [0, 1, 145, "Abort", 0, empty, 0, empty, empty, empty],
      [0, 1, 146, "Props", 0, empty, 0, empty, empty, empty],
      [0, 1, 147, "NumpadParenLeft", 0, empty, 0, empty, empty, empty],
      [0, 1, 148, "NumpadParenRight", 0, empty, 0, empty, empty, empty],
      [0, 1, 149, "NumpadBackspace", 0, empty, 0, empty, empty, empty],
      [0, 1, 150, "NumpadMemoryStore", 0, empty, 0, empty, empty, empty],
      [0, 1, 151, "NumpadMemoryRecall", 0, empty, 0, empty, empty, empty],
      [0, 1, 152, "NumpadMemoryClear", 0, empty, 0, empty, empty, empty],
      [0, 1, 153, "NumpadMemoryAdd", 0, empty, 0, empty, empty, empty],
      [0, 1, 154, "NumpadMemorySubtract", 0, empty, 0, empty, empty, empty],
      [0, 1, 155, "NumpadClear", 126, "Clear", 12, "VK_CLEAR", empty, empty],
      [0, 1, 156, "NumpadClearEntry", 0, empty, 0, empty, empty, empty],
      [5, 1, 0, empty, 5, "Ctrl", 17, "VK_CONTROL", empty, empty],
      [4, 1, 0, empty, 4, "Shift", 16, "VK_SHIFT", empty, empty],
      [6, 1, 0, empty, 6, "Alt", 18, "VK_MENU", empty, empty],
      [57, 1, 0, empty, 57, "Meta", 0, "VK_COMMAND", empty, empty],
      [5, 1, 157, "ControlLeft", 5, empty, 0, "VK_LCONTROL", empty, empty],
      [4, 1, 158, "ShiftLeft", 4, empty, 0, "VK_LSHIFT", empty, empty],
      [6, 1, 159, "AltLeft", 6, empty, 0, "VK_LMENU", empty, empty],
      [57, 1, 160, "MetaLeft", 57, empty, 0, "VK_LWIN", empty, empty],
      [5, 1, 161, "ControlRight", 5, empty, 0, "VK_RCONTROL", empty, empty],
      [4, 1, 162, "ShiftRight", 4, empty, 0, "VK_RSHIFT", empty, empty],
      [6, 1, 163, "AltRight", 6, empty, 0, "VK_RMENU", empty, empty],
      [57, 1, 164, "MetaRight", 57, empty, 0, "VK_RWIN", empty, empty],
      [0, 1, 165, "BrightnessUp", 0, empty, 0, empty, empty, empty],
      [0, 1, 166, "BrightnessDown", 0, empty, 0, empty, empty, empty],
      [0, 1, 167, "MediaPlay", 0, empty, 0, empty, empty, empty],
      [0, 1, 168, "MediaRecord", 0, empty, 0, empty, empty, empty],
      [0, 1, 169, "MediaFastForward", 0, empty, 0, empty, empty, empty],
      [0, 1, 170, "MediaRewind", 0, empty, 0, empty, empty, empty],
      [114, 1, 171, "MediaTrackNext", 119, "MediaTrackNext", 176, "VK_MEDIA_NEXT_TRACK", empty, empty],
      [115, 1, 172, "MediaTrackPrevious", 120, "MediaTrackPrevious", 177, "VK_MEDIA_PREV_TRACK", empty, empty],
      [116, 1, 173, "MediaStop", 121, "MediaStop", 178, "VK_MEDIA_STOP", empty, empty],
      [0, 1, 174, "Eject", 0, empty, 0, empty, empty, empty],
      [117, 1, 175, "MediaPlayPause", 122, "MediaPlayPause", 179, "VK_MEDIA_PLAY_PAUSE", empty, empty],
      [0, 1, 176, "MediaSelect", 123, "LaunchMediaPlayer", 181, "VK_MEDIA_LAUNCH_MEDIA_SELECT", empty, empty],
      [0, 1, 177, "LaunchMail", 124, "LaunchMail", 180, "VK_MEDIA_LAUNCH_MAIL", empty, empty],
      [0, 1, 178, "LaunchApp2", 125, "LaunchApp2", 183, "VK_MEDIA_LAUNCH_APP2", empty, empty],
      [0, 1, 179, "LaunchApp1", 0, empty, 0, "VK_MEDIA_LAUNCH_APP1", empty, empty],
      [0, 1, 180, "SelectTask", 0, empty, 0, empty, empty, empty],
      [0, 1, 181, "LaunchScreenSaver", 0, empty, 0, empty, empty, empty],
      [0, 1, 182, "BrowserSearch", 115, "BrowserSearch", 170, "VK_BROWSER_SEARCH", empty, empty],
      [0, 1, 183, "BrowserHome", 116, "BrowserHome", 172, "VK_BROWSER_HOME", empty, empty],
      [112, 1, 184, "BrowserBack", 117, "BrowserBack", 166, "VK_BROWSER_BACK", empty, empty],
      [113, 1, 185, "BrowserForward", 118, "BrowserForward", 167, "VK_BROWSER_FORWARD", empty, empty],
      [0, 1, 186, "BrowserStop", 0, empty, 0, "VK_BROWSER_STOP", empty, empty],
      [0, 1, 187, "BrowserRefresh", 0, empty, 0, "VK_BROWSER_REFRESH", empty, empty],
      [0, 1, 188, "BrowserFavorites", 0, empty, 0, "VK_BROWSER_FAVORITES", empty, empty],
      [0, 1, 189, "ZoomToggle", 0, empty, 0, empty, empty, empty],
      [0, 1, 190, "MailReply", 0, empty, 0, empty, empty, empty],
      [0, 1, 191, "MailForward", 0, empty, 0, empty, empty, empty],
      [0, 1, 192, "MailSend", 0, empty, 0, empty, empty, empty],
      [109, 1, 0, empty, 109, "KeyInComposition", 229, empty, empty, empty],
      [111, 1, 0, empty, 111, "ABNT_C2", 194, "VK_ABNT_C2", empty, empty],
      [91, 1, 0, empty, 91, "OEM_8", 223, "VK_OEM_8", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_KANA", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_HANGUL", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_JUNJA", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_FINAL", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_HANJA", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_KANJI", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_CONVERT", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_NONCONVERT", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_ACCEPT", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_MODECHANGE", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_SELECT", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_PRINT", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_EXECUTE", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_SNAPSHOT", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_HELP", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_APPS", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_PROCESSKEY", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_PACKET", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_DBE_SBCSCHAR", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_DBE_DBCSCHAR", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_ATTN", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_CRSEL", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_EXSEL", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_EREOF", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_PLAY", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_ZOOM", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_NONAME", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_PA1", empty, empty],
      [0, 1, 0, empty, 0, empty, 0, "VK_OEM_CLEAR", empty, empty]
    ];
    let seenKeyCode = [];
    let seenScanCode = [];
    for (const mapping of mappings) {
      const [_keyCodeOrd, immutable, scanCode, scanCodeStr, keyCode, keyCodeStr, eventKeyCode, vkey, usUserSettingsLabel, generalUserSettingsLabel] = mapping;
      if (!seenScanCode[scanCode]) {
        seenScanCode[scanCode] = true;
        scanCodeIntToStr[scanCode] = scanCodeStr;
        scanCodeStrToInt[scanCodeStr] = scanCode;
        scanCodeLowerCaseStrToInt[scanCodeStr.toLowerCase()] = scanCode;
        if (immutable) {
          IMMUTABLE_CODE_TO_KEY_CODE[scanCode] = keyCode;
          if (keyCode !== 0 && keyCode !== 3 && keyCode !== 5 && keyCode !== 4 && keyCode !== 6 && keyCode !== 57) {
            IMMUTABLE_KEY_CODE_TO_CODE[keyCode] = scanCode;
          }
        }
      }
      if (!seenKeyCode[keyCode]) {
        seenKeyCode[keyCode] = true;
        if (!keyCodeStr) {
          throw new Error(`String representation missing for key code ${keyCode} around scan code ${scanCodeStr}`);
        }
        uiMap.define(keyCode, keyCodeStr);
        userSettingsUSMap.define(keyCode, usUserSettingsLabel || keyCodeStr);
        userSettingsGeneralMap.define(keyCode, generalUserSettingsLabel || usUserSettingsLabel || keyCodeStr);
      }
      if (eventKeyCode) {
        EVENT_KEY_CODE_MAP[eventKeyCode] = keyCode;
      }
      if (vkey) {
        NATIVE_WINDOWS_KEY_CODE_TO_KEY_CODE[vkey] = keyCode;
      }
    }
    IMMUTABLE_KEY_CODE_TO_CODE[3] = 46;
  })();
  var KeyCodeUtils;
  (function(KeyCodeUtils2) {
    function toString(keyCode) {
      return uiMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils2.toString = toString;
    function fromString(key) {
      return uiMap.strToKeyCode(key);
    }
    KeyCodeUtils2.fromString = fromString;
    function toUserSettingsUS(keyCode) {
      return userSettingsUSMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils2.toUserSettingsUS = toUserSettingsUS;
    function toUserSettingsGeneral(keyCode) {
      return userSettingsGeneralMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils2.toUserSettingsGeneral = toUserSettingsGeneral;
    function fromUserSettings(key) {
      return userSettingsUSMap.strToKeyCode(key) || userSettingsGeneralMap.strToKeyCode(key);
    }
    KeyCodeUtils2.fromUserSettings = fromUserSettings;
    function toElectronAccelerator(keyCode) {
      if (keyCode >= 93 && keyCode <= 108) {
        return null;
      }
      switch (keyCode) {
        case 16:
          return "Up";
        case 18:
          return "Down";
        case 15:
          return "Left";
        case 17:
          return "Right";
      }
      return uiMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils2.toElectronAccelerator = toElectronAccelerator;
  })(KeyCodeUtils || (KeyCodeUtils = {}));
  function KeyChord(firstPart, secondPart) {
    const chordPart = (secondPart & 65535) << 16 >>> 0;
    return (firstPart | chordPart) >>> 0;
  }

  // node_modules/monaco-editor/esm/vs/editor/common/core/selection.js
  var Selection = class extends Range {
    constructor(selectionStartLineNumber, selectionStartColumn, positionLineNumber, positionColumn) {
      super(selectionStartLineNumber, selectionStartColumn, positionLineNumber, positionColumn);
      this.selectionStartLineNumber = selectionStartLineNumber;
      this.selectionStartColumn = selectionStartColumn;
      this.positionLineNumber = positionLineNumber;
      this.positionColumn = positionColumn;
    }
    toString() {
      return "[" + this.selectionStartLineNumber + "," + this.selectionStartColumn + " -> " + this.positionLineNumber + "," + this.positionColumn + "]";
    }
    equalsSelection(other) {
      return Selection.selectionsEqual(this, other);
    }
    static selectionsEqual(a, b) {
      return a.selectionStartLineNumber === b.selectionStartLineNumber && a.selectionStartColumn === b.selectionStartColumn && a.positionLineNumber === b.positionLineNumber && a.positionColumn === b.positionColumn;
    }
    getDirection() {
      if (this.selectionStartLineNumber === this.startLineNumber && this.selectionStartColumn === this.startColumn) {
        return 0;
      }
      return 1;
    }
    setEndPosition(endLineNumber, endColumn) {
      if (this.getDirection() === 0) {
        return new Selection(this.startLineNumber, this.startColumn, endLineNumber, endColumn);
      }
      return new Selection(endLineNumber, endColumn, this.startLineNumber, this.startColumn);
    }
    getPosition() {
      return new Position(this.positionLineNumber, this.positionColumn);
    }
    getSelectionStart() {
      return new Position(this.selectionStartLineNumber, this.selectionStartColumn);
    }
    setStartPosition(startLineNumber, startColumn) {
      if (this.getDirection() === 0) {
        return new Selection(startLineNumber, startColumn, this.endLineNumber, this.endColumn);
      }
      return new Selection(this.endLineNumber, this.endColumn, startLineNumber, startColumn);
    }
    static fromPositions(start, end = start) {
      return new Selection(start.lineNumber, start.column, end.lineNumber, end.column);
    }
    static fromRange(range, direction) {
      if (direction === 0) {
        return new Selection(range.startLineNumber, range.startColumn, range.endLineNumber, range.endColumn);
      } else {
        return new Selection(range.endLineNumber, range.endColumn, range.startLineNumber, range.startColumn);
      }
    }
    static liftSelection(sel) {
      return new Selection(sel.selectionStartLineNumber, sel.selectionStartColumn, sel.positionLineNumber, sel.positionColumn);
    }
    static selectionsArrEqual(a, b) {
      if (a && !b || !a && b) {
        return false;
      }
      if (!a && !b) {
        return true;
      }
      if (a.length !== b.length) {
        return false;
      }
      for (let i = 0, len = a.length; i < len; i++) {
        if (!this.selectionsEqual(a[i], b[i])) {
          return false;
        }
      }
      return true;
    }
    static isISelection(obj) {
      return obj && typeof obj.selectionStartLineNumber === "number" && typeof obj.selectionStartColumn === "number" && typeof obj.positionLineNumber === "number" && typeof obj.positionColumn === "number";
    }
    static createWithDirection(startLineNumber, startColumn, endLineNumber, endColumn, direction) {
      if (direction === 0) {
        return new Selection(startLineNumber, startColumn, endLineNumber, endColumn);
      }
      return new Selection(endLineNumber, endColumn, startLineNumber, startColumn);
    }
  };

  // node_modules/monaco-editor/esm/vs/editor/common/tokenizationRegistry.js
  var __awaiter = function(thisArg, _arguments, P, generator) {
    function adopt(value) {
      return value instanceof P ? value : new P(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P || (P = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e) {
          reject(e);
        }
      }
      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e) {
          reject(e);
        }
      }
      function step(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  var TokenizationRegistry = class {
    constructor() {
      this._map = new Map();
      this._factories = new Map();
      this._onDidChange = new Emitter();
      this.onDidChange = this._onDidChange.event;
      this._colorMap = null;
    }
    fire(languages) {
      this._onDidChange.fire({
        changedLanguages: languages,
        changedColorMap: false
      });
    }
    register(language, support) {
      this._map.set(language, support);
      this.fire([language]);
      return toDisposable(() => {
        if (this._map.get(language) !== support) {
          return;
        }
        this._map.delete(language);
        this.fire([language]);
      });
    }
    registerFactory(languageId, factory) {
      var _a3;
      (_a3 = this._factories.get(languageId)) === null || _a3 === void 0 ? void 0 : _a3.dispose();
      const myData = new TokenizationSupportFactoryData(this, languageId, factory);
      this._factories.set(languageId, myData);
      return toDisposable(() => {
        const v = this._factories.get(languageId);
        if (!v || v !== myData) {
          return;
        }
        this._factories.delete(languageId);
        v.dispose();
      });
    }
    getOrCreate(languageId) {
      return __awaiter(this, void 0, void 0, function* () {
        const tokenizationSupport = this.get(languageId);
        if (tokenizationSupport) {
          return tokenizationSupport;
        }
        const factory = this._factories.get(languageId);
        if (!factory || factory.isResolved) {
          return null;
        }
        yield factory.resolve();
        return this.get(languageId);
      });
    }
    get(language) {
      return this._map.get(language) || null;
    }
    isResolved(languageId) {
      const tokenizationSupport = this.get(languageId);
      if (tokenizationSupport) {
        return true;
      }
      const factory = this._factories.get(languageId);
      if (!factory || factory.isResolved) {
        return true;
      }
      return false;
    }
    setColorMap(colorMap) {
      this._colorMap = colorMap;
      this._onDidChange.fire({
        changedLanguages: Array.from(this._map.keys()),
        changedColorMap: true
      });
    }
    getColorMap() {
      return this._colorMap;
    }
    getDefaultBackground() {
      if (this._colorMap && this._colorMap.length > 2) {
        return this._colorMap[2];
      }
      return null;
    }
  };
  var TokenizationSupportFactoryData = class extends Disposable {
    constructor(_registry, _languageId, _factory) {
      super();
      this._registry = _registry;
      this._languageId = _languageId;
      this._factory = _factory;
      this._isDisposed = false;
      this._resolvePromise = null;
      this._isResolved = false;
    }
    get isResolved() {
      return this._isResolved;
    }
    dispose() {
      this._isDisposed = true;
      super.dispose();
    }
    resolve() {
      return __awaiter(this, void 0, void 0, function* () {
        if (!this._resolvePromise) {
          this._resolvePromise = this._create();
        }
        return this._resolvePromise;
      });
    }
    _create() {
      return __awaiter(this, void 0, void 0, function* () {
        const value = yield Promise.resolve(this._factory.createTokenizationSupport());
        this._isResolved = true;
        if (value && !this._isDisposed) {
          this._register(this._registry.register(this._languageId, value));
        }
      });
    }
  };

  // node_modules/monaco-editor/esm/vs/base/common/codicons.js
  var Codicon = class {
    constructor(id, definition, description) {
      this.id = id;
      this.definition = definition;
      this.description = description;
      Codicon._allCodicons.push(this);
    }
    get classNames() {
      return "codicon codicon-" + this.id;
    }
    get classNamesArray() {
      return ["codicon", "codicon-" + this.id];
    }
    get cssSelector() {
      return ".codicon.codicon-" + this.id;
    }
    static getAll() {
      return Codicon._allCodicons;
    }
  };
  Codicon._allCodicons = [];
  Codicon.add = new Codicon("add", {fontCharacter: "\\ea60"});
  Codicon.plus = new Codicon("plus", Codicon.add.definition);
  Codicon.gistNew = new Codicon("gist-new", Codicon.add.definition);
  Codicon.repoCreate = new Codicon("repo-create", Codicon.add.definition);
  Codicon.lightbulb = new Codicon("lightbulb", {fontCharacter: "\\ea61"});
  Codicon.lightBulb = new Codicon("light-bulb", {fontCharacter: "\\ea61"});
  Codicon.repo = new Codicon("repo", {fontCharacter: "\\ea62"});
  Codicon.repoDelete = new Codicon("repo-delete", {fontCharacter: "\\ea62"});
  Codicon.gistFork = new Codicon("gist-fork", {fontCharacter: "\\ea63"});
  Codicon.repoForked = new Codicon("repo-forked", {fontCharacter: "\\ea63"});
  Codicon.gitPullRequest = new Codicon("git-pull-request", {fontCharacter: "\\ea64"});
  Codicon.gitPullRequestAbandoned = new Codicon("git-pull-request-abandoned", {fontCharacter: "\\ea64"});
  Codicon.recordKeys = new Codicon("record-keys", {fontCharacter: "\\ea65"});
  Codicon.keyboard = new Codicon("keyboard", {fontCharacter: "\\ea65"});
  Codicon.tag = new Codicon("tag", {fontCharacter: "\\ea66"});
  Codicon.tagAdd = new Codicon("tag-add", {fontCharacter: "\\ea66"});
  Codicon.tagRemove = new Codicon("tag-remove", {fontCharacter: "\\ea66"});
  Codicon.person = new Codicon("person", {fontCharacter: "\\ea67"});
  Codicon.personFollow = new Codicon("person-follow", {fontCharacter: "\\ea67"});
  Codicon.personOutline = new Codicon("person-outline", {fontCharacter: "\\ea67"});
  Codicon.personFilled = new Codicon("person-filled", {fontCharacter: "\\ea67"});
  Codicon.gitBranch = new Codicon("git-branch", {fontCharacter: "\\ea68"});
  Codicon.gitBranchCreate = new Codicon("git-branch-create", {fontCharacter: "\\ea68"});
  Codicon.gitBranchDelete = new Codicon("git-branch-delete", {fontCharacter: "\\ea68"});
  Codicon.sourceControl = new Codicon("source-control", {fontCharacter: "\\ea68"});
  Codicon.mirror = new Codicon("mirror", {fontCharacter: "\\ea69"});
  Codicon.mirrorPublic = new Codicon("mirror-public", {fontCharacter: "\\ea69"});
  Codicon.star = new Codicon("star", {fontCharacter: "\\ea6a"});
  Codicon.starAdd = new Codicon("star-add", {fontCharacter: "\\ea6a"});
  Codicon.starDelete = new Codicon("star-delete", {fontCharacter: "\\ea6a"});
  Codicon.starEmpty = new Codicon("star-empty", {fontCharacter: "\\ea6a"});
  Codicon.comment = new Codicon("comment", {fontCharacter: "\\ea6b"});
  Codicon.commentAdd = new Codicon("comment-add", {fontCharacter: "\\ea6b"});
  Codicon.alert = new Codicon("alert", {fontCharacter: "\\ea6c"});
  Codicon.warning = new Codicon("warning", {fontCharacter: "\\ea6c"});
  Codicon.search = new Codicon("search", {fontCharacter: "\\ea6d"});
  Codicon.searchSave = new Codicon("search-save", {fontCharacter: "\\ea6d"});
  Codicon.logOut = new Codicon("log-out", {fontCharacter: "\\ea6e"});
  Codicon.signOut = new Codicon("sign-out", {fontCharacter: "\\ea6e"});
  Codicon.logIn = new Codicon("log-in", {fontCharacter: "\\ea6f"});
  Codicon.signIn = new Codicon("sign-in", {fontCharacter: "\\ea6f"});
  Codicon.eye = new Codicon("eye", {fontCharacter: "\\ea70"});
  Codicon.eyeUnwatch = new Codicon("eye-unwatch", {fontCharacter: "\\ea70"});
  Codicon.eyeWatch = new Codicon("eye-watch", {fontCharacter: "\\ea70"});
  Codicon.circleFilled = new Codicon("circle-filled", {fontCharacter: "\\ea71"});
  Codicon.primitiveDot = new Codicon("primitive-dot", {fontCharacter: "\\ea71"});
  Codicon.closeDirty = new Codicon("close-dirty", {fontCharacter: "\\ea71"});
  Codicon.debugBreakpoint = new Codicon("debug-breakpoint", {fontCharacter: "\\ea71"});
  Codicon.debugBreakpointDisabled = new Codicon("debug-breakpoint-disabled", {fontCharacter: "\\ea71"});
  Codicon.debugHint = new Codicon("debug-hint", {fontCharacter: "\\ea71"});
  Codicon.primitiveSquare = new Codicon("primitive-square", {fontCharacter: "\\ea72"});
  Codicon.edit = new Codicon("edit", {fontCharacter: "\\ea73"});
  Codicon.pencil = new Codicon("pencil", {fontCharacter: "\\ea73"});
  Codicon.info = new Codicon("info", {fontCharacter: "\\ea74"});
  Codicon.issueOpened = new Codicon("issue-opened", {fontCharacter: "\\ea74"});
  Codicon.gistPrivate = new Codicon("gist-private", {fontCharacter: "\\ea75"});
  Codicon.gitForkPrivate = new Codicon("git-fork-private", {fontCharacter: "\\ea75"});
  Codicon.lock = new Codicon("lock", {fontCharacter: "\\ea75"});
  Codicon.mirrorPrivate = new Codicon("mirror-private", {fontCharacter: "\\ea75"});
  Codicon.close = new Codicon("close", {fontCharacter: "\\ea76"});
  Codicon.removeClose = new Codicon("remove-close", {fontCharacter: "\\ea76"});
  Codicon.x = new Codicon("x", {fontCharacter: "\\ea76"});
  Codicon.repoSync = new Codicon("repo-sync", {fontCharacter: "\\ea77"});
  Codicon.sync = new Codicon("sync", {fontCharacter: "\\ea77"});
  Codicon.clone = new Codicon("clone", {fontCharacter: "\\ea78"});
  Codicon.desktopDownload = new Codicon("desktop-download", {fontCharacter: "\\ea78"});
  Codicon.beaker = new Codicon("beaker", {fontCharacter: "\\ea79"});
  Codicon.microscope = new Codicon("microscope", {fontCharacter: "\\ea79"});
  Codicon.vm = new Codicon("vm", {fontCharacter: "\\ea7a"});
  Codicon.deviceDesktop = new Codicon("device-desktop", {fontCharacter: "\\ea7a"});
  Codicon.file = new Codicon("file", {fontCharacter: "\\ea7b"});
  Codicon.fileText = new Codicon("file-text", {fontCharacter: "\\ea7b"});
  Codicon.more = new Codicon("more", {fontCharacter: "\\ea7c"});
  Codicon.ellipsis = new Codicon("ellipsis", {fontCharacter: "\\ea7c"});
  Codicon.kebabHorizontal = new Codicon("kebab-horizontal", {fontCharacter: "\\ea7c"});
  Codicon.mailReply = new Codicon("mail-reply", {fontCharacter: "\\ea7d"});
  Codicon.reply = new Codicon("reply", {fontCharacter: "\\ea7d"});
  Codicon.organization = new Codicon("organization", {fontCharacter: "\\ea7e"});
  Codicon.organizationFilled = new Codicon("organization-filled", {fontCharacter: "\\ea7e"});
  Codicon.organizationOutline = new Codicon("organization-outline", {fontCharacter: "\\ea7e"});
  Codicon.newFile = new Codicon("new-file", {fontCharacter: "\\ea7f"});
  Codicon.fileAdd = new Codicon("file-add", {fontCharacter: "\\ea7f"});
  Codicon.newFolder = new Codicon("new-folder", {fontCharacter: "\\ea80"});
  Codicon.fileDirectoryCreate = new Codicon("file-directory-create", {fontCharacter: "\\ea80"});
  Codicon.trash = new Codicon("trash", {fontCharacter: "\\ea81"});
  Codicon.trashcan = new Codicon("trashcan", {fontCharacter: "\\ea81"});
  Codicon.history = new Codicon("history", {fontCharacter: "\\ea82"});
  Codicon.clock = new Codicon("clock", {fontCharacter: "\\ea82"});
  Codicon.folder = new Codicon("folder", {fontCharacter: "\\ea83"});
  Codicon.fileDirectory = new Codicon("file-directory", {fontCharacter: "\\ea83"});
  Codicon.symbolFolder = new Codicon("symbol-folder", {fontCharacter: "\\ea83"});
  Codicon.logoGithub = new Codicon("logo-github", {fontCharacter: "\\ea84"});
  Codicon.markGithub = new Codicon("mark-github", {fontCharacter: "\\ea84"});
  Codicon.github = new Codicon("github", {fontCharacter: "\\ea84"});
  Codicon.terminal = new Codicon("terminal", {fontCharacter: "\\ea85"});
  Codicon.console = new Codicon("console", {fontCharacter: "\\ea85"});
  Codicon.repl = new Codicon("repl", {fontCharacter: "\\ea85"});
  Codicon.zap = new Codicon("zap", {fontCharacter: "\\ea86"});
  Codicon.symbolEvent = new Codicon("symbol-event", {fontCharacter: "\\ea86"});
  Codicon.error = new Codicon("error", {fontCharacter: "\\ea87"});
  Codicon.stop = new Codicon("stop", {fontCharacter: "\\ea87"});
  Codicon.variable = new Codicon("variable", {fontCharacter: "\\ea88"});
  Codicon.symbolVariable = new Codicon("symbol-variable", {fontCharacter: "\\ea88"});
  Codicon.array = new Codicon("array", {fontCharacter: "\\ea8a"});
  Codicon.symbolArray = new Codicon("symbol-array", {fontCharacter: "\\ea8a"});
  Codicon.symbolModule = new Codicon("symbol-module", {fontCharacter: "\\ea8b"});
  Codicon.symbolPackage = new Codicon("symbol-package", {fontCharacter: "\\ea8b"});
  Codicon.symbolNamespace = new Codicon("symbol-namespace", {fontCharacter: "\\ea8b"});
  Codicon.symbolObject = new Codicon("symbol-object", {fontCharacter: "\\ea8b"});
  Codicon.symbolMethod = new Codicon("symbol-method", {fontCharacter: "\\ea8c"});
  Codicon.symbolFunction = new Codicon("symbol-function", {fontCharacter: "\\ea8c"});
  Codicon.symbolConstructor = new Codicon("symbol-constructor", {fontCharacter: "\\ea8c"});
  Codicon.symbolBoolean = new Codicon("symbol-boolean", {fontCharacter: "\\ea8f"});
  Codicon.symbolNull = new Codicon("symbol-null", {fontCharacter: "\\ea8f"});
  Codicon.symbolNumeric = new Codicon("symbol-numeric", {fontCharacter: "\\ea90"});
  Codicon.symbolNumber = new Codicon("symbol-number", {fontCharacter: "\\ea90"});
  Codicon.symbolStructure = new Codicon("symbol-structure", {fontCharacter: "\\ea91"});
  Codicon.symbolStruct = new Codicon("symbol-struct", {fontCharacter: "\\ea91"});
  Codicon.symbolParameter = new Codicon("symbol-parameter", {fontCharacter: "\\ea92"});
  Codicon.symbolTypeParameter = new Codicon("symbol-type-parameter", {fontCharacter: "\\ea92"});
  Codicon.symbolKey = new Codicon("symbol-key", {fontCharacter: "\\ea93"});
  Codicon.symbolText = new Codicon("symbol-text", {fontCharacter: "\\ea93"});
  Codicon.symbolReference = new Codicon("symbol-reference", {fontCharacter: "\\ea94"});
  Codicon.goToFile = new Codicon("go-to-file", {fontCharacter: "\\ea94"});
  Codicon.symbolEnum = new Codicon("symbol-enum", {fontCharacter: "\\ea95"});
  Codicon.symbolValue = new Codicon("symbol-value", {fontCharacter: "\\ea95"});
  Codicon.symbolRuler = new Codicon("symbol-ruler", {fontCharacter: "\\ea96"});
  Codicon.symbolUnit = new Codicon("symbol-unit", {fontCharacter: "\\ea96"});
  Codicon.activateBreakpoints = new Codicon("activate-breakpoints", {fontCharacter: "\\ea97"});
  Codicon.archive = new Codicon("archive", {fontCharacter: "\\ea98"});
  Codicon.arrowBoth = new Codicon("arrow-both", {fontCharacter: "\\ea99"});
  Codicon.arrowDown = new Codicon("arrow-down", {fontCharacter: "\\ea9a"});
  Codicon.arrowLeft = new Codicon("arrow-left", {fontCharacter: "\\ea9b"});
  Codicon.arrowRight = new Codicon("arrow-right", {fontCharacter: "\\ea9c"});
  Codicon.arrowSmallDown = new Codicon("arrow-small-down", {fontCharacter: "\\ea9d"});
  Codicon.arrowSmallLeft = new Codicon("arrow-small-left", {fontCharacter: "\\ea9e"});
  Codicon.arrowSmallRight = new Codicon("arrow-small-right", {fontCharacter: "\\ea9f"});
  Codicon.arrowSmallUp = new Codicon("arrow-small-up", {fontCharacter: "\\eaa0"});
  Codicon.arrowUp = new Codicon("arrow-up", {fontCharacter: "\\eaa1"});
  Codicon.bell = new Codicon("bell", {fontCharacter: "\\eaa2"});
  Codicon.bold = new Codicon("bold", {fontCharacter: "\\eaa3"});
  Codicon.book = new Codicon("book", {fontCharacter: "\\eaa4"});
  Codicon.bookmark = new Codicon("bookmark", {fontCharacter: "\\eaa5"});
  Codicon.debugBreakpointConditionalUnverified = new Codicon("debug-breakpoint-conditional-unverified", {fontCharacter: "\\eaa6"});
  Codicon.debugBreakpointConditional = new Codicon("debug-breakpoint-conditional", {fontCharacter: "\\eaa7"});
  Codicon.debugBreakpointConditionalDisabled = new Codicon("debug-breakpoint-conditional-disabled", {fontCharacter: "\\eaa7"});
  Codicon.debugBreakpointDataUnverified = new Codicon("debug-breakpoint-data-unverified", {fontCharacter: "\\eaa8"});
  Codicon.debugBreakpointData = new Codicon("debug-breakpoint-data", {fontCharacter: "\\eaa9"});
  Codicon.debugBreakpointDataDisabled = new Codicon("debug-breakpoint-data-disabled", {fontCharacter: "\\eaa9"});
  Codicon.debugBreakpointLogUnverified = new Codicon("debug-breakpoint-log-unverified", {fontCharacter: "\\eaaa"});
  Codicon.debugBreakpointLog = new Codicon("debug-breakpoint-log", {fontCharacter: "\\eaab"});
  Codicon.debugBreakpointLogDisabled = new Codicon("debug-breakpoint-log-disabled", {fontCharacter: "\\eaab"});
  Codicon.briefcase = new Codicon("briefcase", {fontCharacter: "\\eaac"});
  Codicon.broadcast = new Codicon("broadcast", {fontCharacter: "\\eaad"});
  Codicon.browser = new Codicon("browser", {fontCharacter: "\\eaae"});
  Codicon.bug = new Codicon("bug", {fontCharacter: "\\eaaf"});
  Codicon.calendar = new Codicon("calendar", {fontCharacter: "\\eab0"});
  Codicon.caseSensitive = new Codicon("case-sensitive", {fontCharacter: "\\eab1"});
  Codicon.check = new Codicon("check", {fontCharacter: "\\eab2"});
  Codicon.checklist = new Codicon("checklist", {fontCharacter: "\\eab3"});
  Codicon.chevronDown = new Codicon("chevron-down", {fontCharacter: "\\eab4"});
  Codicon.dropDownButton = new Codicon("drop-down-button", Codicon.chevronDown.definition);
  Codicon.chevronLeft = new Codicon("chevron-left", {fontCharacter: "\\eab5"});
  Codicon.chevronRight = new Codicon("chevron-right", {fontCharacter: "\\eab6"});
  Codicon.chevronUp = new Codicon("chevron-up", {fontCharacter: "\\eab7"});
  Codicon.chromeClose = new Codicon("chrome-close", {fontCharacter: "\\eab8"});
  Codicon.chromeMaximize = new Codicon("chrome-maximize", {fontCharacter: "\\eab9"});
  Codicon.chromeMinimize = new Codicon("chrome-minimize", {fontCharacter: "\\eaba"});
  Codicon.chromeRestore = new Codicon("chrome-restore", {fontCharacter: "\\eabb"});
  Codicon.circleOutline = new Codicon("circle-outline", {fontCharacter: "\\eabc"});
  Codicon.debugBreakpointUnverified = new Codicon("debug-breakpoint-unverified", {fontCharacter: "\\eabc"});
  Codicon.circleSlash = new Codicon("circle-slash", {fontCharacter: "\\eabd"});
  Codicon.circuitBoard = new Codicon("circuit-board", {fontCharacter: "\\eabe"});
  Codicon.clearAll = new Codicon("clear-all", {fontCharacter: "\\eabf"});
  Codicon.clippy = new Codicon("clippy", {fontCharacter: "\\eac0"});
  Codicon.closeAll = new Codicon("close-all", {fontCharacter: "\\eac1"});
  Codicon.cloudDownload = new Codicon("cloud-download", {fontCharacter: "\\eac2"});
  Codicon.cloudUpload = new Codicon("cloud-upload", {fontCharacter: "\\eac3"});
  Codicon.code = new Codicon("code", {fontCharacter: "\\eac4"});
  Codicon.collapseAll = new Codicon("collapse-all", {fontCharacter: "\\eac5"});
  Codicon.colorMode = new Codicon("color-mode", {fontCharacter: "\\eac6"});
  Codicon.commentDiscussion = new Codicon("comment-discussion", {fontCharacter: "\\eac7"});
  Codicon.compareChanges = new Codicon("compare-changes", {fontCharacter: "\\eafd"});
  Codicon.creditCard = new Codicon("credit-card", {fontCharacter: "\\eac9"});
  Codicon.dash = new Codicon("dash", {fontCharacter: "\\eacc"});
  Codicon.dashboard = new Codicon("dashboard", {fontCharacter: "\\eacd"});
  Codicon.database = new Codicon("database", {fontCharacter: "\\eace"});
  Codicon.debugContinue = new Codicon("debug-continue", {fontCharacter: "\\eacf"});
  Codicon.debugDisconnect = new Codicon("debug-disconnect", {fontCharacter: "\\ead0"});
  Codicon.debugPause = new Codicon("debug-pause", {fontCharacter: "\\ead1"});
  Codicon.debugRestart = new Codicon("debug-restart", {fontCharacter: "\\ead2"});
  Codicon.debugStart = new Codicon("debug-start", {fontCharacter: "\\ead3"});
  Codicon.debugStepInto = new Codicon("debug-step-into", {fontCharacter: "\\ead4"});
  Codicon.debugStepOut = new Codicon("debug-step-out", {fontCharacter: "\\ead5"});
  Codicon.debugStepOver = new Codicon("debug-step-over", {fontCharacter: "\\ead6"});
  Codicon.debugStop = new Codicon("debug-stop", {fontCharacter: "\\ead7"});
  Codicon.debug = new Codicon("debug", {fontCharacter: "\\ead8"});
  Codicon.deviceCameraVideo = new Codicon("device-camera-video", {fontCharacter: "\\ead9"});
  Codicon.deviceCamera = new Codicon("device-camera", {fontCharacter: "\\eada"});
  Codicon.deviceMobile = new Codicon("device-mobile", {fontCharacter: "\\eadb"});
  Codicon.diffAdded = new Codicon("diff-added", {fontCharacter: "\\eadc"});
  Codicon.diffIgnored = new Codicon("diff-ignored", {fontCharacter: "\\eadd"});
  Codicon.diffModified = new Codicon("diff-modified", {fontCharacter: "\\eade"});
  Codicon.diffRemoved = new Codicon("diff-removed", {fontCharacter: "\\eadf"});
  Codicon.diffRenamed = new Codicon("diff-renamed", {fontCharacter: "\\eae0"});
  Codicon.diff = new Codicon("diff", {fontCharacter: "\\eae1"});
  Codicon.discard = new Codicon("discard", {fontCharacter: "\\eae2"});
  Codicon.editorLayout = new Codicon("editor-layout", {fontCharacter: "\\eae3"});
  Codicon.emptyWindow = new Codicon("empty-window", {fontCharacter: "\\eae4"});
  Codicon.exclude = new Codicon("exclude", {fontCharacter: "\\eae5"});
  Codicon.extensions = new Codicon("extensions", {fontCharacter: "\\eae6"});
  Codicon.eyeClosed = new Codicon("eye-closed", {fontCharacter: "\\eae7"});
  Codicon.fileBinary = new Codicon("file-binary", {fontCharacter: "\\eae8"});
  Codicon.fileCode = new Codicon("file-code", {fontCharacter: "\\eae9"});
  Codicon.fileMedia = new Codicon("file-media", {fontCharacter: "\\eaea"});
  Codicon.filePdf = new Codicon("file-pdf", {fontCharacter: "\\eaeb"});
  Codicon.fileSubmodule = new Codicon("file-submodule", {fontCharacter: "\\eaec"});
  Codicon.fileSymlinkDirectory = new Codicon("file-symlink-directory", {fontCharacter: "\\eaed"});
  Codicon.fileSymlinkFile = new Codicon("file-symlink-file", {fontCharacter: "\\eaee"});
  Codicon.fileZip = new Codicon("file-zip", {fontCharacter: "\\eaef"});
  Codicon.files = new Codicon("files", {fontCharacter: "\\eaf0"});
  Codicon.filter = new Codicon("filter", {fontCharacter: "\\eaf1"});
  Codicon.flame = new Codicon("flame", {fontCharacter: "\\eaf2"});
  Codicon.foldDown = new Codicon("fold-down", {fontCharacter: "\\eaf3"});
  Codicon.foldUp = new Codicon("fold-up", {fontCharacter: "\\eaf4"});
  Codicon.fold = new Codicon("fold", {fontCharacter: "\\eaf5"});
  Codicon.folderActive = new Codicon("folder-active", {fontCharacter: "\\eaf6"});
  Codicon.folderOpened = new Codicon("folder-opened", {fontCharacter: "\\eaf7"});
  Codicon.gear = new Codicon("gear", {fontCharacter: "\\eaf8"});
  Codicon.gift = new Codicon("gift", {fontCharacter: "\\eaf9"});
  Codicon.gistSecret = new Codicon("gist-secret", {fontCharacter: "\\eafa"});
  Codicon.gist = new Codicon("gist", {fontCharacter: "\\eafb"});
  Codicon.gitCommit = new Codicon("git-commit", {fontCharacter: "\\eafc"});
  Codicon.gitCompare = new Codicon("git-compare", {fontCharacter: "\\eafd"});
  Codicon.gitMerge = new Codicon("git-merge", {fontCharacter: "\\eafe"});
  Codicon.githubAction = new Codicon("github-action", {fontCharacter: "\\eaff"});
  Codicon.githubAlt = new Codicon("github-alt", {fontCharacter: "\\eb00"});
  Codicon.globe = new Codicon("globe", {fontCharacter: "\\eb01"});
  Codicon.grabber = new Codicon("grabber", {fontCharacter: "\\eb02"});
  Codicon.graph = new Codicon("graph", {fontCharacter: "\\eb03"});
  Codicon.gripper = new Codicon("gripper", {fontCharacter: "\\eb04"});
  Codicon.heart = new Codicon("heart", {fontCharacter: "\\eb05"});
  Codicon.home = new Codicon("home", {fontCharacter: "\\eb06"});
  Codicon.horizontalRule = new Codicon("horizontal-rule", {fontCharacter: "\\eb07"});
  Codicon.hubot = new Codicon("hubot", {fontCharacter: "\\eb08"});
  Codicon.inbox = new Codicon("inbox", {fontCharacter: "\\eb09"});
  Codicon.issueClosed = new Codicon("issue-closed", {fontCharacter: "\\eba4"});
  Codicon.issueReopened = new Codicon("issue-reopened", {fontCharacter: "\\eb0b"});
  Codicon.issues = new Codicon("issues", {fontCharacter: "\\eb0c"});
  Codicon.italic = new Codicon("italic", {fontCharacter: "\\eb0d"});
  Codicon.jersey = new Codicon("jersey", {fontCharacter: "\\eb0e"});
  Codicon.json = new Codicon("json", {fontCharacter: "\\eb0f"});
  Codicon.kebabVertical = new Codicon("kebab-vertical", {fontCharacter: "\\eb10"});
  Codicon.key = new Codicon("key", {fontCharacter: "\\eb11"});
  Codicon.law = new Codicon("law", {fontCharacter: "\\eb12"});
  Codicon.lightbulbAutofix = new Codicon("lightbulb-autofix", {fontCharacter: "\\eb13"});
  Codicon.linkExternal = new Codicon("link-external", {fontCharacter: "\\eb14"});
  Codicon.link = new Codicon("link", {fontCharacter: "\\eb15"});
  Codicon.listOrdered = new Codicon("list-ordered", {fontCharacter: "\\eb16"});
  Codicon.listUnordered = new Codicon("list-unordered", {fontCharacter: "\\eb17"});
  Codicon.liveShare = new Codicon("live-share", {fontCharacter: "\\eb18"});
  Codicon.loading = new Codicon("loading", {fontCharacter: "\\eb19"});
  Codicon.location = new Codicon("location", {fontCharacter: "\\eb1a"});
  Codicon.mailRead = new Codicon("mail-read", {fontCharacter: "\\eb1b"});
  Codicon.mail = new Codicon("mail", {fontCharacter: "\\eb1c"});
  Codicon.markdown = new Codicon("markdown", {fontCharacter: "\\eb1d"});
  Codicon.megaphone = new Codicon("megaphone", {fontCharacter: "\\eb1e"});
  Codicon.mention = new Codicon("mention", {fontCharacter: "\\eb1f"});
  Codicon.milestone = new Codicon("milestone", {fontCharacter: "\\eb20"});
  Codicon.mortarBoard = new Codicon("mortar-board", {fontCharacter: "\\eb21"});
  Codicon.move = new Codicon("move", {fontCharacter: "\\eb22"});
  Codicon.multipleWindows = new Codicon("multiple-windows", {fontCharacter: "\\eb23"});
  Codicon.mute = new Codicon("mute", {fontCharacter: "\\eb24"});
  Codicon.noNewline = new Codicon("no-newline", {fontCharacter: "\\eb25"});
  Codicon.note = new Codicon("note", {fontCharacter: "\\eb26"});
  Codicon.octoface = new Codicon("octoface", {fontCharacter: "\\eb27"});
  Codicon.openPreview = new Codicon("open-preview", {fontCharacter: "\\eb28"});
  Codicon.package_ = new Codicon("package", {fontCharacter: "\\eb29"});
  Codicon.paintcan = new Codicon("paintcan", {fontCharacter: "\\eb2a"});
  Codicon.pin = new Codicon("pin", {fontCharacter: "\\eb2b"});
  Codicon.play = new Codicon("play", {fontCharacter: "\\eb2c"});
  Codicon.run = new Codicon("run", {fontCharacter: "\\eb2c"});
  Codicon.plug = new Codicon("plug", {fontCharacter: "\\eb2d"});
  Codicon.preserveCase = new Codicon("preserve-case", {fontCharacter: "\\eb2e"});
  Codicon.preview = new Codicon("preview", {fontCharacter: "\\eb2f"});
  Codicon.project = new Codicon("project", {fontCharacter: "\\eb30"});
  Codicon.pulse = new Codicon("pulse", {fontCharacter: "\\eb31"});
  Codicon.question = new Codicon("question", {fontCharacter: "\\eb32"});
  Codicon.quote = new Codicon("quote", {fontCharacter: "\\eb33"});
  Codicon.radioTower = new Codicon("radio-tower", {fontCharacter: "\\eb34"});
  Codicon.reactions = new Codicon("reactions", {fontCharacter: "\\eb35"});
  Codicon.references = new Codicon("references", {fontCharacter: "\\eb36"});
  Codicon.refresh = new Codicon("refresh", {fontCharacter: "\\eb37"});
  Codicon.regex = new Codicon("regex", {fontCharacter: "\\eb38"});
  Codicon.remoteExplorer = new Codicon("remote-explorer", {fontCharacter: "\\eb39"});
  Codicon.remote = new Codicon("remote", {fontCharacter: "\\eb3a"});
  Codicon.remove = new Codicon("remove", {fontCharacter: "\\eb3b"});
  Codicon.replaceAll = new Codicon("replace-all", {fontCharacter: "\\eb3c"});
  Codicon.replace = new Codicon("replace", {fontCharacter: "\\eb3d"});
  Codicon.repoClone = new Codicon("repo-clone", {fontCharacter: "\\eb3e"});
  Codicon.repoForcePush = new Codicon("repo-force-push", {fontCharacter: "\\eb3f"});
  Codicon.repoPull = new Codicon("repo-pull", {fontCharacter: "\\eb40"});
  Codicon.repoPush = new Codicon("repo-push", {fontCharacter: "\\eb41"});
  Codicon.report = new Codicon("report", {fontCharacter: "\\eb42"});
  Codicon.requestChanges = new Codicon("request-changes", {fontCharacter: "\\eb43"});
  Codicon.rocket = new Codicon("rocket", {fontCharacter: "\\eb44"});
  Codicon.rootFolderOpened = new Codicon("root-folder-opened", {fontCharacter: "\\eb45"});
  Codicon.rootFolder = new Codicon("root-folder", {fontCharacter: "\\eb46"});
  Codicon.rss = new Codicon("rss", {fontCharacter: "\\eb47"});
  Codicon.ruby = new Codicon("ruby", {fontCharacter: "\\eb48"});
  Codicon.saveAll = new Codicon("save-all", {fontCharacter: "\\eb49"});
  Codicon.saveAs = new Codicon("save-as", {fontCharacter: "\\eb4a"});
  Codicon.save = new Codicon("save", {fontCharacter: "\\eb4b"});
  Codicon.screenFull = new Codicon("screen-full", {fontCharacter: "\\eb4c"});
  Codicon.screenNormal = new Codicon("screen-normal", {fontCharacter: "\\eb4d"});
  Codicon.searchStop = new Codicon("search-stop", {fontCharacter: "\\eb4e"});
  Codicon.server = new Codicon("server", {fontCharacter: "\\eb50"});
  Codicon.settingsGear = new Codicon("settings-gear", {fontCharacter: "\\eb51"});
  Codicon.settings = new Codicon("settings", {fontCharacter: "\\eb52"});
  Codicon.shield = new Codicon("shield", {fontCharacter: "\\eb53"});
  Codicon.smiley = new Codicon("smiley", {fontCharacter: "\\eb54"});
  Codicon.sortPrecedence = new Codicon("sort-precedence", {fontCharacter: "\\eb55"});
  Codicon.splitHorizontal = new Codicon("split-horizontal", {fontCharacter: "\\eb56"});
  Codicon.splitVertical = new Codicon("split-vertical", {fontCharacter: "\\eb57"});
  Codicon.squirrel = new Codicon("squirrel", {fontCharacter: "\\eb58"});
  Codicon.starFull = new Codicon("star-full", {fontCharacter: "\\eb59"});
  Codicon.starHalf = new Codicon("star-half", {fontCharacter: "\\eb5a"});
  Codicon.symbolClass = new Codicon("symbol-class", {fontCharacter: "\\eb5b"});
  Codicon.symbolColor = new Codicon("symbol-color", {fontCharacter: "\\eb5c"});
  Codicon.symbolCustomColor = new Codicon("symbol-customcolor", {fontCharacter: "\\eb5c"});
  Codicon.symbolConstant = new Codicon("symbol-constant", {fontCharacter: "\\eb5d"});
  Codicon.symbolEnumMember = new Codicon("symbol-enum-member", {fontCharacter: "\\eb5e"});
  Codicon.symbolField = new Codicon("symbol-field", {fontCharacter: "\\eb5f"});
  Codicon.symbolFile = new Codicon("symbol-file", {fontCharacter: "\\eb60"});
  Codicon.symbolInterface = new Codicon("symbol-interface", {fontCharacter: "\\eb61"});
  Codicon.symbolKeyword = new Codicon("symbol-keyword", {fontCharacter: "\\eb62"});
  Codicon.symbolMisc = new Codicon("symbol-misc", {fontCharacter: "\\eb63"});
  Codicon.symbolOperator = new Codicon("symbol-operator", {fontCharacter: "\\eb64"});
  Codicon.symbolProperty = new Codicon("symbol-property", {fontCharacter: "\\eb65"});
  Codicon.wrench = new Codicon("wrench", {fontCharacter: "\\eb65"});
  Codicon.wrenchSubaction = new Codicon("wrench-subaction", {fontCharacter: "\\eb65"});
  Codicon.symbolSnippet = new Codicon("symbol-snippet", {fontCharacter: "\\eb66"});
  Codicon.tasklist = new Codicon("tasklist", {fontCharacter: "\\eb67"});
  Codicon.telescope = new Codicon("telescope", {fontCharacter: "\\eb68"});
  Codicon.textSize = new Codicon("text-size", {fontCharacter: "\\eb69"});
  Codicon.threeBars = new Codicon("three-bars", {fontCharacter: "\\eb6a"});
  Codicon.thumbsdown = new Codicon("thumbsdown", {fontCharacter: "\\eb6b"});
  Codicon.thumbsup = new Codicon("thumbsup", {fontCharacter: "\\eb6c"});
  Codicon.tools = new Codicon("tools", {fontCharacter: "\\eb6d"});
  Codicon.triangleDown = new Codicon("triangle-down", {fontCharacter: "\\eb6e"});
  Codicon.triangleLeft = new Codicon("triangle-left", {fontCharacter: "\\eb6f"});
  Codicon.triangleRight = new Codicon("triangle-right", {fontCharacter: "\\eb70"});
  Codicon.triangleUp = new Codicon("triangle-up", {fontCharacter: "\\eb71"});
  Codicon.twitter = new Codicon("twitter", {fontCharacter: "\\eb72"});
  Codicon.unfold = new Codicon("unfold", {fontCharacter: "\\eb73"});
  Codicon.unlock = new Codicon("unlock", {fontCharacter: "\\eb74"});
  Codicon.unmute = new Codicon("unmute", {fontCharacter: "\\eb75"});
  Codicon.unverified = new Codicon("unverified", {fontCharacter: "\\eb76"});
  Codicon.verified = new Codicon("verified", {fontCharacter: "\\eb77"});
  Codicon.versions = new Codicon("versions", {fontCharacter: "\\eb78"});
  Codicon.vmActive = new Codicon("vm-active", {fontCharacter: "\\eb79"});
  Codicon.vmOutline = new Codicon("vm-outline", {fontCharacter: "\\eb7a"});
  Codicon.vmRunning = new Codicon("vm-running", {fontCharacter: "\\eb7b"});
  Codicon.watch = new Codicon("watch", {fontCharacter: "\\eb7c"});
  Codicon.whitespace = new Codicon("whitespace", {fontCharacter: "\\eb7d"});
  Codicon.wholeWord = new Codicon("whole-word", {fontCharacter: "\\eb7e"});
  Codicon.window = new Codicon("window", {fontCharacter: "\\eb7f"});
  Codicon.wordWrap = new Codicon("word-wrap", {fontCharacter: "\\eb80"});
  Codicon.zoomIn = new Codicon("zoom-in", {fontCharacter: "\\eb81"});
  Codicon.zoomOut = new Codicon("zoom-out", {fontCharacter: "\\eb82"});
  Codicon.listFilter = new Codicon("list-filter", {fontCharacter: "\\eb83"});
  Codicon.listFlat = new Codicon("list-flat", {fontCharacter: "\\eb84"});
  Codicon.listSelection = new Codicon("list-selection", {fontCharacter: "\\eb85"});
  Codicon.selection = new Codicon("selection", {fontCharacter: "\\eb85"});
  Codicon.listTree = new Codicon("list-tree", {fontCharacter: "\\eb86"});
  Codicon.debugBreakpointFunctionUnverified = new Codicon("debug-breakpoint-function-unverified", {fontCharacter: "\\eb87"});
  Codicon.debugBreakpointFunction = new Codicon("debug-breakpoint-function", {fontCharacter: "\\eb88"});
  Codicon.debugBreakpointFunctionDisabled = new Codicon("debug-breakpoint-function-disabled", {fontCharacter: "\\eb88"});
  Codicon.debugStackframeActive = new Codicon("debug-stackframe-active", {fontCharacter: "\\eb89"});
  Codicon.debugStackframeDot = new Codicon("debug-stackframe-dot", {fontCharacter: "\\eb8a"});
  Codicon.debugStackframe = new Codicon("debug-stackframe", {fontCharacter: "\\eb8b"});
  Codicon.debugStackframeFocused = new Codicon("debug-stackframe-focused", {fontCharacter: "\\eb8b"});
  Codicon.debugBreakpointUnsupported = new Codicon("debug-breakpoint-unsupported", {fontCharacter: "\\eb8c"});
  Codicon.symbolString = new Codicon("symbol-string", {fontCharacter: "\\eb8d"});
  Codicon.debugReverseContinue = new Codicon("debug-reverse-continue", {fontCharacter: "\\eb8e"});
  Codicon.debugStepBack = new Codicon("debug-step-back", {fontCharacter: "\\eb8f"});
  Codicon.debugRestartFrame = new Codicon("debug-restart-frame", {fontCharacter: "\\eb90"});
  Codicon.callIncoming = new Codicon("call-incoming", {fontCharacter: "\\eb92"});
  Codicon.callOutgoing = new Codicon("call-outgoing", {fontCharacter: "\\eb93"});
  Codicon.menu = new Codicon("menu", {fontCharacter: "\\eb94"});
  Codicon.expandAll = new Codicon("expand-all", {fontCharacter: "\\eb95"});
  Codicon.feedback = new Codicon("feedback", {fontCharacter: "\\eb96"});
  Codicon.groupByRefType = new Codicon("group-by-ref-type", {fontCharacter: "\\eb97"});
  Codicon.ungroupByRefType = new Codicon("ungroup-by-ref-type", {fontCharacter: "\\eb98"});
  Codicon.account = new Codicon("account", {fontCharacter: "\\eb99"});
  Codicon.bellDot = new Codicon("bell-dot", {fontCharacter: "\\eb9a"});
  Codicon.debugConsole = new Codicon("debug-console", {fontCharacter: "\\eb9b"});
  Codicon.library = new Codicon("library", {fontCharacter: "\\eb9c"});
  Codicon.output = new Codicon("output", {fontCharacter: "\\eb9d"});
  Codicon.runAll = new Codicon("run-all", {fontCharacter: "\\eb9e"});
  Codicon.syncIgnored = new Codicon("sync-ignored", {fontCharacter: "\\eb9f"});
  Codicon.pinned = new Codicon("pinned", {fontCharacter: "\\eba0"});
  Codicon.githubInverted = new Codicon("github-inverted", {fontCharacter: "\\eba1"});
  Codicon.debugAlt = new Codicon("debug-alt", {fontCharacter: "\\eb91"});
  Codicon.serverProcess = new Codicon("server-process", {fontCharacter: "\\eba2"});
  Codicon.serverEnvironment = new Codicon("server-environment", {fontCharacter: "\\eba3"});
  Codicon.pass = new Codicon("pass", {fontCharacter: "\\eba4"});
  Codicon.stopCircle = new Codicon("stop-circle", {fontCharacter: "\\eba5"});
  Codicon.playCircle = new Codicon("play-circle", {fontCharacter: "\\eba6"});
  Codicon.record = new Codicon("record", {fontCharacter: "\\eba7"});
  Codicon.debugAltSmall = new Codicon("debug-alt-small", {fontCharacter: "\\eba8"});
  Codicon.vmConnect = new Codicon("vm-connect", {fontCharacter: "\\eba9"});
  Codicon.cloud = new Codicon("cloud", {fontCharacter: "\\ebaa"});
  Codicon.merge = new Codicon("merge", {fontCharacter: "\\ebab"});
  Codicon.exportIcon = new Codicon("export", {fontCharacter: "\\ebac"});
  Codicon.graphLeft = new Codicon("graph-left", {fontCharacter: "\\ebad"});
  Codicon.magnet = new Codicon("magnet", {fontCharacter: "\\ebae"});
  Codicon.notebook = new Codicon("notebook", {fontCharacter: "\\ebaf"});
  Codicon.redo = new Codicon("redo", {fontCharacter: "\\ebb0"});
  Codicon.checkAll = new Codicon("check-all", {fontCharacter: "\\ebb1"});
  Codicon.pinnedDirty = new Codicon("pinned-dirty", {fontCharacter: "\\ebb2"});
  Codicon.passFilled = new Codicon("pass-filled", {fontCharacter: "\\ebb3"});
  Codicon.circleLargeFilled = new Codicon("circle-large-filled", {fontCharacter: "\\ebb4"});
  Codicon.circleLargeOutline = new Codicon("circle-large-outline", {fontCharacter: "\\ebb5"});
  Codicon.combine = new Codicon("combine", {fontCharacter: "\\ebb6"});
  Codicon.gather = new Codicon("gather", {fontCharacter: "\\ebb6"});
  Codicon.table = new Codicon("table", {fontCharacter: "\\ebb7"});
  Codicon.variableGroup = new Codicon("variable-group", {fontCharacter: "\\ebb8"});
  Codicon.typeHierarchy = new Codicon("type-hierarchy", {fontCharacter: "\\ebb9"});
  Codicon.typeHierarchySub = new Codicon("type-hierarchy-sub", {fontCharacter: "\\ebba"});
  Codicon.typeHierarchySuper = new Codicon("type-hierarchy-super", {fontCharacter: "\\ebbb"});
  Codicon.gitPullRequestCreate = new Codicon("git-pull-request-create", {fontCharacter: "\\ebbc"});
  Codicon.runAbove = new Codicon("run-above", {fontCharacter: "\\ebbd"});
  Codicon.runBelow = new Codicon("run-below", {fontCharacter: "\\ebbe"});
  Codicon.notebookTemplate = new Codicon("notebook-template", {fontCharacter: "\\ebbf"});
  Codicon.debugRerun = new Codicon("debug-rerun", {fontCharacter: "\\ebc0"});
  Codicon.workspaceTrusted = new Codicon("workspace-trusted", {fontCharacter: "\\ebc1"});
  Codicon.workspaceUntrusted = new Codicon("workspace-untrusted", {fontCharacter: "\\ebc2"});
  Codicon.workspaceUnspecified = new Codicon("workspace-unspecified", {fontCharacter: "\\ebc3"});
  Codicon.terminalCmd = new Codicon("terminal-cmd", {fontCharacter: "\\ebc4"});
  Codicon.terminalDebian = new Codicon("terminal-debian", {fontCharacter: "\\ebc5"});
  Codicon.terminalLinux = new Codicon("terminal-linux", {fontCharacter: "\\ebc6"});
  Codicon.terminalPowershell = new Codicon("terminal-powershell", {fontCharacter: "\\ebc7"});
  Codicon.terminalTmux = new Codicon("terminal-tmux", {fontCharacter: "\\ebc8"});
  Codicon.terminalUbuntu = new Codicon("terminal-ubuntu", {fontCharacter: "\\ebc9"});
  Codicon.terminalBash = new Codicon("terminal-bash", {fontCharacter: "\\ebca"});
  Codicon.arrowSwap = new Codicon("arrow-swap", {fontCharacter: "\\ebcb"});
  Codicon.copy = new Codicon("copy", {fontCharacter: "\\ebcc"});
  Codicon.personAdd = new Codicon("person-add", {fontCharacter: "\\ebcd"});
  Codicon.filterFilled = new Codicon("filter-filled", {fontCharacter: "\\ebce"});
  Codicon.wand = new Codicon("wand", {fontCharacter: "\\ebcf"});
  Codicon.debugLineByLine = new Codicon("debug-line-by-line", {fontCharacter: "\\ebd0"});
  Codicon.inspect = new Codicon("inspect", {fontCharacter: "\\ebd1"});
  Codicon.layers = new Codicon("layers", {fontCharacter: "\\ebd2"});
  Codicon.layersDot = new Codicon("layers-dot", {fontCharacter: "\\ebd3"});
  Codicon.layersActive = new Codicon("layers-active", {fontCharacter: "\\ebd4"});
  Codicon.compass = new Codicon("compass", {fontCharacter: "\\ebd5"});
  Codicon.compassDot = new Codicon("compass-dot", {fontCharacter: "\\ebd6"});
  Codicon.compassActive = new Codicon("compass-active", {fontCharacter: "\\ebd7"});
  Codicon.azure = new Codicon("azure", {fontCharacter: "\\ebd8"});
  Codicon.issueDraft = new Codicon("issue-draft", {fontCharacter: "\\ebd9"});
  Codicon.gitPullRequestClosed = new Codicon("git-pull-request-closed", {fontCharacter: "\\ebda"});
  Codicon.gitPullRequestDraft = new Codicon("git-pull-request-draft", {fontCharacter: "\\ebdb"});
  Codicon.debugAll = new Codicon("debug-all", {fontCharacter: "\\ebdc"});
  Codicon.debugCoverage = new Codicon("debug-coverage", {fontCharacter: "\\ebdd"});
  Codicon.runErrors = new Codicon("run-errors", {fontCharacter: "\\ebde"});
  Codicon.folderLibrary = new Codicon("folder-library", {fontCharacter: "\\ebdf"});
  Codicon.debugContinueSmall = new Codicon("debug-continue-small", {fontCharacter: "\\ebe0"});
  Codicon.beakerStop = new Codicon("beaker-stop", {fontCharacter: "\\ebe1"});
  Codicon.graphLine = new Codicon("graph-line", {fontCharacter: "\\ebe2"});
  Codicon.graphScatter = new Codicon("graph-scatter", {fontCharacter: "\\ebe3"});
  Codicon.pieChart = new Codicon("pie-chart", {fontCharacter: "\\ebe4"});
  Codicon.bracket = new Codicon("bracket", Codicon.json.definition);
  Codicon.bracketDot = new Codicon("bracket-dot", {fontCharacter: "\\ebe5"});
  Codicon.bracketError = new Codicon("bracket-error", {fontCharacter: "\\ebe6"});
  Codicon.lockSmall = new Codicon("lock-small", {fontCharacter: "\\ebe7"});
  Codicon.azureDevops = new Codicon("azure-devops", {fontCharacter: "\\ebe8"});
  Codicon.verifiedFilled = new Codicon("verified-filled", {fontCharacter: "\\ebe9"});
  Codicon.newLine = new Codicon("newline", {fontCharacter: "\\ebea"});
  Codicon.layout = new Codicon("layout", {fontCharacter: "\\ebeb"});
  Codicon.layoutActivitybarLeft = new Codicon("layout-activitybar-left", {fontCharacter: "\\ebec"});
  Codicon.layoutActivitybarRight = new Codicon("layout-activitybar-right", {fontCharacter: "\\ebed"});
  Codicon.layoutPanelLeft = new Codicon("layout-panel-left", {fontCharacter: "\\ebee"});
  Codicon.layoutPanelCenter = new Codicon("layout-panel-center", {fontCharacter: "\\ebef"});
  Codicon.layoutPanelJustify = new Codicon("layout-panel-justify", {fontCharacter: "\\ebf0"});
  Codicon.layoutPanelRight = new Codicon("layout-panel-right", {fontCharacter: "\\ebf1"});
  Codicon.layoutPanel = new Codicon("layout-panel", {fontCharacter: "\\ebf2"});
  Codicon.layoutSidebarLeft = new Codicon("layout-sidebar-left", {fontCharacter: "\\ebf3"});
  Codicon.layoutSidebarRight = new Codicon("layout-sidebar-right", {fontCharacter: "\\ebf4"});
  Codicon.layoutStatusbar = new Codicon("layout-statusbar", {fontCharacter: "\\ebf5"});
  Codicon.layoutMenubar = new Codicon("layout-menubar", {fontCharacter: "\\ebf6"});
  Codicon.layoutCentered = new Codicon("layout-centered", {fontCharacter: "\\ebf7"});
  Codicon.target = new Codicon("target", {fontCharacter: "\\ebf8"});
  Codicon.indent = new Codicon("indent", {fontCharacter: "\\ebf9"});
  Codicon.recordSmall = new Codicon("record-small", {fontCharacter: "\\ebfa"});
  Codicon.errorSmall = new Codicon("error-small", {fontCharacter: "\\ebfb"});
  Codicon.arrowCircleDown = new Codicon("arrow-circle-down", {fontCharacter: "\\ebfc"});
  Codicon.arrowCircleLeft = new Codicon("arrow-circle-left", {fontCharacter: "\\ebfd"});
  Codicon.arrowCircleRight = new Codicon("arrow-circle-right", {fontCharacter: "\\ebfe"});
  Codicon.arrowCircleUp = new Codicon("arrow-circle-up", {fontCharacter: "\\ebff"});
  Codicon.dialogError = new Codicon("dialog-error", Codicon.error.definition);
  Codicon.dialogWarning = new Codicon("dialog-warning", Codicon.warning.definition);
  Codicon.dialogInfo = new Codicon("dialog-info", Codicon.info.definition);
  Codicon.dialogClose = new Codicon("dialog-close", Codicon.close.definition);
  Codicon.treeItemExpanded = new Codicon("tree-item-expanded", Codicon.chevronDown.definition);
  Codicon.treeFilterOnTypeOn = new Codicon("tree-filter-on-type-on", Codicon.listFilter.definition);
  Codicon.treeFilterOnTypeOff = new Codicon("tree-filter-on-type-off", Codicon.listSelection.definition);
  Codicon.treeFilterClear = new Codicon("tree-filter-clear", Codicon.close.definition);
  Codicon.treeItemLoading = new Codicon("tree-item-loading", Codicon.loading.definition);
  Codicon.menuSelection = new Codicon("menu-selection", Codicon.check.definition);
  Codicon.menuSubmenu = new Codicon("menu-submenu", Codicon.chevronRight.definition);
  Codicon.menuBarMore = new Codicon("menubar-more", Codicon.more.definition);
  Codicon.scrollbarButtonLeft = new Codicon("scrollbar-button-left", Codicon.triangleLeft.definition);
  Codicon.scrollbarButtonRight = new Codicon("scrollbar-button-right", Codicon.triangleRight.definition);
  Codicon.scrollbarButtonUp = new Codicon("scrollbar-button-up", Codicon.triangleUp.definition);
  Codicon.scrollbarButtonDown = new Codicon("scrollbar-button-down", Codicon.triangleDown.definition);
  Codicon.toolBarMore = new Codicon("toolbar-more", Codicon.more.definition);
  Codicon.quickInputBack = new Codicon("quick-input-back", Codicon.arrowLeft.definition);
  var CSSIcon;
  (function(CSSIcon2) {
    CSSIcon2.iconNameSegment = "[A-Za-z0-9]+";
    CSSIcon2.iconNameExpression = "[A-Za-z0-9-]+";
    CSSIcon2.iconModifierExpression = "~[A-Za-z]+";
    CSSIcon2.iconNameCharacter = "[A-Za-z0-9~-]";
    const cssIconIdRegex = new RegExp(`^(${CSSIcon2.iconNameExpression})(${CSSIcon2.iconModifierExpression})?$`);
    function asClassNameArray(icon) {
      if (icon instanceof Codicon) {
        return ["codicon", "codicon-" + icon.id];
      }
      const match = cssIconIdRegex.exec(icon.id);
      if (!match) {
        return asClassNameArray(Codicon.error);
      }
      let [, id, modifier] = match;
      const classNames = ["codicon", "codicon-" + id];
      if (modifier) {
        classNames.push("codicon-modifier-" + modifier.substr(1));
      }
      return classNames;
    }
    CSSIcon2.asClassNameArray = asClassNameArray;
    function asClassName(icon) {
      return asClassNameArray(icon).join(" ");
    }
    CSSIcon2.asClassName = asClassName;
    function asCSSSelector(icon) {
      return "." + asClassNameArray(icon).join(".");
    }
    CSSIcon2.asCSSSelector = asCSSSelector;
  })(CSSIcon || (CSSIcon = {}));

  // node_modules/monaco-editor/esm/vs/editor/common/languages.js
  var Token = class {
    constructor(offset, type, language) {
      this._tokenBrand = void 0;
      this.offset = offset;
      this.type = type;
      this.language = language;
    }
    toString() {
      return "(" + this.offset + ", " + this.type + ")";
    }
  };
  var CompletionItemKinds;
  (function(CompletionItemKinds2) {
    const byKind = new Map();
    byKind.set(0, Codicon.symbolMethod);
    byKind.set(1, Codicon.symbolFunction);
    byKind.set(2, Codicon.symbolConstructor);
    byKind.set(3, Codicon.symbolField);
    byKind.set(4, Codicon.symbolVariable);
    byKind.set(5, Codicon.symbolClass);
    byKind.set(6, Codicon.symbolStruct);
    byKind.set(7, Codicon.symbolInterface);
    byKind.set(8, Codicon.symbolModule);
    byKind.set(9, Codicon.symbolProperty);
    byKind.set(10, Codicon.symbolEvent);
    byKind.set(11, Codicon.symbolOperator);
    byKind.set(12, Codicon.symbolUnit);
    byKind.set(13, Codicon.symbolValue);
    byKind.set(15, Codicon.symbolEnum);
    byKind.set(14, Codicon.symbolConstant);
    byKind.set(15, Codicon.symbolEnum);
    byKind.set(16, Codicon.symbolEnumMember);
    byKind.set(17, Codicon.symbolKeyword);
    byKind.set(27, Codicon.symbolSnippet);
    byKind.set(18, Codicon.symbolText);
    byKind.set(19, Codicon.symbolColor);
    byKind.set(20, Codicon.symbolFile);
    byKind.set(21, Codicon.symbolReference);
    byKind.set(22, Codicon.symbolCustomColor);
    byKind.set(23, Codicon.symbolFolder);
    byKind.set(24, Codicon.symbolTypeParameter);
    byKind.set(25, Codicon.account);
    byKind.set(26, Codicon.issues);
    function toIcon(kind) {
      let codicon = byKind.get(kind);
      if (!codicon) {
        console.info("No codicon found for CompletionItemKind " + kind);
        codicon = Codicon.symbolProperty;
      }
      return codicon;
    }
    CompletionItemKinds2.toIcon = toIcon;
    const data = new Map();
    data.set("method", 0);
    data.set("function", 1);
    data.set("constructor", 2);
    data.set("field", 3);
    data.set("variable", 4);
    data.set("class", 5);
    data.set("struct", 6);
    data.set("interface", 7);
    data.set("module", 8);
    data.set("property", 9);
    data.set("event", 10);
    data.set("operator", 11);
    data.set("unit", 12);
    data.set("value", 13);
    data.set("constant", 14);
    data.set("enum", 15);
    data.set("enum-member", 16);
    data.set("enumMember", 16);
    data.set("keyword", 17);
    data.set("snippet", 27);
    data.set("text", 18);
    data.set("color", 19);
    data.set("file", 20);
    data.set("reference", 21);
    data.set("customcolor", 22);
    data.set("folder", 23);
    data.set("type-parameter", 24);
    data.set("typeParameter", 24);
    data.set("account", 25);
    data.set("issue", 26);
    function fromString(value, strict) {
      let res = data.get(value);
      if (typeof res === "undefined" && !strict) {
        res = 9;
      }
      return res;
    }
    CompletionItemKinds2.fromString = fromString;
  })(CompletionItemKinds || (CompletionItemKinds = {}));
  var InlineCompletionTriggerKind;
  (function(InlineCompletionTriggerKind3) {
    InlineCompletionTriggerKind3[InlineCompletionTriggerKind3["Automatic"] = 0] = "Automatic";
    InlineCompletionTriggerKind3[InlineCompletionTriggerKind3["Explicit"] = 1] = "Explicit";
  })(InlineCompletionTriggerKind || (InlineCompletionTriggerKind = {}));
  var SignatureHelpTriggerKind;
  (function(SignatureHelpTriggerKind3) {
    SignatureHelpTriggerKind3[SignatureHelpTriggerKind3["Invoke"] = 1] = "Invoke";
    SignatureHelpTriggerKind3[SignatureHelpTriggerKind3["TriggerCharacter"] = 2] = "TriggerCharacter";
    SignatureHelpTriggerKind3[SignatureHelpTriggerKind3["ContentChange"] = 3] = "ContentChange";
  })(SignatureHelpTriggerKind || (SignatureHelpTriggerKind = {}));
  var DocumentHighlightKind;
  (function(DocumentHighlightKind3) {
    DocumentHighlightKind3[DocumentHighlightKind3["Text"] = 0] = "Text";
    DocumentHighlightKind3[DocumentHighlightKind3["Read"] = 1] = "Read";
    DocumentHighlightKind3[DocumentHighlightKind3["Write"] = 2] = "Write";
  })(DocumentHighlightKind || (DocumentHighlightKind = {}));
  var SymbolKinds;
  (function(SymbolKinds2) {
    const byKind = new Map();
    byKind.set(0, Codicon.symbolFile);
    byKind.set(1, Codicon.symbolModule);
    byKind.set(2, Codicon.symbolNamespace);
    byKind.set(3, Codicon.symbolPackage);
    byKind.set(4, Codicon.symbolClass);
    byKind.set(5, Codicon.symbolMethod);
    byKind.set(6, Codicon.symbolProperty);
    byKind.set(7, Codicon.symbolField);
    byKind.set(8, Codicon.symbolConstructor);
    byKind.set(9, Codicon.symbolEnum);
    byKind.set(10, Codicon.symbolInterface);
    byKind.set(11, Codicon.symbolFunction);
    byKind.set(12, Codicon.symbolVariable);
    byKind.set(13, Codicon.symbolConstant);
    byKind.set(14, Codicon.symbolString);
    byKind.set(15, Codicon.symbolNumber);
    byKind.set(16, Codicon.symbolBoolean);
    byKind.set(17, Codicon.symbolArray);
    byKind.set(18, Codicon.symbolObject);
    byKind.set(19, Codicon.symbolKey);
    byKind.set(20, Codicon.symbolNull);
    byKind.set(21, Codicon.symbolEnumMember);
    byKind.set(22, Codicon.symbolStruct);
    byKind.set(23, Codicon.symbolEvent);
    byKind.set(24, Codicon.symbolOperator);
    byKind.set(25, Codicon.symbolTypeParameter);
    function toIcon(kind) {
      let icon = byKind.get(kind);
      if (!icon) {
        console.info("No codicon found for SymbolKind " + kind);
        icon = Codicon.symbolProperty;
      }
      return icon;
    }
    SymbolKinds2.toIcon = toIcon;
  })(SymbolKinds || (SymbolKinds = {}));
  var FoldingRangeKind = class {
    constructor(value) {
      this.value = value;
    }
  };
  FoldingRangeKind.Comment = new FoldingRangeKind("comment");
  FoldingRangeKind.Imports = new FoldingRangeKind("imports");
  FoldingRangeKind.Region = new FoldingRangeKind("region");
  var Command;
  (function(Command2) {
    function is(obj) {
      if (!obj || typeof obj !== "object") {
        return false;
      }
      return typeof obj.id === "string" && typeof obj.title === "string";
    }
    Command2.is = is;
  })(Command || (Command = {}));
  var InlayHintKind;
  (function(InlayHintKind3) {
    InlayHintKind3[InlayHintKind3["Type"] = 1] = "Type";
    InlayHintKind3[InlayHintKind3["Parameter"] = 2] = "Parameter";
  })(InlayHintKind || (InlayHintKind = {}));
  var TokenizationRegistry2 = new TokenizationRegistry();

  // node_modules/monaco-editor/esm/vs/editor/common/standalone/standaloneEnums.js
  var AccessibilitySupport;
  (function(AccessibilitySupport2) {
    AccessibilitySupport2[AccessibilitySupport2["Unknown"] = 0] = "Unknown";
    AccessibilitySupport2[AccessibilitySupport2["Disabled"] = 1] = "Disabled";
    AccessibilitySupport2[AccessibilitySupport2["Enabled"] = 2] = "Enabled";
  })(AccessibilitySupport || (AccessibilitySupport = {}));
  var CompletionItemInsertTextRule;
  (function(CompletionItemInsertTextRule2) {
    CompletionItemInsertTextRule2[CompletionItemInsertTextRule2["KeepWhitespace"] = 1] = "KeepWhitespace";
    CompletionItemInsertTextRule2[CompletionItemInsertTextRule2["InsertAsSnippet"] = 4] = "InsertAsSnippet";
  })(CompletionItemInsertTextRule || (CompletionItemInsertTextRule = {}));
  var CompletionItemKind;
  (function(CompletionItemKind2) {
    CompletionItemKind2[CompletionItemKind2["Method"] = 0] = "Method";
    CompletionItemKind2[CompletionItemKind2["Function"] = 1] = "Function";
    CompletionItemKind2[CompletionItemKind2["Constructor"] = 2] = "Constructor";
    CompletionItemKind2[CompletionItemKind2["Field"] = 3] = "Field";
    CompletionItemKind2[CompletionItemKind2["Variable"] = 4] = "Variable";
    CompletionItemKind2[CompletionItemKind2["Class"] = 5] = "Class";
    CompletionItemKind2[CompletionItemKind2["Struct"] = 6] = "Struct";
    CompletionItemKind2[CompletionItemKind2["Interface"] = 7] = "Interface";
    CompletionItemKind2[CompletionItemKind2["Module"] = 8] = "Module";
    CompletionItemKind2[CompletionItemKind2["Property"] = 9] = "Property";
    CompletionItemKind2[CompletionItemKind2["Event"] = 10] = "Event";
    CompletionItemKind2[CompletionItemKind2["Operator"] = 11] = "Operator";
    CompletionItemKind2[CompletionItemKind2["Unit"] = 12] = "Unit";
    CompletionItemKind2[CompletionItemKind2["Value"] = 13] = "Value";
    CompletionItemKind2[CompletionItemKind2["Constant"] = 14] = "Constant";
    CompletionItemKind2[CompletionItemKind2["Enum"] = 15] = "Enum";
    CompletionItemKind2[CompletionItemKind2["EnumMember"] = 16] = "EnumMember";
    CompletionItemKind2[CompletionItemKind2["Keyword"] = 17] = "Keyword";
    CompletionItemKind2[CompletionItemKind2["Text"] = 18] = "Text";
    CompletionItemKind2[CompletionItemKind2["Color"] = 19] = "Color";
    CompletionItemKind2[CompletionItemKind2["File"] = 20] = "File";
    CompletionItemKind2[CompletionItemKind2["Reference"] = 21] = "Reference";
    CompletionItemKind2[CompletionItemKind2["Customcolor"] = 22] = "Customcolor";
    CompletionItemKind2[CompletionItemKind2["Folder"] = 23] = "Folder";
    CompletionItemKind2[CompletionItemKind2["TypeParameter"] = 24] = "TypeParameter";
    CompletionItemKind2[CompletionItemKind2["User"] = 25] = "User";
    CompletionItemKind2[CompletionItemKind2["Issue"] = 26] = "Issue";
    CompletionItemKind2[CompletionItemKind2["Snippet"] = 27] = "Snippet";
  })(CompletionItemKind || (CompletionItemKind = {}));
  var CompletionItemTag;
  (function(CompletionItemTag2) {
    CompletionItemTag2[CompletionItemTag2["Deprecated"] = 1] = "Deprecated";
  })(CompletionItemTag || (CompletionItemTag = {}));
  var CompletionTriggerKind;
  (function(CompletionTriggerKind2) {
    CompletionTriggerKind2[CompletionTriggerKind2["Invoke"] = 0] = "Invoke";
    CompletionTriggerKind2[CompletionTriggerKind2["TriggerCharacter"] = 1] = "TriggerCharacter";
    CompletionTriggerKind2[CompletionTriggerKind2["TriggerForIncompleteCompletions"] = 2] = "TriggerForIncompleteCompletions";
  })(CompletionTriggerKind || (CompletionTriggerKind = {}));
  var ContentWidgetPositionPreference;
  (function(ContentWidgetPositionPreference2) {
    ContentWidgetPositionPreference2[ContentWidgetPositionPreference2["EXACT"] = 0] = "EXACT";
    ContentWidgetPositionPreference2[ContentWidgetPositionPreference2["ABOVE"] = 1] = "ABOVE";
    ContentWidgetPositionPreference2[ContentWidgetPositionPreference2["BELOW"] = 2] = "BELOW";
  })(ContentWidgetPositionPreference || (ContentWidgetPositionPreference = {}));
  var CursorChangeReason;
  (function(CursorChangeReason2) {
    CursorChangeReason2[CursorChangeReason2["NotSet"] = 0] = "NotSet";
    CursorChangeReason2[CursorChangeReason2["ContentFlush"] = 1] = "ContentFlush";
    CursorChangeReason2[CursorChangeReason2["RecoverFromMarkers"] = 2] = "RecoverFromMarkers";
    CursorChangeReason2[CursorChangeReason2["Explicit"] = 3] = "Explicit";
    CursorChangeReason2[CursorChangeReason2["Paste"] = 4] = "Paste";
    CursorChangeReason2[CursorChangeReason2["Undo"] = 5] = "Undo";
    CursorChangeReason2[CursorChangeReason2["Redo"] = 6] = "Redo";
  })(CursorChangeReason || (CursorChangeReason = {}));
  var DefaultEndOfLine;
  (function(DefaultEndOfLine2) {
    DefaultEndOfLine2[DefaultEndOfLine2["LF"] = 1] = "LF";
    DefaultEndOfLine2[DefaultEndOfLine2["CRLF"] = 2] = "CRLF";
  })(DefaultEndOfLine || (DefaultEndOfLine = {}));
  var DocumentHighlightKind2;
  (function(DocumentHighlightKind3) {
    DocumentHighlightKind3[DocumentHighlightKind3["Text"] = 0] = "Text";
    DocumentHighlightKind3[DocumentHighlightKind3["Read"] = 1] = "Read";
    DocumentHighlightKind3[DocumentHighlightKind3["Write"] = 2] = "Write";
  })(DocumentHighlightKind2 || (DocumentHighlightKind2 = {}));
  var EditorAutoIndentStrategy;
  (function(EditorAutoIndentStrategy2) {
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["None"] = 0] = "None";
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["Keep"] = 1] = "Keep";
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["Brackets"] = 2] = "Brackets";
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["Advanced"] = 3] = "Advanced";
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["Full"] = 4] = "Full";
  })(EditorAutoIndentStrategy || (EditorAutoIndentStrategy = {}));
  var EditorOption;
  (function(EditorOption2) {
    EditorOption2[EditorOption2["acceptSuggestionOnCommitCharacter"] = 0] = "acceptSuggestionOnCommitCharacter";
    EditorOption2[EditorOption2["acceptSuggestionOnEnter"] = 1] = "acceptSuggestionOnEnter";
    EditorOption2[EditorOption2["accessibilitySupport"] = 2] = "accessibilitySupport";
    EditorOption2[EditorOption2["accessibilityPageSize"] = 3] = "accessibilityPageSize";
    EditorOption2[EditorOption2["ariaLabel"] = 4] = "ariaLabel";
    EditorOption2[EditorOption2["autoClosingBrackets"] = 5] = "autoClosingBrackets";
    EditorOption2[EditorOption2["autoClosingDelete"] = 6] = "autoClosingDelete";
    EditorOption2[EditorOption2["autoClosingOvertype"] = 7] = "autoClosingOvertype";
    EditorOption2[EditorOption2["autoClosingQuotes"] = 8] = "autoClosingQuotes";
    EditorOption2[EditorOption2["autoIndent"] = 9] = "autoIndent";
    EditorOption2[EditorOption2["automaticLayout"] = 10] = "automaticLayout";
    EditorOption2[EditorOption2["autoSurround"] = 11] = "autoSurround";
    EditorOption2[EditorOption2["bracketPairColorization"] = 12] = "bracketPairColorization";
    EditorOption2[EditorOption2["guides"] = 13] = "guides";
    EditorOption2[EditorOption2["codeLens"] = 14] = "codeLens";
    EditorOption2[EditorOption2["codeLensFontFamily"] = 15] = "codeLensFontFamily";
    EditorOption2[EditorOption2["codeLensFontSize"] = 16] = "codeLensFontSize";
    EditorOption2[EditorOption2["colorDecorators"] = 17] = "colorDecorators";
    EditorOption2[EditorOption2["columnSelection"] = 18] = "columnSelection";
    EditorOption2[EditorOption2["comments"] = 19] = "comments";
    EditorOption2[EditorOption2["contextmenu"] = 20] = "contextmenu";
    EditorOption2[EditorOption2["copyWithSyntaxHighlighting"] = 21] = "copyWithSyntaxHighlighting";
    EditorOption2[EditorOption2["cursorBlinking"] = 22] = "cursorBlinking";
    EditorOption2[EditorOption2["cursorSmoothCaretAnimation"] = 23] = "cursorSmoothCaretAnimation";
    EditorOption2[EditorOption2["cursorStyle"] = 24] = "cursorStyle";
    EditorOption2[EditorOption2["cursorSurroundingLines"] = 25] = "cursorSurroundingLines";
    EditorOption2[EditorOption2["cursorSurroundingLinesStyle"] = 26] = "cursorSurroundingLinesStyle";
    EditorOption2[EditorOption2["cursorWidth"] = 27] = "cursorWidth";
    EditorOption2[EditorOption2["disableLayerHinting"] = 28] = "disableLayerHinting";
    EditorOption2[EditorOption2["disableMonospaceOptimizations"] = 29] = "disableMonospaceOptimizations";
    EditorOption2[EditorOption2["domReadOnly"] = 30] = "domReadOnly";
    EditorOption2[EditorOption2["dragAndDrop"] = 31] = "dragAndDrop";
    EditorOption2[EditorOption2["emptySelectionClipboard"] = 32] = "emptySelectionClipboard";
    EditorOption2[EditorOption2["extraEditorClassName"] = 33] = "extraEditorClassName";
    EditorOption2[EditorOption2["fastScrollSensitivity"] = 34] = "fastScrollSensitivity";
    EditorOption2[EditorOption2["find"] = 35] = "find";
    EditorOption2[EditorOption2["fixedOverflowWidgets"] = 36] = "fixedOverflowWidgets";
    EditorOption2[EditorOption2["folding"] = 37] = "folding";
    EditorOption2[EditorOption2["foldingStrategy"] = 38] = "foldingStrategy";
    EditorOption2[EditorOption2["foldingHighlight"] = 39] = "foldingHighlight";
    EditorOption2[EditorOption2["foldingImportsByDefault"] = 40] = "foldingImportsByDefault";
    EditorOption2[EditorOption2["foldingMaximumRegions"] = 41] = "foldingMaximumRegions";
    EditorOption2[EditorOption2["unfoldOnClickAfterEndOfLine"] = 42] = "unfoldOnClickAfterEndOfLine";
    EditorOption2[EditorOption2["fontFamily"] = 43] = "fontFamily";
    EditorOption2[EditorOption2["fontInfo"] = 44] = "fontInfo";
    EditorOption2[EditorOption2["fontLigatures"] = 45] = "fontLigatures";
    EditorOption2[EditorOption2["fontSize"] = 46] = "fontSize";
    EditorOption2[EditorOption2["fontWeight"] = 47] = "fontWeight";
    EditorOption2[EditorOption2["formatOnPaste"] = 48] = "formatOnPaste";
    EditorOption2[EditorOption2["formatOnType"] = 49] = "formatOnType";
    EditorOption2[EditorOption2["glyphMargin"] = 50] = "glyphMargin";
    EditorOption2[EditorOption2["gotoLocation"] = 51] = "gotoLocation";
    EditorOption2[EditorOption2["hideCursorInOverviewRuler"] = 52] = "hideCursorInOverviewRuler";
    EditorOption2[EditorOption2["hover"] = 53] = "hover";
    EditorOption2[EditorOption2["inDiffEditor"] = 54] = "inDiffEditor";
    EditorOption2[EditorOption2["inlineSuggest"] = 55] = "inlineSuggest";
    EditorOption2[EditorOption2["letterSpacing"] = 56] = "letterSpacing";
    EditorOption2[EditorOption2["lightbulb"] = 57] = "lightbulb";
    EditorOption2[EditorOption2["lineDecorationsWidth"] = 58] = "lineDecorationsWidth";
    EditorOption2[EditorOption2["lineHeight"] = 59] = "lineHeight";
    EditorOption2[EditorOption2["lineNumbers"] = 60] = "lineNumbers";
    EditorOption2[EditorOption2["lineNumbersMinChars"] = 61] = "lineNumbersMinChars";
    EditorOption2[EditorOption2["linkedEditing"] = 62] = "linkedEditing";
    EditorOption2[EditorOption2["links"] = 63] = "links";
    EditorOption2[EditorOption2["matchBrackets"] = 64] = "matchBrackets";
    EditorOption2[EditorOption2["minimap"] = 65] = "minimap";
    EditorOption2[EditorOption2["mouseStyle"] = 66] = "mouseStyle";
    EditorOption2[EditorOption2["mouseWheelScrollSensitivity"] = 67] = "mouseWheelScrollSensitivity";
    EditorOption2[EditorOption2["mouseWheelZoom"] = 68] = "mouseWheelZoom";
    EditorOption2[EditorOption2["multiCursorMergeOverlapping"] = 69] = "multiCursorMergeOverlapping";
    EditorOption2[EditorOption2["multiCursorModifier"] = 70] = "multiCursorModifier";
    EditorOption2[EditorOption2["multiCursorPaste"] = 71] = "multiCursorPaste";
    EditorOption2[EditorOption2["occurrencesHighlight"] = 72] = "occurrencesHighlight";
    EditorOption2[EditorOption2["overviewRulerBorder"] = 73] = "overviewRulerBorder";
    EditorOption2[EditorOption2["overviewRulerLanes"] = 74] = "overviewRulerLanes";
    EditorOption2[EditorOption2["padding"] = 75] = "padding";
    EditorOption2[EditorOption2["parameterHints"] = 76] = "parameterHints";
    EditorOption2[EditorOption2["peekWidgetDefaultFocus"] = 77] = "peekWidgetDefaultFocus";
    EditorOption2[EditorOption2["definitionLinkOpensInPeek"] = 78] = "definitionLinkOpensInPeek";
    EditorOption2[EditorOption2["quickSuggestions"] = 79] = "quickSuggestions";
    EditorOption2[EditorOption2["quickSuggestionsDelay"] = 80] = "quickSuggestionsDelay";
    EditorOption2[EditorOption2["readOnly"] = 81] = "readOnly";
    EditorOption2[EditorOption2["renameOnType"] = 82] = "renameOnType";
    EditorOption2[EditorOption2["renderControlCharacters"] = 83] = "renderControlCharacters";
    EditorOption2[EditorOption2["renderFinalNewline"] = 84] = "renderFinalNewline";
    EditorOption2[EditorOption2["renderLineHighlight"] = 85] = "renderLineHighlight";
    EditorOption2[EditorOption2["renderLineHighlightOnlyWhenFocus"] = 86] = "renderLineHighlightOnlyWhenFocus";
    EditorOption2[EditorOption2["renderValidationDecorations"] = 87] = "renderValidationDecorations";
    EditorOption2[EditorOption2["renderWhitespace"] = 88] = "renderWhitespace";
    EditorOption2[EditorOption2["revealHorizontalRightPadding"] = 89] = "revealHorizontalRightPadding";
    EditorOption2[EditorOption2["roundedSelection"] = 90] = "roundedSelection";
    EditorOption2[EditorOption2["rulers"] = 91] = "rulers";
    EditorOption2[EditorOption2["scrollbar"] = 92] = "scrollbar";
    EditorOption2[EditorOption2["scrollBeyondLastColumn"] = 93] = "scrollBeyondLastColumn";
    EditorOption2[EditorOption2["scrollBeyondLastLine"] = 94] = "scrollBeyondLastLine";
    EditorOption2[EditorOption2["scrollPredominantAxis"] = 95] = "scrollPredominantAxis";
    EditorOption2[EditorOption2["selectionClipboard"] = 96] = "selectionClipboard";
    EditorOption2[EditorOption2["selectionHighlight"] = 97] = "selectionHighlight";
    EditorOption2[EditorOption2["selectOnLineNumbers"] = 98] = "selectOnLineNumbers";
    EditorOption2[EditorOption2["showFoldingControls"] = 99] = "showFoldingControls";
    EditorOption2[EditorOption2["showUnused"] = 100] = "showUnused";
    EditorOption2[EditorOption2["snippetSuggestions"] = 101] = "snippetSuggestions";
    EditorOption2[EditorOption2["smartSelect"] = 102] = "smartSelect";
    EditorOption2[EditorOption2["smoothScrolling"] = 103] = "smoothScrolling";
    EditorOption2[EditorOption2["stickyTabStops"] = 104] = "stickyTabStops";
    EditorOption2[EditorOption2["stopRenderingLineAfter"] = 105] = "stopRenderingLineAfter";
    EditorOption2[EditorOption2["suggest"] = 106] = "suggest";
    EditorOption2[EditorOption2["suggestFontSize"] = 107] = "suggestFontSize";
    EditorOption2[EditorOption2["suggestLineHeight"] = 108] = "suggestLineHeight";
    EditorOption2[EditorOption2["suggestOnTriggerCharacters"] = 109] = "suggestOnTriggerCharacters";
    EditorOption2[EditorOption2["suggestSelection"] = 110] = "suggestSelection";
    EditorOption2[EditorOption2["tabCompletion"] = 111] = "tabCompletion";
    EditorOption2[EditorOption2["tabIndex"] = 112] = "tabIndex";
    EditorOption2[EditorOption2["unicodeHighlighting"] = 113] = "unicodeHighlighting";
    EditorOption2[EditorOption2["unusualLineTerminators"] = 114] = "unusualLineTerminators";
    EditorOption2[EditorOption2["useShadowDOM"] = 115] = "useShadowDOM";
    EditorOption2[EditorOption2["useTabStops"] = 116] = "useTabStops";
    EditorOption2[EditorOption2["wordSeparators"] = 117] = "wordSeparators";
    EditorOption2[EditorOption2["wordWrap"] = 118] = "wordWrap";
    EditorOption2[EditorOption2["wordWrapBreakAfterCharacters"] = 119] = "wordWrapBreakAfterCharacters";
    EditorOption2[EditorOption2["wordWrapBreakBeforeCharacters"] = 120] = "wordWrapBreakBeforeCharacters";
    EditorOption2[EditorOption2["wordWrapColumn"] = 121] = "wordWrapColumn";
    EditorOption2[EditorOption2["wordWrapOverride1"] = 122] = "wordWrapOverride1";
    EditorOption2[EditorOption2["wordWrapOverride2"] = 123] = "wordWrapOverride2";
    EditorOption2[EditorOption2["wrappingIndent"] = 124] = "wrappingIndent";
    EditorOption2[EditorOption2["wrappingStrategy"] = 125] = "wrappingStrategy";
    EditorOption2[EditorOption2["showDeprecated"] = 126] = "showDeprecated";
    EditorOption2[EditorOption2["inlayHints"] = 127] = "inlayHints";
    EditorOption2[EditorOption2["editorClassName"] = 128] = "editorClassName";
    EditorOption2[EditorOption2["pixelRatio"] = 129] = "pixelRatio";
    EditorOption2[EditorOption2["tabFocusMode"] = 130] = "tabFocusMode";
    EditorOption2[EditorOption2["layoutInfo"] = 131] = "layoutInfo";
    EditorOption2[EditorOption2["wrappingInfo"] = 132] = "wrappingInfo";
  })(EditorOption || (EditorOption = {}));
  var EndOfLinePreference;
  (function(EndOfLinePreference2) {
    EndOfLinePreference2[EndOfLinePreference2["TextDefined"] = 0] = "TextDefined";
    EndOfLinePreference2[EndOfLinePreference2["LF"] = 1] = "LF";
    EndOfLinePreference2[EndOfLinePreference2["CRLF"] = 2] = "CRLF";
  })(EndOfLinePreference || (EndOfLinePreference = {}));
  var EndOfLineSequence;
  (function(EndOfLineSequence2) {
    EndOfLineSequence2[EndOfLineSequence2["LF"] = 0] = "LF";
    EndOfLineSequence2[EndOfLineSequence2["CRLF"] = 1] = "CRLF";
  })(EndOfLineSequence || (EndOfLineSequence = {}));
  var IndentAction;
  (function(IndentAction2) {
    IndentAction2[IndentAction2["None"] = 0] = "None";
    IndentAction2[IndentAction2["Indent"] = 1] = "Indent";
    IndentAction2[IndentAction2["IndentOutdent"] = 2] = "IndentOutdent";
    IndentAction2[IndentAction2["Outdent"] = 3] = "Outdent";
  })(IndentAction || (IndentAction = {}));
  var InjectedTextCursorStops;
  (function(InjectedTextCursorStops3) {
    InjectedTextCursorStops3[InjectedTextCursorStops3["Both"] = 0] = "Both";
    InjectedTextCursorStops3[InjectedTextCursorStops3["Right"] = 1] = "Right";
    InjectedTextCursorStops3[InjectedTextCursorStops3["Left"] = 2] = "Left";
    InjectedTextCursorStops3[InjectedTextCursorStops3["None"] = 3] = "None";
  })(InjectedTextCursorStops || (InjectedTextCursorStops = {}));
  var InlayHintKind2;
  (function(InlayHintKind3) {
    InlayHintKind3[InlayHintKind3["Type"] = 1] = "Type";
    InlayHintKind3[InlayHintKind3["Parameter"] = 2] = "Parameter";
  })(InlayHintKind2 || (InlayHintKind2 = {}));
  var InlineCompletionTriggerKind2;
  (function(InlineCompletionTriggerKind3) {
    InlineCompletionTriggerKind3[InlineCompletionTriggerKind3["Automatic"] = 0] = "Automatic";
    InlineCompletionTriggerKind3[InlineCompletionTriggerKind3["Explicit"] = 1] = "Explicit";
  })(InlineCompletionTriggerKind2 || (InlineCompletionTriggerKind2 = {}));
  var KeyCode;
  (function(KeyCode2) {
    KeyCode2[KeyCode2["DependsOnKbLayout"] = -1] = "DependsOnKbLayout";
    KeyCode2[KeyCode2["Unknown"] = 0] = "Unknown";
    KeyCode2[KeyCode2["Backspace"] = 1] = "Backspace";
    KeyCode2[KeyCode2["Tab"] = 2] = "Tab";
    KeyCode2[KeyCode2["Enter"] = 3] = "Enter";
    KeyCode2[KeyCode2["Shift"] = 4] = "Shift";
    KeyCode2[KeyCode2["Ctrl"] = 5] = "Ctrl";
    KeyCode2[KeyCode2["Alt"] = 6] = "Alt";
    KeyCode2[KeyCode2["PauseBreak"] = 7] = "PauseBreak";
    KeyCode2[KeyCode2["CapsLock"] = 8] = "CapsLock";
    KeyCode2[KeyCode2["Escape"] = 9] = "Escape";
    KeyCode2[KeyCode2["Space"] = 10] = "Space";
    KeyCode2[KeyCode2["PageUp"] = 11] = "PageUp";
    KeyCode2[KeyCode2["PageDown"] = 12] = "PageDown";
    KeyCode2[KeyCode2["End"] = 13] = "End";
    KeyCode2[KeyCode2["Home"] = 14] = "Home";
    KeyCode2[KeyCode2["LeftArrow"] = 15] = "LeftArrow";
    KeyCode2[KeyCode2["UpArrow"] = 16] = "UpArrow";
    KeyCode2[KeyCode2["RightArrow"] = 17] = "RightArrow";
    KeyCode2[KeyCode2["DownArrow"] = 18] = "DownArrow";
    KeyCode2[KeyCode2["Insert"] = 19] = "Insert";
    KeyCode2[KeyCode2["Delete"] = 20] = "Delete";
    KeyCode2[KeyCode2["Digit0"] = 21] = "Digit0";
    KeyCode2[KeyCode2["Digit1"] = 22] = "Digit1";
    KeyCode2[KeyCode2["Digit2"] = 23] = "Digit2";
    KeyCode2[KeyCode2["Digit3"] = 24] = "Digit3";
    KeyCode2[KeyCode2["Digit4"] = 25] = "Digit4";
    KeyCode2[KeyCode2["Digit5"] = 26] = "Digit5";
    KeyCode2[KeyCode2["Digit6"] = 27] = "Digit6";
    KeyCode2[KeyCode2["Digit7"] = 28] = "Digit7";
    KeyCode2[KeyCode2["Digit8"] = 29] = "Digit8";
    KeyCode2[KeyCode2["Digit9"] = 30] = "Digit9";
    KeyCode2[KeyCode2["KeyA"] = 31] = "KeyA";
    KeyCode2[KeyCode2["KeyB"] = 32] = "KeyB";
    KeyCode2[KeyCode2["KeyC"] = 33] = "KeyC";
    KeyCode2[KeyCode2["KeyD"] = 34] = "KeyD";
    KeyCode2[KeyCode2["KeyE"] = 35] = "KeyE";
    KeyCode2[KeyCode2["KeyF"] = 36] = "KeyF";
    KeyCode2[KeyCode2["KeyG"] = 37] = "KeyG";
    KeyCode2[KeyCode2["KeyH"] = 38] = "KeyH";
    KeyCode2[KeyCode2["KeyI"] = 39] = "KeyI";
    KeyCode2[KeyCode2["KeyJ"] = 40] = "KeyJ";
    KeyCode2[KeyCode2["KeyK"] = 41] = "KeyK";
    KeyCode2[KeyCode2["KeyL"] = 42] = "KeyL";
    KeyCode2[KeyCode2["KeyM"] = 43] = "KeyM";
    KeyCode2[KeyCode2["KeyN"] = 44] = "KeyN";
    KeyCode2[KeyCode2["KeyO"] = 45] = "KeyO";
    KeyCode2[KeyCode2["KeyP"] = 46] = "KeyP";
    KeyCode2[KeyCode2["KeyQ"] = 47] = "KeyQ";
    KeyCode2[KeyCode2["KeyR"] = 48] = "KeyR";
    KeyCode2[KeyCode2["KeyS"] = 49] = "KeyS";
    KeyCode2[KeyCode2["KeyT"] = 50] = "KeyT";
    KeyCode2[KeyCode2["KeyU"] = 51] = "KeyU";
    KeyCode2[KeyCode2["KeyV"] = 52] = "KeyV";
    KeyCode2[KeyCode2["KeyW"] = 53] = "KeyW";
    KeyCode2[KeyCode2["KeyX"] = 54] = "KeyX";
    KeyCode2[KeyCode2["KeyY"] = 55] = "KeyY";
    KeyCode2[KeyCode2["KeyZ"] = 56] = "KeyZ";
    KeyCode2[KeyCode2["Meta"] = 57] = "Meta";
    KeyCode2[KeyCode2["ContextMenu"] = 58] = "ContextMenu";
    KeyCode2[KeyCode2["F1"] = 59] = "F1";
    KeyCode2[KeyCode2["F2"] = 60] = "F2";
    KeyCode2[KeyCode2["F3"] = 61] = "F3";
    KeyCode2[KeyCode2["F4"] = 62] = "F4";
    KeyCode2[KeyCode2["F5"] = 63] = "F5";
    KeyCode2[KeyCode2["F6"] = 64] = "F6";
    KeyCode2[KeyCode2["F7"] = 65] = "F7";
    KeyCode2[KeyCode2["F8"] = 66] = "F8";
    KeyCode2[KeyCode2["F9"] = 67] = "F9";
    KeyCode2[KeyCode2["F10"] = 68] = "F10";
    KeyCode2[KeyCode2["F11"] = 69] = "F11";
    KeyCode2[KeyCode2["F12"] = 70] = "F12";
    KeyCode2[KeyCode2["F13"] = 71] = "F13";
    KeyCode2[KeyCode2["F14"] = 72] = "F14";
    KeyCode2[KeyCode2["F15"] = 73] = "F15";
    KeyCode2[KeyCode2["F16"] = 74] = "F16";
    KeyCode2[KeyCode2["F17"] = 75] = "F17";
    KeyCode2[KeyCode2["F18"] = 76] = "F18";
    KeyCode2[KeyCode2["F19"] = 77] = "F19";
    KeyCode2[KeyCode2["NumLock"] = 78] = "NumLock";
    KeyCode2[KeyCode2["ScrollLock"] = 79] = "ScrollLock";
    KeyCode2[KeyCode2["Semicolon"] = 80] = "Semicolon";
    KeyCode2[KeyCode2["Equal"] = 81] = "Equal";
    KeyCode2[KeyCode2["Comma"] = 82] = "Comma";
    KeyCode2[KeyCode2["Minus"] = 83] = "Minus";
    KeyCode2[KeyCode2["Period"] = 84] = "Period";
    KeyCode2[KeyCode2["Slash"] = 85] = "Slash";
    KeyCode2[KeyCode2["Backquote"] = 86] = "Backquote";
    KeyCode2[KeyCode2["BracketLeft"] = 87] = "BracketLeft";
    KeyCode2[KeyCode2["Backslash"] = 88] = "Backslash";
    KeyCode2[KeyCode2["BracketRight"] = 89] = "BracketRight";
    KeyCode2[KeyCode2["Quote"] = 90] = "Quote";
    KeyCode2[KeyCode2["OEM_8"] = 91] = "OEM_8";
    KeyCode2[KeyCode2["IntlBackslash"] = 92] = "IntlBackslash";
    KeyCode2[KeyCode2["Numpad0"] = 93] = "Numpad0";
    KeyCode2[KeyCode2["Numpad1"] = 94] = "Numpad1";
    KeyCode2[KeyCode2["Numpad2"] = 95] = "Numpad2";
    KeyCode2[KeyCode2["Numpad3"] = 96] = "Numpad3";
    KeyCode2[KeyCode2["Numpad4"] = 97] = "Numpad4";
    KeyCode2[KeyCode2["Numpad5"] = 98] = "Numpad5";
    KeyCode2[KeyCode2["Numpad6"] = 99] = "Numpad6";
    KeyCode2[KeyCode2["Numpad7"] = 100] = "Numpad7";
    KeyCode2[KeyCode2["Numpad8"] = 101] = "Numpad8";
    KeyCode2[KeyCode2["Numpad9"] = 102] = "Numpad9";
    KeyCode2[KeyCode2["NumpadMultiply"] = 103] = "NumpadMultiply";
    KeyCode2[KeyCode2["NumpadAdd"] = 104] = "NumpadAdd";
    KeyCode2[KeyCode2["NUMPAD_SEPARATOR"] = 105] = "NUMPAD_SEPARATOR";
    KeyCode2[KeyCode2["NumpadSubtract"] = 106] = "NumpadSubtract";
    KeyCode2[KeyCode2["NumpadDecimal"] = 107] = "NumpadDecimal";
    KeyCode2[KeyCode2["NumpadDivide"] = 108] = "NumpadDivide";
    KeyCode2[KeyCode2["KEY_IN_COMPOSITION"] = 109] = "KEY_IN_COMPOSITION";
    KeyCode2[KeyCode2["ABNT_C1"] = 110] = "ABNT_C1";
    KeyCode2[KeyCode2["ABNT_C2"] = 111] = "ABNT_C2";
    KeyCode2[KeyCode2["AudioVolumeMute"] = 112] = "AudioVolumeMute";
    KeyCode2[KeyCode2["AudioVolumeUp"] = 113] = "AudioVolumeUp";
    KeyCode2[KeyCode2["AudioVolumeDown"] = 114] = "AudioVolumeDown";
    KeyCode2[KeyCode2["BrowserSearch"] = 115] = "BrowserSearch";
    KeyCode2[KeyCode2["BrowserHome"] = 116] = "BrowserHome";
    KeyCode2[KeyCode2["BrowserBack"] = 117] = "BrowserBack";
    KeyCode2[KeyCode2["BrowserForward"] = 118] = "BrowserForward";
    KeyCode2[KeyCode2["MediaTrackNext"] = 119] = "MediaTrackNext";
    KeyCode2[KeyCode2["MediaTrackPrevious"] = 120] = "MediaTrackPrevious";
    KeyCode2[KeyCode2["MediaStop"] = 121] = "MediaStop";
    KeyCode2[KeyCode2["MediaPlayPause"] = 122] = "MediaPlayPause";
    KeyCode2[KeyCode2["LaunchMediaPlayer"] = 123] = "LaunchMediaPlayer";
    KeyCode2[KeyCode2["LaunchMail"] = 124] = "LaunchMail";
    KeyCode2[KeyCode2["LaunchApp2"] = 125] = "LaunchApp2";
    KeyCode2[KeyCode2["Clear"] = 126] = "Clear";
    KeyCode2[KeyCode2["MAX_VALUE"] = 127] = "MAX_VALUE";
  })(KeyCode || (KeyCode = {}));
  var MarkerSeverity;
  (function(MarkerSeverity2) {
    MarkerSeverity2[MarkerSeverity2["Hint"] = 1] = "Hint";
    MarkerSeverity2[MarkerSeverity2["Info"] = 2] = "Info";
    MarkerSeverity2[MarkerSeverity2["Warning"] = 4] = "Warning";
    MarkerSeverity2[MarkerSeverity2["Error"] = 8] = "Error";
  })(MarkerSeverity || (MarkerSeverity = {}));
  var MarkerTag;
  (function(MarkerTag2) {
    MarkerTag2[MarkerTag2["Unnecessary"] = 1] = "Unnecessary";
    MarkerTag2[MarkerTag2["Deprecated"] = 2] = "Deprecated";
  })(MarkerTag || (MarkerTag = {}));
  var MinimapPosition;
  (function(MinimapPosition3) {
    MinimapPosition3[MinimapPosition3["Inline"] = 1] = "Inline";
    MinimapPosition3[MinimapPosition3["Gutter"] = 2] = "Gutter";
  })(MinimapPosition || (MinimapPosition = {}));
  var MouseTargetType;
  (function(MouseTargetType2) {
    MouseTargetType2[MouseTargetType2["UNKNOWN"] = 0] = "UNKNOWN";
    MouseTargetType2[MouseTargetType2["TEXTAREA"] = 1] = "TEXTAREA";
    MouseTargetType2[MouseTargetType2["GUTTER_GLYPH_MARGIN"] = 2] = "GUTTER_GLYPH_MARGIN";
    MouseTargetType2[MouseTargetType2["GUTTER_LINE_NUMBERS"] = 3] = "GUTTER_LINE_NUMBERS";
    MouseTargetType2[MouseTargetType2["GUTTER_LINE_DECORATIONS"] = 4] = "GUTTER_LINE_DECORATIONS";
    MouseTargetType2[MouseTargetType2["GUTTER_VIEW_ZONE"] = 5] = "GUTTER_VIEW_ZONE";
    MouseTargetType2[MouseTargetType2["CONTENT_TEXT"] = 6] = "CONTENT_TEXT";
    MouseTargetType2[MouseTargetType2["CONTENT_EMPTY"] = 7] = "CONTENT_EMPTY";
    MouseTargetType2[MouseTargetType2["CONTENT_VIEW_ZONE"] = 8] = "CONTENT_VIEW_ZONE";
    MouseTargetType2[MouseTargetType2["CONTENT_WIDGET"] = 9] = "CONTENT_WIDGET";
    MouseTargetType2[MouseTargetType2["OVERVIEW_RULER"] = 10] = "OVERVIEW_RULER";
    MouseTargetType2[MouseTargetType2["SCROLLBAR"] = 11] = "SCROLLBAR";
    MouseTargetType2[MouseTargetType2["OVERLAY_WIDGET"] = 12] = "OVERLAY_WIDGET";
    MouseTargetType2[MouseTargetType2["OUTSIDE_EDITOR"] = 13] = "OUTSIDE_EDITOR";
  })(MouseTargetType || (MouseTargetType = {}));
  var OverlayWidgetPositionPreference;
  (function(OverlayWidgetPositionPreference2) {
    OverlayWidgetPositionPreference2[OverlayWidgetPositionPreference2["TOP_RIGHT_CORNER"] = 0] = "TOP_RIGHT_CORNER";
    OverlayWidgetPositionPreference2[OverlayWidgetPositionPreference2["BOTTOM_RIGHT_CORNER"] = 1] = "BOTTOM_RIGHT_CORNER";
    OverlayWidgetPositionPreference2[OverlayWidgetPositionPreference2["TOP_CENTER"] = 2] = "TOP_CENTER";
  })(OverlayWidgetPositionPreference || (OverlayWidgetPositionPreference = {}));
  var OverviewRulerLane;
  (function(OverviewRulerLane3) {
    OverviewRulerLane3[OverviewRulerLane3["Left"] = 1] = "Left";
    OverviewRulerLane3[OverviewRulerLane3["Center"] = 2] = "Center";
    OverviewRulerLane3[OverviewRulerLane3["Right"] = 4] = "Right";
    OverviewRulerLane3[OverviewRulerLane3["Full"] = 7] = "Full";
  })(OverviewRulerLane || (OverviewRulerLane = {}));
  var PositionAffinity;
  (function(PositionAffinity2) {
    PositionAffinity2[PositionAffinity2["Left"] = 0] = "Left";
    PositionAffinity2[PositionAffinity2["Right"] = 1] = "Right";
    PositionAffinity2[PositionAffinity2["None"] = 2] = "None";
  })(PositionAffinity || (PositionAffinity = {}));
  var RenderLineNumbersType;
  (function(RenderLineNumbersType2) {
    RenderLineNumbersType2[RenderLineNumbersType2["Off"] = 0] = "Off";
    RenderLineNumbersType2[RenderLineNumbersType2["On"] = 1] = "On";
    RenderLineNumbersType2[RenderLineNumbersType2["Relative"] = 2] = "Relative";
    RenderLineNumbersType2[RenderLineNumbersType2["Interval"] = 3] = "Interval";
    RenderLineNumbersType2[RenderLineNumbersType2["Custom"] = 4] = "Custom";
  })(RenderLineNumbersType || (RenderLineNumbersType = {}));
  var RenderMinimap;
  (function(RenderMinimap2) {
    RenderMinimap2[RenderMinimap2["None"] = 0] = "None";
    RenderMinimap2[RenderMinimap2["Text"] = 1] = "Text";
    RenderMinimap2[RenderMinimap2["Blocks"] = 2] = "Blocks";
  })(RenderMinimap || (RenderMinimap = {}));
  var ScrollType;
  (function(ScrollType2) {
    ScrollType2[ScrollType2["Smooth"] = 0] = "Smooth";
    ScrollType2[ScrollType2["Immediate"] = 1] = "Immediate";
  })(ScrollType || (ScrollType = {}));
  var ScrollbarVisibility;
  (function(ScrollbarVisibility2) {
    ScrollbarVisibility2[ScrollbarVisibility2["Auto"] = 1] = "Auto";
    ScrollbarVisibility2[ScrollbarVisibility2["Hidden"] = 2] = "Hidden";
    ScrollbarVisibility2[ScrollbarVisibility2["Visible"] = 3] = "Visible";
  })(ScrollbarVisibility || (ScrollbarVisibility = {}));
  var SelectionDirection;
  (function(SelectionDirection2) {
    SelectionDirection2[SelectionDirection2["LTR"] = 0] = "LTR";
    SelectionDirection2[SelectionDirection2["RTL"] = 1] = "RTL";
  })(SelectionDirection || (SelectionDirection = {}));
  var SignatureHelpTriggerKind2;
  (function(SignatureHelpTriggerKind3) {
    SignatureHelpTriggerKind3[SignatureHelpTriggerKind3["Invoke"] = 1] = "Invoke";
    SignatureHelpTriggerKind3[SignatureHelpTriggerKind3["TriggerCharacter"] = 2] = "TriggerCharacter";
    SignatureHelpTriggerKind3[SignatureHelpTriggerKind3["ContentChange"] = 3] = "ContentChange";
  })(SignatureHelpTriggerKind2 || (SignatureHelpTriggerKind2 = {}));
  var SymbolKind;
  (function(SymbolKind2) {
    SymbolKind2[SymbolKind2["File"] = 0] = "File";
    SymbolKind2[SymbolKind2["Module"] = 1] = "Module";
    SymbolKind2[SymbolKind2["Namespace"] = 2] = "Namespace";
    SymbolKind2[SymbolKind2["Package"] = 3] = "Package";
    SymbolKind2[SymbolKind2["Class"] = 4] = "Class";
    SymbolKind2[SymbolKind2["Method"] = 5] = "Method";
    SymbolKind2[SymbolKind2["Property"] = 6] = "Property";
    SymbolKind2[SymbolKind2["Field"] = 7] = "Field";
    SymbolKind2[SymbolKind2["Constructor"] = 8] = "Constructor";
    SymbolKind2[SymbolKind2["Enum"] = 9] = "Enum";
    SymbolKind2[SymbolKind2["Interface"] = 10] = "Interface";
    SymbolKind2[SymbolKind2["Function"] = 11] = "Function";
    SymbolKind2[SymbolKind2["Variable"] = 12] = "Variable";
    SymbolKind2[SymbolKind2["Constant"] = 13] = "Constant";
    SymbolKind2[SymbolKind2["String"] = 14] = "String";
    SymbolKind2[SymbolKind2["Number"] = 15] = "Number";
    SymbolKind2[SymbolKind2["Boolean"] = 16] = "Boolean";
    SymbolKind2[SymbolKind2["Array"] = 17] = "Array";
    SymbolKind2[SymbolKind2["Object"] = 18] = "Object";
    SymbolKind2[SymbolKind2["Key"] = 19] = "Key";
    SymbolKind2[SymbolKind2["Null"] = 20] = "Null";
    SymbolKind2[SymbolKind2["EnumMember"] = 21] = "EnumMember";
    SymbolKind2[SymbolKind2["Struct"] = 22] = "Struct";
    SymbolKind2[SymbolKind2["Event"] = 23] = "Event";
    SymbolKind2[SymbolKind2["Operator"] = 24] = "Operator";
    SymbolKind2[SymbolKind2["TypeParameter"] = 25] = "TypeParameter";
  })(SymbolKind || (SymbolKind = {}));
  var SymbolTag;
  (function(SymbolTag2) {
    SymbolTag2[SymbolTag2["Deprecated"] = 1] = "Deprecated";
  })(SymbolTag || (SymbolTag = {}));
  var TextEditorCursorBlinkingStyle;
  (function(TextEditorCursorBlinkingStyle2) {
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Hidden"] = 0] = "Hidden";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Blink"] = 1] = "Blink";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Smooth"] = 2] = "Smooth";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Phase"] = 3] = "Phase";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Expand"] = 4] = "Expand";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Solid"] = 5] = "Solid";
  })(TextEditorCursorBlinkingStyle || (TextEditorCursorBlinkingStyle = {}));
  var TextEditorCursorStyle;
  (function(TextEditorCursorStyle2) {
    TextEditorCursorStyle2[TextEditorCursorStyle2["Line"] = 1] = "Line";
    TextEditorCursorStyle2[TextEditorCursorStyle2["Block"] = 2] = "Block";
    TextEditorCursorStyle2[TextEditorCursorStyle2["Underline"] = 3] = "Underline";
    TextEditorCursorStyle2[TextEditorCursorStyle2["LineThin"] = 4] = "LineThin";
    TextEditorCursorStyle2[TextEditorCursorStyle2["BlockOutline"] = 5] = "BlockOutline";
    TextEditorCursorStyle2[TextEditorCursorStyle2["UnderlineThin"] = 6] = "UnderlineThin";
  })(TextEditorCursorStyle || (TextEditorCursorStyle = {}));
  var TrackedRangeStickiness;
  (function(TrackedRangeStickiness2) {
    TrackedRangeStickiness2[TrackedRangeStickiness2["AlwaysGrowsWhenTypingAtEdges"] = 0] = "AlwaysGrowsWhenTypingAtEdges";
    TrackedRangeStickiness2[TrackedRangeStickiness2["NeverGrowsWhenTypingAtEdges"] = 1] = "NeverGrowsWhenTypingAtEdges";
    TrackedRangeStickiness2[TrackedRangeStickiness2["GrowsOnlyWhenTypingBefore"] = 2] = "GrowsOnlyWhenTypingBefore";
    TrackedRangeStickiness2[TrackedRangeStickiness2["GrowsOnlyWhenTypingAfter"] = 3] = "GrowsOnlyWhenTypingAfter";
  })(TrackedRangeStickiness || (TrackedRangeStickiness = {}));
  var WrappingIndent;
  (function(WrappingIndent2) {
    WrappingIndent2[WrappingIndent2["None"] = 0] = "None";
    WrappingIndent2[WrappingIndent2["Same"] = 1] = "Same";
    WrappingIndent2[WrappingIndent2["Indent"] = 2] = "Indent";
    WrappingIndent2[WrappingIndent2["DeepIndent"] = 3] = "DeepIndent";
  })(WrappingIndent || (WrappingIndent = {}));

  // node_modules/monaco-editor/esm/vs/editor/common/services/editorBaseApi.js
  var KeyMod = class {
    static chord(firstPart, secondPart) {
      return KeyChord(firstPart, secondPart);
    }
  };
  KeyMod.CtrlCmd = 2048;
  KeyMod.Shift = 1024;
  KeyMod.Alt = 512;
  KeyMod.WinCtrl = 256;
  function createMonacoBaseAPI() {
    return {
      editor: void 0,
      languages: void 0,
      CancellationTokenSource,
      Emitter,
      KeyCode,
      KeyMod,
      Position,
      Range,
      Selection,
      SelectionDirection,
      MarkerSeverity,
      MarkerTag,
      Uri: URI,
      Token
    };
  }

  // node_modules/monaco-editor/esm/vs/editor/common/core/wordCharacterClassifier.js
  var WordCharacterClassifier = class extends CharacterClassifier {
    constructor(wordSeparators) {
      super(0);
      for (let i = 0, len = wordSeparators.length; i < len; i++) {
        this.set(wordSeparators.charCodeAt(i), 2);
      }
      this.set(32, 1);
      this.set(9, 1);
    }
  };
  function once2(computeFn) {
    const cache = {};
    return (input) => {
      if (!cache.hasOwnProperty(input)) {
        cache[input] = computeFn(input);
      }
      return cache[input];
    };
  }
  var getMapForWordSeparators = once2((input) => new WordCharacterClassifier(input));

  // node_modules/monaco-editor/esm/vs/editor/common/model.js
  var OverviewRulerLane2;
  (function(OverviewRulerLane3) {
    OverviewRulerLane3[OverviewRulerLane3["Left"] = 1] = "Left";
    OverviewRulerLane3[OverviewRulerLane3["Center"] = 2] = "Center";
    OverviewRulerLane3[OverviewRulerLane3["Right"] = 4] = "Right";
    OverviewRulerLane3[OverviewRulerLane3["Full"] = 7] = "Full";
  })(OverviewRulerLane2 || (OverviewRulerLane2 = {}));
  var MinimapPosition2;
  (function(MinimapPosition3) {
    MinimapPosition3[MinimapPosition3["Inline"] = 1] = "Inline";
    MinimapPosition3[MinimapPosition3["Gutter"] = 2] = "Gutter";
  })(MinimapPosition2 || (MinimapPosition2 = {}));
  var InjectedTextCursorStops2;
  (function(InjectedTextCursorStops3) {
    InjectedTextCursorStops3[InjectedTextCursorStops3["Both"] = 0] = "Both";
    InjectedTextCursorStops3[InjectedTextCursorStops3["Right"] = 1] = "Right";
    InjectedTextCursorStops3[InjectedTextCursorStops3["Left"] = 2] = "Left";
    InjectedTextCursorStops3[InjectedTextCursorStops3["None"] = 3] = "None";
  })(InjectedTextCursorStops2 || (InjectedTextCursorStops2 = {}));

  // node_modules/monaco-editor/esm/vs/editor/common/model/textModelSearch.js
  function leftIsWordBounday(wordSeparators, text, textLength, matchStartIndex, matchLength) {
    if (matchStartIndex === 0) {
      return true;
    }
    const charBefore = text.charCodeAt(matchStartIndex - 1);
    if (wordSeparators.get(charBefore) !== 0) {
      return true;
    }
    if (charBefore === 13 || charBefore === 10) {
      return true;
    }
    if (matchLength > 0) {
      const firstCharInMatch = text.charCodeAt(matchStartIndex);
      if (wordSeparators.get(firstCharInMatch) !== 0) {
        return true;
      }
    }
    return false;
  }
  function rightIsWordBounday(wordSeparators, text, textLength, matchStartIndex, matchLength) {
    if (matchStartIndex + matchLength === textLength) {
      return true;
    }
    const charAfter = text.charCodeAt(matchStartIndex + matchLength);
    if (wordSeparators.get(charAfter) !== 0) {
      return true;
    }
    if (charAfter === 13 || charAfter === 10) {
      return true;
    }
    if (matchLength > 0) {
      const lastCharInMatch = text.charCodeAt(matchStartIndex + matchLength - 1);
      if (wordSeparators.get(lastCharInMatch) !== 0) {
        return true;
      }
    }
    return false;
  }
  function isValidMatch(wordSeparators, text, textLength, matchStartIndex, matchLength) {
    return leftIsWordBounday(wordSeparators, text, textLength, matchStartIndex, matchLength) && rightIsWordBounday(wordSeparators, text, textLength, matchStartIndex, matchLength);
  }
  var Searcher = class {
    constructor(wordSeparators, searchRegex) {
      this._wordSeparators = wordSeparators;
      this._searchRegex = searchRegex;
      this._prevMatchStartIndex = -1;
      this._prevMatchLength = 0;
    }
    reset(lastIndex) {
      this._searchRegex.lastIndex = lastIndex;
      this._prevMatchStartIndex = -1;
      this._prevMatchLength = 0;
    }
    next(text) {
      const textLength = text.length;
      let m;
      do {
        if (this._prevMatchStartIndex + this._prevMatchLength === textLength) {
          return null;
        }
        m = this._searchRegex.exec(text);
        if (!m) {
          return null;
        }
        const matchStartIndex = m.index;
        const matchLength = m[0].length;
        if (matchStartIndex === this._prevMatchStartIndex && matchLength === this._prevMatchLength) {
          if (matchLength === 0) {
            if (getNextCodePoint(text, textLength, this._searchRegex.lastIndex) > 65535) {
              this._searchRegex.lastIndex += 2;
            } else {
              this._searchRegex.lastIndex += 1;
            }
            continue;
          }
          return null;
        }
        this._prevMatchStartIndex = matchStartIndex;
        this._prevMatchLength = matchLength;
        if (!this._wordSeparators || isValidMatch(this._wordSeparators, text, textLength, matchStartIndex, matchLength)) {
          return m;
        }
      } while (m);
      return null;
    }
  };

  // node_modules/monaco-editor/esm/vs/editor/common/services/unicodeTextModelHighlighter.js
  var UnicodeTextModelHighlighter = class {
    static computeUnicodeHighlights(model, options, range) {
      const startLine = range ? range.startLineNumber : 1;
      const endLine = range ? range.endLineNumber : model.getLineCount();
      const codePointHighlighter = new CodePointHighlighter(options);
      const candidates = codePointHighlighter.getCandidateCodePoints();
      let regex;
      if (candidates === "allNonBasicAscii") {
        regex = new RegExp("[^\\t\\n\\r\\x20-\\x7E]", "g");
      } else {
        regex = new RegExp(`${buildRegExpCharClassExpr(Array.from(candidates))}`, "g");
      }
      const searcher = new Searcher(null, regex);
      const ranges = [];
      let hasMore = false;
      let m;
      let ambiguousCharacterCount = 0;
      let invisibleCharacterCount = 0;
      let nonBasicAsciiCharacterCount = 0;
      forLoop:
        for (let lineNumber = startLine, lineCount = endLine; lineNumber <= lineCount; lineNumber++) {
          const lineContent = model.getLineContent(lineNumber);
          const lineLength = lineContent.length;
          searcher.reset(0);
          do {
            m = searcher.next(lineContent);
            if (m) {
              let startIndex = m.index;
              let endIndex = m.index + m[0].length;
              if (startIndex > 0) {
                const charCodeBefore = lineContent.charCodeAt(startIndex - 1);
                if (isHighSurrogate(charCodeBefore)) {
                  startIndex--;
                }
              }
              if (endIndex + 1 < lineLength) {
                const charCodeBefore = lineContent.charCodeAt(endIndex - 1);
                if (isHighSurrogate(charCodeBefore)) {
                  endIndex++;
                }
              }
              const str = lineContent.substring(startIndex, endIndex);
              const word = getWordAtText(startIndex + 1, DEFAULT_WORD_REGEXP, lineContent, 0);
              const highlightReason = codePointHighlighter.shouldHighlightNonBasicASCII(str, word ? word.word : null);
              if (highlightReason !== 0) {
                if (highlightReason === 3) {
                  ambiguousCharacterCount++;
                } else if (highlightReason === 2) {
                  invisibleCharacterCount++;
                } else if (highlightReason === 1) {
                  nonBasicAsciiCharacterCount++;
                } else {
                  assertNever(highlightReason);
                }
                const MAX_RESULT_LENGTH = 1e3;
                if (ranges.length >= MAX_RESULT_LENGTH) {
                  hasMore = true;
                  break forLoop;
                }
                ranges.push(new Range(lineNumber, startIndex + 1, lineNumber, endIndex + 1));
              }
            }
          } while (m);
        }
      return {
        ranges,
        hasMore,
        ambiguousCharacterCount,
        invisibleCharacterCount,
        nonBasicAsciiCharacterCount
      };
    }
    static computeUnicodeHighlightReason(char, options) {
      const codePointHighlighter = new CodePointHighlighter(options);
      const reason = codePointHighlighter.shouldHighlightNonBasicASCII(char, null);
      switch (reason) {
        case 0:
          return null;
        case 2:
          return {kind: 1};
        case 3: {
          const codePoint = char.codePointAt(0);
          const primaryConfusable = codePointHighlighter.ambiguousCharacters.getPrimaryConfusable(codePoint);
          const notAmbiguousInLocales = AmbiguousCharacters.getLocales().filter((l) => !AmbiguousCharacters.getInstance(new Set([...options.allowedLocales, l])).isAmbiguous(codePoint));
          return {kind: 0, confusableWith: String.fromCodePoint(primaryConfusable), notAmbiguousInLocales};
        }
        case 1:
          return {kind: 2};
      }
    }
  };
  function buildRegExpCharClassExpr(codePoints, flags) {
    const src = `[${escapeRegExpCharacters(codePoints.map((i) => String.fromCodePoint(i)).join(""))}]`;
    return src;
  }
  var CodePointHighlighter = class {
    constructor(options) {
      this.options = options;
      this.allowedCodePoints = new Set(options.allowedCodePoints);
      this.ambiguousCharacters = AmbiguousCharacters.getInstance(new Set(options.allowedLocales));
    }
    getCandidateCodePoints() {
      if (this.options.nonBasicASCII) {
        return "allNonBasicAscii";
      }
      const set = new Set();
      if (this.options.invisibleCharacters) {
        for (const cp of InvisibleCharacters.codePoints) {
          if (!isAllowedInvisibleCharacter(String.fromCodePoint(cp))) {
            set.add(cp);
          }
        }
      }
      if (this.options.ambiguousCharacters) {
        for (const cp of this.ambiguousCharacters.getConfusableCodePoints()) {
          set.add(cp);
        }
      }
      for (const cp of this.allowedCodePoints) {
        set.delete(cp);
      }
      return set;
    }
    shouldHighlightNonBasicASCII(character, wordContext) {
      const codePoint = character.codePointAt(0);
      if (this.allowedCodePoints.has(codePoint)) {
        return 0;
      }
      if (this.options.nonBasicASCII) {
        return 1;
      }
      let hasBasicASCIICharacters = false;
      let hasNonConfusableNonBasicAsciiCharacter = false;
      if (wordContext) {
        for (let char of wordContext) {
          const codePoint2 = char.codePointAt(0);
          const isBasicASCII2 = isBasicASCII(char);
          hasBasicASCIICharacters = hasBasicASCIICharacters || isBasicASCII2;
          if (!isBasicASCII2 && !this.ambiguousCharacters.isAmbiguous(codePoint2) && !InvisibleCharacters.isInvisibleCharacter(codePoint2)) {
            hasNonConfusableNonBasicAsciiCharacter = true;
          }
        }
      }
      if (!hasBasicASCIICharacters && hasNonConfusableNonBasicAsciiCharacter) {
        return 0;
      }
      if (this.options.invisibleCharacters) {
        if (!isAllowedInvisibleCharacter(character) && InvisibleCharacters.isInvisibleCharacter(codePoint)) {
          return 2;
        }
      }
      if (this.options.ambiguousCharacters) {
        if (this.ambiguousCharacters.isAmbiguous(codePoint)) {
          return 3;
        }
      }
      return 0;
    }
  };
  function isAllowedInvisibleCharacter(character) {
    return character === " " || character === "\n" || character === "	";
  }

  // node_modules/monaco-editor/esm/vs/editor/common/services/editorSimpleWorker.js
  var __awaiter2 = function(thisArg, _arguments, P, generator) {
    function adopt(value) {
      return value instanceof P ? value : new P(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P || (P = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e) {
          reject(e);
        }
      }
      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e) {
          reject(e);
        }
      }
      function step(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  var MirrorModel = class extends MirrorTextModel {
    get uri() {
      return this._uri;
    }
    get eol() {
      return this._eol;
    }
    getValue() {
      return this.getText();
    }
    getLinesContent() {
      return this._lines.slice(0);
    }
    getLineCount() {
      return this._lines.length;
    }
    getLineContent(lineNumber) {
      return this._lines[lineNumber - 1];
    }
    getWordAtPosition(position, wordDefinition) {
      const wordAtText = getWordAtText(position.column, ensureValidWordDefinition(wordDefinition), this._lines[position.lineNumber - 1], 0);
      if (wordAtText) {
        return new Range(position.lineNumber, wordAtText.startColumn, position.lineNumber, wordAtText.endColumn);
      }
      return null;
    }
    words(wordDefinition) {
      const lines = this._lines;
      const wordenize = this._wordenize.bind(this);
      let lineNumber = 0;
      let lineText = "";
      let wordRangesIdx = 0;
      let wordRanges = [];
      return {
        *[Symbol.iterator]() {
          while (true) {
            if (wordRangesIdx < wordRanges.length) {
              const value = lineText.substring(wordRanges[wordRangesIdx].start, wordRanges[wordRangesIdx].end);
              wordRangesIdx += 1;
              yield value;
            } else {
              if (lineNumber < lines.length) {
                lineText = lines[lineNumber];
                wordRanges = wordenize(lineText, wordDefinition);
                wordRangesIdx = 0;
                lineNumber += 1;
              } else {
                break;
              }
            }
          }
        }
      };
    }
    getLineWords(lineNumber, wordDefinition) {
      const content = this._lines[lineNumber - 1];
      const ranges = this._wordenize(content, wordDefinition);
      const words = [];
      for (const range of ranges) {
        words.push({
          word: content.substring(range.start, range.end),
          startColumn: range.start + 1,
          endColumn: range.end + 1
        });
      }
      return words;
    }
    _wordenize(content, wordDefinition) {
      const result = [];
      let match;
      wordDefinition.lastIndex = 0;
      while (match = wordDefinition.exec(content)) {
        if (match[0].length === 0) {
          break;
        }
        result.push({start: match.index, end: match.index + match[0].length});
      }
      return result;
    }
    getValueInRange(range) {
      range = this._validateRange(range);
      if (range.startLineNumber === range.endLineNumber) {
        return this._lines[range.startLineNumber - 1].substring(range.startColumn - 1, range.endColumn - 1);
      }
      const lineEnding = this._eol;
      const startLineIndex = range.startLineNumber - 1;
      const endLineIndex = range.endLineNumber - 1;
      const resultLines = [];
      resultLines.push(this._lines[startLineIndex].substring(range.startColumn - 1));
      for (let i = startLineIndex + 1; i < endLineIndex; i++) {
        resultLines.push(this._lines[i]);
      }
      resultLines.push(this._lines[endLineIndex].substring(0, range.endColumn - 1));
      return resultLines.join(lineEnding);
    }
    offsetAt(position) {
      position = this._validatePosition(position);
      this._ensureLineStarts();
      return this._lineStarts.getPrefixSum(position.lineNumber - 2) + (position.column - 1);
    }
    positionAt(offset) {
      offset = Math.floor(offset);
      offset = Math.max(0, offset);
      this._ensureLineStarts();
      const out = this._lineStarts.getIndexOf(offset);
      const lineLength = this._lines[out.index].length;
      return {
        lineNumber: 1 + out.index,
        column: 1 + Math.min(out.remainder, lineLength)
      };
    }
    _validateRange(range) {
      const start = this._validatePosition({lineNumber: range.startLineNumber, column: range.startColumn});
      const end = this._validatePosition({lineNumber: range.endLineNumber, column: range.endColumn});
      if (start.lineNumber !== range.startLineNumber || start.column !== range.startColumn || end.lineNumber !== range.endLineNumber || end.column !== range.endColumn) {
        return {
          startLineNumber: start.lineNumber,
          startColumn: start.column,
          endLineNumber: end.lineNumber,
          endColumn: end.column
        };
      }
      return range;
    }
    _validatePosition(position) {
      if (!Position.isIPosition(position)) {
        throw new Error("bad position");
      }
      let {lineNumber, column} = position;
      let hasChanged = false;
      if (lineNumber < 1) {
        lineNumber = 1;
        column = 1;
        hasChanged = true;
      } else if (lineNumber > this._lines.length) {
        lineNumber = this._lines.length;
        column = this._lines[lineNumber - 1].length + 1;
        hasChanged = true;
      } else {
        const maxCharacter = this._lines[lineNumber - 1].length + 1;
        if (column < 1) {
          column = 1;
          hasChanged = true;
        } else if (column > maxCharacter) {
          column = maxCharacter;
          hasChanged = true;
        }
      }
      if (!hasChanged) {
        return position;
      } else {
        return {lineNumber, column};
      }
    }
  };
  var EditorSimpleWorker = class {
    constructor(host, foreignModuleFactory) {
      this._host = host;
      this._models = Object.create(null);
      this._foreignModuleFactory = foreignModuleFactory;
      this._foreignModule = null;
    }
    dispose() {
      this._models = Object.create(null);
    }
    _getModel(uri) {
      return this._models[uri];
    }
    _getModels() {
      const all = [];
      Object.keys(this._models).forEach((key) => all.push(this._models[key]));
      return all;
    }
    acceptNewModel(data) {
      this._models[data.url] = new MirrorModel(URI.parse(data.url), data.lines, data.EOL, data.versionId);
    }
    acceptModelChanged(strURL, e) {
      if (!this._models[strURL]) {
        return;
      }
      const model = this._models[strURL];
      model.onEvents(e);
    }
    acceptRemovedModel(strURL) {
      if (!this._models[strURL]) {
        return;
      }
      delete this._models[strURL];
    }
    computeUnicodeHighlights(url, options, range) {
      return __awaiter2(this, void 0, void 0, function* () {
        const model = this._getModel(url);
        if (!model) {
          return {ranges: [], hasMore: false, ambiguousCharacterCount: 0, invisibleCharacterCount: 0, nonBasicAsciiCharacterCount: 0};
        }
        return UnicodeTextModelHighlighter.computeUnicodeHighlights(model, options, range);
      });
    }
    computeDiff(originalUrl, modifiedUrl, ignoreTrimWhitespace, maxComputationTime) {
      return __awaiter2(this, void 0, void 0, function* () {
        const original = this._getModel(originalUrl);
        const modified = this._getModel(modifiedUrl);
        if (!original || !modified) {
          return null;
        }
        const originalLines = original.getLinesContent();
        const modifiedLines = modified.getLinesContent();
        const diffComputer = new DiffComputer(originalLines, modifiedLines, {
          shouldComputeCharChanges: true,
          shouldPostProcessCharChanges: true,
          shouldIgnoreTrimWhitespace: ignoreTrimWhitespace,
          shouldMakePrettyDiff: true,
          maxComputationTime
        });
        const diffResult = diffComputer.computeDiff();
        const identical = diffResult.changes.length > 0 ? false : this._modelsAreIdentical(original, modified);
        return {
          quitEarly: diffResult.quitEarly,
          identical,
          changes: diffResult.changes
        };
      });
    }
    _modelsAreIdentical(original, modified) {
      const originalLineCount = original.getLineCount();
      const modifiedLineCount = modified.getLineCount();
      if (originalLineCount !== modifiedLineCount) {
        return false;
      }
      for (let line = 1; line <= originalLineCount; line++) {
        const originalLine = original.getLineContent(line);
        const modifiedLine = modified.getLineContent(line);
        if (originalLine !== modifiedLine) {
          return false;
        }
      }
      return true;
    }
    computeMoreMinimalEdits(modelUrl, edits) {
      return __awaiter2(this, void 0, void 0, function* () {
        const model = this._getModel(modelUrl);
        if (!model) {
          return edits;
        }
        const result = [];
        let lastEol = void 0;
        edits = edits.slice(0).sort((a, b) => {
          if (a.range && b.range) {
            return Range.compareRangesUsingStarts(a.range, b.range);
          }
          const aRng = a.range ? 0 : 1;
          const bRng = b.range ? 0 : 1;
          return aRng - bRng;
        });
        for (let {range, text, eol} of edits) {
          if (typeof eol === "number") {
            lastEol = eol;
          }
          if (Range.isEmpty(range) && !text) {
            continue;
          }
          const original = model.getValueInRange(range);
          text = text.replace(/\r\n|\n|\r/g, model.eol);
          if (original === text) {
            continue;
          }
          if (Math.max(text.length, original.length) > EditorSimpleWorker._diffLimit) {
            result.push({range, text});
            continue;
          }
          const changes = stringDiff(original, text, false);
          const editOffset = model.offsetAt(Range.lift(range).getStartPosition());
          for (const change of changes) {
            const start = model.positionAt(editOffset + change.originalStart);
            const end = model.positionAt(editOffset + change.originalStart + change.originalLength);
            const newEdit = {
              text: text.substr(change.modifiedStart, change.modifiedLength),
              range: {startLineNumber: start.lineNumber, startColumn: start.column, endLineNumber: end.lineNumber, endColumn: end.column}
            };
            if (model.getValueInRange(newEdit.range) !== newEdit.text) {
              result.push(newEdit);
            }
          }
        }
        if (typeof lastEol === "number") {
          result.push({eol: lastEol, text: "", range: {startLineNumber: 0, startColumn: 0, endLineNumber: 0, endColumn: 0}});
        }
        return result;
      });
    }
    computeLinks(modelUrl) {
      return __awaiter2(this, void 0, void 0, function* () {
        const model = this._getModel(modelUrl);
        if (!model) {
          return null;
        }
        return computeLinks(model);
      });
    }
    textualSuggest(modelUrls, leadingWord, wordDef, wordDefFlags) {
      return __awaiter2(this, void 0, void 0, function* () {
        const sw = new StopWatch(true);
        const wordDefRegExp = new RegExp(wordDef, wordDefFlags);
        const seen = new Set();
        outer:
          for (let url of modelUrls) {
            const model = this._getModel(url);
            if (!model) {
              continue;
            }
            for (let word of model.words(wordDefRegExp)) {
              if (word === leadingWord || !isNaN(Number(word))) {
                continue;
              }
              seen.add(word);
              if (seen.size > EditorSimpleWorker._suggestionsLimit) {
                break outer;
              }
            }
          }
        return {words: Array.from(seen), duration: sw.elapsed()};
      });
    }
    computeWordRanges(modelUrl, range, wordDef, wordDefFlags) {
      return __awaiter2(this, void 0, void 0, function* () {
        const model = this._getModel(modelUrl);
        if (!model) {
          return Object.create(null);
        }
        const wordDefRegExp = new RegExp(wordDef, wordDefFlags);
        const result = Object.create(null);
        for (let line = range.startLineNumber; line < range.endLineNumber; line++) {
          const words = model.getLineWords(line, wordDefRegExp);
          for (const word of words) {
            if (!isNaN(Number(word.word))) {
              continue;
            }
            let array = result[word.word];
            if (!array) {
              array = [];
              result[word.word] = array;
            }
            array.push({
              startLineNumber: line,
              startColumn: word.startColumn,
              endLineNumber: line,
              endColumn: word.endColumn
            });
          }
        }
        return result;
      });
    }
    navigateValueSet(modelUrl, range, up, wordDef, wordDefFlags) {
      return __awaiter2(this, void 0, void 0, function* () {
        const model = this._getModel(modelUrl);
        if (!model) {
          return null;
        }
        const wordDefRegExp = new RegExp(wordDef, wordDefFlags);
        if (range.startColumn === range.endColumn) {
          range = {
            startLineNumber: range.startLineNumber,
            startColumn: range.startColumn,
            endLineNumber: range.endLineNumber,
            endColumn: range.endColumn + 1
          };
        }
        const selectionText = model.getValueInRange(range);
        const wordRange = model.getWordAtPosition({lineNumber: range.startLineNumber, column: range.startColumn}, wordDefRegExp);
        if (!wordRange) {
          return null;
        }
        const word = model.getValueInRange(wordRange);
        const result = BasicInplaceReplace.INSTANCE.navigateValueSet(range, selectionText, wordRange, word, up);
        return result;
      });
    }
    loadForeignModule(moduleId, createData, foreignHostMethods) {
      const proxyMethodRequest = (method, args) => {
        return this._host.fhr(method, args);
      };
      const foreignHost = createProxyObject(foreignHostMethods, proxyMethodRequest);
      const ctx = {
        host: foreignHost,
        getMirrorModels: () => {
          return this._getModels();
        }
      };
      if (this._foreignModuleFactory) {
        this._foreignModule = this._foreignModuleFactory(ctx, createData);
        return Promise.resolve(getAllMethodNames(this._foreignModule));
      }
      return Promise.reject(new Error(`Unexpected usage`));
    }
    fmr(method, args) {
      if (!this._foreignModule || typeof this._foreignModule[method] !== "function") {
        return Promise.reject(new Error("Missing requestHandler or method: " + method));
      }
      try {
        return Promise.resolve(this._foreignModule[method].apply(this._foreignModule, args));
      } catch (e) {
        return Promise.reject(e);
      }
    }
  };
  EditorSimpleWorker._diffLimit = 1e5;
  EditorSimpleWorker._suggestionsLimit = 1e4;
  if (typeof importScripts === "function") {
    globals.monaco = createMonacoBaseAPI();
  }

  // node_modules/monaco-editor/esm/vs/editor/editor.worker.js
  var initialized = false;
  function initialize(foreignModule) {
    if (initialized) {
      return;
    }
    initialized = true;
    const simpleWorker = new SimpleWorkerServer((msg) => {
      self.postMessage(msg);
    }, (host) => new EditorSimpleWorker(host, foreignModule));
    self.onmessage = (e) => {
      simpleWorker.onmessage(e.data);
    };
  }
  self.onmessage = (e) => {
    if (!initialized) {
      initialize(null);
    }
  };

  // node_modules/monaco-editor/esm/vs/language/typescript/ts.worker.js
  /*!-----------------------------------------------------------------------------
   * Copyright (c) Microsoft Corporation. All rights reserved.
   * Version: 0.33.0(4b1abad427e58dbedc1215d99a0902ffc885fcd4)
   * Released under the MIT license
   * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
   *-----------------------------------------------------------------------------*/
  var __defProp = Object.defineProperty;
  var __export = (target, all) => {
    for (var name in all)
      __defProp(target, name, {get: all[name], enumerable: true});
  };
  var typescriptServices_exports = {};
  __export(typescriptServices_exports, {
    EndOfLineState: () => EndOfLineState,
    IndentStyle: () => IndentStyle,
    ScriptKind: () => ScriptKind,
    ScriptTarget: () => ScriptTarget,
    TokenClass: () => TokenClass,
    createClassifier: () => createClassifier,
    createLanguageService: () => createLanguageService,
    displayPartsToString: () => displayPartsToString,
    flattenDiagnosticMessageText: () => flattenDiagnosticMessageText,
    typescript: () => typescript
  });
  var __spreadArray = function(to, from, pack) {
    if (pack || arguments.length === 2)
      for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
          if (!ar)
            ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
        }
      }
    return to.concat(ar || Array.prototype.slice.call(from));
  };
  var __assign = function() {
    __assign = Object.assign || function(t) {
      for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s)
          if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
      }
      return t;
    };
    return __assign.apply(this, arguments);
  };
  var __makeTemplateObject = function(cooked, raw) {
    if (Object.defineProperty) {
      Object.defineProperty(cooked, "raw", {value: raw});
    } else {
      cooked.raw = raw;
    }
    return cooked;
  };
  var __generator = function(thisArg, body) {
    var _ = {label: 0, sent: function() {
      if (t[0] & 1)
        throw t[1];
      return t[1];
    }, trys: [], ops: []}, f, y, t, g;
    return g = {next: verb(0), throw: verb(1), return: verb(2)}, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
      return this;
    }), g;
    function verb(n) {
      return function(v) {
        return step([n, v]);
      };
    }
    function step(op) {
      if (f)
        throw new TypeError("Generator is already executing.");
      while (_)
        try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
            return t;
          if (y = 0, t)
            op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return {value: op[1], done: false};
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2])
                _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
      if (op[0] & 5)
        throw op[1];
      return {value: op[0] ? op[1] : void 0, done: true};
    }
  };
  var __rest = function(s, e) {
    var t = {};
    for (var p in s)
      if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
        if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
          t[p[i]] = s[p[i]];
      }
    return t;
  };
  var __extends = function() {
    var extendStatics = function(d, b) {
      extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d2, b2) {
        d2.__proto__ = b2;
      } || function(d2, b2) {
        for (var p in b2)
          if (Object.prototype.hasOwnProperty.call(b2, p))
            d2[p] = b2[p];
      };
      return extendStatics(d, b);
    };
    return function(d, b) {
      if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
  }();
  (function(ts2) {
    function createMapData() {
      var sentinel = {};
      sentinel.prev = sentinel;
      return {head: sentinel, tail: sentinel, size: 0};
    }
    function createMapEntry(key, value) {
      return {key, value, next: void 0, prev: void 0};
    }
    function sameValueZero(x, y) {
      return x === y || x !== x && y !== y;
    }
    function getPrev(entry) {
      var prev = entry.prev;
      if (!prev || prev === entry)
        throw new Error("Illegal state");
      return prev;
    }
    function getNext(entry) {
      while (entry) {
        var skipNext = !entry.prev;
        entry = entry.next;
        if (skipNext) {
          continue;
        }
        return entry;
      }
    }
    function getEntry(data, key) {
      for (var entry = data.tail; entry !== data.head; entry = getPrev(entry)) {
        if (sameValueZero(entry.key, key)) {
          return entry;
        }
      }
    }
    function addOrUpdateEntry(data, key, value) {
      var existing = getEntry(data, key);
      if (existing) {
        existing.value = value;
        return;
      }
      var entry = createMapEntry(key, value);
      entry.prev = data.tail;
      data.tail.next = entry;
      data.tail = entry;
      data.size++;
      return entry;
    }
    function deleteEntry(data, key) {
      for (var entry = data.tail; entry !== data.head; entry = getPrev(entry)) {
        if (entry.prev === void 0)
          throw new Error("Illegal state");
        if (sameValueZero(entry.key, key)) {
          if (entry.next) {
            entry.next.prev = entry.prev;
          } else {
            if (data.tail !== entry)
              throw new Error("Illegal state");
            data.tail = entry.prev;
          }
          entry.prev.next = entry.next;
          entry.next = entry.prev;
          entry.prev = void 0;
          data.size--;
          return entry;
        }
      }
    }
    function clearEntries(data) {
      var node = data.tail;
      while (node !== data.head) {
        var prev = getPrev(node);
        node.next = data.head;
        node.prev = void 0;
        node = prev;
      }
      data.head.next = void 0;
      data.tail = data.head;
      data.size = 0;
    }
    function forEachEntry(data, action) {
      var entry = data.head;
      while (entry) {
        entry = getNext(entry);
        if (entry) {
          action(entry.value, entry.key);
        }
      }
    }
    function forEachIteration(iterator, action) {
      if (iterator) {
        for (var step = iterator.next(); !step.done; step = iterator.next()) {
          action(step.value);
        }
      }
    }
    function createIteratorData(data, selector) {
      return {current: data.head, selector};
    }
    function iteratorNext(data) {
      data.current = getNext(data.current);
      if (data.current) {
        return {value: data.selector(data.current.key, data.current.value), done: false};
      } else {
        return {value: void 0, done: true};
      }
    }
    var ShimCollections;
    (function(ShimCollections2) {
      function createMapShim(getIterator) {
        var MapIterator = function() {
          function MapIterator2(data, selector) {
            this._data = createIteratorData(data, selector);
          }
          MapIterator2.prototype.next = function() {
            return iteratorNext(this._data);
          };
          return MapIterator2;
        }();
        return function() {
          function Map2(iterable) {
            var _this = this;
            this._mapData = createMapData();
            forEachIteration(getIterator(iterable), function(_a3) {
              var key = _a3[0], value = _a3[1];
              return _this.set(key, value);
            });
          }
          Object.defineProperty(Map2.prototype, "size", {
            get: function() {
              return this._mapData.size;
            },
            enumerable: false,
            configurable: true
          });
          Map2.prototype.get = function(key) {
            var _a3;
            return (_a3 = getEntry(this._mapData, key)) === null || _a3 === void 0 ? void 0 : _a3.value;
          };
          Map2.prototype.set = function(key, value) {
            return addOrUpdateEntry(this._mapData, key, value), this;
          };
          Map2.prototype.has = function(key) {
            return !!getEntry(this._mapData, key);
          };
          Map2.prototype.delete = function(key) {
            return !!deleteEntry(this._mapData, key);
          };
          Map2.prototype.clear = function() {
            clearEntries(this._mapData);
          };
          Map2.prototype.keys = function() {
            return new MapIterator(this._mapData, function(key, _value) {
              return key;
            });
          };
          Map2.prototype.values = function() {
            return new MapIterator(this._mapData, function(_key, value) {
              return value;
            });
          };
          Map2.prototype.entries = function() {
            return new MapIterator(this._mapData, function(key, value) {
              return [key, value];
            });
          };
          Map2.prototype.forEach = function(action) {
            forEachEntry(this._mapData, action);
          };
          return Map2;
        }();
      }
      ShimCollections2.createMapShim = createMapShim;
      function createSetShim(getIterator) {
        var SetIterator = function() {
          function SetIterator2(data, selector) {
            this._data = createIteratorData(data, selector);
          }
          SetIterator2.prototype.next = function() {
            return iteratorNext(this._data);
          };
          return SetIterator2;
        }();
        return function() {
          function Set2(iterable) {
            var _this = this;
            this._mapData = createMapData();
            forEachIteration(getIterator(iterable), function(value) {
              return _this.add(value);
            });
          }
          Object.defineProperty(Set2.prototype, "size", {
            get: function() {
              return this._mapData.size;
            },
            enumerable: false,
            configurable: true
          });
          Set2.prototype.add = function(value) {
            return addOrUpdateEntry(this._mapData, value, value), this;
          };
          Set2.prototype.has = function(value) {
            return !!getEntry(this._mapData, value);
          };
          Set2.prototype.delete = function(value) {
            return !!deleteEntry(this._mapData, value);
          };
          Set2.prototype.clear = function() {
            clearEntries(this._mapData);
          };
          Set2.prototype.keys = function() {
            return new SetIterator(this._mapData, function(key, _value) {
              return key;
            });
          };
          Set2.prototype.values = function() {
            return new SetIterator(this._mapData, function(_key, value) {
              return value;
            });
          };
          Set2.prototype.entries = function() {
            return new SetIterator(this._mapData, function(key, value) {
              return [key, value];
            });
          };
          Set2.prototype.forEach = function(action) {
            forEachEntry(this._mapData, action);
          };
          return Set2;
        }();
      }
      ShimCollections2.createSetShim = createSetShim;
    })(ShimCollections = ts2.ShimCollections || (ts2.ShimCollections = {}));
  })(ts || (ts = {}));
  (function(ts2) {
    ts2.versionMajorMinor = "4.5";
    ts2.version = "4.5.5";
    var Comparison;
    (function(Comparison2) {
      Comparison2[Comparison2["LessThan"] = -1] = "LessThan";
      Comparison2[Comparison2["EqualTo"] = 0] = "EqualTo";
      Comparison2[Comparison2["GreaterThan"] = 1] = "GreaterThan";
    })(Comparison = ts2.Comparison || (ts2.Comparison = {}));
    var NativeCollections;
    (function(NativeCollections2) {
      function tryGetNativeMap() {
        return typeof Map !== "undefined" && "entries" in Map.prototype && (/* @__PURE__ */ new Map([[0, 0]])).size === 1 ? Map : void 0;
      }
      NativeCollections2.tryGetNativeMap = tryGetNativeMap;
      function tryGetNativeSet() {
        return typeof Set !== "undefined" && "entries" in Set.prototype && (/* @__PURE__ */ new Set([0])).size === 1 ? Set : void 0;
      }
      NativeCollections2.tryGetNativeSet = tryGetNativeSet;
    })(NativeCollections || (NativeCollections = {}));
    ts2.Map = getCollectionImplementation("Map", "tryGetNativeMap", "createMapShim");
    ts2.Set = getCollectionImplementation("Set", "tryGetNativeSet", "createSetShim");
    function getCollectionImplementation(name, nativeFactory, shimFactory) {
      var _a3;
      var constructor = (_a3 = NativeCollections[nativeFactory]()) !== null && _a3 !== void 0 ? _a3 : ts2.ShimCollections === null || ts2.ShimCollections === void 0 ? void 0 : ts2.ShimCollections[shimFactory](ts2.getIterator);
      if (constructor)
        return constructor;
      throw new Error("TypeScript requires an environment that provides a compatible native ".concat(name, " implementation."));
    }
  })(ts || (ts = {}));
  (function(ts2) {
    function getIterator(iterable) {
      if (iterable) {
        if (isArray2(iterable))
          return arrayIterator(iterable);
        if (iterable instanceof ts2.Map)
          return iterable.entries();
        if (iterable instanceof ts2.Set)
          return iterable.values();
        throw new Error("Iteration not supported.");
      }
    }
    ts2.getIterator = getIterator;
    ts2.emptyArray = [];
    ts2.emptyMap = new ts2.Map();
    ts2.emptySet = new ts2.Set();
    function createMap() {
      return new ts2.Map();
    }
    ts2.createMap = createMap;
    function createMapFromTemplate(template) {
      var map2 = new ts2.Map();
      for (var key in template) {
        if (hasOwnProperty.call(template, key)) {
          map2.set(key, template[key]);
        }
      }
      return map2;
    }
    ts2.createMapFromTemplate = createMapFromTemplate;
    function length(array) {
      return array ? array.length : 0;
    }
    ts2.length = length;
    function forEach(array, callback) {
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var result = callback(array[i], i);
          if (result) {
            return result;
          }
        }
      }
      return void 0;
    }
    ts2.forEach = forEach;
    function forEachRight(array, callback) {
      if (array) {
        for (var i = array.length - 1; i >= 0; i--) {
          var result = callback(array[i], i);
          if (result) {
            return result;
          }
        }
      }
      return void 0;
    }
    ts2.forEachRight = forEachRight;
    function firstDefined(array, callback) {
      if (array === void 0) {
        return void 0;
      }
      for (var i = 0; i < array.length; i++) {
        var result = callback(array[i], i);
        if (result !== void 0) {
          return result;
        }
      }
      return void 0;
    }
    ts2.firstDefined = firstDefined;
    function firstDefinedIterator(iter, callback) {
      while (true) {
        var iterResult = iter.next();
        if (iterResult.done) {
          return void 0;
        }
        var result = callback(iterResult.value);
        if (result !== void 0) {
          return result;
        }
      }
    }
    ts2.firstDefinedIterator = firstDefinedIterator;
    function reduceLeftIterator(iterator, f, initial) {
      var result = initial;
      if (iterator) {
        for (var step = iterator.next(), pos = 0; !step.done; step = iterator.next(), pos++) {
          result = f(result, step.value, pos);
        }
      }
      return result;
    }
    ts2.reduceLeftIterator = reduceLeftIterator;
    function zipWith(arrayA, arrayB, callback) {
      var result = [];
      ts2.Debug.assertEqual(arrayA.length, arrayB.length);
      for (var i = 0; i < arrayA.length; i++) {
        result.push(callback(arrayA[i], arrayB[i], i));
      }
      return result;
    }
    ts2.zipWith = zipWith;
    function zipToIterator(arrayA, arrayB) {
      ts2.Debug.assertEqual(arrayA.length, arrayB.length);
      var i = 0;
      return {
        next: function() {
          if (i === arrayA.length) {
            return {value: void 0, done: true};
          }
          i++;
          return {value: [arrayA[i - 1], arrayB[i - 1]], done: false};
        }
      };
    }
    ts2.zipToIterator = zipToIterator;
    function zipToMap(keys, values) {
      ts2.Debug.assert(keys.length === values.length);
      var map2 = new ts2.Map();
      for (var i = 0; i < keys.length; ++i) {
        map2.set(keys[i], values[i]);
      }
      return map2;
    }
    ts2.zipToMap = zipToMap;
    function intersperse(input, element) {
      if (input.length <= 1) {
        return input;
      }
      var result = [];
      for (var i = 0, n = input.length; i < n; i++) {
        if (i)
          result.push(element);
        result.push(input[i]);
      }
      return result;
    }
    ts2.intersperse = intersperse;
    function every(array, callback) {
      if (array) {
        for (var i = 0; i < array.length; i++) {
          if (!callback(array[i], i)) {
            return false;
          }
        }
      }
      return true;
    }
    ts2.every = every;
    function find(array, predicate) {
      for (var i = 0; i < array.length; i++) {
        var value = array[i];
        if (predicate(value, i)) {
          return value;
        }
      }
      return void 0;
    }
    ts2.find = find;
    function findLast(array, predicate) {
      for (var i = array.length - 1; i >= 0; i--) {
        var value = array[i];
        if (predicate(value, i)) {
          return value;
        }
      }
      return void 0;
    }
    ts2.findLast = findLast;
    function findIndex(array, predicate, startIndex) {
      for (var i = startIndex || 0; i < array.length; i++) {
        if (predicate(array[i], i)) {
          return i;
        }
      }
      return -1;
    }
    ts2.findIndex = findIndex;
    function findLastIndex(array, predicate, startIndex) {
      for (var i = startIndex === void 0 ? array.length - 1 : startIndex; i >= 0; i--) {
        if (predicate(array[i], i)) {
          return i;
        }
      }
      return -1;
    }
    ts2.findLastIndex = findLastIndex;
    function findMap(array, callback) {
      for (var i = 0; i < array.length; i++) {
        var result = callback(array[i], i);
        if (result) {
          return result;
        }
      }
      return ts2.Debug.fail();
    }
    ts2.findMap = findMap;
    function contains(array, value, equalityComparer) {
      if (equalityComparer === void 0) {
        equalityComparer = equateValues;
      }
      if (array) {
        for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
          var v = array_1[_i];
          if (equalityComparer(v, value)) {
            return true;
          }
        }
      }
      return false;
    }
    ts2.contains = contains;
    function arraysEqual(a, b, equalityComparer) {
      if (equalityComparer === void 0) {
        equalityComparer = equateValues;
      }
      return a.length === b.length && a.every(function(x, i) {
        return equalityComparer(x, b[i]);
      });
    }
    ts2.arraysEqual = arraysEqual;
    function indexOfAnyCharCode(text, charCodes, start) {
      for (var i = start || 0; i < text.length; i++) {
        if (contains(charCodes, text.charCodeAt(i))) {
          return i;
        }
      }
      return -1;
    }
    ts2.indexOfAnyCharCode = indexOfAnyCharCode;
    function countWhere(array, predicate) {
      var count = 0;
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var v = array[i];
          if (predicate(v, i)) {
            count++;
          }
        }
      }
      return count;
    }
    ts2.countWhere = countWhere;
    function filter(array, f) {
      if (array) {
        var len = array.length;
        var i = 0;
        while (i < len && f(array[i]))
          i++;
        if (i < len) {
          var result = array.slice(0, i);
          i++;
          while (i < len) {
            var item = array[i];
            if (f(item)) {
              result.push(item);
            }
            i++;
          }
          return result;
        }
      }
      return array;
    }
    ts2.filter = filter;
    function filterMutate(array, f) {
      var outIndex = 0;
      for (var i = 0; i < array.length; i++) {
        if (f(array[i], i, array)) {
          array[outIndex] = array[i];
          outIndex++;
        }
      }
      array.length = outIndex;
    }
    ts2.filterMutate = filterMutate;
    function clear(array) {
      array.length = 0;
    }
    ts2.clear = clear;
    function map(array, f) {
      var result;
      if (array) {
        result = [];
        for (var i = 0; i < array.length; i++) {
          result.push(f(array[i], i));
        }
      }
      return result;
    }
    ts2.map = map;
    function mapIterator(iter, mapFn) {
      return {
        next: function() {
          var iterRes = iter.next();
          return iterRes.done ? iterRes : {value: mapFn(iterRes.value), done: false};
        }
      };
    }
    ts2.mapIterator = mapIterator;
    function sameMap(array, f) {
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var item = array[i];
          var mapped = f(item, i);
          if (item !== mapped) {
            var result = array.slice(0, i);
            result.push(mapped);
            for (i++; i < array.length; i++) {
              result.push(f(array[i], i));
            }
            return result;
          }
        }
      }
      return array;
    }
    ts2.sameMap = sameMap;
    function flatten(array) {
      var result = [];
      for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
        var v = array_2[_i];
        if (v) {
          if (isArray2(v)) {
            addRange(result, v);
          } else {
            result.push(v);
          }
        }
      }
      return result;
    }
    ts2.flatten = flatten;
    function flatMap(array, mapfn) {
      var result;
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var v = mapfn(array[i], i);
          if (v) {
            if (isArray2(v)) {
              result = addRange(result, v);
            } else {
              result = append(result, v);
            }
          }
        }
      }
      return result || ts2.emptyArray;
    }
    ts2.flatMap = flatMap;
    function flatMapToMutable(array, mapfn) {
      var result = [];
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var v = mapfn(array[i], i);
          if (v) {
            if (isArray2(v)) {
              addRange(result, v);
            } else {
              result.push(v);
            }
          }
        }
      }
      return result;
    }
    ts2.flatMapToMutable = flatMapToMutable;
    function flatMapIterator(iter, mapfn) {
      var first2 = iter.next();
      if (first2.done) {
        return ts2.emptyIterator;
      }
      var currentIter = getIterator2(first2.value);
      return {
        next: function() {
          while (true) {
            var currentRes = currentIter.next();
            if (!currentRes.done) {
              return currentRes;
            }
            var iterRes = iter.next();
            if (iterRes.done) {
              return iterRes;
            }
            currentIter = getIterator2(iterRes.value);
          }
        }
      };
      function getIterator2(x) {
        var res = mapfn(x);
        return res === void 0 ? ts2.emptyIterator : isArray2(res) ? arrayIterator(res) : res;
      }
    }
    ts2.flatMapIterator = flatMapIterator;
    function sameFlatMap(array, mapfn) {
      var result;
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var item = array[i];
          var mapped = mapfn(item, i);
          if (result || item !== mapped || isArray2(mapped)) {
            if (!result) {
              result = array.slice(0, i);
            }
            if (isArray2(mapped)) {
              addRange(result, mapped);
            } else {
              result.push(mapped);
            }
          }
        }
      }
      return result || array;
    }
    ts2.sameFlatMap = sameFlatMap;
    function mapAllOrFail(array, mapFn) {
      var result = [];
      for (var i = 0; i < array.length; i++) {
        var mapped = mapFn(array[i], i);
        if (mapped === void 0) {
          return void 0;
        }
        result.push(mapped);
      }
      return result;
    }
    ts2.mapAllOrFail = mapAllOrFail;
    function mapDefined(array, mapFn) {
      var result = [];
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var mapped = mapFn(array[i], i);
          if (mapped !== void 0) {
            result.push(mapped);
          }
        }
      }
      return result;
    }
    ts2.mapDefined = mapDefined;
    function mapDefinedIterator(iter, mapFn) {
      return {
        next: function() {
          while (true) {
            var res = iter.next();
            if (res.done) {
              return res;
            }
            var value = mapFn(res.value);
            if (value !== void 0) {
              return {value, done: false};
            }
          }
        }
      };
    }
    ts2.mapDefinedIterator = mapDefinedIterator;
    function mapDefinedEntries(map2, f) {
      if (!map2) {
        return void 0;
      }
      var result = new ts2.Map();
      map2.forEach(function(value, key) {
        var entry = f(key, value);
        if (entry !== void 0) {
          var newKey = entry[0], newValue = entry[1];
          if (newKey !== void 0 && newValue !== void 0) {
            result.set(newKey, newValue);
          }
        }
      });
      return result;
    }
    ts2.mapDefinedEntries = mapDefinedEntries;
    function mapDefinedValues(set, f) {
      if (set) {
        var result_1 = new ts2.Set();
        set.forEach(function(value) {
          var newValue = f(value);
          if (newValue !== void 0) {
            result_1.add(newValue);
          }
        });
        return result_1;
      }
    }
    ts2.mapDefinedValues = mapDefinedValues;
    function getOrUpdate(map2, key, callback) {
      if (map2.has(key)) {
        return map2.get(key);
      }
      var value = callback();
      map2.set(key, value);
      return value;
    }
    ts2.getOrUpdate = getOrUpdate;
    function tryAddToSet(set, value) {
      if (!set.has(value)) {
        set.add(value);
        return true;
      }
      return false;
    }
    ts2.tryAddToSet = tryAddToSet;
    ts2.emptyIterator = {next: function() {
      return {value: void 0, done: true};
    }};
    function singleIterator(value) {
      var done = false;
      return {
        next: function() {
          var wasDone = done;
          done = true;
          return wasDone ? {value: void 0, done: true} : {value, done: false};
        }
      };
    }
    ts2.singleIterator = singleIterator;
    function spanMap(array, keyfn, mapfn) {
      var result;
      if (array) {
        result = [];
        var len = array.length;
        var previousKey = void 0;
        var key = void 0;
        var start = 0;
        var pos = 0;
        while (start < len) {
          while (pos < len) {
            var value = array[pos];
            key = keyfn(value, pos);
            if (pos === 0) {
              previousKey = key;
            } else if (key !== previousKey) {
              break;
            }
            pos++;
          }
          if (start < pos) {
            var v = mapfn(array.slice(start, pos), previousKey, start, pos);
            if (v) {
              result.push(v);
            }
            start = pos;
          }
          previousKey = key;
          pos++;
        }
      }
      return result;
    }
    ts2.spanMap = spanMap;
    function mapEntries(map2, f) {
      if (!map2) {
        return void 0;
      }
      var result = new ts2.Map();
      map2.forEach(function(value, key) {
        var _a3 = f(key, value), newKey = _a3[0], newValue = _a3[1];
        result.set(newKey, newValue);
      });
      return result;
    }
    ts2.mapEntries = mapEntries;
    function some(array, predicate) {
      if (array) {
        if (predicate) {
          for (var _i = 0, array_3 = array; _i < array_3.length; _i++) {
            var v = array_3[_i];
            if (predicate(v)) {
              return true;
            }
          }
        } else {
          return array.length > 0;
        }
      }
      return false;
    }
    ts2.some = some;
    function getRangesWhere(arr, pred, cb) {
      var start;
      for (var i = 0; i < arr.length; i++) {
        if (pred(arr[i])) {
          start = start === void 0 ? i : start;
        } else {
          if (start !== void 0) {
            cb(start, i);
            start = void 0;
          }
        }
      }
      if (start !== void 0)
        cb(start, arr.length);
    }
    ts2.getRangesWhere = getRangesWhere;
    function concatenate(array1, array2) {
      if (!some(array2))
        return array1;
      if (!some(array1))
        return array2;
      return __spreadArray(__spreadArray([], array1, true), array2, true);
    }
    ts2.concatenate = concatenate;
    function selectIndex(_, i) {
      return i;
    }
    function indicesOf(array) {
      return array.map(selectIndex);
    }
    ts2.indicesOf = indicesOf;
    function deduplicateRelational(array, equalityComparer, comparer) {
      var indices = indicesOf(array);
      stableSortIndices(array, indices, comparer);
      var last2 = array[indices[0]];
      var deduplicated = [indices[0]];
      for (var i = 1; i < indices.length; i++) {
        var index = indices[i];
        var item = array[index];
        if (!equalityComparer(last2, item)) {
          deduplicated.push(index);
          last2 = item;
        }
      }
      deduplicated.sort();
      return deduplicated.map(function(i2) {
        return array[i2];
      });
    }
    function deduplicateEquality(array, equalityComparer) {
      var result = [];
      for (var _i = 0, array_4 = array; _i < array_4.length; _i++) {
        var item = array_4[_i];
        pushIfUnique(result, item, equalityComparer);
      }
      return result;
    }
    function deduplicate(array, equalityComparer, comparer) {
      return array.length === 0 ? [] : array.length === 1 ? array.slice() : comparer ? deduplicateRelational(array, equalityComparer, comparer) : deduplicateEquality(array, equalityComparer);
    }
    ts2.deduplicate = deduplicate;
    function deduplicateSorted(array, comparer) {
      if (array.length === 0)
        return ts2.emptyArray;
      var last2 = array[0];
      var deduplicated = [last2];
      for (var i = 1; i < array.length; i++) {
        var next = array[i];
        switch (comparer(next, last2)) {
          case true:
          case 0:
            continue;
          case -1:
            return ts2.Debug.fail("Array is unsorted.");
        }
        deduplicated.push(last2 = next);
      }
      return deduplicated;
    }
    function insertSorted(array, insert, compare) {
      if (array.length === 0) {
        array.push(insert);
        return;
      }
      var insertIndex = binarySearch(array, insert, identity, compare);
      if (insertIndex < 0) {
        array.splice(~insertIndex, 0, insert);
      }
    }
    ts2.insertSorted = insertSorted;
    function sortAndDeduplicate(array, comparer, equalityComparer) {
      return deduplicateSorted(sort(array, comparer), equalityComparer || comparer || compareStringsCaseSensitive);
    }
    ts2.sortAndDeduplicate = sortAndDeduplicate;
    function arrayIsSorted(array, comparer) {
      if (array.length < 2)
        return true;
      var prevElement = array[0];
      for (var _i = 0, _a3 = array.slice(1); _i < _a3.length; _i++) {
        var element = _a3[_i];
        if (comparer(prevElement, element) === 1) {
          return false;
        }
        prevElement = element;
      }
      return true;
    }
    ts2.arrayIsSorted = arrayIsSorted;
    function arrayIsEqualTo(array1, array2, equalityComparer) {
      if (equalityComparer === void 0) {
        equalityComparer = equateValues;
      }
      if (!array1 || !array2) {
        return array1 === array2;
      }
      if (array1.length !== array2.length) {
        return false;
      }
      for (var i = 0; i < array1.length; i++) {
        if (!equalityComparer(array1[i], array2[i], i)) {
          return false;
        }
      }
      return true;
    }
    ts2.arrayIsEqualTo = arrayIsEqualTo;
    function compact(array) {
      var result;
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var v = array[i];
          if (result || !v) {
            if (!result) {
              result = array.slice(0, i);
            }
            if (v) {
              result.push(v);
            }
          }
        }
      }
      return result || array;
    }
    ts2.compact = compact;
    function relativeComplement(arrayA, arrayB, comparer) {
      if (!arrayB || !arrayA || arrayB.length === 0 || arrayA.length === 0)
        return arrayB;
      var result = [];
      loopB:
        for (var offsetA = 0, offsetB = 0; offsetB < arrayB.length; offsetB++) {
          if (offsetB > 0) {
            ts2.Debug.assertGreaterThanOrEqual(comparer(arrayB[offsetB], arrayB[offsetB - 1]), 0);
          }
          loopA:
            for (var startA = offsetA; offsetA < arrayA.length; offsetA++) {
              if (offsetA > startA) {
                ts2.Debug.assertGreaterThanOrEqual(comparer(arrayA[offsetA], arrayA[offsetA - 1]), 0);
              }
              switch (comparer(arrayB[offsetB], arrayA[offsetA])) {
                case -1:
                  result.push(arrayB[offsetB]);
                  continue loopB;
                case 0:
                  continue loopB;
                case 1:
                  continue loopA;
              }
            }
        }
      return result;
    }
    ts2.relativeComplement = relativeComplement;
    function sum(array, prop) {
      var result = 0;
      for (var _i = 0, array_5 = array; _i < array_5.length; _i++) {
        var v = array_5[_i];
        result += v[prop];
      }
      return result;
    }
    ts2.sum = sum;
    function append(to, value) {
      if (value === void 0)
        return to;
      if (to === void 0)
        return [value];
      to.push(value);
      return to;
    }
    ts2.append = append;
    function combine(xs, ys) {
      if (xs === void 0)
        return ys;
      if (ys === void 0)
        return xs;
      if (isArray2(xs))
        return isArray2(ys) ? concatenate(xs, ys) : append(xs, ys);
      if (isArray2(ys))
        return append(ys, xs);
      return [xs, ys];
    }
    ts2.combine = combine;
    function toOffset(array, offset) {
      return offset < 0 ? array.length + offset : offset;
    }
    function addRange(to, from, start, end) {
      if (from === void 0 || from.length === 0)
        return to;
      if (to === void 0)
        return from.slice(start, end);
      start = start === void 0 ? 0 : toOffset(from, start);
      end = end === void 0 ? from.length : toOffset(from, end);
      for (var i = start; i < end && i < from.length; i++) {
        if (from[i] !== void 0) {
          to.push(from[i]);
        }
      }
      return to;
    }
    ts2.addRange = addRange;
    function pushIfUnique(array, toAdd, equalityComparer) {
      if (contains(array, toAdd, equalityComparer)) {
        return false;
      } else {
        array.push(toAdd);
        return true;
      }
    }
    ts2.pushIfUnique = pushIfUnique;
    function appendIfUnique(array, toAdd, equalityComparer) {
      if (array) {
        pushIfUnique(array, toAdd, equalityComparer);
        return array;
      } else {
        return [toAdd];
      }
    }
    ts2.appendIfUnique = appendIfUnique;
    function stableSortIndices(array, indices, comparer) {
      indices.sort(function(x, y) {
        return comparer(array[x], array[y]) || compareValues(x, y);
      });
    }
    function sort(array, comparer) {
      return array.length === 0 ? array : array.slice().sort(comparer);
    }
    ts2.sort = sort;
    function arrayIterator(array) {
      var i = 0;
      return {next: function() {
        if (i === array.length) {
          return {value: void 0, done: true};
        } else {
          i++;
          return {value: array[i - 1], done: false};
        }
      }};
    }
    ts2.arrayIterator = arrayIterator;
    function arrayReverseIterator(array) {
      var i = array.length;
      return {
        next: function() {
          if (i === 0) {
            return {value: void 0, done: true};
          } else {
            i--;
            return {value: array[i], done: false};
          }
        }
      };
    }
    ts2.arrayReverseIterator = arrayReverseIterator;
    function stableSort(array, comparer) {
      var indices = indicesOf(array);
      stableSortIndices(array, indices, comparer);
      return indices.map(function(i) {
        return array[i];
      });
    }
    ts2.stableSort = stableSort;
    function rangeEquals(array1, array2, pos, end) {
      while (pos < end) {
        if (array1[pos] !== array2[pos]) {
          return false;
        }
        pos++;
      }
      return true;
    }
    ts2.rangeEquals = rangeEquals;
    function elementAt(array, offset) {
      if (array) {
        offset = toOffset(array, offset);
        if (offset < array.length) {
          return array[offset];
        }
      }
      return void 0;
    }
    ts2.elementAt = elementAt;
    function firstOrUndefined(array) {
      return array.length === 0 ? void 0 : array[0];
    }
    ts2.firstOrUndefined = firstOrUndefined;
    function first(array) {
      ts2.Debug.assert(array.length !== 0);
      return array[0];
    }
    ts2.first = first;
    function lastOrUndefined(array) {
      return array.length === 0 ? void 0 : array[array.length - 1];
    }
    ts2.lastOrUndefined = lastOrUndefined;
    function last(array) {
      ts2.Debug.assert(array.length !== 0);
      return array[array.length - 1];
    }
    ts2.last = last;
    function singleOrUndefined(array) {
      return array && array.length === 1 ? array[0] : void 0;
    }
    ts2.singleOrUndefined = singleOrUndefined;
    function singleOrMany(array) {
      return array && array.length === 1 ? array[0] : array;
    }
    ts2.singleOrMany = singleOrMany;
    function replaceElement(array, index, value) {
      var result = array.slice(0);
      result[index] = value;
      return result;
    }
    ts2.replaceElement = replaceElement;
    function binarySearch(array, value, keySelector, keyComparer, offset) {
      return binarySearchKey(array, keySelector(value), keySelector, keyComparer, offset);
    }
    ts2.binarySearch = binarySearch;
    function binarySearchKey(array, key, keySelector, keyComparer, offset) {
      if (!some(array)) {
        return -1;
      }
      var low = offset || 0;
      var high = array.length - 1;
      while (low <= high) {
        var middle = low + (high - low >> 1);
        var midKey = keySelector(array[middle], middle);
        switch (keyComparer(midKey, key)) {
          case -1:
            low = middle + 1;
            break;
          case 0:
            return middle;
          case 1:
            high = middle - 1;
            break;
        }
      }
      return ~low;
    }
    ts2.binarySearchKey = binarySearchKey;
    function reduceLeft(array, f, initial, start, count) {
      if (array && array.length > 0) {
        var size = array.length;
        if (size > 0) {
          var pos = start === void 0 || start < 0 ? 0 : start;
          var end = count === void 0 || pos + count > size - 1 ? size - 1 : pos + count;
          var result = void 0;
          if (arguments.length <= 2) {
            result = array[pos];
            pos++;
          } else {
            result = initial;
          }
          while (pos <= end) {
            result = f(result, array[pos], pos);
            pos++;
          }
          return result;
        }
      }
      return initial;
    }
    ts2.reduceLeft = reduceLeft;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    function hasProperty(map2, key) {
      return hasOwnProperty.call(map2, key);
    }
    ts2.hasProperty = hasProperty;
    function getProperty(map2, key) {
      return hasOwnProperty.call(map2, key) ? map2[key] : void 0;
    }
    ts2.getProperty = getProperty;
    function getOwnKeys(map2) {
      var keys = [];
      for (var key in map2) {
        if (hasOwnProperty.call(map2, key)) {
          keys.push(key);
        }
      }
      return keys;
    }
    ts2.getOwnKeys = getOwnKeys;
    function getAllKeys(obj) {
      var result = [];
      do {
        var names = Object.getOwnPropertyNames(obj);
        for (var _i = 0, names_1 = names; _i < names_1.length; _i++) {
          var name = names_1[_i];
          pushIfUnique(result, name);
        }
      } while (obj = Object.getPrototypeOf(obj));
      return result;
    }
    ts2.getAllKeys = getAllKeys;
    function getOwnValues(sparseArray) {
      var values = [];
      for (var key in sparseArray) {
        if (hasOwnProperty.call(sparseArray, key)) {
          values.push(sparseArray[key]);
        }
      }
      return values;
    }
    ts2.getOwnValues = getOwnValues;
    var _entries = Object.entries || function(obj) {
      var keys = getOwnKeys(obj);
      var result = Array(keys.length);
      for (var i = 0; i < keys.length; i++) {
        result[i] = [keys[i], obj[keys[i]]];
      }
      return result;
    };
    function getEntries(obj) {
      return obj ? _entries(obj) : [];
    }
    ts2.getEntries = getEntries;
    function arrayOf(count, f) {
      var result = new Array(count);
      for (var i = 0; i < count; i++) {
        result[i] = f(i);
      }
      return result;
    }
    ts2.arrayOf = arrayOf;
    function arrayFrom(iterator, map2) {
      var result = [];
      for (var iterResult = iterator.next(); !iterResult.done; iterResult = iterator.next()) {
        result.push(map2 ? map2(iterResult.value) : iterResult.value);
      }
      return result;
    }
    ts2.arrayFrom = arrayFrom;
    function assign(t) {
      var args = [];
      for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
      }
      for (var _a3 = 0, args_1 = args; _a3 < args_1.length; _a3++) {
        var arg = args_1[_a3];
        if (arg === void 0)
          continue;
        for (var p in arg) {
          if (hasProperty(arg, p)) {
            t[p] = arg[p];
          }
        }
      }
      return t;
    }
    ts2.assign = assign;
    function equalOwnProperties(left, right, equalityComparer) {
      if (equalityComparer === void 0) {
        equalityComparer = equateValues;
      }
      if (left === right)
        return true;
      if (!left || !right)
        return false;
      for (var key in left) {
        if (hasOwnProperty.call(left, key)) {
          if (!hasOwnProperty.call(right, key))
            return false;
          if (!equalityComparer(left[key], right[key]))
            return false;
        }
      }
      for (var key in right) {
        if (hasOwnProperty.call(right, key)) {
          if (!hasOwnProperty.call(left, key))
            return false;
        }
      }
      return true;
    }
    ts2.equalOwnProperties = equalOwnProperties;
    function arrayToMap(array, makeKey, makeValue) {
      if (makeValue === void 0) {
        makeValue = identity;
      }
      var result = new ts2.Map();
      for (var _i = 0, array_6 = array; _i < array_6.length; _i++) {
        var value = array_6[_i];
        var key = makeKey(value);
        if (key !== void 0)
          result.set(key, makeValue(value));
      }
      return result;
    }
    ts2.arrayToMap = arrayToMap;
    function arrayToNumericMap(array, makeKey, makeValue) {
      if (makeValue === void 0) {
        makeValue = identity;
      }
      var result = [];
      for (var _i = 0, array_7 = array; _i < array_7.length; _i++) {
        var value = array_7[_i];
        result[makeKey(value)] = makeValue(value);
      }
      return result;
    }
    ts2.arrayToNumericMap = arrayToNumericMap;
    function arrayToMultiMap(values, makeKey, makeValue) {
      if (makeValue === void 0) {
        makeValue = identity;
      }
      var result = createMultiMap();
      for (var _i = 0, values_1 = values; _i < values_1.length; _i++) {
        var value = values_1[_i];
        result.add(makeKey(value), makeValue(value));
      }
      return result;
    }
    ts2.arrayToMultiMap = arrayToMultiMap;
    function group(values, getGroupId, resultSelector) {
      if (resultSelector === void 0) {
        resultSelector = identity;
      }
      return arrayFrom(arrayToMultiMap(values, getGroupId).values(), resultSelector);
    }
    ts2.group = group;
    function clone(object) {
      var result = {};
      for (var id in object) {
        if (hasOwnProperty.call(object, id)) {
          result[id] = object[id];
        }
      }
      return result;
    }
    ts2.clone = clone;
    function extend(first2, second) {
      var result = {};
      for (var id in second) {
        if (hasOwnProperty.call(second, id)) {
          result[id] = second[id];
        }
      }
      for (var id in first2) {
        if (hasOwnProperty.call(first2, id)) {
          result[id] = first2[id];
        }
      }
      return result;
    }
    ts2.extend = extend;
    function copyProperties(first2, second) {
      for (var id in second) {
        if (hasOwnProperty.call(second, id)) {
          first2[id] = second[id];
        }
      }
    }
    ts2.copyProperties = copyProperties;
    function maybeBind(obj, fn) {
      return fn ? fn.bind(obj) : void 0;
    }
    ts2.maybeBind = maybeBind;
    function createMultiMap() {
      var map2 = new ts2.Map();
      map2.add = multiMapAdd;
      map2.remove = multiMapRemove;
      return map2;
    }
    ts2.createMultiMap = createMultiMap;
    function multiMapAdd(key, value) {
      var values = this.get(key);
      if (values) {
        values.push(value);
      } else {
        this.set(key, values = [value]);
      }
      return values;
    }
    function multiMapRemove(key, value) {
      var values = this.get(key);
      if (values) {
        unorderedRemoveItem(values, value);
        if (!values.length) {
          this.delete(key);
        }
      }
    }
    function createUnderscoreEscapedMultiMap() {
      return createMultiMap();
    }
    ts2.createUnderscoreEscapedMultiMap = createUnderscoreEscapedMultiMap;
    function isArray2(value) {
      return Array.isArray ? Array.isArray(value) : value instanceof Array;
    }
    ts2.isArray = isArray2;
    function toArray(value) {
      return isArray2(value) ? value : [value];
    }
    ts2.toArray = toArray;
    function isString(text) {
      return typeof text === "string";
    }
    ts2.isString = isString;
    function isNumber(x) {
      return typeof x === "number";
    }
    ts2.isNumber = isNumber;
    function tryCast(value, test) {
      return value !== void 0 && test(value) ? value : void 0;
    }
    ts2.tryCast = tryCast;
    function cast(value, test) {
      if (value !== void 0 && test(value))
        return value;
      return ts2.Debug.fail("Invalid cast. The supplied value ".concat(value, " did not pass the test '").concat(ts2.Debug.getFunctionName(test), "'."));
    }
    ts2.cast = cast;
    function noop(_) {
    }
    ts2.noop = noop;
    function returnFalse() {
      return false;
    }
    ts2.returnFalse = returnFalse;
    function returnTrue() {
      return true;
    }
    ts2.returnTrue = returnTrue;
    function returnUndefined() {
      return void 0;
    }
    ts2.returnUndefined = returnUndefined;
    function identity(x) {
      return x;
    }
    ts2.identity = identity;
    function toLowerCase(x) {
      return x.toLowerCase();
    }
    ts2.toLowerCase = toLowerCase;
    var fileNameLowerCaseRegExp = /[^\u0130\u0131\u00DFa-z0-9\\/:\-_\. ]+/g;
    function toFileNameLowerCase(x) {
      return fileNameLowerCaseRegExp.test(x) ? x.replace(fileNameLowerCaseRegExp, toLowerCase) : x;
    }
    ts2.toFileNameLowerCase = toFileNameLowerCase;
    function notImplemented() {
      throw new Error("Not implemented");
    }
    ts2.notImplemented = notImplemented;
    function memoize(callback) {
      var value;
      return function() {
        if (callback) {
          value = callback();
          callback = void 0;
        }
        return value;
      };
    }
    ts2.memoize = memoize;
    function memoizeOne(callback) {
      var map2 = new ts2.Map();
      return function(arg) {
        var key = "".concat(typeof arg, ":").concat(arg);
        var value = map2.get(key);
        if (value === void 0 && !map2.has(key)) {
          value = callback(arg);
          map2.set(key, value);
        }
        return value;
      };
    }
    ts2.memoizeOne = memoizeOne;
    function compose(a, b, c, d, e) {
      if (!!e) {
        var args_2 = [];
        for (var i = 0; i < arguments.length; i++) {
          args_2[i] = arguments[i];
        }
        return function(t) {
          return reduceLeft(args_2, function(u, f) {
            return f(u);
          }, t);
        };
      } else if (d) {
        return function(t) {
          return d(c(b(a(t))));
        };
      } else if (c) {
        return function(t) {
          return c(b(a(t)));
        };
      } else if (b) {
        return function(t) {
          return b(a(t));
        };
      } else if (a) {
        return function(t) {
          return a(t);
        };
      } else {
        return function(t) {
          return t;
        };
      }
    }
    ts2.compose = compose;
    var AssertionLevel;
    (function(AssertionLevel2) {
      AssertionLevel2[AssertionLevel2["None"] = 0] = "None";
      AssertionLevel2[AssertionLevel2["Normal"] = 1] = "Normal";
      AssertionLevel2[AssertionLevel2["Aggressive"] = 2] = "Aggressive";
      AssertionLevel2[AssertionLevel2["VeryAggressive"] = 3] = "VeryAggressive";
    })(AssertionLevel = ts2.AssertionLevel || (ts2.AssertionLevel = {}));
    function equateValues(a, b) {
      return a === b;
    }
    ts2.equateValues = equateValues;
    function equateStringsCaseInsensitive(a, b) {
      return a === b || a !== void 0 && b !== void 0 && a.toUpperCase() === b.toUpperCase();
    }
    ts2.equateStringsCaseInsensitive = equateStringsCaseInsensitive;
    function equateStringsCaseSensitive(a, b) {
      return equateValues(a, b);
    }
    ts2.equateStringsCaseSensitive = equateStringsCaseSensitive;
    function compareComparableValues(a, b) {
      return a === b ? 0 : a === void 0 ? -1 : b === void 0 ? 1 : a < b ? -1 : 1;
    }
    function compareValues(a, b) {
      return compareComparableValues(a, b);
    }
    ts2.compareValues = compareValues;
    function compareTextSpans(a, b) {
      return compareValues(a === null || a === void 0 ? void 0 : a.start, b === null || b === void 0 ? void 0 : b.start) || compareValues(a === null || a === void 0 ? void 0 : a.length, b === null || b === void 0 ? void 0 : b.length);
    }
    ts2.compareTextSpans = compareTextSpans;
    function min(a, b, compare) {
      return compare(a, b) === -1 ? a : b;
    }
    ts2.min = min;
    function compareStringsCaseInsensitive(a, b) {
      if (a === b)
        return 0;
      if (a === void 0)
        return -1;
      if (b === void 0)
        return 1;
      a = a.toUpperCase();
      b = b.toUpperCase();
      return a < b ? -1 : a > b ? 1 : 0;
    }
    ts2.compareStringsCaseInsensitive = compareStringsCaseInsensitive;
    function compareStringsCaseSensitive(a, b) {
      return compareComparableValues(a, b);
    }
    ts2.compareStringsCaseSensitive = compareStringsCaseSensitive;
    function getStringComparer(ignoreCase) {
      return ignoreCase ? compareStringsCaseInsensitive : compareStringsCaseSensitive;
    }
    ts2.getStringComparer = getStringComparer;
    var createUIStringComparer = function() {
      var defaultComparer;
      var enUSComparer;
      var stringComparerFactory = getStringComparerFactory();
      return createStringComparer;
      function compareWithCallback(a, b, comparer) {
        if (a === b)
          return 0;
        if (a === void 0)
          return -1;
        if (b === void 0)
          return 1;
        var value = comparer(a, b);
        return value < 0 ? -1 : value > 0 ? 1 : 0;
      }
      function createIntlCollatorStringComparer(locale) {
        var comparer = new Intl.Collator(locale, {usage: "sort", sensitivity: "variant"}).compare;
        return function(a, b) {
          return compareWithCallback(a, b, comparer);
        };
      }
      function createLocaleCompareStringComparer(locale) {
        if (locale !== void 0)
          return createFallbackStringComparer();
        return function(a, b) {
          return compareWithCallback(a, b, compareStrings);
        };
        function compareStrings(a, b) {
          return a.localeCompare(b);
        }
      }
      function createFallbackStringComparer() {
        return function(a, b) {
          return compareWithCallback(a, b, compareDictionaryOrder);
        };
        function compareDictionaryOrder(a, b) {
          return compareStrings(a.toUpperCase(), b.toUpperCase()) || compareStrings(a, b);
        }
        function compareStrings(a, b) {
          return a < b ? -1 : a > b ? 1 : 0;
        }
      }
      function getStringComparerFactory() {
        if (typeof Intl === "object" && typeof Intl.Collator === "function") {
          return createIntlCollatorStringComparer;
        }
        if (typeof String.prototype.localeCompare === "function" && typeof String.prototype.toLocaleUpperCase === "function" && "a".localeCompare("B") < 0) {
          return createLocaleCompareStringComparer;
        }
        return createFallbackStringComparer;
      }
      function createStringComparer(locale) {
        if (locale === void 0) {
          return defaultComparer || (defaultComparer = stringComparerFactory(locale));
        } else if (locale === "en-US") {
          return enUSComparer || (enUSComparer = stringComparerFactory(locale));
        } else {
          return stringComparerFactory(locale);
        }
      }
    }();
    var uiComparerCaseSensitive;
    var uiLocale;
    function getUILocale() {
      return uiLocale;
    }
    ts2.getUILocale = getUILocale;
    function setUILocale(value) {
      if (uiLocale !== value) {
        uiLocale = value;
        uiComparerCaseSensitive = void 0;
      }
    }
    ts2.setUILocale = setUILocale;
    function compareStringsCaseSensitiveUI(a, b) {
      var comparer = uiComparerCaseSensitive || (uiComparerCaseSensitive = createUIStringComparer(uiLocale));
      return comparer(a, b);
    }
    ts2.compareStringsCaseSensitiveUI = compareStringsCaseSensitiveUI;
    function compareProperties(a, b, key, comparer) {
      return a === b ? 0 : a === void 0 ? -1 : b === void 0 ? 1 : comparer(a[key], b[key]);
    }
    ts2.compareProperties = compareProperties;
    function compareBooleans(a, b) {
      return compareValues(a ? 1 : 0, b ? 1 : 0);
    }
    ts2.compareBooleans = compareBooleans;
    function getSpellingSuggestion(name, candidates, getName) {
      var maximumLengthDifference = Math.min(2, Math.floor(name.length * 0.34));
      var bestDistance = Math.floor(name.length * 0.4) + 1;
      var bestCandidate;
      for (var _i = 0, candidates_1 = candidates; _i < candidates_1.length; _i++) {
        var candidate = candidates_1[_i];
        var candidateName = getName(candidate);
        if (candidateName !== void 0 && Math.abs(candidateName.length - name.length) <= maximumLengthDifference) {
          if (candidateName === name) {
            continue;
          }
          if (candidateName.length < 3 && candidateName.toLowerCase() !== name.toLowerCase()) {
            continue;
          }
          var distance = levenshteinWithMax(name, candidateName, bestDistance - 0.1);
          if (distance === void 0) {
            continue;
          }
          ts2.Debug.assert(distance < bestDistance);
          bestDistance = distance;
          bestCandidate = candidate;
        }
      }
      return bestCandidate;
    }
    ts2.getSpellingSuggestion = getSpellingSuggestion;
    function levenshteinWithMax(s1, s2, max) {
      var previous = new Array(s2.length + 1);
      var current = new Array(s2.length + 1);
      var big = max + 0.01;
      for (var i = 0; i <= s2.length; i++) {
        previous[i] = i;
      }
      for (var i = 1; i <= s1.length; i++) {
        var c1 = s1.charCodeAt(i - 1);
        var minJ = Math.ceil(i > max ? i - max : 1);
        var maxJ = Math.floor(s2.length > max + i ? max + i : s2.length);
        current[0] = i;
        var colMin = i;
        for (var j = 1; j < minJ; j++) {
          current[j] = big;
        }
        for (var j = minJ; j <= maxJ; j++) {
          var substitutionDistance = s1[i - 1].toLowerCase() === s2[j - 1].toLowerCase() ? previous[j - 1] + 0.1 : previous[j - 1] + 2;
          var dist = c1 === s2.charCodeAt(j - 1) ? previous[j - 1] : Math.min(previous[j] + 1, current[j - 1] + 1, substitutionDistance);
          current[j] = dist;
          colMin = Math.min(colMin, dist);
        }
        for (var j = maxJ + 1; j <= s2.length; j++) {
          current[j] = big;
        }
        if (colMin > max) {
          return void 0;
        }
        var temp = previous;
        previous = current;
        current = temp;
      }
      var res = previous[s2.length];
      return res > max ? void 0 : res;
    }
    function endsWith(str, suffix) {
      var expectedPos = str.length - suffix.length;
      return expectedPos >= 0 && str.indexOf(suffix, expectedPos) === expectedPos;
    }
    ts2.endsWith = endsWith;
    function removeSuffix(str, suffix) {
      return endsWith(str, suffix) ? str.slice(0, str.length - suffix.length) : str;
    }
    ts2.removeSuffix = removeSuffix;
    function tryRemoveSuffix(str, suffix) {
      return endsWith(str, suffix) ? str.slice(0, str.length - suffix.length) : void 0;
    }
    ts2.tryRemoveSuffix = tryRemoveSuffix;
    function stringContains(str, substring) {
      return str.indexOf(substring) !== -1;
    }
    ts2.stringContains = stringContains;
    function removeMinAndVersionNumbers(fileName) {
      var end = fileName.length;
      for (var pos = end - 1; pos > 0; pos--) {
        var ch = fileName.charCodeAt(pos);
        if (ch >= 48 && ch <= 57) {
          do {
            --pos;
            ch = fileName.charCodeAt(pos);
          } while (pos > 0 && ch >= 48 && ch <= 57);
        } else if (pos > 4 && (ch === 110 || ch === 78)) {
          --pos;
          ch = fileName.charCodeAt(pos);
          if (ch !== 105 && ch !== 73) {
            break;
          }
          --pos;
          ch = fileName.charCodeAt(pos);
          if (ch !== 109 && ch !== 77) {
            break;
          }
          --pos;
          ch = fileName.charCodeAt(pos);
        } else {
          break;
        }
        if (ch !== 45 && ch !== 46) {
          break;
        }
        end = pos;
      }
      return end === fileName.length ? fileName : fileName.slice(0, end);
    }
    ts2.removeMinAndVersionNumbers = removeMinAndVersionNumbers;
    function orderedRemoveItem(array, item) {
      for (var i = 0; i < array.length; i++) {
        if (array[i] === item) {
          orderedRemoveItemAt(array, i);
          return true;
        }
      }
      return false;
    }
    ts2.orderedRemoveItem = orderedRemoveItem;
    function orderedRemoveItemAt(array, index) {
      for (var i = index; i < array.length - 1; i++) {
        array[i] = array[i + 1];
      }
      array.pop();
    }
    ts2.orderedRemoveItemAt = orderedRemoveItemAt;
    function unorderedRemoveItemAt(array, index) {
      array[index] = array[array.length - 1];
      array.pop();
    }
    ts2.unorderedRemoveItemAt = unorderedRemoveItemAt;
    function unorderedRemoveItem(array, item) {
      return unorderedRemoveFirstItemWhere(array, function(element) {
        return element === item;
      });
    }
    ts2.unorderedRemoveItem = unorderedRemoveItem;
    function unorderedRemoveFirstItemWhere(array, predicate) {
      for (var i = 0; i < array.length; i++) {
        if (predicate(array[i])) {
          unorderedRemoveItemAt(array, i);
          return true;
        }
      }
      return false;
    }
    function createGetCanonicalFileName(useCaseSensitiveFileNames) {
      return useCaseSensitiveFileNames ? identity : toFileNameLowerCase;
    }
    ts2.createGetCanonicalFileName = createGetCanonicalFileName;
    function patternText(_a3) {
      var prefix = _a3.prefix, suffix = _a3.suffix;
      return "".concat(prefix, "*").concat(suffix);
    }
    ts2.patternText = patternText;
    function matchedText(pattern, candidate) {
      ts2.Debug.assert(isPatternMatch(pattern, candidate));
      return candidate.substring(pattern.prefix.length, candidate.length - pattern.suffix.length);
    }
    ts2.matchedText = matchedText;
    function findBestPatternMatch(values, getPattern, candidate) {
      var matchedValue;
      var longestMatchPrefixLength = -1;
      for (var _i = 0, values_2 = values; _i < values_2.length; _i++) {
        var v = values_2[_i];
        var pattern = getPattern(v);
        if (isPatternMatch(pattern, candidate) && pattern.prefix.length > longestMatchPrefixLength) {
          longestMatchPrefixLength = pattern.prefix.length;
          matchedValue = v;
        }
      }
      return matchedValue;
    }
    ts2.findBestPatternMatch = findBestPatternMatch;
    function startsWith(str, prefix) {
      return str.lastIndexOf(prefix, 0) === 0;
    }
    ts2.startsWith = startsWith;
    function removePrefix(str, prefix) {
      return startsWith(str, prefix) ? str.substr(prefix.length) : str;
    }
    ts2.removePrefix = removePrefix;
    function tryRemovePrefix(str, prefix, getCanonicalFileName) {
      if (getCanonicalFileName === void 0) {
        getCanonicalFileName = identity;
      }
      return startsWith(getCanonicalFileName(str), getCanonicalFileName(prefix)) ? str.substring(prefix.length) : void 0;
    }
    ts2.tryRemovePrefix = tryRemovePrefix;
    function isPatternMatch(_a3, candidate) {
      var prefix = _a3.prefix, suffix = _a3.suffix;
      return candidate.length >= prefix.length + suffix.length && startsWith(candidate, prefix) && endsWith(candidate, suffix);
    }
    function and(f, g) {
      return function(arg) {
        return f(arg) && g(arg);
      };
    }
    ts2.and = and;
    function or() {
      var fs = [];
      for (var _i = 0; _i < arguments.length; _i++) {
        fs[_i] = arguments[_i];
      }
      return function() {
        var args = [];
        for (var _i2 = 0; _i2 < arguments.length; _i2++) {
          args[_i2] = arguments[_i2];
        }
        for (var _a3 = 0, fs_1 = fs; _a3 < fs_1.length; _a3++) {
          var f = fs_1[_a3];
          if (f.apply(void 0, args)) {
            return true;
          }
        }
        return false;
      };
    }
    ts2.or = or;
    function not(fn) {
      return function() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
        }
        return !fn.apply(void 0, args);
      };
    }
    ts2.not = not;
    function assertType(_) {
    }
    ts2.assertType = assertType;
    function singleElementArray(t) {
      return t === void 0 ? void 0 : [t];
    }
    ts2.singleElementArray = singleElementArray;
    function enumerateInsertsAndDeletes(newItems, oldItems, comparer, inserted, deleted, unchanged) {
      unchanged = unchanged || noop;
      var newIndex = 0;
      var oldIndex = 0;
      var newLen = newItems.length;
      var oldLen = oldItems.length;
      var hasChanges = false;
      while (newIndex < newLen && oldIndex < oldLen) {
        var newItem = newItems[newIndex];
        var oldItem = oldItems[oldIndex];
        var compareResult = comparer(newItem, oldItem);
        if (compareResult === -1) {
          inserted(newItem);
          newIndex++;
          hasChanges = true;
        } else if (compareResult === 1) {
          deleted(oldItem);
          oldIndex++;
          hasChanges = true;
        } else {
          unchanged(oldItem, newItem);
          newIndex++;
          oldIndex++;
        }
      }
      while (newIndex < newLen) {
        inserted(newItems[newIndex++]);
        hasChanges = true;
      }
      while (oldIndex < oldLen) {
        deleted(oldItems[oldIndex++]);
        hasChanges = true;
      }
      return hasChanges;
    }
    ts2.enumerateInsertsAndDeletes = enumerateInsertsAndDeletes;
    function fill2(length2, cb) {
      var result = Array(length2);
      for (var i = 0; i < length2; i++) {
        result[i] = cb(i);
      }
      return result;
    }
    ts2.fill = fill2;
    function cartesianProduct(arrays) {
      var result = [];
      cartesianProductWorker(arrays, result, void 0, 0);
      return result;
    }
    ts2.cartesianProduct = cartesianProduct;
    function cartesianProductWorker(arrays, result, outer, index) {
      for (var _i = 0, _a3 = arrays[index]; _i < _a3.length; _i++) {
        var element = _a3[_i];
        var inner = void 0;
        if (outer) {
          inner = outer.slice();
          inner.push(element);
        } else {
          inner = [element];
        }
        if (index === arrays.length - 1) {
          result.push(inner);
        } else {
          cartesianProductWorker(arrays, result, inner, index + 1);
        }
      }
    }
    function padLeft(s, length2, padString) {
      if (padString === void 0) {
        padString = " ";
      }
      return length2 <= s.length ? s : padString.repeat(length2 - s.length) + s;
    }
    ts2.padLeft = padLeft;
    function padRight(s, length2, padString) {
      if (padString === void 0) {
        padString = " ";
      }
      return length2 <= s.length ? s : s + padString.repeat(length2 - s.length);
    }
    ts2.padRight = padRight;
    function takeWhile(array, predicate) {
      var len = array.length;
      var index = 0;
      while (index < len && predicate(array[index])) {
        index++;
      }
      return array.slice(0, index);
    }
    ts2.takeWhile = takeWhile;
    ts2.trimString = !!String.prototype.trim ? function(s) {
      return s.trim();
    } : function(s) {
      return ts2.trimStringEnd(ts2.trimStringStart(s));
    };
    ts2.trimStringEnd = !!String.prototype.trimEnd ? function(s) {
      return s.trimEnd();
    } : trimEndImpl;
    ts2.trimStringStart = !!String.prototype.trimStart ? function(s) {
      return s.trimStart();
    } : function(s) {
      return s.replace(/^\s+/g, "");
    };
    function trimEndImpl(s) {
      var end = s.length - 1;
      while (end >= 0) {
        if (!ts2.isWhiteSpaceLike(s.charCodeAt(end)))
          break;
        end--;
      }
      return s.slice(0, end + 1);
    }
  })(ts || (ts = {}));
  (function(ts2) {
    var LogLevel;
    (function(LogLevel2) {
      LogLevel2[LogLevel2["Off"] = 0] = "Off";
      LogLevel2[LogLevel2["Error"] = 1] = "Error";
      LogLevel2[LogLevel2["Warning"] = 2] = "Warning";
      LogLevel2[LogLevel2["Info"] = 3] = "Info";
      LogLevel2[LogLevel2["Verbose"] = 4] = "Verbose";
    })(LogLevel = ts2.LogLevel || (ts2.LogLevel = {}));
    var Debug2;
    (function(Debug22) {
      var typeScriptVersion;
      var currentAssertionLevel = 0;
      Debug22.currentLogLevel = LogLevel.Warning;
      Debug22.isDebugging = false;
      function getTypeScriptVersion() {
        return typeScriptVersion !== null && typeScriptVersion !== void 0 ? typeScriptVersion : typeScriptVersion = new ts2.Version(ts2.version);
      }
      Debug22.getTypeScriptVersion = getTypeScriptVersion;
      function shouldLog(level) {
        return Debug22.currentLogLevel <= level;
      }
      Debug22.shouldLog = shouldLog;
      function logMessage(level, s) {
        if (Debug22.loggingHost && shouldLog(level)) {
          Debug22.loggingHost.log(level, s);
        }
      }
      function log(s) {
        logMessage(LogLevel.Info, s);
      }
      Debug22.log = log;
      (function(log_1) {
        function error(s) {
          logMessage(LogLevel.Error, s);
        }
        log_1.error = error;
        function warn(s) {
          logMessage(LogLevel.Warning, s);
        }
        log_1.warn = warn;
        function log2(s) {
          logMessage(LogLevel.Info, s);
        }
        log_1.log = log2;
        function trace(s) {
          logMessage(LogLevel.Verbose, s);
        }
        log_1.trace = trace;
      })(log = Debug22.log || (Debug22.log = {}));
      var assertionCache = {};
      function getAssertionLevel() {
        return currentAssertionLevel;
      }
      Debug22.getAssertionLevel = getAssertionLevel;
      function setAssertionLevel(level) {
        var prevAssertionLevel = currentAssertionLevel;
        currentAssertionLevel = level;
        if (level > prevAssertionLevel) {
          for (var _i = 0, _a3 = ts2.getOwnKeys(assertionCache); _i < _a3.length; _i++) {
            var key = _a3[_i];
            var cachedFunc = assertionCache[key];
            if (cachedFunc !== void 0 && Debug22[key] !== cachedFunc.assertion && level >= cachedFunc.level) {
              Debug22[key] = cachedFunc;
              assertionCache[key] = void 0;
            }
          }
        }
      }
      Debug22.setAssertionLevel = setAssertionLevel;
      function shouldAssert(level) {
        return currentAssertionLevel >= level;
      }
      Debug22.shouldAssert = shouldAssert;
      function shouldAssertFunction(level, name) {
        if (!shouldAssert(level)) {
          assertionCache[name] = {level, assertion: Debug22[name]};
          Debug22[name] = ts2.noop;
          return false;
        }
        return true;
      }
      function fail(message, stackCrawlMark) {
        var e = new Error(message ? "Debug Failure. ".concat(message) : "Debug Failure.");
        if (Error.captureStackTrace) {
          Error.captureStackTrace(e, stackCrawlMark || fail);
        }
        throw e;
      }
      Debug22.fail = fail;
      function failBadSyntaxKind(node, message, stackCrawlMark) {
        return fail("".concat(message || "Unexpected node.", "\r\nNode ").concat(formatSyntaxKind(node.kind), " was unexpected."), stackCrawlMark || failBadSyntaxKind);
      }
      Debug22.failBadSyntaxKind = failBadSyntaxKind;
      function assert(expression, message, verboseDebugInfo, stackCrawlMark) {
        if (!expression) {
          message = message ? "False expression: ".concat(message) : "False expression.";
          if (verboseDebugInfo) {
            message += "\r\nVerbose Debug Information: " + (typeof verboseDebugInfo === "string" ? verboseDebugInfo : verboseDebugInfo());
          }
          fail(message, stackCrawlMark || assert);
        }
      }
      Debug22.assert = assert;
      function assertEqual(a, b, msg, msg2, stackCrawlMark) {
        if (a !== b) {
          var message = msg ? msg2 ? "".concat(msg, " ").concat(msg2) : msg : "";
          fail("Expected ".concat(a, " === ").concat(b, ". ").concat(message), stackCrawlMark || assertEqual);
        }
      }
      Debug22.assertEqual = assertEqual;
      function assertLessThan(a, b, msg, stackCrawlMark) {
        if (a >= b) {
          fail("Expected ".concat(a, " < ").concat(b, ". ").concat(msg || ""), stackCrawlMark || assertLessThan);
        }
      }
      Debug22.assertLessThan = assertLessThan;
      function assertLessThanOrEqual(a, b, stackCrawlMark) {
        if (a > b) {
          fail("Expected ".concat(a, " <= ").concat(b), stackCrawlMark || assertLessThanOrEqual);
        }
      }
      Debug22.assertLessThanOrEqual = assertLessThanOrEqual;
      function assertGreaterThanOrEqual(a, b, stackCrawlMark) {
        if (a < b) {
          fail("Expected ".concat(a, " >= ").concat(b), stackCrawlMark || assertGreaterThanOrEqual);
        }
      }
      Debug22.assertGreaterThanOrEqual = assertGreaterThanOrEqual;
      function assertIsDefined(value, message, stackCrawlMark) {
        if (value === void 0 || value === null) {
          fail(message, stackCrawlMark || assertIsDefined);
        }
      }
      Debug22.assertIsDefined = assertIsDefined;
      function checkDefined(value, message, stackCrawlMark) {
        assertIsDefined(value, message, stackCrawlMark || checkDefined);
        return value;
      }
      Debug22.checkDefined = checkDefined;
      Debug22.assertDefined = checkDefined;
      function assertEachIsDefined(value, message, stackCrawlMark) {
        for (var _i = 0, value_1 = value; _i < value_1.length; _i++) {
          var v = value_1[_i];
          assertIsDefined(v, message, stackCrawlMark || assertEachIsDefined);
        }
      }
      Debug22.assertEachIsDefined = assertEachIsDefined;
      function checkEachDefined(value, message, stackCrawlMark) {
        assertEachIsDefined(value, message, stackCrawlMark || checkEachDefined);
        return value;
      }
      Debug22.checkEachDefined = checkEachDefined;
      Debug22.assertEachDefined = checkEachDefined;
      function assertNever2(member, message, stackCrawlMark) {
        if (message === void 0) {
          message = "Illegal value:";
        }
        var detail = typeof member === "object" && ts2.hasProperty(member, "kind") && ts2.hasProperty(member, "pos") && formatSyntaxKind ? "SyntaxKind: " + formatSyntaxKind(member.kind) : JSON.stringify(member);
        return fail("".concat(message, " ").concat(detail), stackCrawlMark || assertNever2);
      }
      Debug22.assertNever = assertNever2;
      function assertEachNode(nodes, test, message, stackCrawlMark) {
        if (shouldAssertFunction(1, "assertEachNode")) {
          assert(test === void 0 || ts2.every(nodes, test), message || "Unexpected node.", function() {
            return "Node array did not pass test '".concat(getFunctionName(test), "'.");
          }, stackCrawlMark || assertEachNode);
        }
      }
      Debug22.assertEachNode = assertEachNode;
      function assertNode(node, test, message, stackCrawlMark) {
        if (shouldAssertFunction(1, "assertNode")) {
          assert(node !== void 0 && (test === void 0 || test(node)), message || "Unexpected node.", function() {
            return "Node ".concat(formatSyntaxKind(node === null || node === void 0 ? void 0 : node.kind), " did not pass test '").concat(getFunctionName(test), "'.");
          }, stackCrawlMark || assertNode);
        }
      }
      Debug22.assertNode = assertNode;
      function assertNotNode(node, test, message, stackCrawlMark) {
        if (shouldAssertFunction(1, "assertNotNode")) {
          assert(node === void 0 || test === void 0 || !test(node), message || "Unexpected node.", function() {
            return "Node ".concat(formatSyntaxKind(node.kind), " should not have passed test '").concat(getFunctionName(test), "'.");
          }, stackCrawlMark || assertNotNode);
        }
      }
      Debug22.assertNotNode = assertNotNode;
      function assertOptionalNode(node, test, message, stackCrawlMark) {
        if (shouldAssertFunction(1, "assertOptionalNode")) {
          assert(test === void 0 || node === void 0 || test(node), message || "Unexpected node.", function() {
            return "Node ".concat(formatSyntaxKind(node === null || node === void 0 ? void 0 : node.kind), " did not pass test '").concat(getFunctionName(test), "'.");
          }, stackCrawlMark || assertOptionalNode);
        }
      }
      Debug22.assertOptionalNode = assertOptionalNode;
      function assertOptionalToken(node, kind, message, stackCrawlMark) {
        if (shouldAssertFunction(1, "assertOptionalToken")) {
          assert(kind === void 0 || node === void 0 || node.kind === kind, message || "Unexpected node.", function() {
            return "Node ".concat(formatSyntaxKind(node === null || node === void 0 ? void 0 : node.kind), " was not a '").concat(formatSyntaxKind(kind), "' token.");
          }, stackCrawlMark || assertOptionalToken);
        }
      }
      Debug22.assertOptionalToken = assertOptionalToken;
      function assertMissingNode(node, message, stackCrawlMark) {
        if (shouldAssertFunction(1, "assertMissingNode")) {
          assert(node === void 0, message || "Unexpected node.", function() {
            return "Node ".concat(formatSyntaxKind(node.kind), " was unexpected'.");
          }, stackCrawlMark || assertMissingNode);
        }
      }
      Debug22.assertMissingNode = assertMissingNode;
      function type(_value) {
      }
      Debug22.type = type;
      function getFunctionName(func) {
        if (typeof func !== "function") {
          return "";
        } else if (func.hasOwnProperty("name")) {
          return func.name;
        } else {
          var text = Function.prototype.toString.call(func);
          var match = /^function\s+([\w\$]+)\s*\(/.exec(text);
          return match ? match[1] : "";
        }
      }
      Debug22.getFunctionName = getFunctionName;
      function formatSymbol(symbol) {
        return "{ name: ".concat(ts2.unescapeLeadingUnderscores(symbol.escapedName), "; flags: ").concat(formatSymbolFlags(symbol.flags), "; declarations: ").concat(ts2.map(symbol.declarations, function(node) {
          return formatSyntaxKind(node.kind);
        }), " }");
      }
      Debug22.formatSymbol = formatSymbol;
      function formatEnum(value, enumObject, isFlags) {
        if (value === void 0) {
          value = 0;
        }
        var members = getEnumMembers(enumObject);
        if (value === 0) {
          return members.length > 0 && members[0][0] === 0 ? members[0][1] : "0";
        }
        if (isFlags) {
          var result = "";
          var remainingFlags = value;
          for (var _i = 0, members_1 = members; _i < members_1.length; _i++) {
            var _a3 = members_1[_i], enumValue = _a3[0], enumName = _a3[1];
            if (enumValue > value) {
              break;
            }
            if (enumValue !== 0 && enumValue & value) {
              result = "".concat(result).concat(result ? "|" : "").concat(enumName);
              remainingFlags &= ~enumValue;
            }
          }
          if (remainingFlags === 0) {
            return result;
          }
        } else {
          for (var _b = 0, members_2 = members; _b < members_2.length; _b++) {
            var _c = members_2[_b], enumValue = _c[0], enumName = _c[1];
            if (enumValue === value) {
              return enumName;
            }
          }
        }
        return value.toString();
      }
      Debug22.formatEnum = formatEnum;
      function getEnumMembers(enumObject) {
        var result = [];
        for (var name in enumObject) {
          var value = enumObject[name];
          if (typeof value === "number") {
            result.push([value, name]);
          }
        }
        return ts2.stableSort(result, function(x, y) {
          return ts2.compareValues(x[0], y[0]);
        });
      }
      function formatSyntaxKind(kind) {
        return formatEnum(kind, ts2.SyntaxKind, false);
      }
      Debug22.formatSyntaxKind = formatSyntaxKind;
      function formatSnippetKind(kind) {
        return formatEnum(kind, ts2.SnippetKind, false);
      }
      Debug22.formatSnippetKind = formatSnippetKind;
      function formatNodeFlags(flags) {
        return formatEnum(flags, ts2.NodeFlags, true);
      }
      Debug22.formatNodeFlags = formatNodeFlags;
      function formatModifierFlags(flags) {
        return formatEnum(flags, ts2.ModifierFlags, true);
      }
      Debug22.formatModifierFlags = formatModifierFlags;
      function formatTransformFlags(flags) {
        return formatEnum(flags, ts2.TransformFlags, true);
      }
      Debug22.formatTransformFlags = formatTransformFlags;
      function formatEmitFlags(flags) {
        return formatEnum(flags, ts2.EmitFlags, true);
      }
      Debug22.formatEmitFlags = formatEmitFlags;
      function formatSymbolFlags(flags) {
        return formatEnum(flags, ts2.SymbolFlags, true);
      }
      Debug22.formatSymbolFlags = formatSymbolFlags;
      function formatTypeFlags(flags) {
        return formatEnum(flags, ts2.TypeFlags, true);
      }
      Debug22.formatTypeFlags = formatTypeFlags;
      function formatSignatureFlags(flags) {
        return formatEnum(flags, ts2.SignatureFlags, true);
      }
      Debug22.formatSignatureFlags = formatSignatureFlags;
      function formatObjectFlags(flags) {
        return formatEnum(flags, ts2.ObjectFlags, true);
      }
      Debug22.formatObjectFlags = formatObjectFlags;
      function formatFlowFlags(flags) {
        return formatEnum(flags, ts2.FlowFlags, true);
      }
      Debug22.formatFlowFlags = formatFlowFlags;
      var isDebugInfoEnabled = false;
      var extendedDebugModule;
      function extendedDebug() {
        enableDebugInfo();
        if (!extendedDebugModule) {
          throw new Error("Debugging helpers could not be loaded.");
        }
        return extendedDebugModule;
      }
      function printControlFlowGraph(flowNode) {
        return console.log(formatControlFlowGraph(flowNode));
      }
      Debug22.printControlFlowGraph = printControlFlowGraph;
      function formatControlFlowGraph(flowNode) {
        return extendedDebug().formatControlFlowGraph(flowNode);
      }
      Debug22.formatControlFlowGraph = formatControlFlowGraph;
      var flowNodeProto;
      function attachFlowNodeDebugInfoWorker(flowNode) {
        if (!("__debugFlowFlags" in flowNode)) {
          Object.defineProperties(flowNode, {
            __tsDebuggerDisplay: {
              value: function() {
                var flowHeader = this.flags & 2 ? "FlowStart" : this.flags & 4 ? "FlowBranchLabel" : this.flags & 8 ? "FlowLoopLabel" : this.flags & 16 ? "FlowAssignment" : this.flags & 32 ? "FlowTrueCondition" : this.flags & 64 ? "FlowFalseCondition" : this.flags & 128 ? "FlowSwitchClause" : this.flags & 256 ? "FlowArrayMutation" : this.flags & 512 ? "FlowCall" : this.flags & 1024 ? "FlowReduceLabel" : this.flags & 1 ? "FlowUnreachable" : "UnknownFlow";
                var remainingFlags = this.flags & ~(2048 - 1);
                return "".concat(flowHeader).concat(remainingFlags ? " (".concat(formatFlowFlags(remainingFlags), ")") : "");
              }
            },
            __debugFlowFlags: {get: function() {
              return formatEnum(this.flags, ts2.FlowFlags, true);
            }},
            __debugToString: {value: function() {
              return formatControlFlowGraph(this);
            }}
          });
        }
      }
      function attachFlowNodeDebugInfo(flowNode) {
        if (isDebugInfoEnabled) {
          if (typeof Object.setPrototypeOf === "function") {
            if (!flowNodeProto) {
              flowNodeProto = Object.create(Object.prototype);
              attachFlowNodeDebugInfoWorker(flowNodeProto);
            }
            Object.setPrototypeOf(flowNode, flowNodeProto);
          } else {
            attachFlowNodeDebugInfoWorker(flowNode);
          }
        }
      }
      Debug22.attachFlowNodeDebugInfo = attachFlowNodeDebugInfo;
      var nodeArrayProto;
      function attachNodeArrayDebugInfoWorker(array) {
        if (!("__tsDebuggerDisplay" in array)) {
          Object.defineProperties(array, {
            __tsDebuggerDisplay: {
              value: function(defaultValue) {
                defaultValue = String(defaultValue).replace(/(?:,[\s\w\d_]+:[^,]+)+\]$/, "]");
                return "NodeArray ".concat(defaultValue);
              }
            }
          });
        }
      }
      function attachNodeArrayDebugInfo(array) {
        if (isDebugInfoEnabled) {
          if (typeof Object.setPrototypeOf === "function") {
            if (!nodeArrayProto) {
              nodeArrayProto = Object.create(Array.prototype);
              attachNodeArrayDebugInfoWorker(nodeArrayProto);
            }
            Object.setPrototypeOf(array, nodeArrayProto);
          } else {
            attachNodeArrayDebugInfoWorker(array);
          }
        }
      }
      Debug22.attachNodeArrayDebugInfo = attachNodeArrayDebugInfo;
      function enableDebugInfo() {
        if (isDebugInfoEnabled)
          return;
        var weakTypeTextMap;
        var weakNodeTextMap;
        function getWeakTypeTextMap() {
          if (weakTypeTextMap === void 0) {
            if (typeof WeakMap === "function")
              weakTypeTextMap = /* @__PURE__ */ new WeakMap();
          }
          return weakTypeTextMap;
        }
        function getWeakNodeTextMap() {
          if (weakNodeTextMap === void 0) {
            if (typeof WeakMap === "function")
              weakNodeTextMap = /* @__PURE__ */ new WeakMap();
          }
          return weakNodeTextMap;
        }
        Object.defineProperties(ts2.objectAllocator.getSymbolConstructor().prototype, {
          __tsDebuggerDisplay: {
            value: function() {
              var symbolHeader = this.flags & 33554432 ? "TransientSymbol" : "Symbol";
              var remainingSymbolFlags = this.flags & ~33554432;
              return "".concat(symbolHeader, " '").concat(ts2.symbolName(this), "'").concat(remainingSymbolFlags ? " (".concat(formatSymbolFlags(remainingSymbolFlags), ")") : "");
            }
          },
          __debugFlags: {get: function() {
            return formatSymbolFlags(this.flags);
          }}
        });
        Object.defineProperties(ts2.objectAllocator.getTypeConstructor().prototype, {
          __tsDebuggerDisplay: {
            value: function() {
              var typeHeader = this.flags & 98304 ? "NullableType" : this.flags & 384 ? "LiteralType ".concat(JSON.stringify(this.value)) : this.flags & 2048 ? "LiteralType ".concat(this.value.negative ? "-" : "").concat(this.value.base10Value, "n") : this.flags & 8192 ? "UniqueESSymbolType" : this.flags & 32 ? "EnumType" : this.flags & 67359327 ? "IntrinsicType ".concat(this.intrinsicName) : this.flags & 1048576 ? "UnionType" : this.flags & 2097152 ? "IntersectionType" : this.flags & 4194304 ? "IndexType" : this.flags & 8388608 ? "IndexedAccessType" : this.flags & 16777216 ? "ConditionalType" : this.flags & 33554432 ? "SubstitutionType" : this.flags & 262144 ? "TypeParameter" : this.flags & 524288 ? this.objectFlags & 3 ? "InterfaceType" : this.objectFlags & 4 ? "TypeReference" : this.objectFlags & 8 ? "TupleType" : this.objectFlags & 16 ? "AnonymousType" : this.objectFlags & 32 ? "MappedType" : this.objectFlags & 1024 ? "ReverseMappedType" : this.objectFlags & 256 ? "EvolvingArrayType" : "ObjectType" : "Type";
              var remainingObjectFlags = this.flags & 524288 ? this.objectFlags & ~1343 : 0;
              return "".concat(typeHeader).concat(this.symbol ? " '".concat(ts2.symbolName(this.symbol), "'") : "").concat(remainingObjectFlags ? " (".concat(formatObjectFlags(remainingObjectFlags), ")") : "");
            }
          },
          __debugFlags: {get: function() {
            return formatTypeFlags(this.flags);
          }},
          __debugObjectFlags: {get: function() {
            return this.flags & 524288 ? formatObjectFlags(this.objectFlags) : "";
          }},
          __debugTypeToString: {
            value: function() {
              var map = getWeakTypeTextMap();
              var text = map === null || map === void 0 ? void 0 : map.get(this);
              if (text === void 0) {
                text = this.checker.typeToString(this);
                map === null || map === void 0 ? void 0 : map.set(this, text);
              }
              return text;
            }
          }
        });
        Object.defineProperties(ts2.objectAllocator.getSignatureConstructor().prototype, {
          __debugFlags: {get: function() {
            return formatSignatureFlags(this.flags);
          }},
          __debugSignatureToString: {value: function() {
            var _a3;
            return (_a3 = this.checker) === null || _a3 === void 0 ? void 0 : _a3.signatureToString(this);
          }}
        });
        var nodeConstructors = [
          ts2.objectAllocator.getNodeConstructor(),
          ts2.objectAllocator.getIdentifierConstructor(),
          ts2.objectAllocator.getTokenConstructor(),
          ts2.objectAllocator.getSourceFileConstructor()
        ];
        for (var _i = 0, nodeConstructors_1 = nodeConstructors; _i < nodeConstructors_1.length; _i++) {
          var ctor = nodeConstructors_1[_i];
          if (!ctor.prototype.hasOwnProperty("__debugKind")) {
            Object.defineProperties(ctor.prototype, {
              __tsDebuggerDisplay: {
                value: function() {
                  var nodeHeader = ts2.isGeneratedIdentifier(this) ? "GeneratedIdentifier" : ts2.isIdentifier(this) ? "Identifier '".concat(ts2.idText(this), "'") : ts2.isPrivateIdentifier(this) ? "PrivateIdentifier '".concat(ts2.idText(this), "'") : ts2.isStringLiteral(this) ? "StringLiteral ".concat(JSON.stringify(this.text.length < 10 ? this.text : this.text.slice(10) + "...")) : ts2.isNumericLiteral(this) ? "NumericLiteral ".concat(this.text) : ts2.isBigIntLiteral(this) ? "BigIntLiteral ".concat(this.text, "n") : ts2.isTypeParameterDeclaration(this) ? "TypeParameterDeclaration" : ts2.isParameter(this) ? "ParameterDeclaration" : ts2.isConstructorDeclaration(this) ? "ConstructorDeclaration" : ts2.isGetAccessorDeclaration(this) ? "GetAccessorDeclaration" : ts2.isSetAccessorDeclaration(this) ? "SetAccessorDeclaration" : ts2.isCallSignatureDeclaration(this) ? "CallSignatureDeclaration" : ts2.isConstructSignatureDeclaration(this) ? "ConstructSignatureDeclaration" : ts2.isIndexSignatureDeclaration(this) ? "IndexSignatureDeclaration" : ts2.isTypePredicateNode(this) ? "TypePredicateNode" : ts2.isTypeReferenceNode(this) ? "TypeReferenceNode" : ts2.isFunctionTypeNode(this) ? "FunctionTypeNode" : ts2.isConstructorTypeNode(this) ? "ConstructorTypeNode" : ts2.isTypeQueryNode(this) ? "TypeQueryNode" : ts2.isTypeLiteralNode(this) ? "TypeLiteralNode" : ts2.isArrayTypeNode(this) ? "ArrayTypeNode" : ts2.isTupleTypeNode(this) ? "TupleTypeNode" : ts2.isOptionalTypeNode(this) ? "OptionalTypeNode" : ts2.isRestTypeNode(this) ? "RestTypeNode" : ts2.isUnionTypeNode(this) ? "UnionTypeNode" : ts2.isIntersectionTypeNode(this) ? "IntersectionTypeNode" : ts2.isConditionalTypeNode(this) ? "ConditionalTypeNode" : ts2.isInferTypeNode(this) ? "InferTypeNode" : ts2.isParenthesizedTypeNode(this) ? "ParenthesizedTypeNode" : ts2.isThisTypeNode(this) ? "ThisTypeNode" : ts2.isTypeOperatorNode(this) ? "TypeOperatorNode" : ts2.isIndexedAccessTypeNode(this) ? "IndexedAccessTypeNode" : ts2.isMappedTypeNode(this) ? "MappedTypeNode" : ts2.isLiteralTypeNode(this) ? "LiteralTypeNode" : ts2.isNamedTupleMember(this) ? "NamedTupleMember" : ts2.isImportTypeNode(this) ? "ImportTypeNode" : formatSyntaxKind(this.kind);
                  return "".concat(nodeHeader).concat(this.flags ? " (".concat(formatNodeFlags(this.flags), ")") : "");
                }
              },
              __debugKind: {get: function() {
                return formatSyntaxKind(this.kind);
              }},
              __debugNodeFlags: {get: function() {
                return formatNodeFlags(this.flags);
              }},
              __debugModifierFlags: {get: function() {
                return formatModifierFlags(ts2.getEffectiveModifierFlagsNoCache(this));
              }},
              __debugTransformFlags: {get: function() {
                return formatTransformFlags(this.transformFlags);
              }},
              __debugIsParseTreeNode: {get: function() {
                return ts2.isParseTreeNode(this);
              }},
              __debugEmitFlags: {get: function() {
                return formatEmitFlags(ts2.getEmitFlags(this));
              }},
              __debugGetText: {
                value: function(includeTrivia) {
                  if (ts2.nodeIsSynthesized(this))
                    return "";
                  var map = getWeakNodeTextMap();
                  var text = map === null || map === void 0 ? void 0 : map.get(this);
                  if (text === void 0) {
                    var parseNode = ts2.getParseTreeNode(this);
                    var sourceFile = parseNode && ts2.getSourceFileOfNode(parseNode);
                    text = sourceFile ? ts2.getSourceTextOfNodeFromSourceFile(sourceFile, parseNode, includeTrivia) : "";
                    map === null || map === void 0 ? void 0 : map.set(this, text);
                  }
                  return text;
                }
              }
            });
          }
        }
        try {
          if (ts2.sys && ts2.sys.require) {
            var basePath = ts2.getDirectoryPath(ts2.resolvePath(ts2.sys.getExecutingFilePath()));
            var result = void 0;
            if (!result.error) {
              result.module.init(ts2);
              extendedDebugModule = result.module;
            }
          }
        } catch (_a3) {
        }
        isDebugInfoEnabled = true;
      }
      Debug22.enableDebugInfo = enableDebugInfo;
      function formatDeprecationMessage(name, error, errorAfter, since, message) {
        var deprecationMessage = error ? "DeprecationError: " : "DeprecationWarning: ";
        deprecationMessage += "'".concat(name, "' ");
        deprecationMessage += since ? "has been deprecated since v".concat(since) : "is deprecated";
        deprecationMessage += error ? " and can no longer be used." : errorAfter ? " and will no longer be usable after v".concat(errorAfter, ".") : ".";
        deprecationMessage += message ? " ".concat(ts2.formatStringFromArgs(message, [name], 0)) : "";
        return deprecationMessage;
      }
      function createErrorDeprecation(name, errorAfter, since, message) {
        var deprecationMessage = formatDeprecationMessage(name, true, errorAfter, since, message);
        return function() {
          throw new TypeError(deprecationMessage);
        };
      }
      function createWarningDeprecation(name, errorAfter, since, message) {
        var hasWrittenDeprecation = false;
        return function() {
          if (!hasWrittenDeprecation) {
            log.warn(formatDeprecationMessage(name, false, errorAfter, since, message));
            hasWrittenDeprecation = true;
          }
        };
      }
      function createDeprecation(name, options) {
        var _a3, _b;
        if (options === void 0) {
          options = {};
        }
        var version = typeof options.typeScriptVersion === "string" ? new ts2.Version(options.typeScriptVersion) : (_a3 = options.typeScriptVersion) !== null && _a3 !== void 0 ? _a3 : getTypeScriptVersion();
        var errorAfter = typeof options.errorAfter === "string" ? new ts2.Version(options.errorAfter) : options.errorAfter;
        var warnAfter = typeof options.warnAfter === "string" ? new ts2.Version(options.warnAfter) : options.warnAfter;
        var since = typeof options.since === "string" ? new ts2.Version(options.since) : (_b = options.since) !== null && _b !== void 0 ? _b : warnAfter;
        var error = options.error || errorAfter && version.compareTo(errorAfter) <= 0;
        var warn = !warnAfter || version.compareTo(warnAfter) >= 0;
        return error ? createErrorDeprecation(name, errorAfter, since, options.message) : warn ? createWarningDeprecation(name, errorAfter, since, options.message) : ts2.noop;
      }
      function wrapFunction(deprecation, func) {
        return function() {
          deprecation();
          return func.apply(this, arguments);
        };
      }
      function deprecate(func, options) {
        var deprecation = createDeprecation(getFunctionName(func), options);
        return wrapFunction(deprecation, func);
      }
      Debug22.deprecate = deprecate;
    })(Debug2 = ts2.Debug || (ts2.Debug = {}));
  })(ts || (ts = {}));
  (function(ts2) {
    var versionRegExp = /^(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:\-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i;
    var prereleaseRegExp = /^(?:0|[1-9]\d*|[a-z-][a-z0-9-]*)(?:\.(?:0|[1-9]\d*|[a-z-][a-z0-9-]*))*$/i;
    var buildRegExp = /^[a-z0-9-]+(?:\.[a-z0-9-]+)*$/i;
    var numericIdentifierRegExp = /^(0|[1-9]\d*)$/;
    var Version = function() {
      function Version2(major, minor, patch, prerelease, build) {
        if (minor === void 0) {
          minor = 0;
        }
        if (patch === void 0) {
          patch = 0;
        }
        if (prerelease === void 0) {
          prerelease = "";
        }
        if (build === void 0) {
          build = "";
        }
        if (typeof major === "string") {
          var result = ts2.Debug.checkDefined(tryParseComponents(major), "Invalid version");
          major = result.major, minor = result.minor, patch = result.patch, prerelease = result.prerelease, build = result.build;
        }
        ts2.Debug.assert(major >= 0, "Invalid argument: major");
        ts2.Debug.assert(minor >= 0, "Invalid argument: minor");
        ts2.Debug.assert(patch >= 0, "Invalid argument: patch");
        ts2.Debug.assert(!prerelease || prereleaseRegExp.test(prerelease), "Invalid argument: prerelease");
        ts2.Debug.assert(!build || buildRegExp.test(build), "Invalid argument: build");
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = prerelease ? prerelease.split(".") : ts2.emptyArray;
        this.build = build ? build.split(".") : ts2.emptyArray;
      }
      Version2.tryParse = function(text) {
        var result = tryParseComponents(text);
        if (!result)
          return void 0;
        var major = result.major, minor = result.minor, patch = result.patch, prerelease = result.prerelease, build = result.build;
        return new Version2(major, minor, patch, prerelease, build);
      };
      Version2.prototype.compareTo = function(other) {
        if (this === other)
          return 0;
        if (other === void 0)
          return 1;
        return ts2.compareValues(this.major, other.major) || ts2.compareValues(this.minor, other.minor) || ts2.compareValues(this.patch, other.patch) || comparePrereleaseIdentifiers(this.prerelease, other.prerelease);
      };
      Version2.prototype.increment = function(field) {
        switch (field) {
          case "major":
            return new Version2(this.major + 1, 0, 0);
          case "minor":
            return new Version2(this.major, this.minor + 1, 0);
          case "patch":
            return new Version2(this.major, this.minor, this.patch + 1);
          default:
            return ts2.Debug.assertNever(field);
        }
      };
      Version2.prototype.toString = function() {
        var result = "".concat(this.major, ".").concat(this.minor, ".").concat(this.patch);
        if (ts2.some(this.prerelease))
          result += "-".concat(this.prerelease.join("."));
        if (ts2.some(this.build))
          result += "+".concat(this.build.join("."));
        return result;
      };
      Version2.zero = new Version2(0, 0, 0);
      return Version2;
    }();
    ts2.Version = Version;
    function tryParseComponents(text) {
      var match = versionRegExp.exec(text);
      if (!match)
        return void 0;
      var major = match[1], _a3 = match[2], minor = _a3 === void 0 ? "0" : _a3, _b = match[3], patch = _b === void 0 ? "0" : _b, _c = match[4], prerelease = _c === void 0 ? "" : _c, _d = match[5], build = _d === void 0 ? "" : _d;
      if (prerelease && !prereleaseRegExp.test(prerelease))
        return void 0;
      if (build && !buildRegExp.test(build))
        return void 0;
      return {
        major: parseInt(major, 10),
        minor: parseInt(minor, 10),
        patch: parseInt(patch, 10),
        prerelease,
        build
      };
    }
    function comparePrereleaseIdentifiers(left, right) {
      if (left === right)
        return 0;
      if (left.length === 0)
        return right.length === 0 ? 0 : 1;
      if (right.length === 0)
        return -1;
      var length = Math.min(left.length, right.length);
      for (var i = 0; i < length; i++) {
        var leftIdentifier = left[i];
        var rightIdentifier = right[i];
        if (leftIdentifier === rightIdentifier)
          continue;
        var leftIsNumeric = numericIdentifierRegExp.test(leftIdentifier);
        var rightIsNumeric = numericIdentifierRegExp.test(rightIdentifier);
        if (leftIsNumeric || rightIsNumeric) {
          if (leftIsNumeric !== rightIsNumeric)
            return leftIsNumeric ? -1 : 1;
          var result = ts2.compareValues(+leftIdentifier, +rightIdentifier);
          if (result)
            return result;
        } else {
          var result = ts2.compareStringsCaseSensitive(leftIdentifier, rightIdentifier);
          if (result)
            return result;
        }
      }
      return ts2.compareValues(left.length, right.length);
    }
    var VersionRange = function() {
      function VersionRange2(spec) {
        this._alternatives = spec ? ts2.Debug.checkDefined(parseRange(spec), "Invalid range spec.") : ts2.emptyArray;
      }
      VersionRange2.tryParse = function(text) {
        var sets = parseRange(text);
        if (sets) {
          var range = new VersionRange2("");
          range._alternatives = sets;
          return range;
        }
        return void 0;
      };
      VersionRange2.prototype.test = function(version) {
        if (typeof version === "string")
          version = new Version(version);
        return testDisjunction(version, this._alternatives);
      };
      VersionRange2.prototype.toString = function() {
        return formatDisjunction(this._alternatives);
      };
      return VersionRange2;
    }();
    ts2.VersionRange = VersionRange;
    var logicalOrRegExp = /\|\|/g;
    var whitespaceRegExp = /\s+/g;
    var partialRegExp = /^([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i;
    var hyphenRegExp = /^\s*([a-z0-9-+.*]+)\s+-\s+([a-z0-9-+.*]+)\s*$/i;
    var rangeRegExp = /^(~|\^|<|<=|>|>=|=)?\s*([a-z0-9-+.*]+)$/i;
    function parseRange(text) {
      var alternatives = [];
      for (var _i = 0, _a3 = ts2.trimString(text).split(logicalOrRegExp); _i < _a3.length; _i++) {
        var range = _a3[_i];
        if (!range)
          continue;
        var comparators = [];
        range = ts2.trimString(range);
        var match = hyphenRegExp.exec(range);
        if (match) {
          if (!parseHyphen(match[1], match[2], comparators))
            return void 0;
        } else {
          for (var _b = 0, _c = range.split(whitespaceRegExp); _b < _c.length; _b++) {
            var simple = _c[_b];
            var match_1 = rangeRegExp.exec(ts2.trimString(simple));
            if (!match_1 || !parseComparator(match_1[1], match_1[2], comparators))
              return void 0;
          }
        }
        alternatives.push(comparators);
      }
      return alternatives;
    }
    function parsePartial(text) {
      var match = partialRegExp.exec(text);
      if (!match)
        return void 0;
      var major = match[1], _a3 = match[2], minor = _a3 === void 0 ? "*" : _a3, _b = match[3], patch = _b === void 0 ? "*" : _b, prerelease = match[4], build = match[5];
      var version = new Version(isWildcard(major) ? 0 : parseInt(major, 10), isWildcard(major) || isWildcard(minor) ? 0 : parseInt(minor, 10), isWildcard(major) || isWildcard(minor) || isWildcard(patch) ? 0 : parseInt(patch, 10), prerelease, build);
      return {version, major, minor, patch};
    }
    function parseHyphen(left, right, comparators) {
      var leftResult = parsePartial(left);
      if (!leftResult)
        return false;
      var rightResult = parsePartial(right);
      if (!rightResult)
        return false;
      if (!isWildcard(leftResult.major)) {
        comparators.push(createComparator(">=", leftResult.version));
      }
      if (!isWildcard(rightResult.major)) {
        comparators.push(isWildcard(rightResult.minor) ? createComparator("<", rightResult.version.increment("major")) : isWildcard(rightResult.patch) ? createComparator("<", rightResult.version.increment("minor")) : createComparator("<=", rightResult.version));
      }
      return true;
    }
    function parseComparator(operator, text, comparators) {
      var result = parsePartial(text);
      if (!result)
        return false;
      var version = result.version, major = result.major, minor = result.minor, patch = result.patch;
      if (!isWildcard(major)) {
        switch (operator) {
          case "~":
            comparators.push(createComparator(">=", version));
            comparators.push(createComparator("<", version.increment(isWildcard(minor) ? "major" : "minor")));
            break;
          case "^":
            comparators.push(createComparator(">=", version));
            comparators.push(createComparator("<", version.increment(version.major > 0 || isWildcard(minor) ? "major" : version.minor > 0 || isWildcard(patch) ? "minor" : "patch")));
            break;
          case "<":
          case ">=":
            comparators.push(createComparator(operator, version));
            break;
          case "<=":
          case ">":
            comparators.push(isWildcard(minor) ? createComparator(operator === "<=" ? "<" : ">=", version.increment("major")) : isWildcard(patch) ? createComparator(operator === "<=" ? "<" : ">=", version.increment("minor")) : createComparator(operator, version));
            break;
          case "=":
          case void 0:
            if (isWildcard(minor) || isWildcard(patch)) {
              comparators.push(createComparator(">=", version));
              comparators.push(createComparator("<", version.increment(isWildcard(minor) ? "major" : "minor")));
            } else {
              comparators.push(createComparator("=", version));
            }
            break;
          default:
            return false;
        }
      } else if (operator === "<" || operator === ">") {
        comparators.push(createComparator("<", Version.zero));
      }
      return true;
    }
    function isWildcard(part) {
      return part === "*" || part === "x" || part === "X";
    }
    function createComparator(operator, operand) {
      return {operator, operand};
    }
    function testDisjunction(version, alternatives) {
      if (alternatives.length === 0)
        return true;
      for (var _i = 0, alternatives_1 = alternatives; _i < alternatives_1.length; _i++) {
        var alternative = alternatives_1[_i];
        if (testAlternative(version, alternative))
          return true;
      }
      return false;
    }
    function testAlternative(version, comparators) {
      for (var _i = 0, comparators_1 = comparators; _i < comparators_1.length; _i++) {
        var comparator = comparators_1[_i];
        if (!testComparator(version, comparator.operator, comparator.operand))
          return false;
      }
      return true;
    }
    function testComparator(version, operator, operand) {
      var cmp = version.compareTo(operand);
      switch (operator) {
        case "<":
          return cmp < 0;
        case "<=":
          return cmp <= 0;
        case ">":
          return cmp > 0;
        case ">=":
          return cmp >= 0;
        case "=":
          return cmp === 0;
        default:
          return ts2.Debug.assertNever(operator);
      }
    }
    function formatDisjunction(alternatives) {
      return ts2.map(alternatives, formatAlternative).join(" || ") || "*";
    }
    function formatAlternative(comparators) {
      return ts2.map(comparators, formatComparator).join(" ");
    }
    function formatComparator(comparator) {
      return "".concat(comparator.operator).concat(comparator.operand);
    }
  })(ts || (ts = {}));
  (function(ts2) {
    function hasRequiredAPI(performance2, PerformanceObserver2) {
      return typeof performance2 === "object" && typeof performance2.timeOrigin === "number" && typeof performance2.mark === "function" && typeof performance2.measure === "function" && typeof performance2.now === "function" && typeof PerformanceObserver2 === "function";
    }
    function tryGetWebPerformanceHooks() {
      if (typeof performance === "object" && typeof PerformanceObserver === "function" && hasRequiredAPI(performance, PerformanceObserver)) {
        return {
          shouldWriteNativeEvents: true,
          performance,
          PerformanceObserver
        };
      }
    }
    function tryGetNodePerformanceHooks() {
      if (typeof process !== "undefined" && process.nextTick && !process.browser && typeof module === "object" && false) {
        try {
          var performance_1;
          var _a3 = {}, nodePerformance_1 = _a3.performance, PerformanceObserver_1 = _a3.PerformanceObserver;
          if (hasRequiredAPI(nodePerformance_1, PerformanceObserver_1)) {
            performance_1 = nodePerformance_1;
            var version_1 = new ts2.Version(process.versions.node);
            var range = new ts2.VersionRange("<12.16.3 || 13 <13.13");
            if (range.test(version_1)) {
              performance_1 = {
                get timeOrigin() {
                  return nodePerformance_1.timeOrigin;
                },
                now: function() {
                  return nodePerformance_1.now();
                },
                mark: function(name) {
                  return nodePerformance_1.mark(name);
                },
                measure: function(name, start, end) {
                  if (start === void 0) {
                    start = "nodeStart";
                  }
                  if (end === void 0) {
                    end = "__performance.measure-fix__";
                    nodePerformance_1.mark(end);
                  }
                  nodePerformance_1.measure(name, start, end);
                  if (end === "__performance.measure-fix__") {
                    nodePerformance_1.clearMarks("__performance.measure-fix__");
                  }
                }
              };
            }
            return {
              shouldWriteNativeEvents: false,
              performance: performance_1,
              PerformanceObserver: PerformanceObserver_1
            };
          }
        } catch (_b) {
        }
      }
    }
    var nativePerformanceHooks = tryGetWebPerformanceHooks() || tryGetNodePerformanceHooks();
    var nativePerformance = nativePerformanceHooks === null || nativePerformanceHooks === void 0 ? void 0 : nativePerformanceHooks.performance;
    function tryGetNativePerformanceHooks() {
      return nativePerformanceHooks;
    }
    ts2.tryGetNativePerformanceHooks = tryGetNativePerformanceHooks;
    ts2.timestamp = nativePerformance ? function() {
      return nativePerformance.now();
    } : Date.now ? Date.now : function() {
      return +new Date();
    };
  })(ts || (ts = {}));
  (function(ts2) {
    var performance2;
    (function(performance3) {
      var perfHooks;
      var performanceImpl;
      function createTimerIf(condition, measureName, startMarkName, endMarkName) {
        return condition ? createTimer(measureName, startMarkName, endMarkName) : performance3.nullTimer;
      }
      performance3.createTimerIf = createTimerIf;
      function createTimer(measureName, startMarkName, endMarkName) {
        var enterCount = 0;
        return {
          enter,
          exit
        };
        function enter() {
          if (++enterCount === 1) {
            mark(startMarkName);
          }
        }
        function exit() {
          if (--enterCount === 0) {
            mark(endMarkName);
            measure(measureName, startMarkName, endMarkName);
          } else if (enterCount < 0) {
            ts2.Debug.fail("enter/exit count does not match.");
          }
        }
      }
      performance3.createTimer = createTimer;
      performance3.nullTimer = {enter: ts2.noop, exit: ts2.noop};
      var enabled = false;
      var timeorigin = ts2.timestamp();
      var marks = new ts2.Map();
      var counts = new ts2.Map();
      var durations = new ts2.Map();
      function mark(markName) {
        var _a3;
        if (enabled) {
          var count = (_a3 = counts.get(markName)) !== null && _a3 !== void 0 ? _a3 : 0;
          counts.set(markName, count + 1);
          marks.set(markName, ts2.timestamp());
          performanceImpl === null || performanceImpl === void 0 ? void 0 : performanceImpl.mark(markName);
        }
      }
      performance3.mark = mark;
      function measure(measureName, startMarkName, endMarkName) {
        var _a3, _b;
        if (enabled) {
          var end = (_a3 = endMarkName !== void 0 ? marks.get(endMarkName) : void 0) !== null && _a3 !== void 0 ? _a3 : ts2.timestamp();
          var start = (_b = startMarkName !== void 0 ? marks.get(startMarkName) : void 0) !== null && _b !== void 0 ? _b : timeorigin;
          var previousDuration = durations.get(measureName) || 0;
          durations.set(measureName, previousDuration + (end - start));
          performanceImpl === null || performanceImpl === void 0 ? void 0 : performanceImpl.measure(measureName, startMarkName, endMarkName);
        }
      }
      performance3.measure = measure;
      function getCount(markName) {
        return counts.get(markName) || 0;
      }
      performance3.getCount = getCount;
      function getDuration(measureName) {
        return durations.get(measureName) || 0;
      }
      performance3.getDuration = getDuration;
      function forEachMeasure(cb) {
        durations.forEach(function(duration, measureName) {
          return cb(measureName, duration);
        });
      }
      performance3.forEachMeasure = forEachMeasure;
      function isEnabled() {
        return enabled;
      }
      performance3.isEnabled = isEnabled;
      function enable(system) {
        var _a3;
        if (system === void 0) {
          system = ts2.sys;
        }
        if (!enabled) {
          enabled = true;
          perfHooks || (perfHooks = ts2.tryGetNativePerformanceHooks());
          if (perfHooks) {
            timeorigin = perfHooks.performance.timeOrigin;
            if (perfHooks.shouldWriteNativeEvents || ((_a3 = system === null || system === void 0 ? void 0 : system.cpuProfilingEnabled) === null || _a3 === void 0 ? void 0 : _a3.call(system)) || (system === null || system === void 0 ? void 0 : system.debugMode)) {
              performanceImpl = perfHooks.performance;
            }
          }
        }
        return true;
      }
      performance3.enable = enable;
      function disable() {
        if (enabled) {
          marks.clear();
          counts.clear();
          durations.clear();
          performanceImpl = void 0;
          enabled = false;
        }
      }
      performance3.disable = disable;
    })(performance2 = ts2.performance || (ts2.performance = {}));
  })(ts || (ts = {}));
  (function(ts2) {
    var _a3;
    var nullLogger = {
      logEvent: ts2.noop,
      logErrEvent: ts2.noop,
      logPerfEvent: ts2.noop,
      logInfoEvent: ts2.noop,
      logStartCommand: ts2.noop,
      logStopCommand: ts2.noop,
      logStartUpdateProgram: ts2.noop,
      logStopUpdateProgram: ts2.noop,
      logStartUpdateGraph: ts2.noop,
      logStopUpdateGraph: ts2.noop,
      logStartResolveModule: ts2.noop,
      logStopResolveModule: ts2.noop,
      logStartParseSourceFile: ts2.noop,
      logStopParseSourceFile: ts2.noop,
      logStartReadFile: ts2.noop,
      logStopReadFile: ts2.noop,
      logStartBindFile: ts2.noop,
      logStopBindFile: ts2.noop,
      logStartScheduledOperation: ts2.noop,
      logStopScheduledOperation: ts2.noop
    };
    var etwModule;
    try {
      var etwModulePath = (_a3 = process.env.TS_ETW_MODULE_PATH) !== null && _a3 !== void 0 ? _a3 : "./node_modules/@microsoft/typescript-etw";
      etwModule = void 0;
    } catch (e) {
      etwModule = void 0;
    }
    ts2.perfLogger = etwModule && etwModule.logEvent ? etwModule : nullLogger;
  })(ts || (ts = {}));
  (function(ts2) {
    var tracingEnabled;
    (function(tracingEnabled2) {
      var fs;
      var traceCount = 0;
      var traceFd = 0;
      var mode;
      var typeCatalog = [];
      var legendPath;
      var legend = [];
      ;
      function startTracing(tracingMode, traceDir, configFilePath) {
        ts2.Debug.assert(!ts2.tracing, "Tracing already started");
        if (fs === void 0) {
          try {
            fs = void 0;
          } catch (e) {
            throw new Error("tracing requires having fs\n(original error: ".concat(e.message || e, ")"));
          }
        }
        mode = tracingMode;
        typeCatalog.length = 0;
        if (legendPath === void 0) {
          legendPath = ts2.combinePaths(traceDir, "legend.json");
        }
        if (!fs.existsSync(traceDir)) {
          fs.mkdirSync(traceDir, {recursive: true});
        }
        var countPart = mode === "build" ? ".".concat(process.pid, "-").concat(++traceCount) : mode === "server" ? ".".concat(process.pid) : "";
        var tracePath = ts2.combinePaths(traceDir, "trace".concat(countPart, ".json"));
        var typesPath = ts2.combinePaths(traceDir, "types".concat(countPart, ".json"));
        legend.push({
          configFilePath,
          tracePath,
          typesPath
        });
        traceFd = fs.openSync(tracePath, "w");
        ts2.tracing = tracingEnabled2;
        var meta = {cat: "__metadata", ph: "M", ts: 1e3 * ts2.timestamp(), pid: 1, tid: 1};
        fs.writeSync(traceFd, "[\n" + [__assign({name: "process_name", args: {name: "tsc"}}, meta), __assign({name: "thread_name", args: {name: "Main"}}, meta), __assign(__assign({name: "TracingStartedInBrowser"}, meta), {cat: "disabled-by-default-devtools.timeline"})].map(function(v) {
          return JSON.stringify(v);
        }).join(",\n"));
      }
      tracingEnabled2.startTracing = startTracing;
      function stopTracing() {
        ts2.Debug.assert(ts2.tracing, "Tracing is not in progress");
        ts2.Debug.assert(!!typeCatalog.length === (mode !== "server"));
        fs.writeSync(traceFd, "\n]\n");
        fs.closeSync(traceFd);
        ts2.tracing = void 0;
        if (typeCatalog.length) {
          dumpTypes(typeCatalog);
        } else {
          legend[legend.length - 1].typesPath = void 0;
        }
      }
      tracingEnabled2.stopTracing = stopTracing;
      function recordType(type) {
        if (mode !== "server") {
          typeCatalog.push(type);
        }
      }
      tracingEnabled2.recordType = recordType;
      var Phase;
      (function(Phase2) {
        Phase2["Parse"] = "parse";
        Phase2["Program"] = "program";
        Phase2["Bind"] = "bind";
        Phase2["Check"] = "check";
        Phase2["CheckTypes"] = "checkTypes";
        Phase2["Emit"] = "emit";
        Phase2["Session"] = "session";
      })(Phase = tracingEnabled2.Phase || (tracingEnabled2.Phase = {}));
      function instant(phase, name, args) {
        writeEvent("I", phase, name, args, '"s":"g"');
      }
      tracingEnabled2.instant = instant;
      var eventStack = [];
      function push(phase, name, args, separateBeginAndEnd) {
        if (separateBeginAndEnd === void 0) {
          separateBeginAndEnd = false;
        }
        if (separateBeginAndEnd) {
          writeEvent("B", phase, name, args);
        }
        eventStack.push({phase, name, args, time: 1e3 * ts2.timestamp(), separateBeginAndEnd});
      }
      tracingEnabled2.push = push;
      function pop() {
        ts2.Debug.assert(eventStack.length > 0);
        writeStackEvent(eventStack.length - 1, 1e3 * ts2.timestamp());
        eventStack.length--;
      }
      tracingEnabled2.pop = pop;
      function popAll() {
        var endTime = 1e3 * ts2.timestamp();
        for (var i = eventStack.length - 1; i >= 0; i--) {
          writeStackEvent(i, endTime);
        }
        eventStack.length = 0;
      }
      tracingEnabled2.popAll = popAll;
      var sampleInterval = 1e3 * 10;
      function writeStackEvent(index, endTime) {
        var _a3 = eventStack[index], phase = _a3.phase, name = _a3.name, args = _a3.args, time = _a3.time, separateBeginAndEnd = _a3.separateBeginAndEnd;
        if (separateBeginAndEnd) {
          writeEvent("E", phase, name, args, void 0, endTime);
        } else if (sampleInterval - time % sampleInterval <= endTime - time) {
          writeEvent("X", phase, name, args, '"dur":'.concat(endTime - time), time);
        }
      }
      function writeEvent(eventType, phase, name, args, extras, time) {
        if (time === void 0) {
          time = 1e3 * ts2.timestamp();
        }
        if (mode === "server" && phase === "checkTypes")
          return;
        ts2.performance.mark("beginTracing");
        fs.writeSync(traceFd, ',\n{"pid":1,"tid":1,"ph":"'.concat(eventType, '","cat":"').concat(phase, '","ts":').concat(time, ',"name":"').concat(name, '"'));
        if (extras)
          fs.writeSync(traceFd, ",".concat(extras));
        if (args)
          fs.writeSync(traceFd, ',"args":'.concat(JSON.stringify(args)));
        fs.writeSync(traceFd, "}");
        ts2.performance.mark("endTracing");
        ts2.performance.measure("Tracing", "beginTracing", "endTracing");
      }
      function getLocation(node) {
        var file = ts2.getSourceFileOfNode(node);
        return !file ? void 0 : {
          path: file.path,
          start: indexFromOne(ts2.getLineAndCharacterOfPosition(file, node.pos)),
          end: indexFromOne(ts2.getLineAndCharacterOfPosition(file, node.end))
        };
        function indexFromOne(lc) {
          return {
            line: lc.line + 1,
            character: lc.character + 1
          };
        }
      }
      function dumpTypes(types3) {
        var _a3, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x;
        ts2.performance.mark("beginDumpTypes");
        var typesPath = legend[legend.length - 1].typesPath;
        var typesFd = fs.openSync(typesPath, "w");
        var recursionIdentityMap = new ts2.Map();
        fs.writeSync(typesFd, "[");
        var numTypes = types3.length;
        for (var i = 0; i < numTypes; i++) {
          var type = types3[i];
          var objectFlags = type.objectFlags;
          var symbol = (_a3 = type.aliasSymbol) !== null && _a3 !== void 0 ? _a3 : type.symbol;
          var display = void 0;
          if (objectFlags & 16 | type.flags & 2944) {
            try {
              display = (_b = type.checker) === null || _b === void 0 ? void 0 : _b.typeToString(type);
            } catch (_y) {
              display = void 0;
            }
          }
          var indexedAccessProperties = {};
          if (type.flags & 8388608) {
            var indexedAccessType = type;
            indexedAccessProperties = {
              indexedAccessObjectType: (_c = indexedAccessType.objectType) === null || _c === void 0 ? void 0 : _c.id,
              indexedAccessIndexType: (_d = indexedAccessType.indexType) === null || _d === void 0 ? void 0 : _d.id
            };
          }
          var referenceProperties = {};
          if (objectFlags & 4) {
            var referenceType = type;
            referenceProperties = {
              instantiatedType: (_e = referenceType.target) === null || _e === void 0 ? void 0 : _e.id,
              typeArguments: (_f = referenceType.resolvedTypeArguments) === null || _f === void 0 ? void 0 : _f.map(function(t) {
                return t.id;
              }),
              referenceLocation: getLocation(referenceType.node)
            };
          }
          var conditionalProperties = {};
          if (type.flags & 16777216) {
            var conditionalType = type;
            conditionalProperties = {
              conditionalCheckType: (_g = conditionalType.checkType) === null || _g === void 0 ? void 0 : _g.id,
              conditionalExtendsType: (_h = conditionalType.extendsType) === null || _h === void 0 ? void 0 : _h.id,
              conditionalTrueType: (_k = (_j = conditionalType.resolvedTrueType) === null || _j === void 0 ? void 0 : _j.id) !== null && _k !== void 0 ? _k : -1,
              conditionalFalseType: (_m = (_l = conditionalType.resolvedFalseType) === null || _l === void 0 ? void 0 : _l.id) !== null && _m !== void 0 ? _m : -1
            };
          }
          var substitutionProperties = {};
          if (type.flags & 33554432) {
            var substitutionType = type;
            substitutionProperties = {
              substitutionBaseType: (_o = substitutionType.baseType) === null || _o === void 0 ? void 0 : _o.id,
              substituteType: (_p = substitutionType.substitute) === null || _p === void 0 ? void 0 : _p.id
            };
          }
          var reverseMappedProperties = {};
          if (objectFlags & 1024) {
            var reverseMappedType = type;
            reverseMappedProperties = {
              reverseMappedSourceType: (_q = reverseMappedType.source) === null || _q === void 0 ? void 0 : _q.id,
              reverseMappedMappedType: (_r = reverseMappedType.mappedType) === null || _r === void 0 ? void 0 : _r.id,
              reverseMappedConstraintType: (_s = reverseMappedType.constraintType) === null || _s === void 0 ? void 0 : _s.id
            };
          }
          var evolvingArrayProperties = {};
          if (objectFlags & 256) {
            var evolvingArrayType = type;
            evolvingArrayProperties = {
              evolvingArrayElementType: evolvingArrayType.elementType.id,
              evolvingArrayFinalType: (_t = evolvingArrayType.finalArrayType) === null || _t === void 0 ? void 0 : _t.id
            };
          }
          var recursionToken = void 0;
          var recursionIdentity = type.checker.getRecursionIdentity(type);
          if (recursionIdentity) {
            recursionToken = recursionIdentityMap.get(recursionIdentity);
            if (!recursionToken) {
              recursionToken = recursionIdentityMap.size;
              recursionIdentityMap.set(recursionIdentity, recursionToken);
            }
          }
          var descriptor = __assign(__assign(__assign(__assign(__assign(__assign(__assign({id: type.id, intrinsicName: type.intrinsicName, symbolName: (symbol === null || symbol === void 0 ? void 0 : symbol.escapedName) && ts2.unescapeLeadingUnderscores(symbol.escapedName), recursionId: recursionToken, isTuple: objectFlags & 8 ? true : void 0, unionTypes: type.flags & 1048576 ? (_u = type.types) === null || _u === void 0 ? void 0 : _u.map(function(t) {
            return t.id;
          }) : void 0, intersectionTypes: type.flags & 2097152 ? type.types.map(function(t) {
            return t.id;
          }) : void 0, aliasTypeArguments: (_v = type.aliasTypeArguments) === null || _v === void 0 ? void 0 : _v.map(function(t) {
            return t.id;
          }), keyofType: type.flags & 4194304 ? (_w = type.type) === null || _w === void 0 ? void 0 : _w.id : void 0}, indexedAccessProperties), referenceProperties), conditionalProperties), substitutionProperties), reverseMappedProperties), evolvingArrayProperties), {destructuringPattern: getLocation(type.pattern), firstDeclaration: getLocation((_x = symbol === null || symbol === void 0 ? void 0 : symbol.declarations) === null || _x === void 0 ? void 0 : _x[0]), flags: ts2.Debug.formatTypeFlags(type.flags).split("|"), display});
          fs.writeSync(typesFd, JSON.stringify(descriptor));
          if (i < numTypes - 1) {
            fs.writeSync(typesFd, ",\n");
          }
        }
        fs.writeSync(typesFd, "]\n");
        fs.closeSync(typesFd);
        ts2.performance.mark("endDumpTypes");
        ts2.performance.measure("Dump types", "beginDumpTypes", "endDumpTypes");
      }
      function dumpLegend() {
        if (!legendPath) {
          return;
        }
        fs.writeFileSync(legendPath, JSON.stringify(legend));
      }
      tracingEnabled2.dumpLegend = dumpLegend;
    })(tracingEnabled || (tracingEnabled = {}));
    ts2.startTracing = tracingEnabled.startTracing;
    ts2.dumpTracingLegend = tracingEnabled.dumpLegend;
  })(ts || (ts = {}));
  (function(ts2) {
    var SyntaxKind;
    (function(SyntaxKind2) {
      SyntaxKind2[SyntaxKind2["Unknown"] = 0] = "Unknown";
      SyntaxKind2[SyntaxKind2["EndOfFileToken"] = 1] = "EndOfFileToken";
      SyntaxKind2[SyntaxKind2["SingleLineCommentTrivia"] = 2] = "SingleLineCommentTrivia";
      SyntaxKind2[SyntaxKind2["MultiLineCommentTrivia"] = 3] = "MultiLineCommentTrivia";
      SyntaxKind2[SyntaxKind2["NewLineTrivia"] = 4] = "NewLineTrivia";
      SyntaxKind2[SyntaxKind2["WhitespaceTrivia"] = 5] = "WhitespaceTrivia";
      SyntaxKind2[SyntaxKind2["ShebangTrivia"] = 6] = "ShebangTrivia";
      SyntaxKind2[SyntaxKind2["ConflictMarkerTrivia"] = 7] = "ConflictMarkerTrivia";
      SyntaxKind2[SyntaxKind2["NumericLiteral"] = 8] = "NumericLiteral";
      SyntaxKind2[SyntaxKind2["BigIntLiteral"] = 9] = "BigIntLiteral";
      SyntaxKind2[SyntaxKind2["StringLiteral"] = 10] = "StringLiteral";
      SyntaxKind2[SyntaxKind2["JsxText"] = 11] = "JsxText";
      SyntaxKind2[SyntaxKind2["JsxTextAllWhiteSpaces"] = 12] = "JsxTextAllWhiteSpaces";
      SyntaxKind2[SyntaxKind2["RegularExpressionLiteral"] = 13] = "RegularExpressionLiteral";
      SyntaxKind2[SyntaxKind2["NoSubstitutionTemplateLiteral"] = 14] = "NoSubstitutionTemplateLiteral";
      SyntaxKind2[SyntaxKind2["TemplateHead"] = 15] = "TemplateHead";
      SyntaxKind2[SyntaxKind2["TemplateMiddle"] = 16] = "TemplateMiddle";
      SyntaxKind2[SyntaxKind2["TemplateTail"] = 17] = "TemplateTail";
      SyntaxKind2[SyntaxKind2["OpenBraceToken"] = 18] = "OpenBraceToken";
      SyntaxKind2[SyntaxKind2["CloseBraceToken"] = 19] = "CloseBraceToken";
      SyntaxKind2[SyntaxKind2["OpenParenToken"] = 20] = "OpenParenToken";
      SyntaxKind2[SyntaxKind2["CloseParenToken"] = 21] = "CloseParenToken";
      SyntaxKind2[SyntaxKind2["OpenBracketToken"] = 22] = "OpenBracketToken";
      SyntaxKind2[SyntaxKind2["CloseBracketToken"] = 23] = "CloseBracketToken";
      SyntaxKind2[SyntaxKind2["DotToken"] = 24] = "DotToken";
      SyntaxKind2[SyntaxKind2["DotDotDotToken"] = 25] = "DotDotDotToken";
      SyntaxKind2[SyntaxKind2["SemicolonToken"] = 26] = "SemicolonToken";
      SyntaxKind2[SyntaxKind2["CommaToken"] = 27] = "CommaToken";
      SyntaxKind2[SyntaxKind2["QuestionDotToken"] = 28] = "QuestionDotToken";
      SyntaxKind2[SyntaxKind2["LessThanToken"] = 29] = "LessThanToken";
      SyntaxKind2[SyntaxKind2["LessThanSlashToken"] = 30] = "LessThanSlashToken";
      SyntaxKind2[SyntaxKind2["GreaterThanToken"] = 31] = "GreaterThanToken";
      SyntaxKind2[SyntaxKind2["LessThanEqualsToken"] = 32] = "LessThanEqualsToken";
      SyntaxKind2[SyntaxKind2["GreaterThanEqualsToken"] = 33] = "GreaterThanEqualsToken";
      SyntaxKind2[SyntaxKind2["EqualsEqualsToken"] = 34] = "EqualsEqualsToken";
      SyntaxKind2[SyntaxKind2["ExclamationEqualsToken"] = 35] = "ExclamationEqualsToken";
      SyntaxKind2[SyntaxKind2["EqualsEqualsEqualsToken"] = 36] = "EqualsEqualsEqualsToken";
      SyntaxKind2[SyntaxKind2["ExclamationEqualsEqualsToken"] = 37] = "ExclamationEqualsEqualsToken";
      SyntaxKind2[SyntaxKind2["EqualsGreaterThanToken"] = 38] = "EqualsGreaterThanToken";
      SyntaxKind2[SyntaxKind2["PlusToken"] = 39] = "PlusToken";
      SyntaxKind2[SyntaxKind2["MinusToken"] = 40] = "MinusToken";
      SyntaxKind2[SyntaxKind2["AsteriskToken"] = 41] = "AsteriskToken";
      SyntaxKind2[SyntaxKind2["AsteriskAsteriskToken"] = 42] = "AsteriskAsteriskToken";
      SyntaxKind2[SyntaxKind2["SlashToken"] = 43] = "SlashToken";
      SyntaxKind2[SyntaxKind2["PercentToken"] = 44] = "PercentToken";
      SyntaxKind2[SyntaxKind2["PlusPlusToken"] = 45] = "PlusPlusToken";
      SyntaxKind2[SyntaxKind2["MinusMinusToken"] = 46] = "MinusMinusToken";
      SyntaxKind2[SyntaxKind2["LessThanLessThanToken"] = 47] = "LessThanLessThanToken";
      SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanToken"] = 48] = "GreaterThanGreaterThanToken";
      SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanGreaterThanToken"] = 49] = "GreaterThanGreaterThanGreaterThanToken";
      SyntaxKind2[SyntaxKind2["AmpersandToken"] = 50] = "AmpersandToken";
      SyntaxKind2[SyntaxKind2["BarToken"] = 51] = "BarToken";
      SyntaxKind2[SyntaxKind2["CaretToken"] = 52] = "CaretToken";
      SyntaxKind2[SyntaxKind2["ExclamationToken"] = 53] = "ExclamationToken";
      SyntaxKind2[SyntaxKind2["TildeToken"] = 54] = "TildeToken";
      SyntaxKind2[SyntaxKind2["AmpersandAmpersandToken"] = 55] = "AmpersandAmpersandToken";
      SyntaxKind2[SyntaxKind2["BarBarToken"] = 56] = "BarBarToken";
      SyntaxKind2[SyntaxKind2["QuestionToken"] = 57] = "QuestionToken";
      SyntaxKind2[SyntaxKind2["ColonToken"] = 58] = "ColonToken";
      SyntaxKind2[SyntaxKind2["AtToken"] = 59] = "AtToken";
      SyntaxKind2[SyntaxKind2["QuestionQuestionToken"] = 60] = "QuestionQuestionToken";
      SyntaxKind2[SyntaxKind2["BacktickToken"] = 61] = "BacktickToken";
      SyntaxKind2[SyntaxKind2["HashToken"] = 62] = "HashToken";
      SyntaxKind2[SyntaxKind2["EqualsToken"] = 63] = "EqualsToken";
      SyntaxKind2[SyntaxKind2["PlusEqualsToken"] = 64] = "PlusEqualsToken";
      SyntaxKind2[SyntaxKind2["MinusEqualsToken"] = 65] = "MinusEqualsToken";
      SyntaxKind2[SyntaxKind2["AsteriskEqualsToken"] = 66] = "AsteriskEqualsToken";
      SyntaxKind2[SyntaxKind2["AsteriskAsteriskEqualsToken"] = 67] = "AsteriskAsteriskEqualsToken";
      SyntaxKind2[SyntaxKind2["SlashEqualsToken"] = 68] = "SlashEqualsToken";
      SyntaxKind2[SyntaxKind2["PercentEqualsToken"] = 69] = "PercentEqualsToken";
      SyntaxKind2[SyntaxKind2["LessThanLessThanEqualsToken"] = 70] = "LessThanLessThanEqualsToken";
      SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanEqualsToken"] = 71] = "GreaterThanGreaterThanEqualsToken";
      SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanGreaterThanEqualsToken"] = 72] = "GreaterThanGreaterThanGreaterThanEqualsToken";
      SyntaxKind2[SyntaxKind2["AmpersandEqualsToken"] = 73] = "AmpersandEqualsToken";
      SyntaxKind2[SyntaxKind2["BarEqualsToken"] = 74] = "BarEqualsToken";
      SyntaxKind2[SyntaxKind2["BarBarEqualsToken"] = 75] = "BarBarEqualsToken";
      SyntaxKind2[SyntaxKind2["AmpersandAmpersandEqualsToken"] = 76] = "AmpersandAmpersandEqualsToken";
      SyntaxKind2[SyntaxKind2["QuestionQuestionEqualsToken"] = 77] = "QuestionQuestionEqualsToken";
      SyntaxKind2[SyntaxKind2["CaretEqualsToken"] = 78] = "CaretEqualsToken";
      SyntaxKind2[SyntaxKind2["Identifier"] = 79] = "Identifier";
      SyntaxKind2[SyntaxKind2["PrivateIdentifier"] = 80] = "PrivateIdentifier";
      SyntaxKind2[SyntaxKind2["BreakKeyword"] = 81] = "BreakKeyword";
      SyntaxKind2[SyntaxKind2["CaseKeyword"] = 82] = "CaseKeyword";
      SyntaxKind2[SyntaxKind2["CatchKeyword"] = 83] = "CatchKeyword";
      SyntaxKind2[SyntaxKind2["ClassKeyword"] = 84] = "ClassKeyword";
      SyntaxKind2[SyntaxKind2["ConstKeyword"] = 85] = "ConstKeyword";
      SyntaxKind2[SyntaxKind2["ContinueKeyword"] = 86] = "ContinueKeyword";
      SyntaxKind2[SyntaxKind2["DebuggerKeyword"] = 87] = "DebuggerKeyword";
      SyntaxKind2[SyntaxKind2["DefaultKeyword"] = 88] = "DefaultKeyword";
      SyntaxKind2[SyntaxKind2["DeleteKeyword"] = 89] = "DeleteKeyword";
      SyntaxKind2[SyntaxKind2["DoKeyword"] = 90] = "DoKeyword";
      SyntaxKind2[SyntaxKind2["ElseKeyword"] = 91] = "ElseKeyword";
      SyntaxKind2[SyntaxKind2["EnumKeyword"] = 92] = "EnumKeyword";
      SyntaxKind2[SyntaxKind2["ExportKeyword"] = 93] = "ExportKeyword";
      SyntaxKind2[SyntaxKind2["ExtendsKeyword"] = 94] = "ExtendsKeyword";
      SyntaxKind2[SyntaxKind2["FalseKeyword"] = 95] = "FalseKeyword";
      SyntaxKind2[SyntaxKind2["FinallyKeyword"] = 96] = "FinallyKeyword";
      SyntaxKind2[SyntaxKind2["ForKeyword"] = 97] = "ForKeyword";
      SyntaxKind2[SyntaxKind2["FunctionKeyword"] = 98] = "FunctionKeyword";
      SyntaxKind2[SyntaxKind2["IfKeyword"] = 99] = "IfKeyword";
      SyntaxKind2[SyntaxKind2["ImportKeyword"] = 100] = "ImportKeyword";
      SyntaxKind2[SyntaxKind2["InKeyword"] = 101] = "InKeyword";
      SyntaxKind2[SyntaxKind2["InstanceOfKeyword"] = 102] = "InstanceOfKeyword";
      SyntaxKind2[SyntaxKind2["NewKeyword"] = 103] = "NewKeyword";
      SyntaxKind2[SyntaxKind2["NullKeyword"] = 104] = "NullKeyword";
      SyntaxKind2[SyntaxKind2["ReturnKeyword"] = 105] = "ReturnKeyword";
      SyntaxKind2[SyntaxKind2["SuperKeyword"] = 106] = "SuperKeyword";
      SyntaxKind2[SyntaxKind2["SwitchKeyword"] = 107] = "SwitchKeyword";
      SyntaxKind2[SyntaxKind2["ThisKeyword"] = 108] = "ThisKeyword";
      SyntaxKind2[SyntaxKind2["ThrowKeyword"] = 109] = "ThrowKeyword";
      SyntaxKind2[SyntaxKind2["TrueKeyword"] = 110] = "TrueKeyword";
      SyntaxKind2[SyntaxKind2["TryKeyword"] = 111] = "TryKeyword";
      SyntaxKind2[SyntaxKind2["TypeOfKeyword"] = 112] = "TypeOfKeyword";
      SyntaxKind2[SyntaxKind2["VarKeyword"] = 113] = "VarKeyword";
      SyntaxKind2[SyntaxKind2["VoidKeyword"] = 114] = "VoidKeyword";
      SyntaxKind2[SyntaxKind2["WhileKeyword"] = 115] = "WhileKeyword";
      SyntaxKind2[SyntaxKind2["WithKeyword"] = 116] = "WithKeyword";
      SyntaxKind2[SyntaxKind2["ImplementsKeyword"] = 117] = "ImplementsKeyword";
      SyntaxKind2[SyntaxKind2["InterfaceKeyword"] = 118] = "InterfaceKeyword";
      SyntaxKind2[SyntaxKind2["LetKeyword"] = 119] = "LetKeyword";
      SyntaxKind2[SyntaxKind2["PackageKeyword"] = 120] = "PackageKeyword";
      SyntaxKind2[SyntaxKind2["PrivateKeyword"] = 121] = "PrivateKeyword";
      SyntaxKind2[SyntaxKind2["ProtectedKeyword"] = 122] = "ProtectedKeyword";
      SyntaxKind2[SyntaxKind2["PublicKeyword"] = 123] = "PublicKeyword";
      SyntaxKind2[SyntaxKind2["StaticKeyword"] = 124] = "StaticKeyword";
      SyntaxKind2[SyntaxKind2["YieldKeyword"] = 125] = "YieldKeyword";
      SyntaxKind2[SyntaxKind2["AbstractKeyword"] = 126] = "AbstractKeyword";
      SyntaxKind2[SyntaxKind2["AsKeyword"] = 127] = "AsKeyword";
      SyntaxKind2[SyntaxKind2["AssertsKeyword"] = 128] = "AssertsKeyword";
      SyntaxKind2[SyntaxKind2["AssertKeyword"] = 129] = "AssertKeyword";
      SyntaxKind2[SyntaxKind2["AnyKeyword"] = 130] = "AnyKeyword";
      SyntaxKind2[SyntaxKind2["AsyncKeyword"] = 131] = "AsyncKeyword";
      SyntaxKind2[SyntaxKind2["AwaitKeyword"] = 132] = "AwaitKeyword";
      SyntaxKind2[SyntaxKind2["BooleanKeyword"] = 133] = "BooleanKeyword";
      SyntaxKind2[SyntaxKind2["ConstructorKeyword"] = 134] = "ConstructorKeyword";
      SyntaxKind2[SyntaxKind2["DeclareKeyword"] = 135] = "DeclareKeyword";
      SyntaxKind2[SyntaxKind2["GetKeyword"] = 136] = "GetKeyword";
      SyntaxKind2[SyntaxKind2["InferKeyword"] = 137] = "InferKeyword";
      SyntaxKind2[SyntaxKind2["IntrinsicKeyword"] = 138] = "IntrinsicKeyword";
      SyntaxKind2[SyntaxKind2["IsKeyword"] = 139] = "IsKeyword";
      SyntaxKind2[SyntaxKind2["KeyOfKeyword"] = 140] = "KeyOfKeyword";
      SyntaxKind2[SyntaxKind2["ModuleKeyword"] = 141] = "ModuleKeyword";
      SyntaxKind2[SyntaxKind2["NamespaceKeyword"] = 142] = "NamespaceKeyword";
      SyntaxKind2[SyntaxKind2["NeverKeyword"] = 143] = "NeverKeyword";
      SyntaxKind2[SyntaxKind2["ReadonlyKeyword"] = 144] = "ReadonlyKeyword";
      SyntaxKind2[SyntaxKind2["RequireKeyword"] = 145] = "RequireKeyword";
      SyntaxKind2[SyntaxKind2["NumberKeyword"] = 146] = "NumberKeyword";
      SyntaxKind2[SyntaxKind2["ObjectKeyword"] = 147] = "ObjectKeyword";
      SyntaxKind2[SyntaxKind2["SetKeyword"] = 148] = "SetKeyword";
      SyntaxKind2[SyntaxKind2["StringKeyword"] = 149] = "StringKeyword";
      SyntaxKind2[SyntaxKind2["SymbolKeyword"] = 150] = "SymbolKeyword";
      SyntaxKind2[SyntaxKind2["TypeKeyword"] = 151] = "TypeKeyword";
      SyntaxKind2[SyntaxKind2["UndefinedKeyword"] = 152] = "UndefinedKeyword";
      SyntaxKind2[SyntaxKind2["UniqueKeyword"] = 153] = "UniqueKeyword";
      SyntaxKind2[SyntaxKind2["UnknownKeyword"] = 154] = "UnknownKeyword";
      SyntaxKind2[SyntaxKind2["FromKeyword"] = 155] = "FromKeyword";
      SyntaxKind2[SyntaxKind2["GlobalKeyword"] = 156] = "GlobalKeyword";
      SyntaxKind2[SyntaxKind2["BigIntKeyword"] = 157] = "BigIntKeyword";
      SyntaxKind2[SyntaxKind2["OverrideKeyword"] = 158] = "OverrideKeyword";
      SyntaxKind2[SyntaxKind2["OfKeyword"] = 159] = "OfKeyword";
      SyntaxKind2[SyntaxKind2["QualifiedName"] = 160] = "QualifiedName";
      SyntaxKind2[SyntaxKind2["ComputedPropertyName"] = 161] = "ComputedPropertyName";
      SyntaxKind2[SyntaxKind2["TypeParameter"] = 162] = "TypeParameter";
      SyntaxKind2[SyntaxKind2["Parameter"] = 163] = "Parameter";
      SyntaxKind2[SyntaxKind2["Decorator"] = 164] = "Decorator";
      SyntaxKind2[SyntaxKind2["PropertySignature"] = 165] = "PropertySignature";
      SyntaxKind2[SyntaxKind2["PropertyDeclaration"] = 166] = "PropertyDeclaration";
      SyntaxKind2[SyntaxKind2["MethodSignature"] = 167] = "MethodSignature";
      SyntaxKind2[SyntaxKind2["MethodDeclaration"] = 168] = "MethodDeclaration";
      SyntaxKind2[SyntaxKind2["ClassStaticBlockDeclaration"] = 169] = "ClassStaticBlockDeclaration";
      SyntaxKind2[SyntaxKind2["Constructor"] = 170] = "Constructor";
      SyntaxKind2[SyntaxKind2["GetAccessor"] = 171] = "GetAccessor";
      SyntaxKind2[SyntaxKind2["SetAccessor"] = 172] = "SetAccessor";
      SyntaxKind2[SyntaxKind2["CallSignature"] = 173] = "CallSignature";
      SyntaxKind2[SyntaxKind2["ConstructSignature"] = 174] = "ConstructSignature";
      SyntaxKind2[SyntaxKind2["IndexSignature"] = 175] = "IndexSignature";
      SyntaxKind2[SyntaxKind2["TypePredicate"] = 176] = "TypePredicate";
      SyntaxKind2[SyntaxKind2["TypeReference"] = 177] = "TypeReference";
      SyntaxKind2[SyntaxKind2["FunctionType"] = 178] = "FunctionType";
      SyntaxKind2[SyntaxKind2["ConstructorType"] = 179] = "ConstructorType";
      SyntaxKind2[SyntaxKind2["TypeQuery"] = 180] = "TypeQuery";
      SyntaxKind2[SyntaxKind2["TypeLiteral"] = 181] = "TypeLiteral";
      SyntaxKind2[SyntaxKind2["ArrayType"] = 182] = "ArrayType";
      SyntaxKind2[SyntaxKind2["TupleType"] = 183] = "TupleType";
      SyntaxKind2[SyntaxKind2["OptionalType"] = 184] = "OptionalType";
      SyntaxKind2[SyntaxKind2["RestType"] = 185] = "RestType";
      SyntaxKind2[SyntaxKind2["UnionType"] = 186] = "UnionType";
      SyntaxKind2[SyntaxKind2["IntersectionType"] = 187] = "IntersectionType";
      SyntaxKind2[SyntaxKind2["ConditionalType"] = 188] = "ConditionalType";
      SyntaxKind2[SyntaxKind2["InferType"] = 189] = "InferType";
      SyntaxKind2[SyntaxKind2["ParenthesizedType"] = 190] = "ParenthesizedType";
      SyntaxKind2[SyntaxKind2["ThisType"] = 191] = "ThisType";
      SyntaxKind2[SyntaxKind2["TypeOperator"] = 192] = "TypeOperator";
      SyntaxKind2[SyntaxKind2["IndexedAccessType"] = 193] = "IndexedAccessType";
      SyntaxKind2[SyntaxKind2["MappedType"] = 194] = "MappedType";
      SyntaxKind2[SyntaxKind2["LiteralType"] = 195] = "LiteralType";
      SyntaxKind2[SyntaxKind2["NamedTupleMember"] = 196] = "NamedTupleMember";
      SyntaxKind2[SyntaxKind2["TemplateLiteralType"] = 197] = "TemplateLiteralType";
      SyntaxKind2[SyntaxKind2["TemplateLiteralTypeSpan"] = 198] = "TemplateLiteralTypeSpan";
      SyntaxKind2[SyntaxKind2["ImportType"] = 199] = "ImportType";
      SyntaxKind2[SyntaxKind2["ObjectBindingPattern"] = 200] = "ObjectBindingPattern";
      SyntaxKind2[SyntaxKind2["ArrayBindingPattern"] = 201] = "ArrayBindingPattern";
      SyntaxKind2[SyntaxKind2["BindingElement"] = 202] = "BindingElement";
      SyntaxKind2[SyntaxKind2["ArrayLiteralExpression"] = 203] = "ArrayLiteralExpression";
      SyntaxKind2[SyntaxKind2["ObjectLiteralExpression"] = 204] = "ObjectLiteralExpression";
      SyntaxKind2[SyntaxKind2["PropertyAccessExpression"] = 205] = "PropertyAccessExpression";
      SyntaxKind2[SyntaxKind2["ElementAccessExpression"] = 206] = "ElementAccessExpression";
      SyntaxKind2[SyntaxKind2["CallExpression"] = 207] = "CallExpression";
      SyntaxKind2[SyntaxKind2["NewExpression"] = 208] = "NewExpression";
      SyntaxKind2[SyntaxKind2["TaggedTemplateExpression"] = 209] = "TaggedTemplateExpression";
      SyntaxKind2[SyntaxKind2["TypeAssertionExpression"] = 210] = "TypeAssertionExpression";
      SyntaxKind2[SyntaxKind2["ParenthesizedExpression"] = 211] = "ParenthesizedExpression";
      SyntaxKind2[SyntaxKind2["FunctionExpression"] = 212] = "FunctionExpression";
      SyntaxKind2[SyntaxKind2["ArrowFunction"] = 213] = "ArrowFunction";
      SyntaxKind2[SyntaxKind2["DeleteExpression"] = 214] = "DeleteExpression";
      SyntaxKind2[SyntaxKind2["TypeOfExpression"] = 215] = "TypeOfExpression";
      SyntaxKind2[SyntaxKind2["VoidExpression"] = 216] = "VoidExpression";
      SyntaxKind2[SyntaxKind2["AwaitExpression"] = 217] = "AwaitExpression";
      SyntaxKind2[SyntaxKind2["PrefixUnaryExpression"] = 218] = "PrefixUnaryExpression";
      SyntaxKind2[SyntaxKind2["PostfixUnaryExpression"] = 219] = "PostfixUnaryExpression";
      SyntaxKind2[SyntaxKind2["BinaryExpression"] = 220] = "BinaryExpression";
      SyntaxKind2[SyntaxKind2["ConditionalExpression"] = 221] = "ConditionalExpression";
      SyntaxKind2[SyntaxKind2["TemplateExpression"] = 222] = "TemplateExpression";
      SyntaxKind2[SyntaxKind2["YieldExpression"] = 223] = "YieldExpression";
      SyntaxKind2[SyntaxKind2["SpreadElement"] = 224] = "SpreadElement";
      SyntaxKind2[SyntaxKind2["ClassExpression"] = 225] = "ClassExpression";
      SyntaxKind2[SyntaxKind2["OmittedExpression"] = 226] = "OmittedExpression";
      SyntaxKind2[SyntaxKind2["ExpressionWithTypeArguments"] = 227] = "ExpressionWithTypeArguments";
      SyntaxKind2[SyntaxKind2["AsExpression"] = 228] = "AsExpression";
      SyntaxKind2[SyntaxKind2["NonNullExpression"] = 229] = "NonNullExpression";
      SyntaxKind2[SyntaxKind2["MetaProperty"] = 230] = "MetaProperty";
      SyntaxKind2[SyntaxKind2["SyntheticExpression"] = 231] = "SyntheticExpression";
      SyntaxKind2[SyntaxKind2["TemplateSpan"] = 232] = "TemplateSpan";
      SyntaxKind2[SyntaxKind2["SemicolonClassElement"] = 233] = "SemicolonClassElement";
      SyntaxKind2[SyntaxKind2["Block"] = 234] = "Block";
      SyntaxKind2[SyntaxKind2["EmptyStatement"] = 235] = "EmptyStatement";
      SyntaxKind2[SyntaxKind2["VariableStatement"] = 236] = "VariableStatement";
      SyntaxKind2[SyntaxKind2["ExpressionStatement"] = 237] = "ExpressionStatement";
      SyntaxKind2[SyntaxKind2["IfStatement"] = 238] = "IfStatement";
      SyntaxKind2[SyntaxKind2["DoStatement"] = 239] = "DoStatement";
      SyntaxKind2[SyntaxKind2["WhileStatement"] = 240] = "WhileStatement";
      SyntaxKind2[SyntaxKind2["ForStatement"] = 241] = "ForStatement";
      SyntaxKind2[SyntaxKind2["ForInStatement"] = 242] = "ForInStatement";
      SyntaxKind2[SyntaxKind2["ForOfStatement"] = 243] = "ForOfStatement";
      SyntaxKind2[SyntaxKind2["ContinueStatement"] = 244] = "ContinueStatement";
      SyntaxKind2[SyntaxKind2["BreakStatement"] = 245] = "BreakStatement";
      SyntaxKind2[SyntaxKind2["ReturnStatement"] = 246] = "ReturnStatement";
      SyntaxKind2[SyntaxKind2["WithStatement"] = 247] = "WithStatement";
      SyntaxKind2[SyntaxKind2["SwitchStatement"] = 248] = "SwitchStatement";
      SyntaxKind2[SyntaxKind2["LabeledStatement"] = 249] = "LabeledStatement";
      SyntaxKind2[SyntaxKind2["ThrowStatement"] = 250] = "ThrowStatement";
      SyntaxKind2[SyntaxKind2["TryStatement"] = 251] = "TryStatement";
      SyntaxKind2[SyntaxKind2["DebuggerStatement"] = 252] = "DebuggerStatement";
      SyntaxKind2[SyntaxKind2["VariableDeclaration"] = 253] = "VariableDeclaration";
      SyntaxKind2[SyntaxKind2["VariableDeclarationList"] = 254] = "VariableDeclarationList";
      SyntaxKind2[SyntaxKind2["FunctionDeclaration"] = 255] = "FunctionDeclaration";
      SyntaxKind2[SyntaxKind2["ClassDeclaration"] = 256] = "ClassDeclaration";
      SyntaxKind2[SyntaxKind2["InterfaceDeclaration"] = 257] = "InterfaceDeclaration";
      SyntaxKind2[SyntaxKind2["TypeAliasDeclaration"] = 258] = "TypeAliasDeclaration";
      SyntaxKind2[SyntaxKind2["EnumDeclaration"] = 259] = "EnumDeclaration";
      SyntaxKind2[SyntaxKind2["ModuleDeclaration"] = 260] = "ModuleDeclaration";
      SyntaxKind2[SyntaxKind2["ModuleBlock"] = 261] = "ModuleBlock";
      SyntaxKind2[SyntaxKind2["CaseBlock"] = 262] = "CaseBlock";
      SyntaxKind2[SyntaxKind2["NamespaceExportDeclaration"] = 263] = "NamespaceExportDeclaration";
      SyntaxKind2[SyntaxKind2["ImportEqualsDeclaration"] = 264] = "ImportEqualsDeclaration";
      SyntaxKind2[SyntaxKind2["ImportDeclaration"] = 265] = "ImportDeclaration";
      SyntaxKind2[SyntaxKind2["ImportClause"] = 266] = "ImportClause";
      SyntaxKind2[SyntaxKind2["NamespaceImport"] = 267] = "NamespaceImport";
      SyntaxKind2[SyntaxKind2["NamedImports"] = 268] = "NamedImports";
      SyntaxKind2[SyntaxKind2["ImportSpecifier"] = 269] = "ImportSpecifier";
      SyntaxKind2[SyntaxKind2["ExportAssignment"] = 270] = "ExportAssignment";
      SyntaxKind2[SyntaxKind2["ExportDeclaration"] = 271] = "ExportDeclaration";
      SyntaxKind2[SyntaxKind2["NamedExports"] = 272] = "NamedExports";
      SyntaxKind2[SyntaxKind2["NamespaceExport"] = 273] = "NamespaceExport";
      SyntaxKind2[SyntaxKind2["ExportSpecifier"] = 274] = "ExportSpecifier";
      SyntaxKind2[SyntaxKind2["MissingDeclaration"] = 275] = "MissingDeclaration";
      SyntaxKind2[SyntaxKind2["ExternalModuleReference"] = 276] = "ExternalModuleReference";
      SyntaxKind2[SyntaxKind2["JsxElement"] = 277] = "JsxElement";
      SyntaxKind2[SyntaxKind2["JsxSelfClosingElement"] = 278] = "JsxSelfClosingElement";
      SyntaxKind2[SyntaxKind2["JsxOpeningElement"] = 279] = "JsxOpeningElement";
      SyntaxKind2[SyntaxKind2["JsxClosingElement"] = 280] = "JsxClosingElement";
      SyntaxKind2[SyntaxKind2["JsxFragment"] = 281] = "JsxFragment";
      SyntaxKind2[SyntaxKind2["JsxOpeningFragment"] = 282] = "JsxOpeningFragment";
      SyntaxKind2[SyntaxKind2["JsxClosingFragment"] = 283] = "JsxClosingFragment";
      SyntaxKind2[SyntaxKind2["JsxAttribute"] = 284] = "JsxAttribute";
      SyntaxKind2[SyntaxKind2["JsxAttributes"] = 285] = "JsxAttributes";
      SyntaxKind2[SyntaxKind2["JsxSpreadAttribute"] = 286] = "JsxSpreadAttribute";
      SyntaxKind2[SyntaxKind2["JsxExpression"] = 287] = "JsxExpression";
      SyntaxKind2[SyntaxKind2["CaseClause"] = 288] = "CaseClause";
      SyntaxKind2[SyntaxKind2["DefaultClause"] = 289] = "DefaultClause";
      SyntaxKind2[SyntaxKind2["HeritageClause"] = 290] = "HeritageClause";
      SyntaxKind2[SyntaxKind2["CatchClause"] = 291] = "CatchClause";
      SyntaxKind2[SyntaxKind2["AssertClause"] = 292] = "AssertClause";
      SyntaxKind2[SyntaxKind2["AssertEntry"] = 293] = "AssertEntry";
      SyntaxKind2[SyntaxKind2["PropertyAssignment"] = 294] = "PropertyAssignment";
      SyntaxKind2[SyntaxKind2["ShorthandPropertyAssignment"] = 295] = "ShorthandPropertyAssignment";
      SyntaxKind2[SyntaxKind2["SpreadAssignment"] = 296] = "SpreadAssignment";
      SyntaxKind2[SyntaxKind2["EnumMember"] = 297] = "EnumMember";
      SyntaxKind2[SyntaxKind2["UnparsedPrologue"] = 298] = "UnparsedPrologue";
      SyntaxKind2[SyntaxKind2["UnparsedPrepend"] = 299] = "UnparsedPrepend";
      SyntaxKind2[SyntaxKind2["UnparsedText"] = 300] = "UnparsedText";
      SyntaxKind2[SyntaxKind2["UnparsedInternalText"] = 301] = "UnparsedInternalText";
      SyntaxKind2[SyntaxKind2["UnparsedSyntheticReference"] = 302] = "UnparsedSyntheticReference";
      SyntaxKind2[SyntaxKind2["SourceFile"] = 303] = "SourceFile";
      SyntaxKind2[SyntaxKind2["Bundle"] = 304] = "Bundle";
      SyntaxKind2[SyntaxKind2["UnparsedSource"] = 305] = "UnparsedSource";
      SyntaxKind2[SyntaxKind2["InputFiles"] = 306] = "InputFiles";
      SyntaxKind2[SyntaxKind2["JSDocTypeExpression"] = 307] = "JSDocTypeExpression";
      SyntaxKind2[SyntaxKind2["JSDocNameReference"] = 308] = "JSDocNameReference";
      SyntaxKind2[SyntaxKind2["JSDocMemberName"] = 309] = "JSDocMemberName";
      SyntaxKind2[SyntaxKind2["JSDocAllType"] = 310] = "JSDocAllType";
      SyntaxKind2[SyntaxKind2["JSDocUnknownType"] = 311] = "JSDocUnknownType";
      SyntaxKind2[SyntaxKind2["JSDocNullableType"] = 312] = "JSDocNullableType";
      SyntaxKind2[SyntaxKind2["JSDocNonNullableType"] = 313] = "JSDocNonNullableType";
      SyntaxKind2[SyntaxKind2["JSDocOptionalType"] = 314] = "JSDocOptionalType";
      SyntaxKind2[SyntaxKind2["JSDocFunctionType"] = 315] = "JSDocFunctionType";
      SyntaxKind2[SyntaxKind2["JSDocVariadicType"] = 316] = "JSDocVariadicType";
      SyntaxKind2[SyntaxKind2["JSDocNamepathType"] = 317] = "JSDocNamepathType";
      SyntaxKind2[SyntaxKind2["JSDocComment"] = 318] = "JSDocComment";
      SyntaxKind2[SyntaxKind2["JSDocText"] = 319] = "JSDocText";
      SyntaxKind2[SyntaxKind2["JSDocTypeLiteral"] = 320] = "JSDocTypeLiteral";
      SyntaxKind2[SyntaxKind2["JSDocSignature"] = 321] = "JSDocSignature";
      SyntaxKind2[SyntaxKind2["JSDocLink"] = 322] = "JSDocLink";
      SyntaxKind2[SyntaxKind2["JSDocLinkCode"] = 323] = "JSDocLinkCode";
      SyntaxKind2[SyntaxKind2["JSDocLinkPlain"] = 324] = "JSDocLinkPlain";
      SyntaxKind2[SyntaxKind2["JSDocTag"] = 325] = "JSDocTag";
      SyntaxKind2[SyntaxKind2["JSDocAugmentsTag"] = 326] = "JSDocAugmentsTag";
      SyntaxKind2[SyntaxKind2["JSDocImplementsTag"] = 327] = "JSDocImplementsTag";
      SyntaxKind2[SyntaxKind2["JSDocAuthorTag"] = 328] = "JSDocAuthorTag";
      SyntaxKind2[SyntaxKind2["JSDocDeprecatedTag"] = 329] = "JSDocDeprecatedTag";
      SyntaxKind2[SyntaxKind2["JSDocClassTag"] = 330] = "JSDocClassTag";
      SyntaxKind2[SyntaxKind2["JSDocPublicTag"] = 331] = "JSDocPublicTag";
      SyntaxKind2[SyntaxKind2["JSDocPrivateTag"] = 332] = "JSDocPrivateTag";
      SyntaxKind2[SyntaxKind2["JSDocProtectedTag"] = 333] = "JSDocProtectedTag";
      SyntaxKind2[SyntaxKind2["JSDocReadonlyTag"] = 334] = "JSDocReadonlyTag";
      SyntaxKind2[SyntaxKind2["JSDocOverrideTag"] = 335] = "JSDocOverrideTag";
      SyntaxKind2[SyntaxKind2["JSDocCallbackTag"] = 336] = "JSDocCallbackTag";
      SyntaxKind2[SyntaxKind2["JSDocEnumTag"] = 337] = "JSDocEnumTag";
      SyntaxKind2[SyntaxKind2["JSDocParameterTag"] = 338] = "JSDocParameterTag";
      SyntaxKind2[SyntaxKind2["JSDocReturnTag"] = 339] = "JSDocReturnTag";
      SyntaxKind2[SyntaxKind2["JSDocThisTag"] = 340] = "JSDocThisTag";
      SyntaxKind2[SyntaxKind2["JSDocTypeTag"] = 341] = "JSDocTypeTag";
      SyntaxKind2[SyntaxKind2["JSDocTemplateTag"] = 342] = "JSDocTemplateTag";
      SyntaxKind2[SyntaxKind2["JSDocTypedefTag"] = 343] = "JSDocTypedefTag";
      SyntaxKind2[SyntaxKind2["JSDocSeeTag"] = 344] = "JSDocSeeTag";
      SyntaxKind2[SyntaxKind2["JSDocPropertyTag"] = 345] = "JSDocPropertyTag";
      SyntaxKind2[SyntaxKind2["SyntaxList"] = 346] = "SyntaxList";
      SyntaxKind2[SyntaxKind2["NotEmittedStatement"] = 347] = "NotEmittedStatement";
      SyntaxKind2[SyntaxKind2["PartiallyEmittedExpression"] = 348] = "PartiallyEmittedExpression";
      SyntaxKind2[SyntaxKind2["CommaListExpression"] = 349] = "CommaListExpression";
      SyntaxKind2[SyntaxKind2["MergeDeclarationMarker"] = 350] = "MergeDeclarationMarker";
      SyntaxKind2[SyntaxKind2["EndOfDeclarationMarker"] = 351] = "EndOfDeclarationMarker";
      SyntaxKind2[SyntaxKind2["SyntheticReferenceExpression"] = 352] = "SyntheticReferenceExpression";
      SyntaxKind2[SyntaxKind2["Count"] = 353] = "Count";
      SyntaxKind2[SyntaxKind2["FirstAssignment"] = 63] = "FirstAssignment";
      SyntaxKind2[SyntaxKind2["LastAssignment"] = 78] = "LastAssignment";
      SyntaxKind2[SyntaxKind2["FirstCompoundAssignment"] = 64] = "FirstCompoundAssignment";
      SyntaxKind2[SyntaxKind2["LastCompoundAssignment"] = 78] = "LastCompoundAssignment";
      SyntaxKind2[SyntaxKind2["FirstReservedWord"] = 81] = "FirstReservedWord";
      SyntaxKind2[SyntaxKind2["LastReservedWord"] = 116] = "LastReservedWord";
      SyntaxKind2[SyntaxKind2["FirstKeyword"] = 81] = "FirstKeyword";
      SyntaxKind2[SyntaxKind2["LastKeyword"] = 159] = "LastKeyword";
      SyntaxKind2[SyntaxKind2["FirstFutureReservedWord"] = 117] = "FirstFutureReservedWord";
      SyntaxKind2[SyntaxKind2["LastFutureReservedWord"] = 125] = "LastFutureReservedWord";
      SyntaxKind2[SyntaxKind2["FirstTypeNode"] = 176] = "FirstTypeNode";
      SyntaxKind2[SyntaxKind2["LastTypeNode"] = 199] = "LastTypeNode";
      SyntaxKind2[SyntaxKind2["FirstPunctuation"] = 18] = "FirstPunctuation";
      SyntaxKind2[SyntaxKind2["LastPunctuation"] = 78] = "LastPunctuation";
      SyntaxKind2[SyntaxKind2["FirstToken"] = 0] = "FirstToken";
      SyntaxKind2[SyntaxKind2["LastToken"] = 159] = "LastToken";
      SyntaxKind2[SyntaxKind2["FirstTriviaToken"] = 2] = "FirstTriviaToken";
      SyntaxKind2[SyntaxKind2["LastTriviaToken"] = 7] = "LastTriviaToken";
      SyntaxKind2[SyntaxKind2["FirstLiteralToken"] = 8] = "FirstLiteralToken";
      SyntaxKind2[SyntaxKind2["LastLiteralToken"] = 14] = "LastLiteralToken";
      SyntaxKind2[SyntaxKind2["FirstTemplateToken"] = 14] = "FirstTemplateToken";
      SyntaxKind2[SyntaxKind2["LastTemplateToken"] = 17] = "LastTemplateToken";
      SyntaxKind2[SyntaxKind2["FirstBinaryOperator"] = 29] = "FirstBinaryOperator";
      SyntaxKind2[SyntaxKind2["LastBinaryOperator"] = 78] = "LastBinaryOperator";
      SyntaxKind2[SyntaxKind2["FirstStatement"] = 236] = "FirstStatement";
      SyntaxKind2[SyntaxKind2["LastStatement"] = 252] = "LastStatement";
      SyntaxKind2[SyntaxKind2["FirstNode"] = 160] = "FirstNode";
      SyntaxKind2[SyntaxKind2["FirstJSDocNode"] = 307] = "FirstJSDocNode";
      SyntaxKind2[SyntaxKind2["LastJSDocNode"] = 345] = "LastJSDocNode";
      SyntaxKind2[SyntaxKind2["FirstJSDocTagNode"] = 325] = "FirstJSDocTagNode";
      SyntaxKind2[SyntaxKind2["LastJSDocTagNode"] = 345] = "LastJSDocTagNode";
      SyntaxKind2[SyntaxKind2["FirstContextualKeyword"] = 126] = "FirstContextualKeyword";
      SyntaxKind2[SyntaxKind2["LastContextualKeyword"] = 159] = "LastContextualKeyword";
    })(SyntaxKind = ts2.SyntaxKind || (ts2.SyntaxKind = {}));
    var NodeFlags;
    (function(NodeFlags2) {
      NodeFlags2[NodeFlags2["None"] = 0] = "None";
      NodeFlags2[NodeFlags2["Let"] = 1] = "Let";
      NodeFlags2[NodeFlags2["Const"] = 2] = "Const";
      NodeFlags2[NodeFlags2["NestedNamespace"] = 4] = "NestedNamespace";
      NodeFlags2[NodeFlags2["Synthesized"] = 8] = "Synthesized";
      NodeFlags2[NodeFlags2["Namespace"] = 16] = "Namespace";
      NodeFlags2[NodeFlags2["OptionalChain"] = 32] = "OptionalChain";
      NodeFlags2[NodeFlags2["ExportContext"] = 64] = "ExportContext";
      NodeFlags2[NodeFlags2["ContainsThis"] = 128] = "ContainsThis";
      NodeFlags2[NodeFlags2["HasImplicitReturn"] = 256] = "HasImplicitReturn";
      NodeFlags2[NodeFlags2["HasExplicitReturn"] = 512] = "HasExplicitReturn";
      NodeFlags2[NodeFlags2["GlobalAugmentation"] = 1024] = "GlobalAugmentation";
      NodeFlags2[NodeFlags2["HasAsyncFunctions"] = 2048] = "HasAsyncFunctions";
      NodeFlags2[NodeFlags2["DisallowInContext"] = 4096] = "DisallowInContext";
      NodeFlags2[NodeFlags2["YieldContext"] = 8192] = "YieldContext";
      NodeFlags2[NodeFlags2["DecoratorContext"] = 16384] = "DecoratorContext";
      NodeFlags2[NodeFlags2["AwaitContext"] = 32768] = "AwaitContext";
      NodeFlags2[NodeFlags2["ThisNodeHasError"] = 65536] = "ThisNodeHasError";
      NodeFlags2[NodeFlags2["JavaScriptFile"] = 131072] = "JavaScriptFile";
      NodeFlags2[NodeFlags2["ThisNodeOrAnySubNodesHasError"] = 262144] = "ThisNodeOrAnySubNodesHasError";
      NodeFlags2[NodeFlags2["HasAggregatedChildData"] = 524288] = "HasAggregatedChildData";
      NodeFlags2[NodeFlags2["PossiblyContainsDynamicImport"] = 1048576] = "PossiblyContainsDynamicImport";
      NodeFlags2[NodeFlags2["PossiblyContainsImportMeta"] = 2097152] = "PossiblyContainsImportMeta";
      NodeFlags2[NodeFlags2["JSDoc"] = 4194304] = "JSDoc";
      NodeFlags2[NodeFlags2["Ambient"] = 8388608] = "Ambient";
      NodeFlags2[NodeFlags2["InWithStatement"] = 16777216] = "InWithStatement";
      NodeFlags2[NodeFlags2["JsonFile"] = 33554432] = "JsonFile";
      NodeFlags2[NodeFlags2["TypeCached"] = 67108864] = "TypeCached";
      NodeFlags2[NodeFlags2["Deprecated"] = 134217728] = "Deprecated";
      NodeFlags2[NodeFlags2["BlockScoped"] = 3] = "BlockScoped";
      NodeFlags2[NodeFlags2["ReachabilityCheckFlags"] = 768] = "ReachabilityCheckFlags";
      NodeFlags2[NodeFlags2["ReachabilityAndEmitFlags"] = 2816] = "ReachabilityAndEmitFlags";
      NodeFlags2[NodeFlags2["ContextFlags"] = 25358336] = "ContextFlags";
      NodeFlags2[NodeFlags2["TypeExcludesFlags"] = 40960] = "TypeExcludesFlags";
      NodeFlags2[NodeFlags2["PermanentlySetIncrementalFlags"] = 3145728] = "PermanentlySetIncrementalFlags";
    })(NodeFlags = ts2.NodeFlags || (ts2.NodeFlags = {}));
    var ModifierFlags;
    (function(ModifierFlags2) {
      ModifierFlags2[ModifierFlags2["None"] = 0] = "None";
      ModifierFlags2[ModifierFlags2["Export"] = 1] = "Export";
      ModifierFlags2[ModifierFlags2["Ambient"] = 2] = "Ambient";
      ModifierFlags2[ModifierFlags2["Public"] = 4] = "Public";
      ModifierFlags2[ModifierFlags2["Private"] = 8] = "Private";
      ModifierFlags2[ModifierFlags2["Protected"] = 16] = "Protected";
      ModifierFlags2[ModifierFlags2["Static"] = 32] = "Static";
      ModifierFlags2[ModifierFlags2["Readonly"] = 64] = "Readonly";
      ModifierFlags2[ModifierFlags2["Abstract"] = 128] = "Abstract";
      ModifierFlags2[ModifierFlags2["Async"] = 256] = "Async";
      ModifierFlags2[ModifierFlags2["Default"] = 512] = "Default";
      ModifierFlags2[ModifierFlags2["Const"] = 2048] = "Const";
      ModifierFlags2[ModifierFlags2["HasComputedJSDocModifiers"] = 4096] = "HasComputedJSDocModifiers";
      ModifierFlags2[ModifierFlags2["Deprecated"] = 8192] = "Deprecated";
      ModifierFlags2[ModifierFlags2["Override"] = 16384] = "Override";
      ModifierFlags2[ModifierFlags2["HasComputedFlags"] = 536870912] = "HasComputedFlags";
      ModifierFlags2[ModifierFlags2["AccessibilityModifier"] = 28] = "AccessibilityModifier";
      ModifierFlags2[ModifierFlags2["ParameterPropertyModifier"] = 16476] = "ParameterPropertyModifier";
      ModifierFlags2[ModifierFlags2["NonPublicAccessibilityModifier"] = 24] = "NonPublicAccessibilityModifier";
      ModifierFlags2[ModifierFlags2["TypeScriptModifier"] = 18654] = "TypeScriptModifier";
      ModifierFlags2[ModifierFlags2["ExportDefault"] = 513] = "ExportDefault";
      ModifierFlags2[ModifierFlags2["All"] = 27647] = "All";
    })(ModifierFlags = ts2.ModifierFlags || (ts2.ModifierFlags = {}));
    var JsxFlags;
    (function(JsxFlags2) {
      JsxFlags2[JsxFlags2["None"] = 0] = "None";
      JsxFlags2[JsxFlags2["IntrinsicNamedElement"] = 1] = "IntrinsicNamedElement";
      JsxFlags2[JsxFlags2["IntrinsicIndexedElement"] = 2] = "IntrinsicIndexedElement";
      JsxFlags2[JsxFlags2["IntrinsicElement"] = 3] = "IntrinsicElement";
    })(JsxFlags = ts2.JsxFlags || (ts2.JsxFlags = {}));
    var RelationComparisonResult;
    (function(RelationComparisonResult2) {
      RelationComparisonResult2[RelationComparisonResult2["Succeeded"] = 1] = "Succeeded";
      RelationComparisonResult2[RelationComparisonResult2["Failed"] = 2] = "Failed";
      RelationComparisonResult2[RelationComparisonResult2["Reported"] = 4] = "Reported";
      RelationComparisonResult2[RelationComparisonResult2["ReportsUnmeasurable"] = 8] = "ReportsUnmeasurable";
      RelationComparisonResult2[RelationComparisonResult2["ReportsUnreliable"] = 16] = "ReportsUnreliable";
      RelationComparisonResult2[RelationComparisonResult2["ReportsMask"] = 24] = "ReportsMask";
    })(RelationComparisonResult = ts2.RelationComparisonResult || (ts2.RelationComparisonResult = {}));
    var GeneratedIdentifierFlags;
    (function(GeneratedIdentifierFlags2) {
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["None"] = 0] = "None";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Auto"] = 1] = "Auto";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Loop"] = 2] = "Loop";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Unique"] = 3] = "Unique";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Node"] = 4] = "Node";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["KindMask"] = 7] = "KindMask";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["ReservedInNestedScopes"] = 8] = "ReservedInNestedScopes";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Optimistic"] = 16] = "Optimistic";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["FileLevel"] = 32] = "FileLevel";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["AllowNameSubstitution"] = 64] = "AllowNameSubstitution";
    })(GeneratedIdentifierFlags = ts2.GeneratedIdentifierFlags || (ts2.GeneratedIdentifierFlags = {}));
    var TokenFlags;
    (function(TokenFlags2) {
      TokenFlags2[TokenFlags2["None"] = 0] = "None";
      TokenFlags2[TokenFlags2["PrecedingLineBreak"] = 1] = "PrecedingLineBreak";
      TokenFlags2[TokenFlags2["PrecedingJSDocComment"] = 2] = "PrecedingJSDocComment";
      TokenFlags2[TokenFlags2["Unterminated"] = 4] = "Unterminated";
      TokenFlags2[TokenFlags2["ExtendedUnicodeEscape"] = 8] = "ExtendedUnicodeEscape";
      TokenFlags2[TokenFlags2["Scientific"] = 16] = "Scientific";
      TokenFlags2[TokenFlags2["Octal"] = 32] = "Octal";
      TokenFlags2[TokenFlags2["HexSpecifier"] = 64] = "HexSpecifier";
      TokenFlags2[TokenFlags2["BinarySpecifier"] = 128] = "BinarySpecifier";
      TokenFlags2[TokenFlags2["OctalSpecifier"] = 256] = "OctalSpecifier";
      TokenFlags2[TokenFlags2["ContainsSeparator"] = 512] = "ContainsSeparator";
      TokenFlags2[TokenFlags2["UnicodeEscape"] = 1024] = "UnicodeEscape";
      TokenFlags2[TokenFlags2["ContainsInvalidEscape"] = 2048] = "ContainsInvalidEscape";
      TokenFlags2[TokenFlags2["BinaryOrOctalSpecifier"] = 384] = "BinaryOrOctalSpecifier";
      TokenFlags2[TokenFlags2["NumericLiteralFlags"] = 1008] = "NumericLiteralFlags";
      TokenFlags2[TokenFlags2["TemplateLiteralLikeFlags"] = 2048] = "TemplateLiteralLikeFlags";
    })(TokenFlags = ts2.TokenFlags || (ts2.TokenFlags = {}));
    var FlowFlags;
    (function(FlowFlags2) {
      FlowFlags2[FlowFlags2["Unreachable"] = 1] = "Unreachable";
      FlowFlags2[FlowFlags2["Start"] = 2] = "Start";
      FlowFlags2[FlowFlags2["BranchLabel"] = 4] = "BranchLabel";
      FlowFlags2[FlowFlags2["LoopLabel"] = 8] = "LoopLabel";
      FlowFlags2[FlowFlags2["Assignment"] = 16] = "Assignment";
      FlowFlags2[FlowFlags2["TrueCondition"] = 32] = "TrueCondition";
      FlowFlags2[FlowFlags2["FalseCondition"] = 64] = "FalseCondition";
      FlowFlags2[FlowFlags2["SwitchClause"] = 128] = "SwitchClause";
      FlowFlags2[FlowFlags2["ArrayMutation"] = 256] = "ArrayMutation";
      FlowFlags2[FlowFlags2["Call"] = 512] = "Call";
      FlowFlags2[FlowFlags2["ReduceLabel"] = 1024] = "ReduceLabel";
      FlowFlags2[FlowFlags2["Referenced"] = 2048] = "Referenced";
      FlowFlags2[FlowFlags2["Shared"] = 4096] = "Shared";
      FlowFlags2[FlowFlags2["Label"] = 12] = "Label";
      FlowFlags2[FlowFlags2["Condition"] = 96] = "Condition";
    })(FlowFlags = ts2.FlowFlags || (ts2.FlowFlags = {}));
    var CommentDirectiveType;
    (function(CommentDirectiveType2) {
      CommentDirectiveType2[CommentDirectiveType2["ExpectError"] = 0] = "ExpectError";
      CommentDirectiveType2[CommentDirectiveType2["Ignore"] = 1] = "Ignore";
    })(CommentDirectiveType = ts2.CommentDirectiveType || (ts2.CommentDirectiveType = {}));
    var OperationCanceledException = function() {
      function OperationCanceledException2() {
      }
      return OperationCanceledException2;
    }();
    ts2.OperationCanceledException = OperationCanceledException;
    var FileIncludeKind;
    (function(FileIncludeKind2) {
      FileIncludeKind2[FileIncludeKind2["RootFile"] = 0] = "RootFile";
      FileIncludeKind2[FileIncludeKind2["SourceFromProjectReference"] = 1] = "SourceFromProjectReference";
      FileIncludeKind2[FileIncludeKind2["OutputFromProjectReference"] = 2] = "OutputFromProjectReference";
      FileIncludeKind2[FileIncludeKind2["Import"] = 3] = "Import";
      FileIncludeKind2[FileIncludeKind2["ReferenceFile"] = 4] = "ReferenceFile";
      FileIncludeKind2[FileIncludeKind2["TypeReferenceDirective"] = 5] = "TypeReferenceDirective";
      FileIncludeKind2[FileIncludeKind2["LibFile"] = 6] = "LibFile";
      FileIncludeKind2[FileIncludeKind2["LibReferenceDirective"] = 7] = "LibReferenceDirective";
      FileIncludeKind2[FileIncludeKind2["AutomaticTypeDirectiveFile"] = 8] = "AutomaticTypeDirectiveFile";
    })(FileIncludeKind = ts2.FileIncludeKind || (ts2.FileIncludeKind = {}));
    var FilePreprocessingDiagnosticsKind;
    (function(FilePreprocessingDiagnosticsKind2) {
      FilePreprocessingDiagnosticsKind2[FilePreprocessingDiagnosticsKind2["FilePreprocessingReferencedDiagnostic"] = 0] = "FilePreprocessingReferencedDiagnostic";
      FilePreprocessingDiagnosticsKind2[FilePreprocessingDiagnosticsKind2["FilePreprocessingFileExplainingDiagnostic"] = 1] = "FilePreprocessingFileExplainingDiagnostic";
    })(FilePreprocessingDiagnosticsKind = ts2.FilePreprocessingDiagnosticsKind || (ts2.FilePreprocessingDiagnosticsKind = {}));
    var StructureIsReused;
    (function(StructureIsReused2) {
      StructureIsReused2[StructureIsReused2["Not"] = 0] = "Not";
      StructureIsReused2[StructureIsReused2["SafeModules"] = 1] = "SafeModules";
      StructureIsReused2[StructureIsReused2["Completely"] = 2] = "Completely";
    })(StructureIsReused = ts2.StructureIsReused || (ts2.StructureIsReused = {}));
    var ExitStatus;
    (function(ExitStatus2) {
      ExitStatus2[ExitStatus2["Success"] = 0] = "Success";
      ExitStatus2[ExitStatus2["DiagnosticsPresent_OutputsSkipped"] = 1] = "DiagnosticsPresent_OutputsSkipped";
      ExitStatus2[ExitStatus2["DiagnosticsPresent_OutputsGenerated"] = 2] = "DiagnosticsPresent_OutputsGenerated";
      ExitStatus2[ExitStatus2["InvalidProject_OutputsSkipped"] = 3] = "InvalidProject_OutputsSkipped";
      ExitStatus2[ExitStatus2["ProjectReferenceCycle_OutputsSkipped"] = 4] = "ProjectReferenceCycle_OutputsSkipped";
      ExitStatus2[ExitStatus2["ProjectReferenceCycle_OutputsSkupped"] = 4] = "ProjectReferenceCycle_OutputsSkupped";
    })(ExitStatus = ts2.ExitStatus || (ts2.ExitStatus = {}));
    var MemberOverrideStatus;
    (function(MemberOverrideStatus2) {
      MemberOverrideStatus2[MemberOverrideStatus2["Ok"] = 0] = "Ok";
      MemberOverrideStatus2[MemberOverrideStatus2["NeedsOverride"] = 1] = "NeedsOverride";
      MemberOverrideStatus2[MemberOverrideStatus2["HasInvalidOverride"] = 2] = "HasInvalidOverride";
    })(MemberOverrideStatus = ts2.MemberOverrideStatus || (ts2.MemberOverrideStatus = {}));
    var UnionReduction;
    (function(UnionReduction2) {
      UnionReduction2[UnionReduction2["None"] = 0] = "None";
      UnionReduction2[UnionReduction2["Literal"] = 1] = "Literal";
      UnionReduction2[UnionReduction2["Subtype"] = 2] = "Subtype";
    })(UnionReduction = ts2.UnionReduction || (ts2.UnionReduction = {}));
    var ContextFlags;
    (function(ContextFlags2) {
      ContextFlags2[ContextFlags2["None"] = 0] = "None";
      ContextFlags2[ContextFlags2["Signature"] = 1] = "Signature";
      ContextFlags2[ContextFlags2["NoConstraints"] = 2] = "NoConstraints";
      ContextFlags2[ContextFlags2["Completions"] = 4] = "Completions";
      ContextFlags2[ContextFlags2["SkipBindingPatterns"] = 8] = "SkipBindingPatterns";
    })(ContextFlags = ts2.ContextFlags || (ts2.ContextFlags = {}));
    var NodeBuilderFlags;
    (function(NodeBuilderFlags2) {
      NodeBuilderFlags2[NodeBuilderFlags2["None"] = 0] = "None";
      NodeBuilderFlags2[NodeBuilderFlags2["NoTruncation"] = 1] = "NoTruncation";
      NodeBuilderFlags2[NodeBuilderFlags2["WriteArrayAsGenericType"] = 2] = "WriteArrayAsGenericType";
      NodeBuilderFlags2[NodeBuilderFlags2["GenerateNamesForShadowedTypeParams"] = 4] = "GenerateNamesForShadowedTypeParams";
      NodeBuilderFlags2[NodeBuilderFlags2["UseStructuralFallback"] = 8] = "UseStructuralFallback";
      NodeBuilderFlags2[NodeBuilderFlags2["ForbidIndexedAccessSymbolReferences"] = 16] = "ForbidIndexedAccessSymbolReferences";
      NodeBuilderFlags2[NodeBuilderFlags2["WriteTypeArgumentsOfSignature"] = 32] = "WriteTypeArgumentsOfSignature";
      NodeBuilderFlags2[NodeBuilderFlags2["UseFullyQualifiedType"] = 64] = "UseFullyQualifiedType";
      NodeBuilderFlags2[NodeBuilderFlags2["UseOnlyExternalAliasing"] = 128] = "UseOnlyExternalAliasing";
      NodeBuilderFlags2[NodeBuilderFlags2["SuppressAnyReturnType"] = 256] = "SuppressAnyReturnType";
      NodeBuilderFlags2[NodeBuilderFlags2["WriteTypeParametersInQualifiedName"] = 512] = "WriteTypeParametersInQualifiedName";
      NodeBuilderFlags2[NodeBuilderFlags2["MultilineObjectLiterals"] = 1024] = "MultilineObjectLiterals";
      NodeBuilderFlags2[NodeBuilderFlags2["WriteClassExpressionAsTypeLiteral"] = 2048] = "WriteClassExpressionAsTypeLiteral";
      NodeBuilderFlags2[NodeBuilderFlags2["UseTypeOfFunction"] = 4096] = "UseTypeOfFunction";
      NodeBuilderFlags2[NodeBuilderFlags2["OmitParameterModifiers"] = 8192] = "OmitParameterModifiers";
      NodeBuilderFlags2[NodeBuilderFlags2["UseAliasDefinedOutsideCurrentScope"] = 16384] = "UseAliasDefinedOutsideCurrentScope";
      NodeBuilderFlags2[NodeBuilderFlags2["UseSingleQuotesForStringLiteralType"] = 268435456] = "UseSingleQuotesForStringLiteralType";
      NodeBuilderFlags2[NodeBuilderFlags2["NoTypeReduction"] = 536870912] = "NoTypeReduction";
      NodeBuilderFlags2[NodeBuilderFlags2["NoUndefinedOptionalParameterType"] = 1073741824] = "NoUndefinedOptionalParameterType";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowThisInObjectLiteral"] = 32768] = "AllowThisInObjectLiteral";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowQualifiedNameInPlaceOfIdentifier"] = 65536] = "AllowQualifiedNameInPlaceOfIdentifier";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowQualifedNameInPlaceOfIdentifier"] = 65536] = "AllowQualifedNameInPlaceOfIdentifier";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowAnonymousIdentifier"] = 131072] = "AllowAnonymousIdentifier";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyUnionOrIntersection"] = 262144] = "AllowEmptyUnionOrIntersection";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyTuple"] = 524288] = "AllowEmptyTuple";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowUniqueESSymbolType"] = 1048576] = "AllowUniqueESSymbolType";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyIndexInfoType"] = 2097152] = "AllowEmptyIndexInfoType";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowNodeModulesRelativePaths"] = 67108864] = "AllowNodeModulesRelativePaths";
      NodeBuilderFlags2[NodeBuilderFlags2["DoNotIncludeSymbolChain"] = 134217728] = "DoNotIncludeSymbolChain";
      NodeBuilderFlags2[NodeBuilderFlags2["IgnoreErrors"] = 70221824] = "IgnoreErrors";
      NodeBuilderFlags2[NodeBuilderFlags2["InObjectTypeLiteral"] = 4194304] = "InObjectTypeLiteral";
      NodeBuilderFlags2[NodeBuilderFlags2["InTypeAlias"] = 8388608] = "InTypeAlias";
      NodeBuilderFlags2[NodeBuilderFlags2["InInitialEntityName"] = 16777216] = "InInitialEntityName";
    })(NodeBuilderFlags = ts2.NodeBuilderFlags || (ts2.NodeBuilderFlags = {}));
    var TypeFormatFlags;
    (function(TypeFormatFlags2) {
      TypeFormatFlags2[TypeFormatFlags2["None"] = 0] = "None";
      TypeFormatFlags2[TypeFormatFlags2["NoTruncation"] = 1] = "NoTruncation";
      TypeFormatFlags2[TypeFormatFlags2["WriteArrayAsGenericType"] = 2] = "WriteArrayAsGenericType";
      TypeFormatFlags2[TypeFormatFlags2["UseStructuralFallback"] = 8] = "UseStructuralFallback";
      TypeFormatFlags2[TypeFormatFlags2["WriteTypeArgumentsOfSignature"] = 32] = "WriteTypeArgumentsOfSignature";
      TypeFormatFlags2[TypeFormatFlags2["UseFullyQualifiedType"] = 64] = "UseFullyQualifiedType";
      TypeFormatFlags2[TypeFormatFlags2["SuppressAnyReturnType"] = 256] = "SuppressAnyReturnType";
      TypeFormatFlags2[TypeFormatFlags2["MultilineObjectLiterals"] = 1024] = "MultilineObjectLiterals";
      TypeFormatFlags2[TypeFormatFlags2["WriteClassExpressionAsTypeLiteral"] = 2048] = "WriteClassExpressionAsTypeLiteral";
      TypeFormatFlags2[TypeFormatFlags2["UseTypeOfFunction"] = 4096] = "UseTypeOfFunction";
      TypeFormatFlags2[TypeFormatFlags2["OmitParameterModifiers"] = 8192] = "OmitParameterModifiers";
      TypeFormatFlags2[TypeFormatFlags2["UseAliasDefinedOutsideCurrentScope"] = 16384] = "UseAliasDefinedOutsideCurrentScope";
      TypeFormatFlags2[TypeFormatFlags2["UseSingleQuotesForStringLiteralType"] = 268435456] = "UseSingleQuotesForStringLiteralType";
      TypeFormatFlags2[TypeFormatFlags2["NoTypeReduction"] = 536870912] = "NoTypeReduction";
      TypeFormatFlags2[TypeFormatFlags2["AllowUniqueESSymbolType"] = 1048576] = "AllowUniqueESSymbolType";
      TypeFormatFlags2[TypeFormatFlags2["AddUndefined"] = 131072] = "AddUndefined";
      TypeFormatFlags2[TypeFormatFlags2["WriteArrowStyleSignature"] = 262144] = "WriteArrowStyleSignature";
      TypeFormatFlags2[TypeFormatFlags2["InArrayType"] = 524288] = "InArrayType";
      TypeFormatFlags2[TypeFormatFlags2["InElementType"] = 2097152] = "InElementType";
      TypeFormatFlags2[TypeFormatFlags2["InFirstTypeArgument"] = 4194304] = "InFirstTypeArgument";
      TypeFormatFlags2[TypeFormatFlags2["InTypeAlias"] = 8388608] = "InTypeAlias";
      TypeFormatFlags2[TypeFormatFlags2["WriteOwnNameForAnyLike"] = 0] = "WriteOwnNameForAnyLike";
      TypeFormatFlags2[TypeFormatFlags2["NodeBuilderFlagsMask"] = 814775659] = "NodeBuilderFlagsMask";
    })(TypeFormatFlags = ts2.TypeFormatFlags || (ts2.TypeFormatFlags = {}));
    var SymbolFormatFlags;
    (function(SymbolFormatFlags2) {
      SymbolFormatFlags2[SymbolFormatFlags2["None"] = 0] = "None";
      SymbolFormatFlags2[SymbolFormatFlags2["WriteTypeParametersOrArguments"] = 1] = "WriteTypeParametersOrArguments";
      SymbolFormatFlags2[SymbolFormatFlags2["UseOnlyExternalAliasing"] = 2] = "UseOnlyExternalAliasing";
      SymbolFormatFlags2[SymbolFormatFlags2["AllowAnyNodeKind"] = 4] = "AllowAnyNodeKind";
      SymbolFormatFlags2[SymbolFormatFlags2["UseAliasDefinedOutsideCurrentScope"] = 8] = "UseAliasDefinedOutsideCurrentScope";
      SymbolFormatFlags2[SymbolFormatFlags2["DoNotIncludeSymbolChain"] = 16] = "DoNotIncludeSymbolChain";
    })(SymbolFormatFlags = ts2.SymbolFormatFlags || (ts2.SymbolFormatFlags = {}));
    var SymbolAccessibility;
    (function(SymbolAccessibility2) {
      SymbolAccessibility2[SymbolAccessibility2["Accessible"] = 0] = "Accessible";
      SymbolAccessibility2[SymbolAccessibility2["NotAccessible"] = 1] = "NotAccessible";
      SymbolAccessibility2[SymbolAccessibility2["CannotBeNamed"] = 2] = "CannotBeNamed";
    })(SymbolAccessibility = ts2.SymbolAccessibility || (ts2.SymbolAccessibility = {}));
    var SyntheticSymbolKind;
    (function(SyntheticSymbolKind2) {
      SyntheticSymbolKind2[SyntheticSymbolKind2["UnionOrIntersection"] = 0] = "UnionOrIntersection";
      SyntheticSymbolKind2[SyntheticSymbolKind2["Spread"] = 1] = "Spread";
    })(SyntheticSymbolKind = ts2.SyntheticSymbolKind || (ts2.SyntheticSymbolKind = {}));
    var TypePredicateKind;
    (function(TypePredicateKind2) {
      TypePredicateKind2[TypePredicateKind2["This"] = 0] = "This";
      TypePredicateKind2[TypePredicateKind2["Identifier"] = 1] = "Identifier";
      TypePredicateKind2[TypePredicateKind2["AssertsThis"] = 2] = "AssertsThis";
      TypePredicateKind2[TypePredicateKind2["AssertsIdentifier"] = 3] = "AssertsIdentifier";
    })(TypePredicateKind = ts2.TypePredicateKind || (ts2.TypePredicateKind = {}));
    var TypeReferenceSerializationKind;
    (function(TypeReferenceSerializationKind2) {
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["Unknown"] = 0] = "Unknown";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["TypeWithConstructSignatureAndValue"] = 1] = "TypeWithConstructSignatureAndValue";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["VoidNullableOrNeverType"] = 2] = "VoidNullableOrNeverType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["NumberLikeType"] = 3] = "NumberLikeType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["BigIntLikeType"] = 4] = "BigIntLikeType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["StringLikeType"] = 5] = "StringLikeType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["BooleanType"] = 6] = "BooleanType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ArrayLikeType"] = 7] = "ArrayLikeType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ESSymbolType"] = 8] = "ESSymbolType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["Promise"] = 9] = "Promise";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["TypeWithCallSignature"] = 10] = "TypeWithCallSignature";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ObjectType"] = 11] = "ObjectType";
    })(TypeReferenceSerializationKind = ts2.TypeReferenceSerializationKind || (ts2.TypeReferenceSerializationKind = {}));
    var SymbolFlags;
    (function(SymbolFlags2) {
      SymbolFlags2[SymbolFlags2["None"] = 0] = "None";
      SymbolFlags2[SymbolFlags2["FunctionScopedVariable"] = 1] = "FunctionScopedVariable";
      SymbolFlags2[SymbolFlags2["BlockScopedVariable"] = 2] = "BlockScopedVariable";
      SymbolFlags2[SymbolFlags2["Property"] = 4] = "Property";
      SymbolFlags2[SymbolFlags2["EnumMember"] = 8] = "EnumMember";
      SymbolFlags2[SymbolFlags2["Function"] = 16] = "Function";
      SymbolFlags2[SymbolFlags2["Class"] = 32] = "Class";
      SymbolFlags2[SymbolFlags2["Interface"] = 64] = "Interface";
      SymbolFlags2[SymbolFlags2["ConstEnum"] = 128] = "ConstEnum";
      SymbolFlags2[SymbolFlags2["RegularEnum"] = 256] = "RegularEnum";
      SymbolFlags2[SymbolFlags2["ValueModule"] = 512] = "ValueModule";
      SymbolFlags2[SymbolFlags2["NamespaceModule"] = 1024] = "NamespaceModule";
      SymbolFlags2[SymbolFlags2["TypeLiteral"] = 2048] = "TypeLiteral";
      SymbolFlags2[SymbolFlags2["ObjectLiteral"] = 4096] = "ObjectLiteral";
      SymbolFlags2[SymbolFlags2["Method"] = 8192] = "Method";
      SymbolFlags2[SymbolFlags2["Constructor"] = 16384] = "Constructor";
      SymbolFlags2[SymbolFlags2["GetAccessor"] = 32768] = "GetAccessor";
      SymbolFlags2[SymbolFlags2["SetAccessor"] = 65536] = "SetAccessor";
      SymbolFlags2[SymbolFlags2["Signature"] = 131072] = "Signature";
      SymbolFlags2[SymbolFlags2["TypeParameter"] = 262144] = "TypeParameter";
      SymbolFlags2[SymbolFlags2["TypeAlias"] = 524288] = "TypeAlias";
      SymbolFlags2[SymbolFlags2["ExportValue"] = 1048576] = "ExportValue";
      SymbolFlags2[SymbolFlags2["Alias"] = 2097152] = "Alias";
      SymbolFlags2[SymbolFlags2["Prototype"] = 4194304] = "Prototype";
      SymbolFlags2[SymbolFlags2["ExportStar"] = 8388608] = "ExportStar";
      SymbolFlags2[SymbolFlags2["Optional"] = 16777216] = "Optional";
      SymbolFlags2[SymbolFlags2["Transient"] = 33554432] = "Transient";
      SymbolFlags2[SymbolFlags2["Assignment"] = 67108864] = "Assignment";
      SymbolFlags2[SymbolFlags2["ModuleExports"] = 134217728] = "ModuleExports";
      SymbolFlags2[SymbolFlags2["All"] = 67108863] = "All";
      SymbolFlags2[SymbolFlags2["Enum"] = 384] = "Enum";
      SymbolFlags2[SymbolFlags2["Variable"] = 3] = "Variable";
      SymbolFlags2[SymbolFlags2["Value"] = 111551] = "Value";
      SymbolFlags2[SymbolFlags2["Type"] = 788968] = "Type";
      SymbolFlags2[SymbolFlags2["Namespace"] = 1920] = "Namespace";
      SymbolFlags2[SymbolFlags2["Module"] = 1536] = "Module";
      SymbolFlags2[SymbolFlags2["Accessor"] = 98304] = "Accessor";
      SymbolFlags2[SymbolFlags2["FunctionScopedVariableExcludes"] = 111550] = "FunctionScopedVariableExcludes";
      SymbolFlags2[SymbolFlags2["BlockScopedVariableExcludes"] = 111551] = "BlockScopedVariableExcludes";
      SymbolFlags2[SymbolFlags2["ParameterExcludes"] = 111551] = "ParameterExcludes";
      SymbolFlags2[SymbolFlags2["PropertyExcludes"] = 0] = "PropertyExcludes";
      SymbolFlags2[SymbolFlags2["EnumMemberExcludes"] = 900095] = "EnumMemberExcludes";
      SymbolFlags2[SymbolFlags2["FunctionExcludes"] = 110991] = "FunctionExcludes";
      SymbolFlags2[SymbolFlags2["ClassExcludes"] = 899503] = "ClassExcludes";
      SymbolFlags2[SymbolFlags2["InterfaceExcludes"] = 788872] = "InterfaceExcludes";
      SymbolFlags2[SymbolFlags2["RegularEnumExcludes"] = 899327] = "RegularEnumExcludes";
      SymbolFlags2[SymbolFlags2["ConstEnumExcludes"] = 899967] = "ConstEnumExcludes";
      SymbolFlags2[SymbolFlags2["ValueModuleExcludes"] = 110735] = "ValueModuleExcludes";
      SymbolFlags2[SymbolFlags2["NamespaceModuleExcludes"] = 0] = "NamespaceModuleExcludes";
      SymbolFlags2[SymbolFlags2["MethodExcludes"] = 103359] = "MethodExcludes";
      SymbolFlags2[SymbolFlags2["GetAccessorExcludes"] = 46015] = "GetAccessorExcludes";
      SymbolFlags2[SymbolFlags2["SetAccessorExcludes"] = 78783] = "SetAccessorExcludes";
      SymbolFlags2[SymbolFlags2["TypeParameterExcludes"] = 526824] = "TypeParameterExcludes";
      SymbolFlags2[SymbolFlags2["TypeAliasExcludes"] = 788968] = "TypeAliasExcludes";
      SymbolFlags2[SymbolFlags2["AliasExcludes"] = 2097152] = "AliasExcludes";
      SymbolFlags2[SymbolFlags2["ModuleMember"] = 2623475] = "ModuleMember";
      SymbolFlags2[SymbolFlags2["ExportHasLocal"] = 944] = "ExportHasLocal";
      SymbolFlags2[SymbolFlags2["BlockScoped"] = 418] = "BlockScoped";
      SymbolFlags2[SymbolFlags2["PropertyOrAccessor"] = 98308] = "PropertyOrAccessor";
      SymbolFlags2[SymbolFlags2["ClassMember"] = 106500] = "ClassMember";
      SymbolFlags2[SymbolFlags2["ExportSupportsDefaultModifier"] = 112] = "ExportSupportsDefaultModifier";
      SymbolFlags2[SymbolFlags2["ExportDoesNotSupportDefaultModifier"] = -113] = "ExportDoesNotSupportDefaultModifier";
      SymbolFlags2[SymbolFlags2["Classifiable"] = 2885600] = "Classifiable";
      SymbolFlags2[SymbolFlags2["LateBindingContainer"] = 6256] = "LateBindingContainer";
    })(SymbolFlags = ts2.SymbolFlags || (ts2.SymbolFlags = {}));
    var EnumKind;
    (function(EnumKind2) {
      EnumKind2[EnumKind2["Numeric"] = 0] = "Numeric";
      EnumKind2[EnumKind2["Literal"] = 1] = "Literal";
    })(EnumKind = ts2.EnumKind || (ts2.EnumKind = {}));
    var CheckFlags;
    (function(CheckFlags2) {
      CheckFlags2[CheckFlags2["Instantiated"] = 1] = "Instantiated";
      CheckFlags2[CheckFlags2["SyntheticProperty"] = 2] = "SyntheticProperty";
      CheckFlags2[CheckFlags2["SyntheticMethod"] = 4] = "SyntheticMethod";
      CheckFlags2[CheckFlags2["Readonly"] = 8] = "Readonly";
      CheckFlags2[CheckFlags2["ReadPartial"] = 16] = "ReadPartial";
      CheckFlags2[CheckFlags2["WritePartial"] = 32] = "WritePartial";
      CheckFlags2[CheckFlags2["HasNonUniformType"] = 64] = "HasNonUniformType";
      CheckFlags2[CheckFlags2["HasLiteralType"] = 128] = "HasLiteralType";
      CheckFlags2[CheckFlags2["ContainsPublic"] = 256] = "ContainsPublic";
      CheckFlags2[CheckFlags2["ContainsProtected"] = 512] = "ContainsProtected";
      CheckFlags2[CheckFlags2["ContainsPrivate"] = 1024] = "ContainsPrivate";
      CheckFlags2[CheckFlags2["ContainsStatic"] = 2048] = "ContainsStatic";
      CheckFlags2[CheckFlags2["Late"] = 4096] = "Late";
      CheckFlags2[CheckFlags2["ReverseMapped"] = 8192] = "ReverseMapped";
      CheckFlags2[CheckFlags2["OptionalParameter"] = 16384] = "OptionalParameter";
      CheckFlags2[CheckFlags2["RestParameter"] = 32768] = "RestParameter";
      CheckFlags2[CheckFlags2["DeferredType"] = 65536] = "DeferredType";
      CheckFlags2[CheckFlags2["HasNeverType"] = 131072] = "HasNeverType";
      CheckFlags2[CheckFlags2["Mapped"] = 262144] = "Mapped";
      CheckFlags2[CheckFlags2["StripOptional"] = 524288] = "StripOptional";
      CheckFlags2[CheckFlags2["Unresolved"] = 1048576] = "Unresolved";
      CheckFlags2[CheckFlags2["Synthetic"] = 6] = "Synthetic";
      CheckFlags2[CheckFlags2["Discriminant"] = 192] = "Discriminant";
      CheckFlags2[CheckFlags2["Partial"] = 48] = "Partial";
    })(CheckFlags = ts2.CheckFlags || (ts2.CheckFlags = {}));
    var InternalSymbolName;
    (function(InternalSymbolName2) {
      InternalSymbolName2["Call"] = "__call";
      InternalSymbolName2["Constructor"] = "__constructor";
      InternalSymbolName2["New"] = "__new";
      InternalSymbolName2["Index"] = "__index";
      InternalSymbolName2["ExportStar"] = "__export";
      InternalSymbolName2["Global"] = "__global";
      InternalSymbolName2["Missing"] = "__missing";
      InternalSymbolName2["Type"] = "__type";
      InternalSymbolName2["Object"] = "__object";
      InternalSymbolName2["JSXAttributes"] = "__jsxAttributes";
      InternalSymbolName2["Class"] = "__class";
      InternalSymbolName2["Function"] = "__function";
      InternalSymbolName2["Computed"] = "__computed";
      InternalSymbolName2["Resolving"] = "__resolving__";
      InternalSymbolName2["ExportEquals"] = "export=";
      InternalSymbolName2["Default"] = "default";
      InternalSymbolName2["This"] = "this";
    })(InternalSymbolName = ts2.InternalSymbolName || (ts2.InternalSymbolName = {}));
    var NodeCheckFlags;
    (function(NodeCheckFlags2) {
      NodeCheckFlags2[NodeCheckFlags2["TypeChecked"] = 1] = "TypeChecked";
      NodeCheckFlags2[NodeCheckFlags2["LexicalThis"] = 2] = "LexicalThis";
      NodeCheckFlags2[NodeCheckFlags2["CaptureThis"] = 4] = "CaptureThis";
      NodeCheckFlags2[NodeCheckFlags2["CaptureNewTarget"] = 8] = "CaptureNewTarget";
      NodeCheckFlags2[NodeCheckFlags2["SuperInstance"] = 256] = "SuperInstance";
      NodeCheckFlags2[NodeCheckFlags2["SuperStatic"] = 512] = "SuperStatic";
      NodeCheckFlags2[NodeCheckFlags2["ContextChecked"] = 1024] = "ContextChecked";
      NodeCheckFlags2[NodeCheckFlags2["AsyncMethodWithSuper"] = 2048] = "AsyncMethodWithSuper";
      NodeCheckFlags2[NodeCheckFlags2["AsyncMethodWithSuperBinding"] = 4096] = "AsyncMethodWithSuperBinding";
      NodeCheckFlags2[NodeCheckFlags2["CaptureArguments"] = 8192] = "CaptureArguments";
      NodeCheckFlags2[NodeCheckFlags2["EnumValuesComputed"] = 16384] = "EnumValuesComputed";
      NodeCheckFlags2[NodeCheckFlags2["LexicalModuleMergesWithClass"] = 32768] = "LexicalModuleMergesWithClass";
      NodeCheckFlags2[NodeCheckFlags2["LoopWithCapturedBlockScopedBinding"] = 65536] = "LoopWithCapturedBlockScopedBinding";
      NodeCheckFlags2[NodeCheckFlags2["ContainsCapturedBlockScopeBinding"] = 131072] = "ContainsCapturedBlockScopeBinding";
      NodeCheckFlags2[NodeCheckFlags2["CapturedBlockScopedBinding"] = 262144] = "CapturedBlockScopedBinding";
      NodeCheckFlags2[NodeCheckFlags2["BlockScopedBindingInLoop"] = 524288] = "BlockScopedBindingInLoop";
      NodeCheckFlags2[NodeCheckFlags2["ClassWithBodyScopedClassBinding"] = 1048576] = "ClassWithBodyScopedClassBinding";
      NodeCheckFlags2[NodeCheckFlags2["BodyScopedClassBinding"] = 2097152] = "BodyScopedClassBinding";
      NodeCheckFlags2[NodeCheckFlags2["NeedsLoopOutParameter"] = 4194304] = "NeedsLoopOutParameter";
      NodeCheckFlags2[NodeCheckFlags2["AssignmentsMarked"] = 8388608] = "AssignmentsMarked";
      NodeCheckFlags2[NodeCheckFlags2["ClassWithConstructorReference"] = 16777216] = "ClassWithConstructorReference";
      NodeCheckFlags2[NodeCheckFlags2["ConstructorReferenceInClass"] = 33554432] = "ConstructorReferenceInClass";
      NodeCheckFlags2[NodeCheckFlags2["ContainsClassWithPrivateIdentifiers"] = 67108864] = "ContainsClassWithPrivateIdentifiers";
      NodeCheckFlags2[NodeCheckFlags2["ContainsSuperPropertyInStaticInitializer"] = 134217728] = "ContainsSuperPropertyInStaticInitializer";
    })(NodeCheckFlags = ts2.NodeCheckFlags || (ts2.NodeCheckFlags = {}));
    var TypeFlags;
    (function(TypeFlags2) {
      TypeFlags2[TypeFlags2["Any"] = 1] = "Any";
      TypeFlags2[TypeFlags2["Unknown"] = 2] = "Unknown";
      TypeFlags2[TypeFlags2["String"] = 4] = "String";
      TypeFlags2[TypeFlags2["Number"] = 8] = "Number";
      TypeFlags2[TypeFlags2["Boolean"] = 16] = "Boolean";
      TypeFlags2[TypeFlags2["Enum"] = 32] = "Enum";
      TypeFlags2[TypeFlags2["BigInt"] = 64] = "BigInt";
      TypeFlags2[TypeFlags2["StringLiteral"] = 128] = "StringLiteral";
      TypeFlags2[TypeFlags2["NumberLiteral"] = 256] = "NumberLiteral";
      TypeFlags2[TypeFlags2["BooleanLiteral"] = 512] = "BooleanLiteral";
      TypeFlags2[TypeFlags2["EnumLiteral"] = 1024] = "EnumLiteral";
      TypeFlags2[TypeFlags2["BigIntLiteral"] = 2048] = "BigIntLiteral";
      TypeFlags2[TypeFlags2["ESSymbol"] = 4096] = "ESSymbol";
      TypeFlags2[TypeFlags2["UniqueESSymbol"] = 8192] = "UniqueESSymbol";
      TypeFlags2[TypeFlags2["Void"] = 16384] = "Void";
      TypeFlags2[TypeFlags2["Undefined"] = 32768] = "Undefined";
      TypeFlags2[TypeFlags2["Null"] = 65536] = "Null";
      TypeFlags2[TypeFlags2["Never"] = 131072] = "Never";
      TypeFlags2[TypeFlags2["TypeParameter"] = 262144] = "TypeParameter";
      TypeFlags2[TypeFlags2["Object"] = 524288] = "Object";
      TypeFlags2[TypeFlags2["Union"] = 1048576] = "Union";
      TypeFlags2[TypeFlags2["Intersection"] = 2097152] = "Intersection";
      TypeFlags2[TypeFlags2["Index"] = 4194304] = "Index";
      TypeFlags2[TypeFlags2["IndexedAccess"] = 8388608] = "IndexedAccess";
      TypeFlags2[TypeFlags2["Conditional"] = 16777216] = "Conditional";
      TypeFlags2[TypeFlags2["Substitution"] = 33554432] = "Substitution";
      TypeFlags2[TypeFlags2["NonPrimitive"] = 67108864] = "NonPrimitive";
      TypeFlags2[TypeFlags2["TemplateLiteral"] = 134217728] = "TemplateLiteral";
      TypeFlags2[TypeFlags2["StringMapping"] = 268435456] = "StringMapping";
      TypeFlags2[TypeFlags2["AnyOrUnknown"] = 3] = "AnyOrUnknown";
      TypeFlags2[TypeFlags2["Nullable"] = 98304] = "Nullable";
      TypeFlags2[TypeFlags2["Literal"] = 2944] = "Literal";
      TypeFlags2[TypeFlags2["Unit"] = 109440] = "Unit";
      TypeFlags2[TypeFlags2["StringOrNumberLiteral"] = 384] = "StringOrNumberLiteral";
      TypeFlags2[TypeFlags2["StringOrNumberLiteralOrUnique"] = 8576] = "StringOrNumberLiteralOrUnique";
      TypeFlags2[TypeFlags2["DefinitelyFalsy"] = 117632] = "DefinitelyFalsy";
      TypeFlags2[TypeFlags2["PossiblyFalsy"] = 117724] = "PossiblyFalsy";
      TypeFlags2[TypeFlags2["Intrinsic"] = 67359327] = "Intrinsic";
      TypeFlags2[TypeFlags2["Primitive"] = 131068] = "Primitive";
      TypeFlags2[TypeFlags2["StringLike"] = 402653316] = "StringLike";
      TypeFlags2[TypeFlags2["NumberLike"] = 296] = "NumberLike";
      TypeFlags2[TypeFlags2["BigIntLike"] = 2112] = "BigIntLike";
      TypeFlags2[TypeFlags2["BooleanLike"] = 528] = "BooleanLike";
      TypeFlags2[TypeFlags2["EnumLike"] = 1056] = "EnumLike";
      TypeFlags2[TypeFlags2["ESSymbolLike"] = 12288] = "ESSymbolLike";
      TypeFlags2[TypeFlags2["VoidLike"] = 49152] = "VoidLike";
      TypeFlags2[TypeFlags2["DisjointDomains"] = 469892092] = "DisjointDomains";
      TypeFlags2[TypeFlags2["UnionOrIntersection"] = 3145728] = "UnionOrIntersection";
      TypeFlags2[TypeFlags2["StructuredType"] = 3670016] = "StructuredType";
      TypeFlags2[TypeFlags2["TypeVariable"] = 8650752] = "TypeVariable";
      TypeFlags2[TypeFlags2["InstantiableNonPrimitive"] = 58982400] = "InstantiableNonPrimitive";
      TypeFlags2[TypeFlags2["InstantiablePrimitive"] = 406847488] = "InstantiablePrimitive";
      TypeFlags2[TypeFlags2["Instantiable"] = 465829888] = "Instantiable";
      TypeFlags2[TypeFlags2["StructuredOrInstantiable"] = 469499904] = "StructuredOrInstantiable";
      TypeFlags2[TypeFlags2["ObjectFlagsType"] = 3899393] = "ObjectFlagsType";
      TypeFlags2[TypeFlags2["Simplifiable"] = 25165824] = "Simplifiable";
      TypeFlags2[TypeFlags2["Singleton"] = 67358815] = "Singleton";
      TypeFlags2[TypeFlags2["Narrowable"] = 536624127] = "Narrowable";
      TypeFlags2[TypeFlags2["IncludesMask"] = 205258751] = "IncludesMask";
      TypeFlags2[TypeFlags2["IncludesMissingType"] = 262144] = "IncludesMissingType";
      TypeFlags2[TypeFlags2["IncludesNonWideningType"] = 4194304] = "IncludesNonWideningType";
      TypeFlags2[TypeFlags2["IncludesWildcard"] = 8388608] = "IncludesWildcard";
      TypeFlags2[TypeFlags2["IncludesEmptyObject"] = 16777216] = "IncludesEmptyObject";
      TypeFlags2[TypeFlags2["IncludesInstantiable"] = 33554432] = "IncludesInstantiable";
      TypeFlags2[TypeFlags2["NotPrimitiveUnion"] = 36323363] = "NotPrimitiveUnion";
    })(TypeFlags = ts2.TypeFlags || (ts2.TypeFlags = {}));
    var ObjectFlags;
    (function(ObjectFlags2) {
      ObjectFlags2[ObjectFlags2["Class"] = 1] = "Class";
      ObjectFlags2[ObjectFlags2["Interface"] = 2] = "Interface";
      ObjectFlags2[ObjectFlags2["Reference"] = 4] = "Reference";
      ObjectFlags2[ObjectFlags2["Tuple"] = 8] = "Tuple";
      ObjectFlags2[ObjectFlags2["Anonymous"] = 16] = "Anonymous";
      ObjectFlags2[ObjectFlags2["Mapped"] = 32] = "Mapped";
      ObjectFlags2[ObjectFlags2["Instantiated"] = 64] = "Instantiated";
      ObjectFlags2[ObjectFlags2["ObjectLiteral"] = 128] = "ObjectLiteral";
      ObjectFlags2[ObjectFlags2["EvolvingArray"] = 256] = "EvolvingArray";
      ObjectFlags2[ObjectFlags2["ObjectLiteralPatternWithComputedProperties"] = 512] = "ObjectLiteralPatternWithComputedProperties";
      ObjectFlags2[ObjectFlags2["ReverseMapped"] = 1024] = "ReverseMapped";
      ObjectFlags2[ObjectFlags2["JsxAttributes"] = 2048] = "JsxAttributes";
      ObjectFlags2[ObjectFlags2["MarkerType"] = 4096] = "MarkerType";
      ObjectFlags2[ObjectFlags2["JSLiteral"] = 8192] = "JSLiteral";
      ObjectFlags2[ObjectFlags2["FreshLiteral"] = 16384] = "FreshLiteral";
      ObjectFlags2[ObjectFlags2["ArrayLiteral"] = 32768] = "ArrayLiteral";
      ObjectFlags2[ObjectFlags2["PrimitiveUnion"] = 65536] = "PrimitiveUnion";
      ObjectFlags2[ObjectFlags2["ContainsWideningType"] = 131072] = "ContainsWideningType";
      ObjectFlags2[ObjectFlags2["ContainsObjectOrArrayLiteral"] = 262144] = "ContainsObjectOrArrayLiteral";
      ObjectFlags2[ObjectFlags2["NonInferrableType"] = 524288] = "NonInferrableType";
      ObjectFlags2[ObjectFlags2["CouldContainTypeVariablesComputed"] = 1048576] = "CouldContainTypeVariablesComputed";
      ObjectFlags2[ObjectFlags2["CouldContainTypeVariables"] = 2097152] = "CouldContainTypeVariables";
      ObjectFlags2[ObjectFlags2["ClassOrInterface"] = 3] = "ClassOrInterface";
      ObjectFlags2[ObjectFlags2["RequiresWidening"] = 393216] = "RequiresWidening";
      ObjectFlags2[ObjectFlags2["PropagatingFlags"] = 917504] = "PropagatingFlags";
      ObjectFlags2[ObjectFlags2["ObjectTypeKindMask"] = 1343] = "ObjectTypeKindMask";
      ObjectFlags2[ObjectFlags2["ContainsSpread"] = 4194304] = "ContainsSpread";
      ObjectFlags2[ObjectFlags2["ObjectRestType"] = 8388608] = "ObjectRestType";
      ObjectFlags2[ObjectFlags2["IsClassInstanceClone"] = 16777216] = "IsClassInstanceClone";
      ObjectFlags2[ObjectFlags2["IdenticalBaseTypeCalculated"] = 33554432] = "IdenticalBaseTypeCalculated";
      ObjectFlags2[ObjectFlags2["IdenticalBaseTypeExists"] = 67108864] = "IdenticalBaseTypeExists";
      ObjectFlags2[ObjectFlags2["IsGenericTypeComputed"] = 4194304] = "IsGenericTypeComputed";
      ObjectFlags2[ObjectFlags2["IsGenericObjectType"] = 8388608] = "IsGenericObjectType";
      ObjectFlags2[ObjectFlags2["IsGenericIndexType"] = 16777216] = "IsGenericIndexType";
      ObjectFlags2[ObjectFlags2["IsGenericType"] = 25165824] = "IsGenericType";
      ObjectFlags2[ObjectFlags2["ContainsIntersections"] = 33554432] = "ContainsIntersections";
      ObjectFlags2[ObjectFlags2["IsNeverIntersectionComputed"] = 33554432] = "IsNeverIntersectionComputed";
      ObjectFlags2[ObjectFlags2["IsNeverIntersection"] = 67108864] = "IsNeverIntersection";
    })(ObjectFlags = ts2.ObjectFlags || (ts2.ObjectFlags = {}));
    var VarianceFlags;
    (function(VarianceFlags2) {
      VarianceFlags2[VarianceFlags2["Invariant"] = 0] = "Invariant";
      VarianceFlags2[VarianceFlags2["Covariant"] = 1] = "Covariant";
      VarianceFlags2[VarianceFlags2["Contravariant"] = 2] = "Contravariant";
      VarianceFlags2[VarianceFlags2["Bivariant"] = 3] = "Bivariant";
      VarianceFlags2[VarianceFlags2["Independent"] = 4] = "Independent";
      VarianceFlags2[VarianceFlags2["VarianceMask"] = 7] = "VarianceMask";
      VarianceFlags2[VarianceFlags2["Unmeasurable"] = 8] = "Unmeasurable";
      VarianceFlags2[VarianceFlags2["Unreliable"] = 16] = "Unreliable";
      VarianceFlags2[VarianceFlags2["AllowsStructuralFallback"] = 24] = "AllowsStructuralFallback";
    })(VarianceFlags = ts2.VarianceFlags || (ts2.VarianceFlags = {}));
    var ElementFlags;
    (function(ElementFlags2) {
      ElementFlags2[ElementFlags2["Required"] = 1] = "Required";
      ElementFlags2[ElementFlags2["Optional"] = 2] = "Optional";
      ElementFlags2[ElementFlags2["Rest"] = 4] = "Rest";
      ElementFlags2[ElementFlags2["Variadic"] = 8] = "Variadic";
      ElementFlags2[ElementFlags2["Fixed"] = 3] = "Fixed";
      ElementFlags2[ElementFlags2["Variable"] = 12] = "Variable";
      ElementFlags2[ElementFlags2["NonRequired"] = 14] = "NonRequired";
      ElementFlags2[ElementFlags2["NonRest"] = 11] = "NonRest";
    })(ElementFlags = ts2.ElementFlags || (ts2.ElementFlags = {}));
    var AccessFlags;
    (function(AccessFlags2) {
      AccessFlags2[AccessFlags2["None"] = 0] = "None";
      AccessFlags2[AccessFlags2["IncludeUndefined"] = 1] = "IncludeUndefined";
      AccessFlags2[AccessFlags2["NoIndexSignatures"] = 2] = "NoIndexSignatures";
      AccessFlags2[AccessFlags2["Writing"] = 4] = "Writing";
      AccessFlags2[AccessFlags2["CacheSymbol"] = 8] = "CacheSymbol";
      AccessFlags2[AccessFlags2["NoTupleBoundsCheck"] = 16] = "NoTupleBoundsCheck";
      AccessFlags2[AccessFlags2["ExpressionPosition"] = 32] = "ExpressionPosition";
      AccessFlags2[AccessFlags2["ReportDeprecated"] = 64] = "ReportDeprecated";
      AccessFlags2[AccessFlags2["SuppressNoImplicitAnyError"] = 128] = "SuppressNoImplicitAnyError";
      AccessFlags2[AccessFlags2["Contextual"] = 256] = "Contextual";
      AccessFlags2[AccessFlags2["Persistent"] = 1] = "Persistent";
    })(AccessFlags = ts2.AccessFlags || (ts2.AccessFlags = {}));
    var JsxReferenceKind;
    (function(JsxReferenceKind2) {
      JsxReferenceKind2[JsxReferenceKind2["Component"] = 0] = "Component";
      JsxReferenceKind2[JsxReferenceKind2["Function"] = 1] = "Function";
      JsxReferenceKind2[JsxReferenceKind2["Mixed"] = 2] = "Mixed";
    })(JsxReferenceKind = ts2.JsxReferenceKind || (ts2.JsxReferenceKind = {}));
    var SignatureKind;
    (function(SignatureKind2) {
      SignatureKind2[SignatureKind2["Call"] = 0] = "Call";
      SignatureKind2[SignatureKind2["Construct"] = 1] = "Construct";
    })(SignatureKind = ts2.SignatureKind || (ts2.SignatureKind = {}));
    var SignatureFlags;
    (function(SignatureFlags2) {
      SignatureFlags2[SignatureFlags2["None"] = 0] = "None";
      SignatureFlags2[SignatureFlags2["HasRestParameter"] = 1] = "HasRestParameter";
      SignatureFlags2[SignatureFlags2["HasLiteralTypes"] = 2] = "HasLiteralTypes";
      SignatureFlags2[SignatureFlags2["Abstract"] = 4] = "Abstract";
      SignatureFlags2[SignatureFlags2["IsInnerCallChain"] = 8] = "IsInnerCallChain";
      SignatureFlags2[SignatureFlags2["IsOuterCallChain"] = 16] = "IsOuterCallChain";
      SignatureFlags2[SignatureFlags2["IsUntypedSignatureInJSFile"] = 32] = "IsUntypedSignatureInJSFile";
      SignatureFlags2[SignatureFlags2["PropagatingFlags"] = 39] = "PropagatingFlags";
      SignatureFlags2[SignatureFlags2["CallChainFlags"] = 24] = "CallChainFlags";
    })(SignatureFlags = ts2.SignatureFlags || (ts2.SignatureFlags = {}));
    var IndexKind;
    (function(IndexKind2) {
      IndexKind2[IndexKind2["String"] = 0] = "String";
      IndexKind2[IndexKind2["Number"] = 1] = "Number";
    })(IndexKind = ts2.IndexKind || (ts2.IndexKind = {}));
    var TypeMapKind;
    (function(TypeMapKind2) {
      TypeMapKind2[TypeMapKind2["Simple"] = 0] = "Simple";
      TypeMapKind2[TypeMapKind2["Array"] = 1] = "Array";
      TypeMapKind2[TypeMapKind2["Function"] = 2] = "Function";
      TypeMapKind2[TypeMapKind2["Composite"] = 3] = "Composite";
      TypeMapKind2[TypeMapKind2["Merged"] = 4] = "Merged";
    })(TypeMapKind = ts2.TypeMapKind || (ts2.TypeMapKind = {}));
    var InferencePriority;
    (function(InferencePriority2) {
      InferencePriority2[InferencePriority2["NakedTypeVariable"] = 1] = "NakedTypeVariable";
      InferencePriority2[InferencePriority2["SpeculativeTuple"] = 2] = "SpeculativeTuple";
      InferencePriority2[InferencePriority2["SubstituteSource"] = 4] = "SubstituteSource";
      InferencePriority2[InferencePriority2["HomomorphicMappedType"] = 8] = "HomomorphicMappedType";
      InferencePriority2[InferencePriority2["PartialHomomorphicMappedType"] = 16] = "PartialHomomorphicMappedType";
      InferencePriority2[InferencePriority2["MappedTypeConstraint"] = 32] = "MappedTypeConstraint";
      InferencePriority2[InferencePriority2["ContravariantConditional"] = 64] = "ContravariantConditional";
      InferencePriority2[InferencePriority2["ReturnType"] = 128] = "ReturnType";
      InferencePriority2[InferencePriority2["LiteralKeyof"] = 256] = "LiteralKeyof";
      InferencePriority2[InferencePriority2["NoConstraints"] = 512] = "NoConstraints";
      InferencePriority2[InferencePriority2["AlwaysStrict"] = 1024] = "AlwaysStrict";
      InferencePriority2[InferencePriority2["MaxValue"] = 2048] = "MaxValue";
      InferencePriority2[InferencePriority2["PriorityImpliesCombination"] = 416] = "PriorityImpliesCombination";
      InferencePriority2[InferencePriority2["Circularity"] = -1] = "Circularity";
    })(InferencePriority = ts2.InferencePriority || (ts2.InferencePriority = {}));
    var InferenceFlags;
    (function(InferenceFlags2) {
      InferenceFlags2[InferenceFlags2["None"] = 0] = "None";
      InferenceFlags2[InferenceFlags2["NoDefault"] = 1] = "NoDefault";
      InferenceFlags2[InferenceFlags2["AnyDefault"] = 2] = "AnyDefault";
      InferenceFlags2[InferenceFlags2["SkippedGenericFunction"] = 4] = "SkippedGenericFunction";
    })(InferenceFlags = ts2.InferenceFlags || (ts2.InferenceFlags = {}));
    var Ternary;
    (function(Ternary2) {
      Ternary2[Ternary2["False"] = 0] = "False";
      Ternary2[Ternary2["Unknown"] = 1] = "Unknown";
      Ternary2[Ternary2["Maybe"] = 3] = "Maybe";
      Ternary2[Ternary2["True"] = -1] = "True";
    })(Ternary = ts2.Ternary || (ts2.Ternary = {}));
    var AssignmentDeclarationKind;
    (function(AssignmentDeclarationKind2) {
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["None"] = 0] = "None";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["ExportsProperty"] = 1] = "ExportsProperty";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["ModuleExports"] = 2] = "ModuleExports";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["PrototypeProperty"] = 3] = "PrototypeProperty";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["ThisProperty"] = 4] = "ThisProperty";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["Property"] = 5] = "Property";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["Prototype"] = 6] = "Prototype";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePropertyValue"] = 7] = "ObjectDefinePropertyValue";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePropertyExports"] = 8] = "ObjectDefinePropertyExports";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePrototypeProperty"] = 9] = "ObjectDefinePrototypeProperty";
    })(AssignmentDeclarationKind = ts2.AssignmentDeclarationKind || (ts2.AssignmentDeclarationKind = {}));
    var DiagnosticCategory;
    (function(DiagnosticCategory2) {
      DiagnosticCategory2[DiagnosticCategory2["Warning"] = 0] = "Warning";
      DiagnosticCategory2[DiagnosticCategory2["Error"] = 1] = "Error";
      DiagnosticCategory2[DiagnosticCategory2["Suggestion"] = 2] = "Suggestion";
      DiagnosticCategory2[DiagnosticCategory2["Message"] = 3] = "Message";
    })(DiagnosticCategory = ts2.DiagnosticCategory || (ts2.DiagnosticCategory = {}));
    function diagnosticCategoryName(d, lowerCase) {
      if (lowerCase === void 0) {
        lowerCase = true;
      }
      var name = DiagnosticCategory[d.category];
      return lowerCase ? name.toLowerCase() : name;
    }
    ts2.diagnosticCategoryName = diagnosticCategoryName;
    var ModuleResolutionKind;
    (function(ModuleResolutionKind2) {
      ModuleResolutionKind2[ModuleResolutionKind2["Classic"] = 1] = "Classic";
      ModuleResolutionKind2[ModuleResolutionKind2["NodeJs"] = 2] = "NodeJs";
      ModuleResolutionKind2[ModuleResolutionKind2["Node12"] = 3] = "Node12";
      ModuleResolutionKind2[ModuleResolutionKind2["NodeNext"] = 99] = "NodeNext";
    })(ModuleResolutionKind = ts2.ModuleResolutionKind || (ts2.ModuleResolutionKind = {}));
    var WatchFileKind;
    (function(WatchFileKind2) {
      WatchFileKind2[WatchFileKind2["FixedPollingInterval"] = 0] = "FixedPollingInterval";
      WatchFileKind2[WatchFileKind2["PriorityPollingInterval"] = 1] = "PriorityPollingInterval";
      WatchFileKind2[WatchFileKind2["DynamicPriorityPolling"] = 2] = "DynamicPriorityPolling";
      WatchFileKind2[WatchFileKind2["FixedChunkSizePolling"] = 3] = "FixedChunkSizePolling";
      WatchFileKind2[WatchFileKind2["UseFsEvents"] = 4] = "UseFsEvents";
      WatchFileKind2[WatchFileKind2["UseFsEventsOnParentDirectory"] = 5] = "UseFsEventsOnParentDirectory";
    })(WatchFileKind = ts2.WatchFileKind || (ts2.WatchFileKind = {}));
    var WatchDirectoryKind;
    (function(WatchDirectoryKind2) {
      WatchDirectoryKind2[WatchDirectoryKind2["UseFsEvents"] = 0] = "UseFsEvents";
      WatchDirectoryKind2[WatchDirectoryKind2["FixedPollingInterval"] = 1] = "FixedPollingInterval";
      WatchDirectoryKind2[WatchDirectoryKind2["DynamicPriorityPolling"] = 2] = "DynamicPriorityPolling";
      WatchDirectoryKind2[WatchDirectoryKind2["FixedChunkSizePolling"] = 3] = "FixedChunkSizePolling";
    })(WatchDirectoryKind = ts2.WatchDirectoryKind || (ts2.WatchDirectoryKind = {}));
    var PollingWatchKind;
    (function(PollingWatchKind2) {
      PollingWatchKind2[PollingWatchKind2["FixedInterval"] = 0] = "FixedInterval";
      PollingWatchKind2[PollingWatchKind2["PriorityInterval"] = 1] = "PriorityInterval";
      PollingWatchKind2[PollingWatchKind2["DynamicPriority"] = 2] = "DynamicPriority";
      PollingWatchKind2[PollingWatchKind2["FixedChunkSize"] = 3] = "FixedChunkSize";
    })(PollingWatchKind = ts2.PollingWatchKind || (ts2.PollingWatchKind = {}));
    var ModuleKind;
    (function(ModuleKind2) {
      ModuleKind2[ModuleKind2["None"] = 0] = "None";
      ModuleKind2[ModuleKind2["CommonJS"] = 1] = "CommonJS";
      ModuleKind2[ModuleKind2["AMD"] = 2] = "AMD";
      ModuleKind2[ModuleKind2["UMD"] = 3] = "UMD";
      ModuleKind2[ModuleKind2["System"] = 4] = "System";
      ModuleKind2[ModuleKind2["ES2015"] = 5] = "ES2015";
      ModuleKind2[ModuleKind2["ES2020"] = 6] = "ES2020";
      ModuleKind2[ModuleKind2["ES2022"] = 7] = "ES2022";
      ModuleKind2[ModuleKind2["ESNext"] = 99] = "ESNext";
      ModuleKind2[ModuleKind2["Node12"] = 100] = "Node12";
      ModuleKind2[ModuleKind2["NodeNext"] = 199] = "NodeNext";
    })(ModuleKind = ts2.ModuleKind || (ts2.ModuleKind = {}));
    var JsxEmit;
    (function(JsxEmit2) {
      JsxEmit2[JsxEmit2["None"] = 0] = "None";
      JsxEmit2[JsxEmit2["Preserve"] = 1] = "Preserve";
      JsxEmit2[JsxEmit2["React"] = 2] = "React";
      JsxEmit2[JsxEmit2["ReactNative"] = 3] = "ReactNative";
      JsxEmit2[JsxEmit2["ReactJSX"] = 4] = "ReactJSX";
      JsxEmit2[JsxEmit2["ReactJSXDev"] = 5] = "ReactJSXDev";
    })(JsxEmit = ts2.JsxEmit || (ts2.JsxEmit = {}));
    var ImportsNotUsedAsValues;
    (function(ImportsNotUsedAsValues2) {
      ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Remove"] = 0] = "Remove";
      ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Preserve"] = 1] = "Preserve";
      ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Error"] = 2] = "Error";
    })(ImportsNotUsedAsValues = ts2.ImportsNotUsedAsValues || (ts2.ImportsNotUsedAsValues = {}));
    var NewLineKind;
    (function(NewLineKind2) {
      NewLineKind2[NewLineKind2["CarriageReturnLineFeed"] = 0] = "CarriageReturnLineFeed";
      NewLineKind2[NewLineKind2["LineFeed"] = 1] = "LineFeed";
    })(NewLineKind = ts2.NewLineKind || (ts2.NewLineKind = {}));
    var ScriptKind2;
    (function(ScriptKind3) {
      ScriptKind3[ScriptKind3["Unknown"] = 0] = "Unknown";
      ScriptKind3[ScriptKind3["JS"] = 1] = "JS";
      ScriptKind3[ScriptKind3["JSX"] = 2] = "JSX";
      ScriptKind3[ScriptKind3["TS"] = 3] = "TS";
      ScriptKind3[ScriptKind3["TSX"] = 4] = "TSX";
      ScriptKind3[ScriptKind3["External"] = 5] = "External";
      ScriptKind3[ScriptKind3["JSON"] = 6] = "JSON";
      ScriptKind3[ScriptKind3["Deferred"] = 7] = "Deferred";
    })(ScriptKind2 = ts2.ScriptKind || (ts2.ScriptKind = {}));
    var ScriptTarget2;
    (function(ScriptTarget3) {
      ScriptTarget3[ScriptTarget3["ES3"] = 0] = "ES3";
      ScriptTarget3[ScriptTarget3["ES5"] = 1] = "ES5";
      ScriptTarget3[ScriptTarget3["ES2015"] = 2] = "ES2015";
      ScriptTarget3[ScriptTarget3["ES2016"] = 3] = "ES2016";
      ScriptTarget3[ScriptTarget3["ES2017"] = 4] = "ES2017";
      ScriptTarget3[ScriptTarget3["ES2018"] = 5] = "ES2018";
      ScriptTarget3[ScriptTarget3["ES2019"] = 6] = "ES2019";
      ScriptTarget3[ScriptTarget3["ES2020"] = 7] = "ES2020";
      ScriptTarget3[ScriptTarget3["ES2021"] = 8] = "ES2021";
      ScriptTarget3[ScriptTarget3["ESNext"] = 99] = "ESNext";
      ScriptTarget3[ScriptTarget3["JSON"] = 100] = "JSON";
      ScriptTarget3[ScriptTarget3["Latest"] = 99] = "Latest";
    })(ScriptTarget2 = ts2.ScriptTarget || (ts2.ScriptTarget = {}));
    var LanguageVariant;
    (function(LanguageVariant2) {
      LanguageVariant2[LanguageVariant2["Standard"] = 0] = "Standard";
      LanguageVariant2[LanguageVariant2["JSX"] = 1] = "JSX";
    })(LanguageVariant = ts2.LanguageVariant || (ts2.LanguageVariant = {}));
    var WatchDirectoryFlags;
    (function(WatchDirectoryFlags2) {
      WatchDirectoryFlags2[WatchDirectoryFlags2["None"] = 0] = "None";
      WatchDirectoryFlags2[WatchDirectoryFlags2["Recursive"] = 1] = "Recursive";
    })(WatchDirectoryFlags = ts2.WatchDirectoryFlags || (ts2.WatchDirectoryFlags = {}));
    var CharacterCodes;
    (function(CharacterCodes2) {
      CharacterCodes2[CharacterCodes2["nullCharacter"] = 0] = "nullCharacter";
      CharacterCodes2[CharacterCodes2["maxAsciiCharacter"] = 127] = "maxAsciiCharacter";
      CharacterCodes2[CharacterCodes2["lineFeed"] = 10] = "lineFeed";
      CharacterCodes2[CharacterCodes2["carriageReturn"] = 13] = "carriageReturn";
      CharacterCodes2[CharacterCodes2["lineSeparator"] = 8232] = "lineSeparator";
      CharacterCodes2[CharacterCodes2["paragraphSeparator"] = 8233] = "paragraphSeparator";
      CharacterCodes2[CharacterCodes2["nextLine"] = 133] = "nextLine";
      CharacterCodes2[CharacterCodes2["space"] = 32] = "space";
      CharacterCodes2[CharacterCodes2["nonBreakingSpace"] = 160] = "nonBreakingSpace";
      CharacterCodes2[CharacterCodes2["enQuad"] = 8192] = "enQuad";
      CharacterCodes2[CharacterCodes2["emQuad"] = 8193] = "emQuad";
      CharacterCodes2[CharacterCodes2["enSpace"] = 8194] = "enSpace";
      CharacterCodes2[CharacterCodes2["emSpace"] = 8195] = "emSpace";
      CharacterCodes2[CharacterCodes2["threePerEmSpace"] = 8196] = "threePerEmSpace";
      CharacterCodes2[CharacterCodes2["fourPerEmSpace"] = 8197] = "fourPerEmSpace";
      CharacterCodes2[CharacterCodes2["sixPerEmSpace"] = 8198] = "sixPerEmSpace";
      CharacterCodes2[CharacterCodes2["figureSpace"] = 8199] = "figureSpace";
      CharacterCodes2[CharacterCodes2["punctuationSpace"] = 8200] = "punctuationSpace";
      CharacterCodes2[CharacterCodes2["thinSpace"] = 8201] = "thinSpace";
      CharacterCodes2[CharacterCodes2["hairSpace"] = 8202] = "hairSpace";
      CharacterCodes2[CharacterCodes2["zeroWidthSpace"] = 8203] = "zeroWidthSpace";
      CharacterCodes2[CharacterCodes2["narrowNoBreakSpace"] = 8239] = "narrowNoBreakSpace";
      CharacterCodes2[CharacterCodes2["ideographicSpace"] = 12288] = "ideographicSpace";
      CharacterCodes2[CharacterCodes2["mathematicalSpace"] = 8287] = "mathematicalSpace";
      CharacterCodes2[CharacterCodes2["ogham"] = 5760] = "ogham";
      CharacterCodes2[CharacterCodes2["_"] = 95] = "_";
      CharacterCodes2[CharacterCodes2["$"] = 36] = "$";
      CharacterCodes2[CharacterCodes2["_0"] = 48] = "_0";
      CharacterCodes2[CharacterCodes2["_1"] = 49] = "_1";
      CharacterCodes2[CharacterCodes2["_2"] = 50] = "_2";
      CharacterCodes2[CharacterCodes2["_3"] = 51] = "_3";
      CharacterCodes2[CharacterCodes2["_4"] = 52] = "_4";
      CharacterCodes2[CharacterCodes2["_5"] = 53] = "_5";
      CharacterCodes2[CharacterCodes2["_6"] = 54] = "_6";
      CharacterCodes2[CharacterCodes2["_7"] = 55] = "_7";
      CharacterCodes2[CharacterCodes2["_8"] = 56] = "_8";
      CharacterCodes2[CharacterCodes2["_9"] = 57] = "_9";
      CharacterCodes2[CharacterCodes2["a"] = 97] = "a";
      CharacterCodes2[CharacterCodes2["b"] = 98] = "b";
      CharacterCodes2[CharacterCodes2["c"] = 99] = "c";
      CharacterCodes2[CharacterCodes2["d"] = 100] = "d";
      CharacterCodes2[CharacterCodes2["e"] = 101] = "e";
      CharacterCodes2[CharacterCodes2["f"] = 102] = "f";
      CharacterCodes2[CharacterCodes2["g"] = 103] = "g";
      CharacterCodes2[CharacterCodes2["h"] = 104] = "h";
      CharacterCodes2[CharacterCodes2["i"] = 105] = "i";
      CharacterCodes2[CharacterCodes2["j"] = 106] = "j";
      CharacterCodes2[CharacterCodes2["k"] = 107] = "k";
      CharacterCodes2[CharacterCodes2["l"] = 108] = "l";
      CharacterCodes2[CharacterCodes2["m"] = 109] = "m";
      CharacterCodes2[CharacterCodes2["n"] = 110] = "n";
      CharacterCodes2[CharacterCodes2["o"] = 111] = "o";
      CharacterCodes2[CharacterCodes2["p"] = 112] = "p";
      CharacterCodes2[CharacterCodes2["q"] = 113] = "q";
      CharacterCodes2[CharacterCodes2["r"] = 114] = "r";
      CharacterCodes2[CharacterCodes2["s"] = 115] = "s";
      CharacterCodes2[CharacterCodes2["t"] = 116] = "t";
      CharacterCodes2[CharacterCodes2["u"] = 117] = "u";
      CharacterCodes2[CharacterCodes2["v"] = 118] = "v";
      CharacterCodes2[CharacterCodes2["w"] = 119] = "w";
      CharacterCodes2[CharacterCodes2["x"] = 120] = "x";
      CharacterCodes2[CharacterCodes2["y"] = 121] = "y";
      CharacterCodes2[CharacterCodes2["z"] = 122] = "z";
      CharacterCodes2[CharacterCodes2["A"] = 65] = "A";
      CharacterCodes2[CharacterCodes2["B"] = 66] = "B";
      CharacterCodes2[CharacterCodes2["C"] = 67] = "C";
      CharacterCodes2[CharacterCodes2["D"] = 68] = "D";
      CharacterCodes2[CharacterCodes2["E"] = 69] = "E";
      CharacterCodes2[CharacterCodes2["F"] = 70] = "F";
      CharacterCodes2[CharacterCodes2["G"] = 71] = "G";
      CharacterCodes2[CharacterCodes2["H"] = 72] = "H";
      CharacterCodes2[CharacterCodes2["I"] = 73] = "I";
      CharacterCodes2[CharacterCodes2["J"] = 74] = "J";
      CharacterCodes2[CharacterCodes2["K"] = 75] = "K";
      CharacterCodes2[CharacterCodes2["L"] = 76] = "L";
      CharacterCodes2[CharacterCodes2["M"] = 77] = "M";
      CharacterCodes2[CharacterCodes2["N"] = 78] = "N";
      CharacterCodes2[CharacterCodes2["O"] = 79] = "O";
      CharacterCodes2[CharacterCodes2["P"] = 80] = "P";
      CharacterCodes2[CharacterCodes2["Q"] = 81] = "Q";
      CharacterCodes2[CharacterCodes2["R"] = 82] = "R";
      CharacterCodes2[CharacterCodes2["S"] = 83] = "S";
      CharacterCodes2[CharacterCodes2["T"] = 84] = "T";
      CharacterCodes2[CharacterCodes2["U"] = 85] = "U";
      CharacterCodes2[CharacterCodes2["V"] = 86] = "V";
      CharacterCodes2[CharacterCodes2["W"] = 87] = "W";
      CharacterCodes2[CharacterCodes2["X"] = 88] = "X";
      CharacterCodes2[CharacterCodes2["Y"] = 89] = "Y";
      CharacterCodes2[CharacterCodes2["Z"] = 90] = "Z";
      CharacterCodes2[CharacterCodes2["ampersand"] = 38] = "ampersand";
      CharacterCodes2[CharacterCodes2["asterisk"] = 42] = "asterisk";
      CharacterCodes2[CharacterCodes2["at"] = 64] = "at";
      CharacterCodes2[CharacterCodes2["backslash"] = 92] = "backslash";
      CharacterCodes2[CharacterCodes2["backtick"] = 96] = "backtick";
      CharacterCodes2[CharacterCodes2["bar"] = 124] = "bar";
      CharacterCodes2[CharacterCodes2["caret"] = 94] = "caret";
      CharacterCodes2[CharacterCodes2["closeBrace"] = 125] = "closeBrace";
      CharacterCodes2[CharacterCodes2["closeBracket"] = 93] = "closeBracket";
      CharacterCodes2[CharacterCodes2["closeParen"] = 41] = "closeParen";
      CharacterCodes2[CharacterCodes2["colon"] = 58] = "colon";
      CharacterCodes2[CharacterCodes2["comma"] = 44] = "comma";
      CharacterCodes2[CharacterCodes2["dot"] = 46] = "dot";
      CharacterCodes2[CharacterCodes2["doubleQuote"] = 34] = "doubleQuote";
      CharacterCodes2[CharacterCodes2["equals"] = 61] = "equals";
      CharacterCodes2[CharacterCodes2["exclamation"] = 33] = "exclamation";
      CharacterCodes2[CharacterCodes2["greaterThan"] = 62] = "greaterThan";
      CharacterCodes2[CharacterCodes2["hash"] = 35] = "hash";
      CharacterCodes2[CharacterCodes2["lessThan"] = 60] = "lessThan";
      CharacterCodes2[CharacterCodes2["minus"] = 45] = "minus";
      CharacterCodes2[CharacterCodes2["openBrace"] = 123] = "openBrace";
      CharacterCodes2[CharacterCodes2["openBracket"] = 91] = "openBracket";
      CharacterCodes2[CharacterCodes2["openParen"] = 40] = "openParen";
      CharacterCodes2[CharacterCodes2["percent"] = 37] = "percent";
      CharacterCodes2[CharacterCodes2["plus"] = 43] = "plus";
      CharacterCodes2[CharacterCodes2["question"] = 63] = "question";
      CharacterCodes2[CharacterCodes2["semicolon"] = 59] = "semicolon";
      CharacterCodes2[CharacterCodes2["singleQuote"] = 39] = "singleQuote";
      CharacterCodes2[CharacterCodes2["slash"] = 47] = "slash";
      CharacterCodes2[CharacterCodes2["tilde"] = 126] = "tilde";
      CharacterCodes2[CharacterCodes2["backspace"] = 8] = "backspace";
      CharacterCodes2[CharacterCodes2["formFeed"] = 12] = "formFeed";
      CharacterCodes2[CharacterCodes2["byteOrderMark"] = 65279] = "byteOrderMark";
      CharacterCodes2[CharacterCodes2["tab"] = 9] = "tab";
      CharacterCodes2[CharacterCodes2["verticalTab"] = 11] = "verticalTab";
    })(CharacterCodes = ts2.CharacterCodes || (ts2.CharacterCodes = {}));
    var Extension;
    (function(Extension2) {
      Extension2["Ts"] = ".ts";
      Extension2["Tsx"] = ".tsx";
      Extension2["Dts"] = ".d.ts";
      Extension2["Js"] = ".js";
      Extension2["Jsx"] = ".jsx";
      Extension2["Json"] = ".json";
      Extension2["TsBuildInfo"] = ".tsbuildinfo";
      Extension2["Mjs"] = ".mjs";
      Extension2["Mts"] = ".mts";
      Extension2["Dmts"] = ".d.mts";
      Extension2["Cjs"] = ".cjs";
      Extension2["Cts"] = ".cts";
      Extension2["Dcts"] = ".d.cts";
    })(Extension = ts2.Extension || (ts2.Extension = {}));
    var TransformFlags;
    (function(TransformFlags2) {
      TransformFlags2[TransformFlags2["None"] = 0] = "None";
      TransformFlags2[TransformFlags2["ContainsTypeScript"] = 1] = "ContainsTypeScript";
      TransformFlags2[TransformFlags2["ContainsJsx"] = 2] = "ContainsJsx";
      TransformFlags2[TransformFlags2["ContainsESNext"] = 4] = "ContainsESNext";
      TransformFlags2[TransformFlags2["ContainsES2021"] = 8] = "ContainsES2021";
      TransformFlags2[TransformFlags2["ContainsES2020"] = 16] = "ContainsES2020";
      TransformFlags2[TransformFlags2["ContainsES2019"] = 32] = "ContainsES2019";
      TransformFlags2[TransformFlags2["ContainsES2018"] = 64] = "ContainsES2018";
      TransformFlags2[TransformFlags2["ContainsES2017"] = 128] = "ContainsES2017";
      TransformFlags2[TransformFlags2["ContainsES2016"] = 256] = "ContainsES2016";
      TransformFlags2[TransformFlags2["ContainsES2015"] = 512] = "ContainsES2015";
      TransformFlags2[TransformFlags2["ContainsGenerator"] = 1024] = "ContainsGenerator";
      TransformFlags2[TransformFlags2["ContainsDestructuringAssignment"] = 2048] = "ContainsDestructuringAssignment";
      TransformFlags2[TransformFlags2["ContainsTypeScriptClassSyntax"] = 4096] = "ContainsTypeScriptClassSyntax";
      TransformFlags2[TransformFlags2["ContainsLexicalThis"] = 8192] = "ContainsLexicalThis";
      TransformFlags2[TransformFlags2["ContainsRestOrSpread"] = 16384] = "ContainsRestOrSpread";
      TransformFlags2[TransformFlags2["ContainsObjectRestOrSpread"] = 32768] = "ContainsObjectRestOrSpread";
      TransformFlags2[TransformFlags2["ContainsComputedPropertyName"] = 65536] = "ContainsComputedPropertyName";
      TransformFlags2[TransformFlags2["ContainsBlockScopedBinding"] = 131072] = "ContainsBlockScopedBinding";
      TransformFlags2[TransformFlags2["ContainsBindingPattern"] = 262144] = "ContainsBindingPattern";
      TransformFlags2[TransformFlags2["ContainsYield"] = 524288] = "ContainsYield";
      TransformFlags2[TransformFlags2["ContainsAwait"] = 1048576] = "ContainsAwait";
      TransformFlags2[TransformFlags2["ContainsHoistedDeclarationOrCompletion"] = 2097152] = "ContainsHoistedDeclarationOrCompletion";
      TransformFlags2[TransformFlags2["ContainsDynamicImport"] = 4194304] = "ContainsDynamicImport";
      TransformFlags2[TransformFlags2["ContainsClassFields"] = 8388608] = "ContainsClassFields";
      TransformFlags2[TransformFlags2["ContainsPossibleTopLevelAwait"] = 16777216] = "ContainsPossibleTopLevelAwait";
      TransformFlags2[TransformFlags2["ContainsLexicalSuper"] = 33554432] = "ContainsLexicalSuper";
      TransformFlags2[TransformFlags2["ContainsUpdateExpressionForIdentifier"] = 67108864] = "ContainsUpdateExpressionForIdentifier";
      TransformFlags2[TransformFlags2["HasComputedFlags"] = 536870912] = "HasComputedFlags";
      TransformFlags2[TransformFlags2["AssertTypeScript"] = 1] = "AssertTypeScript";
      TransformFlags2[TransformFlags2["AssertJsx"] = 2] = "AssertJsx";
      TransformFlags2[TransformFlags2["AssertESNext"] = 4] = "AssertESNext";
      TransformFlags2[TransformFlags2["AssertES2021"] = 8] = "AssertES2021";
      TransformFlags2[TransformFlags2["AssertES2020"] = 16] = "AssertES2020";
      TransformFlags2[TransformFlags2["AssertES2019"] = 32] = "AssertES2019";
      TransformFlags2[TransformFlags2["AssertES2018"] = 64] = "AssertES2018";
      TransformFlags2[TransformFlags2["AssertES2017"] = 128] = "AssertES2017";
      TransformFlags2[TransformFlags2["AssertES2016"] = 256] = "AssertES2016";
      TransformFlags2[TransformFlags2["AssertES2015"] = 512] = "AssertES2015";
      TransformFlags2[TransformFlags2["AssertGenerator"] = 1024] = "AssertGenerator";
      TransformFlags2[TransformFlags2["AssertDestructuringAssignment"] = 2048] = "AssertDestructuringAssignment";
      TransformFlags2[TransformFlags2["OuterExpressionExcludes"] = 536870912] = "OuterExpressionExcludes";
      TransformFlags2[TransformFlags2["PropertyAccessExcludes"] = 536870912] = "PropertyAccessExcludes";
      TransformFlags2[TransformFlags2["NodeExcludes"] = 536870912] = "NodeExcludes";
      TransformFlags2[TransformFlags2["ArrowFunctionExcludes"] = 557748224] = "ArrowFunctionExcludes";
      TransformFlags2[TransformFlags2["FunctionExcludes"] = 591310848] = "FunctionExcludes";
      TransformFlags2[TransformFlags2["ConstructorExcludes"] = 591306752] = "ConstructorExcludes";
      TransformFlags2[TransformFlags2["MethodOrAccessorExcludes"] = 574529536] = "MethodOrAccessorExcludes";
      TransformFlags2[TransformFlags2["PropertyExcludes"] = 570433536] = "PropertyExcludes";
      TransformFlags2[TransformFlags2["ClassExcludes"] = 536940544] = "ClassExcludes";
      TransformFlags2[TransformFlags2["ModuleExcludes"] = 589443072] = "ModuleExcludes";
      TransformFlags2[TransformFlags2["TypeExcludes"] = -2] = "TypeExcludes";
      TransformFlags2[TransformFlags2["ObjectLiteralExcludes"] = 536973312] = "ObjectLiteralExcludes";
      TransformFlags2[TransformFlags2["ArrayLiteralOrCallOrNewExcludes"] = 536887296] = "ArrayLiteralOrCallOrNewExcludes";
      TransformFlags2[TransformFlags2["VariableDeclarationListExcludes"] = 537165824] = "VariableDeclarationListExcludes";
      TransformFlags2[TransformFlags2["ParameterExcludes"] = 536870912] = "ParameterExcludes";
      TransformFlags2[TransformFlags2["CatchClauseExcludes"] = 536903680] = "CatchClauseExcludes";
      TransformFlags2[TransformFlags2["BindingPatternExcludes"] = 536887296] = "BindingPatternExcludes";
      TransformFlags2[TransformFlags2["ContainsLexicalThisOrSuper"] = 33562624] = "ContainsLexicalThisOrSuper";
      TransformFlags2[TransformFlags2["PropertyNamePropagatingFlags"] = 33562624] = "PropertyNamePropagatingFlags";
    })(TransformFlags = ts2.TransformFlags || (ts2.TransformFlags = {}));
    var SnippetKind;
    (function(SnippetKind2) {
      SnippetKind2[SnippetKind2["TabStop"] = 0] = "TabStop";
      SnippetKind2[SnippetKind2["Placeholder"] = 1] = "Placeholder";
      SnippetKind2[SnippetKind2["Choice"] = 2] = "Choice";
      SnippetKind2[SnippetKind2["Variable"] = 3] = "Variable";
    })(SnippetKind = ts2.SnippetKind || (ts2.SnippetKind = {}));
    var EmitFlags;
    (function(EmitFlags2) {
      EmitFlags2[EmitFlags2["None"] = 0] = "None";
      EmitFlags2[EmitFlags2["SingleLine"] = 1] = "SingleLine";
      EmitFlags2[EmitFlags2["AdviseOnEmitNode"] = 2] = "AdviseOnEmitNode";
      EmitFlags2[EmitFlags2["NoSubstitution"] = 4] = "NoSubstitution";
      EmitFlags2[EmitFlags2["CapturesThis"] = 8] = "CapturesThis";
      EmitFlags2[EmitFlags2["NoLeadingSourceMap"] = 16] = "NoLeadingSourceMap";
      EmitFlags2[EmitFlags2["NoTrailingSourceMap"] = 32] = "NoTrailingSourceMap";
      EmitFlags2[EmitFlags2["NoSourceMap"] = 48] = "NoSourceMap";
      EmitFlags2[EmitFlags2["NoNestedSourceMaps"] = 64] = "NoNestedSourceMaps";
      EmitFlags2[EmitFlags2["NoTokenLeadingSourceMaps"] = 128] = "NoTokenLeadingSourceMaps";
      EmitFlags2[EmitFlags2["NoTokenTrailingSourceMaps"] = 256] = "NoTokenTrailingSourceMaps";
      EmitFlags2[EmitFlags2["NoTokenSourceMaps"] = 384] = "NoTokenSourceMaps";
      EmitFlags2[EmitFlags2["NoLeadingComments"] = 512] = "NoLeadingComments";
      EmitFlags2[EmitFlags2["NoTrailingComments"] = 1024] = "NoTrailingComments";
      EmitFlags2[EmitFlags2["NoComments"] = 1536] = "NoComments";
      EmitFlags2[EmitFlags2["NoNestedComments"] = 2048] = "NoNestedComments";
      EmitFlags2[EmitFlags2["HelperName"] = 4096] = "HelperName";
      EmitFlags2[EmitFlags2["ExportName"] = 8192] = "ExportName";
      EmitFlags2[EmitFlags2["LocalName"] = 16384] = "LocalName";
      EmitFlags2[EmitFlags2["InternalName"] = 32768] = "InternalName";
      EmitFlags2[EmitFlags2["Indented"] = 65536] = "Indented";
      EmitFlags2[EmitFlags2["NoIndentation"] = 131072] = "NoIndentation";
      EmitFlags2[EmitFlags2["AsyncFunctionBody"] = 262144] = "AsyncFunctionBody";
      EmitFlags2[EmitFlags2["ReuseTempVariableScope"] = 524288] = "ReuseTempVariableScope";
      EmitFlags2[EmitFlags2["CustomPrologue"] = 1048576] = "CustomPrologue";
      EmitFlags2[EmitFlags2["NoHoisting"] = 2097152] = "NoHoisting";
      EmitFlags2[EmitFlags2["HasEndOfDeclarationMarker"] = 4194304] = "HasEndOfDeclarationMarker";
      EmitFlags2[EmitFlags2["Iterator"] = 8388608] = "Iterator";
      EmitFlags2[EmitFlags2["NoAsciiEscaping"] = 16777216] = "NoAsciiEscaping";
      EmitFlags2[EmitFlags2["TypeScriptClassWrapper"] = 33554432] = "TypeScriptClassWrapper";
      EmitFlags2[EmitFlags2["NeverApplyImportHelper"] = 67108864] = "NeverApplyImportHelper";
      EmitFlags2[EmitFlags2["IgnoreSourceNewlines"] = 134217728] = "IgnoreSourceNewlines";
      EmitFlags2[EmitFlags2["Immutable"] = 268435456] = "Immutable";
      EmitFlags2[EmitFlags2["IndirectCall"] = 536870912] = "IndirectCall";
    })(EmitFlags = ts2.EmitFlags || (ts2.EmitFlags = {}));
    var ExternalEmitHelpers;
    (function(ExternalEmitHelpers2) {
      ExternalEmitHelpers2[ExternalEmitHelpers2["Extends"] = 1] = "Extends";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Assign"] = 2] = "Assign";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Rest"] = 4] = "Rest";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Decorate"] = 8] = "Decorate";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Metadata"] = 16] = "Metadata";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Param"] = 32] = "Param";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Awaiter"] = 64] = "Awaiter";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Generator"] = 128] = "Generator";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Values"] = 256] = "Values";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Read"] = 512] = "Read";
      ExternalEmitHelpers2[ExternalEmitHelpers2["SpreadArray"] = 1024] = "SpreadArray";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Await"] = 2048] = "Await";
      ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncGenerator"] = 4096] = "AsyncGenerator";
      ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncDelegator"] = 8192] = "AsyncDelegator";
      ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncValues"] = 16384] = "AsyncValues";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ExportStar"] = 32768] = "ExportStar";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ImportStar"] = 65536] = "ImportStar";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ImportDefault"] = 131072] = "ImportDefault";
      ExternalEmitHelpers2[ExternalEmitHelpers2["MakeTemplateObject"] = 262144] = "MakeTemplateObject";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ClassPrivateFieldGet"] = 524288] = "ClassPrivateFieldGet";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ClassPrivateFieldSet"] = 1048576] = "ClassPrivateFieldSet";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ClassPrivateFieldIn"] = 2097152] = "ClassPrivateFieldIn";
      ExternalEmitHelpers2[ExternalEmitHelpers2["CreateBinding"] = 4194304] = "CreateBinding";
      ExternalEmitHelpers2[ExternalEmitHelpers2["FirstEmitHelper"] = 1] = "FirstEmitHelper";
      ExternalEmitHelpers2[ExternalEmitHelpers2["LastEmitHelper"] = 4194304] = "LastEmitHelper";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ForOfIncludes"] = 256] = "ForOfIncludes";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ForAwaitOfIncludes"] = 16384] = "ForAwaitOfIncludes";
      ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncGeneratorIncludes"] = 6144] = "AsyncGeneratorIncludes";
      ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncDelegatorIncludes"] = 26624] = "AsyncDelegatorIncludes";
      ExternalEmitHelpers2[ExternalEmitHelpers2["SpreadIncludes"] = 1536] = "SpreadIncludes";
    })(ExternalEmitHelpers = ts2.ExternalEmitHelpers || (ts2.ExternalEmitHelpers = {}));
    var EmitHint;
    (function(EmitHint2) {
      EmitHint2[EmitHint2["SourceFile"] = 0] = "SourceFile";
      EmitHint2[EmitHint2["Expression"] = 1] = "Expression";
      EmitHint2[EmitHint2["IdentifierName"] = 2] = "IdentifierName";
      EmitHint2[EmitHint2["MappedTypeParameter"] = 3] = "MappedTypeParameter";
      EmitHint2[EmitHint2["Unspecified"] = 4] = "Unspecified";
      EmitHint2[EmitHint2["EmbeddedStatement"] = 5] = "EmbeddedStatement";
      EmitHint2[EmitHint2["JsxAttributeValue"] = 6] = "JsxAttributeValue";
    })(EmitHint = ts2.EmitHint || (ts2.EmitHint = {}));
    var OuterExpressionKinds;
    (function(OuterExpressionKinds2) {
      OuterExpressionKinds2[OuterExpressionKinds2["Parentheses"] = 1] = "Parentheses";
      OuterExpressionKinds2[OuterExpressionKinds2["TypeAssertions"] = 2] = "TypeAssertions";
      OuterExpressionKinds2[OuterExpressionKinds2["NonNullAssertions"] = 4] = "NonNullAssertions";
      OuterExpressionKinds2[OuterExpressionKinds2["PartiallyEmittedExpressions"] = 8] = "PartiallyEmittedExpressions";
      OuterExpressionKinds2[OuterExpressionKinds2["Assertions"] = 6] = "Assertions";
      OuterExpressionKinds2[OuterExpressionKinds2["All"] = 15] = "All";
      OuterExpressionKinds2[OuterExpressionKinds2["ExcludeJSDocTypeAssertion"] = 16] = "ExcludeJSDocTypeAssertion";
    })(OuterExpressionKinds = ts2.OuterExpressionKinds || (ts2.OuterExpressionKinds = {}));
    var LexicalEnvironmentFlags;
    (function(LexicalEnvironmentFlags2) {
      LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["None"] = 0] = "None";
      LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["InParameters"] = 1] = "InParameters";
      LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["VariablesHoistedInParameters"] = 2] = "VariablesHoistedInParameters";
    })(LexicalEnvironmentFlags = ts2.LexicalEnvironmentFlags || (ts2.LexicalEnvironmentFlags = {}));
    var BundleFileSectionKind;
    (function(BundleFileSectionKind2) {
      BundleFileSectionKind2["Prologue"] = "prologue";
      BundleFileSectionKind2["EmitHelpers"] = "emitHelpers";
      BundleFileSectionKind2["NoDefaultLib"] = "no-default-lib";
      BundleFileSectionKind2["Reference"] = "reference";
      BundleFileSectionKind2["Type"] = "type";
      BundleFileSectionKind2["Lib"] = "lib";
      BundleFileSectionKind2["Prepend"] = "prepend";
      BundleFileSectionKind2["Text"] = "text";
      BundleFileSectionKind2["Internal"] = "internal";
    })(BundleFileSectionKind = ts2.BundleFileSectionKind || (ts2.BundleFileSectionKind = {}));
    var ListFormat;
    (function(ListFormat2) {
      ListFormat2[ListFormat2["None"] = 0] = "None";
      ListFormat2[ListFormat2["SingleLine"] = 0] = "SingleLine";
      ListFormat2[ListFormat2["MultiLine"] = 1] = "MultiLine";
      ListFormat2[ListFormat2["PreserveLines"] = 2] = "PreserveLines";
      ListFormat2[ListFormat2["LinesMask"] = 3] = "LinesMask";
      ListFormat2[ListFormat2["NotDelimited"] = 0] = "NotDelimited";
      ListFormat2[ListFormat2["BarDelimited"] = 4] = "BarDelimited";
      ListFormat2[ListFormat2["AmpersandDelimited"] = 8] = "AmpersandDelimited";
      ListFormat2[ListFormat2["CommaDelimited"] = 16] = "CommaDelimited";
      ListFormat2[ListFormat2["AsteriskDelimited"] = 32] = "AsteriskDelimited";
      ListFormat2[ListFormat2["DelimitersMask"] = 60] = "DelimitersMask";
      ListFormat2[ListFormat2["AllowTrailingComma"] = 64] = "AllowTrailingComma";
      ListFormat2[ListFormat2["Indented"] = 128] = "Indented";
      ListFormat2[ListFormat2["SpaceBetweenBraces"] = 256] = "SpaceBetweenBraces";
      ListFormat2[ListFormat2["SpaceBetweenSiblings"] = 512] = "SpaceBetweenSiblings";
      ListFormat2[ListFormat2["Braces"] = 1024] = "Braces";
      ListFormat2[ListFormat2["Parenthesis"] = 2048] = "Parenthesis";
      ListFormat2[ListFormat2["AngleBrackets"] = 4096] = "AngleBrackets";
      ListFormat2[ListFormat2["SquareBrackets"] = 8192] = "SquareBrackets";
      ListFormat2[ListFormat2["BracketsMask"] = 15360] = "BracketsMask";
      ListFormat2[ListFormat2["OptionalIfUndefined"] = 16384] = "OptionalIfUndefined";
      ListFormat2[ListFormat2["OptionalIfEmpty"] = 32768] = "OptionalIfEmpty";
      ListFormat2[ListFormat2["Optional"] = 49152] = "Optional";
      ListFormat2[ListFormat2["PreferNewLine"] = 65536] = "PreferNewLine";
      ListFormat2[ListFormat2["NoTrailingNewLine"] = 131072] = "NoTrailingNewLine";
      ListFormat2[ListFormat2["NoInterveningComments"] = 262144] = "NoInterveningComments";
      ListFormat2[ListFormat2["NoSpaceIfEmpty"] = 524288] = "NoSpaceIfEmpty";
      ListFormat2[ListFormat2["SingleElement"] = 1048576] = "SingleElement";
      ListFormat2[ListFormat2["SpaceAfterList"] = 2097152] = "SpaceAfterList";
      ListFormat2[ListFormat2["Modifiers"] = 262656] = "Modifiers";
      ListFormat2[ListFormat2["HeritageClauses"] = 512] = "HeritageClauses";
      ListFormat2[ListFormat2["SingleLineTypeLiteralMembers"] = 768] = "SingleLineTypeLiteralMembers";
      ListFormat2[ListFormat2["MultiLineTypeLiteralMembers"] = 32897] = "MultiLineTypeLiteralMembers";
      ListFormat2[ListFormat2["SingleLineTupleTypeElements"] = 528] = "SingleLineTupleTypeElements";
      ListFormat2[ListFormat2["MultiLineTupleTypeElements"] = 657] = "MultiLineTupleTypeElements";
      ListFormat2[ListFormat2["UnionTypeConstituents"] = 516] = "UnionTypeConstituents";
      ListFormat2[ListFormat2["IntersectionTypeConstituents"] = 520] = "IntersectionTypeConstituents";
      ListFormat2[ListFormat2["ObjectBindingPatternElements"] = 525136] = "ObjectBindingPatternElements";
      ListFormat2[ListFormat2["ArrayBindingPatternElements"] = 524880] = "ArrayBindingPatternElements";
      ListFormat2[ListFormat2["ObjectLiteralExpressionProperties"] = 526226] = "ObjectLiteralExpressionProperties";
      ListFormat2[ListFormat2["ImportClauseEntries"] = 526226] = "ImportClauseEntries";
      ListFormat2[ListFormat2["ArrayLiteralExpressionElements"] = 8914] = "ArrayLiteralExpressionElements";
      ListFormat2[ListFormat2["CommaListElements"] = 528] = "CommaListElements";
      ListFormat2[ListFormat2["CallExpressionArguments"] = 2576] = "CallExpressionArguments";
      ListFormat2[ListFormat2["NewExpressionArguments"] = 18960] = "NewExpressionArguments";
      ListFormat2[ListFormat2["TemplateExpressionSpans"] = 262144] = "TemplateExpressionSpans";
      ListFormat2[ListFormat2["SingleLineBlockStatements"] = 768] = "SingleLineBlockStatements";
      ListFormat2[ListFormat2["MultiLineBlockStatements"] = 129] = "MultiLineBlockStatements";
      ListFormat2[ListFormat2["VariableDeclarationList"] = 528] = "VariableDeclarationList";
      ListFormat2[ListFormat2["SingleLineFunctionBodyStatements"] = 768] = "SingleLineFunctionBodyStatements";
      ListFormat2[ListFormat2["MultiLineFunctionBodyStatements"] = 1] = "MultiLineFunctionBodyStatements";
      ListFormat2[ListFormat2["ClassHeritageClauses"] = 0] = "ClassHeritageClauses";
      ListFormat2[ListFormat2["ClassMembers"] = 129] = "ClassMembers";
      ListFormat2[ListFormat2["InterfaceMembers"] = 129] = "InterfaceMembers";
      ListFormat2[ListFormat2["EnumMembers"] = 145] = "EnumMembers";
      ListFormat2[ListFormat2["CaseBlockClauses"] = 129] = "CaseBlockClauses";
      ListFormat2[ListFormat2["NamedImportsOrExportsElements"] = 525136] = "NamedImportsOrExportsElements";
      ListFormat2[ListFormat2["JsxElementOrFragmentChildren"] = 262144] = "JsxElementOrFragmentChildren";
      ListFormat2[ListFormat2["JsxElementAttributes"] = 262656] = "JsxElementAttributes";
      ListFormat2[ListFormat2["CaseOrDefaultClauseStatements"] = 163969] = "CaseOrDefaultClauseStatements";
      ListFormat2[ListFormat2["HeritageClauseTypes"] = 528] = "HeritageClauseTypes";
      ListFormat2[ListFormat2["SourceFileStatements"] = 131073] = "SourceFileStatements";
      ListFormat2[ListFormat2["Decorators"] = 2146305] = "Decorators";
      ListFormat2[ListFormat2["TypeArguments"] = 53776] = "TypeArguments";
      ListFormat2[ListFormat2["TypeParameters"] = 53776] = "TypeParameters";
      ListFormat2[ListFormat2["Parameters"] = 2576] = "Parameters";
      ListFormat2[ListFormat2["IndexSignatureParameters"] = 8848] = "IndexSignatureParameters";
      ListFormat2[ListFormat2["JSDocComment"] = 33] = "JSDocComment";
    })(ListFormat = ts2.ListFormat || (ts2.ListFormat = {}));
    var PragmaKindFlags;
    (function(PragmaKindFlags2) {
      PragmaKindFlags2[PragmaKindFlags2["None"] = 0] = "None";
      PragmaKindFlags2[PragmaKindFlags2["TripleSlashXML"] = 1] = "TripleSlashXML";
      PragmaKindFlags2[PragmaKindFlags2["SingleLine"] = 2] = "SingleLine";
      PragmaKindFlags2[PragmaKindFlags2["MultiLine"] = 4] = "MultiLine";
      PragmaKindFlags2[PragmaKindFlags2["All"] = 7] = "All";
      PragmaKindFlags2[PragmaKindFlags2["Default"] = 7] = "Default";
    })(PragmaKindFlags = ts2.PragmaKindFlags || (ts2.PragmaKindFlags = {}));
    ts2.commentPragmas = {
      reference: {
        args: [
          {name: "types", optional: true, captureSpan: true},
          {name: "lib", optional: true, captureSpan: true},
          {name: "path", optional: true, captureSpan: true},
          {name: "no-default-lib", optional: true}
        ],
        kind: 1
      },
      "amd-dependency": {
        args: [{name: "path"}, {name: "name", optional: true}],
        kind: 1
      },
      "amd-module": {
        args: [{name: "name"}],
        kind: 1
      },
      "ts-check": {
        kind: 2
      },
      "ts-nocheck": {
        kind: 2
      },
      jsx: {
        args: [{name: "factory"}],
        kind: 4
      },
      jsxfrag: {
        args: [{name: "factory"}],
        kind: 4
      },
      jsximportsource: {
        args: [{name: "factory"}],
        kind: 4
      },
      jsxruntime: {
        args: [{name: "factory"}],
        kind: 4
      }
    };
  })(ts || (ts = {}));
  (function(ts2) {
    ts2.directorySeparator = "/";
    ts2.altDirectorySeparator = "\\";
    var urlSchemeSeparator = "://";
    var backslashRegExp = /\\/g;
    function isAnyDirectorySeparator(charCode) {
      return charCode === 47 || charCode === 92;
    }
    ts2.isAnyDirectorySeparator = isAnyDirectorySeparator;
    function isUrl(path) {
      return getEncodedRootLength(path) < 0;
    }
    ts2.isUrl = isUrl;
    function isRootedDiskPath(path) {
      return getEncodedRootLength(path) > 0;
    }
    ts2.isRootedDiskPath = isRootedDiskPath;
    function isDiskPathRoot(path) {
      var rootLength = getEncodedRootLength(path);
      return rootLength > 0 && rootLength === path.length;
    }
    ts2.isDiskPathRoot = isDiskPathRoot;
    function pathIsAbsolute(path) {
      return getEncodedRootLength(path) !== 0;
    }
    ts2.pathIsAbsolute = pathIsAbsolute;
    function pathIsRelative(path) {
      return /^\.\.?($|[\\/])/.test(path);
    }
    ts2.pathIsRelative = pathIsRelative;
    function pathIsBareSpecifier(path) {
      return !pathIsAbsolute(path) && !pathIsRelative(path);
    }
    ts2.pathIsBareSpecifier = pathIsBareSpecifier;
    function hasExtension(fileName) {
      return ts2.stringContains(getBaseFileName(fileName), ".");
    }
    ts2.hasExtension = hasExtension;
    function fileExtensionIs(path, extension) {
      return path.length > extension.length && ts2.endsWith(path, extension);
    }
    ts2.fileExtensionIs = fileExtensionIs;
    function fileExtensionIsOneOf(path, extensions) {
      for (var _i = 0, extensions_1 = extensions; _i < extensions_1.length; _i++) {
        var extension = extensions_1[_i];
        if (fileExtensionIs(path, extension)) {
          return true;
        }
      }
      return false;
    }
    ts2.fileExtensionIsOneOf = fileExtensionIsOneOf;
    function hasTrailingDirectorySeparator(path) {
      return path.length > 0 && isAnyDirectorySeparator(path.charCodeAt(path.length - 1));
    }
    ts2.hasTrailingDirectorySeparator = hasTrailingDirectorySeparator;
    function isVolumeCharacter(charCode) {
      return charCode >= 97 && charCode <= 122 || charCode >= 65 && charCode <= 90;
    }
    function getFileUrlVolumeSeparatorEnd(url, start) {
      var ch0 = url.charCodeAt(start);
      if (ch0 === 58)
        return start + 1;
      if (ch0 === 37 && url.charCodeAt(start + 1) === 51) {
        var ch2 = url.charCodeAt(start + 2);
        if (ch2 === 97 || ch2 === 65)
          return start + 3;
      }
      return -1;
    }
    function getEncodedRootLength(path) {
      if (!path)
        return 0;
      var ch0 = path.charCodeAt(0);
      if (ch0 === 47 || ch0 === 92) {
        if (path.charCodeAt(1) !== ch0)
          return 1;
        var p1 = path.indexOf(ch0 === 47 ? ts2.directorySeparator : ts2.altDirectorySeparator, 2);
        if (p1 < 0)
          return path.length;
        return p1 + 1;
      }
      if (isVolumeCharacter(ch0) && path.charCodeAt(1) === 58) {
        var ch2 = path.charCodeAt(2);
        if (ch2 === 47 || ch2 === 92)
          return 3;
        if (path.length === 2)
          return 2;
      }
      var schemeEnd = path.indexOf(urlSchemeSeparator);
      if (schemeEnd !== -1) {
        var authorityStart = schemeEnd + urlSchemeSeparator.length;
        var authorityEnd = path.indexOf(ts2.directorySeparator, authorityStart);
        if (authorityEnd !== -1) {
          var scheme = path.slice(0, schemeEnd);
          var authority = path.slice(authorityStart, authorityEnd);
          if (scheme === "file" && (authority === "" || authority === "localhost") && isVolumeCharacter(path.charCodeAt(authorityEnd + 1))) {
            var volumeSeparatorEnd = getFileUrlVolumeSeparatorEnd(path, authorityEnd + 2);
            if (volumeSeparatorEnd !== -1) {
              if (path.charCodeAt(volumeSeparatorEnd) === 47) {
                return ~(volumeSeparatorEnd + 1);
              }
              if (volumeSeparatorEnd === path.length) {
                return ~volumeSeparatorEnd;
              }
            }
          }
          return ~(authorityEnd + 1);
        }
        return ~path.length;
      }
      return 0;
    }
    function getRootLength(path) {
      var rootLength = getEncodedRootLength(path);
      return rootLength < 0 ? ~rootLength : rootLength;
    }
    ts2.getRootLength = getRootLength;
    function getDirectoryPath(path) {
      path = normalizeSlashes(path);
      var rootLength = getRootLength(path);
      if (rootLength === path.length)
        return path;
      path = removeTrailingDirectorySeparator(path);
      return path.slice(0, Math.max(rootLength, path.lastIndexOf(ts2.directorySeparator)));
    }
    ts2.getDirectoryPath = getDirectoryPath;
    function getBaseFileName(path, extensions, ignoreCase) {
      path = normalizeSlashes(path);
      var rootLength = getRootLength(path);
      if (rootLength === path.length)
        return "";
      path = removeTrailingDirectorySeparator(path);
      var name = path.slice(Math.max(getRootLength(path), path.lastIndexOf(ts2.directorySeparator) + 1));
      var extension = extensions !== void 0 && ignoreCase !== void 0 ? getAnyExtensionFromPath(name, extensions, ignoreCase) : void 0;
      return extension ? name.slice(0, name.length - extension.length) : name;
    }
    ts2.getBaseFileName = getBaseFileName;
    function tryGetExtensionFromPath(path, extension, stringEqualityComparer) {
      if (!ts2.startsWith(extension, "."))
        extension = "." + extension;
      if (path.length >= extension.length && path.charCodeAt(path.length - extension.length) === 46) {
        var pathExtension = path.slice(path.length - extension.length);
        if (stringEqualityComparer(pathExtension, extension)) {
          return pathExtension;
        }
      }
    }
    function getAnyExtensionFromPathWorker(path, extensions, stringEqualityComparer) {
      if (typeof extensions === "string") {
        return tryGetExtensionFromPath(path, extensions, stringEqualityComparer) || "";
      }
      for (var _i = 0, extensions_2 = extensions; _i < extensions_2.length; _i++) {
        var extension = extensions_2[_i];
        var result = tryGetExtensionFromPath(path, extension, stringEqualityComparer);
        if (result)
          return result;
      }
      return "";
    }
    function getAnyExtensionFromPath(path, extensions, ignoreCase) {
      if (extensions) {
        return getAnyExtensionFromPathWorker(removeTrailingDirectorySeparator(path), extensions, ignoreCase ? ts2.equateStringsCaseInsensitive : ts2.equateStringsCaseSensitive);
      }
      var baseFileName = getBaseFileName(path);
      var extensionIndex = baseFileName.lastIndexOf(".");
      if (extensionIndex >= 0) {
        return baseFileName.substring(extensionIndex);
      }
      return "";
    }
    ts2.getAnyExtensionFromPath = getAnyExtensionFromPath;
    function pathComponents(path, rootLength) {
      var root = path.substring(0, rootLength);
      var rest = path.substring(rootLength).split(ts2.directorySeparator);
      if (rest.length && !ts2.lastOrUndefined(rest))
        rest.pop();
      return __spreadArray([root], rest, true);
    }
    function getPathComponents(path, currentDirectory) {
      if (currentDirectory === void 0) {
        currentDirectory = "";
      }
      path = combinePaths(currentDirectory, path);
      return pathComponents(path, getRootLength(path));
    }
    ts2.getPathComponents = getPathComponents;
    function getPathFromPathComponents(pathComponents2) {
      if (pathComponents2.length === 0)
        return "";
      var root = pathComponents2[0] && ensureTrailingDirectorySeparator(pathComponents2[0]);
      return root + pathComponents2.slice(1).join(ts2.directorySeparator);
    }
    ts2.getPathFromPathComponents = getPathFromPathComponents;
    function normalizeSlashes(path) {
      var index = path.indexOf("\\");
      if (index === -1) {
        return path;
      }
      backslashRegExp.lastIndex = index;
      return path.replace(backslashRegExp, ts2.directorySeparator);
    }
    ts2.normalizeSlashes = normalizeSlashes;
    function reducePathComponents(components) {
      if (!ts2.some(components))
        return [];
      var reduced = [components[0]];
      for (var i = 1; i < components.length; i++) {
        var component = components[i];
        if (!component)
          continue;
        if (component === ".")
          continue;
        if (component === "..") {
          if (reduced.length > 1) {
            if (reduced[reduced.length - 1] !== "..") {
              reduced.pop();
              continue;
            }
          } else if (reduced[0])
            continue;
        }
        reduced.push(component);
      }
      return reduced;
    }
    ts2.reducePathComponents = reducePathComponents;
    function combinePaths(path) {
      var paths2 = [];
      for (var _i = 1; _i < arguments.length; _i++) {
        paths2[_i - 1] = arguments[_i];
      }
      if (path)
        path = normalizeSlashes(path);
      for (var _a3 = 0, paths_1 = paths2; _a3 < paths_1.length; _a3++) {
        var relativePath = paths_1[_a3];
        if (!relativePath)
          continue;
        relativePath = normalizeSlashes(relativePath);
        if (!path || getRootLength(relativePath) !== 0) {
          path = relativePath;
        } else {
          path = ensureTrailingDirectorySeparator(path) + relativePath;
        }
      }
      return path;
    }
    ts2.combinePaths = combinePaths;
    function resolvePath(path) {
      var paths2 = [];
      for (var _i = 1; _i < arguments.length; _i++) {
        paths2[_i - 1] = arguments[_i];
      }
      return normalizePath(ts2.some(paths2) ? combinePaths.apply(void 0, __spreadArray([path], paths2, false)) : normalizeSlashes(path));
    }
    ts2.resolvePath = resolvePath;
    function getNormalizedPathComponents(path, currentDirectory) {
      return reducePathComponents(getPathComponents(path, currentDirectory));
    }
    ts2.getNormalizedPathComponents = getNormalizedPathComponents;
    function getNormalizedAbsolutePath(fileName, currentDirectory) {
      return getPathFromPathComponents(getNormalizedPathComponents(fileName, currentDirectory));
    }
    ts2.getNormalizedAbsolutePath = getNormalizedAbsolutePath;
    function normalizePath(path) {
      path = normalizeSlashes(path);
      if (!relativePathSegmentRegExp.test(path)) {
        return path;
      }
      var simplified = path.replace(/\/\.\//g, "/").replace(/^\.\//, "");
      if (simplified !== path) {
        path = simplified;
        if (!relativePathSegmentRegExp.test(path)) {
          return path;
        }
      }
      var normalized = getPathFromPathComponents(reducePathComponents(getPathComponents(path)));
      return normalized && hasTrailingDirectorySeparator(path) ? ensureTrailingDirectorySeparator(normalized) : normalized;
    }
    ts2.normalizePath = normalizePath;
    function getPathWithoutRoot(pathComponents2) {
      if (pathComponents2.length === 0)
        return "";
      return pathComponents2.slice(1).join(ts2.directorySeparator);
    }
    function getNormalizedAbsolutePathWithoutRoot(fileName, currentDirectory) {
      return getPathWithoutRoot(getNormalizedPathComponents(fileName, currentDirectory));
    }
    ts2.getNormalizedAbsolutePathWithoutRoot = getNormalizedAbsolutePathWithoutRoot;
    function toPath(fileName, basePath, getCanonicalFileName) {
      var nonCanonicalizedPath = isRootedDiskPath(fileName) ? normalizePath(fileName) : getNormalizedAbsolutePath(fileName, basePath);
      return getCanonicalFileName(nonCanonicalizedPath);
    }
    ts2.toPath = toPath;
    function normalizePathAndParts(path) {
      path = normalizeSlashes(path);
      var _a3 = reducePathComponents(getPathComponents(path)), root = _a3[0], parts = _a3.slice(1);
      if (parts.length) {
        var joinedParts = root + parts.join(ts2.directorySeparator);
        return {path: hasTrailingDirectorySeparator(path) ? ensureTrailingDirectorySeparator(joinedParts) : joinedParts, parts};
      } else {
        return {path: root, parts};
      }
    }
    ts2.normalizePathAndParts = normalizePathAndParts;
    function removeTrailingDirectorySeparator(path) {
      if (hasTrailingDirectorySeparator(path)) {
        return path.substr(0, path.length - 1);
      }
      return path;
    }
    ts2.removeTrailingDirectorySeparator = removeTrailingDirectorySeparator;
    function ensureTrailingDirectorySeparator(path) {
      if (!hasTrailingDirectorySeparator(path)) {
        return path + ts2.directorySeparator;
      }
      return path;
    }
    ts2.ensureTrailingDirectorySeparator = ensureTrailingDirectorySeparator;
    function ensurePathIsNonModuleName(path) {
      return !pathIsAbsolute(path) && !pathIsRelative(path) ? "./" + path : path;
    }
    ts2.ensurePathIsNonModuleName = ensurePathIsNonModuleName;
    function changeAnyExtension(path, ext, extensions, ignoreCase) {
      var pathext = extensions !== void 0 && ignoreCase !== void 0 ? getAnyExtensionFromPath(path, extensions, ignoreCase) : getAnyExtensionFromPath(path);
      return pathext ? path.slice(0, path.length - pathext.length) + (ts2.startsWith(ext, ".") ? ext : "." + ext) : path;
    }
    ts2.changeAnyExtension = changeAnyExtension;
    var relativePathSegmentRegExp = /(?:\/\/)|(?:^|\/)\.\.?(?:$|\/)/;
    function comparePathsWorker(a, b, componentComparer) {
      if (a === b)
        return 0;
      if (a === void 0)
        return -1;
      if (b === void 0)
        return 1;
      var aRoot = a.substring(0, getRootLength(a));
      var bRoot = b.substring(0, getRootLength(b));
      var result = ts2.compareStringsCaseInsensitive(aRoot, bRoot);
      if (result !== 0) {
        return result;
      }
      var aRest = a.substring(aRoot.length);
      var bRest = b.substring(bRoot.length);
      if (!relativePathSegmentRegExp.test(aRest) && !relativePathSegmentRegExp.test(bRest)) {
        return componentComparer(aRest, bRest);
      }
      var aComponents = reducePathComponents(getPathComponents(a));
      var bComponents = reducePathComponents(getPathComponents(b));
      var sharedLength = Math.min(aComponents.length, bComponents.length);
      for (var i = 1; i < sharedLength; i++) {
        var result_2 = componentComparer(aComponents[i], bComponents[i]);
        if (result_2 !== 0) {
          return result_2;
        }
      }
      return ts2.compareValues(aComponents.length, bComponents.length);
    }
    function comparePathsCaseSensitive(a, b) {
      return comparePathsWorker(a, b, ts2.compareStringsCaseSensitive);
    }
    ts2.comparePathsCaseSensitive = comparePathsCaseSensitive;
    function comparePathsCaseInsensitive(a, b) {
      return comparePathsWorker(a, b, ts2.compareStringsCaseInsensitive);
    }
    ts2.comparePathsCaseInsensitive = comparePathsCaseInsensitive;
    function comparePaths(a, b, currentDirectory, ignoreCase) {
      if (typeof currentDirectory === "string") {
        a = combinePaths(currentDirectory, a);
        b = combinePaths(currentDirectory, b);
      } else if (typeof currentDirectory === "boolean") {
        ignoreCase = currentDirectory;
      }
      return comparePathsWorker(a, b, ts2.getStringComparer(ignoreCase));
    }
    ts2.comparePaths = comparePaths;
    function containsPath(parent, child, currentDirectory, ignoreCase) {
      if (typeof currentDirectory === "string") {
        parent = combinePaths(currentDirectory, parent);
        child = combinePaths(currentDirectory, child);
      } else if (typeof currentDirectory === "boolean") {
        ignoreCase = currentDirectory;
      }
      if (parent === void 0 || child === void 0)
        return false;
      if (parent === child)
        return true;
      var parentComponents = reducePathComponents(getPathComponents(parent));
      var childComponents = reducePathComponents(getPathComponents(child));
      if (childComponents.length < parentComponents.length) {
        return false;
      }
      var componentEqualityComparer = ignoreCase ? ts2.equateStringsCaseInsensitive : ts2.equateStringsCaseSensitive;
      for (var i = 0; i < parentComponents.length; i++) {
        var equalityComparer = i === 0 ? ts2.equateStringsCaseInsensitive : componentEqualityComparer;
        if (!equalityComparer(parentComponents[i], childComponents[i])) {
          return false;
        }
      }
      return true;
    }
    ts2.containsPath = containsPath;
    function startsWithDirectory(fileName, directoryName, getCanonicalFileName) {
      var canonicalFileName = getCanonicalFileName(fileName);
      var canonicalDirectoryName = getCanonicalFileName(directoryName);
      return ts2.startsWith(canonicalFileName, canonicalDirectoryName + "/") || ts2.startsWith(canonicalFileName, canonicalDirectoryName + "\\");
    }
    ts2.startsWithDirectory = startsWithDirectory;
    function getPathComponentsRelativeTo(from, to, stringEqualityComparer, getCanonicalFileName) {
      var fromComponents = reducePathComponents(getPathComponents(from));
      var toComponents = reducePathComponents(getPathComponents(to));
      var start;
      for (start = 0; start < fromComponents.length && start < toComponents.length; start++) {
        var fromComponent = getCanonicalFileName(fromComponents[start]);
        var toComponent = getCanonicalFileName(toComponents[start]);
        var comparer = start === 0 ? ts2.equateStringsCaseInsensitive : stringEqualityComparer;
        if (!comparer(fromComponent, toComponent))
          break;
      }
      if (start === 0) {
        return toComponents;
      }
      var components = toComponents.slice(start);
      var relative2 = [];
      for (; start < fromComponents.length; start++) {
        relative2.push("..");
      }
      return __spreadArray(__spreadArray([""], relative2, true), components, true);
    }
    ts2.getPathComponentsRelativeTo = getPathComponentsRelativeTo;
    function getRelativePathFromDirectory(fromDirectory, to, getCanonicalFileNameOrIgnoreCase) {
      ts2.Debug.assert(getRootLength(fromDirectory) > 0 === getRootLength(to) > 0, "Paths must either both be absolute or both be relative");
      var getCanonicalFileName = typeof getCanonicalFileNameOrIgnoreCase === "function" ? getCanonicalFileNameOrIgnoreCase : ts2.identity;
      var ignoreCase = typeof getCanonicalFileNameOrIgnoreCase === "boolean" ? getCanonicalFileNameOrIgnoreCase : false;
      var pathComponents2 = getPathComponentsRelativeTo(fromDirectory, to, ignoreCase ? ts2.equateStringsCaseInsensitive : ts2.equateStringsCaseSensitive, getCanonicalFileName);
      return getPathFromPathComponents(pathComponents2);
    }
    ts2.getRelativePathFromDirectory = getRelativePathFromDirectory;
    function convertToRelativePath(absoluteOrRelativePath, basePath, getCanonicalFileName) {
      return !isRootedDiskPath(absoluteOrRelativePath) ? absoluteOrRelativePath : getRelativePathToDirectoryOrUrl(basePath, absoluteOrRelativePath, basePath, getCanonicalFileName, false);
    }
    ts2.convertToRelativePath = convertToRelativePath;
    function getRelativePathFromFile(from, to, getCanonicalFileName) {
      return ensurePathIsNonModuleName(getRelativePathFromDirectory(getDirectoryPath(from), to, getCanonicalFileName));
    }
    ts2.getRelativePathFromFile = getRelativePathFromFile;
    function getRelativePathToDirectoryOrUrl(directoryPathOrUrl, relativeOrAbsolutePath, currentDirectory, getCanonicalFileName, isAbsolutePathAnUrl) {
      var pathComponents2 = getPathComponentsRelativeTo(resolvePath(currentDirectory, directoryPathOrUrl), resolvePath(currentDirectory, relativeOrAbsolutePath), ts2.equateStringsCaseSensitive, getCanonicalFileName);
      var firstComponent = pathComponents2[0];
      if (isAbsolutePathAnUrl && isRootedDiskPath(firstComponent)) {
        var prefix = firstComponent.charAt(0) === ts2.directorySeparator ? "file://" : "file:///";
        pathComponents2[0] = prefix + firstComponent;
      }
      return getPathFromPathComponents(pathComponents2);
    }
    ts2.getRelativePathToDirectoryOrUrl = getRelativePathToDirectoryOrUrl;
    function forEachAncestorDirectory(directory, callback) {
      while (true) {
        var result = callback(directory);
        if (result !== void 0) {
          return result;
        }
        var parentPath = getDirectoryPath(directory);
        if (parentPath === directory) {
          return void 0;
        }
        directory = parentPath;
      }
    }
    ts2.forEachAncestorDirectory = forEachAncestorDirectory;
    function isNodeModulesDirectory(dirPath) {
      return ts2.endsWith(dirPath, "/node_modules");
    }
    ts2.isNodeModulesDirectory = isNodeModulesDirectory;
  })(ts || (ts = {}));
  (function(ts2) {
    function generateDjb2Hash(data) {
      var acc = 5381;
      for (var i = 0; i < data.length; i++) {
        acc = (acc << 5) + acc + data.charCodeAt(i);
      }
      return acc.toString();
    }
    ts2.generateDjb2Hash = generateDjb2Hash;
    function setStackTraceLimit() {
      if (Error.stackTraceLimit < 100) {
        Error.stackTraceLimit = 100;
      }
    }
    ts2.setStackTraceLimit = setStackTraceLimit;
    var FileWatcherEventKind;
    (function(FileWatcherEventKind2) {
      FileWatcherEventKind2[FileWatcherEventKind2["Created"] = 0] = "Created";
      FileWatcherEventKind2[FileWatcherEventKind2["Changed"] = 1] = "Changed";
      FileWatcherEventKind2[FileWatcherEventKind2["Deleted"] = 2] = "Deleted";
    })(FileWatcherEventKind = ts2.FileWatcherEventKind || (ts2.FileWatcherEventKind = {}));
    var PollingInterval;
    (function(PollingInterval2) {
      PollingInterval2[PollingInterval2["High"] = 2e3] = "High";
      PollingInterval2[PollingInterval2["Medium"] = 500] = "Medium";
      PollingInterval2[PollingInterval2["Low"] = 250] = "Low";
    })(PollingInterval = ts2.PollingInterval || (ts2.PollingInterval = {}));
    ts2.missingFileModifiedTime = new Date(0);
    function getModifiedTime(host, fileName) {
      return host.getModifiedTime(fileName) || ts2.missingFileModifiedTime;
    }
    ts2.getModifiedTime = getModifiedTime;
    function createPollingIntervalBasedLevels(levels) {
      var _a3;
      return _a3 = {}, _a3[PollingInterval.Low] = levels.Low, _a3[PollingInterval.Medium] = levels.Medium, _a3[PollingInterval.High] = levels.High, _a3;
    }
    var defaultChunkLevels = {Low: 32, Medium: 64, High: 256};
    var pollingChunkSize = createPollingIntervalBasedLevels(defaultChunkLevels);
    ts2.unchangedPollThresholds = createPollingIntervalBasedLevels(defaultChunkLevels);
    function setCustomPollingValues(system) {
      if (!system.getEnvironmentVariable) {
        return;
      }
      var pollingIntervalChanged = setCustomLevels("TSC_WATCH_POLLINGINTERVAL", PollingInterval);
      pollingChunkSize = getCustomPollingBasedLevels("TSC_WATCH_POLLINGCHUNKSIZE", defaultChunkLevels) || pollingChunkSize;
      ts2.unchangedPollThresholds = getCustomPollingBasedLevels("TSC_WATCH_UNCHANGEDPOLLTHRESHOLDS", defaultChunkLevels) || ts2.unchangedPollThresholds;
      function getLevel(envVar, level) {
        return system.getEnvironmentVariable("".concat(envVar, "_").concat(level.toUpperCase()));
      }
      function getCustomLevels(baseVariable) {
        var customLevels;
        setCustomLevel("Low");
        setCustomLevel("Medium");
        setCustomLevel("High");
        return customLevels;
        function setCustomLevel(level) {
          var customLevel = getLevel(baseVariable, level);
          if (customLevel) {
            (customLevels || (customLevels = {}))[level] = Number(customLevel);
          }
        }
      }
      function setCustomLevels(baseVariable, levels) {
        var customLevels = getCustomLevels(baseVariable);
        if (customLevels) {
          setLevel("Low");
          setLevel("Medium");
          setLevel("High");
          return true;
        }
        return false;
        function setLevel(level) {
          levels[level] = customLevels[level] || levels[level];
        }
      }
      function getCustomPollingBasedLevels(baseVariable, defaultLevels) {
        var customLevels = getCustomLevels(baseVariable);
        return (pollingIntervalChanged || customLevels) && createPollingIntervalBasedLevels(customLevels ? __assign(__assign({}, defaultLevels), customLevels) : defaultLevels);
      }
    }
    ts2.setCustomPollingValues = setCustomPollingValues;
    function pollWatchedFileQueue(host, queue, pollIndex, chunkSize, callbackOnWatchFileStat) {
      var definedValueCopyToIndex = pollIndex;
      for (var canVisit = queue.length; chunkSize && canVisit; nextPollIndex(), canVisit--) {
        var watchedFile = queue[pollIndex];
        if (!watchedFile) {
          continue;
        } else if (watchedFile.isClosed) {
          queue[pollIndex] = void 0;
          continue;
        }
        chunkSize--;
        var fileChanged = onWatchedFileStat(watchedFile, getModifiedTime(host, watchedFile.fileName));
        if (watchedFile.isClosed) {
          queue[pollIndex] = void 0;
          continue;
        }
        callbackOnWatchFileStat === null || callbackOnWatchFileStat === void 0 ? void 0 : callbackOnWatchFileStat(watchedFile, pollIndex, fileChanged);
        if (queue[pollIndex]) {
          if (definedValueCopyToIndex < pollIndex) {
            queue[definedValueCopyToIndex] = watchedFile;
            queue[pollIndex] = void 0;
          }
          definedValueCopyToIndex++;
        }
      }
      return pollIndex;
      function nextPollIndex() {
        pollIndex++;
        if (pollIndex === queue.length) {
          if (definedValueCopyToIndex < pollIndex) {
            queue.length = definedValueCopyToIndex;
          }
          pollIndex = 0;
          definedValueCopyToIndex = 0;
        }
      }
    }
    function createDynamicPriorityPollingWatchFile(host) {
      var watchedFiles = [];
      var changedFilesInLastPoll = [];
      var lowPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.Low);
      var mediumPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.Medium);
      var highPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.High);
      return watchFile;
      function watchFile(fileName, callback, defaultPollingInterval) {
        var file = {
          fileName,
          callback,
          unchangedPolls: 0,
          mtime: getModifiedTime(host, fileName)
        };
        watchedFiles.push(file);
        addToPollingIntervalQueue(file, defaultPollingInterval);
        return {
          close: function() {
            file.isClosed = true;
            ts2.unorderedRemoveItem(watchedFiles, file);
          }
        };
      }
      function createPollingIntervalQueue(pollingInterval) {
        var queue = [];
        queue.pollingInterval = pollingInterval;
        queue.pollIndex = 0;
        queue.pollScheduled = false;
        return queue;
      }
      function pollPollingIntervalQueue(queue) {
        queue.pollIndex = pollQueue(queue, queue.pollingInterval, queue.pollIndex, pollingChunkSize[queue.pollingInterval]);
        if (queue.length) {
          scheduleNextPoll(queue.pollingInterval);
        } else {
          ts2.Debug.assert(queue.pollIndex === 0);
          queue.pollScheduled = false;
        }
      }
      function pollLowPollingIntervalQueue(queue) {
        pollQueue(changedFilesInLastPoll, PollingInterval.Low, 0, changedFilesInLastPoll.length);
        pollPollingIntervalQueue(queue);
        if (!queue.pollScheduled && changedFilesInLastPoll.length) {
          scheduleNextPoll(PollingInterval.Low);
        }
      }
      function pollQueue(queue, pollingInterval, pollIndex, chunkSize) {
        return pollWatchedFileQueue(host, queue, pollIndex, chunkSize, onWatchFileStat);
        function onWatchFileStat(watchedFile, pollIndex2, fileChanged) {
          if (fileChanged) {
            watchedFile.unchangedPolls = 0;
            if (queue !== changedFilesInLastPoll) {
              queue[pollIndex2] = void 0;
              addChangedFileToLowPollingIntervalQueue(watchedFile);
            }
          } else if (watchedFile.unchangedPolls !== ts2.unchangedPollThresholds[pollingInterval]) {
            watchedFile.unchangedPolls++;
          } else if (queue === changedFilesInLastPoll) {
            watchedFile.unchangedPolls = 1;
            queue[pollIndex2] = void 0;
            addToPollingIntervalQueue(watchedFile, PollingInterval.Low);
          } else if (pollingInterval !== PollingInterval.High) {
            watchedFile.unchangedPolls++;
            queue[pollIndex2] = void 0;
            addToPollingIntervalQueue(watchedFile, pollingInterval === PollingInterval.Low ? PollingInterval.Medium : PollingInterval.High);
          }
        }
      }
      function pollingIntervalQueue(pollingInterval) {
        switch (pollingInterval) {
          case PollingInterval.Low:
            return lowPollingIntervalQueue;
          case PollingInterval.Medium:
            return mediumPollingIntervalQueue;
          case PollingInterval.High:
            return highPollingIntervalQueue;
        }
      }
      function addToPollingIntervalQueue(file, pollingInterval) {
        pollingIntervalQueue(pollingInterval).push(file);
        scheduleNextPollIfNotAlreadyScheduled(pollingInterval);
      }
      function addChangedFileToLowPollingIntervalQueue(file) {
        changedFilesInLastPoll.push(file);
        scheduleNextPollIfNotAlreadyScheduled(PollingInterval.Low);
      }
      function scheduleNextPollIfNotAlreadyScheduled(pollingInterval) {
        if (!pollingIntervalQueue(pollingInterval).pollScheduled) {
          scheduleNextPoll(pollingInterval);
        }
      }
      function scheduleNextPoll(pollingInterval) {
        pollingIntervalQueue(pollingInterval).pollScheduled = host.setTimeout(pollingInterval === PollingInterval.Low ? pollLowPollingIntervalQueue : pollPollingIntervalQueue, pollingInterval, pollingIntervalQueue(pollingInterval));
      }
    }
    ts2.createDynamicPriorityPollingWatchFile = createDynamicPriorityPollingWatchFile;
    function createUseFsEventsOnParentDirectoryWatchFile(fsWatch, useCaseSensitiveFileNames) {
      var fileWatcherCallbacks = ts2.createMultiMap();
      var dirWatchers = new ts2.Map();
      var toCanonicalName = ts2.createGetCanonicalFileName(useCaseSensitiveFileNames);
      return nonPollingWatchFile;
      function nonPollingWatchFile(fileName, callback, _pollingInterval, fallbackOptions) {
        var filePath = toCanonicalName(fileName);
        fileWatcherCallbacks.add(filePath, callback);
        var dirPath = ts2.getDirectoryPath(filePath) || ".";
        var watcher = dirWatchers.get(dirPath) || createDirectoryWatcher(ts2.getDirectoryPath(fileName) || ".", dirPath, fallbackOptions);
        watcher.referenceCount++;
        return {
          close: function() {
            if (watcher.referenceCount === 1) {
              watcher.close();
              dirWatchers.delete(dirPath);
            } else {
              watcher.referenceCount--;
            }
            fileWatcherCallbacks.remove(filePath, callback);
          }
        };
      }
      function createDirectoryWatcher(dirName, dirPath, fallbackOptions) {
        var watcher = fsWatch(dirName, 1, function(_eventName, relativeFileName) {
          if (!ts2.isString(relativeFileName))
            return;
          var fileName = ts2.getNormalizedAbsolutePath(relativeFileName, dirName);
          var callbacks = fileName && fileWatcherCallbacks.get(toCanonicalName(fileName));
          if (callbacks) {
            for (var _i = 0, callbacks_1 = callbacks; _i < callbacks_1.length; _i++) {
              var fileCallback = callbacks_1[_i];
              fileCallback(fileName, FileWatcherEventKind.Changed);
            }
          }
        }, false, PollingInterval.Medium, fallbackOptions);
        watcher.referenceCount = 0;
        dirWatchers.set(dirPath, watcher);
        return watcher;
      }
    }
    function createFixedChunkSizePollingWatchFile(host) {
      var watchedFiles = [];
      var pollIndex = 0;
      var pollScheduled;
      return watchFile;
      function watchFile(fileName, callback) {
        var file = {
          fileName,
          callback,
          mtime: getModifiedTime(host, fileName)
        };
        watchedFiles.push(file);
        scheduleNextPoll();
        return {
          close: function() {
            file.isClosed = true;
            ts2.unorderedRemoveItem(watchedFiles, file);
          }
        };
      }
      function pollQueue() {
        pollScheduled = void 0;
        pollIndex = pollWatchedFileQueue(host, watchedFiles, pollIndex, pollingChunkSize[PollingInterval.Low]);
        scheduleNextPoll();
      }
      function scheduleNextPoll() {
        if (!watchedFiles.length || pollScheduled)
          return;
        pollScheduled = host.setTimeout(pollQueue, PollingInterval.High);
      }
    }
    function createSingleFileWatcherPerName(watchFile, useCaseSensitiveFileNames) {
      var cache = new ts2.Map();
      var callbacksCache = ts2.createMultiMap();
      var toCanonicalFileName = ts2.createGetCanonicalFileName(useCaseSensitiveFileNames);
      return function(fileName, callback, pollingInterval, options) {
        var path = toCanonicalFileName(fileName);
        var existing = cache.get(path);
        if (existing) {
          existing.refCount++;
        } else {
          cache.set(path, {
            watcher: watchFile(fileName, function(fileName2, eventKind) {
              return ts2.forEach(callbacksCache.get(path), function(cb) {
                return cb(fileName2, eventKind);
              });
            }, pollingInterval, options),
            refCount: 1
          });
        }
        callbacksCache.add(path, callback);
        return {
          close: function() {
            var watcher = ts2.Debug.checkDefined(cache.get(path));
            callbacksCache.remove(path, callback);
            watcher.refCount--;
            if (watcher.refCount)
              return;
            cache.delete(path);
            ts2.closeFileWatcherOf(watcher);
          }
        };
      };
    }
    ts2.createSingleFileWatcherPerName = createSingleFileWatcherPerName;
    function onWatchedFileStat(watchedFile, modifiedTime) {
      var oldTime = watchedFile.mtime.getTime();
      var newTime = modifiedTime.getTime();
      if (oldTime !== newTime) {
        watchedFile.mtime = modifiedTime;
        watchedFile.callback(watchedFile.fileName, getFileWatcherEventKind(oldTime, newTime));
        return true;
      }
      return false;
    }
    ts2.onWatchedFileStat = onWatchedFileStat;
    function getFileWatcherEventKind(oldTime, newTime) {
      return oldTime === 0 ? FileWatcherEventKind.Created : newTime === 0 ? FileWatcherEventKind.Deleted : FileWatcherEventKind.Changed;
    }
    ts2.getFileWatcherEventKind = getFileWatcherEventKind;
    ts2.ignoredPaths = ["/node_modules/.", "/.git", "/.#"];
    ts2.sysLog = ts2.noop;
    function setSysLog(logger) {
      ts2.sysLog = logger;
    }
    ts2.setSysLog = setSysLog;
    function createDirectoryWatcherSupportingRecursive(_a3) {
      var watchDirectory = _a3.watchDirectory, useCaseSensitiveFileNames = _a3.useCaseSensitiveFileNames, getCurrentDirectory = _a3.getCurrentDirectory, getAccessibleSortedChildDirectories = _a3.getAccessibleSortedChildDirectories, directoryExists = _a3.directoryExists, realpath = _a3.realpath, setTimeout2 = _a3.setTimeout, clearTimeout2 = _a3.clearTimeout;
      var cache = new ts2.Map();
      var callbackCache = ts2.createMultiMap();
      var cacheToUpdateChildWatches = new ts2.Map();
      var timerToUpdateChildWatches;
      var filePathComparer = ts2.getStringComparer(!useCaseSensitiveFileNames);
      var toCanonicalFilePath = ts2.createGetCanonicalFileName(useCaseSensitiveFileNames);
      return function(dirName, callback, recursive, options) {
        return recursive ? createDirectoryWatcher(dirName, options, callback) : watchDirectory(dirName, callback, recursive, options);
      };
      function createDirectoryWatcher(dirName, options, callback) {
        var dirPath = toCanonicalFilePath(dirName);
        var directoryWatcher = cache.get(dirPath);
        if (directoryWatcher) {
          directoryWatcher.refCount++;
        } else {
          directoryWatcher = {
            watcher: watchDirectory(dirName, function(fileName) {
              if (isIgnoredPath(fileName, options))
                return;
              if (options === null || options === void 0 ? void 0 : options.synchronousWatchDirectory) {
                invokeCallbacks(dirPath, fileName);
                updateChildWatches(dirName, dirPath, options);
              } else {
                nonSyncUpdateChildWatches(dirName, dirPath, fileName, options);
              }
            }, false, options),
            refCount: 1,
            childWatches: ts2.emptyArray
          };
          cache.set(dirPath, directoryWatcher);
          updateChildWatches(dirName, dirPath, options);
        }
        var callbackToAdd = callback && {dirName, callback};
        if (callbackToAdd) {
          callbackCache.add(dirPath, callbackToAdd);
        }
        return {
          dirName,
          close: function() {
            var directoryWatcher2 = ts2.Debug.checkDefined(cache.get(dirPath));
            if (callbackToAdd)
              callbackCache.remove(dirPath, callbackToAdd);
            directoryWatcher2.refCount--;
            if (directoryWatcher2.refCount)
              return;
            cache.delete(dirPath);
            ts2.closeFileWatcherOf(directoryWatcher2);
            directoryWatcher2.childWatches.forEach(ts2.closeFileWatcher);
          }
        };
      }
      function invokeCallbacks(dirPath, fileNameOrInvokeMap, fileNames) {
        var fileName;
        var invokeMap;
        if (ts2.isString(fileNameOrInvokeMap)) {
          fileName = fileNameOrInvokeMap;
        } else {
          invokeMap = fileNameOrInvokeMap;
        }
        callbackCache.forEach(function(callbacks, rootDirName) {
          var _a22;
          if (invokeMap && invokeMap.get(rootDirName) === true)
            return;
          if (rootDirName === dirPath || ts2.startsWith(dirPath, rootDirName) && dirPath[rootDirName.length] === ts2.directorySeparator) {
            if (invokeMap) {
              if (fileNames) {
                var existing = invokeMap.get(rootDirName);
                if (existing) {
                  (_a22 = existing).push.apply(_a22, fileNames);
                } else {
                  invokeMap.set(rootDirName, fileNames.slice());
                }
              } else {
                invokeMap.set(rootDirName, true);
              }
            } else {
              callbacks.forEach(function(_a32) {
                var callback = _a32.callback;
                return callback(fileName);
              });
            }
          }
        });
      }
      function nonSyncUpdateChildWatches(dirName, dirPath, fileName, options) {
        var parentWatcher = cache.get(dirPath);
        if (parentWatcher && directoryExists(dirName)) {
          scheduleUpdateChildWatches(dirName, dirPath, fileName, options);
          return;
        }
        invokeCallbacks(dirPath, fileName);
        removeChildWatches(parentWatcher);
      }
      function scheduleUpdateChildWatches(dirName, dirPath, fileName, options) {
        var existing = cacheToUpdateChildWatches.get(dirPath);
        if (existing) {
          existing.fileNames.push(fileName);
        } else {
          cacheToUpdateChildWatches.set(dirPath, {dirName, options, fileNames: [fileName]});
        }
        if (timerToUpdateChildWatches) {
          clearTimeout2(timerToUpdateChildWatches);
          timerToUpdateChildWatches = void 0;
        }
        timerToUpdateChildWatches = setTimeout2(onTimerToUpdateChildWatches, 1e3);
      }
      function onTimerToUpdateChildWatches() {
        timerToUpdateChildWatches = void 0;
        ts2.sysLog("sysLog:: onTimerToUpdateChildWatches:: ".concat(cacheToUpdateChildWatches.size));
        var start = ts2.timestamp();
        var invokeMap = new ts2.Map();
        while (!timerToUpdateChildWatches && cacheToUpdateChildWatches.size) {
          var result = cacheToUpdateChildWatches.entries().next();
          ts2.Debug.assert(!result.done);
          var _a22 = result.value, dirPath = _a22[0], _b = _a22[1], dirName = _b.dirName, options = _b.options, fileNames = _b.fileNames;
          cacheToUpdateChildWatches.delete(dirPath);
          var hasChanges = updateChildWatches(dirName, dirPath, options);
          invokeCallbacks(dirPath, invokeMap, hasChanges ? void 0 : fileNames);
        }
        ts2.sysLog("sysLog:: invokingWatchers:: Elapsed:: ".concat(ts2.timestamp() - start, "ms:: ").concat(cacheToUpdateChildWatches.size));
        callbackCache.forEach(function(callbacks, rootDirName) {
          var existing = invokeMap.get(rootDirName);
          if (existing) {
            callbacks.forEach(function(_a32) {
              var callback = _a32.callback, dirName2 = _a32.dirName;
              if (ts2.isArray(existing)) {
                existing.forEach(callback);
              } else {
                callback(dirName2);
              }
            });
          }
        });
        var elapsed = ts2.timestamp() - start;
        ts2.sysLog("sysLog:: Elapsed:: ".concat(elapsed, "ms:: onTimerToUpdateChildWatches:: ").concat(cacheToUpdateChildWatches.size, " ").concat(timerToUpdateChildWatches));
      }
      function removeChildWatches(parentWatcher) {
        if (!parentWatcher)
          return;
        var existingChildWatches = parentWatcher.childWatches;
        parentWatcher.childWatches = ts2.emptyArray;
        for (var _i = 0, existingChildWatches_1 = existingChildWatches; _i < existingChildWatches_1.length; _i++) {
          var childWatcher = existingChildWatches_1[_i];
          childWatcher.close();
          removeChildWatches(cache.get(toCanonicalFilePath(childWatcher.dirName)));
        }
      }
      function updateChildWatches(parentDir, parentDirPath, options) {
        var parentWatcher = cache.get(parentDirPath);
        if (!parentWatcher)
          return false;
        var newChildWatches;
        var hasChanges = ts2.enumerateInsertsAndDeletes(directoryExists(parentDir) ? ts2.mapDefined(getAccessibleSortedChildDirectories(parentDir), function(child) {
          var childFullName = ts2.getNormalizedAbsolutePath(child, parentDir);
          return !isIgnoredPath(childFullName, options) && filePathComparer(childFullName, ts2.normalizePath(realpath(childFullName))) === 0 ? childFullName : void 0;
        }) : ts2.emptyArray, parentWatcher.childWatches, function(child, childWatcher) {
          return filePathComparer(child, childWatcher.dirName);
        }, createAndAddChildDirectoryWatcher, ts2.closeFileWatcher, addChildDirectoryWatcher);
        parentWatcher.childWatches = newChildWatches || ts2.emptyArray;
        return hasChanges;
        function createAndAddChildDirectoryWatcher(childName) {
          var result = createDirectoryWatcher(childName, options);
          addChildDirectoryWatcher(result);
        }
        function addChildDirectoryWatcher(childWatcher) {
          (newChildWatches || (newChildWatches = [])).push(childWatcher);
        }
      }
      function isIgnoredPath(path, options) {
        return ts2.some(ts2.ignoredPaths, function(searchPath) {
          return isInPath(path, searchPath);
        }) || isIgnoredByWatchOptions(path, options, useCaseSensitiveFileNames, getCurrentDirectory);
      }
      function isInPath(path, searchPath) {
        if (ts2.stringContains(path, searchPath))
          return true;
        if (useCaseSensitiveFileNames)
          return false;
        return ts2.stringContains(toCanonicalFilePath(path), searchPath);
      }
    }
    ts2.createDirectoryWatcherSupportingRecursive = createDirectoryWatcherSupportingRecursive;
    var FileSystemEntryKind;
    (function(FileSystemEntryKind2) {
      FileSystemEntryKind2[FileSystemEntryKind2["File"] = 0] = "File";
      FileSystemEntryKind2[FileSystemEntryKind2["Directory"] = 1] = "Directory";
    })(FileSystemEntryKind = ts2.FileSystemEntryKind || (ts2.FileSystemEntryKind = {}));
    function createFileWatcherCallback(callback) {
      return function(_fileName, eventKind) {
        return callback(eventKind === FileWatcherEventKind.Changed ? "change" : "rename", "");
      };
    }
    ts2.createFileWatcherCallback = createFileWatcherCallback;
    function createFsWatchCallbackForFileWatcherCallback(fileName, callback, fileExists) {
      return function(eventName) {
        if (eventName === "rename") {
          callback(fileName, fileExists(fileName) ? FileWatcherEventKind.Created : FileWatcherEventKind.Deleted);
        } else {
          callback(fileName, FileWatcherEventKind.Changed);
        }
      };
    }
    function isIgnoredByWatchOptions(pathToCheck, options, useCaseSensitiveFileNames, getCurrentDirectory) {
      return ((options === null || options === void 0 ? void 0 : options.excludeDirectories) || (options === null || options === void 0 ? void 0 : options.excludeFiles)) && (ts2.matchesExclude(pathToCheck, options === null || options === void 0 ? void 0 : options.excludeFiles, useCaseSensitiveFileNames, getCurrentDirectory()) || ts2.matchesExclude(pathToCheck, options === null || options === void 0 ? void 0 : options.excludeDirectories, useCaseSensitiveFileNames, getCurrentDirectory()));
    }
    function createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback, options, useCaseSensitiveFileNames, getCurrentDirectory) {
      return function(eventName, relativeFileName) {
        if (eventName === "rename") {
          var fileName = !relativeFileName ? directoryName : ts2.normalizePath(ts2.combinePaths(directoryName, relativeFileName));
          if (!relativeFileName || !isIgnoredByWatchOptions(fileName, options, useCaseSensitiveFileNames, getCurrentDirectory)) {
            callback(fileName);
          }
        }
      };
    }
    function createSystemWatchFunctions(_a3) {
      var pollingWatchFile = _a3.pollingWatchFile, getModifiedTime2 = _a3.getModifiedTime, setTimeout2 = _a3.setTimeout, clearTimeout2 = _a3.clearTimeout, fsWatch = _a3.fsWatch, fileExists = _a3.fileExists, useCaseSensitiveFileNames = _a3.useCaseSensitiveFileNames, getCurrentDirectory = _a3.getCurrentDirectory, fsSupportsRecursiveFsWatch = _a3.fsSupportsRecursiveFsWatch, directoryExists = _a3.directoryExists, getAccessibleSortedChildDirectories = _a3.getAccessibleSortedChildDirectories, realpath = _a3.realpath, tscWatchFile = _a3.tscWatchFile, useNonPollingWatchers = _a3.useNonPollingWatchers, tscWatchDirectory = _a3.tscWatchDirectory, defaultWatchFileKind = _a3.defaultWatchFileKind;
      var dynamicPollingWatchFile;
      var fixedChunkSizePollingWatchFile;
      var nonPollingWatchFile;
      var hostRecursiveDirectoryWatcher;
      return {
        watchFile,
        watchDirectory
      };
      function watchFile(fileName, callback, pollingInterval, options) {
        options = updateOptionsForWatchFile(options, useNonPollingWatchers);
        var watchFileKind = ts2.Debug.checkDefined(options.watchFile);
        switch (watchFileKind) {
          case ts2.WatchFileKind.FixedPollingInterval:
            return pollingWatchFile(fileName, callback, PollingInterval.Low, void 0);
          case ts2.WatchFileKind.PriorityPollingInterval:
            return pollingWatchFile(fileName, callback, pollingInterval, void 0);
          case ts2.WatchFileKind.DynamicPriorityPolling:
            return ensureDynamicPollingWatchFile()(fileName, callback, pollingInterval, void 0);
          case ts2.WatchFileKind.FixedChunkSizePolling:
            return ensureFixedChunkSizePollingWatchFile()(fileName, callback, void 0, void 0);
          case ts2.WatchFileKind.UseFsEvents:
            return fsWatch(fileName, 0, createFsWatchCallbackForFileWatcherCallback(fileName, callback, fileExists), false, pollingInterval, ts2.getFallbackOptions(options));
          case ts2.WatchFileKind.UseFsEventsOnParentDirectory:
            if (!nonPollingWatchFile) {
              nonPollingWatchFile = createUseFsEventsOnParentDirectoryWatchFile(fsWatch, useCaseSensitiveFileNames);
            }
            return nonPollingWatchFile(fileName, callback, pollingInterval, ts2.getFallbackOptions(options));
          default:
            ts2.Debug.assertNever(watchFileKind);
        }
      }
      function ensureDynamicPollingWatchFile() {
        return dynamicPollingWatchFile || (dynamicPollingWatchFile = createDynamicPriorityPollingWatchFile({getModifiedTime: getModifiedTime2, setTimeout: setTimeout2}));
      }
      function ensureFixedChunkSizePollingWatchFile() {
        return fixedChunkSizePollingWatchFile || (fixedChunkSizePollingWatchFile = createFixedChunkSizePollingWatchFile({getModifiedTime: getModifiedTime2, setTimeout: setTimeout2}));
      }
      function updateOptionsForWatchFile(options, useNonPollingWatchers2) {
        if (options && options.watchFile !== void 0)
          return options;
        switch (tscWatchFile) {
          case "PriorityPollingInterval":
            return {watchFile: ts2.WatchFileKind.PriorityPollingInterval};
          case "DynamicPriorityPolling":
            return {watchFile: ts2.WatchFileKind.DynamicPriorityPolling};
          case "UseFsEvents":
            return generateWatchFileOptions(ts2.WatchFileKind.UseFsEvents, ts2.PollingWatchKind.PriorityInterval, options);
          case "UseFsEventsWithFallbackDynamicPolling":
            return generateWatchFileOptions(ts2.WatchFileKind.UseFsEvents, ts2.PollingWatchKind.DynamicPriority, options);
          case "UseFsEventsOnParentDirectory":
            useNonPollingWatchers2 = true;
          default:
            return useNonPollingWatchers2 ? generateWatchFileOptions(ts2.WatchFileKind.UseFsEventsOnParentDirectory, ts2.PollingWatchKind.PriorityInterval, options) : {watchFile: (defaultWatchFileKind === null || defaultWatchFileKind === void 0 ? void 0 : defaultWatchFileKind()) || ts2.WatchFileKind.FixedPollingInterval};
        }
      }
      function generateWatchFileOptions(watchFile2, fallbackPolling, options) {
        var defaultFallbackPolling = options === null || options === void 0 ? void 0 : options.fallbackPolling;
        return {
          watchFile: watchFile2,
          fallbackPolling: defaultFallbackPolling === void 0 ? fallbackPolling : defaultFallbackPolling
        };
      }
      function watchDirectory(directoryName, callback, recursive, options) {
        if (fsSupportsRecursiveFsWatch) {
          return fsWatch(directoryName, 1, createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback, options, useCaseSensitiveFileNames, getCurrentDirectory), recursive, PollingInterval.Medium, ts2.getFallbackOptions(options));
        }
        if (!hostRecursiveDirectoryWatcher) {
          hostRecursiveDirectoryWatcher = createDirectoryWatcherSupportingRecursive({
            useCaseSensitiveFileNames,
            getCurrentDirectory,
            directoryExists,
            getAccessibleSortedChildDirectories,
            watchDirectory: nonRecursiveWatchDirectory,
            realpath,
            setTimeout: setTimeout2,
            clearTimeout: clearTimeout2
          });
        }
        return hostRecursiveDirectoryWatcher(directoryName, callback, recursive, options);
      }
      function nonRecursiveWatchDirectory(directoryName, callback, recursive, options) {
        ts2.Debug.assert(!recursive);
        var watchDirectoryOptions = updateOptionsForWatchDirectory(options);
        var watchDirectoryKind = ts2.Debug.checkDefined(watchDirectoryOptions.watchDirectory);
        switch (watchDirectoryKind) {
          case ts2.WatchDirectoryKind.FixedPollingInterval:
            return pollingWatchFile(directoryName, function() {
              return callback(directoryName);
            }, PollingInterval.Medium, void 0);
          case ts2.WatchDirectoryKind.DynamicPriorityPolling:
            return ensureDynamicPollingWatchFile()(directoryName, function() {
              return callback(directoryName);
            }, PollingInterval.Medium, void 0);
          case ts2.WatchDirectoryKind.FixedChunkSizePolling:
            return ensureFixedChunkSizePollingWatchFile()(directoryName, function() {
              return callback(directoryName);
            }, void 0, void 0);
          case ts2.WatchDirectoryKind.UseFsEvents:
            return fsWatch(directoryName, 1, createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback, options, useCaseSensitiveFileNames, getCurrentDirectory), recursive, PollingInterval.Medium, ts2.getFallbackOptions(watchDirectoryOptions));
          default:
            ts2.Debug.assertNever(watchDirectoryKind);
        }
      }
      function updateOptionsForWatchDirectory(options) {
        if (options && options.watchDirectory !== void 0)
          return options;
        switch (tscWatchDirectory) {
          case "RecursiveDirectoryUsingFsWatchFile":
            return {watchDirectory: ts2.WatchDirectoryKind.FixedPollingInterval};
          case "RecursiveDirectoryUsingDynamicPriorityPolling":
            return {watchDirectory: ts2.WatchDirectoryKind.DynamicPriorityPolling};
          default:
            var defaultFallbackPolling = options === null || options === void 0 ? void 0 : options.fallbackPolling;
            return {
              watchDirectory: ts2.WatchDirectoryKind.UseFsEvents,
              fallbackPolling: defaultFallbackPolling !== void 0 ? defaultFallbackPolling : void 0
            };
        }
      }
    }
    ts2.createSystemWatchFunctions = createSystemWatchFunctions;
    function patchWriteFileEnsuringDirectory(sys) {
      var originalWriteFile = sys.writeFile;
      sys.writeFile = function(path, data, writeBom) {
        return ts2.writeFileEnsuringDirectories(path, data, !!writeBom, function(path2, data2, writeByteOrderMark) {
          return originalWriteFile.call(sys, path2, data2, writeByteOrderMark);
        }, function(path2) {
          return sys.createDirectory(path2);
        }, function(path2) {
          return sys.directoryExists(path2);
        });
      };
    }
    ts2.patchWriteFileEnsuringDirectory = patchWriteFileEnsuringDirectory;
    function getNodeMajorVersion() {
      if (typeof process === "undefined") {
        return void 0;
      }
      var version = process.version;
      if (!version) {
        return void 0;
      }
      var dot = version.indexOf(".");
      if (dot === -1) {
        return void 0;
      }
      return parseInt(version.substring(1, dot));
    }
    ts2.getNodeMajorVersion = getNodeMajorVersion;
    ts2.sys = void 0;
    function setSys(s) {
      ts2.sys = s;
    }
    ts2.setSys = setSys;
    if (ts2.sys && ts2.sys.getEnvironmentVariable) {
      setCustomPollingValues(ts2.sys);
      ts2.Debug.setAssertionLevel(/^development$/i.test(ts2.sys.getEnvironmentVariable("NODE_ENV")) ? 1 : 0);
    }
    if (ts2.sys && ts2.sys.debugMode) {
      ts2.Debug.isDebugging = true;
    }
  })(ts || (ts = {}));
  (function(ts2) {
    function diag(code, category, key, message, reportsUnnecessary, elidedInCompatabilityPyramid, reportsDeprecated) {
      return {code, category, key, message, reportsUnnecessary, elidedInCompatabilityPyramid, reportsDeprecated};
    }
    ts2.Diagnostics = {
      Unterminated_string_literal: diag(1002, ts2.DiagnosticCategory.Error, "Unterminated_string_literal_1002", "Unterminated string literal."),
      Identifier_expected: diag(1003, ts2.DiagnosticCategory.Error, "Identifier_expected_1003", "Identifier expected."),
      _0_expected: diag(1005, ts2.DiagnosticCategory.Error, "_0_expected_1005", "'{0}' expected."),
      A_file_cannot_have_a_reference_to_itself: diag(1006, ts2.DiagnosticCategory.Error, "A_file_cannot_have_a_reference_to_itself_1006", "A file cannot have a reference to itself."),
      The_parser_expected_to_find_a_to_match_the_token_here: diag(1007, ts2.DiagnosticCategory.Error, "The_parser_expected_to_find_a_to_match_the_token_here_1007", "The parser expected to find a '}' to match the '{' token here."),
      Trailing_comma_not_allowed: diag(1009, ts2.DiagnosticCategory.Error, "Trailing_comma_not_allowed_1009", "Trailing comma not allowed."),
      Asterisk_Slash_expected: diag(1010, ts2.DiagnosticCategory.Error, "Asterisk_Slash_expected_1010", "'*/' expected."),
      An_element_access_expression_should_take_an_argument: diag(1011, ts2.DiagnosticCategory.Error, "An_element_access_expression_should_take_an_argument_1011", "An element access expression should take an argument."),
      Unexpected_token: diag(1012, ts2.DiagnosticCategory.Error, "Unexpected_token_1012", "Unexpected token."),
      A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma: diag(1013, ts2.DiagnosticCategory.Error, "A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma_1013", "A rest parameter or binding pattern may not have a trailing comma."),
      A_rest_parameter_must_be_last_in_a_parameter_list: diag(1014, ts2.DiagnosticCategory.Error, "A_rest_parameter_must_be_last_in_a_parameter_list_1014", "A rest parameter must be last in a parameter list."),
      Parameter_cannot_have_question_mark_and_initializer: diag(1015, ts2.DiagnosticCategory.Error, "Parameter_cannot_have_question_mark_and_initializer_1015", "Parameter cannot have question mark and initializer."),
      A_required_parameter_cannot_follow_an_optional_parameter: diag(1016, ts2.DiagnosticCategory.Error, "A_required_parameter_cannot_follow_an_optional_parameter_1016", "A required parameter cannot follow an optional parameter."),
      An_index_signature_cannot_have_a_rest_parameter: diag(1017, ts2.DiagnosticCategory.Error, "An_index_signature_cannot_have_a_rest_parameter_1017", "An index signature cannot have a rest parameter."),
      An_index_signature_parameter_cannot_have_an_accessibility_modifier: diag(1018, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_an_accessibility_modifier_1018", "An index signature parameter cannot have an accessibility modifier."),
      An_index_signature_parameter_cannot_have_a_question_mark: diag(1019, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_a_question_mark_1019", "An index signature parameter cannot have a question mark."),
      An_index_signature_parameter_cannot_have_an_initializer: diag(1020, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_an_initializer_1020", "An index signature parameter cannot have an initializer."),
      An_index_signature_must_have_a_type_annotation: diag(1021, ts2.DiagnosticCategory.Error, "An_index_signature_must_have_a_type_annotation_1021", "An index signature must have a type annotation."),
      An_index_signature_parameter_must_have_a_type_annotation: diag(1022, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_must_have_a_type_annotation_1022", "An index signature parameter must have a type annotation."),
      readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature: diag(1024, ts2.DiagnosticCategory.Error, "readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature_1024", "'readonly' modifier can only appear on a property declaration or index signature."),
      An_index_signature_cannot_have_a_trailing_comma: diag(1025, ts2.DiagnosticCategory.Error, "An_index_signature_cannot_have_a_trailing_comma_1025", "An index signature cannot have a trailing comma."),
      Accessibility_modifier_already_seen: diag(1028, ts2.DiagnosticCategory.Error, "Accessibility_modifier_already_seen_1028", "Accessibility modifier already seen."),
      _0_modifier_must_precede_1_modifier: diag(1029, ts2.DiagnosticCategory.Error, "_0_modifier_must_precede_1_modifier_1029", "'{0}' modifier must precede '{1}' modifier."),
      _0_modifier_already_seen: diag(1030, ts2.DiagnosticCategory.Error, "_0_modifier_already_seen_1030", "'{0}' modifier already seen."),
      _0_modifier_cannot_appear_on_class_elements_of_this_kind: diag(1031, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_class_elements_of_this_kind_1031", "'{0}' modifier cannot appear on class elements of this kind."),
      super_must_be_followed_by_an_argument_list_or_member_access: diag(1034, ts2.DiagnosticCategory.Error, "super_must_be_followed_by_an_argument_list_or_member_access_1034", "'super' must be followed by an argument list or member access."),
      Only_ambient_modules_can_use_quoted_names: diag(1035, ts2.DiagnosticCategory.Error, "Only_ambient_modules_can_use_quoted_names_1035", "Only ambient modules can use quoted names."),
      Statements_are_not_allowed_in_ambient_contexts: diag(1036, ts2.DiagnosticCategory.Error, "Statements_are_not_allowed_in_ambient_contexts_1036", "Statements are not allowed in ambient contexts."),
      A_declare_modifier_cannot_be_used_in_an_already_ambient_context: diag(1038, ts2.DiagnosticCategory.Error, "A_declare_modifier_cannot_be_used_in_an_already_ambient_context_1038", "A 'declare' modifier cannot be used in an already ambient context."),
      Initializers_are_not_allowed_in_ambient_contexts: diag(1039, ts2.DiagnosticCategory.Error, "Initializers_are_not_allowed_in_ambient_contexts_1039", "Initializers are not allowed in ambient contexts."),
      _0_modifier_cannot_be_used_in_an_ambient_context: diag(1040, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_in_an_ambient_context_1040", "'{0}' modifier cannot be used in an ambient context."),
      _0_modifier_cannot_be_used_here: diag(1042, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_here_1042", "'{0}' modifier cannot be used here."),
      _0_modifier_cannot_appear_on_a_module_or_namespace_element: diag(1044, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_module_or_namespace_element_1044", "'{0}' modifier cannot appear on a module or namespace element."),
      Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier: diag(1046, ts2.DiagnosticCategory.Error, "Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier_1046", "Top-level declarations in .d.ts files must start with either a 'declare' or 'export' modifier."),
      A_rest_parameter_cannot_be_optional: diag(1047, ts2.DiagnosticCategory.Error, "A_rest_parameter_cannot_be_optional_1047", "A rest parameter cannot be optional."),
      A_rest_parameter_cannot_have_an_initializer: diag(1048, ts2.DiagnosticCategory.Error, "A_rest_parameter_cannot_have_an_initializer_1048", "A rest parameter cannot have an initializer."),
      A_set_accessor_must_have_exactly_one_parameter: diag(1049, ts2.DiagnosticCategory.Error, "A_set_accessor_must_have_exactly_one_parameter_1049", "A 'set' accessor must have exactly one parameter."),
      A_set_accessor_cannot_have_an_optional_parameter: diag(1051, ts2.DiagnosticCategory.Error, "A_set_accessor_cannot_have_an_optional_parameter_1051", "A 'set' accessor cannot have an optional parameter."),
      A_set_accessor_parameter_cannot_have_an_initializer: diag(1052, ts2.DiagnosticCategory.Error, "A_set_accessor_parameter_cannot_have_an_initializer_1052", "A 'set' accessor parameter cannot have an initializer."),
      A_set_accessor_cannot_have_rest_parameter: diag(1053, ts2.DiagnosticCategory.Error, "A_set_accessor_cannot_have_rest_parameter_1053", "A 'set' accessor cannot have rest parameter."),
      A_get_accessor_cannot_have_parameters: diag(1054, ts2.DiagnosticCategory.Error, "A_get_accessor_cannot_have_parameters_1054", "A 'get' accessor cannot have parameters."),
      Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Promise_compatible_constructor_value: diag(1055, ts2.DiagnosticCategory.Error, "Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Prom_1055", "Type '{0}' is not a valid async function return type in ES5/ES3 because it does not refer to a Promise-compatible constructor value."),
      Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher: diag(1056, ts2.DiagnosticCategory.Error, "Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher_1056", "Accessors are only available when targeting ECMAScript 5 and higher."),
      The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1058, ts2.DiagnosticCategory.Error, "The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_t_1058", "The return type of an async function must either be a valid promise or must not contain a callable 'then' member."),
      A_promise_must_have_a_then_method: diag(1059, ts2.DiagnosticCategory.Error, "A_promise_must_have_a_then_method_1059", "A promise must have a 'then' method."),
      The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback: diag(1060, ts2.DiagnosticCategory.Error, "The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback_1060", "The first parameter of the 'then' method of a promise must be a callback."),
      Enum_member_must_have_initializer: diag(1061, ts2.DiagnosticCategory.Error, "Enum_member_must_have_initializer_1061", "Enum member must have initializer."),
      Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method: diag(1062, ts2.DiagnosticCategory.Error, "Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method_1062", "Type is referenced directly or indirectly in the fulfillment callback of its own 'then' method."),
      An_export_assignment_cannot_be_used_in_a_namespace: diag(1063, ts2.DiagnosticCategory.Error, "An_export_assignment_cannot_be_used_in_a_namespace_1063", "An export assignment cannot be used in a namespace."),
      The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_Did_you_mean_to_write_Promise_0: diag(1064, ts2.DiagnosticCategory.Error, "The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_Did_you_mean_to_wri_1064", "The return type of an async function or method must be the global Promise<T> type. Did you mean to write 'Promise<{0}>'?"),
      In_ambient_enum_declarations_member_initializer_must_be_constant_expression: diag(1066, ts2.DiagnosticCategory.Error, "In_ambient_enum_declarations_member_initializer_must_be_constant_expression_1066", "In ambient enum declarations member initializer must be constant expression."),
      Unexpected_token_A_constructor_method_accessor_or_property_was_expected: diag(1068, ts2.DiagnosticCategory.Error, "Unexpected_token_A_constructor_method_accessor_or_property_was_expected_1068", "Unexpected token. A constructor, method, accessor, or property was expected."),
      Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces: diag(1069, ts2.DiagnosticCategory.Error, "Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces_1069", "Unexpected token. A type parameter name was expected without curly braces."),
      _0_modifier_cannot_appear_on_a_type_member: diag(1070, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_type_member_1070", "'{0}' modifier cannot appear on a type member."),
      _0_modifier_cannot_appear_on_an_index_signature: diag(1071, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_an_index_signature_1071", "'{0}' modifier cannot appear on an index signature."),
      A_0_modifier_cannot_be_used_with_an_import_declaration: diag(1079, ts2.DiagnosticCategory.Error, "A_0_modifier_cannot_be_used_with_an_import_declaration_1079", "A '{0}' modifier cannot be used with an import declaration."),
      Invalid_reference_directive_syntax: diag(1084, ts2.DiagnosticCategory.Error, "Invalid_reference_directive_syntax_1084", "Invalid 'reference' directive syntax."),
      Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0: diag(1085, ts2.DiagnosticCategory.Error, "Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0_1085", "Octal literals are not available when targeting ECMAScript 5 and higher. Use the syntax '{0}'."),
      _0_modifier_cannot_appear_on_a_constructor_declaration: diag(1089, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_constructor_declaration_1089", "'{0}' modifier cannot appear on a constructor declaration."),
      _0_modifier_cannot_appear_on_a_parameter: diag(1090, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_parameter_1090", "'{0}' modifier cannot appear on a parameter."),
      Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement: diag(1091, ts2.DiagnosticCategory.Error, "Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement_1091", "Only a single variable declaration is allowed in a 'for...in' statement."),
      Type_parameters_cannot_appear_on_a_constructor_declaration: diag(1092, ts2.DiagnosticCategory.Error, "Type_parameters_cannot_appear_on_a_constructor_declaration_1092", "Type parameters cannot appear on a constructor declaration."),
      Type_annotation_cannot_appear_on_a_constructor_declaration: diag(1093, ts2.DiagnosticCategory.Error, "Type_annotation_cannot_appear_on_a_constructor_declaration_1093", "Type annotation cannot appear on a constructor declaration."),
      An_accessor_cannot_have_type_parameters: diag(1094, ts2.DiagnosticCategory.Error, "An_accessor_cannot_have_type_parameters_1094", "An accessor cannot have type parameters."),
      A_set_accessor_cannot_have_a_return_type_annotation: diag(1095, ts2.DiagnosticCategory.Error, "A_set_accessor_cannot_have_a_return_type_annotation_1095", "A 'set' accessor cannot have a return type annotation."),
      An_index_signature_must_have_exactly_one_parameter: diag(1096, ts2.DiagnosticCategory.Error, "An_index_signature_must_have_exactly_one_parameter_1096", "An index signature must have exactly one parameter."),
      _0_list_cannot_be_empty: diag(1097, ts2.DiagnosticCategory.Error, "_0_list_cannot_be_empty_1097", "'{0}' list cannot be empty."),
      Type_parameter_list_cannot_be_empty: diag(1098, ts2.DiagnosticCategory.Error, "Type_parameter_list_cannot_be_empty_1098", "Type parameter list cannot be empty."),
      Type_argument_list_cannot_be_empty: diag(1099, ts2.DiagnosticCategory.Error, "Type_argument_list_cannot_be_empty_1099", "Type argument list cannot be empty."),
      Invalid_use_of_0_in_strict_mode: diag(1100, ts2.DiagnosticCategory.Error, "Invalid_use_of_0_in_strict_mode_1100", "Invalid use of '{0}' in strict mode."),
      with_statements_are_not_allowed_in_strict_mode: diag(1101, ts2.DiagnosticCategory.Error, "with_statements_are_not_allowed_in_strict_mode_1101", "'with' statements are not allowed in strict mode."),
      delete_cannot_be_called_on_an_identifier_in_strict_mode: diag(1102, ts2.DiagnosticCategory.Error, "delete_cannot_be_called_on_an_identifier_in_strict_mode_1102", "'delete' cannot be called on an identifier in strict mode."),
      for_await_loops_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules: diag(1103, ts2.DiagnosticCategory.Error, "for_await_loops_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules_1103", "'for await' loops are only allowed within async functions and at the top levels of modules."),
      A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement: diag(1104, ts2.DiagnosticCategory.Error, "A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement_1104", "A 'continue' statement can only be used within an enclosing iteration statement."),
      A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement: diag(1105, ts2.DiagnosticCategory.Error, "A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement_1105", "A 'break' statement can only be used within an enclosing iteration or switch statement."),
      The_left_hand_side_of_a_for_of_statement_may_not_be_async: diag(1106, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_may_not_be_async_1106", "The left-hand side of a 'for...of' statement may not be 'async'."),
      Jump_target_cannot_cross_function_boundary: diag(1107, ts2.DiagnosticCategory.Error, "Jump_target_cannot_cross_function_boundary_1107", "Jump target cannot cross function boundary."),
      A_return_statement_can_only_be_used_within_a_function_body: diag(1108, ts2.DiagnosticCategory.Error, "A_return_statement_can_only_be_used_within_a_function_body_1108", "A 'return' statement can only be used within a function body."),
      Expression_expected: diag(1109, ts2.DiagnosticCategory.Error, "Expression_expected_1109", "Expression expected."),
      Type_expected: diag(1110, ts2.DiagnosticCategory.Error, "Type_expected_1110", "Type expected."),
      A_default_clause_cannot_appear_more_than_once_in_a_switch_statement: diag(1113, ts2.DiagnosticCategory.Error, "A_default_clause_cannot_appear_more_than_once_in_a_switch_statement_1113", "A 'default' clause cannot appear more than once in a 'switch' statement."),
      Duplicate_label_0: diag(1114, ts2.DiagnosticCategory.Error, "Duplicate_label_0_1114", "Duplicate label '{0}'."),
      A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement: diag(1115, ts2.DiagnosticCategory.Error, "A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement_1115", "A 'continue' statement can only jump to a label of an enclosing iteration statement."),
      A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement: diag(1116, ts2.DiagnosticCategory.Error, "A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement_1116", "A 'break' statement can only jump to a label of an enclosing statement."),
      An_object_literal_cannot_have_multiple_properties_with_the_same_name_in_strict_mode: diag(1117, ts2.DiagnosticCategory.Error, "An_object_literal_cannot_have_multiple_properties_with_the_same_name_in_strict_mode_1117", "An object literal cannot have multiple properties with the same name in strict mode."),
      An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name: diag(1118, ts2.DiagnosticCategory.Error, "An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name_1118", "An object literal cannot have multiple get/set accessors with the same name."),
      An_object_literal_cannot_have_property_and_accessor_with_the_same_name: diag(1119, ts2.DiagnosticCategory.Error, "An_object_literal_cannot_have_property_and_accessor_with_the_same_name_1119", "An object literal cannot have property and accessor with the same name."),
      An_export_assignment_cannot_have_modifiers: diag(1120, ts2.DiagnosticCategory.Error, "An_export_assignment_cannot_have_modifiers_1120", "An export assignment cannot have modifiers."),
      Octal_literals_are_not_allowed_in_strict_mode: diag(1121, ts2.DiagnosticCategory.Error, "Octal_literals_are_not_allowed_in_strict_mode_1121", "Octal literals are not allowed in strict mode."),
      Variable_declaration_list_cannot_be_empty: diag(1123, ts2.DiagnosticCategory.Error, "Variable_declaration_list_cannot_be_empty_1123", "Variable declaration list cannot be empty."),
      Digit_expected: diag(1124, ts2.DiagnosticCategory.Error, "Digit_expected_1124", "Digit expected."),
      Hexadecimal_digit_expected: diag(1125, ts2.DiagnosticCategory.Error, "Hexadecimal_digit_expected_1125", "Hexadecimal digit expected."),
      Unexpected_end_of_text: diag(1126, ts2.DiagnosticCategory.Error, "Unexpected_end_of_text_1126", "Unexpected end of text."),
      Invalid_character: diag(1127, ts2.DiagnosticCategory.Error, "Invalid_character_1127", "Invalid character."),
      Declaration_or_statement_expected: diag(1128, ts2.DiagnosticCategory.Error, "Declaration_or_statement_expected_1128", "Declaration or statement expected."),
      Statement_expected: diag(1129, ts2.DiagnosticCategory.Error, "Statement_expected_1129", "Statement expected."),
      case_or_default_expected: diag(1130, ts2.DiagnosticCategory.Error, "case_or_default_expected_1130", "'case' or 'default' expected."),
      Property_or_signature_expected: diag(1131, ts2.DiagnosticCategory.Error, "Property_or_signature_expected_1131", "Property or signature expected."),
      Enum_member_expected: diag(1132, ts2.DiagnosticCategory.Error, "Enum_member_expected_1132", "Enum member expected."),
      Variable_declaration_expected: diag(1134, ts2.DiagnosticCategory.Error, "Variable_declaration_expected_1134", "Variable declaration expected."),
      Argument_expression_expected: diag(1135, ts2.DiagnosticCategory.Error, "Argument_expression_expected_1135", "Argument expression expected."),
      Property_assignment_expected: diag(1136, ts2.DiagnosticCategory.Error, "Property_assignment_expected_1136", "Property assignment expected."),
      Expression_or_comma_expected: diag(1137, ts2.DiagnosticCategory.Error, "Expression_or_comma_expected_1137", "Expression or comma expected."),
      Parameter_declaration_expected: diag(1138, ts2.DiagnosticCategory.Error, "Parameter_declaration_expected_1138", "Parameter declaration expected."),
      Type_parameter_declaration_expected: diag(1139, ts2.DiagnosticCategory.Error, "Type_parameter_declaration_expected_1139", "Type parameter declaration expected."),
      Type_argument_expected: diag(1140, ts2.DiagnosticCategory.Error, "Type_argument_expected_1140", "Type argument expected."),
      String_literal_expected: diag(1141, ts2.DiagnosticCategory.Error, "String_literal_expected_1141", "String literal expected."),
      Line_break_not_permitted_here: diag(1142, ts2.DiagnosticCategory.Error, "Line_break_not_permitted_here_1142", "Line break not permitted here."),
      or_expected: diag(1144, ts2.DiagnosticCategory.Error, "or_expected_1144", "'{' or ';' expected."),
      Declaration_expected: diag(1146, ts2.DiagnosticCategory.Error, "Declaration_expected_1146", "Declaration expected."),
      Import_declarations_in_a_namespace_cannot_reference_a_module: diag(1147, ts2.DiagnosticCategory.Error, "Import_declarations_in_a_namespace_cannot_reference_a_module_1147", "Import declarations in a namespace cannot reference a module."),
      Cannot_use_imports_exports_or_module_augmentations_when_module_is_none: diag(1148, ts2.DiagnosticCategory.Error, "Cannot_use_imports_exports_or_module_augmentations_when_module_is_none_1148", "Cannot use imports, exports, or module augmentations when '--module' is 'none'."),
      File_name_0_differs_from_already_included_file_name_1_only_in_casing: diag(1149, ts2.DiagnosticCategory.Error, "File_name_0_differs_from_already_included_file_name_1_only_in_casing_1149", "File name '{0}' differs from already included file name '{1}' only in casing."),
      const_declarations_must_be_initialized: diag(1155, ts2.DiagnosticCategory.Error, "const_declarations_must_be_initialized_1155", "'const' declarations must be initialized."),
      const_declarations_can_only_be_declared_inside_a_block: diag(1156, ts2.DiagnosticCategory.Error, "const_declarations_can_only_be_declared_inside_a_block_1156", "'const' declarations can only be declared inside a block."),
      let_declarations_can_only_be_declared_inside_a_block: diag(1157, ts2.DiagnosticCategory.Error, "let_declarations_can_only_be_declared_inside_a_block_1157", "'let' declarations can only be declared inside a block."),
      Unterminated_template_literal: diag(1160, ts2.DiagnosticCategory.Error, "Unterminated_template_literal_1160", "Unterminated template literal."),
      Unterminated_regular_expression_literal: diag(1161, ts2.DiagnosticCategory.Error, "Unterminated_regular_expression_literal_1161", "Unterminated regular expression literal."),
      An_object_member_cannot_be_declared_optional: diag(1162, ts2.DiagnosticCategory.Error, "An_object_member_cannot_be_declared_optional_1162", "An object member cannot be declared optional."),
      A_yield_expression_is_only_allowed_in_a_generator_body: diag(1163, ts2.DiagnosticCategory.Error, "A_yield_expression_is_only_allowed_in_a_generator_body_1163", "A 'yield' expression is only allowed in a generator body."),
      Computed_property_names_are_not_allowed_in_enums: diag(1164, ts2.DiagnosticCategory.Error, "Computed_property_names_are_not_allowed_in_enums_1164", "Computed property names are not allowed in enums."),
      A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1165, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_t_1165", "A computed property name in an ambient context must refer to an expression whose type is a literal type or a 'unique symbol' type."),
      A_computed_property_name_in_a_class_property_declaration_must_have_a_simple_literal_type_or_a_unique_symbol_type: diag(1166, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_a_class_property_declaration_must_have_a_simple_literal_type_or_a_unique_1166", "A computed property name in a class property declaration must have a simple literal type or a 'unique symbol' type."),
      A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1168, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_ty_1168", "A computed property name in a method overload must refer to an expression whose type is a literal type or a 'unique symbol' type."),
      A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1169, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_1169", "A computed property name in an interface must refer to an expression whose type is a literal type or a 'unique symbol' type."),
      A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1170, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type__1170", "A computed property name in a type literal must refer to an expression whose type is a literal type or a 'unique symbol' type."),
      A_comma_expression_is_not_allowed_in_a_computed_property_name: diag(1171, ts2.DiagnosticCategory.Error, "A_comma_expression_is_not_allowed_in_a_computed_property_name_1171", "A comma expression is not allowed in a computed property name."),
      extends_clause_already_seen: diag(1172, ts2.DiagnosticCategory.Error, "extends_clause_already_seen_1172", "'extends' clause already seen."),
      extends_clause_must_precede_implements_clause: diag(1173, ts2.DiagnosticCategory.Error, "extends_clause_must_precede_implements_clause_1173", "'extends' clause must precede 'implements' clause."),
      Classes_can_only_extend_a_single_class: diag(1174, ts2.DiagnosticCategory.Error, "Classes_can_only_extend_a_single_class_1174", "Classes can only extend a single class."),
      implements_clause_already_seen: diag(1175, ts2.DiagnosticCategory.Error, "implements_clause_already_seen_1175", "'implements' clause already seen."),
      Interface_declaration_cannot_have_implements_clause: diag(1176, ts2.DiagnosticCategory.Error, "Interface_declaration_cannot_have_implements_clause_1176", "Interface declaration cannot have 'implements' clause."),
      Binary_digit_expected: diag(1177, ts2.DiagnosticCategory.Error, "Binary_digit_expected_1177", "Binary digit expected."),
      Octal_digit_expected: diag(1178, ts2.DiagnosticCategory.Error, "Octal_digit_expected_1178", "Octal digit expected."),
      Unexpected_token_expected: diag(1179, ts2.DiagnosticCategory.Error, "Unexpected_token_expected_1179", "Unexpected token. '{' expected."),
      Property_destructuring_pattern_expected: diag(1180, ts2.DiagnosticCategory.Error, "Property_destructuring_pattern_expected_1180", "Property destructuring pattern expected."),
      Array_element_destructuring_pattern_expected: diag(1181, ts2.DiagnosticCategory.Error, "Array_element_destructuring_pattern_expected_1181", "Array element destructuring pattern expected."),
      A_destructuring_declaration_must_have_an_initializer: diag(1182, ts2.DiagnosticCategory.Error, "A_destructuring_declaration_must_have_an_initializer_1182", "A destructuring declaration must have an initializer."),
      An_implementation_cannot_be_declared_in_ambient_contexts: diag(1183, ts2.DiagnosticCategory.Error, "An_implementation_cannot_be_declared_in_ambient_contexts_1183", "An implementation cannot be declared in ambient contexts."),
      Modifiers_cannot_appear_here: diag(1184, ts2.DiagnosticCategory.Error, "Modifiers_cannot_appear_here_1184", "Modifiers cannot appear here."),
      Merge_conflict_marker_encountered: diag(1185, ts2.DiagnosticCategory.Error, "Merge_conflict_marker_encountered_1185", "Merge conflict marker encountered."),
      A_rest_element_cannot_have_an_initializer: diag(1186, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_have_an_initializer_1186", "A rest element cannot have an initializer."),
      A_parameter_property_may_not_be_declared_using_a_binding_pattern: diag(1187, ts2.DiagnosticCategory.Error, "A_parameter_property_may_not_be_declared_using_a_binding_pattern_1187", "A parameter property may not be declared using a binding pattern."),
      Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement: diag(1188, ts2.DiagnosticCategory.Error, "Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement_1188", "Only a single variable declaration is allowed in a 'for...of' statement."),
      The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer: diag(1189, ts2.DiagnosticCategory.Error, "The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer_1189", "The variable declaration of a 'for...in' statement cannot have an initializer."),
      The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer: diag(1190, ts2.DiagnosticCategory.Error, "The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer_1190", "The variable declaration of a 'for...of' statement cannot have an initializer."),
      An_import_declaration_cannot_have_modifiers: diag(1191, ts2.DiagnosticCategory.Error, "An_import_declaration_cannot_have_modifiers_1191", "An import declaration cannot have modifiers."),
      Module_0_has_no_default_export: diag(1192, ts2.DiagnosticCategory.Error, "Module_0_has_no_default_export_1192", "Module '{0}' has no default export."),
      An_export_declaration_cannot_have_modifiers: diag(1193, ts2.DiagnosticCategory.Error, "An_export_declaration_cannot_have_modifiers_1193", "An export declaration cannot have modifiers."),
      Export_declarations_are_not_permitted_in_a_namespace: diag(1194, ts2.DiagnosticCategory.Error, "Export_declarations_are_not_permitted_in_a_namespace_1194", "Export declarations are not permitted in a namespace."),
      export_Asterisk_does_not_re_export_a_default: diag(1195, ts2.DiagnosticCategory.Error, "export_Asterisk_does_not_re_export_a_default_1195", "'export *' does not re-export a default."),
      Catch_clause_variable_type_annotation_must_be_any_or_unknown_if_specified: diag(1196, ts2.DiagnosticCategory.Error, "Catch_clause_variable_type_annotation_must_be_any_or_unknown_if_specified_1196", "Catch clause variable type annotation must be 'any' or 'unknown' if specified."),
      Catch_clause_variable_cannot_have_an_initializer: diag(1197, ts2.DiagnosticCategory.Error, "Catch_clause_variable_cannot_have_an_initializer_1197", "Catch clause variable cannot have an initializer."),
      An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive: diag(1198, ts2.DiagnosticCategory.Error, "An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive_1198", "An extended Unicode escape value must be between 0x0 and 0x10FFFF inclusive."),
      Unterminated_Unicode_escape_sequence: diag(1199, ts2.DiagnosticCategory.Error, "Unterminated_Unicode_escape_sequence_1199", "Unterminated Unicode escape sequence."),
      Line_terminator_not_permitted_before_arrow: diag(1200, ts2.DiagnosticCategory.Error, "Line_terminator_not_permitted_before_arrow_1200", "Line terminator not permitted before arrow."),
      Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_ns_from_mod_import_a_from_mod_import_d_from_mod_or_another_module_format_instead: diag(1202, ts2.DiagnosticCategory.Error, "Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_1202", `Import assignment cannot be used when targeting ECMAScript modules. Consider using 'import * as ns from "mod"', 'import {a} from "mod"', 'import d from "mod"', or another module format instead.`),
      Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or_another_module_format_instead: diag(1203, ts2.DiagnosticCategory.Error, "Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or__1203", "Export assignment cannot be used when targeting ECMAScript modules. Consider using 'export default' or another module format instead."),
      Re_exporting_a_type_when_the_isolatedModules_flag_is_provided_requires_using_export_type: diag(1205, ts2.DiagnosticCategory.Error, "Re_exporting_a_type_when_the_isolatedModules_flag_is_provided_requires_using_export_type_1205", "Re-exporting a type when the '--isolatedModules' flag is provided requires using 'export type'."),
      Decorators_are_not_valid_here: diag(1206, ts2.DiagnosticCategory.Error, "Decorators_are_not_valid_here_1206", "Decorators are not valid here."),
      Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name: diag(1207, ts2.DiagnosticCategory.Error, "Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name_1207", "Decorators cannot be applied to multiple get/set accessors of the same name."),
      _0_cannot_be_compiled_under_isolatedModules_because_it_is_considered_a_global_script_file_Add_an_import_export_or_an_empty_export_statement_to_make_it_a_module: diag(1208, ts2.DiagnosticCategory.Error, "_0_cannot_be_compiled_under_isolatedModules_because_it_is_considered_a_global_script_file_Add_an_imp_1208", "'{0}' cannot be compiled under '--isolatedModules' because it is considered a global script file. Add an import, export, or an empty 'export {}' statement to make it a module."),
      Code_contained_in_a_class_is_evaluated_in_JavaScript_s_strict_mode_which_does_not_allow_this_use_of_0_For_more_information_see_https_Colon_Slash_Slashdeveloper_mozilla_org_Slashen_US_Slashdocs_SlashWeb_SlashJavaScript_SlashReference_SlashStrict_mode: diag(1210, ts2.DiagnosticCategory.Error, "Code_contained_in_a_class_is_evaluated_in_JavaScript_s_strict_mode_which_does_not_allow_this_use_of__1210", "Code contained in a class is evaluated in JavaScript's strict mode which does not allow this use of '{0}'. For more information, see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode."),
      A_class_declaration_without_the_default_modifier_must_have_a_name: diag(1211, ts2.DiagnosticCategory.Error, "A_class_declaration_without_the_default_modifier_must_have_a_name_1211", "A class declaration without the 'default' modifier must have a name."),
      Identifier_expected_0_is_a_reserved_word_in_strict_mode: diag(1212, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_1212", "Identifier expected. '{0}' is a reserved word in strict mode."),
      Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_strict_mode: diag(1213, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_stric_1213", "Identifier expected. '{0}' is a reserved word in strict mode. Class definitions are automatically in strict mode."),
      Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode: diag(1214, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode_1214", "Identifier expected. '{0}' is a reserved word in strict mode. Modules are automatically in strict mode."),
      Invalid_use_of_0_Modules_are_automatically_in_strict_mode: diag(1215, ts2.DiagnosticCategory.Error, "Invalid_use_of_0_Modules_are_automatically_in_strict_mode_1215", "Invalid use of '{0}'. Modules are automatically in strict mode."),
      Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules: diag(1216, ts2.DiagnosticCategory.Error, "Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules_1216", "Identifier expected. '__esModule' is reserved as an exported marker when transforming ECMAScript modules."),
      Export_assignment_is_not_supported_when_module_flag_is_system: diag(1218, ts2.DiagnosticCategory.Error, "Export_assignment_is_not_supported_when_module_flag_is_system_1218", "Export assignment is not supported when '--module' flag is 'system'."),
      Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_the_experimentalDecorators_option_in_your_tsconfig_or_jsconfig_to_remove_this_warning: diag(1219, ts2.DiagnosticCategory.Error, "Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_t_1219", "Experimental support for decorators is a feature that is subject to change in a future release. Set the 'experimentalDecorators' option in your 'tsconfig' or 'jsconfig' to remove this warning."),
      Generators_are_not_allowed_in_an_ambient_context: diag(1221, ts2.DiagnosticCategory.Error, "Generators_are_not_allowed_in_an_ambient_context_1221", "Generators are not allowed in an ambient context."),
      An_overload_signature_cannot_be_declared_as_a_generator: diag(1222, ts2.DiagnosticCategory.Error, "An_overload_signature_cannot_be_declared_as_a_generator_1222", "An overload signature cannot be declared as a generator."),
      _0_tag_already_specified: diag(1223, ts2.DiagnosticCategory.Error, "_0_tag_already_specified_1223", "'{0}' tag already specified."),
      Signature_0_must_be_a_type_predicate: diag(1224, ts2.DiagnosticCategory.Error, "Signature_0_must_be_a_type_predicate_1224", "Signature '{0}' must be a type predicate."),
      Cannot_find_parameter_0: diag(1225, ts2.DiagnosticCategory.Error, "Cannot_find_parameter_0_1225", "Cannot find parameter '{0}'."),
      Type_predicate_0_is_not_assignable_to_1: diag(1226, ts2.DiagnosticCategory.Error, "Type_predicate_0_is_not_assignable_to_1_1226", "Type predicate '{0}' is not assignable to '{1}'."),
      Parameter_0_is_not_in_the_same_position_as_parameter_1: diag(1227, ts2.DiagnosticCategory.Error, "Parameter_0_is_not_in_the_same_position_as_parameter_1_1227", "Parameter '{0}' is not in the same position as parameter '{1}'."),
      A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods: diag(1228, ts2.DiagnosticCategory.Error, "A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods_1228", "A type predicate is only allowed in return type position for functions and methods."),
      A_type_predicate_cannot_reference_a_rest_parameter: diag(1229, ts2.DiagnosticCategory.Error, "A_type_predicate_cannot_reference_a_rest_parameter_1229", "A type predicate cannot reference a rest parameter."),
      A_type_predicate_cannot_reference_element_0_in_a_binding_pattern: diag(1230, ts2.DiagnosticCategory.Error, "A_type_predicate_cannot_reference_element_0_in_a_binding_pattern_1230", "A type predicate cannot reference element '{0}' in a binding pattern."),
      An_export_assignment_must_be_at_the_top_level_of_a_file_or_module_declaration: diag(1231, ts2.DiagnosticCategory.Error, "An_export_assignment_must_be_at_the_top_level_of_a_file_or_module_declaration_1231", "An export assignment must be at the top level of a file or module declaration."),
      An_import_declaration_can_only_be_used_in_a_namespace_or_module: diag(1232, ts2.DiagnosticCategory.Error, "An_import_declaration_can_only_be_used_in_a_namespace_or_module_1232", "An import declaration can only be used in a namespace or module."),
      An_export_declaration_can_only_be_used_in_a_module: diag(1233, ts2.DiagnosticCategory.Error, "An_export_declaration_can_only_be_used_in_a_module_1233", "An export declaration can only be used in a module."),
      An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file: diag(1234, ts2.DiagnosticCategory.Error, "An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file_1234", "An ambient module declaration is only allowed at the top level in a file."),
      A_namespace_declaration_is_only_allowed_in_a_namespace_or_module: diag(1235, ts2.DiagnosticCategory.Error, "A_namespace_declaration_is_only_allowed_in_a_namespace_or_module_1235", "A namespace declaration is only allowed in a namespace or module."),
      The_return_type_of_a_property_decorator_function_must_be_either_void_or_any: diag(1236, ts2.DiagnosticCategory.Error, "The_return_type_of_a_property_decorator_function_must_be_either_void_or_any_1236", "The return type of a property decorator function must be either 'void' or 'any'."),
      The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any: diag(1237, ts2.DiagnosticCategory.Error, "The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any_1237", "The return type of a parameter decorator function must be either 'void' or 'any'."),
      Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression: diag(1238, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression_1238", "Unable to resolve signature of class decorator when called as an expression."),
      Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression: diag(1239, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression_1239", "Unable to resolve signature of parameter decorator when called as an expression."),
      Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression: diag(1240, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression_1240", "Unable to resolve signature of property decorator when called as an expression."),
      Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression: diag(1241, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression_1241", "Unable to resolve signature of method decorator when called as an expression."),
      abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration: diag(1242, ts2.DiagnosticCategory.Error, "abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration_1242", "'abstract' modifier can only appear on a class, method, or property declaration."),
      _0_modifier_cannot_be_used_with_1_modifier: diag(1243, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_with_1_modifier_1243", "'{0}' modifier cannot be used with '{1}' modifier."),
      Abstract_methods_can_only_appear_within_an_abstract_class: diag(1244, ts2.DiagnosticCategory.Error, "Abstract_methods_can_only_appear_within_an_abstract_class_1244", "Abstract methods can only appear within an abstract class."),
      Method_0_cannot_have_an_implementation_because_it_is_marked_abstract: diag(1245, ts2.DiagnosticCategory.Error, "Method_0_cannot_have_an_implementation_because_it_is_marked_abstract_1245", "Method '{0}' cannot have an implementation because it is marked abstract."),
      An_interface_property_cannot_have_an_initializer: diag(1246, ts2.DiagnosticCategory.Error, "An_interface_property_cannot_have_an_initializer_1246", "An interface property cannot have an initializer."),
      A_type_literal_property_cannot_have_an_initializer: diag(1247, ts2.DiagnosticCategory.Error, "A_type_literal_property_cannot_have_an_initializer_1247", "A type literal property cannot have an initializer."),
      A_class_member_cannot_have_the_0_keyword: diag(1248, ts2.DiagnosticCategory.Error, "A_class_member_cannot_have_the_0_keyword_1248", "A class member cannot have the '{0}' keyword."),
      A_decorator_can_only_decorate_a_method_implementation_not_an_overload: diag(1249, ts2.DiagnosticCategory.Error, "A_decorator_can_only_decorate_a_method_implementation_not_an_overload_1249", "A decorator can only decorate a method implementation, not an overload."),
      Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5: diag(1250, ts2.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_1250", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'."),
      Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_definitions_are_automatically_in_strict_mode: diag(1251, ts2.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_d_1251", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Class definitions are automatically in strict mode."),
      Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_are_automatically_in_strict_mode: diag(1252, ts2.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_1252", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Modules are automatically in strict mode."),
      A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_reference: diag(1254, ts2.DiagnosticCategory.Error, "A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_refere_1254", "A 'const' initializer in an ambient context must be a string or numeric literal or literal enum reference."),
      A_definite_assignment_assertion_is_not_permitted_in_this_context: diag(1255, ts2.DiagnosticCategory.Error, "A_definite_assignment_assertion_is_not_permitted_in_this_context_1255", "A definite assignment assertion '!' is not permitted in this context."),
      A_required_element_cannot_follow_an_optional_element: diag(1257, ts2.DiagnosticCategory.Error, "A_required_element_cannot_follow_an_optional_element_1257", "A required element cannot follow an optional element."),
      A_default_export_must_be_at_the_top_level_of_a_file_or_module_declaration: diag(1258, ts2.DiagnosticCategory.Error, "A_default_export_must_be_at_the_top_level_of_a_file_or_module_declaration_1258", "A default export must be at the top level of a file or module declaration."),
      Module_0_can_only_be_default_imported_using_the_1_flag: diag(1259, ts2.DiagnosticCategory.Error, "Module_0_can_only_be_default_imported_using_the_1_flag_1259", "Module '{0}' can only be default-imported using the '{1}' flag"),
      Keywords_cannot_contain_escape_characters: diag(1260, ts2.DiagnosticCategory.Error, "Keywords_cannot_contain_escape_characters_1260", "Keywords cannot contain escape characters."),
      Already_included_file_name_0_differs_from_file_name_1_only_in_casing: diag(1261, ts2.DiagnosticCategory.Error, "Already_included_file_name_0_differs_from_file_name_1_only_in_casing_1261", "Already included file name '{0}' differs from file name '{1}' only in casing."),
      Identifier_expected_0_is_a_reserved_word_at_the_top_level_of_a_module: diag(1262, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_at_the_top_level_of_a_module_1262", "Identifier expected. '{0}' is a reserved word at the top-level of a module."),
      Declarations_with_initializers_cannot_also_have_definite_assignment_assertions: diag(1263, ts2.DiagnosticCategory.Error, "Declarations_with_initializers_cannot_also_have_definite_assignment_assertions_1263", "Declarations with initializers cannot also have definite assignment assertions."),
      Declarations_with_definite_assignment_assertions_must_also_have_type_annotations: diag(1264, ts2.DiagnosticCategory.Error, "Declarations_with_definite_assignment_assertions_must_also_have_type_annotations_1264", "Declarations with definite assignment assertions must also have type annotations."),
      A_rest_element_cannot_follow_another_rest_element: diag(1265, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_follow_another_rest_element_1265", "A rest element cannot follow another rest element."),
      An_optional_element_cannot_follow_a_rest_element: diag(1266, ts2.DiagnosticCategory.Error, "An_optional_element_cannot_follow_a_rest_element_1266", "An optional element cannot follow a rest element."),
      Property_0_cannot_have_an_initializer_because_it_is_marked_abstract: diag(1267, ts2.DiagnosticCategory.Error, "Property_0_cannot_have_an_initializer_because_it_is_marked_abstract_1267", "Property '{0}' cannot have an initializer because it is marked abstract."),
      An_index_signature_parameter_type_must_be_string_number_symbol_or_a_template_literal_type: diag(1268, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_type_must_be_string_number_symbol_or_a_template_literal_type_1268", "An index signature parameter type must be 'string', 'number', 'symbol', or a template literal type."),
      with_statements_are_not_allowed_in_an_async_function_block: diag(1300, ts2.DiagnosticCategory.Error, "with_statements_are_not_allowed_in_an_async_function_block_1300", "'with' statements are not allowed in an async function block."),
      await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules: diag(1308, ts2.DiagnosticCategory.Error, "await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules_1308", "'await' expressions are only allowed within async functions and at the top levels of modules."),
      Did_you_mean_to_use_a_Colon_An_can_only_follow_a_property_name_when_the_containing_object_literal_is_part_of_a_destructuring_pattern: diag(1312, ts2.DiagnosticCategory.Error, "Did_you_mean_to_use_a_Colon_An_can_only_follow_a_property_name_when_the_containing_object_literal_is_1312", "Did you mean to use a ':'? An '=' can only follow a property name when the containing object literal is part of a destructuring pattern."),
      The_body_of_an_if_statement_cannot_be_the_empty_statement: diag(1313, ts2.DiagnosticCategory.Error, "The_body_of_an_if_statement_cannot_be_the_empty_statement_1313", "The body of an 'if' statement cannot be the empty statement."),
      Global_module_exports_may_only_appear_in_module_files: diag(1314, ts2.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_in_module_files_1314", "Global module exports may only appear in module files."),
      Global_module_exports_may_only_appear_in_declaration_files: diag(1315, ts2.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_in_declaration_files_1315", "Global module exports may only appear in declaration files."),
      Global_module_exports_may_only_appear_at_top_level: diag(1316, ts2.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_at_top_level_1316", "Global module exports may only appear at top level."),
      A_parameter_property_cannot_be_declared_using_a_rest_parameter: diag(1317, ts2.DiagnosticCategory.Error, "A_parameter_property_cannot_be_declared_using_a_rest_parameter_1317", "A parameter property cannot be declared using a rest parameter."),
      An_abstract_accessor_cannot_have_an_implementation: diag(1318, ts2.DiagnosticCategory.Error, "An_abstract_accessor_cannot_have_an_implementation_1318", "An abstract accessor cannot have an implementation."),
      A_default_export_can_only_be_used_in_an_ECMAScript_style_module: diag(1319, ts2.DiagnosticCategory.Error, "A_default_export_can_only_be_used_in_an_ECMAScript_style_module_1319", "A default export can only be used in an ECMAScript-style module."),
      Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1320, ts2.DiagnosticCategory.Error, "Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member_1320", "Type of 'await' operand must either be a valid promise or must not contain a callable 'then' member."),
      Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1321, ts2.DiagnosticCategory.Error, "Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_cal_1321", "Type of 'yield' operand in an async generator must either be a valid promise or must not contain a callable 'then' member."),
      Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1322, ts2.DiagnosticCategory.Error, "Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_con_1322", "Type of iterated elements of a 'yield*' operand must either be a valid promise or must not contain a callable 'then' member."),
      Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_es2022_esnext_commonjs_amd_system_umd_node12_or_nodenext: diag(1323, ts2.DiagnosticCategory.Error, "Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_es2022_esnext_commonjs_amd__1323", "Dynamic imports are only supported when the '--module' flag is set to 'es2020', 'es2022', 'esnext', 'commonjs', 'amd', 'system', 'umd', 'node12', or 'nodenext'."),
      Dynamic_imports_only_support_a_second_argument_when_the_module_option_is_set_to_esnext: diag(1324, ts2.DiagnosticCategory.Error, "Dynamic_imports_only_support_a_second_argument_when_the_module_option_is_set_to_esnext_1324", "Dynamic imports only support a second argument when the '--module' option is set to 'esnext'."),
      Argument_of_dynamic_import_cannot_be_spread_element: diag(1325, ts2.DiagnosticCategory.Error, "Argument_of_dynamic_import_cannot_be_spread_element_1325", "Argument of dynamic import cannot be spread element."),
      Dynamic_import_cannot_have_type_arguments: diag(1326, ts2.DiagnosticCategory.Error, "Dynamic_import_cannot_have_type_arguments_1326", "Dynamic import cannot have type arguments."),
      String_literal_with_double_quotes_expected: diag(1327, ts2.DiagnosticCategory.Error, "String_literal_with_double_quotes_expected_1327", "String literal with double quotes expected."),
      Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_literal: diag(1328, ts2.DiagnosticCategory.Error, "Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_li_1328", "Property value can only be string literal, numeric literal, 'true', 'false', 'null', object literal or array literal."),
      _0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write_0: diag(1329, ts2.DiagnosticCategory.Error, "_0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write__1329", "'{0}' accepts too few arguments to be used as a decorator here. Did you mean to call it first and write '@{0}()'?"),
      A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly: diag(1330, ts2.DiagnosticCategory.Error, "A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly_1330", "A property of an interface or type literal whose type is a 'unique symbol' type must be 'readonly'."),
      A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly: diag(1331, ts2.DiagnosticCategory.Error, "A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly_1331", "A property of a class whose type is a 'unique symbol' type must be both 'static' and 'readonly'."),
      A_variable_whose_type_is_a_unique_symbol_type_must_be_const: diag(1332, ts2.DiagnosticCategory.Error, "A_variable_whose_type_is_a_unique_symbol_type_must_be_const_1332", "A variable whose type is a 'unique symbol' type must be 'const'."),
      unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name: diag(1333, ts2.DiagnosticCategory.Error, "unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name_1333", "'unique symbol' types may not be used on a variable declaration with a binding name."),
      unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement: diag(1334, ts2.DiagnosticCategory.Error, "unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement_1334", "'unique symbol' types are only allowed on variables in a variable statement."),
      unique_symbol_types_are_not_allowed_here: diag(1335, ts2.DiagnosticCategory.Error, "unique_symbol_types_are_not_allowed_here_1335", "'unique symbol' types are not allowed here."),
      An_index_signature_parameter_type_cannot_be_a_literal_type_or_generic_type_Consider_using_a_mapped_object_type_instead: diag(1337, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_type_cannot_be_a_literal_type_or_generic_type_Consider_using_a_mapped_o_1337", "An index signature parameter type cannot be a literal type or generic type. Consider using a mapped object type instead."),
      infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type: diag(1338, ts2.DiagnosticCategory.Error, "infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type_1338", "'infer' declarations are only permitted in the 'extends' clause of a conditional type."),
      Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here: diag(1339, ts2.DiagnosticCategory.Error, "Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here_1339", "Module '{0}' does not refer to a value, but is used as a value here."),
      Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0: diag(1340, ts2.DiagnosticCategory.Error, "Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0_1340", "Module '{0}' does not refer to a type, but is used as a type here. Did you mean 'typeof import('{0}')'?"),
      Type_arguments_cannot_be_used_here: diag(1342, ts2.DiagnosticCategory.Error, "Type_arguments_cannot_be_used_here_1342", "Type arguments cannot be used here."),
      The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_es2020_es2022_esnext_system_node12_or_nodenext: diag(1343, ts2.DiagnosticCategory.Error, "The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_es2020_es2022_esnext_system__1343", "The 'import.meta' meta-property is only allowed when the '--module' option is 'es2020', 'es2022', 'esnext', 'system', 'node12', or 'nodenext'."),
      A_label_is_not_allowed_here: diag(1344, ts2.DiagnosticCategory.Error, "A_label_is_not_allowed_here_1344", "'A label is not allowed here."),
      An_expression_of_type_void_cannot_be_tested_for_truthiness: diag(1345, ts2.DiagnosticCategory.Error, "An_expression_of_type_void_cannot_be_tested_for_truthiness_1345", "An expression of type 'void' cannot be tested for truthiness."),
      This_parameter_is_not_allowed_with_use_strict_directive: diag(1346, ts2.DiagnosticCategory.Error, "This_parameter_is_not_allowed_with_use_strict_directive_1346", "This parameter is not allowed with 'use strict' directive."),
      use_strict_directive_cannot_be_used_with_non_simple_parameter_list: diag(1347, ts2.DiagnosticCategory.Error, "use_strict_directive_cannot_be_used_with_non_simple_parameter_list_1347", "'use strict' directive cannot be used with non-simple parameter list."),
      Non_simple_parameter_declared_here: diag(1348, ts2.DiagnosticCategory.Error, "Non_simple_parameter_declared_here_1348", "Non-simple parameter declared here."),
      use_strict_directive_used_here: diag(1349, ts2.DiagnosticCategory.Error, "use_strict_directive_used_here_1349", "'use strict' directive used here."),
      Print_the_final_configuration_instead_of_building: diag(1350, ts2.DiagnosticCategory.Message, "Print_the_final_configuration_instead_of_building_1350", "Print the final configuration instead of building."),
      An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal: diag(1351, ts2.DiagnosticCategory.Error, "An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal_1351", "An identifier or keyword cannot immediately follow a numeric literal."),
      A_bigint_literal_cannot_use_exponential_notation: diag(1352, ts2.DiagnosticCategory.Error, "A_bigint_literal_cannot_use_exponential_notation_1352", "A bigint literal cannot use exponential notation."),
      A_bigint_literal_must_be_an_integer: diag(1353, ts2.DiagnosticCategory.Error, "A_bigint_literal_must_be_an_integer_1353", "A bigint literal must be an integer."),
      readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types: diag(1354, ts2.DiagnosticCategory.Error, "readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types_1354", "'readonly' type modifier is only permitted on array and tuple literal types."),
      A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array_or_object_literals: diag(1355, ts2.DiagnosticCategory.Error, "A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array__1355", "A 'const' assertions can only be applied to references to enum members, or string, number, boolean, array, or object literals."),
      Did_you_mean_to_mark_this_function_as_async: diag(1356, ts2.DiagnosticCategory.Error, "Did_you_mean_to_mark_this_function_as_async_1356", "Did you mean to mark this function as 'async'?"),
      An_enum_member_name_must_be_followed_by_a_or: diag(1357, ts2.DiagnosticCategory.Error, "An_enum_member_name_must_be_followed_by_a_or_1357", "An enum member name must be followed by a ',', '=', or '}'."),
      Tagged_template_expressions_are_not_permitted_in_an_optional_chain: diag(1358, ts2.DiagnosticCategory.Error, "Tagged_template_expressions_are_not_permitted_in_an_optional_chain_1358", "Tagged template expressions are not permitted in an optional chain."),
      Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here: diag(1359, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here_1359", "Identifier expected. '{0}' is a reserved word that cannot be used here."),
      _0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type: diag(1361, ts2.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type_1361", "'{0}' cannot be used as a value because it was imported using 'import type'."),
      _0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type: diag(1362, ts2.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type_1362", "'{0}' cannot be used as a value because it was exported using 'export type'."),
      A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both: diag(1363, ts2.DiagnosticCategory.Error, "A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both_1363", "A type-only import can specify a default import or named bindings, but not both."),
      Convert_to_type_only_export: diag(1364, ts2.DiagnosticCategory.Message, "Convert_to_type_only_export_1364", "Convert to type-only export"),
      Convert_all_re_exported_types_to_type_only_exports: diag(1365, ts2.DiagnosticCategory.Message, "Convert_all_re_exported_types_to_type_only_exports_1365", "Convert all re-exported types to type-only exports"),
      Split_into_two_separate_import_declarations: diag(1366, ts2.DiagnosticCategory.Message, "Split_into_two_separate_import_declarations_1366", "Split into two separate import declarations"),
      Split_all_invalid_type_only_imports: diag(1367, ts2.DiagnosticCategory.Message, "Split_all_invalid_type_only_imports_1367", "Split all invalid type-only imports"),
      Did_you_mean_0: diag(1369, ts2.DiagnosticCategory.Message, "Did_you_mean_0_1369", "Did you mean '{0}'?"),
      This_import_is_never_used_as_a_value_and_must_use_import_type_because_importsNotUsedAsValues_is_set_to_error: diag(1371, ts2.DiagnosticCategory.Error, "This_import_is_never_used_as_a_value_and_must_use_import_type_because_importsNotUsedAsValues_is_set__1371", "This import is never used as a value and must use 'import type' because 'importsNotUsedAsValues' is set to 'error'."),
      Convert_to_type_only_import: diag(1373, ts2.DiagnosticCategory.Message, "Convert_to_type_only_import_1373", "Convert to type-only import"),
      Convert_all_imports_not_used_as_a_value_to_type_only_imports: diag(1374, ts2.DiagnosticCategory.Message, "Convert_all_imports_not_used_as_a_value_to_type_only_imports_1374", "Convert all imports not used as a value to type-only imports"),
      await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_has_no_imports_or_exports_Consider_adding_an_empty_export_to_make_this_file_a_module: diag(1375, ts2.DiagnosticCategory.Error, "await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_fi_1375", "'await' expressions are only allowed at the top level of a file when that file is a module, but this file has no imports or exports. Consider adding an empty 'export {}' to make this file a module."),
      _0_was_imported_here: diag(1376, ts2.DiagnosticCategory.Message, "_0_was_imported_here_1376", "'{0}' was imported here."),
      _0_was_exported_here: diag(1377, ts2.DiagnosticCategory.Message, "_0_was_exported_here_1377", "'{0}' was exported here."),
      Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_or_nodenext_and_the_target_option_is_set_to_es2017_or_higher: diag(1378, ts2.DiagnosticCategory.Error, "Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_o_1378", "Top-level 'await' expressions are only allowed when the 'module' option is set to 'es2022', 'esnext', 'system', or 'nodenext', and the 'target' option is set to 'es2017' or higher."),
      An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type: diag(1379, ts2.DiagnosticCategory.Error, "An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type_1379", "An import alias cannot reference a declaration that was exported using 'export type'."),
      An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type: diag(1380, ts2.DiagnosticCategory.Error, "An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type_1380", "An import alias cannot reference a declaration that was imported using 'import type'."),
      Unexpected_token_Did_you_mean_or_rbrace: diag(1381, ts2.DiagnosticCategory.Error, "Unexpected_token_Did_you_mean_or_rbrace_1381", "Unexpected token. Did you mean `{'}'}` or `&rbrace;`?"),
      Unexpected_token_Did_you_mean_or_gt: diag(1382, ts2.DiagnosticCategory.Error, "Unexpected_token_Did_you_mean_or_gt_1382", "Unexpected token. Did you mean `{'>'}` or `&gt;`?"),
      Only_named_exports_may_use_export_type: diag(1383, ts2.DiagnosticCategory.Error, "Only_named_exports_may_use_export_type_1383", "Only named exports may use 'export type'."),
      A_new_expression_with_type_arguments_must_always_be_followed_by_a_parenthesized_argument_list: diag(1384, ts2.DiagnosticCategory.Error, "A_new_expression_with_type_arguments_must_always_be_followed_by_a_parenthesized_argument_list_1384", "A 'new' expression with type arguments must always be followed by a parenthesized argument list."),
      Function_type_notation_must_be_parenthesized_when_used_in_a_union_type: diag(1385, ts2.DiagnosticCategory.Error, "Function_type_notation_must_be_parenthesized_when_used_in_a_union_type_1385", "Function type notation must be parenthesized when used in a union type."),
      Constructor_type_notation_must_be_parenthesized_when_used_in_a_union_type: diag(1386, ts2.DiagnosticCategory.Error, "Constructor_type_notation_must_be_parenthesized_when_used_in_a_union_type_1386", "Constructor type notation must be parenthesized when used in a union type."),
      Function_type_notation_must_be_parenthesized_when_used_in_an_intersection_type: diag(1387, ts2.DiagnosticCategory.Error, "Function_type_notation_must_be_parenthesized_when_used_in_an_intersection_type_1387", "Function type notation must be parenthesized when used in an intersection type."),
      Constructor_type_notation_must_be_parenthesized_when_used_in_an_intersection_type: diag(1388, ts2.DiagnosticCategory.Error, "Constructor_type_notation_must_be_parenthesized_when_used_in_an_intersection_type_1388", "Constructor type notation must be parenthesized when used in an intersection type."),
      _0_is_not_allowed_as_a_variable_declaration_name: diag(1389, ts2.DiagnosticCategory.Error, "_0_is_not_allowed_as_a_variable_declaration_name_1389", "'{0}' is not allowed as a variable declaration name."),
      _0_is_not_allowed_as_a_parameter_name: diag(1390, ts2.DiagnosticCategory.Error, "_0_is_not_allowed_as_a_parameter_name_1390", "'{0}' is not allowed as a parameter name."),
      An_import_alias_cannot_use_import_type: diag(1392, ts2.DiagnosticCategory.Error, "An_import_alias_cannot_use_import_type_1392", "An import alias cannot use 'import type'"),
      Imported_via_0_from_file_1: diag(1393, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_1393", "Imported via {0} from file '{1}'"),
      Imported_via_0_from_file_1_with_packageId_2: diag(1394, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_with_packageId_2_1394", "Imported via {0} from file '{1}' with packageId '{2}'"),
      Imported_via_0_from_file_1_to_import_importHelpers_as_specified_in_compilerOptions: diag(1395, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_to_import_importHelpers_as_specified_in_compilerOptions_1395", "Imported via {0} from file '{1}' to import 'importHelpers' as specified in compilerOptions"),
      Imported_via_0_from_file_1_with_packageId_2_to_import_importHelpers_as_specified_in_compilerOptions: diag(1396, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_with_packageId_2_to_import_importHelpers_as_specified_in_compilerOptions_1396", "Imported via {0} from file '{1}' with packageId '{2}' to import 'importHelpers' as specified in compilerOptions"),
      Imported_via_0_from_file_1_to_import_jsx_and_jsxs_factory_functions: diag(1397, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_to_import_jsx_and_jsxs_factory_functions_1397", "Imported via {0} from file '{1}' to import 'jsx' and 'jsxs' factory functions"),
      Imported_via_0_from_file_1_with_packageId_2_to_import_jsx_and_jsxs_factory_functions: diag(1398, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_with_packageId_2_to_import_jsx_and_jsxs_factory_functions_1398", "Imported via {0} from file '{1}' with packageId '{2}' to import 'jsx' and 'jsxs' factory functions"),
      File_is_included_via_import_here: diag(1399, ts2.DiagnosticCategory.Message, "File_is_included_via_import_here_1399", "File is included via import here."),
      Referenced_via_0_from_file_1: diag(1400, ts2.DiagnosticCategory.Message, "Referenced_via_0_from_file_1_1400", "Referenced via '{0}' from file '{1}'"),
      File_is_included_via_reference_here: diag(1401, ts2.DiagnosticCategory.Message, "File_is_included_via_reference_here_1401", "File is included via reference here."),
      Type_library_referenced_via_0_from_file_1: diag(1402, ts2.DiagnosticCategory.Message, "Type_library_referenced_via_0_from_file_1_1402", "Type library referenced via '{0}' from file '{1}'"),
      Type_library_referenced_via_0_from_file_1_with_packageId_2: diag(1403, ts2.DiagnosticCategory.Message, "Type_library_referenced_via_0_from_file_1_with_packageId_2_1403", "Type library referenced via '{0}' from file '{1}' with packageId '{2}'"),
      File_is_included_via_type_library_reference_here: diag(1404, ts2.DiagnosticCategory.Message, "File_is_included_via_type_library_reference_here_1404", "File is included via type library reference here."),
      Library_referenced_via_0_from_file_1: diag(1405, ts2.DiagnosticCategory.Message, "Library_referenced_via_0_from_file_1_1405", "Library referenced via '{0}' from file '{1}'"),
      File_is_included_via_library_reference_here: diag(1406, ts2.DiagnosticCategory.Message, "File_is_included_via_library_reference_here_1406", "File is included via library reference here."),
      Matched_by_include_pattern_0_in_1: diag(1407, ts2.DiagnosticCategory.Message, "Matched_by_include_pattern_0_in_1_1407", "Matched by include pattern '{0}' in '{1}'"),
      File_is_matched_by_include_pattern_specified_here: diag(1408, ts2.DiagnosticCategory.Message, "File_is_matched_by_include_pattern_specified_here_1408", "File is matched by include pattern specified here."),
      Part_of_files_list_in_tsconfig_json: diag(1409, ts2.DiagnosticCategory.Message, "Part_of_files_list_in_tsconfig_json_1409", "Part of 'files' list in tsconfig.json"),
      File_is_matched_by_files_list_specified_here: diag(1410, ts2.DiagnosticCategory.Message, "File_is_matched_by_files_list_specified_here_1410", "File is matched by 'files' list specified here."),
      Output_from_referenced_project_0_included_because_1_specified: diag(1411, ts2.DiagnosticCategory.Message, "Output_from_referenced_project_0_included_because_1_specified_1411", "Output from referenced project '{0}' included because '{1}' specified"),
      Output_from_referenced_project_0_included_because_module_is_specified_as_none: diag(1412, ts2.DiagnosticCategory.Message, "Output_from_referenced_project_0_included_because_module_is_specified_as_none_1412", "Output from referenced project '{0}' included because '--module' is specified as 'none'"),
      File_is_output_from_referenced_project_specified_here: diag(1413, ts2.DiagnosticCategory.Message, "File_is_output_from_referenced_project_specified_here_1413", "File is output from referenced project specified here."),
      Source_from_referenced_project_0_included_because_1_specified: diag(1414, ts2.DiagnosticCategory.Message, "Source_from_referenced_project_0_included_because_1_specified_1414", "Source from referenced project '{0}' included because '{1}' specified"),
      Source_from_referenced_project_0_included_because_module_is_specified_as_none: diag(1415, ts2.DiagnosticCategory.Message, "Source_from_referenced_project_0_included_because_module_is_specified_as_none_1415", "Source from referenced project '{0}' included because '--module' is specified as 'none'"),
      File_is_source_from_referenced_project_specified_here: diag(1416, ts2.DiagnosticCategory.Message, "File_is_source_from_referenced_project_specified_here_1416", "File is source from referenced project specified here."),
      Entry_point_of_type_library_0_specified_in_compilerOptions: diag(1417, ts2.DiagnosticCategory.Message, "Entry_point_of_type_library_0_specified_in_compilerOptions_1417", "Entry point of type library '{0}' specified in compilerOptions"),
      Entry_point_of_type_library_0_specified_in_compilerOptions_with_packageId_1: diag(1418, ts2.DiagnosticCategory.Message, "Entry_point_of_type_library_0_specified_in_compilerOptions_with_packageId_1_1418", "Entry point of type library '{0}' specified in compilerOptions with packageId '{1}'"),
      File_is_entry_point_of_type_library_specified_here: diag(1419, ts2.DiagnosticCategory.Message, "File_is_entry_point_of_type_library_specified_here_1419", "File is entry point of type library specified here."),
      Entry_point_for_implicit_type_library_0: diag(1420, ts2.DiagnosticCategory.Message, "Entry_point_for_implicit_type_library_0_1420", "Entry point for implicit type library '{0}'"),
      Entry_point_for_implicit_type_library_0_with_packageId_1: diag(1421, ts2.DiagnosticCategory.Message, "Entry_point_for_implicit_type_library_0_with_packageId_1_1421", "Entry point for implicit type library '{0}' with packageId '{1}'"),
      Library_0_specified_in_compilerOptions: diag(1422, ts2.DiagnosticCategory.Message, "Library_0_specified_in_compilerOptions_1422", "Library '{0}' specified in compilerOptions"),
      File_is_library_specified_here: diag(1423, ts2.DiagnosticCategory.Message, "File_is_library_specified_here_1423", "File is library specified here."),
      Default_library: diag(1424, ts2.DiagnosticCategory.Message, "Default_library_1424", "Default library"),
      Default_library_for_target_0: diag(1425, ts2.DiagnosticCategory.Message, "Default_library_for_target_0_1425", "Default library for target '{0}'"),
      File_is_default_library_for_target_specified_here: diag(1426, ts2.DiagnosticCategory.Message, "File_is_default_library_for_target_specified_here_1426", "File is default library for target specified here."),
      Root_file_specified_for_compilation: diag(1427, ts2.DiagnosticCategory.Message, "Root_file_specified_for_compilation_1427", "Root file specified for compilation"),
      File_is_output_of_project_reference_source_0: diag(1428, ts2.DiagnosticCategory.Message, "File_is_output_of_project_reference_source_0_1428", "File is output of project reference source '{0}'"),
      File_redirects_to_file_0: diag(1429, ts2.DiagnosticCategory.Message, "File_redirects_to_file_0_1429", "File redirects to file '{0}'"),
      The_file_is_in_the_program_because_Colon: diag(1430, ts2.DiagnosticCategory.Message, "The_file_is_in_the_program_because_Colon_1430", "The file is in the program because:"),
      for_await_loops_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_has_no_imports_or_exports_Consider_adding_an_empty_export_to_make_this_file_a_module: diag(1431, ts2.DiagnosticCategory.Error, "for_await_loops_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_1431", "'for await' loops are only allowed at the top level of a file when that file is a module, but this file has no imports or exports. Consider adding an empty 'export {}' to make this file a module."),
      Top_level_for_await_loops_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_or_nodenext_and_the_target_option_is_set_to_es2017_or_higher: diag(1432, ts2.DiagnosticCategory.Error, "Top_level_for_await_loops_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_or__1432", "Top-level 'for await' loops are only allowed when the 'module' option is set to 'es2022', 'esnext', 'system', or 'nodenext', and the 'target' option is set to 'es2017' or higher."),
      Decorators_may_not_be_applied_to_this_parameters: diag(1433, ts2.DiagnosticCategory.Error, "Decorators_may_not_be_applied_to_this_parameters_1433", "Decorators may not be applied to 'this' parameters."),
      Unexpected_keyword_or_identifier: diag(1434, ts2.DiagnosticCategory.Error, "Unexpected_keyword_or_identifier_1434", "Unexpected keyword or identifier."),
      Unknown_keyword_or_identifier_Did_you_mean_0: diag(1435, ts2.DiagnosticCategory.Error, "Unknown_keyword_or_identifier_Did_you_mean_0_1435", "Unknown keyword or identifier. Did you mean '{0}'?"),
      Decorators_must_precede_the_name_and_all_keywords_of_property_declarations: diag(1436, ts2.DiagnosticCategory.Error, "Decorators_must_precede_the_name_and_all_keywords_of_property_declarations_1436", "Decorators must precede the name and all keywords of property declarations."),
      Namespace_must_be_given_a_name: diag(1437, ts2.DiagnosticCategory.Error, "Namespace_must_be_given_a_name_1437", "Namespace must be given a name."),
      Interface_must_be_given_a_name: diag(1438, ts2.DiagnosticCategory.Error, "Interface_must_be_given_a_name_1438", "Interface must be given a name."),
      Type_alias_must_be_given_a_name: diag(1439, ts2.DiagnosticCategory.Error, "Type_alias_must_be_given_a_name_1439", "Type alias must be given a name."),
      Variable_declaration_not_allowed_at_this_location: diag(1440, ts2.DiagnosticCategory.Error, "Variable_declaration_not_allowed_at_this_location_1440", "Variable declaration not allowed at this location."),
      Cannot_start_a_function_call_in_a_type_annotation: diag(1441, ts2.DiagnosticCategory.Error, "Cannot_start_a_function_call_in_a_type_annotation_1441", "Cannot start a function call in a type annotation."),
      Expected_for_property_initializer: diag(1442, ts2.DiagnosticCategory.Error, "Expected_for_property_initializer_1442", "Expected '=' for property initializer."),
      Module_declaration_names_may_only_use_or_quoted_strings: diag(1443, ts2.DiagnosticCategory.Error, "Module_declaration_names_may_only_use_or_quoted_strings_1443", `Module declaration names may only use ' or " quoted strings.`),
      _0_is_a_type_and_must_be_imported_using_a_type_only_import_when_preserveValueImports_and_isolatedModules_are_both_enabled: diag(1444, ts2.DiagnosticCategory.Error, "_0_is_a_type_and_must_be_imported_using_a_type_only_import_when_preserveValueImports_and_isolatedMod_1444", "'{0}' is a type and must be imported using a type-only import when 'preserveValueImports' and 'isolatedModules' are both enabled."),
      _0_resolves_to_a_type_only_declaration_and_must_be_imported_using_a_type_only_import_when_preserveValueImports_and_isolatedModules_are_both_enabled: diag(1446, ts2.DiagnosticCategory.Error, "_0_resolves_to_a_type_only_declaration_and_must_be_imported_using_a_type_only_import_when_preserveVa_1446", "'{0}' resolves to a type-only declaration and must be imported using a type-only import when 'preserveValueImports' and 'isolatedModules' are both enabled."),
      _0_resolves_to_a_type_only_declaration_and_must_be_re_exported_using_a_type_only_re_export_when_isolatedModules_is_enabled: diag(1448, ts2.DiagnosticCategory.Error, "_0_resolves_to_a_type_only_declaration_and_must_be_re_exported_using_a_type_only_re_export_when_isol_1448", "'{0}' resolves to a type-only declaration and must be re-exported using a type-only re-export when 'isolatedModules' is enabled."),
      Preserve_unused_imported_values_in_the_JavaScript_output_that_would_otherwise_be_removed: diag(1449, ts2.DiagnosticCategory.Message, "Preserve_unused_imported_values_in_the_JavaScript_output_that_would_otherwise_be_removed_1449", "Preserve unused imported values in the JavaScript output that would otherwise be removed."),
      Dynamic_imports_can_only_accept_a_module_specifier_and_an_optional_assertion_as_arguments: diag(1450, ts2.DiagnosticCategory.Message, "Dynamic_imports_can_only_accept_a_module_specifier_and_an_optional_assertion_as_arguments_1450", "Dynamic imports can only accept a module specifier and an optional assertion as arguments"),
      Private_identifiers_are_only_allowed_in_class_bodies_and_may_only_be_used_as_part_of_a_class_member_declaration_property_access_or_on_the_left_hand_side_of_an_in_expression: diag(1451, ts2.DiagnosticCategory.Error, "Private_identifiers_are_only_allowed_in_class_bodies_and_may_only_be_used_as_part_of_a_class_member__1451", "Private identifiers are only allowed in class bodies and may only be used as part of a class member declaration, property access, or on the left-hand-side of an 'in' expression"),
      The_import_meta_meta_property_is_not_allowed_in_files_which_will_build_into_CommonJS_output: diag(1470, ts2.DiagnosticCategory.Error, "The_import_meta_meta_property_is_not_allowed_in_files_which_will_build_into_CommonJS_output_1470", "The 'import.meta' meta-property is not allowed in files which will build into CommonJS output."),
      Module_0_cannot_be_imported_using_this_construct_The_specifier_only_resolves_to_an_ES_module_which_cannot_be_imported_synchronously_Use_dynamic_import_instead: diag(1471, ts2.DiagnosticCategory.Error, "Module_0_cannot_be_imported_using_this_construct_The_specifier_only_resolves_to_an_ES_module_which_c_1471", "Module '{0}' cannot be imported using this construct. The specifier only resolves to an ES module, which cannot be imported synchronously. Use dynamic import instead."),
      The_types_of_0_are_incompatible_between_these_types: diag(2200, ts2.DiagnosticCategory.Error, "The_types_of_0_are_incompatible_between_these_types_2200", "The types of '{0}' are incompatible between these types."),
      The_types_returned_by_0_are_incompatible_between_these_types: diag(2201, ts2.DiagnosticCategory.Error, "The_types_returned_by_0_are_incompatible_between_these_types_2201", "The types returned by '{0}' are incompatible between these types."),
      Call_signature_return_types_0_and_1_are_incompatible: diag(2202, ts2.DiagnosticCategory.Error, "Call_signature_return_types_0_and_1_are_incompatible_2202", "Call signature return types '{0}' and '{1}' are incompatible.", void 0, true),
      Construct_signature_return_types_0_and_1_are_incompatible: diag(2203, ts2.DiagnosticCategory.Error, "Construct_signature_return_types_0_and_1_are_incompatible_2203", "Construct signature return types '{0}' and '{1}' are incompatible.", void 0, true),
      Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1: diag(2204, ts2.DiagnosticCategory.Error, "Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2204", "Call signatures with no arguments have incompatible return types '{0}' and '{1}'.", void 0, true),
      Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1: diag(2205, ts2.DiagnosticCategory.Error, "Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2205", "Construct signatures with no arguments have incompatible return types '{0}' and '{1}'.", void 0, true),
      The_type_modifier_cannot_be_used_on_a_named_import_when_import_type_is_used_on_its_import_statement: diag(2206, ts2.DiagnosticCategory.Error, "The_type_modifier_cannot_be_used_on_a_named_import_when_import_type_is_used_on_its_import_statement_2206", "The 'type' modifier cannot be used on a named import when 'import type' is used on its import statement."),
      The_type_modifier_cannot_be_used_on_a_named_export_when_export_type_is_used_on_its_export_statement: diag(2207, ts2.DiagnosticCategory.Error, "The_type_modifier_cannot_be_used_on_a_named_export_when_export_type_is_used_on_its_export_statement_2207", "The 'type' modifier cannot be used on a named export when 'export type' is used on its export statement."),
      Duplicate_identifier_0: diag(2300, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_2300", "Duplicate identifier '{0}'."),
      Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor: diag(2301, ts2.DiagnosticCategory.Error, "Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor_2301", "Initializer of instance member variable '{0}' cannot reference identifier '{1}' declared in the constructor."),
      Static_members_cannot_reference_class_type_parameters: diag(2302, ts2.DiagnosticCategory.Error, "Static_members_cannot_reference_class_type_parameters_2302", "Static members cannot reference class type parameters."),
      Circular_definition_of_import_alias_0: diag(2303, ts2.DiagnosticCategory.Error, "Circular_definition_of_import_alias_0_2303", "Circular definition of import alias '{0}'."),
      Cannot_find_name_0: diag(2304, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_2304", "Cannot find name '{0}'."),
      Module_0_has_no_exported_member_1: diag(2305, ts2.DiagnosticCategory.Error, "Module_0_has_no_exported_member_1_2305", "Module '{0}' has no exported member '{1}'."),
      File_0_is_not_a_module: diag(2306, ts2.DiagnosticCategory.Error, "File_0_is_not_a_module_2306", "File '{0}' is not a module."),
      Cannot_find_module_0_or_its_corresponding_type_declarations: diag(2307, ts2.DiagnosticCategory.Error, "Cannot_find_module_0_or_its_corresponding_type_declarations_2307", "Cannot find module '{0}' or its corresponding type declarations."),
      Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambiguity: diag(2308, ts2.DiagnosticCategory.Error, "Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambig_2308", "Module {0} has already exported a member named '{1}'. Consider explicitly re-exporting to resolve the ambiguity."),
      An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements: diag(2309, ts2.DiagnosticCategory.Error, "An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements_2309", "An export assignment cannot be used in a module with other exported elements."),
      Type_0_recursively_references_itself_as_a_base_type: diag(2310, ts2.DiagnosticCategory.Error, "Type_0_recursively_references_itself_as_a_base_type_2310", "Type '{0}' recursively references itself as a base type."),
      An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2312, ts2.DiagnosticCategory.Error, "An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_me_2312", "An interface can only extend an object type or intersection of object types with statically known members."),
      Type_parameter_0_has_a_circular_constraint: diag(2313, ts2.DiagnosticCategory.Error, "Type_parameter_0_has_a_circular_constraint_2313", "Type parameter '{0}' has a circular constraint."),
      Generic_type_0_requires_1_type_argument_s: diag(2314, ts2.DiagnosticCategory.Error, "Generic_type_0_requires_1_type_argument_s_2314", "Generic type '{0}' requires {1} type argument(s)."),
      Type_0_is_not_generic: diag(2315, ts2.DiagnosticCategory.Error, "Type_0_is_not_generic_2315", "Type '{0}' is not generic."),
      Global_type_0_must_be_a_class_or_interface_type: diag(2316, ts2.DiagnosticCategory.Error, "Global_type_0_must_be_a_class_or_interface_type_2316", "Global type '{0}' must be a class or interface type."),
      Global_type_0_must_have_1_type_parameter_s: diag(2317, ts2.DiagnosticCategory.Error, "Global_type_0_must_have_1_type_parameter_s_2317", "Global type '{0}' must have {1} type parameter(s)."),
      Cannot_find_global_type_0: diag(2318, ts2.DiagnosticCategory.Error, "Cannot_find_global_type_0_2318", "Cannot find global type '{0}'."),
      Named_property_0_of_types_1_and_2_are_not_identical: diag(2319, ts2.DiagnosticCategory.Error, "Named_property_0_of_types_1_and_2_are_not_identical_2319", "Named property '{0}' of types '{1}' and '{2}' are not identical."),
      Interface_0_cannot_simultaneously_extend_types_1_and_2: diag(2320, ts2.DiagnosticCategory.Error, "Interface_0_cannot_simultaneously_extend_types_1_and_2_2320", "Interface '{0}' cannot simultaneously extend types '{1}' and '{2}'."),
      Excessive_stack_depth_comparing_types_0_and_1: diag(2321, ts2.DiagnosticCategory.Error, "Excessive_stack_depth_comparing_types_0_and_1_2321", "Excessive stack depth comparing types '{0}' and '{1}'."),
      Type_0_is_not_assignable_to_type_1: diag(2322, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_2322", "Type '{0}' is not assignable to type '{1}'."),
      Cannot_redeclare_exported_variable_0: diag(2323, ts2.DiagnosticCategory.Error, "Cannot_redeclare_exported_variable_0_2323", "Cannot redeclare exported variable '{0}'."),
      Property_0_is_missing_in_type_1: diag(2324, ts2.DiagnosticCategory.Error, "Property_0_is_missing_in_type_1_2324", "Property '{0}' is missing in type '{1}'."),
      Property_0_is_private_in_type_1_but_not_in_type_2: diag(2325, ts2.DiagnosticCategory.Error, "Property_0_is_private_in_type_1_but_not_in_type_2_2325", "Property '{0}' is private in type '{1}' but not in type '{2}'."),
      Types_of_property_0_are_incompatible: diag(2326, ts2.DiagnosticCategory.Error, "Types_of_property_0_are_incompatible_2326", "Types of property '{0}' are incompatible."),
      Property_0_is_optional_in_type_1_but_required_in_type_2: diag(2327, ts2.DiagnosticCategory.Error, "Property_0_is_optional_in_type_1_but_required_in_type_2_2327", "Property '{0}' is optional in type '{1}' but required in type '{2}'."),
      Types_of_parameters_0_and_1_are_incompatible: diag(2328, ts2.DiagnosticCategory.Error, "Types_of_parameters_0_and_1_are_incompatible_2328", "Types of parameters '{0}' and '{1}' are incompatible."),
      Index_signature_for_type_0_is_missing_in_type_1: diag(2329, ts2.DiagnosticCategory.Error, "Index_signature_for_type_0_is_missing_in_type_1_2329", "Index signature for type '{0}' is missing in type '{1}'."),
      _0_and_1_index_signatures_are_incompatible: diag(2330, ts2.DiagnosticCategory.Error, "_0_and_1_index_signatures_are_incompatible_2330", "'{0}' and '{1}' index signatures are incompatible."),
      this_cannot_be_referenced_in_a_module_or_namespace_body: diag(2331, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_module_or_namespace_body_2331", "'this' cannot be referenced in a module or namespace body."),
      this_cannot_be_referenced_in_current_location: diag(2332, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_current_location_2332", "'this' cannot be referenced in current location."),
      this_cannot_be_referenced_in_constructor_arguments: diag(2333, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_constructor_arguments_2333", "'this' cannot be referenced in constructor arguments."),
      this_cannot_be_referenced_in_a_static_property_initializer: diag(2334, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_static_property_initializer_2334", "'this' cannot be referenced in a static property initializer."),
      super_can_only_be_referenced_in_a_derived_class: diag(2335, ts2.DiagnosticCategory.Error, "super_can_only_be_referenced_in_a_derived_class_2335", "'super' can only be referenced in a derived class."),
      super_cannot_be_referenced_in_constructor_arguments: diag(2336, ts2.DiagnosticCategory.Error, "super_cannot_be_referenced_in_constructor_arguments_2336", "'super' cannot be referenced in constructor arguments."),
      Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors: diag(2337, ts2.DiagnosticCategory.Error, "Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors_2337", "Super calls are not permitted outside constructors or in nested functions inside constructors."),
      super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_derived_class: diag(2338, ts2.DiagnosticCategory.Error, "super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_der_2338", "'super' property access is permitted only in a constructor, member function, or member accessor of a derived class."),
      Property_0_does_not_exist_on_type_1: diag(2339, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_2339", "Property '{0}' does not exist on type '{1}'."),
      Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword: diag(2340, ts2.DiagnosticCategory.Error, "Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword_2340", "Only public and protected methods of the base class are accessible via the 'super' keyword."),
      Property_0_is_private_and_only_accessible_within_class_1: diag(2341, ts2.DiagnosticCategory.Error, "Property_0_is_private_and_only_accessible_within_class_1_2341", "Property '{0}' is private and only accessible within class '{1}'."),
      This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_version_of_0: diag(2343, ts2.DiagnosticCategory.Error, "This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_ve_2343", "This syntax requires an imported helper named '{1}' which does not exist in '{0}'. Consider upgrading your version of '{0}'."),
      Type_0_does_not_satisfy_the_constraint_1: diag(2344, ts2.DiagnosticCategory.Error, "Type_0_does_not_satisfy_the_constraint_1_2344", "Type '{0}' does not satisfy the constraint '{1}'."),
      Argument_of_type_0_is_not_assignable_to_parameter_of_type_1: diag(2345, ts2.DiagnosticCategory.Error, "Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_2345", "Argument of type '{0}' is not assignable to parameter of type '{1}'."),
      Call_target_does_not_contain_any_signatures: diag(2346, ts2.DiagnosticCategory.Error, "Call_target_does_not_contain_any_signatures_2346", "Call target does not contain any signatures."),
      Untyped_function_calls_may_not_accept_type_arguments: diag(2347, ts2.DiagnosticCategory.Error, "Untyped_function_calls_may_not_accept_type_arguments_2347", "Untyped function calls may not accept type arguments."),
      Value_of_type_0_is_not_callable_Did_you_mean_to_include_new: diag(2348, ts2.DiagnosticCategory.Error, "Value_of_type_0_is_not_callable_Did_you_mean_to_include_new_2348", "Value of type '{0}' is not callable. Did you mean to include 'new'?"),
      This_expression_is_not_callable: diag(2349, ts2.DiagnosticCategory.Error, "This_expression_is_not_callable_2349", "This expression is not callable."),
      Only_a_void_function_can_be_called_with_the_new_keyword: diag(2350, ts2.DiagnosticCategory.Error, "Only_a_void_function_can_be_called_with_the_new_keyword_2350", "Only a void function can be called with the 'new' keyword."),
      This_expression_is_not_constructable: diag(2351, ts2.DiagnosticCategory.Error, "This_expression_is_not_constructable_2351", "This expression is not constructable."),
      Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the_other_If_this_was_intentional_convert_the_expression_to_unknown_first: diag(2352, ts2.DiagnosticCategory.Error, "Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the__2352", "Conversion of type '{0}' to type '{1}' may be a mistake because neither type sufficiently overlaps with the other. If this was intentional, convert the expression to 'unknown' first."),
      Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1: diag(2353, ts2.DiagnosticCategory.Error, "Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1_2353", "Object literal may only specify known properties, and '{0}' does not exist in type '{1}'."),
      This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found: diag(2354, ts2.DiagnosticCategory.Error, "This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found_2354", "This syntax requires an imported helper but module '{0}' cannot be found."),
      A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value: diag(2355, ts2.DiagnosticCategory.Error, "A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value_2355", "A function whose declared type is neither 'void' nor 'any' must return a value."),
      An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2356, ts2.DiagnosticCategory.Error, "An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type_2356", "An arithmetic operand must be of type 'any', 'number', 'bigint' or an enum type."),
      The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access: diag(2357, ts2.DiagnosticCategory.Error, "The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access_2357", "The operand of an increment or decrement operator must be a variable or a property access."),
      The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_parameter: diag(2358, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_paramete_2358", "The left-hand side of an 'instanceof' expression must be of type 'any', an object type or a type parameter."),
      The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_Function_interface_type: diag(2359, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_F_2359", "The right-hand side of an 'instanceof' expression must be of type 'any' or of a type assignable to the 'Function' interface type."),
      The_left_hand_side_of_an_in_expression_must_be_a_private_identifier_or_of_type_any_string_number_or_symbol: diag(2360, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_in_expression_must_be_a_private_identifier_or_of_type_any_string_number_or__2360", "The left-hand side of an 'in' expression must be a private identifier or of type 'any', 'string', 'number', or 'symbol'."),
      The_right_hand_side_of_an_in_expression_must_not_be_a_primitive: diag(2361, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_an_in_expression_must_not_be_a_primitive_2361", "The right-hand side of an 'in' expression must not be a primitive."),
      The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2362, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2362", "The left-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),
      The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2363, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2363", "The right-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),
      The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access: diag(2364, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access_2364", "The left-hand side of an assignment expression must be a variable or a property access."),
      Operator_0_cannot_be_applied_to_types_1_and_2: diag(2365, ts2.DiagnosticCategory.Error, "Operator_0_cannot_be_applied_to_types_1_and_2_2365", "Operator '{0}' cannot be applied to types '{1}' and '{2}'."),
      Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined: diag(2366, ts2.DiagnosticCategory.Error, "Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined_2366", "Function lacks ending return statement and return type does not include 'undefined'."),
      This_condition_will_always_return_0_since_the_types_1_and_2_have_no_overlap: diag(2367, ts2.DiagnosticCategory.Error, "This_condition_will_always_return_0_since_the_types_1_and_2_have_no_overlap_2367", "This condition will always return '{0}' since the types '{1}' and '{2}' have no overlap."),
      Type_parameter_name_cannot_be_0: diag(2368, ts2.DiagnosticCategory.Error, "Type_parameter_name_cannot_be_0_2368", "Type parameter name cannot be '{0}'."),
      A_parameter_property_is_only_allowed_in_a_constructor_implementation: diag(2369, ts2.DiagnosticCategory.Error, "A_parameter_property_is_only_allowed_in_a_constructor_implementation_2369", "A parameter property is only allowed in a constructor implementation."),
      A_rest_parameter_must_be_of_an_array_type: diag(2370, ts2.DiagnosticCategory.Error, "A_rest_parameter_must_be_of_an_array_type_2370", "A rest parameter must be of an array type."),
      A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation: diag(2371, ts2.DiagnosticCategory.Error, "A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation_2371", "A parameter initializer is only allowed in a function or constructor implementation."),
      Parameter_0_cannot_reference_itself: diag(2372, ts2.DiagnosticCategory.Error, "Parameter_0_cannot_reference_itself_2372", "Parameter '{0}' cannot reference itself."),
      Parameter_0_cannot_reference_identifier_1_declared_after_it: diag(2373, ts2.DiagnosticCategory.Error, "Parameter_0_cannot_reference_identifier_1_declared_after_it_2373", "Parameter '{0}' cannot reference identifier '{1}' declared after it."),
      Duplicate_index_signature_for_type_0: diag(2374, ts2.DiagnosticCategory.Error, "Duplicate_index_signature_for_type_0_2374", "Duplicate index signature for type '{0}'."),
      Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefined_to_the_types_of_the_target_s_properties: diag(2375, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefi_2375", "Type '{0}' is not assignable to type '{1}' with 'exactOptionalPropertyTypes: true'. Consider adding 'undefined' to the types of the target's properties."),
      A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_properties_parameter_properties_or_private_identifiers: diag(2376, ts2.DiagnosticCategory.Error, "A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_proper_2376", "A 'super' call must be the first statement in the constructor when a class contains initialized properties, parameter properties, or private identifiers."),
      Constructors_for_derived_classes_must_contain_a_super_call: diag(2377, ts2.DiagnosticCategory.Error, "Constructors_for_derived_classes_must_contain_a_super_call_2377", "Constructors for derived classes must contain a 'super' call."),
      A_get_accessor_must_return_a_value: diag(2378, ts2.DiagnosticCategory.Error, "A_get_accessor_must_return_a_value_2378", "A 'get' accessor must return a value."),
      Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefined_to_the_types_of_the_target_s_properties: diag(2379, ts2.DiagnosticCategory.Error, "Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_with_exactOptionalPropertyTypes_Colon_tr_2379", "Argument of type '{0}' is not assignable to parameter of type '{1}' with 'exactOptionalPropertyTypes: true'. Consider adding 'undefined' to the types of the target's properties."),
      The_return_type_of_a_get_accessor_must_be_assignable_to_its_set_accessor_type: diag(2380, ts2.DiagnosticCategory.Error, "The_return_type_of_a_get_accessor_must_be_assignable_to_its_set_accessor_type_2380", "The return type of a 'get' accessor must be assignable to its 'set' accessor type"),
      Overload_signatures_must_all_be_exported_or_non_exported: diag(2383, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_exported_or_non_exported_2383", "Overload signatures must all be exported or non-exported."),
      Overload_signatures_must_all_be_ambient_or_non_ambient: diag(2384, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_ambient_or_non_ambient_2384", "Overload signatures must all be ambient or non-ambient."),
      Overload_signatures_must_all_be_public_private_or_protected: diag(2385, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_public_private_or_protected_2385", "Overload signatures must all be public, private or protected."),
      Overload_signatures_must_all_be_optional_or_required: diag(2386, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_optional_or_required_2386", "Overload signatures must all be optional or required."),
      Function_overload_must_be_static: diag(2387, ts2.DiagnosticCategory.Error, "Function_overload_must_be_static_2387", "Function overload must be static."),
      Function_overload_must_not_be_static: diag(2388, ts2.DiagnosticCategory.Error, "Function_overload_must_not_be_static_2388", "Function overload must not be static."),
      Function_implementation_name_must_be_0: diag(2389, ts2.DiagnosticCategory.Error, "Function_implementation_name_must_be_0_2389", "Function implementation name must be '{0}'."),
      Constructor_implementation_is_missing: diag(2390, ts2.DiagnosticCategory.Error, "Constructor_implementation_is_missing_2390", "Constructor implementation is missing."),
      Function_implementation_is_missing_or_not_immediately_following_the_declaration: diag(2391, ts2.DiagnosticCategory.Error, "Function_implementation_is_missing_or_not_immediately_following_the_declaration_2391", "Function implementation is missing or not immediately following the declaration."),
      Multiple_constructor_implementations_are_not_allowed: diag(2392, ts2.DiagnosticCategory.Error, "Multiple_constructor_implementations_are_not_allowed_2392", "Multiple constructor implementations are not allowed."),
      Duplicate_function_implementation: diag(2393, ts2.DiagnosticCategory.Error, "Duplicate_function_implementation_2393", "Duplicate function implementation."),
      This_overload_signature_is_not_compatible_with_its_implementation_signature: diag(2394, ts2.DiagnosticCategory.Error, "This_overload_signature_is_not_compatible_with_its_implementation_signature_2394", "This overload signature is not compatible with its implementation signature."),
      Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local: diag(2395, ts2.DiagnosticCategory.Error, "Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local_2395", "Individual declarations in merged declaration '{0}' must be all exported or all local."),
      Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters: diag(2396, ts2.DiagnosticCategory.Error, "Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters_2396", "Duplicate identifier 'arguments'. Compiler uses 'arguments' to initialize rest parameters."),
      Declaration_name_conflicts_with_built_in_global_identifier_0: diag(2397, ts2.DiagnosticCategory.Error, "Declaration_name_conflicts_with_built_in_global_identifier_0_2397", "Declaration name conflicts with built-in global identifier '{0}'."),
      constructor_cannot_be_used_as_a_parameter_property_name: diag(2398, ts2.DiagnosticCategory.Error, "constructor_cannot_be_used_as_a_parameter_property_name_2398", "'constructor' cannot be used as a parameter property name."),
      Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference: diag(2399, ts2.DiagnosticCategory.Error, "Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference_2399", "Duplicate identifier '_this'. Compiler uses variable declaration '_this' to capture 'this' reference."),
      Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference: diag(2400, ts2.DiagnosticCategory.Error, "Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference_2400", "Expression resolves to variable declaration '_this' that compiler uses to capture 'this' reference."),
      Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference: diag(2402, ts2.DiagnosticCategory.Error, "Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference_2402", "Expression resolves to '_super' that compiler uses to capture base class reference."),
      Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_type_2: diag(2403, ts2.DiagnosticCategory.Error, "Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_t_2403", "Subsequent variable declarations must have the same type.  Variable '{0}' must be of type '{1}', but here has type '{2}'."),
      The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation: diag(2404, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation_2404", "The left-hand side of a 'for...in' statement cannot use a type annotation."),
      The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any: diag(2405, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any_2405", "The left-hand side of a 'for...in' statement must be of type 'string' or 'any'."),
      The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access: diag(2406, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access_2406", "The left-hand side of a 'for...in' statement must be a variable or a property access."),
      The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_here_has_type_0: diag(2407, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_2407", "The right-hand side of a 'for...in' statement must be of type 'any', an object type or a type parameter, but here has type '{0}'."),
      Setters_cannot_return_a_value: diag(2408, ts2.DiagnosticCategory.Error, "Setters_cannot_return_a_value_2408", "Setters cannot return a value."),
      Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class: diag(2409, ts2.DiagnosticCategory.Error, "Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class_2409", "Return type of constructor signature must be assignable to the instance type of the class."),
      The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any: diag(2410, ts2.DiagnosticCategory.Error, "The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any_2410", "The 'with' statement is not supported. All symbols in a 'with' block will have type 'any'."),
      Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefined_to_the_type_of_the_target: diag(2412, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefi_2412", "Type '{0}' is not assignable to type '{1}' with 'exactOptionalPropertyTypes: true'. Consider adding 'undefined' to the type of the target."),
      Property_0_of_type_1_is_not_assignable_to_2_index_type_3: diag(2411, ts2.DiagnosticCategory.Error, "Property_0_of_type_1_is_not_assignable_to_2_index_type_3_2411", "Property '{0}' of type '{1}' is not assignable to '{2}' index type '{3}'."),
      _0_index_type_1_is_not_assignable_to_2_index_type_3: diag(2413, ts2.DiagnosticCategory.Error, "_0_index_type_1_is_not_assignable_to_2_index_type_3_2413", "'{0}' index type '{1}' is not assignable to '{2}' index type '{3}'."),
      Class_name_cannot_be_0: diag(2414, ts2.DiagnosticCategory.Error, "Class_name_cannot_be_0_2414", "Class name cannot be '{0}'."),
      Class_0_incorrectly_extends_base_class_1: diag(2415, ts2.DiagnosticCategory.Error, "Class_0_incorrectly_extends_base_class_1_2415", "Class '{0}' incorrectly extends base class '{1}'."),
      Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2: diag(2416, ts2.DiagnosticCategory.Error, "Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2_2416", "Property '{0}' in type '{1}' is not assignable to the same property in base type '{2}'."),
      Class_static_side_0_incorrectly_extends_base_class_static_side_1: diag(2417, ts2.DiagnosticCategory.Error, "Class_static_side_0_incorrectly_extends_base_class_static_side_1_2417", "Class static side '{0}' incorrectly extends base class static side '{1}'."),
      Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1: diag(2418, ts2.DiagnosticCategory.Error, "Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1_2418", "Type of computed property's value is '{0}', which is not assignable to type '{1}'."),
      Types_of_construct_signatures_are_incompatible: diag(2419, ts2.DiagnosticCategory.Error, "Types_of_construct_signatures_are_incompatible_2419", "Types of construct signatures are incompatible."),
      Class_0_incorrectly_implements_interface_1: diag(2420, ts2.DiagnosticCategory.Error, "Class_0_incorrectly_implements_interface_1_2420", "Class '{0}' incorrectly implements interface '{1}'."),
      A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2422, ts2.DiagnosticCategory.Error, "A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_memb_2422", "A class can only implement an object type or intersection of object types with statically known members."),
      Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_accessor: diag(2423, ts2.DiagnosticCategory.Error, "Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_access_2423", "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member accessor."),
      Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_function: diag(2425, ts2.DiagnosticCategory.Error, "Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_functi_2425", "Class '{0}' defines instance member property '{1}', but extended class '{2}' defines it as instance member function."),
      Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_function: diag(2426, ts2.DiagnosticCategory.Error, "Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_functi_2426", "Class '{0}' defines instance member accessor '{1}', but extended class '{2}' defines it as instance member function."),
      Interface_name_cannot_be_0: diag(2427, ts2.DiagnosticCategory.Error, "Interface_name_cannot_be_0_2427", "Interface name cannot be '{0}'."),
      All_declarations_of_0_must_have_identical_type_parameters: diag(2428, ts2.DiagnosticCategory.Error, "All_declarations_of_0_must_have_identical_type_parameters_2428", "All declarations of '{0}' must have identical type parameters."),
      Interface_0_incorrectly_extends_interface_1: diag(2430, ts2.DiagnosticCategory.Error, "Interface_0_incorrectly_extends_interface_1_2430", "Interface '{0}' incorrectly extends interface '{1}'."),
      Enum_name_cannot_be_0: diag(2431, ts2.DiagnosticCategory.Error, "Enum_name_cannot_be_0_2431", "Enum name cannot be '{0}'."),
      In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enum_element: diag(2432, ts2.DiagnosticCategory.Error, "In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enu_2432", "In an enum with multiple declarations, only one declaration can omit an initializer for its first enum element."),
      A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merged: diag(2433, ts2.DiagnosticCategory.Error, "A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merg_2433", "A namespace declaration cannot be in a different file from a class or function with which it is merged."),
      A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged: diag(2434, ts2.DiagnosticCategory.Error, "A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged_2434", "A namespace declaration cannot be located prior to a class or function with which it is merged."),
      Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces: diag(2435, ts2.DiagnosticCategory.Error, "Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces_2435", "Ambient modules cannot be nested in other modules or namespaces."),
      Ambient_module_declaration_cannot_specify_relative_module_name: diag(2436, ts2.DiagnosticCategory.Error, "Ambient_module_declaration_cannot_specify_relative_module_name_2436", "Ambient module declaration cannot specify relative module name."),
      Module_0_is_hidden_by_a_local_declaration_with_the_same_name: diag(2437, ts2.DiagnosticCategory.Error, "Module_0_is_hidden_by_a_local_declaration_with_the_same_name_2437", "Module '{0}' is hidden by a local declaration with the same name."),
      Import_name_cannot_be_0: diag(2438, ts2.DiagnosticCategory.Error, "Import_name_cannot_be_0_2438", "Import name cannot be '{0}'."),
      Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relative_module_name: diag(2439, ts2.DiagnosticCategory.Error, "Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relati_2439", "Import or export declaration in an ambient module declaration cannot reference module through relative module name."),
      Import_declaration_conflicts_with_local_declaration_of_0: diag(2440, ts2.DiagnosticCategory.Error, "Import_declaration_conflicts_with_local_declaration_of_0_2440", "Import declaration conflicts with local declaration of '{0}'."),
      Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module: diag(2441, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_2441", "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module."),
      Types_have_separate_declarations_of_a_private_property_0: diag(2442, ts2.DiagnosticCategory.Error, "Types_have_separate_declarations_of_a_private_property_0_2442", "Types have separate declarations of a private property '{0}'."),
      Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2: diag(2443, ts2.DiagnosticCategory.Error, "Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2_2443", "Property '{0}' is protected but type '{1}' is not a class derived from '{2}'."),
      Property_0_is_protected_in_type_1_but_public_in_type_2: diag(2444, ts2.DiagnosticCategory.Error, "Property_0_is_protected_in_type_1_but_public_in_type_2_2444", "Property '{0}' is protected in type '{1}' but public in type '{2}'."),
      Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses: diag(2445, ts2.DiagnosticCategory.Error, "Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses_2445", "Property '{0}' is protected and only accessible within class '{1}' and its subclasses."),
      Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1_This_is_an_instance_of_class_2: diag(2446, ts2.DiagnosticCategory.Error, "Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1_This_is_an_instance_of_cl_2446", "Property '{0}' is protected and only accessible through an instance of class '{1}'. This is an instance of class '{2}'."),
      The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead: diag(2447, ts2.DiagnosticCategory.Error, "The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead_2447", "The '{0}' operator is not allowed for boolean types. Consider using '{1}' instead."),
      Block_scoped_variable_0_used_before_its_declaration: diag(2448, ts2.DiagnosticCategory.Error, "Block_scoped_variable_0_used_before_its_declaration_2448", "Block-scoped variable '{0}' used before its declaration."),
      Class_0_used_before_its_declaration: diag(2449, ts2.DiagnosticCategory.Error, "Class_0_used_before_its_declaration_2449", "Class '{0}' used before its declaration."),
      Enum_0_used_before_its_declaration: diag(2450, ts2.DiagnosticCategory.Error, "Enum_0_used_before_its_declaration_2450", "Enum '{0}' used before its declaration."),
      Cannot_redeclare_block_scoped_variable_0: diag(2451, ts2.DiagnosticCategory.Error, "Cannot_redeclare_block_scoped_variable_0_2451", "Cannot redeclare block-scoped variable '{0}'."),
      An_enum_member_cannot_have_a_numeric_name: diag(2452, ts2.DiagnosticCategory.Error, "An_enum_member_cannot_have_a_numeric_name_2452", "An enum member cannot have a numeric name."),
      Variable_0_is_used_before_being_assigned: diag(2454, ts2.DiagnosticCategory.Error, "Variable_0_is_used_before_being_assigned_2454", "Variable '{0}' is used before being assigned."),
      Type_alias_0_circularly_references_itself: diag(2456, ts2.DiagnosticCategory.Error, "Type_alias_0_circularly_references_itself_2456", "Type alias '{0}' circularly references itself."),
      Type_alias_name_cannot_be_0: diag(2457, ts2.DiagnosticCategory.Error, "Type_alias_name_cannot_be_0_2457", "Type alias name cannot be '{0}'."),
      An_AMD_module_cannot_have_multiple_name_assignments: diag(2458, ts2.DiagnosticCategory.Error, "An_AMD_module_cannot_have_multiple_name_assignments_2458", "An AMD module cannot have multiple name assignments."),
      Module_0_declares_1_locally_but_it_is_not_exported: diag(2459, ts2.DiagnosticCategory.Error, "Module_0_declares_1_locally_but_it_is_not_exported_2459", "Module '{0}' declares '{1}' locally, but it is not exported."),
      Module_0_declares_1_locally_but_it_is_exported_as_2: diag(2460, ts2.DiagnosticCategory.Error, "Module_0_declares_1_locally_but_it_is_exported_as_2_2460", "Module '{0}' declares '{1}' locally, but it is exported as '{2}'."),
      Type_0_is_not_an_array_type: diag(2461, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_2461", "Type '{0}' is not an array type."),
      A_rest_element_must_be_last_in_a_destructuring_pattern: diag(2462, ts2.DiagnosticCategory.Error, "A_rest_element_must_be_last_in_a_destructuring_pattern_2462", "A rest element must be last in a destructuring pattern."),
      A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature: diag(2463, ts2.DiagnosticCategory.Error, "A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature_2463", "A binding pattern parameter cannot be optional in an implementation signature."),
      A_computed_property_name_must_be_of_type_string_number_symbol_or_any: diag(2464, ts2.DiagnosticCategory.Error, "A_computed_property_name_must_be_of_type_string_number_symbol_or_any_2464", "A computed property name must be of type 'string', 'number', 'symbol', or 'any'."),
      this_cannot_be_referenced_in_a_computed_property_name: diag(2465, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_computed_property_name_2465", "'this' cannot be referenced in a computed property name."),
      super_cannot_be_referenced_in_a_computed_property_name: diag(2466, ts2.DiagnosticCategory.Error, "super_cannot_be_referenced_in_a_computed_property_name_2466", "'super' cannot be referenced in a computed property name."),
      A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type: diag(2467, ts2.DiagnosticCategory.Error, "A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type_2467", "A computed property name cannot reference a type parameter from its containing type."),
      Cannot_find_global_value_0: diag(2468, ts2.DiagnosticCategory.Error, "Cannot_find_global_value_0_2468", "Cannot find global value '{0}'."),
      The_0_operator_cannot_be_applied_to_type_symbol: diag(2469, ts2.DiagnosticCategory.Error, "The_0_operator_cannot_be_applied_to_type_symbol_2469", "The '{0}' operator cannot be applied to type 'symbol'."),
      Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher: diag(2472, ts2.DiagnosticCategory.Error, "Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher_2472", "Spread operator in 'new' expressions is only available when targeting ECMAScript 5 and higher."),
      Enum_declarations_must_all_be_const_or_non_const: diag(2473, ts2.DiagnosticCategory.Error, "Enum_declarations_must_all_be_const_or_non_const_2473", "Enum declarations must all be const or non-const."),
      const_enum_member_initializers_can_only_contain_literal_values_and_other_computed_enum_values: diag(2474, ts2.DiagnosticCategory.Error, "const_enum_member_initializers_can_only_contain_literal_values_and_other_computed_enum_values_2474", "const enum member initializers can only contain literal values and other computed enum values."),
      const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_import_declaration_or_export_assignment_or_type_query: diag(2475, ts2.DiagnosticCategory.Error, "const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_im_2475", "'const' enums can only be used in property or index access expressions or the right hand side of an import declaration or export assignment or type query."),
      A_const_enum_member_can_only_be_accessed_using_a_string_literal: diag(2476, ts2.DiagnosticCategory.Error, "A_const_enum_member_can_only_be_accessed_using_a_string_literal_2476", "A const enum member can only be accessed using a string literal."),
      const_enum_member_initializer_was_evaluated_to_a_non_finite_value: diag(2477, ts2.DiagnosticCategory.Error, "const_enum_member_initializer_was_evaluated_to_a_non_finite_value_2477", "'const' enum member initializer was evaluated to a non-finite value."),
      const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN: diag(2478, ts2.DiagnosticCategory.Error, "const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN_2478", "'const' enum member initializer was evaluated to disallowed value 'NaN'."),
      let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations: diag(2480, ts2.DiagnosticCategory.Error, "let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations_2480", "'let' is not allowed to be used as a name in 'let' or 'const' declarations."),
      Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1: diag(2481, ts2.DiagnosticCategory.Error, "Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1_2481", "Cannot initialize outer scoped variable '{0}' in the same scope as block scoped declaration '{1}'."),
      The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation: diag(2483, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation_2483", "The left-hand side of a 'for...of' statement cannot use a type annotation."),
      Export_declaration_conflicts_with_exported_declaration_of_0: diag(2484, ts2.DiagnosticCategory.Error, "Export_declaration_conflicts_with_exported_declaration_of_0_2484", "Export declaration conflicts with exported declaration of '{0}'."),
      The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access: diag(2487, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access_2487", "The left-hand side of a 'for...of' statement must be a variable or a property access."),
      Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2488, ts2.DiagnosticCategory.Error, "Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator_2488", "Type '{0}' must have a '[Symbol.iterator]()' method that returns an iterator."),
      An_iterator_must_have_a_next_method: diag(2489, ts2.DiagnosticCategory.Error, "An_iterator_must_have_a_next_method_2489", "An iterator must have a 'next()' method."),
      The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property: diag(2490, ts2.DiagnosticCategory.Error, "The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property_2490", "The type returned by the '{0}()' method of an iterator must have a 'value' property."),
      The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern: diag(2491, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern_2491", "The left-hand side of a 'for...in' statement cannot be a destructuring pattern."),
      Cannot_redeclare_identifier_0_in_catch_clause: diag(2492, ts2.DiagnosticCategory.Error, "Cannot_redeclare_identifier_0_in_catch_clause_2492", "Cannot redeclare identifier '{0}' in catch clause."),
      Tuple_type_0_of_length_1_has_no_element_at_index_2: diag(2493, ts2.DiagnosticCategory.Error, "Tuple_type_0_of_length_1_has_no_element_at_index_2_2493", "Tuple type '{0}' of length '{1}' has no element at index '{2}'."),
      Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher: diag(2494, ts2.DiagnosticCategory.Error, "Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher_2494", "Using a string in a 'for...of' statement is only supported in ECMAScript 5 and higher."),
      Type_0_is_not_an_array_type_or_a_string_type: diag(2495, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_2495", "Type '{0}' is not an array type or a string type."),
      The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_standard_function_expression: diag(2496, ts2.DiagnosticCategory.Error, "The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_stand_2496", "The 'arguments' object cannot be referenced in an arrow function in ES3 and ES5. Consider using a standard function expression."),
      This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_referencing_its_default_export: diag(2497, ts2.DiagnosticCategory.Error, "This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_2497", "This module can only be referenced with ECMAScript imports/exports by turning on the '{0}' flag and referencing its default export."),
      Module_0_uses_export_and_cannot_be_used_with_export_Asterisk: diag(2498, ts2.DiagnosticCategory.Error, "Module_0_uses_export_and_cannot_be_used_with_export_Asterisk_2498", "Module '{0}' uses 'export =' and cannot be used with 'export *'."),
      An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments: diag(2499, ts2.DiagnosticCategory.Error, "An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments_2499", "An interface can only extend an identifier/qualified-name with optional type arguments."),
      A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments: diag(2500, ts2.DiagnosticCategory.Error, "A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments_2500", "A class can only implement an identifier/qualified-name with optional type arguments."),
      A_rest_element_cannot_contain_a_binding_pattern: diag(2501, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_contain_a_binding_pattern_2501", "A rest element cannot contain a binding pattern."),
      _0_is_referenced_directly_or_indirectly_in_its_own_type_annotation: diag(2502, ts2.DiagnosticCategory.Error, "_0_is_referenced_directly_or_indirectly_in_its_own_type_annotation_2502", "'{0}' is referenced directly or indirectly in its own type annotation."),
      Cannot_find_namespace_0: diag(2503, ts2.DiagnosticCategory.Error, "Cannot_find_namespace_0_2503", "Cannot find namespace '{0}'."),
      Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator: diag(2504, ts2.DiagnosticCategory.Error, "Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator_2504", "Type '{0}' must have a '[Symbol.asyncIterator]()' method that returns an async iterator."),
      A_generator_cannot_have_a_void_type_annotation: diag(2505, ts2.DiagnosticCategory.Error, "A_generator_cannot_have_a_void_type_annotation_2505", "A generator cannot have a 'void' type annotation."),
      _0_is_referenced_directly_or_indirectly_in_its_own_base_expression: diag(2506, ts2.DiagnosticCategory.Error, "_0_is_referenced_directly_or_indirectly_in_its_own_base_expression_2506", "'{0}' is referenced directly or indirectly in its own base expression."),
      Type_0_is_not_a_constructor_function_type: diag(2507, ts2.DiagnosticCategory.Error, "Type_0_is_not_a_constructor_function_type_2507", "Type '{0}' is not a constructor function type."),
      No_base_constructor_has_the_specified_number_of_type_arguments: diag(2508, ts2.DiagnosticCategory.Error, "No_base_constructor_has_the_specified_number_of_type_arguments_2508", "No base constructor has the specified number of type arguments."),
      Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2509, ts2.DiagnosticCategory.Error, "Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_2509", "Base constructor return type '{0}' is not an object type or intersection of object types with statically known members."),
      Base_constructors_must_all_have_the_same_return_type: diag(2510, ts2.DiagnosticCategory.Error, "Base_constructors_must_all_have_the_same_return_type_2510", "Base constructors must all have the same return type."),
      Cannot_create_an_instance_of_an_abstract_class: diag(2511, ts2.DiagnosticCategory.Error, "Cannot_create_an_instance_of_an_abstract_class_2511", "Cannot create an instance of an abstract class."),
      Overload_signatures_must_all_be_abstract_or_non_abstract: diag(2512, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_abstract_or_non_abstract_2512", "Overload signatures must all be abstract or non-abstract."),
      Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression: diag(2513, ts2.DiagnosticCategory.Error, "Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression_2513", "Abstract method '{0}' in class '{1}' cannot be accessed via super expression."),
      Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2: diag(2515, ts2.DiagnosticCategory.Error, "Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2_2515", "Non-abstract class '{0}' does not implement inherited abstract member '{1}' from class '{2}'."),
      All_declarations_of_an_abstract_method_must_be_consecutive: diag(2516, ts2.DiagnosticCategory.Error, "All_declarations_of_an_abstract_method_must_be_consecutive_2516", "All declarations of an abstract method must be consecutive."),
      Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type: diag(2517, ts2.DiagnosticCategory.Error, "Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type_2517", "Cannot assign an abstract constructor type to a non-abstract constructor type."),
      A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard: diag(2518, ts2.DiagnosticCategory.Error, "A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard_2518", "A 'this'-based type guard is not compatible with a parameter-based type guard."),
      An_async_iterator_must_have_a_next_method: diag(2519, ts2.DiagnosticCategory.Error, "An_async_iterator_must_have_a_next_method_2519", "An async iterator must have a 'next()' method."),
      Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions: diag(2520, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions_2520", "Duplicate identifier '{0}'. Compiler uses declaration '{1}' to support async functions."),
      The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_using_a_standard_function_or_method: diag(2522, ts2.DiagnosticCategory.Error, "The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_usi_2522", "The 'arguments' object cannot be referenced in an async function or method in ES3 and ES5. Consider using a standard function or method."),
      yield_expressions_cannot_be_used_in_a_parameter_initializer: diag(2523, ts2.DiagnosticCategory.Error, "yield_expressions_cannot_be_used_in_a_parameter_initializer_2523", "'yield' expressions cannot be used in a parameter initializer."),
      await_expressions_cannot_be_used_in_a_parameter_initializer: diag(2524, ts2.DiagnosticCategory.Error, "await_expressions_cannot_be_used_in_a_parameter_initializer_2524", "'await' expressions cannot be used in a parameter initializer."),
      Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value: diag(2525, ts2.DiagnosticCategory.Error, "Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value_2525", "Initializer provides no value for this binding element and the binding element has no default value."),
      A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface: diag(2526, ts2.DiagnosticCategory.Error, "A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface_2526", "A 'this' type is available only in a non-static member of a class or interface."),
      The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary: diag(2527, ts2.DiagnosticCategory.Error, "The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary_2527", "The inferred type of '{0}' references an inaccessible '{1}' type. A type annotation is necessary."),
      A_module_cannot_have_multiple_default_exports: diag(2528, ts2.DiagnosticCategory.Error, "A_module_cannot_have_multiple_default_exports_2528", "A module cannot have multiple default exports."),
      Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_functions: diag(2529, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_func_2529", "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module containing async functions."),
      Property_0_is_incompatible_with_index_signature: diag(2530, ts2.DiagnosticCategory.Error, "Property_0_is_incompatible_with_index_signature_2530", "Property '{0}' is incompatible with index signature."),
      Object_is_possibly_null: diag(2531, ts2.DiagnosticCategory.Error, "Object_is_possibly_null_2531", "Object is possibly 'null'."),
      Object_is_possibly_undefined: diag(2532, ts2.DiagnosticCategory.Error, "Object_is_possibly_undefined_2532", "Object is possibly 'undefined'."),
      Object_is_possibly_null_or_undefined: diag(2533, ts2.DiagnosticCategory.Error, "Object_is_possibly_null_or_undefined_2533", "Object is possibly 'null' or 'undefined'."),
      A_function_returning_never_cannot_have_a_reachable_end_point: diag(2534, ts2.DiagnosticCategory.Error, "A_function_returning_never_cannot_have_a_reachable_end_point_2534", "A function returning 'never' cannot have a reachable end point."),
      Enum_type_0_has_members_with_initializers_that_are_not_literals: diag(2535, ts2.DiagnosticCategory.Error, "Enum_type_0_has_members_with_initializers_that_are_not_literals_2535", "Enum type '{0}' has members with initializers that are not literals."),
      Type_0_cannot_be_used_to_index_type_1: diag(2536, ts2.DiagnosticCategory.Error, "Type_0_cannot_be_used_to_index_type_1_2536", "Type '{0}' cannot be used to index type '{1}'."),
      Type_0_has_no_matching_index_signature_for_type_1: diag(2537, ts2.DiagnosticCategory.Error, "Type_0_has_no_matching_index_signature_for_type_1_2537", "Type '{0}' has no matching index signature for type '{1}'."),
      Type_0_cannot_be_used_as_an_index_type: diag(2538, ts2.DiagnosticCategory.Error, "Type_0_cannot_be_used_as_an_index_type_2538", "Type '{0}' cannot be used as an index type."),
      Cannot_assign_to_0_because_it_is_not_a_variable: diag(2539, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_not_a_variable_2539", "Cannot assign to '{0}' because it is not a variable."),
      Cannot_assign_to_0_because_it_is_a_read_only_property: diag(2540, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_read_only_property_2540", "Cannot assign to '{0}' because it is a read-only property."),
      Index_signature_in_type_0_only_permits_reading: diag(2542, ts2.DiagnosticCategory.Error, "Index_signature_in_type_0_only_permits_reading_2542", "Index signature in type '{0}' only permits reading."),
      Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_meta_property_reference: diag(2543, ts2.DiagnosticCategory.Error, "Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_me_2543", "Duplicate identifier '_newTarget'. Compiler uses variable declaration '_newTarget' to capture 'new.target' meta-property reference."),
      Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta_property_reference: diag(2544, ts2.DiagnosticCategory.Error, "Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta__2544", "Expression resolves to variable declaration '_newTarget' that compiler uses to capture 'new.target' meta-property reference."),
      A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any: diag(2545, ts2.DiagnosticCategory.Error, "A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any_2545", "A mixin class must have a constructor with a single rest parameter of type 'any[]'."),
      The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_property: diag(2547, ts2.DiagnosticCategory.Error, "The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_pro_2547", "The type returned by the '{0}()' method of an async iterator must be a promise for a type with a 'value' property."),
      Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2548, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator_2548", "Type '{0}' is not an array type or does not have a '[Symbol.iterator]()' method that returns an iterator."),
      Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2549, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns__2549", "Type '{0}' is not an array type or a string type or does not have a '[Symbol.iterator]()' method that returns an iterator."),
      Property_0_does_not_exist_on_type_1_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2_or_later: diag(2550, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Do_you_need_to_change_your_target_library_Try_changing_the_lib_c_2550", "Property '{0}' does not exist on type '{1}'. Do you need to change your target library? Try changing the 'lib' compiler option to '{2}' or later."),
      Property_0_does_not_exist_on_type_1_Did_you_mean_2: diag(2551, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Did_you_mean_2_2551", "Property '{0}' does not exist on type '{1}'. Did you mean '{2}'?"),
      Cannot_find_name_0_Did_you_mean_1: diag(2552, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_1_2552", "Cannot find name '{0}'. Did you mean '{1}'?"),
      Computed_values_are_not_permitted_in_an_enum_with_string_valued_members: diag(2553, ts2.DiagnosticCategory.Error, "Computed_values_are_not_permitted_in_an_enum_with_string_valued_members_2553", "Computed values are not permitted in an enum with string valued members."),
      Expected_0_arguments_but_got_1: diag(2554, ts2.DiagnosticCategory.Error, "Expected_0_arguments_but_got_1_2554", "Expected {0} arguments, but got {1}."),
      Expected_at_least_0_arguments_but_got_1: diag(2555, ts2.DiagnosticCategory.Error, "Expected_at_least_0_arguments_but_got_1_2555", "Expected at least {0} arguments, but got {1}."),
      A_spread_argument_must_either_have_a_tuple_type_or_be_passed_to_a_rest_parameter: diag(2556, ts2.DiagnosticCategory.Error, "A_spread_argument_must_either_have_a_tuple_type_or_be_passed_to_a_rest_parameter_2556", "A spread argument must either have a tuple type or be passed to a rest parameter."),
      Expected_0_type_arguments_but_got_1: diag(2558, ts2.DiagnosticCategory.Error, "Expected_0_type_arguments_but_got_1_2558", "Expected {0} type arguments, but got {1}."),
      Type_0_has_no_properties_in_common_with_type_1: diag(2559, ts2.DiagnosticCategory.Error, "Type_0_has_no_properties_in_common_with_type_1_2559", "Type '{0}' has no properties in common with type '{1}'."),
      Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it: diag(2560, ts2.DiagnosticCategory.Error, "Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it_2560", "Value of type '{0}' has no properties in common with type '{1}'. Did you mean to call it?"),
      Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_write_2: diag(2561, ts2.DiagnosticCategory.Error, "Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_writ_2561", "Object literal may only specify known properties, but '{0}' does not exist in type '{1}'. Did you mean to write '{2}'?"),
      Base_class_expressions_cannot_reference_class_type_parameters: diag(2562, ts2.DiagnosticCategory.Error, "Base_class_expressions_cannot_reference_class_type_parameters_2562", "Base class expressions cannot reference class type parameters."),
      The_containing_function_or_module_body_is_too_large_for_control_flow_analysis: diag(2563, ts2.DiagnosticCategory.Error, "The_containing_function_or_module_body_is_too_large_for_control_flow_analysis_2563", "The containing function or module body is too large for control flow analysis."),
      Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor: diag(2564, ts2.DiagnosticCategory.Error, "Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor_2564", "Property '{0}' has no initializer and is not definitely assigned in the constructor."),
      Property_0_is_used_before_being_assigned: diag(2565, ts2.DiagnosticCategory.Error, "Property_0_is_used_before_being_assigned_2565", "Property '{0}' is used before being assigned."),
      A_rest_element_cannot_have_a_property_name: diag(2566, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_have_a_property_name_2566", "A rest element cannot have a property name."),
      Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations: diag(2567, ts2.DiagnosticCategory.Error, "Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations_2567", "Enum declarations can only merge with namespace or other enum declarations."),
      Property_0_may_not_exist_on_type_1_Did_you_mean_2: diag(2568, ts2.DiagnosticCategory.Error, "Property_0_may_not_exist_on_type_1_Did_you_mean_2_2568", "Property '{0}' may not exist on type '{1}'. Did you mean '{2}'?"),
      Type_0_is_not_an_array_type_or_a_string_type_Use_compiler_option_downlevelIteration_to_allow_iterating_of_iterators: diag(2569, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_Use_compiler_option_downlevelIteration_to_allow_iterati_2569", "Type '{0}' is not an array type or a string type. Use compiler option '--downlevelIteration' to allow iterating of iterators."),
      Could_not_find_name_0_Did_you_mean_1: diag(2570, ts2.DiagnosticCategory.Error, "Could_not_find_name_0_Did_you_mean_1_2570", "Could not find name '{0}'. Did you mean '{1}'?"),
      Object_is_of_type_unknown: diag(2571, ts2.DiagnosticCategory.Error, "Object_is_of_type_unknown_2571", "Object is of type 'unknown'."),
      A_rest_element_type_must_be_an_array_type: diag(2574, ts2.DiagnosticCategory.Error, "A_rest_element_type_must_be_an_array_type_2574", "A rest element type must be an array type."),
      No_overload_expects_0_arguments_but_overloads_do_exist_that_expect_either_1_or_2_arguments: diag(2575, ts2.DiagnosticCategory.Error, "No_overload_expects_0_arguments_but_overloads_do_exist_that_expect_either_1_or_2_arguments_2575", "No overload expects {0} arguments, but overloads do exist that expect either {1} or {2} arguments."),
      Property_0_does_not_exist_on_type_1_Did_you_mean_to_access_the_static_member_2_instead: diag(2576, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Did_you_mean_to_access_the_static_member_2_instead_2576", "Property '{0}' does not exist on type '{1}'. Did you mean to access the static member '{2}' instead?"),
      Return_type_annotation_circularly_references_itself: diag(2577, ts2.DiagnosticCategory.Error, "Return_type_annotation_circularly_references_itself_2577", "Return type annotation circularly references itself."),
      Unused_ts_expect_error_directive: diag(2578, ts2.DiagnosticCategory.Error, "Unused_ts_expect_error_directive_2578", "Unused '@ts-expect-error' directive."),
      Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashnode: diag(2580, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashno_2580", "Cannot find name '{0}'. Do you need to install type definitions for node? Try `npm i --save-dev @types/node`."),
      Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slashjquery: diag(2581, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slash_2581", "Cannot find name '{0}'. Do you need to install type definitions for jQuery? Try `npm i --save-dev @types/jquery`."),
      Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_types_Slashjest_or_npm_i_save_dev_types_Slashmocha: diag(2582, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_type_2582", "Cannot find name '{0}'. Do you need to install type definitions for a test runner? Try `npm i --save-dev @types/jest` or `npm i --save-dev @types/mocha`."),
      Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_1_or_later: diag(2583, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2583", "Cannot find name '{0}'. Do you need to change your target library? Try changing the 'lib' compiler option to '{1}' or later."),
      Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_include_dom: diag(2584, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2584", "Cannot find name '{0}'. Do you need to change your target library? Try changing the 'lib' compiler option to include 'dom'."),
      _0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_es2015_or_later: diag(2585, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Do_you_need_to_change_your_target_library_2585", "'{0}' only refers to a type, but is being used as a value here. Do you need to change your target library? Try changing the 'lib' compiler option to es2015 or later."),
      Cannot_assign_to_0_because_it_is_a_constant: diag(2588, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_constant_2588", "Cannot assign to '{0}' because it is a constant."),
      Type_instantiation_is_excessively_deep_and_possibly_infinite: diag(2589, ts2.DiagnosticCategory.Error, "Type_instantiation_is_excessively_deep_and_possibly_infinite_2589", "Type instantiation is excessively deep and possibly infinite."),
      Expression_produces_a_union_type_that_is_too_complex_to_represent: diag(2590, ts2.DiagnosticCategory.Error, "Expression_produces_a_union_type_that_is_too_complex_to_represent_2590", "Expression produces a union type that is too complex to represent."),
      Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashnode_and_then_add_node_to_the_types_field_in_your_tsconfig: diag(2591, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashno_2591", "Cannot find name '{0}'. Do you need to install type definitions for node? Try `npm i --save-dev @types/node` and then add 'node' to the types field in your tsconfig."),
      Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slashjquery_and_then_add_jquery_to_the_types_field_in_your_tsconfig: diag(2592, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slash_2592", "Cannot find name '{0}'. Do you need to install type definitions for jQuery? Try `npm i --save-dev @types/jquery` and then add 'jquery' to the types field in your tsconfig."),
      Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_types_Slashjest_or_npm_i_save_dev_types_Slashmocha_and_then_add_jest_or_mocha_to_the_types_field_in_your_tsconfig: diag(2593, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_type_2593", "Cannot find name '{0}'. Do you need to install type definitions for a test runner? Try `npm i --save-dev @types/jest` or `npm i --save-dev @types/mocha` and then add 'jest' or 'mocha' to the types field in your tsconfig."),
      This_module_is_declared_with_using_export_and_can_only_be_used_with_a_default_import_when_using_the_0_flag: diag(2594, ts2.DiagnosticCategory.Error, "This_module_is_declared_with_using_export_and_can_only_be_used_with_a_default_import_when_using_the__2594", "This module is declared with using 'export =', and can only be used with a default import when using the '{0}' flag."),
      _0_can_only_be_imported_by_using_a_default_import: diag(2595, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_a_default_import_2595", "'{0}' can only be imported by using a default import."),
      _0_can_only_be_imported_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2596, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import_2596", "'{0}' can only be imported by turning on the 'esModuleInterop' flag and using a default import."),
      _0_can_only_be_imported_by_using_a_require_call_or_by_using_a_default_import: diag(2597, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_a_require_call_or_by_using_a_default_import_2597", "'{0}' can only be imported by using a 'require' call or by using a default import."),
      _0_can_only_be_imported_by_using_a_require_call_or_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2598, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_a_require_call_or_by_turning_on_the_esModuleInterop_flag_and_using__2598", "'{0}' can only be imported by using a 'require' call or by turning on the 'esModuleInterop' flag and using a default import."),
      JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist: diag(2602, ts2.DiagnosticCategory.Error, "JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist_2602", "JSX element implicitly has type 'any' because the global type 'JSX.Element' does not exist."),
      Property_0_in_type_1_is_not_assignable_to_type_2: diag(2603, ts2.DiagnosticCategory.Error, "Property_0_in_type_1_is_not_assignable_to_type_2_2603", "Property '{0}' in type '{1}' is not assignable to type '{2}'."),
      JSX_element_type_0_does_not_have_any_construct_or_call_signatures: diag(2604, ts2.DiagnosticCategory.Error, "JSX_element_type_0_does_not_have_any_construct_or_call_signatures_2604", "JSX element type '{0}' does not have any construct or call signatures."),
      Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property: diag(2606, ts2.DiagnosticCategory.Error, "Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property_2606", "Property '{0}' of JSX spread attribute is not assignable to target property."),
      JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property: diag(2607, ts2.DiagnosticCategory.Error, "JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property_2607", "JSX element class does not support attributes because it does not have a '{0}' property."),
      The_global_type_JSX_0_may_not_have_more_than_one_property: diag(2608, ts2.DiagnosticCategory.Error, "The_global_type_JSX_0_may_not_have_more_than_one_property_2608", "The global type 'JSX.{0}' may not have more than one property."),
      JSX_spread_child_must_be_an_array_type: diag(2609, ts2.DiagnosticCategory.Error, "JSX_spread_child_must_be_an_array_type_2609", "JSX spread child must be an array type."),
      _0_is_defined_as_an_accessor_in_class_1_but_is_overridden_here_in_2_as_an_instance_property: diag(2610, ts2.DiagnosticCategory.Error, "_0_is_defined_as_an_accessor_in_class_1_but_is_overridden_here_in_2_as_an_instance_property_2610", "'{0}' is defined as an accessor in class '{1}', but is overridden here in '{2}' as an instance property."),
      _0_is_defined_as_a_property_in_class_1_but_is_overridden_here_in_2_as_an_accessor: diag(2611, ts2.DiagnosticCategory.Error, "_0_is_defined_as_a_property_in_class_1_but_is_overridden_here_in_2_as_an_accessor_2611", "'{0}' is defined as a property in class '{1}', but is overridden here in '{2}' as an accessor."),
      Property_0_will_overwrite_the_base_property_in_1_If_this_is_intentional_add_an_initializer_Otherwise_add_a_declare_modifier_or_remove_the_redundant_declaration: diag(2612, ts2.DiagnosticCategory.Error, "Property_0_will_overwrite_the_base_property_in_1_If_this_is_intentional_add_an_initializer_Otherwise_2612", "Property '{0}' will overwrite the base property in '{1}'. If this is intentional, add an initializer. Otherwise, add a 'declare' modifier or remove the redundant declaration."),
      Module_0_has_no_default_export_Did_you_mean_to_use_import_1_from_0_instead: diag(2613, ts2.DiagnosticCategory.Error, "Module_0_has_no_default_export_Did_you_mean_to_use_import_1_from_0_instead_2613", "Module '{0}' has no default export. Did you mean to use 'import { {1} } from {0}' instead?"),
      Module_0_has_no_exported_member_1_Did_you_mean_to_use_import_1_from_0_instead: diag(2614, ts2.DiagnosticCategory.Error, "Module_0_has_no_exported_member_1_Did_you_mean_to_use_import_1_from_0_instead_2614", "Module '{0}' has no exported member '{1}'. Did you mean to use 'import {1} from {0}' instead?"),
      Type_of_property_0_circularly_references_itself_in_mapped_type_1: diag(2615, ts2.DiagnosticCategory.Error, "Type_of_property_0_circularly_references_itself_in_mapped_type_1_2615", "Type of property '{0}' circularly references itself in mapped type '{1}'."),
      _0_can_only_be_imported_by_using_import_1_require_2_or_a_default_import: diag(2616, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_import_1_require_2_or_a_default_import_2616", "'{0}' can only be imported by using 'import {1} = require({2})' or a default import."),
      _0_can_only_be_imported_by_using_import_1_require_2_or_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2617, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_import_1_require_2_or_by_turning_on_the_esModuleInterop_flag_and_us_2617", "'{0}' can only be imported by using 'import {1} = require({2})' or by turning on the 'esModuleInterop' flag and using a default import."),
      Source_has_0_element_s_but_target_requires_1: diag(2618, ts2.DiagnosticCategory.Error, "Source_has_0_element_s_but_target_requires_1_2618", "Source has {0} element(s) but target requires {1}."),
      Source_has_0_element_s_but_target_allows_only_1: diag(2619, ts2.DiagnosticCategory.Error, "Source_has_0_element_s_but_target_allows_only_1_2619", "Source has {0} element(s) but target allows only {1}."),
      Target_requires_0_element_s_but_source_may_have_fewer: diag(2620, ts2.DiagnosticCategory.Error, "Target_requires_0_element_s_but_source_may_have_fewer_2620", "Target requires {0} element(s) but source may have fewer."),
      Target_allows_only_0_element_s_but_source_may_have_more: diag(2621, ts2.DiagnosticCategory.Error, "Target_allows_only_0_element_s_but_source_may_have_more_2621", "Target allows only {0} element(s) but source may have more."),
      Source_provides_no_match_for_required_element_at_position_0_in_target: diag(2623, ts2.DiagnosticCategory.Error, "Source_provides_no_match_for_required_element_at_position_0_in_target_2623", "Source provides no match for required element at position {0} in target."),
      Source_provides_no_match_for_variadic_element_at_position_0_in_target: diag(2624, ts2.DiagnosticCategory.Error, "Source_provides_no_match_for_variadic_element_at_position_0_in_target_2624", "Source provides no match for variadic element at position {0} in target."),
      Variadic_element_at_position_0_in_source_does_not_match_element_at_position_1_in_target: diag(2625, ts2.DiagnosticCategory.Error, "Variadic_element_at_position_0_in_source_does_not_match_element_at_position_1_in_target_2625", "Variadic element at position {0} in source does not match element at position {1} in target."),
      Type_at_position_0_in_source_is_not_compatible_with_type_at_position_1_in_target: diag(2626, ts2.DiagnosticCategory.Error, "Type_at_position_0_in_source_is_not_compatible_with_type_at_position_1_in_target_2626", "Type at position {0} in source is not compatible with type at position {1} in target."),
      Type_at_positions_0_through_1_in_source_is_not_compatible_with_type_at_position_2_in_target: diag(2627, ts2.DiagnosticCategory.Error, "Type_at_positions_0_through_1_in_source_is_not_compatible_with_type_at_position_2_in_target_2627", "Type at positions {0} through {1} in source is not compatible with type at position {2} in target."),
      Cannot_assign_to_0_because_it_is_an_enum: diag(2628, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_an_enum_2628", "Cannot assign to '{0}' because it is an enum."),
      Cannot_assign_to_0_because_it_is_a_class: diag(2629, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_class_2629", "Cannot assign to '{0}' because it is a class."),
      Cannot_assign_to_0_because_it_is_a_function: diag(2630, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_function_2630", "Cannot assign to '{0}' because it is a function."),
      Cannot_assign_to_0_because_it_is_a_namespace: diag(2631, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_namespace_2631", "Cannot assign to '{0}' because it is a namespace."),
      Cannot_assign_to_0_because_it_is_an_import: diag(2632, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_an_import_2632", "Cannot assign to '{0}' because it is an import."),
      JSX_property_access_expressions_cannot_include_JSX_namespace_names: diag(2633, ts2.DiagnosticCategory.Error, "JSX_property_access_expressions_cannot_include_JSX_namespace_names_2633", "JSX property access expressions cannot include JSX namespace names"),
      _0_index_signatures_are_incompatible: diag(2634, ts2.DiagnosticCategory.Error, "_0_index_signatures_are_incompatible_2634", "'{0}' index signatures are incompatible."),
      Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity: diag(2649, ts2.DiagnosticCategory.Error, "Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity_2649", "Cannot augment module '{0}' with value exports because it resolves to a non-module entity."),
      A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_members_defined_in_other_enums: diag(2651, ts2.DiagnosticCategory.Error, "A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_memb_2651", "A member initializer in a enum declaration cannot reference members declared after it, including members defined in other enums."),
      Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_default_0_declaration_instead: diag(2652, ts2.DiagnosticCategory.Error, "Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_d_2652", "Merged declaration '{0}' cannot include a default export declaration. Consider adding a separate 'export default {0}' declaration instead."),
      Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1: diag(2653, ts2.DiagnosticCategory.Error, "Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1_2653", "Non-abstract class expression does not implement inherited abstract member '{0}' from class '{1}'."),
      JSX_expressions_must_have_one_parent_element: diag(2657, ts2.DiagnosticCategory.Error, "JSX_expressions_must_have_one_parent_element_2657", "JSX expressions must have one parent element."),
      Type_0_provides_no_match_for_the_signature_1: diag(2658, ts2.DiagnosticCategory.Error, "Type_0_provides_no_match_for_the_signature_1_2658", "Type '{0}' provides no match for the signature '{1}'."),
      super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_higher: diag(2659, ts2.DiagnosticCategory.Error, "super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_highe_2659", "'super' is only allowed in members of object literal expressions when option 'target' is 'ES2015' or higher."),
      super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions: diag(2660, ts2.DiagnosticCategory.Error, "super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions_2660", "'super' can only be referenced in members of derived classes or object literal expressions."),
      Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module: diag(2661, ts2.DiagnosticCategory.Error, "Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module_2661", "Cannot export '{0}'. Only local declarations can be exported from a module."),
      Cannot_find_name_0_Did_you_mean_the_static_member_1_0: diag(2662, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_the_static_member_1_0_2662", "Cannot find name '{0}'. Did you mean the static member '{1}.{0}'?"),
      Cannot_find_name_0_Did_you_mean_the_instance_member_this_0: diag(2663, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_the_instance_member_this_0_2663", "Cannot find name '{0}'. Did you mean the instance member 'this.{0}'?"),
      Invalid_module_name_in_augmentation_module_0_cannot_be_found: diag(2664, ts2.DiagnosticCategory.Error, "Invalid_module_name_in_augmentation_module_0_cannot_be_found_2664", "Invalid module name in augmentation, module '{0}' cannot be found."),
      Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augmented: diag(2665, ts2.DiagnosticCategory.Error, "Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augm_2665", "Invalid module name in augmentation. Module '{0}' resolves to an untyped module at '{1}', which cannot be augmented."),
      Exports_and_export_assignments_are_not_permitted_in_module_augmentations: diag(2666, ts2.DiagnosticCategory.Error, "Exports_and_export_assignments_are_not_permitted_in_module_augmentations_2666", "Exports and export assignments are not permitted in module augmentations."),
      Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_module: diag(2667, ts2.DiagnosticCategory.Error, "Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_mod_2667", "Imports are not permitted in module augmentations. Consider moving them to the enclosing external module."),
      export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always_visible: diag(2668, ts2.DiagnosticCategory.Error, "export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always__2668", "'export' modifier cannot be applied to ambient modules and module augmentations since they are always visible."),
      Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_declarations: diag(2669, ts2.DiagnosticCategory.Error, "Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_2669", "Augmentations for the global scope can only be directly nested in external modules or ambient module declarations."),
      Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambient_context: diag(2670, ts2.DiagnosticCategory.Error, "Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambien_2670", "Augmentations for the global scope should have 'declare' modifier unless they appear in already ambient context."),
      Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity: diag(2671, ts2.DiagnosticCategory.Error, "Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity_2671", "Cannot augment module '{0}' because it resolves to a non-module entity."),
      Cannot_assign_a_0_constructor_type_to_a_1_constructor_type: diag(2672, ts2.DiagnosticCategory.Error, "Cannot_assign_a_0_constructor_type_to_a_1_constructor_type_2672", "Cannot assign a '{0}' constructor type to a '{1}' constructor type."),
      Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration: diag(2673, ts2.DiagnosticCategory.Error, "Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration_2673", "Constructor of class '{0}' is private and only accessible within the class declaration."),
      Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration: diag(2674, ts2.DiagnosticCategory.Error, "Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration_2674", "Constructor of class '{0}' is protected and only accessible within the class declaration."),
      Cannot_extend_a_class_0_Class_constructor_is_marked_as_private: diag(2675, ts2.DiagnosticCategory.Error, "Cannot_extend_a_class_0_Class_constructor_is_marked_as_private_2675", "Cannot extend a class '{0}'. Class constructor is marked as private."),
      Accessors_must_both_be_abstract_or_non_abstract: diag(2676, ts2.DiagnosticCategory.Error, "Accessors_must_both_be_abstract_or_non_abstract_2676", "Accessors must both be abstract or non-abstract."),
      A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type: diag(2677, ts2.DiagnosticCategory.Error, "A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type_2677", "A type predicate's type must be assignable to its parameter's type."),
      Type_0_is_not_comparable_to_type_1: diag(2678, ts2.DiagnosticCategory.Error, "Type_0_is_not_comparable_to_type_1_2678", "Type '{0}' is not comparable to type '{1}'."),
      A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void: diag(2679, ts2.DiagnosticCategory.Error, "A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void_2679", "A function that is called with the 'new' keyword cannot have a 'this' type that is 'void'."),
      A_0_parameter_must_be_the_first_parameter: diag(2680, ts2.DiagnosticCategory.Error, "A_0_parameter_must_be_the_first_parameter_2680", "A '{0}' parameter must be the first parameter."),
      A_constructor_cannot_have_a_this_parameter: diag(2681, ts2.DiagnosticCategory.Error, "A_constructor_cannot_have_a_this_parameter_2681", "A constructor cannot have a 'this' parameter."),
      this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation: diag(2683, ts2.DiagnosticCategory.Error, "this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_2683", "'this' implicitly has type 'any' because it does not have a type annotation."),
      The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1: diag(2684, ts2.DiagnosticCategory.Error, "The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1_2684", "The 'this' context of type '{0}' is not assignable to method's 'this' of type '{1}'."),
      The_this_types_of_each_signature_are_incompatible: diag(2685, ts2.DiagnosticCategory.Error, "The_this_types_of_each_signature_are_incompatible_2685", "The 'this' types of each signature are incompatible."),
      _0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead: diag(2686, ts2.DiagnosticCategory.Error, "_0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead_2686", "'{0}' refers to a UMD global, but the current file is a module. Consider adding an import instead."),
      All_declarations_of_0_must_have_identical_modifiers: diag(2687, ts2.DiagnosticCategory.Error, "All_declarations_of_0_must_have_identical_modifiers_2687", "All declarations of '{0}' must have identical modifiers."),
      Cannot_find_type_definition_file_for_0: diag(2688, ts2.DiagnosticCategory.Error, "Cannot_find_type_definition_file_for_0_2688", "Cannot find type definition file for '{0}'."),
      Cannot_extend_an_interface_0_Did_you_mean_implements: diag(2689, ts2.DiagnosticCategory.Error, "Cannot_extend_an_interface_0_Did_you_mean_implements_2689", "Cannot extend an interface '{0}'. Did you mean 'implements'?"),
      _0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Did_you_mean_to_use_1_in_0: diag(2690, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Did_you_mean_to_use_1_in_0_2690", "'{0}' only refers to a type, but is being used as a value here. Did you mean to use '{1} in {0}'?"),
      An_import_path_cannot_end_with_a_0_extension_Consider_importing_1_instead: diag(2691, ts2.DiagnosticCategory.Error, "An_import_path_cannot_end_with_a_0_extension_Consider_importing_1_instead_2691", "An import path cannot end with a '{0}' extension. Consider importing '{1}' instead."),
      _0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible: diag(2692, ts2.DiagnosticCategory.Error, "_0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible_2692", "'{0}' is a primitive, but '{1}' is a wrapper object. Prefer using '{0}' when possible."),
      _0_only_refers_to_a_type_but_is_being_used_as_a_value_here: diag(2693, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_2693", "'{0}' only refers to a type, but is being used as a value here."),
      Namespace_0_has_no_exported_member_1: diag(2694, ts2.DiagnosticCategory.Error, "Namespace_0_has_no_exported_member_1_2694", "Namespace '{0}' has no exported member '{1}'."),
      Left_side_of_comma_operator_is_unused_and_has_no_side_effects: diag(2695, ts2.DiagnosticCategory.Error, "Left_side_of_comma_operator_is_unused_and_has_no_side_effects_2695", "Left side of comma operator is unused and has no side effects.", true),
      The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead: diag(2696, ts2.DiagnosticCategory.Error, "The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead_2696", "The 'Object' type is assignable to very few other types. Did you mean to use the 'any' type instead?"),
      An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option: diag(2697, ts2.DiagnosticCategory.Error, "An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_in_2697", "An async function or method must return a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your '--lib' option."),
      Spread_types_may_only_be_created_from_object_types: diag(2698, ts2.DiagnosticCategory.Error, "Spread_types_may_only_be_created_from_object_types_2698", "Spread types may only be created from object types."),
      Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1: diag(2699, ts2.DiagnosticCategory.Error, "Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1_2699", "Static property '{0}' conflicts with built-in property 'Function.{0}' of constructor function '{1}'."),
      Rest_types_may_only_be_created_from_object_types: diag(2700, ts2.DiagnosticCategory.Error, "Rest_types_may_only_be_created_from_object_types_2700", "Rest types may only be created from object types."),
      The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access: diag(2701, ts2.DiagnosticCategory.Error, "The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access_2701", "The target of an object rest assignment must be a variable or a property access."),
      _0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here: diag(2702, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here_2702", "'{0}' only refers to a type, but is being used as a namespace here."),
      The_operand_of_a_delete_operator_must_be_a_property_reference: diag(2703, ts2.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_must_be_a_property_reference_2703", "The operand of a 'delete' operator must be a property reference."),
      The_operand_of_a_delete_operator_cannot_be_a_read_only_property: diag(2704, ts2.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_cannot_be_a_read_only_property_2704", "The operand of a 'delete' operator cannot be a read-only property."),
      An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option: diag(2705, ts2.DiagnosticCategory.Error, "An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_de_2705", "An async function or method in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your '--lib' option."),
      Required_type_parameters_may_not_follow_optional_type_parameters: diag(2706, ts2.DiagnosticCategory.Error, "Required_type_parameters_may_not_follow_optional_type_parameters_2706", "Required type parameters may not follow optional type parameters."),
      Generic_type_0_requires_between_1_and_2_type_arguments: diag(2707, ts2.DiagnosticCategory.Error, "Generic_type_0_requires_between_1_and_2_type_arguments_2707", "Generic type '{0}' requires between {1} and {2} type arguments."),
      Cannot_use_namespace_0_as_a_value: diag(2708, ts2.DiagnosticCategory.Error, "Cannot_use_namespace_0_as_a_value_2708", "Cannot use namespace '{0}' as a value."),
      Cannot_use_namespace_0_as_a_type: diag(2709, ts2.DiagnosticCategory.Error, "Cannot_use_namespace_0_as_a_type_2709", "Cannot use namespace '{0}' as a type."),
      _0_are_specified_twice_The_attribute_named_0_will_be_overwritten: diag(2710, ts2.DiagnosticCategory.Error, "_0_are_specified_twice_The_attribute_named_0_will_be_overwritten_2710", "'{0}' are specified twice. The attribute named '{0}' will be overwritten."),
      A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option: diag(2711, ts2.DiagnosticCategory.Error, "A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES20_2711", "A dynamic import call returns a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your '--lib' option."),
      A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option: diag(2712, ts2.DiagnosticCategory.Error, "A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declarat_2712", "A dynamic import call in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your '--lib' option."),
      Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_property_1_in_0_with_0_1: diag(2713, ts2.DiagnosticCategory.Error, "Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_p_2713", `Cannot access '{0}.{1}' because '{0}' is a type, but not a namespace. Did you mean to retrieve the type of the property '{1}' in '{0}' with '{0}["{1}"]'?`),
      The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context: diag(2714, ts2.DiagnosticCategory.Error, "The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context_2714", "The expression of an export assignment must be an identifier or qualified name in an ambient context."),
      Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor: diag(2715, ts2.DiagnosticCategory.Error, "Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor_2715", "Abstract property '{0}' in class '{1}' cannot be accessed in the constructor."),
      Type_parameter_0_has_a_circular_default: diag(2716, ts2.DiagnosticCategory.Error, "Type_parameter_0_has_a_circular_default_2716", "Type parameter '{0}' has a circular default."),
      Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_type_2: diag(2717, ts2.DiagnosticCategory.Error, "Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_t_2717", "Subsequent property declarations must have the same type.  Property '{0}' must be of type '{1}', but here has type '{2}'."),
      Duplicate_property_0: diag(2718, ts2.DiagnosticCategory.Error, "Duplicate_property_0_2718", "Duplicate property '{0}'."),
      Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated: diag(2719, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated_2719", "Type '{0}' is not assignable to type '{1}'. Two different types with this name exist, but they are unrelated."),
      Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclass: diag(2720, ts2.DiagnosticCategory.Error, "Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclas_2720", "Class '{0}' incorrectly implements class '{1}'. Did you mean to extend '{1}' and inherit its members as a subclass?"),
      Cannot_invoke_an_object_which_is_possibly_null: diag(2721, ts2.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_null_2721", "Cannot invoke an object which is possibly 'null'."),
      Cannot_invoke_an_object_which_is_possibly_undefined: diag(2722, ts2.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_undefined_2722", "Cannot invoke an object which is possibly 'undefined'."),
      Cannot_invoke_an_object_which_is_possibly_null_or_undefined: diag(2723, ts2.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_null_or_undefined_2723", "Cannot invoke an object which is possibly 'null' or 'undefined'."),
      _0_has_no_exported_member_named_1_Did_you_mean_2: diag(2724, ts2.DiagnosticCategory.Error, "_0_has_no_exported_member_named_1_Did_you_mean_2_2724", "'{0}' has no exported member named '{1}'. Did you mean '{2}'?"),
      Class_name_cannot_be_Object_when_targeting_ES5_with_module_0: diag(2725, ts2.DiagnosticCategory.Error, "Class_name_cannot_be_Object_when_targeting_ES5_with_module_0_2725", "Class name cannot be 'Object' when targeting ES5 with module {0}."),
      Cannot_find_lib_definition_for_0: diag(2726, ts2.DiagnosticCategory.Error, "Cannot_find_lib_definition_for_0_2726", "Cannot find lib definition for '{0}'."),
      Cannot_find_lib_definition_for_0_Did_you_mean_1: diag(2727, ts2.DiagnosticCategory.Error, "Cannot_find_lib_definition_for_0_Did_you_mean_1_2727", "Cannot find lib definition for '{0}'. Did you mean '{1}'?"),
      _0_is_declared_here: diag(2728, ts2.DiagnosticCategory.Message, "_0_is_declared_here_2728", "'{0}' is declared here."),
      Property_0_is_used_before_its_initialization: diag(2729, ts2.DiagnosticCategory.Error, "Property_0_is_used_before_its_initialization_2729", "Property '{0}' is used before its initialization."),
      An_arrow_function_cannot_have_a_this_parameter: diag(2730, ts2.DiagnosticCategory.Error, "An_arrow_function_cannot_have_a_this_parameter_2730", "An arrow function cannot have a 'this' parameter."),
      Implicit_conversion_of_a_symbol_to_a_string_will_fail_at_runtime_Consider_wrapping_this_expression_in_String: diag(2731, ts2.DiagnosticCategory.Error, "Implicit_conversion_of_a_symbol_to_a_string_will_fail_at_runtime_Consider_wrapping_this_expression_i_2731", "Implicit conversion of a 'symbol' to a 'string' will fail at runtime. Consider wrapping this expression in 'String(...)'."),
      Cannot_find_module_0_Consider_using_resolveJsonModule_to_import_module_with_json_extension: diag(2732, ts2.DiagnosticCategory.Error, "Cannot_find_module_0_Consider_using_resolveJsonModule_to_import_module_with_json_extension_2732", "Cannot find module '{0}'. Consider using '--resolveJsonModule' to import module with '.json' extension."),
      Property_0_was_also_declared_here: diag(2733, ts2.DiagnosticCategory.Error, "Property_0_was_also_declared_here_2733", "Property '{0}' was also declared here."),
      Are_you_missing_a_semicolon: diag(2734, ts2.DiagnosticCategory.Error, "Are_you_missing_a_semicolon_2734", "Are you missing a semicolon?"),
      Did_you_mean_for_0_to_be_constrained_to_type_new_args_Colon_any_1: diag(2735, ts2.DiagnosticCategory.Error, "Did_you_mean_for_0_to_be_constrained_to_type_new_args_Colon_any_1_2735", "Did you mean for '{0}' to be constrained to type 'new (...args: any[]) => {1}'?"),
      Operator_0_cannot_be_applied_to_type_1: diag(2736, ts2.DiagnosticCategory.Error, "Operator_0_cannot_be_applied_to_type_1_2736", "Operator '{0}' cannot be applied to type '{1}'."),
      BigInt_literals_are_not_available_when_targeting_lower_than_ES2020: diag(2737, ts2.DiagnosticCategory.Error, "BigInt_literals_are_not_available_when_targeting_lower_than_ES2020_2737", "BigInt literals are not available when targeting lower than ES2020."),
      An_outer_value_of_this_is_shadowed_by_this_container: diag(2738, ts2.DiagnosticCategory.Message, "An_outer_value_of_this_is_shadowed_by_this_container_2738", "An outer value of 'this' is shadowed by this container."),
      Type_0_is_missing_the_following_properties_from_type_1_Colon_2: diag(2739, ts2.DiagnosticCategory.Error, "Type_0_is_missing_the_following_properties_from_type_1_Colon_2_2739", "Type '{0}' is missing the following properties from type '{1}': {2}"),
      Type_0_is_missing_the_following_properties_from_type_1_Colon_2_and_3_more: diag(2740, ts2.DiagnosticCategory.Error, "Type_0_is_missing_the_following_properties_from_type_1_Colon_2_and_3_more_2740", "Type '{0}' is missing the following properties from type '{1}': {2}, and {3} more."),
      Property_0_is_missing_in_type_1_but_required_in_type_2: diag(2741, ts2.DiagnosticCategory.Error, "Property_0_is_missing_in_type_1_but_required_in_type_2_2741", "Property '{0}' is missing in type '{1}' but required in type '{2}'."),
      The_inferred_type_of_0_cannot_be_named_without_a_reference_to_1_This_is_likely_not_portable_A_type_annotation_is_necessary: diag(2742, ts2.DiagnosticCategory.Error, "The_inferred_type_of_0_cannot_be_named_without_a_reference_to_1_This_is_likely_not_portable_A_type_a_2742", "The inferred type of '{0}' cannot be named without a reference to '{1}'. This is likely not portable. A type annotation is necessary."),
      No_overload_expects_0_type_arguments_but_overloads_do_exist_that_expect_either_1_or_2_type_arguments: diag(2743, ts2.DiagnosticCategory.Error, "No_overload_expects_0_type_arguments_but_overloads_do_exist_that_expect_either_1_or_2_type_arguments_2743", "No overload expects {0} type arguments, but overloads do exist that expect either {1} or {2} type arguments."),
      Type_parameter_defaults_can_only_reference_previously_declared_type_parameters: diag(2744, ts2.DiagnosticCategory.Error, "Type_parameter_defaults_can_only_reference_previously_declared_type_parameters_2744", "Type parameter defaults can only reference previously declared type parameters."),
      This_JSX_tag_s_0_prop_expects_type_1_which_requires_multiple_children_but_only_a_single_child_was_provided: diag(2745, ts2.DiagnosticCategory.Error, "This_JSX_tag_s_0_prop_expects_type_1_which_requires_multiple_children_but_only_a_single_child_was_pr_2745", "This JSX tag's '{0}' prop expects type '{1}' which requires multiple children, but only a single child was provided."),
      This_JSX_tag_s_0_prop_expects_a_single_child_of_type_1_but_multiple_children_were_provided: diag(2746, ts2.DiagnosticCategory.Error, "This_JSX_tag_s_0_prop_expects_a_single_child_of_type_1_but_multiple_children_were_provided_2746", "This JSX tag's '{0}' prop expects a single child of type '{1}', but multiple children were provided."),
      _0_components_don_t_accept_text_as_child_elements_Text_in_JSX_has_the_type_string_but_the_expected_type_of_1_is_2: diag(2747, ts2.DiagnosticCategory.Error, "_0_components_don_t_accept_text_as_child_elements_Text_in_JSX_has_the_type_string_but_the_expected_t_2747", "'{0}' components don't accept text as child elements. Text in JSX has the type 'string', but the expected type of '{1}' is '{2}'."),
      Cannot_access_ambient_const_enums_when_the_isolatedModules_flag_is_provided: diag(2748, ts2.DiagnosticCategory.Error, "Cannot_access_ambient_const_enums_when_the_isolatedModules_flag_is_provided_2748", "Cannot access ambient const enums when the '--isolatedModules' flag is provided."),
      _0_refers_to_a_value_but_is_being_used_as_a_type_here_Did_you_mean_typeof_0: diag(2749, ts2.DiagnosticCategory.Error, "_0_refers_to_a_value_but_is_being_used_as_a_type_here_Did_you_mean_typeof_0_2749", "'{0}' refers to a value, but is being used as a type here. Did you mean 'typeof {0}'?"),
      The_implementation_signature_is_declared_here: diag(2750, ts2.DiagnosticCategory.Error, "The_implementation_signature_is_declared_here_2750", "The implementation signature is declared here."),
      Circularity_originates_in_type_at_this_location: diag(2751, ts2.DiagnosticCategory.Error, "Circularity_originates_in_type_at_this_location_2751", "Circularity originates in type at this location."),
      The_first_export_default_is_here: diag(2752, ts2.DiagnosticCategory.Error, "The_first_export_default_is_here_2752", "The first export default is here."),
      Another_export_default_is_here: diag(2753, ts2.DiagnosticCategory.Error, "Another_export_default_is_here_2753", "Another export default is here."),
      super_may_not_use_type_arguments: diag(2754, ts2.DiagnosticCategory.Error, "super_may_not_use_type_arguments_2754", "'super' may not use type arguments."),
      No_constituent_of_type_0_is_callable: diag(2755, ts2.DiagnosticCategory.Error, "No_constituent_of_type_0_is_callable_2755", "No constituent of type '{0}' is callable."),
      Not_all_constituents_of_type_0_are_callable: diag(2756, ts2.DiagnosticCategory.Error, "Not_all_constituents_of_type_0_are_callable_2756", "Not all constituents of type '{0}' are callable."),
      Type_0_has_no_call_signatures: diag(2757, ts2.DiagnosticCategory.Error, "Type_0_has_no_call_signatures_2757", "Type '{0}' has no call signatures."),
      Each_member_of_the_union_type_0_has_signatures_but_none_of_those_signatures_are_compatible_with_each_other: diag(2758, ts2.DiagnosticCategory.Error, "Each_member_of_the_union_type_0_has_signatures_but_none_of_those_signatures_are_compatible_with_each_2758", "Each member of the union type '{0}' has signatures, but none of those signatures are compatible with each other."),
      No_constituent_of_type_0_is_constructable: diag(2759, ts2.DiagnosticCategory.Error, "No_constituent_of_type_0_is_constructable_2759", "No constituent of type '{0}' is constructable."),
      Not_all_constituents_of_type_0_are_constructable: diag(2760, ts2.DiagnosticCategory.Error, "Not_all_constituents_of_type_0_are_constructable_2760", "Not all constituents of type '{0}' are constructable."),
      Type_0_has_no_construct_signatures: diag(2761, ts2.DiagnosticCategory.Error, "Type_0_has_no_construct_signatures_2761", "Type '{0}' has no construct signatures."),
      Each_member_of_the_union_type_0_has_construct_signatures_but_none_of_those_signatures_are_compatible_with_each_other: diag(2762, ts2.DiagnosticCategory.Error, "Each_member_of_the_union_type_0_has_construct_signatures_but_none_of_those_signatures_are_compatible_2762", "Each member of the union type '{0}' has construct signatures, but none of those signatures are compatible with each other."),
      Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_for_of_will_always_send_0: diag(2763, ts2.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_for_of_will_always_s_2763", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but for-of will always send '{0}'."),
      Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_spread_will_always_send_0: diag(2764, ts2.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_spread_will_al_2764", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but array spread will always send '{0}'."),
      Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_destructuring_will_always_send_0: diag(2765, ts2.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_destructuring__2765", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but array destructuring will always send '{0}'."),
      Cannot_delegate_iteration_to_value_because_the_next_method_of_its_iterator_expects_type_1_but_the_containing_generator_will_always_send_0: diag(2766, ts2.DiagnosticCategory.Error, "Cannot_delegate_iteration_to_value_because_the_next_method_of_its_iterator_expects_type_1_but_the_co_2766", "Cannot delegate iteration to value because the 'next' method of its iterator expects type '{1}', but the containing generator will always send '{0}'."),
      The_0_property_of_an_iterator_must_be_a_method: diag(2767, ts2.DiagnosticCategory.Error, "The_0_property_of_an_iterator_must_be_a_method_2767", "The '{0}' property of an iterator must be a method."),
      The_0_property_of_an_async_iterator_must_be_a_method: diag(2768, ts2.DiagnosticCategory.Error, "The_0_property_of_an_async_iterator_must_be_a_method_2768", "The '{0}' property of an async iterator must be a method."),
      No_overload_matches_this_call: diag(2769, ts2.DiagnosticCategory.Error, "No_overload_matches_this_call_2769", "No overload matches this call."),
      The_last_overload_gave_the_following_error: diag(2770, ts2.DiagnosticCategory.Error, "The_last_overload_gave_the_following_error_2770", "The last overload gave the following error."),
      The_last_overload_is_declared_here: diag(2771, ts2.DiagnosticCategory.Error, "The_last_overload_is_declared_here_2771", "The last overload is declared here."),
      Overload_0_of_1_2_gave_the_following_error: diag(2772, ts2.DiagnosticCategory.Error, "Overload_0_of_1_2_gave_the_following_error_2772", "Overload {0} of {1}, '{2}', gave the following error."),
      Did_you_forget_to_use_await: diag(2773, ts2.DiagnosticCategory.Error, "Did_you_forget_to_use_await_2773", "Did you forget to use 'await'?"),
      This_condition_will_always_return_true_since_this_function_is_always_defined_Did_you_mean_to_call_it_instead: diag(2774, ts2.DiagnosticCategory.Error, "This_condition_will_always_return_true_since_this_function_is_always_defined_Did_you_mean_to_call_it_2774", "This condition will always return true since this function is always defined. Did you mean to call it instead?"),
      Assertions_require_every_name_in_the_call_target_to_be_declared_with_an_explicit_type_annotation: diag(2775, ts2.DiagnosticCategory.Error, "Assertions_require_every_name_in_the_call_target_to_be_declared_with_an_explicit_type_annotation_2775", "Assertions require every name in the call target to be declared with an explicit type annotation."),
      Assertions_require_the_call_target_to_be_an_identifier_or_qualified_name: diag(2776, ts2.DiagnosticCategory.Error, "Assertions_require_the_call_target_to_be_an_identifier_or_qualified_name_2776", "Assertions require the call target to be an identifier or qualified name."),
      The_operand_of_an_increment_or_decrement_operator_may_not_be_an_optional_property_access: diag(2777, ts2.DiagnosticCategory.Error, "The_operand_of_an_increment_or_decrement_operator_may_not_be_an_optional_property_access_2777", "The operand of an increment or decrement operator may not be an optional property access."),
      The_target_of_an_object_rest_assignment_may_not_be_an_optional_property_access: diag(2778, ts2.DiagnosticCategory.Error, "The_target_of_an_object_rest_assignment_may_not_be_an_optional_property_access_2778", "The target of an object rest assignment may not be an optional property access."),
      The_left_hand_side_of_an_assignment_expression_may_not_be_an_optional_property_access: diag(2779, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_assignment_expression_may_not_be_an_optional_property_access_2779", "The left-hand side of an assignment expression may not be an optional property access."),
      The_left_hand_side_of_a_for_in_statement_may_not_be_an_optional_property_access: diag(2780, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_may_not_be_an_optional_property_access_2780", "The left-hand side of a 'for...in' statement may not be an optional property access."),
      The_left_hand_side_of_a_for_of_statement_may_not_be_an_optional_property_access: diag(2781, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_may_not_be_an_optional_property_access_2781", "The left-hand side of a 'for...of' statement may not be an optional property access."),
      _0_needs_an_explicit_type_annotation: diag(2782, ts2.DiagnosticCategory.Message, "_0_needs_an_explicit_type_annotation_2782", "'{0}' needs an explicit type annotation."),
      _0_is_specified_more_than_once_so_this_usage_will_be_overwritten: diag(2783, ts2.DiagnosticCategory.Error, "_0_is_specified_more_than_once_so_this_usage_will_be_overwritten_2783", "'{0}' is specified more than once, so this usage will be overwritten."),
      get_and_set_accessors_cannot_declare_this_parameters: diag(2784, ts2.DiagnosticCategory.Error, "get_and_set_accessors_cannot_declare_this_parameters_2784", "'get' and 'set' accessors cannot declare 'this' parameters."),
      This_spread_always_overwrites_this_property: diag(2785, ts2.DiagnosticCategory.Error, "This_spread_always_overwrites_this_property_2785", "This spread always overwrites this property."),
      _0_cannot_be_used_as_a_JSX_component: diag(2786, ts2.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_JSX_component_2786", "'{0}' cannot be used as a JSX component."),
      Its_return_type_0_is_not_a_valid_JSX_element: diag(2787, ts2.DiagnosticCategory.Error, "Its_return_type_0_is_not_a_valid_JSX_element_2787", "Its return type '{0}' is not a valid JSX element."),
      Its_instance_type_0_is_not_a_valid_JSX_element: diag(2788, ts2.DiagnosticCategory.Error, "Its_instance_type_0_is_not_a_valid_JSX_element_2788", "Its instance type '{0}' is not a valid JSX element."),
      Its_element_type_0_is_not_a_valid_JSX_element: diag(2789, ts2.DiagnosticCategory.Error, "Its_element_type_0_is_not_a_valid_JSX_element_2789", "Its element type '{0}' is not a valid JSX element."),
      The_operand_of_a_delete_operator_must_be_optional: diag(2790, ts2.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_must_be_optional_2790", "The operand of a 'delete' operator must be optional."),
      Exponentiation_cannot_be_performed_on_bigint_values_unless_the_target_option_is_set_to_es2016_or_later: diag(2791, ts2.DiagnosticCategory.Error, "Exponentiation_cannot_be_performed_on_bigint_values_unless_the_target_option_is_set_to_es2016_or_lat_2791", "Exponentiation cannot be performed on 'bigint' values unless the 'target' option is set to 'es2016' or later."),
      Cannot_find_module_0_Did_you_mean_to_set_the_moduleResolution_option_to_node_or_to_add_aliases_to_the_paths_option: diag(2792, ts2.DiagnosticCategory.Error, "Cannot_find_module_0_Did_you_mean_to_set_the_moduleResolution_option_to_node_or_to_add_aliases_to_th_2792", "Cannot find module '{0}'. Did you mean to set the 'moduleResolution' option to 'node', or to add aliases to the 'paths' option?"),
      The_call_would_have_succeeded_against_this_implementation_but_implementation_signatures_of_overloads_are_not_externally_visible: diag(2793, ts2.DiagnosticCategory.Error, "The_call_would_have_succeeded_against_this_implementation_but_implementation_signatures_of_overloads_2793", "The call would have succeeded against this implementation, but implementation signatures of overloads are not externally visible."),
      Expected_0_arguments_but_got_1_Did_you_forget_to_include_void_in_your_type_argument_to_Promise: diag(2794, ts2.DiagnosticCategory.Error, "Expected_0_arguments_but_got_1_Did_you_forget_to_include_void_in_your_type_argument_to_Promise_2794", "Expected {0} arguments, but got {1}. Did you forget to include 'void' in your type argument to 'Promise'?"),
      The_intrinsic_keyword_can_only_be_used_to_declare_compiler_provided_intrinsic_types: diag(2795, ts2.DiagnosticCategory.Error, "The_intrinsic_keyword_can_only_be_used_to_declare_compiler_provided_intrinsic_types_2795", "The 'intrinsic' keyword can only be used to declare compiler provided intrinsic types."),
      It_is_likely_that_you_are_missing_a_comma_to_separate_these_two_template_expressions_They_form_a_tagged_template_expression_which_cannot_be_invoked: diag(2796, ts2.DiagnosticCategory.Error, "It_is_likely_that_you_are_missing_a_comma_to_separate_these_two_template_expressions_They_form_a_tag_2796", "It is likely that you are missing a comma to separate these two template expressions. They form a tagged template expression which cannot be invoked."),
      A_mixin_class_that_extends_from_a_type_variable_containing_an_abstract_construct_signature_must_also_be_declared_abstract: diag(2797, ts2.DiagnosticCategory.Error, "A_mixin_class_that_extends_from_a_type_variable_containing_an_abstract_construct_signature_must_also_2797", "A mixin class that extends from a type variable containing an abstract construct signature must also be declared 'abstract'."),
      The_declaration_was_marked_as_deprecated_here: diag(2798, ts2.DiagnosticCategory.Error, "The_declaration_was_marked_as_deprecated_here_2798", "The declaration was marked as deprecated here."),
      Type_produces_a_tuple_type_that_is_too_large_to_represent: diag(2799, ts2.DiagnosticCategory.Error, "Type_produces_a_tuple_type_that_is_too_large_to_represent_2799", "Type produces a tuple type that is too large to represent."),
      Expression_produces_a_tuple_type_that_is_too_large_to_represent: diag(2800, ts2.DiagnosticCategory.Error, "Expression_produces_a_tuple_type_that_is_too_large_to_represent_2800", "Expression produces a tuple type that is too large to represent."),
      This_condition_will_always_return_true_since_this_0_is_always_defined: diag(2801, ts2.DiagnosticCategory.Error, "This_condition_will_always_return_true_since_this_0_is_always_defined_2801", "This condition will always return true since this '{0}' is always defined."),
      Type_0_can_only_be_iterated_through_when_using_the_downlevelIteration_flag_or_with_a_target_of_es2015_or_higher: diag(2802, ts2.DiagnosticCategory.Error, "Type_0_can_only_be_iterated_through_when_using_the_downlevelIteration_flag_or_with_a_target_of_es201_2802", "Type '{0}' can only be iterated through when using the '--downlevelIteration' flag or with a '--target' of 'es2015' or higher."),
      Cannot_assign_to_private_method_0_Private_methods_are_not_writable: diag(2803, ts2.DiagnosticCategory.Error, "Cannot_assign_to_private_method_0_Private_methods_are_not_writable_2803", "Cannot assign to private method '{0}'. Private methods are not writable."),
      Duplicate_identifier_0_Static_and_instance_elements_cannot_share_the_same_private_name: diag(2804, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Static_and_instance_elements_cannot_share_the_same_private_name_2804", "Duplicate identifier '{0}'. Static and instance elements cannot share the same private name."),
      Static_fields_with_private_names_can_t_have_initializers_when_the_useDefineForClassFields_flag_is_not_specified_with_a_target_of_esnext_Consider_adding_the_useDefineForClassFields_flag: diag(2805, ts2.DiagnosticCategory.Error, "Static_fields_with_private_names_can_t_have_initializers_when_the_useDefineForClassFields_flag_is_no_2805", "Static fields with private names can't have initializers when the '--useDefineForClassFields' flag is not specified with a '--target' of 'esnext'. Consider adding the '--useDefineForClassFields' flag."),
      Private_accessor_was_defined_without_a_getter: diag(2806, ts2.DiagnosticCategory.Error, "Private_accessor_was_defined_without_a_getter_2806", "Private accessor was defined without a getter."),
      This_syntax_requires_an_imported_helper_named_1_with_2_parameters_which_is_not_compatible_with_the_one_in_0_Consider_upgrading_your_version_of_0: diag(2807, ts2.DiagnosticCategory.Error, "This_syntax_requires_an_imported_helper_named_1_with_2_parameters_which_is_not_compatible_with_the_o_2807", "This syntax requires an imported helper named '{1}' with {2} parameters, which is not compatible with the one in '{0}'. Consider upgrading your version of '{0}'."),
      A_get_accessor_must_be_at_least_as_accessible_as_the_setter: diag(2808, ts2.DiagnosticCategory.Error, "A_get_accessor_must_be_at_least_as_accessible_as_the_setter_2808", "A get accessor must be at least as accessible as the setter"),
      Declaration_or_statement_expected_This_follows_a_block_of_statements_so_if_you_intended_to_write_a_destructuring_assignment_you_might_need_to_wrap_the_the_whole_assignment_in_parentheses: diag(2809, ts2.DiagnosticCategory.Error, "Declaration_or_statement_expected_This_follows_a_block_of_statements_so_if_you_intended_to_write_a_d_2809", "Declaration or statement expected. This '=' follows a block of statements, so if you intended to write a destructuring assignment, you might need to wrap the the whole assignment in parentheses."),
      Property_0_may_not_be_used_in_a_static_property_s_initializer_in_the_same_class_when_target_is_esnext_and_useDefineForClassFields_is_false: diag(2810, ts2.DiagnosticCategory.Error, "Property_0_may_not_be_used_in_a_static_property_s_initializer_in_the_same_class_when_target_is_esnex_2810", "Property '{0}' may not be used in a static property's initializer in the same class when 'target' is 'esnext' and 'useDefineForClassFields' is 'false'."),
      Initializer_for_property_0: diag(2811, ts2.DiagnosticCategory.Error, "Initializer_for_property_0_2811", "Initializer for property '{0}'"),
      Property_0_does_not_exist_on_type_1_Try_changing_the_lib_compiler_option_to_include_dom: diag(2812, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Try_changing_the_lib_compiler_option_to_include_dom_2812", "Property '{0}' does not exist on type '{1}'. Try changing the 'lib' compiler option to include 'dom'."),
      Class_declaration_cannot_implement_overload_list_for_0: diag(2813, ts2.DiagnosticCategory.Error, "Class_declaration_cannot_implement_overload_list_for_0_2813", "Class declaration cannot implement overload list for '{0}'."),
      Function_with_bodies_can_only_merge_with_classes_that_are_ambient: diag(2814, ts2.DiagnosticCategory.Error, "Function_with_bodies_can_only_merge_with_classes_that_are_ambient_2814", "Function with bodies can only merge with classes that are ambient."),
      arguments_cannot_be_referenced_in_property_initializers: diag(2815, ts2.DiagnosticCategory.Error, "arguments_cannot_be_referenced_in_property_initializers_2815", "'arguments' cannot be referenced in property initializers."),
      Cannot_use_this_in_a_static_property_initializer_of_a_decorated_class: diag(2816, ts2.DiagnosticCategory.Error, "Cannot_use_this_in_a_static_property_initializer_of_a_decorated_class_2816", "Cannot use 'this' in a static property initializer of a decorated class."),
      Property_0_has_no_initializer_and_is_not_definitely_assigned_in_a_class_static_block: diag(2817, ts2.DiagnosticCategory.Error, "Property_0_has_no_initializer_and_is_not_definitely_assigned_in_a_class_static_block_2817", "Property '{0}' has no initializer and is not definitely assigned in a class static block."),
      Duplicate_identifier_0_Compiler_reserves_name_1_when_emitting_super_references_in_static_initializers: diag(2818, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_reserves_name_1_when_emitting_super_references_in_static_initializer_2818", "Duplicate identifier '{0}'. Compiler reserves name '{1}' when emitting 'super' references in static initializers."),
      Namespace_name_cannot_be_0: diag(2819, ts2.DiagnosticCategory.Error, "Namespace_name_cannot_be_0_2819", "Namespace name cannot be '{0}'."),
      Type_0_is_not_assignable_to_type_1_Did_you_mean_2: diag(2820, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_Did_you_mean_2_2820", "Type '{0}' is not assignable to type '{1}'. Did you mean '{2}'?"),
      Import_assertions_are_only_supported_when_the_module_option_is_set_to_esnext: diag(2821, ts2.DiagnosticCategory.Error, "Import_assertions_are_only_supported_when_the_module_option_is_set_to_esnext_2821", "Import assertions are only supported when the '--module' option is set to 'esnext'."),
      Import_assertions_cannot_be_used_with_type_only_imports_or_exports: diag(2822, ts2.DiagnosticCategory.Error, "Import_assertions_cannot_be_used_with_type_only_imports_or_exports_2822", "Import assertions cannot be used with type-only imports or exports."),
      Cannot_find_namespace_0_Did_you_mean_1: diag(2833, ts2.DiagnosticCategory.Error, "Cannot_find_namespace_0_Did_you_mean_1_2833", "Cannot find namespace '{0}'. Did you mean '{1}'?"),
      Relative_import_paths_need_explicit_file_extensions_in_EcmaScript_imports_when_moduleResolution_is_node12_or_nodenext_Consider_adding_an_extension_to_the_import_path: diag(2834, ts2.DiagnosticCategory.Error, "Relative_import_paths_need_explicit_file_extensions_in_EcmaScript_imports_when_moduleResolution_is_n_2834", "Relative import paths need explicit file extensions in EcmaScript imports when '--moduleResolution' is 'node12' or 'nodenext'. Consider adding an extension to the import path."),
      Relative_import_paths_need_explicit_file_extensions_in_EcmaScript_imports_when_moduleResolution_is_node12_or_nodenext_Did_you_mean_0: diag(2835, ts2.DiagnosticCategory.Error, "Relative_import_paths_need_explicit_file_extensions_in_EcmaScript_imports_when_moduleResolution_is_n_2835", "Relative import paths need explicit file extensions in EcmaScript imports when '--moduleResolution' is 'node12' or 'nodenext'. Did you mean '{0}'?"),
      Import_declaration_0_is_using_private_name_1: diag(4e3, ts2.DiagnosticCategory.Error, "Import_declaration_0_is_using_private_name_1_4000", "Import declaration '{0}' is using private name '{1}'."),
      Type_parameter_0_of_exported_class_has_or_is_using_private_name_1: diag(4002, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_class_has_or_is_using_private_name_1_4002", "Type parameter '{0}' of exported class has or is using private name '{1}'."),
      Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1: diag(4004, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1_4004", "Type parameter '{0}' of exported interface has or is using private name '{1}'."),
      Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4006, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4006", "Type parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),
      Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4008, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4008", "Type parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),
      Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: diag(4010, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4010", "Type parameter '{0}' of public static method from exported class has or is using private name '{1}'."),
      Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: diag(4012, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4012", "Type parameter '{0}' of public method from exported class has or is using private name '{1}'."),
      Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: diag(4014, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4014", "Type parameter '{0}' of method from exported interface has or is using private name '{1}'."),
      Type_parameter_0_of_exported_function_has_or_is_using_private_name_1: diag(4016, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_function_has_or_is_using_private_name_1_4016", "Type parameter '{0}' of exported function has or is using private name '{1}'."),
      Implements_clause_of_exported_class_0_has_or_is_using_private_name_1: diag(4019, ts2.DiagnosticCategory.Error, "Implements_clause_of_exported_class_0_has_or_is_using_private_name_1_4019", "Implements clause of exported class '{0}' has or is using private name '{1}'."),
      extends_clause_of_exported_class_0_has_or_is_using_private_name_1: diag(4020, ts2.DiagnosticCategory.Error, "extends_clause_of_exported_class_0_has_or_is_using_private_name_1_4020", "'extends' clause of exported class '{0}' has or is using private name '{1}'."),
      extends_clause_of_exported_class_has_or_is_using_private_name_0: diag(4021, ts2.DiagnosticCategory.Error, "extends_clause_of_exported_class_has_or_is_using_private_name_0_4021", "'extends' clause of exported class has or is using private name '{0}'."),
      extends_clause_of_exported_interface_0_has_or_is_using_private_name_1: diag(4022, ts2.DiagnosticCategory.Error, "extends_clause_of_exported_interface_0_has_or_is_using_private_name_1_4022", "'extends' clause of exported interface '{0}' has or is using private name '{1}'."),
      Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4023, ts2.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4023", "Exported variable '{0}' has or is using name '{1}' from external module {2} but cannot be named."),
      Exported_variable_0_has_or_is_using_name_1_from_private_module_2: diag(4024, ts2.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_name_1_from_private_module_2_4024", "Exported variable '{0}' has or is using name '{1}' from private module '{2}'."),
      Exported_variable_0_has_or_is_using_private_name_1: diag(4025, ts2.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_private_name_1_4025", "Exported variable '{0}' has or is using private name '{1}'."),
      Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4026, ts2.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot__4026", "Public static property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4027, ts2.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4027", "Public static property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
      Public_static_property_0_of_exported_class_has_or_is_using_private_name_1: diag(4028, ts2.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_private_name_1_4028", "Public static property '{0}' of exported class has or is using private name '{1}'."),
      Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4029, ts2.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_name_4029", "Public property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4030, ts2.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4030", "Public property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
      Public_property_0_of_exported_class_has_or_is_using_private_name_1: diag(4031, ts2.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_private_name_1_4031", "Public property '{0}' of exported class has or is using private name '{1}'."),
      Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4032, ts2.DiagnosticCategory.Error, "Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4032", "Property '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),
      Property_0_of_exported_interface_has_or_is_using_private_name_1: diag(4033, ts2.DiagnosticCategory.Error, "Property_0_of_exported_interface_has_or_is_using_private_name_1_4033", "Property '{0}' of exported interface has or is using private name '{1}'."),
      Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4034, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_mod_4034", "Parameter type of public static setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
      Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1: diag(4035, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1_4035", "Parameter type of public static setter '{0}' from exported class has or is using private name '{1}'."),
      Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4036, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4036", "Parameter type of public setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
      Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1: diag(4037, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1_4037", "Parameter type of public setter '{0}' from exported class has or is using private name '{1}'."),
      Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4038, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_modul_4038", "Return type of public static getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4039, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_4039", "Return type of public static getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
      Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1: diag(4040, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1_4040", "Return type of public static getter '{0}' from exported class has or is using private name '{1}'."),
      Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4041, ts2.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_4041", "Return type of public getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4042, ts2.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4042", "Return type of public getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
      Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1: diag(4043, ts2.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1_4043", "Return type of public getter '{0}' from exported class has or is using private name '{1}'."),
      Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4044, ts2.DiagnosticCategory.Error, "Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_mod_4044", "Return type of constructor signature from exported interface has or is using name '{0}' from private module '{1}'."),
      Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4045, ts2.DiagnosticCategory.Error, "Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0_4045", "Return type of constructor signature from exported interface has or is using private name '{0}'."),
      Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4046, ts2.DiagnosticCategory.Error, "Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4046", "Return type of call signature from exported interface has or is using name '{0}' from private module '{1}'."),
      Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4047, ts2.DiagnosticCategory.Error, "Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0_4047", "Return type of call signature from exported interface has or is using private name '{0}'."),
      Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4048, ts2.DiagnosticCategory.Error, "Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4048", "Return type of index signature from exported interface has or is using name '{0}' from private module '{1}'."),
      Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4049, ts2.DiagnosticCategory.Error, "Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0_4049", "Return type of index signature from exported interface has or is using private name '{0}'."),
      Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4050, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module__4050", "Return type of public static method from exported class has or is using name '{0}' from external module {1} but cannot be named."),
      Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: diag(4051, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4051", "Return type of public static method from exported class has or is using name '{0}' from private module '{1}'."),
      Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0: diag(4052, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0_4052", "Return type of public static method from exported class has or is using private name '{0}'."),
      Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4053, ts2.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_c_4053", "Return type of public method from exported class has or is using name '{0}' from external module {1} but cannot be named."),
      Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: diag(4054, ts2.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4054", "Return type of public method from exported class has or is using name '{0}' from private module '{1}'."),
      Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0: diag(4055, ts2.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0_4055", "Return type of public method from exported class has or is using private name '{0}'."),
      Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4056, ts2.DiagnosticCategory.Error, "Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4056", "Return type of method from exported interface has or is using name '{0}' from private module '{1}'."),
      Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0: diag(4057, ts2.DiagnosticCategory.Error, "Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0_4057", "Return type of method from exported interface has or is using private name '{0}'."),
      Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4058, ts2.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named_4058", "Return type of exported function has or is using name '{0}' from external module {1} but cannot be named."),
      Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1: diag(4059, ts2.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1_4059", "Return type of exported function has or is using name '{0}' from private module '{1}'."),
      Return_type_of_exported_function_has_or_is_using_private_name_0: diag(4060, ts2.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_private_name_0_4060", "Return type of exported function has or is using private name '{0}'."),
      Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4061, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_can_4061", "Parameter '{0}' of constructor from exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4062, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2_4062", "Parameter '{0}' of constructor from exported class has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1: diag(4063, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1_4063", "Parameter '{0}' of constructor from exported class has or is using private name '{1}'."),
      Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4064, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_mod_4064", "Parameter '{0}' of constructor signature from exported interface has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4065, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4065", "Parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),
      Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4066, ts2.DiagnosticCategory.Error, "Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4066", "Parameter '{0}' of call signature from exported interface has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4067, ts2.DiagnosticCategory.Error, "Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4067", "Parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),
      Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4068, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module__4068", "Parameter '{0}' of public static method from exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4069, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4069", "Parameter '{0}' of public static method from exported class has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: diag(4070, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4070", "Parameter '{0}' of public static method from exported class has or is using private name '{1}'."),
      Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4071, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_c_4071", "Parameter '{0}' of public method from exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4072, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4072", "Parameter '{0}' of public method from exported class has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: diag(4073, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4073", "Parameter '{0}' of public method from exported class has or is using private name '{1}'."),
      Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4074, ts2.DiagnosticCategory.Error, "Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4074", "Parameter '{0}' of method from exported interface has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: diag(4075, ts2.DiagnosticCategory.Error, "Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4075", "Parameter '{0}' of method from exported interface has or is using private name '{1}'."),
      Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4076, ts2.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4076", "Parameter '{0}' of exported function has or is using name '{1}' from external module {2} but cannot be named."),
      Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2: diag(4077, ts2.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2_4077", "Parameter '{0}' of exported function has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_exported_function_has_or_is_using_private_name_1: diag(4078, ts2.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_private_name_1_4078", "Parameter '{0}' of exported function has or is using private name '{1}'."),
      Exported_type_alias_0_has_or_is_using_private_name_1: diag(4081, ts2.DiagnosticCategory.Error, "Exported_type_alias_0_has_or_is_using_private_name_1_4081", "Exported type alias '{0}' has or is using private name '{1}'."),
      Default_export_of_the_module_has_or_is_using_private_name_0: diag(4082, ts2.DiagnosticCategory.Error, "Default_export_of_the_module_has_or_is_using_private_name_0_4082", "Default export of the module has or is using private name '{0}'."),
      Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1: diag(4083, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1_4083", "Type parameter '{0}' of exported type alias has or is using private name '{1}'."),
      Exported_type_alias_0_has_or_is_using_private_name_1_from_module_2: diag(4084, ts2.DiagnosticCategory.Error, "Exported_type_alias_0_has_or_is_using_private_name_1_from_module_2_4084", "Exported type alias '{0}' has or is using private name '{1}' from module {2}."),
      Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_library_to_resolve_the_conflict: diag(4090, ts2.DiagnosticCategory.Error, "Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_librar_4090", "Conflicting definitions for '{0}' found at '{1}' and '{2}'. Consider installing a specific version of this library to resolve the conflict."),
      Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4091, ts2.DiagnosticCategory.Error, "Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4091", "Parameter '{0}' of index signature from exported interface has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4092, ts2.DiagnosticCategory.Error, "Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1_4092", "Parameter '{0}' of index signature from exported interface has or is using private name '{1}'."),
      Property_0_of_exported_class_expression_may_not_be_private_or_protected: diag(4094, ts2.DiagnosticCategory.Error, "Property_0_of_exported_class_expression_may_not_be_private_or_protected_4094", "Property '{0}' of exported class expression may not be private or protected."),
      Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4095, ts2.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_4095", "Public static method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4096, ts2.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4096", "Public static method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
      Public_static_method_0_of_exported_class_has_or_is_using_private_name_1: diag(4097, ts2.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_private_name_1_4097", "Public static method '{0}' of exported class has or is using private name '{1}'."),
      Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4098, ts2.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4098", "Public method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4099, ts2.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4099", "Public method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
      Public_method_0_of_exported_class_has_or_is_using_private_name_1: diag(4100, ts2.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_private_name_1_4100", "Public method '{0}' of exported class has or is using private name '{1}'."),
      Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4101, ts2.DiagnosticCategory.Error, "Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4101", "Method '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),
      Method_0_of_exported_interface_has_or_is_using_private_name_1: diag(4102, ts2.DiagnosticCategory.Error, "Method_0_of_exported_interface_has_or_is_using_private_name_1_4102", "Method '{0}' of exported interface has or is using private name '{1}'."),
      Type_parameter_0_of_exported_mapped_object_type_is_using_private_name_1: diag(4103, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_mapped_object_type_is_using_private_name_1_4103", "Type parameter '{0}' of exported mapped object type is using private name '{1}'."),
      The_type_0_is_readonly_and_cannot_be_assigned_to_the_mutable_type_1: diag(4104, ts2.DiagnosticCategory.Error, "The_type_0_is_readonly_and_cannot_be_assigned_to_the_mutable_type_1_4104", "The type '{0}' is 'readonly' and cannot be assigned to the mutable type '{1}'."),
      Private_or_protected_member_0_cannot_be_accessed_on_a_type_parameter: diag(4105, ts2.DiagnosticCategory.Error, "Private_or_protected_member_0_cannot_be_accessed_on_a_type_parameter_4105", "Private or protected member '{0}' cannot be accessed on a type parameter."),
      Parameter_0_of_accessor_has_or_is_using_private_name_1: diag(4106, ts2.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_private_name_1_4106", "Parameter '{0}' of accessor has or is using private name '{1}'."),
      Parameter_0_of_accessor_has_or_is_using_name_1_from_private_module_2: diag(4107, ts2.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_name_1_from_private_module_2_4107", "Parameter '{0}' of accessor has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_accessor_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4108, ts2.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4108", "Parameter '{0}' of accessor has or is using name '{1}' from external module '{2}' but cannot be named."),
      Type_arguments_for_0_circularly_reference_themselves: diag(4109, ts2.DiagnosticCategory.Error, "Type_arguments_for_0_circularly_reference_themselves_4109", "Type arguments for '{0}' circularly reference themselves."),
      Tuple_type_arguments_circularly_reference_themselves: diag(4110, ts2.DiagnosticCategory.Error, "Tuple_type_arguments_circularly_reference_themselves_4110", "Tuple type arguments circularly reference themselves."),
      Property_0_comes_from_an_index_signature_so_it_must_be_accessed_with_0: diag(4111, ts2.DiagnosticCategory.Error, "Property_0_comes_from_an_index_signature_so_it_must_be_accessed_with_0_4111", "Property '{0}' comes from an index signature, so it must be accessed with ['{0}']."),
      This_member_cannot_have_an_override_modifier_because_its_containing_class_0_does_not_extend_another_class: diag(4112, ts2.DiagnosticCategory.Error, "This_member_cannot_have_an_override_modifier_because_its_containing_class_0_does_not_extend_another__4112", "This member cannot have an 'override' modifier because its containing class '{0}' does not extend another class."),
      This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0: diag(4113, ts2.DiagnosticCategory.Error, "This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0_4113", "This member cannot have an 'override' modifier because it is not declared in the base class '{0}'."),
      This_member_must_have_an_override_modifier_because_it_overrides_a_member_in_the_base_class_0: diag(4114, ts2.DiagnosticCategory.Error, "This_member_must_have_an_override_modifier_because_it_overrides_a_member_in_the_base_class_0_4114", "This member must have an 'override' modifier because it overrides a member in the base class '{0}'."),
      This_parameter_property_must_have_an_override_modifier_because_it_overrides_a_member_in_base_class_0: diag(4115, ts2.DiagnosticCategory.Error, "This_parameter_property_must_have_an_override_modifier_because_it_overrides_a_member_in_base_class_0_4115", "This parameter property must have an 'override' modifier because it overrides a member in base class '{0}'."),
      This_member_must_have_an_override_modifier_because_it_overrides_an_abstract_method_that_is_declared_in_the_base_class_0: diag(4116, ts2.DiagnosticCategory.Error, "This_member_must_have_an_override_modifier_because_it_overrides_an_abstract_method_that_is_declared__4116", "This member must have an 'override' modifier because it overrides an abstract method that is declared in the base class '{0}'."),
      This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0_Did_you_mean_1: diag(4117, ts2.DiagnosticCategory.Error, "This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0_Did_you__4117", "This member cannot have an 'override' modifier because it is not declared in the base class '{0}'. Did you mean '{1}'?"),
      The_type_of_this_node_cannot_be_serialized_because_its_property_0_cannot_be_serialized: diag(4118, ts2.DiagnosticCategory.Error, "The_type_of_this_node_cannot_be_serialized_because_its_property_0_cannot_be_serialized_4118", "The type of this node cannot be serialized because its property '{0}' cannot be serialized."),
      This_member_must_have_a_JSDoc_comment_with_an_override_tag_because_it_overrides_a_member_in_the_base_class_0: diag(4119, ts2.DiagnosticCategory.Error, "This_member_must_have_a_JSDoc_comment_with_an_override_tag_because_it_overrides_a_member_in_the_base_4119", "This member must have a JSDoc comment with an '@override' tag because it overrides a member in the base class '{0}'."),
      This_parameter_property_must_have_a_JSDoc_comment_with_an_override_tag_because_it_overrides_a_member_in_the_base_class_0: diag(4120, ts2.DiagnosticCategory.Error, "This_parameter_property_must_have_a_JSDoc_comment_with_an_override_tag_because_it_overrides_a_member_4120", "This parameter property must have a JSDoc comment with an '@override' tag because it overrides a member in the base class '{0}'."),
      This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_its_containing_class_0_does_not_extend_another_class: diag(4121, ts2.DiagnosticCategory.Error, "This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_its_containing_class_0_does_not_4121", "This member cannot have a JSDoc comment with an '@override' tag because its containing class '{0}' does not extend another class."),
      This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_it_is_not_declared_in_the_base_class_0: diag(4122, ts2.DiagnosticCategory.Error, "This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_it_is_not_declared_in_the_base__4122", "This member cannot have a JSDoc comment with an '@override' tag because it is not declared in the base class '{0}'."),
      This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_it_is_not_declared_in_the_base_class_0_Did_you_mean_1: diag(4123, ts2.DiagnosticCategory.Error, "This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_it_is_not_declared_in_the_base__4123", "This member cannot have a JSDoc comment with an 'override' tag because it is not declared in the base class '{0}'. Did you mean '{1}'?"),
      Compiler_option_0_of_value_1_is_unstable_Use_nightly_TypeScript_to_silence_this_error_Try_updating_with_npm_install_D_typescript_next: diag(4124, ts2.DiagnosticCategory.Error, "Compiler_option_0_of_value_1_is_unstable_Use_nightly_TypeScript_to_silence_this_error_Try_updating_w_4124", "Compiler option '{0}' of value '{1}' is unstable. Use nightly TypeScript to silence this error. Try updating with 'npm install -D typescript@next'."),
      The_current_host_does_not_support_the_0_option: diag(5001, ts2.DiagnosticCategory.Error, "The_current_host_does_not_support_the_0_option_5001", "The current host does not support the '{0}' option."),
      Cannot_find_the_common_subdirectory_path_for_the_input_files: diag(5009, ts2.DiagnosticCategory.Error, "Cannot_find_the_common_subdirectory_path_for_the_input_files_5009", "Cannot find the common subdirectory path for the input files."),
      File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0: diag(5010, ts2.DiagnosticCategory.Error, "File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0_5010", "File specification cannot end in a recursive directory wildcard ('**'): '{0}'."),
      Cannot_read_file_0_Colon_1: diag(5012, ts2.DiagnosticCategory.Error, "Cannot_read_file_0_Colon_1_5012", "Cannot read file '{0}': {1}."),
      Failed_to_parse_file_0_Colon_1: diag(5014, ts2.DiagnosticCategory.Error, "Failed_to_parse_file_0_Colon_1_5014", "Failed to parse file '{0}': {1}."),
      Unknown_compiler_option_0: diag(5023, ts2.DiagnosticCategory.Error, "Unknown_compiler_option_0_5023", "Unknown compiler option '{0}'."),
      Compiler_option_0_requires_a_value_of_type_1: diag(5024, ts2.DiagnosticCategory.Error, "Compiler_option_0_requires_a_value_of_type_1_5024", "Compiler option '{0}' requires a value of type {1}."),
      Unknown_compiler_option_0_Did_you_mean_1: diag(5025, ts2.DiagnosticCategory.Error, "Unknown_compiler_option_0_Did_you_mean_1_5025", "Unknown compiler option '{0}'. Did you mean '{1}'?"),
      Could_not_write_file_0_Colon_1: diag(5033, ts2.DiagnosticCategory.Error, "Could_not_write_file_0_Colon_1_5033", "Could not write file '{0}': {1}."),
      Option_project_cannot_be_mixed_with_source_files_on_a_command_line: diag(5042, ts2.DiagnosticCategory.Error, "Option_project_cannot_be_mixed_with_source_files_on_a_command_line_5042", "Option 'project' cannot be mixed with source files on a command line."),
      Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES2015_or_higher: diag(5047, ts2.DiagnosticCategory.Error, "Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES_5047", "Option 'isolatedModules' can only be used when either option '--module' is provided or option 'target' is 'ES2015' or higher."),
      Option_0_cannot_be_specified_when_option_target_is_ES3: diag(5048, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_when_option_target_is_ES3_5048", "Option '{0}' cannot be specified when option 'target' is 'ES3'."),
      Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided: diag(5051, ts2.DiagnosticCategory.Error, "Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided_5051", "Option '{0} can only be used when either option '--inlineSourceMap' or option '--sourceMap' is provided."),
      Option_0_cannot_be_specified_without_specifying_option_1: diag(5052, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_without_specifying_option_1_5052", "Option '{0}' cannot be specified without specifying option '{1}'."),
      Option_0_cannot_be_specified_with_option_1: diag(5053, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_with_option_1_5053", "Option '{0}' cannot be specified with option '{1}'."),
      A_tsconfig_json_file_is_already_defined_at_Colon_0: diag(5054, ts2.DiagnosticCategory.Error, "A_tsconfig_json_file_is_already_defined_at_Colon_0_5054", "A 'tsconfig.json' file is already defined at: '{0}'."),
      Cannot_write_file_0_because_it_would_overwrite_input_file: diag(5055, ts2.DiagnosticCategory.Error, "Cannot_write_file_0_because_it_would_overwrite_input_file_5055", "Cannot write file '{0}' because it would overwrite input file."),
      Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files: diag(5056, ts2.DiagnosticCategory.Error, "Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files_5056", "Cannot write file '{0}' because it would be overwritten by multiple input files."),
      Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0: diag(5057, ts2.DiagnosticCategory.Error, "Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0_5057", "Cannot find a tsconfig.json file at the specified directory: '{0}'."),
      The_specified_path_does_not_exist_Colon_0: diag(5058, ts2.DiagnosticCategory.Error, "The_specified_path_does_not_exist_Colon_0_5058", "The specified path does not exist: '{0}'."),
      Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier: diag(5059, ts2.DiagnosticCategory.Error, "Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier_5059", "Invalid value for '--reactNamespace'. '{0}' is not a valid identifier."),
      Pattern_0_can_have_at_most_one_Asterisk_character: diag(5061, ts2.DiagnosticCategory.Error, "Pattern_0_can_have_at_most_one_Asterisk_character_5061", "Pattern '{0}' can have at most one '*' character."),
      Substitution_0_in_pattern_1_can_have_at_most_one_Asterisk_character: diag(5062, ts2.DiagnosticCategory.Error, "Substitution_0_in_pattern_1_can_have_at_most_one_Asterisk_character_5062", "Substitution '{0}' in pattern '{1}' can have at most one '*' character."),
      Substitutions_for_pattern_0_should_be_an_array: diag(5063, ts2.DiagnosticCategory.Error, "Substitutions_for_pattern_0_should_be_an_array_5063", "Substitutions for pattern '{0}' should be an array."),
      Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2: diag(5064, ts2.DiagnosticCategory.Error, "Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2_5064", "Substitution '{0}' for pattern '{1}' has incorrect type, expected 'string', got '{2}'."),
      File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0: diag(5065, ts2.DiagnosticCategory.Error, "File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildca_5065", "File specification cannot contain a parent directory ('..') that appears after a recursive directory wildcard ('**'): '{0}'."),
      Substitutions_for_pattern_0_shouldn_t_be_an_empty_array: diag(5066, ts2.DiagnosticCategory.Error, "Substitutions_for_pattern_0_shouldn_t_be_an_empty_array_5066", "Substitutions for pattern '{0}' shouldn't be an empty array."),
      Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name: diag(5067, ts2.DiagnosticCategory.Error, "Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name_5067", "Invalid value for 'jsxFactory'. '{0}' is not a valid identifier or qualified-name."),
      Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript_files_Learn_more_at_https_Colon_Slash_Slashaka_ms_Slashtsconfig: diag(5068, ts2.DiagnosticCategory.Error, "Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript__5068", "Adding a tsconfig.json file will help organize projects that contain both TypeScript and JavaScript files. Learn more at https://aka.ms/tsconfig."),
      Option_0_cannot_be_specified_without_specifying_option_1_or_option_2: diag(5069, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_without_specifying_option_1_or_option_2_5069", "Option '{0}' cannot be specified without specifying option '{1}' or option '{2}'."),
      Option_resolveJsonModule_cannot_be_specified_without_node_module_resolution_strategy: diag(5070, ts2.DiagnosticCategory.Error, "Option_resolveJsonModule_cannot_be_specified_without_node_module_resolution_strategy_5070", "Option '--resolveJsonModule' cannot be specified without 'node' module resolution strategy."),
      Option_resolveJsonModule_can_only_be_specified_when_module_code_generation_is_commonjs_amd_es2015_or_esNext: diag(5071, ts2.DiagnosticCategory.Error, "Option_resolveJsonModule_can_only_be_specified_when_module_code_generation_is_commonjs_amd_es2015_or_5071", "Option '--resolveJsonModule' can only be specified when module code generation is 'commonjs', 'amd', 'es2015' or 'esNext'."),
      Unknown_build_option_0: diag(5072, ts2.DiagnosticCategory.Error, "Unknown_build_option_0_5072", "Unknown build option '{0}'."),
      Build_option_0_requires_a_value_of_type_1: diag(5073, ts2.DiagnosticCategory.Error, "Build_option_0_requires_a_value_of_type_1_5073", "Build option '{0}' requires a value of type {1}."),
      Option_incremental_can_only_be_specified_using_tsconfig_emitting_to_single_file_or_when_option_tsBuildInfoFile_is_specified: diag(5074, ts2.DiagnosticCategory.Error, "Option_incremental_can_only_be_specified_using_tsconfig_emitting_to_single_file_or_when_option_tsBui_5074", "Option '--incremental' can only be specified using tsconfig, emitting to single file or when option '--tsBuildInfoFile' is specified."),
      _0_is_assignable_to_the_constraint_of_type_1_but_1_could_be_instantiated_with_a_different_subtype_of_constraint_2: diag(5075, ts2.DiagnosticCategory.Error, "_0_is_assignable_to_the_constraint_of_type_1_but_1_could_be_instantiated_with_a_different_subtype_of_5075", "'{0}' is assignable to the constraint of type '{1}', but '{1}' could be instantiated with a different subtype of constraint '{2}'."),
      _0_and_1_operations_cannot_be_mixed_without_parentheses: diag(5076, ts2.DiagnosticCategory.Error, "_0_and_1_operations_cannot_be_mixed_without_parentheses_5076", "'{0}' and '{1}' operations cannot be mixed without parentheses."),
      Unknown_build_option_0_Did_you_mean_1: diag(5077, ts2.DiagnosticCategory.Error, "Unknown_build_option_0_Did_you_mean_1_5077", "Unknown build option '{0}'. Did you mean '{1}'?"),
      Unknown_watch_option_0: diag(5078, ts2.DiagnosticCategory.Error, "Unknown_watch_option_0_5078", "Unknown watch option '{0}'."),
      Unknown_watch_option_0_Did_you_mean_1: diag(5079, ts2.DiagnosticCategory.Error, "Unknown_watch_option_0_Did_you_mean_1_5079", "Unknown watch option '{0}'. Did you mean '{1}'?"),
      Watch_option_0_requires_a_value_of_type_1: diag(5080, ts2.DiagnosticCategory.Error, "Watch_option_0_requires_a_value_of_type_1_5080", "Watch option '{0}' requires a value of type {1}."),
      Cannot_find_a_tsconfig_json_file_at_the_current_directory_Colon_0: diag(5081, ts2.DiagnosticCategory.Error, "Cannot_find_a_tsconfig_json_file_at_the_current_directory_Colon_0_5081", "Cannot find a tsconfig.json file at the current directory: {0}."),
      _0_could_be_instantiated_with_an_arbitrary_type_which_could_be_unrelated_to_1: diag(5082, ts2.DiagnosticCategory.Error, "_0_could_be_instantiated_with_an_arbitrary_type_which_could_be_unrelated_to_1_5082", "'{0}' could be instantiated with an arbitrary type which could be unrelated to '{1}'."),
      Cannot_read_file_0: diag(5083, ts2.DiagnosticCategory.Error, "Cannot_read_file_0_5083", "Cannot read file '{0}'."),
      Tuple_members_must_all_have_names_or_all_not_have_names: diag(5084, ts2.DiagnosticCategory.Error, "Tuple_members_must_all_have_names_or_all_not_have_names_5084", "Tuple members must all have names or all not have names."),
      A_tuple_member_cannot_be_both_optional_and_rest: diag(5085, ts2.DiagnosticCategory.Error, "A_tuple_member_cannot_be_both_optional_and_rest_5085", "A tuple member cannot be both optional and rest."),
      A_labeled_tuple_element_is_declared_as_optional_with_a_question_mark_after_the_name_and_before_the_colon_rather_than_after_the_type: diag(5086, ts2.DiagnosticCategory.Error, "A_labeled_tuple_element_is_declared_as_optional_with_a_question_mark_after_the_name_and_before_the_c_5086", "A labeled tuple element is declared as optional with a question mark after the name and before the colon, rather than after the type."),
      A_labeled_tuple_element_is_declared_as_rest_with_a_before_the_name_rather_than_before_the_type: diag(5087, ts2.DiagnosticCategory.Error, "A_labeled_tuple_element_is_declared_as_rest_with_a_before_the_name_rather_than_before_the_type_5087", "A labeled tuple element is declared as rest with a '...' before the name, rather than before the type."),
      The_inferred_type_of_0_references_a_type_with_a_cyclic_structure_which_cannot_be_trivially_serialized_A_type_annotation_is_necessary: diag(5088, ts2.DiagnosticCategory.Error, "The_inferred_type_of_0_references_a_type_with_a_cyclic_structure_which_cannot_be_trivially_serialize_5088", "The inferred type of '{0}' references a type with a cyclic structure which cannot be trivially serialized. A type annotation is necessary."),
      Option_0_cannot_be_specified_when_option_jsx_is_1: diag(5089, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_when_option_jsx_is_1_5089", "Option '{0}' cannot be specified when option 'jsx' is '{1}'."),
      Non_relative_paths_are_not_allowed_when_baseUrl_is_not_set_Did_you_forget_a_leading_Slash: diag(5090, ts2.DiagnosticCategory.Error, "Non_relative_paths_are_not_allowed_when_baseUrl_is_not_set_Did_you_forget_a_leading_Slash_5090", "Non-relative paths are not allowed when 'baseUrl' is not set. Did you forget a leading './'?"),
      Option_preserveConstEnums_cannot_be_disabled_when_isolatedModules_is_enabled: diag(5091, ts2.DiagnosticCategory.Error, "Option_preserveConstEnums_cannot_be_disabled_when_isolatedModules_is_enabled_5091", "Option 'preserveConstEnums' cannot be disabled when 'isolatedModules' is enabled."),
      The_root_value_of_a_0_file_must_be_an_object: diag(5092, ts2.DiagnosticCategory.Error, "The_root_value_of_a_0_file_must_be_an_object_5092", "The root value of a '{0}' file must be an object."),
      Compiler_option_0_may_only_be_used_with_build: diag(5093, ts2.DiagnosticCategory.Error, "Compiler_option_0_may_only_be_used_with_build_5093", "Compiler option '--{0}' may only be used with '--build'."),
      Compiler_option_0_may_not_be_used_with_build: diag(5094, ts2.DiagnosticCategory.Error, "Compiler_option_0_may_not_be_used_with_build_5094", "Compiler option '--{0}' may not be used with '--build'."),
      Option_preserveValueImports_can_only_be_used_when_module_is_set_to_es2015_or_later: diag(5095, ts2.DiagnosticCategory.Error, "Option_preserveValueImports_can_only_be_used_when_module_is_set_to_es2015_or_later_5095", "Option 'preserveValueImports' can only be used when 'module' is set to 'es2015' or later."),
      Generates_a_sourcemap_for_each_corresponding_d_ts_file: diag(6e3, ts2.DiagnosticCategory.Message, "Generates_a_sourcemap_for_each_corresponding_d_ts_file_6000", "Generates a sourcemap for each corresponding '.d.ts' file."),
      Concatenate_and_emit_output_to_single_file: diag(6001, ts2.DiagnosticCategory.Message, "Concatenate_and_emit_output_to_single_file_6001", "Concatenate and emit output to single file."),
      Generates_corresponding_d_ts_file: diag(6002, ts2.DiagnosticCategory.Message, "Generates_corresponding_d_ts_file_6002", "Generates corresponding '.d.ts' file."),
      Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations: diag(6004, ts2.DiagnosticCategory.Message, "Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations_6004", "Specify the location where debugger should locate TypeScript files instead of source locations."),
      Watch_input_files: diag(6005, ts2.DiagnosticCategory.Message, "Watch_input_files_6005", "Watch input files."),
      Redirect_output_structure_to_the_directory: diag(6006, ts2.DiagnosticCategory.Message, "Redirect_output_structure_to_the_directory_6006", "Redirect output structure to the directory."),
      Do_not_erase_const_enum_declarations_in_generated_code: diag(6007, ts2.DiagnosticCategory.Message, "Do_not_erase_const_enum_declarations_in_generated_code_6007", "Do not erase const enum declarations in generated code."),
      Do_not_emit_outputs_if_any_errors_were_reported: diag(6008, ts2.DiagnosticCategory.Message, "Do_not_emit_outputs_if_any_errors_were_reported_6008", "Do not emit outputs if any errors were reported."),
      Do_not_emit_comments_to_output: diag(6009, ts2.DiagnosticCategory.Message, "Do_not_emit_comments_to_output_6009", "Do not emit comments to output."),
      Do_not_emit_outputs: diag(6010, ts2.DiagnosticCategory.Message, "Do_not_emit_outputs_6010", "Do not emit outputs."),
      Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typechecking: diag(6011, ts2.DiagnosticCategory.Message, "Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typech_6011", "Allow default imports from modules with no default export. This does not affect code emit, just typechecking."),
      Skip_type_checking_of_declaration_files: diag(6012, ts2.DiagnosticCategory.Message, "Skip_type_checking_of_declaration_files_6012", "Skip type checking of declaration files."),
      Do_not_resolve_the_real_path_of_symlinks: diag(6013, ts2.DiagnosticCategory.Message, "Do_not_resolve_the_real_path_of_symlinks_6013", "Do not resolve the real path of symlinks."),
      Only_emit_d_ts_declaration_files: diag(6014, ts2.DiagnosticCategory.Message, "Only_emit_d_ts_declaration_files_6014", "Only emit '.d.ts' declaration files."),
      Specify_ECMAScript_target_version: diag(6015, ts2.DiagnosticCategory.Message, "Specify_ECMAScript_target_version_6015", "Specify ECMAScript target version."),
      Specify_module_code_generation: diag(6016, ts2.DiagnosticCategory.Message, "Specify_module_code_generation_6016", "Specify module code generation."),
      Print_this_message: diag(6017, ts2.DiagnosticCategory.Message, "Print_this_message_6017", "Print this message."),
      Print_the_compiler_s_version: diag(6019, ts2.DiagnosticCategory.Message, "Print_the_compiler_s_version_6019", "Print the compiler's version."),
      Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json: diag(6020, ts2.DiagnosticCategory.Message, "Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json_6020", "Compile the project given the path to its configuration file, or to a folder with a 'tsconfig.json'."),
      Syntax_Colon_0: diag(6023, ts2.DiagnosticCategory.Message, "Syntax_Colon_0_6023", "Syntax: {0}"),
      options: diag(6024, ts2.DiagnosticCategory.Message, "options_6024", "options"),
      file: diag(6025, ts2.DiagnosticCategory.Message, "file_6025", "file"),
      Examples_Colon_0: diag(6026, ts2.DiagnosticCategory.Message, "Examples_Colon_0_6026", "Examples: {0}"),
      Options_Colon: diag(6027, ts2.DiagnosticCategory.Message, "Options_Colon_6027", "Options:"),
      Version_0: diag(6029, ts2.DiagnosticCategory.Message, "Version_0_6029", "Version {0}"),
      Insert_command_line_options_and_files_from_a_file: diag(6030, ts2.DiagnosticCategory.Message, "Insert_command_line_options_and_files_from_a_file_6030", "Insert command line options and files from a file."),
      Starting_compilation_in_watch_mode: diag(6031, ts2.DiagnosticCategory.Message, "Starting_compilation_in_watch_mode_6031", "Starting compilation in watch mode..."),
      File_change_detected_Starting_incremental_compilation: diag(6032, ts2.DiagnosticCategory.Message, "File_change_detected_Starting_incremental_compilation_6032", "File change detected. Starting incremental compilation..."),
      KIND: diag(6034, ts2.DiagnosticCategory.Message, "KIND_6034", "KIND"),
      FILE: diag(6035, ts2.DiagnosticCategory.Message, "FILE_6035", "FILE"),
      VERSION: diag(6036, ts2.DiagnosticCategory.Message, "VERSION_6036", "VERSION"),
      LOCATION: diag(6037, ts2.DiagnosticCategory.Message, "LOCATION_6037", "LOCATION"),
      DIRECTORY: diag(6038, ts2.DiagnosticCategory.Message, "DIRECTORY_6038", "DIRECTORY"),
      STRATEGY: diag(6039, ts2.DiagnosticCategory.Message, "STRATEGY_6039", "STRATEGY"),
      FILE_OR_DIRECTORY: diag(6040, ts2.DiagnosticCategory.Message, "FILE_OR_DIRECTORY_6040", "FILE OR DIRECTORY"),
      Generates_corresponding_map_file: diag(6043, ts2.DiagnosticCategory.Message, "Generates_corresponding_map_file_6043", "Generates corresponding '.map' file."),
      Compiler_option_0_expects_an_argument: diag(6044, ts2.DiagnosticCategory.Error, "Compiler_option_0_expects_an_argument_6044", "Compiler option '{0}' expects an argument."),
      Unterminated_quoted_string_in_response_file_0: diag(6045, ts2.DiagnosticCategory.Error, "Unterminated_quoted_string_in_response_file_0_6045", "Unterminated quoted string in response file '{0}'."),
      Argument_for_0_option_must_be_Colon_1: diag(6046, ts2.DiagnosticCategory.Error, "Argument_for_0_option_must_be_Colon_1_6046", "Argument for '{0}' option must be: {1}."),
      Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1: diag(6048, ts2.DiagnosticCategory.Error, "Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1_6048", "Locale must be of the form <language> or <language>-<territory>. For example '{0}' or '{1}'."),
      Unable_to_open_file_0: diag(6050, ts2.DiagnosticCategory.Error, "Unable_to_open_file_0_6050", "Unable to open file '{0}'."),
      Corrupted_locale_file_0: diag(6051, ts2.DiagnosticCategory.Error, "Corrupted_locale_file_0_6051", "Corrupted locale file {0}."),
      Raise_error_on_expressions_and_declarations_with_an_implied_any_type: diag(6052, ts2.DiagnosticCategory.Message, "Raise_error_on_expressions_and_declarations_with_an_implied_any_type_6052", "Raise error on expressions and declarations with an implied 'any' type."),
      File_0_not_found: diag(6053, ts2.DiagnosticCategory.Error, "File_0_not_found_6053", "File '{0}' not found."),
      File_0_has_an_unsupported_extension_The_only_supported_extensions_are_1: diag(6054, ts2.DiagnosticCategory.Error, "File_0_has_an_unsupported_extension_The_only_supported_extensions_are_1_6054", "File '{0}' has an unsupported extension. The only supported extensions are {1}."),
      Suppress_noImplicitAny_errors_for_indexing_objects_lacking_index_signatures: diag(6055, ts2.DiagnosticCategory.Message, "Suppress_noImplicitAny_errors_for_indexing_objects_lacking_index_signatures_6055", "Suppress noImplicitAny errors for indexing objects lacking index signatures."),
      Do_not_emit_declarations_for_code_that_has_an_internal_annotation: diag(6056, ts2.DiagnosticCategory.Message, "Do_not_emit_declarations_for_code_that_has_an_internal_annotation_6056", "Do not emit declarations for code that has an '@internal' annotation."),
      Specify_the_root_directory_of_input_files_Use_to_control_the_output_directory_structure_with_outDir: diag(6058, ts2.DiagnosticCategory.Message, "Specify_the_root_directory_of_input_files_Use_to_control_the_output_directory_structure_with_outDir_6058", "Specify the root directory of input files. Use to control the output directory structure with --outDir."),
      File_0_is_not_under_rootDir_1_rootDir_is_expected_to_contain_all_source_files: diag(6059, ts2.DiagnosticCategory.Error, "File_0_is_not_under_rootDir_1_rootDir_is_expected_to_contain_all_source_files_6059", "File '{0}' is not under 'rootDir' '{1}'. 'rootDir' is expected to contain all source files."),
      Specify_the_end_of_line_sequence_to_be_used_when_emitting_files_Colon_CRLF_dos_or_LF_unix: diag(6060, ts2.DiagnosticCategory.Message, "Specify_the_end_of_line_sequence_to_be_used_when_emitting_files_Colon_CRLF_dos_or_LF_unix_6060", "Specify the end of line sequence to be used when emitting files: 'CRLF' (dos) or 'LF' (unix)."),
      NEWLINE: diag(6061, ts2.DiagnosticCategory.Message, "NEWLINE_6061", "NEWLINE"),
      Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_null_on_command_line: diag(6064, ts2.DiagnosticCategory.Error, "Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_null_on_command_line_6064", "Option '{0}' can only be specified in 'tsconfig.json' file or set to 'null' on command line."),
      Enables_experimental_support_for_ES7_decorators: diag(6065, ts2.DiagnosticCategory.Message, "Enables_experimental_support_for_ES7_decorators_6065", "Enables experimental support for ES7 decorators."),
      Enables_experimental_support_for_emitting_type_metadata_for_decorators: diag(6066, ts2.DiagnosticCategory.Message, "Enables_experimental_support_for_emitting_type_metadata_for_decorators_6066", "Enables experimental support for emitting type metadata for decorators."),
      Specify_module_resolution_strategy_Colon_node_Node_js_or_classic_TypeScript_pre_1_6: diag(6069, ts2.DiagnosticCategory.Message, "Specify_module_resolution_strategy_Colon_node_Node_js_or_classic_TypeScript_pre_1_6_6069", "Specify module resolution strategy: 'node' (Node.js) or 'classic' (TypeScript pre-1.6)."),
      Initializes_a_TypeScript_project_and_creates_a_tsconfig_json_file: diag(6070, ts2.DiagnosticCategory.Message, "Initializes_a_TypeScript_project_and_creates_a_tsconfig_json_file_6070", "Initializes a TypeScript project and creates a tsconfig.json file."),
      Successfully_created_a_tsconfig_json_file: diag(6071, ts2.DiagnosticCategory.Message, "Successfully_created_a_tsconfig_json_file_6071", "Successfully created a tsconfig.json file."),
      Suppress_excess_property_checks_for_object_literals: diag(6072, ts2.DiagnosticCategory.Message, "Suppress_excess_property_checks_for_object_literals_6072", "Suppress excess property checks for object literals."),
      Stylize_errors_and_messages_using_color_and_context_experimental: diag(6073, ts2.DiagnosticCategory.Message, "Stylize_errors_and_messages_using_color_and_context_experimental_6073", "Stylize errors and messages using color and context (experimental)."),
      Do_not_report_errors_on_unused_labels: diag(6074, ts2.DiagnosticCategory.Message, "Do_not_report_errors_on_unused_labels_6074", "Do not report errors on unused labels."),
      Report_error_when_not_all_code_paths_in_function_return_a_value: diag(6075, ts2.DiagnosticCategory.Message, "Report_error_when_not_all_code_paths_in_function_return_a_value_6075", "Report error when not all code paths in function return a value."),
      Report_errors_for_fallthrough_cases_in_switch_statement: diag(6076, ts2.DiagnosticCategory.Message, "Report_errors_for_fallthrough_cases_in_switch_statement_6076", "Report errors for fallthrough cases in switch statement."),
      Do_not_report_errors_on_unreachable_code: diag(6077, ts2.DiagnosticCategory.Message, "Do_not_report_errors_on_unreachable_code_6077", "Do not report errors on unreachable code."),
      Disallow_inconsistently_cased_references_to_the_same_file: diag(6078, ts2.DiagnosticCategory.Message, "Disallow_inconsistently_cased_references_to_the_same_file_6078", "Disallow inconsistently-cased references to the same file."),
      Specify_library_files_to_be_included_in_the_compilation: diag(6079, ts2.DiagnosticCategory.Message, "Specify_library_files_to_be_included_in_the_compilation_6079", "Specify library files to be included in the compilation."),
      Specify_JSX_code_generation: diag(6080, ts2.DiagnosticCategory.Message, "Specify_JSX_code_generation_6080", "Specify JSX code generation."),
      File_0_has_an_unsupported_extension_so_skipping_it: diag(6081, ts2.DiagnosticCategory.Message, "File_0_has_an_unsupported_extension_so_skipping_it_6081", "File '{0}' has an unsupported extension, so skipping it."),
      Only_amd_and_system_modules_are_supported_alongside_0: diag(6082, ts2.DiagnosticCategory.Error, "Only_amd_and_system_modules_are_supported_alongside_0_6082", "Only 'amd' and 'system' modules are supported alongside --{0}."),
      Base_directory_to_resolve_non_absolute_module_names: diag(6083, ts2.DiagnosticCategory.Message, "Base_directory_to_resolve_non_absolute_module_names_6083", "Base directory to resolve non-absolute module names."),
      Deprecated_Use_jsxFactory_instead_Specify_the_object_invoked_for_createElement_when_targeting_react_JSX_emit: diag(6084, ts2.DiagnosticCategory.Message, "Deprecated_Use_jsxFactory_instead_Specify_the_object_invoked_for_createElement_when_targeting_react__6084", "[Deprecated] Use '--jsxFactory' instead. Specify the object invoked for createElement when targeting 'react' JSX emit"),
      Enable_tracing_of_the_name_resolution_process: diag(6085, ts2.DiagnosticCategory.Message, "Enable_tracing_of_the_name_resolution_process_6085", "Enable tracing of the name resolution process."),
      Resolving_module_0_from_1: diag(6086, ts2.DiagnosticCategory.Message, "Resolving_module_0_from_1_6086", "======== Resolving module '{0}' from '{1}'. ========"),
      Explicitly_specified_module_resolution_kind_Colon_0: diag(6087, ts2.DiagnosticCategory.Message, "Explicitly_specified_module_resolution_kind_Colon_0_6087", "Explicitly specified module resolution kind: '{0}'."),
      Module_resolution_kind_is_not_specified_using_0: diag(6088, ts2.DiagnosticCategory.Message, "Module_resolution_kind_is_not_specified_using_0_6088", "Module resolution kind is not specified, using '{0}'."),
      Module_name_0_was_successfully_resolved_to_1: diag(6089, ts2.DiagnosticCategory.Message, "Module_name_0_was_successfully_resolved_to_1_6089", "======== Module name '{0}' was successfully resolved to '{1}'. ========"),
      Module_name_0_was_not_resolved: diag(6090, ts2.DiagnosticCategory.Message, "Module_name_0_was_not_resolved_6090", "======== Module name '{0}' was not resolved. ========"),
      paths_option_is_specified_looking_for_a_pattern_to_match_module_name_0: diag(6091, ts2.DiagnosticCategory.Message, "paths_option_is_specified_looking_for_a_pattern_to_match_module_name_0_6091", "'paths' option is specified, looking for a pattern to match module name '{0}'."),
      Module_name_0_matched_pattern_1: diag(6092, ts2.DiagnosticCategory.Message, "Module_name_0_matched_pattern_1_6092", "Module name '{0}', matched pattern '{1}'."),
      Trying_substitution_0_candidate_module_location_Colon_1: diag(6093, ts2.DiagnosticCategory.Message, "Trying_substitution_0_candidate_module_location_Colon_1_6093", "Trying substitution '{0}', candidate module location: '{1}'."),
      Resolving_module_name_0_relative_to_base_url_1_2: diag(6094, ts2.DiagnosticCategory.Message, "Resolving_module_name_0_relative_to_base_url_1_2_6094", "Resolving module name '{0}' relative to base url '{1}' - '{2}'."),
      Loading_module_as_file_Slash_folder_candidate_module_location_0_target_file_type_1: diag(6095, ts2.DiagnosticCategory.Message, "Loading_module_as_file_Slash_folder_candidate_module_location_0_target_file_type_1_6095", "Loading module as file / folder, candidate module location '{0}', target file type '{1}'."),
      File_0_does_not_exist: diag(6096, ts2.DiagnosticCategory.Message, "File_0_does_not_exist_6096", "File '{0}' does not exist."),
      File_0_exist_use_it_as_a_name_resolution_result: diag(6097, ts2.DiagnosticCategory.Message, "File_0_exist_use_it_as_a_name_resolution_result_6097", "File '{0}' exist - use it as a name resolution result."),
      Loading_module_0_from_node_modules_folder_target_file_type_1: diag(6098, ts2.DiagnosticCategory.Message, "Loading_module_0_from_node_modules_folder_target_file_type_1_6098", "Loading module '{0}' from 'node_modules' folder, target file type '{1}'."),
      Found_package_json_at_0: diag(6099, ts2.DiagnosticCategory.Message, "Found_package_json_at_0_6099", "Found 'package.json' at '{0}'."),
      package_json_does_not_have_a_0_field: diag(6100, ts2.DiagnosticCategory.Message, "package_json_does_not_have_a_0_field_6100", "'package.json' does not have a '{0}' field."),
      package_json_has_0_field_1_that_references_2: diag(6101, ts2.DiagnosticCategory.Message, "package_json_has_0_field_1_that_references_2_6101", "'package.json' has '{0}' field '{1}' that references '{2}'."),
      Allow_javascript_files_to_be_compiled: diag(6102, ts2.DiagnosticCategory.Message, "Allow_javascript_files_to_be_compiled_6102", "Allow javascript files to be compiled."),
      Checking_if_0_is_the_longest_matching_prefix_for_1_2: diag(6104, ts2.DiagnosticCategory.Message, "Checking_if_0_is_the_longest_matching_prefix_for_1_2_6104", "Checking if '{0}' is the longest matching prefix for '{1}' - '{2}'."),
      Expected_type_of_0_field_in_package_json_to_be_1_got_2: diag(6105, ts2.DiagnosticCategory.Message, "Expected_type_of_0_field_in_package_json_to_be_1_got_2_6105", "Expected type of '{0}' field in 'package.json' to be '{1}', got '{2}'."),
      baseUrl_option_is_set_to_0_using_this_value_to_resolve_non_relative_module_name_1: diag(6106, ts2.DiagnosticCategory.Message, "baseUrl_option_is_set_to_0_using_this_value_to_resolve_non_relative_module_name_1_6106", "'baseUrl' option is set to '{0}', using this value to resolve non-relative module name '{1}'."),
      rootDirs_option_is_set_using_it_to_resolve_relative_module_name_0: diag(6107, ts2.DiagnosticCategory.Message, "rootDirs_option_is_set_using_it_to_resolve_relative_module_name_0_6107", "'rootDirs' option is set, using it to resolve relative module name '{0}'."),
      Longest_matching_prefix_for_0_is_1: diag(6108, ts2.DiagnosticCategory.Message, "Longest_matching_prefix_for_0_is_1_6108", "Longest matching prefix for '{0}' is '{1}'."),
      Loading_0_from_the_root_dir_1_candidate_location_2: diag(6109, ts2.DiagnosticCategory.Message, "Loading_0_from_the_root_dir_1_candidate_location_2_6109", "Loading '{0}' from the root dir '{1}', candidate location '{2}'."),
      Trying_other_entries_in_rootDirs: diag(6110, ts2.DiagnosticCategory.Message, "Trying_other_entries_in_rootDirs_6110", "Trying other entries in 'rootDirs'."),
      Module_resolution_using_rootDirs_has_failed: diag(6111, ts2.DiagnosticCategory.Message, "Module_resolution_using_rootDirs_has_failed_6111", "Module resolution using 'rootDirs' has failed."),
      Do_not_emit_use_strict_directives_in_module_output: diag(6112, ts2.DiagnosticCategory.Message, "Do_not_emit_use_strict_directives_in_module_output_6112", "Do not emit 'use strict' directives in module output."),
      Enable_strict_null_checks: diag(6113, ts2.DiagnosticCategory.Message, "Enable_strict_null_checks_6113", "Enable strict null checks."),
      Unknown_option_excludes_Did_you_mean_exclude: diag(6114, ts2.DiagnosticCategory.Error, "Unknown_option_excludes_Did_you_mean_exclude_6114", "Unknown option 'excludes'. Did you mean 'exclude'?"),
      Raise_error_on_this_expressions_with_an_implied_any_type: diag(6115, ts2.DiagnosticCategory.Message, "Raise_error_on_this_expressions_with_an_implied_any_type_6115", "Raise error on 'this' expressions with an implied 'any' type."),
      Resolving_type_reference_directive_0_containing_file_1_root_directory_2: diag(6116, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_1_root_directory_2_6116", "======== Resolving type reference directive '{0}', containing file '{1}', root directory '{2}'. ========"),
      Type_reference_directive_0_was_successfully_resolved_to_1_primary_Colon_2: diag(6119, ts2.DiagnosticCategory.Message, "Type_reference_directive_0_was_successfully_resolved_to_1_primary_Colon_2_6119", "======== Type reference directive '{0}' was successfully resolved to '{1}', primary: {2}. ========"),
      Type_reference_directive_0_was_not_resolved: diag(6120, ts2.DiagnosticCategory.Message, "Type_reference_directive_0_was_not_resolved_6120", "======== Type reference directive '{0}' was not resolved. ========"),
      Resolving_with_primary_search_path_0: diag(6121, ts2.DiagnosticCategory.Message, "Resolving_with_primary_search_path_0_6121", "Resolving with primary search path '{0}'."),
      Root_directory_cannot_be_determined_skipping_primary_search_paths: diag(6122, ts2.DiagnosticCategory.Message, "Root_directory_cannot_be_determined_skipping_primary_search_paths_6122", "Root directory cannot be determined, skipping primary search paths."),
      Resolving_type_reference_directive_0_containing_file_1_root_directory_not_set: diag(6123, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_1_root_directory_not_set_6123", "======== Resolving type reference directive '{0}', containing file '{1}', root directory not set. ========"),
      Type_declaration_files_to_be_included_in_compilation: diag(6124, ts2.DiagnosticCategory.Message, "Type_declaration_files_to_be_included_in_compilation_6124", "Type declaration files to be included in compilation."),
      Looking_up_in_node_modules_folder_initial_location_0: diag(6125, ts2.DiagnosticCategory.Message, "Looking_up_in_node_modules_folder_initial_location_0_6125", "Looking up in 'node_modules' folder, initial location '{0}'."),
      Containing_file_is_not_specified_and_root_directory_cannot_be_determined_skipping_lookup_in_node_modules_folder: diag(6126, ts2.DiagnosticCategory.Message, "Containing_file_is_not_specified_and_root_directory_cannot_be_determined_skipping_lookup_in_node_mod_6126", "Containing file is not specified and root directory cannot be determined, skipping lookup in 'node_modules' folder."),
      Resolving_type_reference_directive_0_containing_file_not_set_root_directory_1: diag(6127, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_not_set_root_directory_1_6127", "======== Resolving type reference directive '{0}', containing file not set, root directory '{1}'. ========"),
      Resolving_type_reference_directive_0_containing_file_not_set_root_directory_not_set: diag(6128, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_not_set_root_directory_not_set_6128", "======== Resolving type reference directive '{0}', containing file not set, root directory not set. ========"),
      Resolving_real_path_for_0_result_1: diag(6130, ts2.DiagnosticCategory.Message, "Resolving_real_path_for_0_result_1_6130", "Resolving real path for '{0}', result '{1}'."),
      Cannot_compile_modules_using_option_0_unless_the_module_flag_is_amd_or_system: diag(6131, ts2.DiagnosticCategory.Error, "Cannot_compile_modules_using_option_0_unless_the_module_flag_is_amd_or_system_6131", "Cannot compile modules using option '{0}' unless the '--module' flag is 'amd' or 'system'."),
      File_name_0_has_a_1_extension_stripping_it: diag(6132, ts2.DiagnosticCategory.Message, "File_name_0_has_a_1_extension_stripping_it_6132", "File name '{0}' has a '{1}' extension - stripping it."),
      _0_is_declared_but_its_value_is_never_read: diag(6133, ts2.DiagnosticCategory.Error, "_0_is_declared_but_its_value_is_never_read_6133", "'{0}' is declared but its value is never read.", true),
      Report_errors_on_unused_locals: diag(6134, ts2.DiagnosticCategory.Message, "Report_errors_on_unused_locals_6134", "Report errors on unused locals."),
      Report_errors_on_unused_parameters: diag(6135, ts2.DiagnosticCategory.Message, "Report_errors_on_unused_parameters_6135", "Report errors on unused parameters."),
      The_maximum_dependency_depth_to_search_under_node_modules_and_load_JavaScript_files: diag(6136, ts2.DiagnosticCategory.Message, "The_maximum_dependency_depth_to_search_under_node_modules_and_load_JavaScript_files_6136", "The maximum dependency depth to search under node_modules and load JavaScript files."),
      Cannot_import_type_declaration_files_Consider_importing_0_instead_of_1: diag(6137, ts2.DiagnosticCategory.Error, "Cannot_import_type_declaration_files_Consider_importing_0_instead_of_1_6137", "Cannot import type declaration files. Consider importing '{0}' instead of '{1}'."),
      Property_0_is_declared_but_its_value_is_never_read: diag(6138, ts2.DiagnosticCategory.Error, "Property_0_is_declared_but_its_value_is_never_read_6138", "Property '{0}' is declared but its value is never read.", true),
      Import_emit_helpers_from_tslib: diag(6139, ts2.DiagnosticCategory.Message, "Import_emit_helpers_from_tslib_6139", "Import emit helpers from 'tslib'."),
      Auto_discovery_for_typings_is_enabled_in_project_0_Running_extra_resolution_pass_for_module_1_using_cache_location_2: diag(6140, ts2.DiagnosticCategory.Error, "Auto_discovery_for_typings_is_enabled_in_project_0_Running_extra_resolution_pass_for_module_1_using__6140", "Auto discovery for typings is enabled in project '{0}'. Running extra resolution pass for module '{1}' using cache location '{2}'."),
      Parse_in_strict_mode_and_emit_use_strict_for_each_source_file: diag(6141, ts2.DiagnosticCategory.Message, "Parse_in_strict_mode_and_emit_use_strict_for_each_source_file_6141", 'Parse in strict mode and emit "use strict" for each source file.'),
      Module_0_was_resolved_to_1_but_jsx_is_not_set: diag(6142, ts2.DiagnosticCategory.Error, "Module_0_was_resolved_to_1_but_jsx_is_not_set_6142", "Module '{0}' was resolved to '{1}', but '--jsx' is not set."),
      Module_0_was_resolved_as_locally_declared_ambient_module_in_file_1: diag(6144, ts2.DiagnosticCategory.Message, "Module_0_was_resolved_as_locally_declared_ambient_module_in_file_1_6144", "Module '{0}' was resolved as locally declared ambient module in file '{1}'."),
      Module_0_was_resolved_as_ambient_module_declared_in_1_since_this_file_was_not_modified: diag(6145, ts2.DiagnosticCategory.Message, "Module_0_was_resolved_as_ambient_module_declared_in_1_since_this_file_was_not_modified_6145", "Module '{0}' was resolved as ambient module declared in '{1}' since this file was not modified."),
      Specify_the_JSX_factory_function_to_use_when_targeting_react_JSX_emit_e_g_React_createElement_or_h: diag(6146, ts2.DiagnosticCategory.Message, "Specify_the_JSX_factory_function_to_use_when_targeting_react_JSX_emit_e_g_React_createElement_or_h_6146", "Specify the JSX factory function to use when targeting 'react' JSX emit, e.g. 'React.createElement' or 'h'."),
      Resolution_for_module_0_was_found_in_cache_from_location_1: diag(6147, ts2.DiagnosticCategory.Message, "Resolution_for_module_0_was_found_in_cache_from_location_1_6147", "Resolution for module '{0}' was found in cache from location '{1}'."),
      Directory_0_does_not_exist_skipping_all_lookups_in_it: diag(6148, ts2.DiagnosticCategory.Message, "Directory_0_does_not_exist_skipping_all_lookups_in_it_6148", "Directory '{0}' does not exist, skipping all lookups in it."),
      Show_diagnostic_information: diag(6149, ts2.DiagnosticCategory.Message, "Show_diagnostic_information_6149", "Show diagnostic information."),
      Show_verbose_diagnostic_information: diag(6150, ts2.DiagnosticCategory.Message, "Show_verbose_diagnostic_information_6150", "Show verbose diagnostic information."),
      Emit_a_single_file_with_source_maps_instead_of_having_a_separate_file: diag(6151, ts2.DiagnosticCategory.Message, "Emit_a_single_file_with_source_maps_instead_of_having_a_separate_file_6151", "Emit a single file with source maps instead of having a separate file."),
      Emit_the_source_alongside_the_sourcemaps_within_a_single_file_requires_inlineSourceMap_or_sourceMap_to_be_set: diag(6152, ts2.DiagnosticCategory.Message, "Emit_the_source_alongside_the_sourcemaps_within_a_single_file_requires_inlineSourceMap_or_sourceMap__6152", "Emit the source alongside the sourcemaps within a single file; requires '--inlineSourceMap' or '--sourceMap' to be set."),
      Transpile_each_file_as_a_separate_module_similar_to_ts_transpileModule: diag(6153, ts2.DiagnosticCategory.Message, "Transpile_each_file_as_a_separate_module_similar_to_ts_transpileModule_6153", "Transpile each file as a separate module (similar to 'ts.transpileModule')."),
      Print_names_of_generated_files_part_of_the_compilation: diag(6154, ts2.DiagnosticCategory.Message, "Print_names_of_generated_files_part_of_the_compilation_6154", "Print names of generated files part of the compilation."),
      Print_names_of_files_part_of_the_compilation: diag(6155, ts2.DiagnosticCategory.Message, "Print_names_of_files_part_of_the_compilation_6155", "Print names of files part of the compilation."),
      The_locale_used_when_displaying_messages_to_the_user_e_g_en_us: diag(6156, ts2.DiagnosticCategory.Message, "The_locale_used_when_displaying_messages_to_the_user_e_g_en_us_6156", "The locale used when displaying messages to the user (e.g. 'en-us')"),
      Do_not_generate_custom_helper_functions_like_extends_in_compiled_output: diag(6157, ts2.DiagnosticCategory.Message, "Do_not_generate_custom_helper_functions_like_extends_in_compiled_output_6157", "Do not generate custom helper functions like '__extends' in compiled output."),
      Do_not_include_the_default_library_file_lib_d_ts: diag(6158, ts2.DiagnosticCategory.Message, "Do_not_include_the_default_library_file_lib_d_ts_6158", "Do not include the default library file (lib.d.ts)."),
      Do_not_add_triple_slash_references_or_imported_modules_to_the_list_of_compiled_files: diag(6159, ts2.DiagnosticCategory.Message, "Do_not_add_triple_slash_references_or_imported_modules_to_the_list_of_compiled_files_6159", "Do not add triple-slash references or imported modules to the list of compiled files."),
      Deprecated_Use_skipLibCheck_instead_Skip_type_checking_of_default_library_declaration_files: diag(6160, ts2.DiagnosticCategory.Message, "Deprecated_Use_skipLibCheck_instead_Skip_type_checking_of_default_library_declaration_files_6160", "[Deprecated] Use '--skipLibCheck' instead. Skip type checking of default library declaration files."),
      List_of_folders_to_include_type_definitions_from: diag(6161, ts2.DiagnosticCategory.Message, "List_of_folders_to_include_type_definitions_from_6161", "List of folders to include type definitions from."),
      Disable_size_limitations_on_JavaScript_projects: diag(6162, ts2.DiagnosticCategory.Message, "Disable_size_limitations_on_JavaScript_projects_6162", "Disable size limitations on JavaScript projects."),
      The_character_set_of_the_input_files: diag(6163, ts2.DiagnosticCategory.Message, "The_character_set_of_the_input_files_6163", "The character set of the input files."),
      Do_not_truncate_error_messages: diag(6165, ts2.DiagnosticCategory.Message, "Do_not_truncate_error_messages_6165", "Do not truncate error messages."),
      Output_directory_for_generated_declaration_files: diag(6166, ts2.DiagnosticCategory.Message, "Output_directory_for_generated_declaration_files_6166", "Output directory for generated declaration files."),
      A_series_of_entries_which_re_map_imports_to_lookup_locations_relative_to_the_baseUrl: diag(6167, ts2.DiagnosticCategory.Message, "A_series_of_entries_which_re_map_imports_to_lookup_locations_relative_to_the_baseUrl_6167", "A series of entries which re-map imports to lookup locations relative to the 'baseUrl'."),
      List_of_root_folders_whose_combined_content_represents_the_structure_of_the_project_at_runtime: diag(6168, ts2.DiagnosticCategory.Message, "List_of_root_folders_whose_combined_content_represents_the_structure_of_the_project_at_runtime_6168", "List of root folders whose combined content represents the structure of the project at runtime."),
      Show_all_compiler_options: diag(6169, ts2.DiagnosticCategory.Message, "Show_all_compiler_options_6169", "Show all compiler options."),
      Deprecated_Use_outFile_instead_Concatenate_and_emit_output_to_single_file: diag(6170, ts2.DiagnosticCategory.Message, "Deprecated_Use_outFile_instead_Concatenate_and_emit_output_to_single_file_6170", "[Deprecated] Use '--outFile' instead. Concatenate and emit output to single file"),
      Command_line_Options: diag(6171, ts2.DiagnosticCategory.Message, "Command_line_Options_6171", "Command-line Options"),
      Provide_full_support_for_iterables_in_for_of_spread_and_destructuring_when_targeting_ES5_or_ES3: diag(6179, ts2.DiagnosticCategory.Message, "Provide_full_support_for_iterables_in_for_of_spread_and_destructuring_when_targeting_ES5_or_ES3_6179", "Provide full support for iterables in 'for-of', spread, and destructuring when targeting 'ES5' or 'ES3'."),
      Enable_all_strict_type_checking_options: diag(6180, ts2.DiagnosticCategory.Message, "Enable_all_strict_type_checking_options_6180", "Enable all strict type-checking options."),
      List_of_language_service_plugins: diag(6181, ts2.DiagnosticCategory.Message, "List_of_language_service_plugins_6181", "List of language service plugins."),
      Scoped_package_detected_looking_in_0: diag(6182, ts2.DiagnosticCategory.Message, "Scoped_package_detected_looking_in_0_6182", "Scoped package detected, looking in '{0}'"),
      Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2: diag(6183, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2_6183", "Reusing resolution of module '{0}' from '{1}' of old program, it was successfully resolved to '{2}'."),
      Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2_with_Package_ID_3: diag(6184, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2_with_Package__6184", "Reusing resolution of module '{0}' from '{1}' of old program, it was successfully resolved to '{2}' with Package ID '{3}'."),
      Enable_strict_checking_of_function_types: diag(6186, ts2.DiagnosticCategory.Message, "Enable_strict_checking_of_function_types_6186", "Enable strict checking of function types."),
      Enable_strict_checking_of_property_initialization_in_classes: diag(6187, ts2.DiagnosticCategory.Message, "Enable_strict_checking_of_property_initialization_in_classes_6187", "Enable strict checking of property initialization in classes."),
      Numeric_separators_are_not_allowed_here: diag(6188, ts2.DiagnosticCategory.Error, "Numeric_separators_are_not_allowed_here_6188", "Numeric separators are not allowed here."),
      Multiple_consecutive_numeric_separators_are_not_permitted: diag(6189, ts2.DiagnosticCategory.Error, "Multiple_consecutive_numeric_separators_are_not_permitted_6189", "Multiple consecutive numeric separators are not permitted."),
      Whether_to_keep_outdated_console_output_in_watch_mode_instead_of_clearing_the_screen: diag(6191, ts2.DiagnosticCategory.Message, "Whether_to_keep_outdated_console_output_in_watch_mode_instead_of_clearing_the_screen_6191", "Whether to keep outdated console output in watch mode instead of clearing the screen."),
      All_imports_in_import_declaration_are_unused: diag(6192, ts2.DiagnosticCategory.Error, "All_imports_in_import_declaration_are_unused_6192", "All imports in import declaration are unused.", true),
      Found_1_error_Watching_for_file_changes: diag(6193, ts2.DiagnosticCategory.Message, "Found_1_error_Watching_for_file_changes_6193", "Found 1 error. Watching for file changes."),
      Found_0_errors_Watching_for_file_changes: diag(6194, ts2.DiagnosticCategory.Message, "Found_0_errors_Watching_for_file_changes_6194", "Found {0} errors. Watching for file changes."),
      Resolve_keyof_to_string_valued_property_names_only_no_numbers_or_symbols: diag(6195, ts2.DiagnosticCategory.Message, "Resolve_keyof_to_string_valued_property_names_only_no_numbers_or_symbols_6195", "Resolve 'keyof' to string valued property names only (no numbers or symbols)."),
      _0_is_declared_but_never_used: diag(6196, ts2.DiagnosticCategory.Error, "_0_is_declared_but_never_used_6196", "'{0}' is declared but never used.", true),
      Include_modules_imported_with_json_extension: diag(6197, ts2.DiagnosticCategory.Message, "Include_modules_imported_with_json_extension_6197", "Include modules imported with '.json' extension"),
      All_destructured_elements_are_unused: diag(6198, ts2.DiagnosticCategory.Error, "All_destructured_elements_are_unused_6198", "All destructured elements are unused.", true),
      All_variables_are_unused: diag(6199, ts2.DiagnosticCategory.Error, "All_variables_are_unused_6199", "All variables are unused.", true),
      Definitions_of_the_following_identifiers_conflict_with_those_in_another_file_Colon_0: diag(6200, ts2.DiagnosticCategory.Error, "Definitions_of_the_following_identifiers_conflict_with_those_in_another_file_Colon_0_6200", "Definitions of the following identifiers conflict with those in another file: {0}"),
      Conflicts_are_in_this_file: diag(6201, ts2.DiagnosticCategory.Message, "Conflicts_are_in_this_file_6201", "Conflicts are in this file."),
      Project_references_may_not_form_a_circular_graph_Cycle_detected_Colon_0: diag(6202, ts2.DiagnosticCategory.Error, "Project_references_may_not_form_a_circular_graph_Cycle_detected_Colon_0_6202", "Project references may not form a circular graph. Cycle detected: {0}"),
      _0_was_also_declared_here: diag(6203, ts2.DiagnosticCategory.Message, "_0_was_also_declared_here_6203", "'{0}' was also declared here."),
      and_here: diag(6204, ts2.DiagnosticCategory.Message, "and_here_6204", "and here."),
      All_type_parameters_are_unused: diag(6205, ts2.DiagnosticCategory.Error, "All_type_parameters_are_unused_6205", "All type parameters are unused."),
      package_json_has_a_typesVersions_field_with_version_specific_path_mappings: diag(6206, ts2.DiagnosticCategory.Message, "package_json_has_a_typesVersions_field_with_version_specific_path_mappings_6206", "'package.json' has a 'typesVersions' field with version-specific path mappings."),
      package_json_does_not_have_a_typesVersions_entry_that_matches_version_0: diag(6207, ts2.DiagnosticCategory.Message, "package_json_does_not_have_a_typesVersions_entry_that_matches_version_0_6207", "'package.json' does not have a 'typesVersions' entry that matches version '{0}'."),
      package_json_has_a_typesVersions_entry_0_that_matches_compiler_version_1_looking_for_a_pattern_to_match_module_name_2: diag(6208, ts2.DiagnosticCategory.Message, "package_json_has_a_typesVersions_entry_0_that_matches_compiler_version_1_looking_for_a_pattern_to_ma_6208", "'package.json' has a 'typesVersions' entry '{0}' that matches compiler version '{1}', looking for a pattern to match module name '{2}'."),
      package_json_has_a_typesVersions_entry_0_that_is_not_a_valid_semver_range: diag(6209, ts2.DiagnosticCategory.Message, "package_json_has_a_typesVersions_entry_0_that_is_not_a_valid_semver_range_6209", "'package.json' has a 'typesVersions' entry '{0}' that is not a valid semver range."),
      An_argument_for_0_was_not_provided: diag(6210, ts2.DiagnosticCategory.Message, "An_argument_for_0_was_not_provided_6210", "An argument for '{0}' was not provided."),
      An_argument_matching_this_binding_pattern_was_not_provided: diag(6211, ts2.DiagnosticCategory.Message, "An_argument_matching_this_binding_pattern_was_not_provided_6211", "An argument matching this binding pattern was not provided."),
      Did_you_mean_to_call_this_expression: diag(6212, ts2.DiagnosticCategory.Message, "Did_you_mean_to_call_this_expression_6212", "Did you mean to call this expression?"),
      Did_you_mean_to_use_new_with_this_expression: diag(6213, ts2.DiagnosticCategory.Message, "Did_you_mean_to_use_new_with_this_expression_6213", "Did you mean to use 'new' with this expression?"),
      Enable_strict_bind_call_and_apply_methods_on_functions: diag(6214, ts2.DiagnosticCategory.Message, "Enable_strict_bind_call_and_apply_methods_on_functions_6214", "Enable strict 'bind', 'call', and 'apply' methods on functions."),
      Using_compiler_options_of_project_reference_redirect_0: diag(6215, ts2.DiagnosticCategory.Message, "Using_compiler_options_of_project_reference_redirect_0_6215", "Using compiler options of project reference redirect '{0}'."),
      Found_1_error: diag(6216, ts2.DiagnosticCategory.Message, "Found_1_error_6216", "Found 1 error."),
      Found_0_errors: diag(6217, ts2.DiagnosticCategory.Message, "Found_0_errors_6217", "Found {0} errors."),
      Module_name_0_was_successfully_resolved_to_1_with_Package_ID_2: diag(6218, ts2.DiagnosticCategory.Message, "Module_name_0_was_successfully_resolved_to_1_with_Package_ID_2_6218", "======== Module name '{0}' was successfully resolved to '{1}' with Package ID '{2}'. ========"),
      Type_reference_directive_0_was_successfully_resolved_to_1_with_Package_ID_2_primary_Colon_3: diag(6219, ts2.DiagnosticCategory.Message, "Type_reference_directive_0_was_successfully_resolved_to_1_with_Package_ID_2_primary_Colon_3_6219", "======== Type reference directive '{0}' was successfully resolved to '{1}' with Package ID '{2}', primary: {3}. ========"),
      package_json_had_a_falsy_0_field: diag(6220, ts2.DiagnosticCategory.Message, "package_json_had_a_falsy_0_field_6220", "'package.json' had a falsy '{0}' field."),
      Disable_use_of_source_files_instead_of_declaration_files_from_referenced_projects: diag(6221, ts2.DiagnosticCategory.Message, "Disable_use_of_source_files_instead_of_declaration_files_from_referenced_projects_6221", "Disable use of source files instead of declaration files from referenced projects."),
      Emit_class_fields_with_Define_instead_of_Set: diag(6222, ts2.DiagnosticCategory.Message, "Emit_class_fields_with_Define_instead_of_Set_6222", "Emit class fields with Define instead of Set."),
      Generates_a_CPU_profile: diag(6223, ts2.DiagnosticCategory.Message, "Generates_a_CPU_profile_6223", "Generates a CPU profile."),
      Disable_solution_searching_for_this_project: diag(6224, ts2.DiagnosticCategory.Message, "Disable_solution_searching_for_this_project_6224", "Disable solution searching for this project."),
      Specify_strategy_for_watching_file_Colon_FixedPollingInterval_default_PriorityPollingInterval_DynamicPriorityPolling_FixedChunkSizePolling_UseFsEvents_UseFsEventsOnParentDirectory: diag(6225, ts2.DiagnosticCategory.Message, "Specify_strategy_for_watching_file_Colon_FixedPollingInterval_default_PriorityPollingInterval_Dynami_6225", "Specify strategy for watching file: 'FixedPollingInterval' (default), 'PriorityPollingInterval', 'DynamicPriorityPolling', 'FixedChunkSizePolling', 'UseFsEvents', 'UseFsEventsOnParentDirectory'."),
      Specify_strategy_for_watching_directory_on_platforms_that_don_t_support_recursive_watching_natively_Colon_UseFsEvents_default_FixedPollingInterval_DynamicPriorityPolling_FixedChunkSizePolling: diag(6226, ts2.DiagnosticCategory.Message, "Specify_strategy_for_watching_directory_on_platforms_that_don_t_support_recursive_watching_natively__6226", "Specify strategy for watching directory on platforms that don't support recursive watching natively: 'UseFsEvents' (default), 'FixedPollingInterval', 'DynamicPriorityPolling', 'FixedChunkSizePolling'."),
      Specify_strategy_for_creating_a_polling_watch_when_it_fails_to_create_using_file_system_events_Colon_FixedInterval_default_PriorityInterval_DynamicPriority_FixedChunkSize: diag(6227, ts2.DiagnosticCategory.Message, "Specify_strategy_for_creating_a_polling_watch_when_it_fails_to_create_using_file_system_events_Colon_6227", "Specify strategy for creating a polling watch when it fails to create using file system events: 'FixedInterval' (default), 'PriorityInterval', 'DynamicPriority', 'FixedChunkSize'."),
      Tag_0_expects_at_least_1_arguments_but_the_JSX_factory_2_provides_at_most_3: diag(6229, ts2.DiagnosticCategory.Error, "Tag_0_expects_at_least_1_arguments_but_the_JSX_factory_2_provides_at_most_3_6229", "Tag '{0}' expects at least '{1}' arguments, but the JSX factory '{2}' provides at most '{3}'."),
      Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_false_or_null_on_command_line: diag(6230, ts2.DiagnosticCategory.Error, "Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_false_or_null_on_command_line_6230", "Option '{0}' can only be specified in 'tsconfig.json' file or set to 'false' or 'null' on command line."),
      Could_not_resolve_the_path_0_with_the_extensions_Colon_1: diag(6231, ts2.DiagnosticCategory.Error, "Could_not_resolve_the_path_0_with_the_extensions_Colon_1_6231", "Could not resolve the path '{0}' with the extensions: {1}."),
      Declaration_augments_declaration_in_another_file_This_cannot_be_serialized: diag(6232, ts2.DiagnosticCategory.Error, "Declaration_augments_declaration_in_another_file_This_cannot_be_serialized_6232", "Declaration augments declaration in another file. This cannot be serialized."),
      This_is_the_declaration_being_augmented_Consider_moving_the_augmenting_declaration_into_the_same_file: diag(6233, ts2.DiagnosticCategory.Error, "This_is_the_declaration_being_augmented_Consider_moving_the_augmenting_declaration_into_the_same_fil_6233", "This is the declaration being augmented. Consider moving the augmenting declaration into the same file."),
      This_expression_is_not_callable_because_it_is_a_get_accessor_Did_you_mean_to_use_it_without: diag(6234, ts2.DiagnosticCategory.Error, "This_expression_is_not_callable_because_it_is_a_get_accessor_Did_you_mean_to_use_it_without_6234", "This expression is not callable because it is a 'get' accessor. Did you mean to use it without '()'?"),
      Disable_loading_referenced_projects: diag(6235, ts2.DiagnosticCategory.Message, "Disable_loading_referenced_projects_6235", "Disable loading referenced projects."),
      Arguments_for_the_rest_parameter_0_were_not_provided: diag(6236, ts2.DiagnosticCategory.Error, "Arguments_for_the_rest_parameter_0_were_not_provided_6236", "Arguments for the rest parameter '{0}' were not provided."),
      Generates_an_event_trace_and_a_list_of_types: diag(6237, ts2.DiagnosticCategory.Message, "Generates_an_event_trace_and_a_list_of_types_6237", "Generates an event trace and a list of types."),
      Specify_the_module_specifier_to_be_used_to_import_the_jsx_and_jsxs_factory_functions_from_eg_react: diag(6238, ts2.DiagnosticCategory.Error, "Specify_the_module_specifier_to_be_used_to_import_the_jsx_and_jsxs_factory_functions_from_eg_react_6238", "Specify the module specifier to be used to import the 'jsx' and 'jsxs' factory functions from. eg, react"),
      File_0_exists_according_to_earlier_cached_lookups: diag(6239, ts2.DiagnosticCategory.Message, "File_0_exists_according_to_earlier_cached_lookups_6239", "File '{0}' exists according to earlier cached lookups."),
      File_0_does_not_exist_according_to_earlier_cached_lookups: diag(6240, ts2.DiagnosticCategory.Message, "File_0_does_not_exist_according_to_earlier_cached_lookups_6240", "File '{0}' does not exist according to earlier cached lookups."),
      Resolution_for_type_reference_directive_0_was_found_in_cache_from_location_1: diag(6241, ts2.DiagnosticCategory.Message, "Resolution_for_type_reference_directive_0_was_found_in_cache_from_location_1_6241", "Resolution for type reference directive '{0}' was found in cache from location '{1}'."),
      Resolving_type_reference_directive_0_containing_file_1: diag(6242, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_1_6242", "======== Resolving type reference directive '{0}', containing file '{1}'. ========"),
      Interpret_optional_property_types_as_written_rather_than_adding_undefined: diag(6243, ts2.DiagnosticCategory.Message, "Interpret_optional_property_types_as_written_rather_than_adding_undefined_6243", "Interpret optional property types as written, rather than adding 'undefined'."),
      Modules: diag(6244, ts2.DiagnosticCategory.Message, "Modules_6244", "Modules"),
      File_Management: diag(6245, ts2.DiagnosticCategory.Message, "File_Management_6245", "File Management"),
      Emit: diag(6246, ts2.DiagnosticCategory.Message, "Emit_6246", "Emit"),
      JavaScript_Support: diag(6247, ts2.DiagnosticCategory.Message, "JavaScript_Support_6247", "JavaScript Support"),
      Type_Checking: diag(6248, ts2.DiagnosticCategory.Message, "Type_Checking_6248", "Type Checking"),
      Editor_Support: diag(6249, ts2.DiagnosticCategory.Message, "Editor_Support_6249", "Editor Support"),
      Watch_and_Build_Modes: diag(6250, ts2.DiagnosticCategory.Message, "Watch_and_Build_Modes_6250", "Watch and Build Modes"),
      Compiler_Diagnostics: diag(6251, ts2.DiagnosticCategory.Message, "Compile