package io.springboot.plugin.goview.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author lengleng
 * @date 2022/5/2
 * <p>
 * 数据大屏配置
 */
@Data
@ConfigurationProperties("gv")
public class GoviewProperties {

    /**
     * 服务 http://IP:port
     */
    private String host = "";

    /**
     * 路由前缀
     */
    private String gatewayPrefix = "/api/gv";

    /**
     * 图片存放路径
     */
    private String imgPath;

    /**
     * 项目 license
     */
    private String license;

    /**
     * 是否开启检查更新
     */
    private boolean checkUpdate = true;

}
