package io.springboot.plugin.goview;

import io.springboot.plugin.goview.config.GoviewProperties;
import io.springboot.plugin.goview.config.MybatisAutoConfiguration;
import io.springboot.plugin.goview.config.YamlPropertySourceFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;

/**
 * 数据可视化核心配置
 *
 * @author lengleng
 * @date 2021/7/20
 */
@Slf4j
@RequiredArgsConstructor
@Configuration(proxyBeanMethods = false)
@Import(MybatisAutoConfiguration.class)
@EnableConfigurationProperties(GoviewProperties.class)
@ComponentScan("io.springboot.plugin.goview.controller")
@PropertySource(value = "classpath:goview-config.yml", factory = YamlPropertySourceFactory.class)
public class DatavAutoConfiguration {

}
